/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator.parser;

import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.ModifiableElement;
import com.ochafik.lang.jnaerator.parser.Modifier;
import com.ochafik.lang.jnaerator.parser.ModifierKind;
import com.ochafik.lang.jnaerator.parser.Visitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class TypeRef
extends ModifiableElement
implements Declarator.MutableByDeclarator {
    protected boolean markedAsResolved;

    public TypeRef setMarkedAsResolved(boolean markedAsResolved) {
        this.markedAsResolved = markedAsResolved;
        return this;
    }

    public boolean isMarkedAsResolved() {
        return this.markedAsResolved;
    }

    public TypeRef importDetails(Element from, boolean move) {
        return (TypeRef)super.importDetails(from, move);
    }

    public TypeRef addModifiers(Modifier ... mds) {
        return (TypeRef)super.addModifiers(mds);
    }

    public TypeRef clone() {
        return (TypeRef)super.clone();
    }

    public boolean acceptsModifier(Modifier modifier) {
        return modifier.isAnyOf(ModifierKind.NumericTypeQualifier, ModifierKind.TypeQualifier);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArrayRef
    extends TargettedTypeRef {
        final List<Expression> dimensions = new ArrayList<Expression>();

        public ArrayRef(TypeRef target, Expression ... dimensions) {
            this(target, Arrays.asList(dimensions));
        }

        public ArrayRef(TypeRef target, List<Expression> dimensions) {
            this();
            this.setDimensions(dimensions);
            this.setTarget(target);
        }

        public void flattenDimensions(List<Expression> out) {
            out.addAll(this.dimensions);
        }

        public List<Expression> flattenDimensions() {
            ArrayList<Expression> dims = new ArrayList<Expression>();
            if (this.getTarget() instanceof ArrayRef) {
                ((ArrayRef)this.getTarget()).flattenDimensions(dims);
            }
            this.flattenDimensions(dims);
            return dims;
        }

        public boolean hasStaticStorageSize() {
            if (this.dimensions.isEmpty()) {
                return false;
            }
            Expression x = this.dimensions.get(this.dimensions.size() - 1);
            return x != null && !(x instanceof Expression.EmptyArraySize);
        }

        public ArrayRef() {
        }

        @Override
        public Element getNextChild(Element child) {
            Element e = ArrayRef.getNextSibling(this.dimensions, child);
            if (e != null) {
                return e;
            }
            return super.getNextChild(child);
        }

        @Override
        public Element getPreviousChild(Element child) {
            Element e = ArrayRef.getPreviousSibling(this.dimensions, child);
            if (e != null) {
                return e;
            }
            return super.getPreviousChild(child);
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            if (ArrayRef.replaceChild(this.dimensions, Expression.class, (Element)this, child, by)) {
                return true;
            }
            return super.replaceChild(child, by);
        }

        public List<Expression> getDimensions() {
            return this.unmodifiableList(this.dimensions);
        }

        public void setDimensions(List<Expression> dimensions) {
            ArrayRef.changeValue((Element)this, this.dimensions, dimensions);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitArray(this);
        }

        public void addDimension(Expression x) {
            if (x == null) {
                return;
            }
            x.setParentElement(this);
            this.dimensions.add(x);
        }
    }

    public static class PrecisionTypeRef
    extends TargettedTypeRef {
        Expression precision;

        public PrecisionTypeRef() {
        }

        public PrecisionTypeRef(TypeRef target, Expression precision) {
            this.setTarget(target);
            this.setPrecision(precision);
        }

        public Expression getPrecision() {
            return this.precision;
        }

        public void setPrecision(Expression precision) {
            this.precision = PrecisionTypeRef.changeValue((Element)this, this.precision, precision);
        }

        public boolean replaceChild(Element child, Element by) {
            if (child == this.getPrecision()) {
                this.setPrecision((Expression)by);
                return true;
            }
            return super.replaceChild(child, by);
        }

        public void accept(Visitor visitor) {
            visitor.visitPrecisionTypeRef(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class TargettedTypeRef
    extends TypeRef {
        protected TypeRef target;

        public TypeRef getTarget() {
            return this.target;
        }

        public void setTarget(TypeRef target) {
            this.target = TargettedTypeRef.changeValue((Element)this, this.target, target);
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            if (this.getTarget() == child) {
                this.setTarget((TypeRef)by);
                return true;
            }
            return super.replaceChild(child, by);
        }

        @Override
        public List<Modifier> harvestModifiers() {
            List<Modifier> mods = super.harvestModifiers();
            if (this.getTarget() != null) {
                mods.addAll(this.getTarget().harvestModifiers());
            }
            return mods;
        }
    }

    public static class Pointer
    extends TargettedTypeRef {
        Declarator.PointerStyle pointerStyle;

        public Pointer(TypeRef target, Declarator.PointerStyle pointerStyle) {
            this();
            this.setTarget(target);
            this.setPointerStyle(pointerStyle);
        }

        public Pointer() {
        }

        public void setPointerStyle(Declarator.PointerStyle pointerStyle) {
            this.pointerStyle = pointerStyle;
        }

        public Declarator.PointerStyle getPointerStyle() {
            return this.pointerStyle;
        }

        public void accept(Visitor visitor) {
            visitor.visitPointer(this);
        }
    }

    public static class Primitive
    extends SimpleTypeRef {
        static Set<String> cPrimitiveTypes = new HashSet<String>();

        public static boolean isACPrimitive(String s) {
            return cPrimitiveTypes.contains(s);
        }

        public Primitive(String name) {
            this.setName(name == null ? null : new Identifier.SimpleIdentifier(name, new Expression[0]));
        }

        public Primitive() {
        }

        public Primitive addModifiers(Modifier ... mds) {
            return (Primitive)super.addModifiers(mds);
        }

        public void accept(Visitor visitor) {
            visitor.visitPrimitive(this);
        }

        static {
            cPrimitiveTypes.add("long");
            cPrimitiveTypes.add("int");
            cPrimitiveTypes.add("short");
            cPrimitiveTypes.add("bool");
            cPrimitiveTypes.add("char");
            cPrimitiveTypes.add("void");
            cPrimitiveTypes.add("double");
            cPrimitiveTypes.add("float");
            cPrimitiveTypes.add("size_t");
            cPrimitiveTypes.add("__int8");
            cPrimitiveTypes.add("__int16");
            cPrimitiveTypes.add("__int32");
            cPrimitiveTypes.add("__int64");
            cPrimitiveTypes.add("__uint8");
            cPrimitiveTypes.add("__uint16");
            cPrimitiveTypes.add("__uint32");
            cPrimitiveTypes.add("__uint64");
        }
    }

    public static class FunctionSignature
    extends TypeRef {
        protected Type type = Type.CFunction;
        protected Function function;

        public void setType(Type type) {
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }

        public FunctionSignature(Function function) {
            this();
            this.setFunction(function);
        }

        public FunctionSignature clone() {
            return (FunctionSignature)super.clone();
        }

        public FunctionSignature() {
        }

        public Function getFunction() {
            return this.function;
        }

        public void setFunction(Function function) {
            this.function = FunctionSignature.changeValue((Element)this, this.function, function);
        }

        public void accept(Visitor visitor) {
            visitor.visitFunctionSignature(this);
        }

        public boolean replaceChild(Element child, Element by) {
            if (this.getFunction() == child) {
                this.setFunction((Function)by);
                return true;
            }
            return super.replaceChild(child, by);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            CFunction,
            ObjCBlock;

        }
    }

    public static class SimpleTypeRef
    extends TypeRef {
        protected Identifier name;

        public SimpleTypeRef(String name) {
            this();
            this.setName(new Identifier.SimpleIdentifier(name, new Expression[0]));
        }

        public SimpleTypeRef(Identifier name) {
            this();
            this.setName(name);
        }

        public SimpleTypeRef() {
        }

        public Identifier getName() {
            return this.name;
        }

        public void setName(Identifier name) {
            this.name = SimpleTypeRef.changeValue((Element)this, this.name, name);
        }

        public boolean replaceChild(Element child, Element by) {
            if (child == this.getName()) {
                this.setName((Identifier)by);
            }
            return super.replaceChild(child, by);
        }

        public void accept(Visitor visitor) {
            visitor.visitSimpleTypeRef(this);
        }
    }

    public static abstract class TaggedTypeRef
    extends TypeRef {
        Identifier tag;
        Identifier originalTag;
        Identifier parentNamespace;
        boolean forwardDeclaration = false;

        public Identifier getTag() {
            return this.tag;
        }

        public void setTag(Identifier tag) {
            this.tag = TaggedTypeRef.changeValue((Element)this, this.tag, tag);
            if (this.originalTag == null && tag != null) {
                this.setOriginalTag(tag.clone());
            }
        }

        public boolean replaceChild(Element child, Element by) {
            if (child == this.getTag()) {
                this.setTag((Identifier)by);
                return true;
            }
            if (child == this.getOriginalTag()) {
                this.setOriginalTag((Identifier)by);
                return true;
            }
            if (child == this.getParentNamespace()) {
                this.setParentNamespace((Identifier)by);
                return true;
            }
            return super.replaceChild(child, by);
        }

        public void setParentNamespace(Identifier parentNamespace) {
            this.parentNamespace = TaggedTypeRef.changeValue((Element)this, this.parentNamespace, parentNamespace);
        }

        public Identifier getParentNamespace() {
            return this.parentNamespace;
        }

        public void setOriginalTag(Identifier originalTag) {
            this.originalTag = TaggedTypeRef.changeValue((Element)this, this.originalTag, originalTag);
        }

        public Identifier getOriginalTag() {
            return this.originalTag;
        }

        public boolean isForwardDeclaration() {
            return this.forwardDeclaration;
        }

        public void setForwardDeclaration(boolean forwardDeclaration) {
            this.forwardDeclaration = forwardDeclaration;
        }

        public void accept(Visitor visitor) {
            visitor.visitTaggedTypeRef(this);
        }
    }
}

