/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator.parser;

import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.ModifiableElement;
import com.ochafik.lang.jnaerator.parser.VariablesDeclaration;
import com.ochafik.lang.jnaerator.parser.Visitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class Statement
extends ModifiableElement {
    public Statement clone() {
        return (Statement)super.clone();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Try
    extends Statement {
        Statement tryStatement;
        Statement finallyStatement;
        final List<Catch> catches = new ArrayList<Catch>();

        public Try() {
        }

        public Try(Statement tryStatement, Statement finallyStatement, Catch ... catches) {
            this.setTryStatement(tryStatement);
            this.setFinallyStatement(finallyStatement);
            this.setCatches(Arrays.asList(catches));
        }

        public void setTryStatement(Statement tryStatement) {
            this.tryStatement = Try.changeValue((Element)this, this.tryStatement, tryStatement);
        }

        public Statement getTryStatement() {
            return this.tryStatement;
        }

        public void setFinallyStatement(Statement finallyStatement) {
            this.finallyStatement = Try.changeValue((Element)this, this.finallyStatement, finallyStatement);
        }

        public Statement getFinallyStatement() {
            return this.finallyStatement;
        }

        public List<Catch> getCatches() {
            return Collections.unmodifiableList(this.catches);
        }

        public void setCatches(List<Catch> catches) {
            Try.changeValue((Element)this, this.catches, catches);
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            if (child == this.getTryStatement()) {
                this.setTryStatement((Statement)by);
                return true;
            }
            if (child == this.getFinallyStatement()) {
                this.setFinallyStatement((Statement)by);
                return true;
            }
            return Try.replaceChild(this.catches, Catch.class, (Element)this, child, by) || super.replaceChild(child, by);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitTry(this);
        }
    }

    public static class Catch
    extends Statement {
        VariablesDeclaration declaration;
        Statement body;

        public Catch() {
        }

        public Catch(VariablesDeclaration declaration, Statement body) {
            this.setDeclaration(declaration);
            this.setBody(body);
        }

        public VariablesDeclaration getDeclaration() {
            return this.declaration;
        }

        public void setDeclaration(VariablesDeclaration declaration) {
            this.declaration = Catch.changeValue((Element)this, this.declaration, declaration);
        }

        public Statement getBody() {
            return this.body;
        }

        public void setBody(Statement body) {
            this.body = Catch.changeValue((Element)this, this.body, body);
        }

        public boolean replaceChild(Element child, Element by) {
            if (child == this.getDeclaration()) {
                this.setDeclaration((VariablesDeclaration)by);
                return true;
            }
            if (child == this.getBody()) {
                this.setBody((Statement)by);
                return true;
            }
            return super.replaceChild(child, by);
        }

        public void accept(Visitor visitor) {
            visitor.visitCatch(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Block
    extends Statement {
        final List<Statement> statements = new ArrayList<Statement>();
        boolean compact;

        @Override
        public void accept(Visitor visitor) {
            visitor.visitBlock(this);
        }

        @Override
        public Block clone() {
            return (Block)super.clone();
        }

        public Block setCompact(boolean compact) {
            this.compact = compact;
            return this;
        }

        public boolean isCompact() {
            return this.compact;
        }

        public Block() {
        }

        public Block(Statement ... statements) {
            this.addStatements(statements);
        }

        public Block(List<Statement> statements) {
            this.setStatements(statements);
        }

        public void addStatement(Statement statement) {
            if (statement != null) {
                statement.setParentElement(this);
                this.statements.add(statement);
            }
        }

        public void setStatements(List<Statement> statements) {
            Block.changeValue((Element)this, this.statements, statements);
        }

        public void addStatements(Statement ... statements) {
            this.setStatements(Arrays.asList(statements));
        }

        public List<Statement> getStatements() {
            return this.unmodifiableList(this.statements);
        }

        @Override
        public Element getNextChild(Element child) {
            Element e = super.getNextChild(child);
            if (e != null) {
                return e;
            }
            return Block.getNextSibling(this.statements, child);
        }

        @Override
        public Element getPreviousChild(Element child) {
            Element e = super.getPreviousChild(child);
            if (e != null) {
                return e;
            }
            return Block.getPreviousSibling(this.statements, child);
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            return Block.replaceChild(this.statements, Statement.class, (Element)this, child, by) || super.replaceChild(child, by);
        }
    }

    public static class ExpressionStatement
    extends Statement {
        Expression expression;

        public ExpressionStatement() {
        }

        public ExpressionStatement(Expression expression) {
            this.setExpression(expression);
        }

        public Expression getExpression() {
            return this.expression;
        }

        public void setExpression(Expression expression) {
            this.expression = ExpressionStatement.changeValue((Element)this, this.expression, expression);
        }

        public void accept(Visitor visitor) {
            visitor.visitExpressionStatement(this);
        }

        public boolean replaceChild(Element child, Element by) {
            if (this.getExpression() == child) {
                this.setExpression((Expression)by);
                return true;
            }
            return super.replaceChild(child, by);
        }
    }

    public static class DoWhile
    extends While {
        public DoWhile() {
        }

        public DoWhile(Expression condition, Statement body) {
            super(condition, body);
        }

        public void accept(Visitor visitor) {
            visitor.visitDoWhile(this);
        }
    }

    public static class While
    extends Statement {
        Expression condition;
        Statement body;

        public While() {
        }

        public While(Expression condition, Statement body) {
            this.setCondition(condition);
            this.setBody(body);
        }

        public void setCondition(Expression condition) {
            this.condition = While.changeValue((Element)this, this.condition, condition);
        }

        public void setBody(Statement body) {
            this.body = While.changeValue((Element)this, this.body, body);
        }

        public Statement getBody() {
            return this.body;
        }

        public Expression getCondition() {
            return this.condition;
        }

        public void accept(Visitor visitor) {
            visitor.visitWhile(this);
        }

        public boolean replaceChild(Element child, Element by) {
            if (child == this.getCondition()) {
                this.setCondition((Expression)by);
                return true;
            }
            if (child == this.getBody()) {
                this.setBody((Statement)by);
                return true;
            }
            return super.replaceChild(child, by);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class For
    extends Statement {
        Expression condition;
        Statement body;
        final List<Statement> initStatements = new ArrayList<Statement>();
        final List<Statement> postStatements = new ArrayList<Statement>();

        public For() {
        }

        public For(List<Statement> initStatements, Expression condition, List<Statement> postStatements, Statement body) {
            this.setInitStatements(initStatements);
            this.setCondition(condition);
            this.setPostStatements(postStatements);
            this.setBody(body);
        }

        public void setPostStatements(List<Statement> postStatements) {
            For.changeValue((Element)this, this.postStatements, postStatements);
        }

        public List<Statement> getPostStatements() {
            return this.unmodifiableList(this.postStatements);
        }

        public void setInitStatements(List<Statement> initStatements) {
            For.changeValue((Element)this, this.initStatements, initStatements);
        }

        public List<Statement> getInitStatements() {
            return this.unmodifiableList(this.initStatements);
        }

        public void setCondition(Expression condition) {
            this.condition = For.changeValue((Element)this, this.condition, condition);
        }

        public void setBody(Statement body) {
            this.body = For.changeValue((Element)this, this.body, body);
        }

        public Statement getBody() {
            return this.body;
        }

        public Expression getCondition() {
            return this.condition;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitFor(this);
        }

        @Override
        public Element getNextChild(Element child) {
            Element e = super.getNextChild(child);
            if (e != null) {
                return e;
            }
            e = For.getNextSibling(this.initStatements, child);
            if (e != null) {
                return e;
            }
            return For.getNextSibling(this.postStatements, child);
        }

        @Override
        public Element getPreviousChild(Element child) {
            Element e = super.getPreviousChild(child);
            if (e != null) {
                return e;
            }
            e = For.getPreviousSibling(this.initStatements, child);
            if (e != null) {
                return e;
            }
            return For.getPreviousSibling(this.postStatements, child);
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            if (child == this.getCondition()) {
                this.setCondition((Expression)by);
                return true;
            }
            if (child == this.getBody()) {
                this.setBody((Statement)by);
                return true;
            }
            return For.replaceChild(this.initStatements, Statement.class, (Element)this, child, by) || For.replaceChild(this.postStatements, Statement.class, (Element)this, child, by) || super.replaceChild(child, by);
        }
    }

    public static class If
    extends Statement {
        Expression condition;
        Statement thenBranch;
        Statement elseBranch;

        public If() {
        }

        public If(Expression condition, Statement thenBranch) {
            this(condition, thenBranch, null);
        }

        public If(Expression condition, Statement thenBranch, Statement elseBranch) {
            this.setCondition(condition);
            this.setThenBranch(thenBranch);
            this.setElseBranch(elseBranch);
        }

        public void setElseBranch(Statement elseBranch) {
            this.elseBranch = If.changeValue((Element)this, this.elseBranch, elseBranch);
        }

        public void setCondition(Expression condition) {
            this.condition = If.changeValue((Element)this, this.condition, condition);
        }

        public void setThenBranch(Statement thenBranch) {
            this.thenBranch = If.changeValue((Element)this, this.thenBranch, thenBranch);
        }

        public Statement getElseBranch() {
            return this.elseBranch;
        }

        public Statement getThenBranch() {
            return this.thenBranch;
        }

        public Expression getCondition() {
            return this.condition;
        }

        public void accept(Visitor visitor) {
            visitor.visitIf(this);
        }

        public boolean replaceChild(Element child, Element by) {
            if (child == this.getCondition()) {
                this.setCondition((Expression)by);
                return true;
            }
            if (child == this.getThenBranch()) {
                this.setThenBranch((Statement)by);
                return true;
            }
            if (child == this.getElseBranch()) {
                this.setElseBranch((Statement)by);
                return true;
            }
            return super.replaceChild(child, by);
        }
    }

    public static class Delete
    extends SingleValueStatement {
        boolean array;

        public Delete() {
        }

        public Delete(Expression value, boolean isArray) {
            super(value);
            this.setArray(isArray);
        }

        public boolean isArray() {
            return this.array;
        }

        public void setArray(boolean isArray) {
            this.array = isArray;
        }

        public void accept(Visitor visitor) {
            visitor.visitDelete(this);
        }
    }

    public static class Return
    extends SingleValueStatement {
        public Return() {
        }

        public Return(Expression value) {
            super(value);
        }

        public void accept(Visitor visitor) {
            visitor.visitReturn(this);
        }
    }

    public static abstract class SingleValueStatement
    extends Statement {
        Expression value;

        public SingleValueStatement() {
        }

        public SingleValueStatement(Expression value) {
            this.setValue(value);
        }

        public void setValue(Expression value) {
            this.value = SingleValueStatement.changeValue((Element)this, this.value, value);
        }

        public Expression getValue() {
            return this.value;
        }

        public Element getNextChild(Element child) {
            Element e = super.getNextChild(child);
            if (e != null) {
                return e;
            }
            return null;
        }

        public Element getPreviousChild(Element child) {
            Element e = super.getPreviousChild(child);
            if (e != null) {
                return e;
            }
            return null;
        }

        public boolean replaceChild(Element child, Element by) {
            if (child == this.getValue()) {
                this.setValue((Expression)by);
                return true;
            }
            return super.replaceChild(child, by);
        }
    }

    public static class Throw
    extends Statement {
        Expression expression;

        public Expression getExpression() {
            return this.expression;
        }

        public void setExpression(Expression expression) {
            this.expression = Throw.changeValue((Element)this, this.expression, expression);
        }

        public Throw() {
        }

        public Throw(Expression expression) {
            this.setExpression(expression);
        }

        public void accept(Visitor visitor) {
            visitor.visitThrow(this);
        }

        public boolean replaceChild(Element child, Element by) {
            if (child == this.getExpression()) {
                this.setExpression((Expression)by);
                return true;
            }
            return super.replaceChild(child, by);
        }
    }
}

