/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator.parser;

import com.nativelibs4java.jalico.Adapter;
import com.nativelibs4java.jalico.ListenableCollections;
import com.nativelibs4java.jalico.Pair;
import com.ochafik.lang.jnaerator.parser.Annotation;
import com.ochafik.lang.jnaerator.parser.Arg;
import com.ochafik.lang.jnaerator.parser.Declarations;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Define;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.EmptyDeclaration;
import com.ochafik.lang.jnaerator.parser.Enum;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.ExternDeclarations;
import com.ochafik.lang.jnaerator.parser.FriendDeclaration;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.FunctionPointerDeclaration;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.Include;
import com.ochafik.lang.jnaerator.parser.ModifiableElement;
import com.ochafik.lang.jnaerator.parser.Modifier;
import com.ochafik.lang.jnaerator.parser.ModifierType;
import com.ochafik.lang.jnaerator.parser.Namespace;
import com.ochafik.lang.jnaerator.parser.Property;
import com.ochafik.lang.jnaerator.parser.Scanner;
import com.ochafik.lang.jnaerator.parser.SourceFile;
import com.ochafik.lang.jnaerator.parser.Statement;
import com.ochafik.lang.jnaerator.parser.StatementDeclaration;
import com.ochafik.lang.jnaerator.parser.StoredDeclarations;
import com.ochafik.lang.jnaerator.parser.Struct;
import com.ochafik.lang.jnaerator.parser.TaggedTypeRefDeclaration;
import com.ochafik.lang.jnaerator.parser.Template;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.VariablesDeclaration;
import com.ochafik.lang.jnaerator.parser.Visitor;
import com.ochafik.util.string.StringUtils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Printer
implements Visitor {
    StringBuilder out = new StringBuilder();
    int currentLine = 0;
    Stack<String> indentStack = new Stack();
    volatile String indent = "";
    protected static boolean beginEachCommentLineWithStar = true;

    protected void indent(String indent) {
        this.indent = indent;
        this.indentStack.push(this.indent);
    }

    protected void indent() {
        this.indent(this.indent + "\t");
    }

    protected void deindent() {
        this.indentStack.pop();
        this.indent = this.indentStack.isEmpty() ? "" : (String)this.indentStack.lastElement();
    }

    public Printer() {
    }

    public Printer(String initialIdent) {
        this.indent = initialIdent == null ? "" : initialIdent;
    }

    public String toString() {
        return this.out.toString();
    }

    protected void expressionPre(Expression x) {
        this.append(x.getParenthesis() ? "(" : "");
    }

    protected void expressionPost(Expression x) {
        this.append(x.getParenthesis() ? ")" : "");
    }

    @Override
    public void visitConstant(Expression.Constant e) {
        this.expressionPre(e);
        String txt = e.getOriginalTextualRepresentation();
        if (txt != null) {
            this.append(txt);
        } else {
            Object value = e.getValue();
            if (e.getIntForm() == Expression.Constant.IntForm.Hex) {
                this.append("0x", Long.toHexString(value instanceof Long ? ((Long)value).longValue() : ((Integer)value).longValue()).toUpperCase());
            } else if (e.getIntForm() == Expression.Constant.IntForm.Octal) {
                this.append(Long.toOctalString(value instanceof Long ? ((Long)value).longValue() : ((Integer)value).longValue()).toUpperCase());
            } else if (e.getType() == null) {
                this.append("");
            } else {
                switch (e.getType()) {
                    case Null: {
                        this.append("null");
                        break;
                    }
                    case Byte: 
                    case Double: 
                    case Int: 
                    case Short: 
                    case UInt: {
                        this.append(value);
                        break;
                    }
                    case Float: {
                        this.append(value, Character.valueOf('F'));
                        break;
                    }
                    case ULong: 
                    case Long: {
                        this.append(value, Character.valueOf('L'));
                        break;
                    }
                    case String: {
                        this.append(Character.valueOf('\"'), StringUtils.javaEscape((String)((String)value)), Character.valueOf('\"'));
                        break;
                    }
                    case Char: {
                        this.append(Character.valueOf('\''), StringUtils.javaEscape((String)((Character)value).toString()), Character.valueOf('\''));
                        break;
                    }
                    case IntegerString: {
                        int intVal = (Integer)value;
                        this.append(Character.valueOf('\''), Expression.Constant.intStr(intVal), Character.valueOf('\''));
                        break;
                    }
                    case LongString: {
                        long longVal = ((Long)value).intValue();
                        this.append(Character.valueOf('\''), Expression.Constant.intStr((int)(longVal & 0xFFFFFFFFL)), Expression.Constant.intStr((int)(longVal >>> 32 & 0xFFFFFFFFL)), Character.valueOf('\''));
                        break;
                    }
                    case Bool: {
                        this.append(((Boolean)value).toString());
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("visitConstant not implemented for constqnt type " + (Object)((Object)e.getType()));
                    }
                }
            }
        }
        this.expressionPost(e);
    }

    @Override
    public void visitArg(Arg e) {
        this.implode(e.getAnnotations(), "\n");
        if (e.getValueType() != null) {
            if (e.getName() != null) {
                this.variableDeclarationToString(e.getValueType(), e.getName(), e.isVarArg());
                if (e.getDefaultValue() != null) {
                    this.append(" = ").append(e.getDefaultValue());
                }
            } else {
                this.append(e.getValueType()).append(e.isVarArg() ? "..." : null);
            }
        } else {
            this.append("...");
        }
    }

    @Override
    public void visitEnum(Enum e) {
        this.formatComments(e, false, true, true, new String[0]);
        this.modifiersStringPrefix(e);
        if (!e.getAnnotations().isEmpty()) {
            this.implode(e.getAnnotations(), "\n" + this.indent).append("\n", this.indent);
        }
        this.append("enum ", e.getTag());
        if (e.getTag() != null) {
            this.append(" ");
        }
        if (!e.getInterfaces().isEmpty()) {
            this.append("implements ").implode(e.getInterfaces(), ", ").append(" ");
        }
        this.append("{\n");
        this.indent();
        List<Enum.EnumItem> items = e.getItems();
        int len = items.size();
        for (int i = 0; i < len; ++i) {
            Enum.EnumItem item = items.get(i);
            this.append(this.indent, item, i < len - 1 ? "," : (e.getBody() == null ? "" : ";"), "\n");
        }
        if (e.getBody() != null) {
            this.append(this.indent);
            this.implode(e.getBody().getDeclarations(), "\n" + this.indent);
            this.append("\n");
        }
        this.deindent();
        this.append(this.indent, "}");
    }

    @Override
    public void visitFunction(Function e) {
        TypeRef valueType = e.getValueType();
        Identifier name = e.getName();
        List<Modifier> modifiers = e.getModifiers();
        if (e.getType() == null) {
            this.append("<no function type>");
            return;
        }
        this.formatComments(e, false, true, true, new String[0]);
        if (!e.getAnnotations().isEmpty()) {
            this.implode(e.getAnnotations(), "\n" + this.indent).append("\n", this.indent);
        }
        switch (e.getType()) {
            case StaticInit: {
                this.implode(modifiers, " ");
                this.space(!modifiers.isEmpty());
                this.append(e.getBody() == null ? ";" : e.getBody());
                break;
            }
            case JavaMethod: 
            case CFunction: 
            case CppMethod: {
                if (name != null && name.equals("operator") && e.getType() == Function.Type.CppMethod) {
                    this.append(name);
                    this.space();
                    this.implode(modifiers, " ");
                    this.space(!modifiers.isEmpty());
                    this.append(valueType);
                } else {
                    this.implode(modifiers, " ");
                    this.space(!modifiers.isEmpty());
                    this.append(valueType);
                    this.space(valueType != null);
                    this.append(name);
                }
                this.append("(").implode(e.getArgs(), ", ").append(")");
                switch (e.getType()) {
                    case JavaMethod: {
                        if (e.getThrown().isEmpty()) break;
                        this.append(" throws ").implode(e.getThrown(), ", ");
                        break;
                    }
                    default: {
                        if (!e.getThrows()) break;
                        this.append(" throw(");
                        this.implode(e.getThrown(), ", ");
                        this.append(")");
                    }
                }
                if (!e.getInitializers().isEmpty()) {
                    this.append(" : ").implode(e.getInitializers(), ", ");
                }
                if (e.getBody() == null) {
                    this.append(";");
                    break;
                }
                this.append(" ", e.getBody());
                break;
            }
            case ObjCMethod: {
                this.append(modifiers.contains(ModifierType.Static) ? "+" : "-");
                this.space();
                if (valueType != null) {
                    this.append("(", valueType, ")");
                }
                this.append(name);
                boolean firstArg = true;
                for (Arg arg : e.getArgs()) {
                    if (arg.isVarArg()) {
                        if (!firstArg) {
                            this.append(", ");
                        }
                        this.append("...");
                    } else {
                        if (!firstArg) {
                            this.append(Character.valueOf(' '), arg.getSelector());
                        }
                        this.append(":(", arg.createMutatedType(), Character.valueOf(')'), arg.getName());
                    }
                    firstArg = false;
                }
                this.append(";");
                break;
            }
            default: {
                throw new RuntimeException(e.getType().toString());
            }
        }
        if (e.getAsmName() != null) {
            this.append("__asm(\"", e.getAsmName(), "\") ");
        }
        if (e.getCommentAfter() != null) {
            this.append(" ", e.getCommentAfter());
        }
    }

    @Override
    public void visitFunctionPointerDeclaration(FunctionPointerDeclaration e) {
        this.modifiersStringPrefix(e);
        this.append(e.getValueType());
        if (e.getDefaultValue() != null) {
            this.append(" = ", e.getDefaultValue());
        }
        this.append(";");
    }

    @Override
    public void visitStruct(Struct e) {
        this.formatComments(e, false, true, true, new String[0]);
        if (!e.getAnnotations().isEmpty()) {
            this.implode(e.getAnnotations(), "\n" + this.indent).append("\n", this.indent);
        }
        if (e.getType() != null) {
            switch (e.getType()) {
                case CPPClass: {
                    this.modifiersStringPrefix(e);
                    this.append("class ", e.getTag());
                    if (e.getParents().isEmpty()) break;
                    this.append(" : ").implode(e.getParents(), ", ");
                    break;
                }
                case CUnion: {
                    this.modifiersStringPrefix(e);
                    this.append("union ", e.getTag() == null ? null : " ", e.getTag());
                    break;
                }
                case JavaClass: 
                case JavaInterface: {
                    this.modifiersStringPrefix(e);
                    this.append(e.getType() == Struct.Type.JavaClass ? "class " : "interface ", e.getTag());
                    if (!e.getParents().isEmpty()) {
                        this.append(" extends ").implode(e.getParents(), ", ");
                    }
                    if (e.getProtocols().isEmpty()) break;
                    this.append(" implements ").implode(e.getProtocols(), ", ");
                    break;
                }
                case ObjCClass: {
                    this.modifiersStringPrefix(e);
                    this.append(e.isForwardDeclaration() ? "@class " : "@interface ", e.getTag());
                    if (e.getCategoryName() == null) break;
                    this.append(" (", e.getCategoryName(), ")");
                    break;
                }
                case ObjCProtocol: {
                    this.modifiersStringPrefix(e);
                    this.append("@protocol ", e.getTag());
                    break;
                }
                default: {
                    this.append("struct ");
                    this.modifiersStringPrefix(e);
                    this.append(e.getTag());
                    if (e.getParents().isEmpty()) break;
                    this.append(" : ").implode(e.getParents(), ", ");
                }
            }
        }
        if (!e.isForwardDeclaration()) {
            this.space(e.getTag() != null).append("{\n");
            this.indent();
            this.append(this.indent);
            this.implode(e.getDeclarations(), "\n" + this.indent);
            this.deindent();
            this.append("\n", this.indent, "}");
        }
    }

    @Override
    public void visitTypeDef(StoredDeclarations.TypeDef e) {
        this.formatComments(e, false, true, true, new String[0]);
        this.modifiersStringPrefix(e);
        this.append("typedef ");
        this.valueTypeAndStorageSuffix(e);
        this.append(";");
        if (e.getCommentAfter() != null) {
            this.append(" ", e.getCommentAfter().trim());
        }
    }

    @Override
    public void visitSimpleTypeRef(TypeRef.SimpleTypeRef e) {
        this.formatComments(e, true, false, false, new String[0]).modifiersStringPrefix(e).append(e.getName());
    }

    @Override
    public void visitFunctionSignature(TypeRef.FunctionSignature e) {
        if (e.getFunction() == null) {
            return;
        }
        assert (e.getFunction().getBody() == null);
        this.modifiersStringPrefix(e);
        this.append(e.getFunction().getValueType()).space(e.getFunction().getValueType() != null);
        if (e.getParentElement() instanceof TypeRef.Pointer) {
            this.append("(");
            this.modifiersStringPrefix(e.getFunction());
            switch (e.getType()) {
                case CFunction: {
                    this.append("*");
                    break;
                }
                case ObjCBlock: {
                    this.append("^");
                }
            }
            this.append(e.getFunction().getName());
            this.append(")");
        } else {
            this.append(e.getFunction().getName());
        }
        this.append("(");
        this.implode(e.getFunction().getArgs(), ", ");
        this.append(")");
        this.append(e.getModifiers().isEmpty() ? "" : " ");
        this.implode(e.getModifiers(), " ");
    }

    @Override
    public void visitPrimitive(TypeRef.Primitive e) {
        this.modifiersStringPrefix(e, e.getName() != null);
        this.append(e.getName());
    }

    @Override
    public void visitPointer(TypeRef.Pointer e) {
        this.modifiersStringPrefix(e);
        this.append(e.getTarget());
        if (!(e.getTarget() instanceof TypeRef.FunctionSignature)) {
            this.append(new Object[]{e.getPointerStyle()});
        }
    }

    @Override
    public void visitArray(TypeRef.ArrayRef e) {
        this.modifiersStringPrefix(e);
        this.append(e.getTarget());
        this.bracketsToString(e);
    }

    @Override
    public void visitSourceFile(SourceFile e) {
        this.implode(e.getDeclarations(), "\n" + this.indent);
    }

    @Override
    public void visitEnumItem(Enum.EnumItem e) {
        this.formatComments(e, false, true, true, new String[0]);
        this.append(e.getName());
        if (!e.getArguments().isEmpty()) {
            if (e.getType() == Enum.Type.C) {
                this.append(" = ", e.getArguments().get(0));
            } else {
                this.append("(");
                this.implode(e.getArguments(), ", ");
                this.append(")");
            }
        }
        if (e.getBody() != null) {
            this.append(" {\n\t", this.indent);
            this.indent();
            this.implode(e.getBody().getDeclarations(), "\n" + this.indent);
            this.deindent();
            this.append("\n", this.indent, "}");
        }
        this.space(e.getCommentAfter() != null).append(e.getCommentAfter());
    }

    @Override
    public void visitUnaryOp(Expression.UnaryOp e) {
        this.expressionPre(e);
        this.append(Expression.UnaryOp.unOpsRev.get(e.getOperator())).append(e.getOperand());
        this.expressionPost(e);
    }

    @Override
    public void visitVariableRef(Expression.VariableRef e) {
        this.expressionPre(e);
        this.append(e.getName());
        this.expressionPost(e);
    }

    @Override
    public void visitBinaryOp(Expression.BinaryOp e) {
        this.expressionPre(e);
        this.append(e.getFirstOperand()).space().append(Expression.BinaryOp.binOpsRev.get(e.getOperator())).space().append(e.getSecondOperand());
        this.expressionPost(e);
    }

    protected Printer targetPrefix(Expression.MemberRef e) {
        String sep;
        if (e.getTarget() == null || e.getMemberRefStyle() == null) {
            return this;
        }
        switch (e.getMemberRefStyle()) {
            case Arrow: {
                sep = "->";
                break;
            }
            case Dot: {
                sep = ".";
                break;
            }
            case Colons: {
                sep = "::";
                break;
            }
            default: {
                assert (false);
                sep = null;
            }
        }
        if (sep != null) {
            this.append(e.getTarget());
            this.append(sep);
        }
        return this;
    }

    @Override
    public void visitFunctionCall(Expression.FunctionCall e) {
        this.expressionPre(e);
        if (e.getMemberRefStyle() == Expression.MemberRefStyle.SquareBrackets) {
            this.append(Character.valueOf('['));
            this.append(e.getTarget());
            if (e.getFunction() != null) {
                this.append(Character.valueOf(' '));
                this.append(e.getFunction());
            }
            List<Pair<String, Expression>> args = e.getArguments();
            int len = args.size();
            for (int i = 0; i < len; ++i) {
                Pair<String, Expression> arg = args.get(i);
                if (i > 0) {
                    this.append(Character.valueOf(' '));
                    this.append(arg.getFirst());
                }
                this.append(Character.valueOf(':'));
                this.append(arg.getSecond());
            }
            this.append(Character.valueOf(']'));
        } else {
            this.targetPrefix(e);
            if (e.getFunction() != null) {
                this.append(e.getFunction());
            }
            this.append("(");
            this.implode(ListenableCollections.adapt(e.getArguments(), (Adapter)new Adapter<Pair<String, Expression>, Expression>(){

                public Expression adapt(Pair<String, Expression> value) {
                    return (Expression)value.getValue();
                }
            }), ", ");
            this.append(")");
        }
        this.expressionPost(e);
    }

    @Override
    public void visitCast(Expression.Cast e) {
        this.expressionPre(e);
        this.append("(").append(e.getType()).append(")");
        this.append(e.getTarget());
        this.expressionPost(e);
    }

    @Override
    public void visitDeclarator(Declarator e) {
        if (e.isParenthesized()) {
            this.append(Character.valueOf('('));
        }
        this.implode(e.getModifiers(), " ").space(!e.getModifiers().isEmpty());
        if (e instanceof Declarator.DirectDeclarator) {
            this.append(((Declarator.DirectDeclarator)e).getName());
        } else if (e instanceof Declarator.PointerDeclarator) {
            Declarator.PointerDeclarator d = (Declarator.PointerDeclarator)e;
            this.append(new Object[]{d.getPointerStyle(), d.getTarget()});
        } else if (e instanceof Declarator.FunctionDeclarator) {
            Declarator.FunctionDeclarator d = (Declarator.FunctionDeclarator)e;
            this.append(d.getTarget(), Character.valueOf('(')).implode(d.getArgs(), ", ").append(")");
        } else if (e instanceof Declarator.ArrayDeclarator) {
            Declarator.ArrayDeclarator d = (Declarator.ArrayDeclarator)e;
            this.append(d.getTarget(), Character.valueOf('[')).implode(d.getDimensions(), "][").append("]");
        }
        if (e.isParenthesized()) {
            this.append(Character.valueOf(')'));
        }
        if (e.getBits() >= 0) {
            this.append(":", e.getBits());
        }
        if (e.getDefaultValue() != null) {
            this.append(" = ", e.getDefaultValue());
        }
    }

    @Override
    public void visitVariablesDeclaration(VariablesDeclaration e) {
        this.formatComments(e, false, true, true, new String[0]);
        if (!e.getAnnotations().isEmpty()) {
            this.implode(e.getAnnotations(), "\n" + this.indent).append("\n", this.indent);
        }
        this.modifiersStringPrefix(e);
        this.valueTypeAndStorageSuffix(e);
        if (!(e.getParentElement() instanceof Statement.Catch)) {
            this.append(";");
        }
        if (e.getCommentAfter() != null) {
            this.space().append(e.getCommentAfter());
        }
    }

    @Override
    public void visitTaggedTypeRefDeclaration(TaggedTypeRefDeclaration e) {
        if (e.getTaggedTypeRef() == null) {
            return;
        }
        TypeRef.TaggedTypeRef tr = e.getTaggedTypeRef();
        this.formatComments(e, false, true, true, new String[0]);
        this.append(tr, ";", e.getCommentAfter());
    }

    @Override
    public void visitTaggedTypeRef(TypeRef.TaggedTypeRef e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visitEmptyArraySize(Expression.EmptyArraySize e) {
        this.expressionPre(e);
        this.expressionPost(e);
    }

    @Override
    public void visitDefine(Define e) {
        this.append(this.indent, "#define ", e.getName());
        this.space(e.getValue() != null).append(e.getValue());
    }

    @Override
    public void visitTypeRefExpression(Expression.TypeRefExpression e) {
        this.expressionPre(e);
        this.append(e.getType());
        this.expressionPost(e);
    }

    @Override
    public void visitNew(Expression.New e) {
        this.expressionPre(e);
        this.append("new ").append(e.getType());
        if (e.getConstruction() == null) {
            this.append("()");
        } else {
            this.append(e.getConstruction());
        }
        this.expressionPost(e);
    }

    @Override
    public void visitAnnotation(Annotation e) {
        boolean hasNamed;
        this.append("@", e.getAnnotationClass());
        boolean first = true;
        boolean hasDefault = e.getDefaultArgument() != null;
        boolean bl = hasNamed = !e.getNamedArguments().isEmpty();
        if (hasDefault || hasNamed) {
            this.append("(");
            if (hasDefault) {
                if (hasNamed) {
                    this.append("value = ");
                }
                this.append(e.getDefaultArgument());
                first = false;
            }
            for (Map.Entry<String, Expression> entry : e.getNamedArguments().entrySet()) {
                if (!first) {
                    this.append(", ");
                }
                this.append(entry.getKey(), " = ", entry.getValue());
                first = false;
            }
            this.append(")");
        }
        this.space();
    }

    @Override
    public void visitEmptyDeclaration(EmptyDeclaration e) {
        this.formatComments(e, true, true, false, new String[0]);
    }

    @Override
    public void visitNewArray(Expression.NewArray e) {
        this.expressionPre(e);
        boolean noDims = e.getDimensions().isEmpty();
        boolean noVals = e.getInitialValues().isEmpty();
        boolean isAnn = e.isAnnotationValue();
        if (!isAnn) {
            this.append("new ").append(e.getType()).append("[");
            if (noDims && noVals) {
                this.append("0");
            } else {
                this.implode(e.getDimensions(), "][");
            }
            this.append("]");
        }
        if (isAnn || noDims && !noVals) {
            this.append("{").implode(e.getInitialValues(), ", ").append("}");
        }
        this.expressionPost(e);
    }

    @Override
    public void visitPointerDeclarator(Declarator.PointerDeclarator e) {
        this.visitDeclarator(e);
    }

    @Override
    public void visitArrayDeclarator(Declarator.ArrayDeclarator e) {
        this.visitDeclarator(e);
    }

    @Override
    public void visitDirectDeclarator(Declarator.DirectDeclarator e) {
        this.visitDeclarator(e);
    }

    @Override
    public void visitFunctionDeclarator(Declarator.FunctionDeclarator e) {
        this.visitDeclarator(e);
    }

    @Override
    public void visitModifiableElement(ModifiableElement e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void visitBlock(Statement.Block e) {
        this.append("{");
        if (!e.getStatements().isEmpty()) {
            if (e.isCompact()) {
                this.append(Character.valueOf(' '));
                this.implode(e.getStatements(), ", ");
                this.append(Character.valueOf(' '));
            } else {
                this.indent();
                this.append("\n", this.indent);
                this.implode(e.getStatements(), "\n" + this.indent);
                this.deindent();
                this.append("\n", this.indent);
            }
        }
        this.append(Character.valueOf('}'));
    }

    @Override
    public void visitExpressionStatement(Statement.ExpressionStatement e) {
        this.append(e.getExpression(), ";");
    }

    @Override
    public void visitIf(Statement.If e) {
        this.append("if (", e.getCondition(), ") ");
        if (e.getThenBranch() == null) {
            this.append("<null>");
        } else if (e.getThenBranch() instanceof Statement.Block) {
            this.append(e.getThenBranch());
            if (e.getElseBranch() != null) {
                this.append(" ");
            }
        } else {
            this.indent();
            this.append("\n", this.indent, e.getThenBranch());
            this.deindent();
            if (e.getElseBranch() != null) {
                this.append("\n", this.indent);
            }
        }
        if (e.getElseBranch() != null) {
            this.append("else ");
            if (e.getElseBranch() instanceof Statement.Block) {
                this.append(e.getElseBranch());
            } else {
                this.indent();
                this.append("\n", this.indent, e.getElseBranch());
                this.deindent();
            }
        }
    }

    @Override
    public void visitNullExpression(Expression.NullExpression e) {
        this.expressionPre(e);
        this.append("null");
        this.expressionPost(e);
    }

    @Override
    public void visitReturn(Statement.Return e) {
        this.append("return ", e.getValue(), ";");
    }

    @Override
    public void visitExternDeclarations(ExternDeclarations e) {
        this.append("extern \"", e.getLanguage(), "\" {\n");
        this.indent();
        this.implode(e.getDeclarations(), "\n" + this.indent);
        this.deindent();
        this.append("\n", this.indent, "}");
    }

    @Override
    public void visitOpaqueExpression(Expression.OpaqueExpression e) {
        this.expressionPre(e);
        this.append(e.getOpaqueString());
        this.expressionPost(e);
    }

    @Override
    public void visitArrayAccess(Expression.ArrayAccess e) {
        this.expressionPre(e);
        this.append(e.getTarget());
        this.append("[");
        this.append(e.getIndex());
        this.append("]");
        this.expressionPost(e);
    }

    @Override
    public void visitMemberRef(Expression.MemberRef e) {
        this.expressionPre(e);
        this.targetPrefix(e);
        this.append(e.getName());
        this.expressionPost(e);
    }

    @Override
    public void visitAssignmentOp(Expression.AssignmentOp e) {
        this.expressionPre(e);
        this.append(e.getTarget()).space().append(Expression.AssignmentOp.assignOpsRev.get(e.getOperator())).space().append(e.getValue());
        this.expressionPost(e);
    }

    @Override
    public void visitConditionalExpression(Expression.ConditionalExpression e) {
        this.expressionPre(e);
        this.append(e.getTest()).append(" ? ").append(e.getThenValue()).append(" : ").append(e.getElseValue());
        this.expressionPost(e);
    }

    @Override
    public void visitExpressionSequence(Expression.ExpressionSequence e) {
        this.expressionPre(e);
        this.implode(e.getExpressions(), ", ");
        this.expressionPost(e);
    }

    @Override
    public void visitExpressionsBlock(Expression.ExpressionsBlock e) {
        this.expressionPre(e);
        this.append("{ ");
        this.implode(e.getExpressions(), ", ");
        this.append(" }");
        this.expressionPost(e);
    }

    @Override
    public void visitSimpleIdentifier(Identifier.SimpleIdentifier e) {
        this.append(e.getName());
        if (!e.getTemplateArguments().isEmpty()) {
            this.append("<");
            this.implode(e.getTemplateArguments(), ", ");
            this.append(" >");
        }
    }

    @Override
    public void visitQualifiedIdentifier(Identifier.QualifiedIdentifier e) {
        this.implode(e.getIdentifiers(), String.valueOf((Object)e.getSeparator()));
    }

    @Override
    public void visitThrow(Statement.Throw e) {
        this.append("throw ", e.getExpression(), ";");
    }

    @Override
    public void visitProperty(Property e) {
        this.append("@property");
        if (!e.getModifiers().isEmpty()) {
            this.append("(").implode(e.getModifiers(), ", ").append(")");
        }
        this.append(" ", e.getDeclaration());
    }

    @Override
    public void visitFriendDeclaration(FriendDeclaration e) {
        this.append("friend ", e.getFriend());
    }

    @Override
    public void visitTry(Statement.Try e) {
        this.append("try {\n");
        this.indent();
        this.append(this.indent, e.getTryStatement());
        this.deindent();
        this.append("\n", this.indent, "}");
        this.implode(e.getCatches(), " ");
        if (e.getFinallyStatement() != null) {
            this.append(" finally {\n");
            this.indent();
            this.append(this.indent);
            this.append(e.getFinallyStatement());
            this.deindent();
            this.append("\n", this.indent, "}");
        }
    }

    @Override
    public void visitCatch(Statement.Catch e) {
        this.append("catch (", e.getDeclaration(), ") {\n\t", this.indent);
        if (e.getBody() != null) {
            this.append(e.getBody());
        }
        this.append("\n", this.indent, "}");
    }

    protected Printer space() {
        return this.space(true);
    }

    protected Printer space(boolean doIt) {
        if (doIt) {
            this.append(" ");
        }
        return this;
    }

    public Printer append(Object ... os) {
        for (Object e : os) {
            if (e instanceof Element) {
                Element ee = (Element)e;
                ee.accept(this);
                ee.setElementLine(this.currentLine);
                continue;
            }
            if (e == null) continue;
            String s = String.valueOf(e);
            this.out.append(s);
            int i = -1;
            while ((i = s.indexOf("\n", i + 1)) >= 0) {
                ++this.currentLine;
            }
        }
        return this;
    }

    protected final Printer implode(Iterable<?> elements, Object separator) {
        if (elements != null) {
            String sepStr = separator.toString();
            boolean first = true;
            for (Object s : elements) {
                if (s == null) continue;
                if (first) {
                    first = false;
                } else {
                    this.append(sepStr);
                }
                this.append(s);
            }
        }
        return this;
    }

    public static String formatComments(CharSequence indent, String commentBefore, String commentAfter, boolean mergeCommentsAfter, boolean allowLineComments, boolean skipLineAfter, String ... otherComments) {
        String suffix;
        if (indent == null) {
            indent = "";
        }
        ArrayList<String> nakedComments = new ArrayList<String>();
        ArrayList<String> src = new ArrayList<String>();
        if (commentBefore != null) {
            src.add(commentBefore);
        }
        if (mergeCommentsAfter && commentAfter != null) {
            src.add(commentAfter);
        }
        src.addAll(Arrays.asList(otherComments));
        if (src.isEmpty()) {
            return null;
        }
        for (String c : src) {
            if (c == null) continue;
            c = Element.cleanComment(c).trim();
            nakedComments.add(c);
        }
        String uniqueLine = null;
        if (nakedComments.size() == 1 && !((String)nakedComments.get(0)).contains("\n")) {
            uniqueLine = (String)nakedComments.get(0);
        }
        String string = suffix = skipLineAfter ? "\n" + indent : "";
        if (uniqueLine != null && allowLineComments) {
            return "/** " + uniqueLine.replace("\\u", "\\\\u") + " */" + suffix;
        }
        String content = beginEachCommentLineWithStar ? " * " + StringUtils.implode(nakedComments, (Object)"\n").replaceAll("\n", "<br>\n" + indent + " * ") + "\n" + indent : "\t" + StringUtils.implode(nakedComments, (Object)"\n").replaceAll("\n", "<br>" + StringUtils.LINE_SEPARATOR + indent + "\t");
        return "/**" + StringUtils.LINE_SEPARATOR + indent + content.replace("\\u", "\\\\u") + " */" + suffix;
    }

    public Printer formatComments(Element e, boolean mergeCommentsAfter, boolean allowLineComments, boolean skipLineAfter, String ... otherComments) {
        String cb = e.getCommentBefore();
        String ca = e.getCommentAfter();
        if (cb != null || ca != null || otherComments.length > 0) {
            this.append(Printer.formatComments(this.indent, cb, ca, mergeCommentsAfter, allowLineComments, skipLineAfter, otherComments));
        }
        return this;
    }

    protected Printer modifiersStringPrefix(ModifiableElement e) {
        return this.modifiersStringPrefix(e, true);
    }

    protected Printer modifiersStringPrefix(ModifiableElement e, boolean addSpace) {
        List<Modifier> modifiers = e.getModifiers();
        if (modifiers != null && !modifiers.isEmpty()) {
            this.implode(modifiers, " ");
            if (addSpace) {
                this.space();
            }
        }
        return this;
    }

    protected void variableDeclarationToString(TypeRef e, String varName, boolean isVarArg) {
        if (e instanceof TypeRef.FunctionSignature) {
            TypeRef.FunctionSignature fs = (TypeRef.FunctionSignature)e;
            if (!isVarArg && fs.getFunction() != null && fs.getFunction().getName() != null) {
                this.append(this.indent);
                return;
            }
        } else if (e instanceof TypeRef.ArrayRef) {
            TypeRef.ArrayRef ar = (TypeRef.ArrayRef)e;
            this.append(ar.getTarget(), isVarArg ? "... " : " ", varName);
            this.bracketsToString(ar);
            return;
        }
        this.append(e).append(isVarArg ? "... " : " ").append(varName);
    }

    protected void bracketsToString(TypeRef.ArrayRef e) {
        this.append("[").implode(e.getDimensions(), "][").append("]");
    }

    protected void valueTypeAndStorageSuffix(StoredDeclarations e) {
        String stoName;
        Identifier name;
        TypeRef.FunctionSignature sig;
        if (e.getValueType() instanceof TypeRef.FunctionSignature && (sig = (TypeRef.FunctionSignature)e.getValueType()).getFunction() != null && (name = sig.getFunction().getName()) != null && e.declarators.size() == 1 && (name.equals(stoName = e.declarators.get(0).resolveName()) || stoName == null)) {
            this.append(sig);
            return;
        }
        this.append(e.getValueType()).space(!e.getDeclarators().isEmpty()).implode(e.getDeclarators(), ", ");
    }

    public static void printJava(Identifier packageName, Identifier className, Element rootElement, PrintWriter out) {
        final LinkedHashMap identifiersBySimpleName = new LinkedHashMap();
        String outputPackage = packageName.toString();
        String outputClassPrefix = className + ".";
        rootElement.accept(new Scanner(){

            public void visitIdentifier(Identifier e) {
                super.visitIdentifier(e);
                if (e.getParentElement() instanceof Identifier.QualifiedIdentifier) {
                    return;
                }
                Element parent = e.getParentElement();
                if (!(parent instanceof TypeRef)) {
                    return;
                }
                e = e.clone();
                Identifier.SimpleIdentifier si = e.resolveLastSimpleIdentifier();
                si.setTemplateArguments(Collections.EMPTY_LIST);
                String name = si.getName();
                HashSet<Identifier> ids = (HashSet<Identifier>)identifiersBySimpleName.get(name);
                if (ids == null) {
                    ids = new HashSet<Identifier>();
                    identifiersBySimpleName.put(name, ids);
                }
                ids.add(e);
            }
        });
        LinkedHashMap<Identifier, String> resolvedIds = new LinkedHashMap<Identifier, String>();
        final HashSet<String> importedClassesStrings = new HashSet<String>(50);
        importedClassesStrings.add(className.toString());
        String packagePrefix = packageName + ".";
        TreeSet<String> importStatements = new TreeSet<String>();
        for (Map.Entry kv : identifiersBySimpleName.entrySet()) {
            Identifier.SimpleIdentifier si;
            Identifier id;
            String ids;
            if (((Set)kv.getValue()).size() != 1 || (ids = (id = (Identifier)((Set)kv.getValue()).iterator().next()).toString()).indexOf(".") < 0 || (si = id.resolveLastSimpleIdentifier()).isJavaStaticImportable()) continue;
            String name = si.getName();
            resolvedIds.put(id, name);
            Identifier pack = id.resolveAllButLastIdentifier();
            if (pack == null) continue;
            String ps = pack.toString();
            importedClassesStrings.add(ids);
            if (ps.equals("java.lang") || ps.equals(outputPackage) || ids.startsWith(outputClassPrefix)) continue;
            importStatements.add("import " + ids + ";");
        }
        for (String imp : importStatements) {
            out.println(imp);
        }
        out.println(new Printer(){

            public void visitQualifiedIdentifier(Identifier.QualifiedIdentifier e) {
                if (e.getParentElement() instanceof TypeRef) {
                    Identifier.QualifiedIdentifier c = e.clone();
                    Identifier.SimpleIdentifier si = c.resolveLastSimpleIdentifier();
                    ArrayList<Expression> targs = new ArrayList<Expression>(si.getTemplateArguments());
                    si.setTemplateArguments(Collections.EMPTY_LIST);
                    ArrayList<Identifier.SimpleIdentifier> sis = new ArrayList<Identifier.SimpleIdentifier>(c.resolveSimpleIdentifiers());
                    Printer pt = new Printer();
                    int n = sis.size();
                    for (int i = 0; i < n; ++i) {
                        if (i != 0) {
                            pt.append(".");
                        }
                        pt.append(sis.get(i));
                        String str = pt.toString();
                        if (!importedClassesStrings.contains(str)) continue;
                        int j = i;
                        while (j-- != 0) {
                            sis.remove(j);
                        }
                        c.setIdentifiers(sis);
                        c.resolveLastSimpleIdentifier().setTemplateArguments(targs);
                        this.append(c);
                        return;
                    }
                }
                super.visitQualifiedIdentifier(e);
            }
        }.append(rootElement));
    }

    @Override
    public void visitTemplate(Template template) {
        this.append("template <").implode(template.getArgs(), ", ").append(" >\n");
        this.append(this.indent, template.getDeclaration());
    }

    @Override
    public void visitWhile(Statement.While whileStat) {
        this.append("while (").append(whileStat.getCondition()).append("{\n");
        this.indent();
        this.append(whileStat.getBody());
        this.deindent();
        this.append("\n", this.indent, "}");
    }

    @Override
    public void visitDoWhile(Statement.DoWhile doWhileStat) {
        this.append("do {\n");
        this.indent();
        this.append(doWhileStat.getBody());
        this.deindent();
        this.append("\n", this.indent, "} while (").append(doWhileStat.getCondition()).append(");");
    }

    @Override
    public void visitNamespace(Namespace ns) {
        this.append("namespace ").append(ns.getName()).append(" {\n");
        this.indent();
        this.implode(ns.getDeclarations(), "\n" + this.indent);
        this.deindent();
        this.append("\n", this.indent, "}");
    }

    @Override
    public void visitDeclarations(Declarations decls) {
        this.implode(decls.getDeclarations(), "\n" + this.indent);
    }

    @Override
    public void visitFor(Statement.For aFor) {
        this.append("for (").implode(aFor.getInitStatements(), ", ").append(";").append(aFor.getCondition()).append(";").implode(aFor.getPostStatements(), ", ").append(") {\n");
        this.indent();
        this.append(aFor.getBody());
        this.deindent();
        this.append("\n", this.indent, "}");
    }

    @Override
    public void visitPrecisionTypeRef(TypeRef.PrecisionTypeRef tr) {
        this.append(tr.getTarget());
        this.append("(", tr.getPrecision(), ")");
    }

    @Override
    public void visitDelete(Statement.Delete d) {
        this.append("delete");
        if (d.isArray()) {
            this.append("[]");
        }
        this.append(" ");
        this.append(d.getValue());
        this.append(";");
    }

    @Override
    public void visitInclude(Include inc) {
        switch (inc.getType()) {
            case CInclude: {
                this.append("#include \"" + inc.getPath() + "\"\n");
                break;
            }
            case ObjCImport: {
                this.append("#import <" + inc.getPath() + ">\n");
                break;
            }
            case JavaImport: {
                this.append("import " + inc.getPath() + ";\n");
                break;
            }
            case JavaStaticImport: {
                this.append("import static " + inc.getPath() + ";\n");
            }
        }
    }

    @Override
    public void visitStatementDeclaration(StatementDeclaration d) {
        if (d.getStatement() != null) {
            d.getStatement().accept(this);
        }
    }
}

