/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator.parser;

import com.ochafik.lang.jnaerator.parser.Modifier;
import com.ochafik.lang.jnaerator.parser.ModifierKind;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ModifierType implements Modifier
{
    __cdecl(EnumSet.of(ModifierKind.CallingConvention)),
    _cdecl(__cdecl),
    __stdcall(EnumSet.of(ModifierKind.CallingConvention)),
    _stdcall(__stdcall),
    __fastcall(EnumSet.of(ModifierKind.CallingConvention)),
    _fastcall(__fastcall),
    __thiscall(EnumSet.of(ModifierKind.CallingConvention)),
    _thiscall(__thiscall),
    __pascal(EnumSet.of(ModifierKind.CallingConvention)),
    _pascal(__pascal),
    __pre(EnumSet.of(ModifierKind.VCAnnotationNoArg, ModifierKind.VCParameterAnnotation)),
    __valid(EnumSet.of(ModifierKind.VCAnnotationNoArg, ModifierKind.VCParameterAnnotation)),
    __reserved(EnumSet.of(ModifierKind.VCAnnotationNoArg, ModifierKind.VCParameterAnnotation)),
    __checkReturn(EnumSet.of(ModifierKind.VCAnnotationNoArg, ModifierKind.VCParameterAnnotation)),
    __fallthrough(EnumSet.of(ModifierKind.VCAnnotationNoArg, ModifierKind.VCParameterAnnotation)),
    __readonly(EnumSet.of(ModifierKind.VCAnnotationNoArg, ModifierKind.VCParameterAnnotation)),
    __null(EnumSet.of(ModifierKind.VCAnnotationNoArg, ModifierKind.VCParameterAnnotation)),
    __in(EnumSet.of(ModifierKind.VCAnnotationNoArg, ModifierKind.VCParameterAnnotation)),
    __out(EnumSet.of(ModifierKind.VCAnnotationNoArg, ModifierKind.VCParameterAnnotation)),
    __inout(EnumSet.of(ModifierKind.VCAnnotationNoArg, ModifierKind.VCParameterAnnotation)),
    __refparam(EnumSet.of(ModifierKind.VCAnnotationNoArg, ModifierKind.VCParameterAnnotation)),
    __exceptthat(EnumSet.of(ModifierKind.VCAnnotationNoArg, ModifierKind.VCParameterAnnotation)),
    _opt(EnumSet.of(ModifierKind.VCAnnotationNoArg, ModifierKind.VCParameterAnnotation)),
    _deref(EnumSet.of(ModifierKind.VCAnnotationNoArg, ModifierKind.VCParameterAnnotation)),
    _deref_opt(EnumSet.of(ModifierKind.VCAnnotationNoArg, ModifierKind.VCParameterAnnotation)),
    _ecount(EnumSet.of(ModifierKind.VCAnnotation1Arg, ModifierKind.VCParameterAnnotation)),
    _bcount(EnumSet.of(ModifierKind.VCAnnotation1Arg, ModifierKind.VCParameterAnnotation)),
    _full(EnumSet.of(ModifierKind.VCAnnotation1Arg, ModifierKind.VCParameterAnnotation)),
    _part(EnumSet.of(ModifierKind.VCAnnotation2Args, ModifierKind.VCParameterAnnotation)),
    __ptr64(EnumSet.of(ModifierKind.TypeQualifier)),
    __maybenull(EnumSet.of(ModifierKind.TypeQualifier)),
    __nullterminated(EnumSet.of(ModifierKind.TypeQualifier, ModifierKind.StringAnnotation)),
    __nullnullterminated(EnumSet.of(ModifierKind.TypeQualifier, ModifierKind.StringAnnotation)),
    __possibly_notnullterminated(EnumSet.of(ModifierKind.TypeQualifier, ModifierKind.StringAnnotation)),
    Auto(EnumSet.of(ModifierKind.StorageClassSpecifier)),
    Register(EnumSet.of(ModifierKind.StorageClassSpecifier)),
    Static(EnumSet.of(ModifierKind.StorageClassSpecifier)),
    Virtual(EnumSet.of(ModifierKind.StorageClassSpecifier)),
    Extern(EnumSet.of(ModifierKind.StorageClassSpecifier)),
    Pascal(__pascal, EnumSet.of(ModifierKind.StorageClassSpecifier)),
    __const(EnumSet.of(ModifierKind.TypeQualifier)),
    Const(__const),
    Volatile(EnumSet.of(ModifierKind.TypeQualifier)),
    Mutable(EnumSet.of(ModifierKind.TypeQualifier)),
    __unsigned(EnumSet.of(ModifierKind.NumericTypeQualifier, ModifierKind.SignModifier)),
    __signed(EnumSet.of(ModifierKind.NumericTypeQualifier, ModifierKind.SignModifier)),
    Unsigned(__unsigned),
    Signed(__signed),
    Long(EnumSet.of(ModifierKind.NumericTypeQualifier, ModifierKind.SizeModifier)),
    Short(EnumSet.of(ModifierKind.NumericTypeQualifier, ModifierKind.SizeModifier)),
    _Complex(EnumSet.of(ModifierKind.NumericTypeQualifier)),
    Typename(EnumSet.of(ModifierKind.ReferenceQualifier)),
    Struct(EnumSet.of(ModifierKind.ReferenceQualifier)),
    Class(EnumSet.of(ModifierKind.ReferenceQualifier)),
    Public(EnumSet.of(ModifierKind.Publicity)),
    Abstract(EnumSet.of(ModifierKind.Publicity)),
    Final(EnumSet.of(ModifierKind.Publicity)),
    __private(EnumSet.of(ModifierKind.Publicity)),
    Private(__private),
    Protected(EnumSet.of(ModifierKind.Publicity)),
    Explicit(EnumSet.of(ModifierKind.Publicity, ModifierKind.StorageClassSpecifier)),
    Inline(EnumSet.of(ModifierKind.C, ModifierKind.StorageClassSpecifier)),
    __inline(Inline),
    __inline__(Inline),
    __forceinline(EnumSet.of(ModifierKind.C, ModifierKind.StorageClassSpecifier)),
    In(EnumSet.of(ModifierKind.ObjectiveC, ModifierKind.OnlyInArgDef)),
    Out(EnumSet.of(ModifierKind.ObjectiveC, ModifierKind.OnlyInArgDef)),
    InOut(EnumSet.of(ModifierKind.ObjectiveC, ModifierKind.OnlyInArgDef)),
    OneWay(EnumSet.of(ModifierKind.ObjectiveC, ModifierKind.OnlyInArgDef)),
    ByCopy(EnumSet.of(ModifierKind.ObjectiveC, ModifierKind.OnlyInArgDef)),
    ByRef(EnumSet.of(ModifierKind.ObjectiveC, ModifierKind.OnlyInArgDef)),
    Package(EnumSet.of(ModifierKind.ObjectiveC)),
    Optional(EnumSet.of(ModifierKind.ObjectiveC)),
    Required(EnumSet.of(ModifierKind.ObjectiveC)),
    Readonly(EnumSet.of(ModifierKind.ObjectiveC, ModifierKind.ObjCPropertyModifier)),
    Readwrite(EnumSet.of(ModifierKind.ObjectiveC, ModifierKind.ObjCPropertyModifier)),
    Strong(EnumSet.of(ModifierKind.ObjectiveC, ModifierKind.ObjCPropertyModifier)),
    Retain(EnumSet.of(ModifierKind.ObjectiveC, ModifierKind.ObjCPropertyModifier)),
    Unsafe_unretained(EnumSet.of(ModifierKind.ObjectiveC, ModifierKind.ObjCPropertyModifier)),
    Copy(EnumSet.of(ModifierKind.ObjectiveC, ModifierKind.ObjCPropertyModifier)),
    Assign(EnumSet.of(ModifierKind.ObjectiveC, ModifierKind.ObjCPropertyModifier)),
    Nonatomic(EnumSet.of(ModifierKind.ObjectiveC, ModifierKind.ObjCPropertyModifier)),
    Atomic(EnumSet.of(ModifierKind.ObjectiveC, ModifierKind.ObjCPropertyModifier)),
    Getter(EnumSet.of(ModifierKind.ObjectiveC, ModifierKind.ObjCPropertyModifier)),
    Setter(EnumSet.of(ModifierKind.ObjectiveC, ModifierKind.ObjCPropertyModifier)),
    Weak(EnumSet.of(ModifierKind.Attribute, ModifierKind.ObjectiveC, ModifierKind.ObjCPropertyModifier)),
    __strong(EnumSet.of(ModifierKind.ObjectiveC, ModifierKind.TypeQualifier)),
    __weak(EnumSet.of(ModifierKind.ObjectiveC, ModifierKind.TypeQualifier)),
    __autoreleasing(EnumSet.of(ModifierKind.ObjectiveC, ModifierKind.TypeQualifier)),
    __unsafe_unretained(EnumSet.of(ModifierKind.ObjectiveC, ModifierKind.TypeQualifier)),
    __block(EnumSet.of(ModifierKind.ObjectiveC, ModifierKind.TypeQualifier)),
    __bridge(EnumSet.of(ModifierKind.ObjectiveC, ModifierKind.TypeQualifier)),
    Align(EnumSet.of(ModifierKind.Declspec, ModifierKind.HasArguments)),
    Allocate(EnumSet.of(ModifierKind.Declspec, ModifierKind.HasArguments)),
    AppDomain(EnumSet.of(ModifierKind.Declspec)),
    Deprecated(EnumSet.of(ModifierKind.Declspec, ModifierKind.Attribute)),
    DllExport(EnumSet.of(ModifierKind.Declspec, ModifierKind.StorageClassSpecifier)),
    DllImport(EnumSet.of(ModifierKind.Declspec, ModifierKind.StorageClassSpecifier)),
    JITIntrinsic(EnumSet.of(ModifierKind.Declspec)),
    Naked(EnumSet.of(ModifierKind.Declspec, ModifierKind.StorageClassSpecifier, ModifierKind.Attribute)),
    NoAlias(EnumSet.of(ModifierKind.Declspec, ModifierKind.StorageClassSpecifier)),
    NoInline(EnumSet.of(ModifierKind.Declspec)),
    NoReturn(EnumSet.of(ModifierKind.Declspec)),
    NoThrow(EnumSet.of(ModifierKind.Declspec, ModifierKind.StorageClassSpecifier)),
    NoVTable(EnumSet.of(ModifierKind.Declspec)),
    Process(EnumSet.of(ModifierKind.Declspec)),
    Property(EnumSet.of(ModifierKind.Declspec, ModifierKind.HasArguments, ModifierKind.StorageClassSpecifier, ModifierKind.COMSpecific)),
    Restrict(EnumSet.of(ModifierKind.Declspec, ModifierKind.StorageClassSpecifier)),
    __restrict(Restrict),
    __restrict__(Restrict),
    SelectAny(EnumSet.of(ModifierKind.Declspec, ModifierKind.StorageClassSpecifier, ModifierKind.COMSpecific)),
    Thread(EnumSet.of(ModifierKind.Declspec)),
    UUID(EnumSet.of(ModifierKind.Declspec, new ModifierKind[]{ModifierKind.Extended, ModifierKind.HasArguments, ModifierKind.StorageClassSpecifier, ModifierKind.COMSpecific, ModifierKind.VCAnnotation1Arg})),
    Alias(EnumSet.of(ModifierKind.Attribute)),
    Always_inline(EnumSet.of(ModifierKind.Attribute)),
    Cdecl(__cdecl, EnumSet.of(ModifierKind.Attribute)),
    Constructor(EnumSet.of(ModifierKind.Attribute)),
    Destructor(EnumSet.of(ModifierKind.Attribute)),
    Dllexport(EnumSet.of(ModifierKind.Attribute)),
    Weak_import(EnumSet.of(ModifierKind.Attribute)),
    Dllimport(EnumSet.of(ModifierKind.Attribute)),
    Eightbit_data(EnumSet.of(ModifierKind.Attribute)),
    Exception(EnumSet.of(ModifierKind.Attribute)),
    Far(EnumSet.of(ModifierKind.Attribute)),
    Fastcall(__fastcall, EnumSet.of(ModifierKind.Attribute)),
    Format(EnumSet.of(ModifierKind.Attribute)),
    Format_arg(EnumSet.of(ModifierKind.Attribute)),
    Function_vector(EnumSet.of(ModifierKind.Attribute)),
    Interrupt(EnumSet.of(ModifierKind.Attribute)),
    Interrupt_handler(EnumSet.of(ModifierKind.Attribute)),
    Long_call(EnumSet.of(ModifierKind.Attribute)),
    Short_call(EnumSet.of(ModifierKind.Attribute)),
    Longcall(EnumSet.of(ModifierKind.Attribute)),
    Shortcall(EnumSet.of(ModifierKind.Attribute)),
    Malloc(EnumSet.of(ModifierKind.Attribute)),
    Model(EnumSet.of(ModifierKind.Attribute)),
    Near(EnumSet.of(ModifierKind.Attribute)),
    No_check_memory_usage(EnumSet.of(ModifierKind.Attribute)),
    No_instrument_function(EnumSet.of(ModifierKind.Attribute)),
    Noinline(EnumSet.of(ModifierKind.Attribute)),
    Nonnull(EnumSet.of(ModifierKind.Attribute)),
    Noreturn(EnumSet.of(ModifierKind.Attribute)),
    Nothrow(EnumSet.of(ModifierKind.Attribute)),
    Pure(EnumSet.of(ModifierKind.Attribute)),
    Regparm(EnumSet.of(ModifierKind.Attribute)),
    Saveall(EnumSet.of(ModifierKind.Attribute)),
    Section(EnumSet.of(ModifierKind.Attribute)),
    Signal(EnumSet.of(ModifierKind.Attribute)),
    Sp_switch(EnumSet.of(ModifierKind.Attribute)),
    Stdcall(__stdcall, EnumSet.of(ModifierKind.Attribute)),
    Tiny_data(EnumSet.of(ModifierKind.Attribute)),
    Trap_exit(EnumSet.of(ModifierKind.Attribute)),
    Unused(EnumSet.of(ModifierKind.Attribute)),
    Used(EnumSet.of(ModifierKind.Attribute)),
    Visibility(EnumSet.of(ModifierKind.Attribute)),
    Warn_unused_result(EnumSet.of(ModifierKind.Attribute)),
    __gnu_inline(EnumSet.of(ModifierKind.Attribute)),
    gnu_inline(__gnu_inline, EnumSet.of(ModifierKind.Attribute)),
    __dllimport__(EnumSet.of(ModifierKind.Attribute)),
    __always_inline__(EnumSet.of(ModifierKind.Attribute)),
    __unused__(EnumSet.of(ModifierKind.Attribute)),
    __alignof__(EnumSet.of(ModifierKind.Attribute)),
    __format__(EnumSet.of(ModifierKind.Attribute)),
    __used__(EnumSet.of(ModifierKind.Attribute)),
    __deprecated__(EnumSet.of(ModifierKind.Attribute)),
    __noreturn__(EnumSet.of(ModifierKind.Attribute)),
    __const__(EnumSet.of(ModifierKind.Attribute)),
    __malloc__(EnumSet.of(ModifierKind.Attribute)),
    __optimize__(EnumSet.of(ModifierKind.Attribute)),
    __aligned__(EnumSet.of(ModifierKind.Attribute)),
    __pure__(EnumSet.of(ModifierKind.Attribute)),
    __nothrow__(EnumSet.of(ModifierKind.Attribute)),
    __visibility__(EnumSet.of(ModifierKind.Attribute)),
    mode(EnumSet.of(ModifierKind.Attribute)),
    __weakref__(EnumSet.of(ModifierKind.Attribute)),
    __returns_twice__(EnumSet.of(ModifierKind.Attribute)),
    unused(__unused__, EnumSet.of(ModifierKind.Attribute)),
    noinline(EnumSet.of(ModifierKind.Attribute)),
    regparm(EnumSet.of(ModifierKind.Attribute)),
    __kernel(EnumSet.of(ModifierKind.OpenCL)),
    __global(EnumSet.of(ModifierKind.OpenCL)),
    __read_only(EnumSet.of(ModifierKind.OpenCL)),
    __write_only(EnumSet.of(ModifierKind.OpenCL)),
    __local(EnumSet.of(ModifierKind.OpenCL)),
    __constant(EnumSet.of(ModifierKind.OpenCL)),
    kernel(__kernel),
    global(__global),
    read_only(__read_only),
    write_only(__write_only),
    local(__local),
    constant(__constant),
    Synchronized(EnumSet.of(ModifierKind.Java)),
    Native(EnumSet.of(ModifierKind.Java));

    EnumSet<ModifierKind> kinds;
    Modifier alias;
    static Map<String, Modifier> mods;

    private ModifierType(ModifierType alias) {
        this.kinds = alias.kinds;
        this.alias = alias;
    }

    private ModifierType(EnumSet<ModifierKind> kinds) {
        this.kinds = kinds;
    }

    private ModifierType() {
        this(EnumSet.noneOf(ModifierKind.class));
    }

    private ModifierType(Modifier alias, EnumSet<ModifierKind> kinds) {
        this.alias = alias;
        this.kinds = kinds;
    }

    @Override
    public Modifier resolveAlias() {
        if (this.alias == null) {
            return this;
        }
        return this.alias.resolveAlias();
    }

    public boolean isContainedBy(Collection<Modifier> modifiers) {
        Modifier alias = this.resolveAlias();
        for (Modifier modifier : modifiers) {
            if (!modifier.resolveAlias().equals(alias)) continue;
            return true;
        }
        return false;
    }

    public int countIn(Collection<Modifier> modifiers) {
        Modifier alias = this.resolveAlias();
        int c = 0;
        for (Modifier modifier : modifiers) {
            if (!modifier.resolveAlias().equals(alias)) continue;
            ++c;
        }
        return c;
    }

    public Modifier getAlias() {
        return this.alias;
    }

    public static Modifier parseModifier(String name, ModifierKind ... kinds) {
        try {
            Modifier modifier = mods.get(name);
            if (kinds.length == 0 || modifier == null) {
                return modifier;
            }
            for (ModifierKind kind : kinds) {
                if (!modifier.isA(kind)) continue;
                return modifier;
            }
            return kinds.length > 0 ? null : modifier;
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    @Override
    public boolean isA(ModifierKind k) {
        if (k == ModifierKind.Plain && !this.kinds.contains((Object)ModifierKind.Attribute) && !this.kinds.contains((Object)ModifierKind.Declspec)) {
            return true;
        }
        if (k == ModifierKind.Extended && (this.kinds.contains((Object)ModifierKind.Attribute) || this.kinds.contains((Object)ModifierKind.Declspec))) {
            return true;
        }
        if ((k == ModifierKind.CPlusPlus || k == ModifierKind.CPlusPlusCLI || k == ModifierKind.ObjectiveC) && this.kinds.contains((Object)ModifierKind.C)) {
            return true;
        }
        return this.kinds.contains((Object)k);
    }

    @Override
    public boolean isAnyOf(ModifierKind ... kinds) {
        for (ModifierKind kind : kinds) {
            if (!this.isA(kind)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAllOf(ModifierKind ... kinds) {
        for (ModifierKind kind : kinds) {
            if (this.isA(kind)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Compiler compiler) {
        String low = this.name().toLowerCase();
        if (!this.kinds.contains((Object)ModifierKind.VCAnnotation1Arg) && !this.kinds.contains((Object)ModifierKind.VCAnnotation2Args) && !this.kinds.contains((Object)ModifierKind.VCAnnotationNoArg) && this.kinds.contains((Object)ModifierKind.Declspec)) {
            return "__declspec(" + low + ")";
        }
        if (this.kinds.contains((Object)ModifierKind.Attribute)) {
            return "__attribute__((" + low + "))";
        }
        return low;
    }

    @Override
    public Collection<ModifierKind> getKinds() {
        return this.kinds;
    }

    static {
        mods = new LinkedHashMap<String, Modifier>();
        for (ModifierType m : ModifierType.values()) {
            String n = m == _Complex ? m.name() : m.name().toLowerCase();
            mods.put(n, m);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Compiler {
        GCC,
        MSVC,
        Intel;

    }
}

