/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator.parser;

import com.ochafik.lang.jnaerator.parser.Annotation;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.Modifier;
import com.ochafik.lang.jnaerator.parser.ModifierKind;
import com.ochafik.lang.jnaerator.parser.ModifierType;
import com.ochafik.lang.jnaerator.parser.ValuedModifier;
import com.ochafik.lang.jnaerator.parser.Visitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModifiableElement
extends Element {
    protected final List<Modifier> modifiers = new ArrayList<Modifier>();
    protected final List<Annotation> annotations = new ArrayList<Annotation>();

    @Override
    public void accept(Visitor visitor) {
        visitor.visitModifiableElement(this);
    }

    public void addAnnotations(List<Annotation> as) {
        for (Annotation a : as) {
            this.addAnnotation(a);
        }
    }

    public ModifiableElement addAnnotation(Annotation a) {
        if (a != null) {
            this.annotations.add(a);
            a.setParentElement(this);
        }
        return this;
    }

    public List<Annotation> getAnnotations() {
        return this.unmodifiableList(this.annotations);
    }

    public void setAnnotations(List<Annotation> annotations) {
        ModifiableElement.changeValue((Element)this, this.annotations, annotations);
    }

    @Override
    public boolean replaceChild(Element child, Element by) {
        if (ModifiableElement.replaceChild(this.annotations, Annotation.class, (Element)this, child, by)) {
            return true;
        }
        return super.replaceChild(child, by);
    }

    @Override
    public Element getNextChild(Element child) {
        return ModifiableElement.getNextSibling(this.annotations, child);
    }

    @Override
    public Element getPreviousChild(Element child) {
        return ModifiableElement.getPreviousSibling(this.annotations, child);
    }

    public ModifiableElement addModifiers(List<Modifier> mods) {
        if (mods != null) {
            for (Modifier mod : mods) {
                if (mod == null) continue;
                this.modifiers.add(mod);
            }
        }
        return this;
    }

    public ModifiableElement addModifiers(Modifier ... mds) {
        return this.addModifiers(Arrays.asList(mds));
    }

    public Object getModifierValue(ModifierType t) {
        Modifier rt = t.resolveAlias();
        if (!t.isAnyOf(ModifierKind.HasArguments, ModifierKind.VCAnnotation1Arg)) {
            throw new RuntimeException("Modifier type " + t + " does not hold any value.");
        }
        for (Modifier m : this.getModifiers()) {
            ValuedModifier vm;
            Modifier mm;
            if (!(m instanceof ValuedModifier) || (mm = (vm = (ValuedModifier)m).getModifier()) == null || !rt.equals(mm = mm.resolveAlias())) continue;
            return vm.getValue();
        }
        return null;
    }

    public ModifiableElement reorganizeModifiers() {
        this.setModifiers(new ArrayList<Modifier>(new LinkedHashSet<Modifier>(this.getModifiers())));
        return this;
    }

    public List<Modifier> getModifiers() {
        return Collections.unmodifiableList(this.modifiers);
    }

    public List<Modifier> harvestModifiers() {
        ArrayList<Modifier> mods = new ArrayList<Modifier>();
        mods.addAll(this.getModifiers());
        return mods;
    }

    public boolean hasModifier(Modifier m) {
        m = m.resolveAlias();
        for (Modifier mm : this.modifiers) {
            if (!m.equals(mm.resolveAlias())) continue;
            return true;
        }
        return false;
    }

    public void removeModifiers(Modifier ... modifiers) {
        for (Modifier m : modifiers) {
            this.modifiers.remove(m);
        }
    }

    public void removeModifiers(List<Modifier> modifiers) {
        for (Modifier m : modifiers) {
            this.modifiers.remove(m);
        }
    }

    public void setModifiers(List<Modifier> modifiers) {
        this.modifiers.clear();
        if (modifiers != null) {
            this.modifiers.addAll(modifiers);
        }
    }
}

