/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator.parser;

import com.ochafik.lang.SyntaxUtils;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.Visitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Identifier
extends Element
implements Comparable<Object> {
    public QualifiedIdentifier derive(QualificationSeparator separator, Identifier ... subIdentifiers) {
        QualifiedIdentifier qi = new QualifiedIdentifier(separator);
        qi.add(this);
        for (Identifier i : subIdentifiers) {
            if (i == null) continue;
            qi.add(i);
        }
        return qi;
    }

    public QualifiedIdentifier derive(QualificationSeparator separator, String ... subIdentifiers) {
        QualifiedIdentifier qi = new QualifiedIdentifier(separator);
        qi.add(this);
        for (String i : subIdentifiers) {
            qi.add(new SimpleIdentifier(i, new Expression[0]));
        }
        return qi;
    }

    @Override
    public Identifier clone() {
        return (Identifier)super.clone();
    }

    public abstract boolean isPlain();

    public abstract SimpleIdentifier resolveLastSimpleIdentifier();

    public abstract List<SimpleIdentifier> resolveSimpleIdentifiers();

    public abstract Identifier eraseTemplateArguments();

    @Override
    public final int compareTo(Object o) {
        String s = this.toString();
        if (s == null) {
            return o == null ? 0 : -1;
        }
        String os = o == null ? null : String.valueOf(o);
        return os == null ? -1 : s.compareTo(os);
    }

    public final boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public abstract Identifier resolveAllButLastIdentifier();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class QualifiedIdentifier
    extends Identifier {
        private List<SimpleIdentifier> identifiers = new ArrayList<SimpleIdentifier>();
        private QualificationSeparator separator;

        public List<SimpleIdentifier> getIdentifiers() {
            return this.unmodifiableList(this.identifiers);
        }

        @Override
        public QualifiedIdentifier clone() {
            return (QualifiedIdentifier)super.clone();
        }

        public void add(Identifier identifier) {
            if (identifier instanceof SimpleIdentifier) {
                this.addIdentifier((SimpleIdentifier)identifier);
            } else {
                QualifiedIdentifier oqi = (QualifiedIdentifier)identifier;
                if (!SyntaxUtils.equal((Object)((Object)oqi.getSeparator()), (Object)((Object)this.separator))) {
                    throw new IllegalArgumentException("Attempting to derive qualified identifier " + this + " with mismatching separator " + (Object)((Object)this.separator) + " and sub-name " + identifier);
                }
                this.addIdentifiers(oqi.getIdentifiers());
            }
        }

        public QualifiedIdentifier() {
        }

        public QualifiedIdentifier(QualificationSeparator separator) {
            this.setSeparator(separator);
        }

        public QualifiedIdentifier(QualificationSeparator separator, List<SimpleIdentifier> identifiers) {
            this.setSeparator(separator);
            this.setIdentifiers(identifiers);
        }

        public void setSeparator(QualificationSeparator separator) {
            this.separator = separator;
        }

        public QualificationSeparator getSeparator() {
            return this.separator;
        }

        public void setIdentifiers(List<SimpleIdentifier> identifiers) {
            QualifiedIdentifier.changeValue((Element)this, this.identifiers, identifiers);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitQualifiedIdentifier(this);
        }

        @Override
        public Element getNextChild(Element child) {
            return QualifiedIdentifier.getNextSibling(this.identifiers, child);
        }

        @Override
        public Element getPreviousChild(Element child) {
            return QualifiedIdentifier.getPreviousSibling(this.identifiers, child);
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            if (QualifiedIdentifier.replaceChild(this.identifiers, SimpleIdentifier.class, (Element)this, child, by)) {
                return true;
            }
            return super.replaceChild(child, by);
        }

        public void addIdentifiers(List<SimpleIdentifier> is) {
            for (SimpleIdentifier i : is) {
                this.addIdentifier(i);
            }
        }

        public void addIdentifier(SimpleIdentifier i) {
            if (i == null) {
                return;
            }
            i.setParentElement(this);
            this.identifiers.add(i);
        }

        @Override
        public boolean isPlain() {
            return this.identifiers.size() == 1 && this.identifiers.get(0).isPlain();
        }

        @Override
        public SimpleIdentifier resolveLastSimpleIdentifier() {
            return this.identifiers.isEmpty() ? null : this.identifiers.get(this.identifiers.size() - 1);
        }

        @Override
        public QualifiedIdentifier eraseTemplateArguments() {
            return this.resolveAllButLastIdentifier().derive(this.getSeparator(), this.resolveLastSimpleIdentifier().eraseTemplateArguments());
        }

        @Override
        public List<SimpleIdentifier> resolveSimpleIdentifiers() {
            return this.getIdentifiers();
        }

        @Override
        public Identifier resolveAllButLastIdentifier() {
            ArrayList<SimpleIdentifier> si = new ArrayList<SimpleIdentifier>(this.identifiers);
            if (!si.isEmpty()) {
                si.remove(si.size() - 1);
            }
            return new QualifiedIdentifier(this.getSeparator(), si);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleIdentifier
    extends Identifier {
        private String name;
        private boolean javaStaticImportable;
        protected List<Expression> templateArguments = new ArrayList<Expression>();

        public SimpleIdentifier() {
        }

        public SimpleIdentifier(String name, Expression ... args) {
            this.setName(name);
            this.setTemplateArguments(Arrays.asList(args));
        }

        public SimpleIdentifier setJavaStaticImportable(boolean javaStaticImportable) {
            this.javaStaticImportable = javaStaticImportable;
            return this;
        }

        public boolean isJavaStaticImportable() {
            return this.javaStaticImportable;
        }

        public void addTemplateArgument(Expression x) {
            if (x == null) {
                return;
            }
            x.setParentElement(this);
            this.templateArguments.add(x);
        }

        @Override
        public Identifier eraseTemplateArguments() {
            return new SimpleIdentifier(this.getName(), new Expression[0]);
        }

        public List<Expression> getTemplateArguments() {
            return this.unmodifiableList(this.templateArguments);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            if (name != null && (name.contains(".") || name.contains("::"))) {
                throw new IllegalArgumentException("Not a simple identifier : '" + name + "'");
            }
            this.name = name;
        }

        public void setTemplateArguments(List<Expression> templateArguments) {
            SimpleIdentifier.changeValue((Element)this, this.templateArguments, templateArguments);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitSimpleIdentifier(this);
        }

        @Override
        public Element getNextChild(Element child) {
            return SimpleIdentifier.getNextSibling(this.templateArguments, child);
        }

        @Override
        public Element getPreviousChild(Element child) {
            return SimpleIdentifier.getPreviousSibling(this.templateArguments, child);
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            if (SimpleIdentifier.replaceChild(this.templateArguments, Expression.class, (Element)this, child, by)) {
                return true;
            }
            return super.replaceChild(child, by);
        }

        @Override
        public boolean isPlain() {
            return this.templateArguments.isEmpty();
        }

        @Override
        public SimpleIdentifier resolveLastSimpleIdentifier() {
            return this;
        }

        @Override
        public List<SimpleIdentifier> resolveSimpleIdentifiers() {
            return Arrays.asList(this);
        }

        @Override
        public Identifier resolveAllButLastIdentifier() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QualificationSeparator {
        Colons("::"),
        Dot(".");

        private String s;

        private QualificationSeparator(String s) {
            this.s = s;
        }

        public String toString() {
            return this.s;
        }
    }
}

