/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator.parser;

import com.ochafik.lang.jnaerator.parser.Annotation;
import com.ochafik.lang.jnaerator.parser.Arg;
import com.ochafik.lang.jnaerator.parser.Declaration;
import com.ochafik.lang.jnaerator.parser.Declarator;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.ElementsHelper;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.Modifier;
import com.ochafik.lang.jnaerator.parser.ModifierType;
import com.ochafik.lang.jnaerator.parser.Scanner;
import com.ochafik.lang.jnaerator.parser.Statement;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.Visitor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Function
extends Declaration
implements Declarator.MutableByDeclarator {
    final List<Arg> args = new ArrayList<Arg>();
    final List<TypeRef> thrown = new ArrayList<TypeRef>();
    final List<Expression.FunctionCall> initializers = new ArrayList<Expression.FunctionCall>();
    boolean throws_;
    Statement.Block body;
    Type type;
    Identifier name;
    String asmName;
    Scanner eraser = new Scanner(){

        public void visitSimpleIdentifier(Identifier.SimpleIdentifier e) {
            super.visitSimpleIdentifier(e);
            e.setTemplateArguments(Collections.EMPTY_LIST);
        }
    };

    public Function setName(Identifier name) {
        this.name = Function.changeValue((Element)this, this.name, name);
        return this;
    }

    public Identifier getName() {
        return this.name;
    }

    public boolean getThrows() {
        return this.throws_;
    }

    public void setThrows(boolean throws_) {
        this.throws_ = throws_;
    }

    public void setInitializers(List<Expression.FunctionCall> initializers) {
        Function.changeValue((Element)this, this.initializers, initializers);
    }

    public void addInitializer(Expression.FunctionCall i) {
        if (i == null) {
            return;
        }
        i.setParentElement(this);
        this.initializers.add(i);
    }

    public List<Expression.FunctionCall> getInitializers() {
        return this.unmodifiableList(this.initializers);
    }

    public void setAsmName(String asmName) {
        this.asmName = asmName;
    }

    public String getAsmName() {
        return this.asmName;
    }

    @Override
    public Element getNextChild(Element child) {
        Element e = super.getNextChild(child);
        if (e != null) {
            return e;
        }
        e = Function.getNextSibling(this.initializers, child);
        if (e != null) {
            return e;
        }
        e = Function.getNextSibling(this.thrown, child);
        if (e != null) {
            return e;
        }
        return Function.getNextSibling(this.args, child);
    }

    @Override
    public Function clone() {
        return (Function)super.clone();
    }

    @Override
    public Element getPreviousChild(Element child) {
        Element e = super.getPreviousChild(child);
        if (e != null) {
            return e;
        }
        e = Function.getPreviousSibling(this.initializers, child);
        if (e != null) {
            return e;
        }
        e = Function.getPreviousSibling(this.thrown, child);
        if (e != null) {
            return e;
        }
        return Function.getPreviousSibling(this.args, child);
    }

    @Override
    public boolean replaceChild(Element child, Element by) {
        if (child == this.getBody()) {
            this.setBody((Statement.Block)by);
            return true;
        }
        if (child == this.getName()) {
            this.setName((Identifier)by);
            return true;
        }
        if (Function.replaceChild(this.args, Arg.class, (Element)this, child, by)) {
            return true;
        }
        if (Function.replaceChild(this.thrown, TypeRef.class, (Element)this, child, by)) {
            return true;
        }
        if (Function.replaceChild(this.initializers, Expression.FunctionCall.class, (Element)this, child, by)) {
            return true;
        }
        return super.replaceChild(child, by);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Arg addArg(Arg a) {
        if (a != null) {
            this.args.add(a);
            a.setParentElement(this);
        }
        return a;
    }

    public List<Arg> getArgs() {
        return this.unmodifiableList(this.args);
    }

    public void setArgs(List<Arg> args) {
        Function.changeValue((Element)this, this.args, args);
    }

    public TypeRef addThrown(TypeRef a) {
        if (a != null) {
            this.thrown.add(a);
            a.setParentElement(this);
        }
        return a;
    }

    public List<TypeRef> getThrown() {
        return this.unmodifiableList(this.thrown);
    }

    public void setThrown(List<TypeRef> thrown) {
        Function.changeValue((Element)this, this.thrown, thrown);
    }

    public Function setBody(Statement.Block body) {
        this.body = Function.changeValue((Element)this, this.body, body);
        return this;
    }

    public Function() {
    }

    public Function(Type type, Identifier name, TypeRef returnType) {
        this.setType(type);
        this.setName(name);
        this.setValueType(returnType);
    }

    public Function(Type type, Identifier name, TypeRef returnType, Arg ... args) {
        this(type, name, returnType, Arrays.asList(args));
    }

    public Function(Type type, Identifier name, TypeRef returnType, List<Arg> args) {
        this.setType(type);
        this.setName(name);
        this.setValueType(returnType);
        this.setArgs(args);
    }

    @Override
    public Function addAnnotation(Annotation a) {
        return (Function)super.addAnnotation(a);
    }

    @Override
    public Function addModifiers(Modifier ... mds) {
        return (Function)super.addModifiers(mds);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitFunction(this);
    }

    public Statement.Block getBody() {
        return this.body;
    }

    public <E extends Element> E erase(E e) {
        this.eraser.visit(e);
        return e;
    }

    public String computeSignature(SignatureType signatureType) {
        StringBuilder b = new StringBuilder();
        if (this.type == Type.ObjCMethod) {
            b.append(this.modifiers.contains(ModifierType.Static) ? "+" : "-");
            b.append("(");
            TypeRef t = this.getValueType();
            if (t == null) {
                b.append("id");
            } else {
                t = t.clone();
                this.erase(t);
                t.setCommentAfter(null);
                t.setCommentBefore(null);
                b.append(t);
            }
            b.append(")");
            b.append(this.getName());
            boolean firstArg = true;
            for (Arg arg : this.args) {
                if (arg.isVarArg()) {
                    if (!firstArg) {
                        b.append(", ");
                    }
                    b.append("...");
                } else {
                    if (!firstArg) {
                        b.append(" " + arg.getSelector());
                    }
                    b.append(":(");
                    t = arg.createMutatedType();
                    if (t != null) {
                        this.erase(t);
                        t.setCommentAfter(null);
                        t.setCommentBefore(null);
                        b.append(t);
                    }
                    b.append(')');
                }
                firstArg = false;
            }
        } else {
            if (signatureType.hasReturnType && this.getValueType() != null) {
                TypeRef t = this.getValueType().clone();
                this.erase(t);
                t.stripDetails();
                b.append(t);
                b.append(' ');
            }
            if (signatureType.hasName) {
                b.append(this.getName());
            }
            boolean first = true;
            b.append('(');
            for (Arg arg : this.getArgs()) {
                if (first) {
                    first = false;
                } else {
                    b.append(", ");
                }
                TypeRef t = arg.createMutatedType();
                if (t != null) {
                    this.erase(t);
                    t.stripDetails();
                }
                b.append(t);
            }
            b.append(')');
        }
        return b.toString();
    }

    public static Function fromMethod(Method m) {
        Function f = new Function(Type.JavaMethod, ElementsHelper.ident(m.getName()), m.getReturnType() == null ? ElementsHelper.typeRef("void") : ElementsHelper.typeRef(m.getReturnType()));
        int i = 0;
        for (Class<?> c : m.getParameterTypes()) {
            f.addArg(new Arg("arg" + i++, ElementsHelper.typeRef(c)));
        }
        int modifiers = m.getModifiers();
        if (java.lang.reflect.Modifier.isPrivate(modifiers)) {
            f.addModifiers(ModifierType.Private);
        }
        if (java.lang.reflect.Modifier.isProtected(modifiers)) {
            f.addModifiers(ModifierType.Protected);
        }
        if (java.lang.reflect.Modifier.isPublic(modifiers)) {
            f.addModifiers(ModifierType.Public);
        }
        if (java.lang.reflect.Modifier.isStatic(modifiers)) {
            f.addModifiers(ModifierType.Static);
        }
        if (java.lang.reflect.Modifier.isAbstract(modifiers)) {
            f.addModifiers(ModifierType.Abstract);
        }
        if (java.lang.reflect.Modifier.isFinal(modifiers)) {
            f.addModifiers(ModifierType.Final);
        }
        if (java.lang.reflect.Modifier.isNative(modifiers)) {
            f.addModifiers(ModifierType.Native);
        }
        if (java.lang.reflect.Modifier.isSynchronized(modifiers)) {
            f.addModifiers(ModifierType.Synchronized);
        }
        return f;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SignatureType {
        Full(true, true),
        ArgsOnly(false, false),
        ArgsAndRet(false, true),
        JavaStyle(true, false);

        public final boolean hasName;
        public final boolean hasReturnType;

        private SignatureType(boolean hasName, boolean hasReturnType) {
            this.hasName = hasName;
            this.hasReturnType = hasReturnType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        CFunction,
        ObjCMethod,
        CppMethod,
        JavaMethod,
        StaticInit;

    }
}

