/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator.parser;

import com.nativelibs4java.jalico.Pair;
import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.Visitor;
import java.lang.constant.Constable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Expression
extends Element {
    private static final long MAX_UINT_VALUE = 0xFFFFFFFEL;
    boolean parenthesis;
    static final Map<String, AssignmentOperator> assignOps = new LinkedHashMap<String, AssignmentOperator>();
    static final Map<String, BinaryOperator> binOps = new LinkedHashMap<String, BinaryOperator>();
    static final Map<String, UnaryOperator> unOps = new LinkedHashMap<String, UnaryOperator>();
    static final Map<AssignmentOperator, String> assignOpsRev = new LinkedHashMap<AssignmentOperator, String>();
    static final Map<BinaryOperator, String> binOpsRev = new LinkedHashMap<BinaryOperator, String>();
    static final Map<UnaryOperator, String> unOpsRev = new LinkedHashMap<UnaryOperator, String>();

    public Expression setParenthesis(boolean parenthesis) {
        this.parenthesis = parenthesis;
        return this;
    }

    public Expression setParenthesisIfNeeded() {
        this.setParenthesis(!(this instanceof VariableRef) && !(this instanceof FunctionCall) && !(this instanceof MemberRef) && !(this instanceof ArrayAccess));
        return this;
    }

    public boolean getParenthesis() {
        return this.parenthesis;
    }

    public boolean isParenthesis() {
        return this.parenthesis;
    }

    @Override
    public Expression clone() {
        return (Expression)super.clone();
    }

    public static MemberRefStyle parseMemberRefStyle(String s) {
        if (s.equals("->")) {
            return MemberRefStyle.Arrow;
        }
        if (s.equals(".")) {
            return MemberRefStyle.Dot;
        }
        if (s.equals("::")) {
            return MemberRefStyle.Colons;
        }
        return null;
    }

    static <K, V> void map(Map<K, V> m, Map<V, K> r, K k, V v) {
        m.put(k, v);
        r.put(v, k);
    }

    public static BinaryOperator getBinaryOperator(String s) {
        return binOps.get(s);
    }

    public static AssignmentOperator getAssignmentOperator(String s) {
        AssignmentOperator op = assignOps.get(s);
        if (op == null) {
            throw new RuntimeException("Failed to parse op " + s);
        }
        return op;
    }

    public static UnaryOperator getUnaryOperator(String s) {
        UnaryOperator op = unOps.get(s);
        if (op == null) {
            throw new RuntimeException("Failed to parse op " + s);
        }
        return op;
    }

    public static Enum<?> getAnyOperator(String s) {
        Enum e = binOps.get(s);
        if (e != null) {
            return e;
        }
        e = unOps.get(s);
        if (e != null) {
            return e;
        }
        return Expression.getAssignmentOperator(s);
    }

    static {
        for (AssignmentOperator assignmentOperator : AssignmentOperator.values()) {
            Expression.map(assignOps, assignOpsRev, assignmentOperator.toString(), assignmentOperator);
        }
        for (Enum enum_ : UnaryOperator.values()) {
            Expression.map(unOps, unOpsRev, ((UnaryOperator)enum_).toString(), enum_);
        }
        for (Enum enum_ : BinaryOperator.values()) {
            Expression.map(binOps, binOpsRev, ((BinaryOperator)enum_).toString(), enum_);
        }
    }

    public static class Constant
    extends Expression {
        Type type;
        IntForm intForm;
        Object value;
        String originalTextualRepresentation;
        static final String[] trailingTypeInfos = new String[]{"ll", "li", "l", "s", "u"};

        public Constant(Type type, IntForm intForm, Object value, String originalTextualRepresentation) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.setType(type);
            this.setIntForm(intForm);
            this.setValue(value);
            this.setOriginalTextualRepresentation(originalTextualRepresentation);
            this.checkType();
        }

        public Constant(Type type, Object value, String originalTextualRepresentation) {
            this.setType(type);
            this.setValue(value);
            this.setOriginalTextualRepresentation(originalTextualRepresentation);
            this.checkType();
        }

        public void setOriginalTextualRepresentation(String originalTextualRepresentation) {
            this.originalTextualRepresentation = originalTextualRepresentation;
        }

        public String getOriginalTextualRepresentation() {
            return this.originalTextualRepresentation;
        }

        void checkType() {
            if (this.type == null) {
                return;
            }
            Object value = this.getValue();
            switch (this.type) {
                case Int: 
                case UInt: 
                case IntegerString: {
                    value = (Integer)value;
                    break;
                }
                case ULong: 
                case Long: 
                case LongString: {
                    value = (Long)value;
                    break;
                }
                case Char: {
                    value = (Character)value;
                    break;
                }
                case Double: {
                    value = (Double)value;
                    break;
                }
                case Float: {
                    value = (Float)value;
                    break;
                }
                case String: {
                    value = (String)value;
                    break;
                }
                case Bool: {
                    value = (Boolean)value;
                }
            }
        }

        public static Constant newNull() {
            return new Constant(Type.Null, null, null);
        }

        public void setIntForm(IntForm intForm) {
            this.intForm = intForm;
        }

        public IntForm getIntForm() {
            return this.intForm;
        }

        public Type getType() {
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public Constant() {
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        static String intStr(int intVal) {
            return String.valueOf((char)(0xFF & intVal >> 24)) + (char)(0xFF & intVal >> 16) + (char)(0xFF & intVal >> 8) + (char)(0xFF & intVal);
        }

        public void accept(Visitor visitor) {
            visitor.visitConstant(this);
        }

        public Element getNextChild(Element child) {
            return null;
        }

        public Element getPreviousChild(Element child) {
            return null;
        }

        public Integer asInteger() {
            switch (this.getType()) {
                case Int: 
                case IntegerString: {
                    return (Integer)this.value;
                }
            }
            throw new ClassCastException("Constant " + this.getValue() + " is not an integer, but a " + (Object)((Object)this.getType()));
        }

        public static Constant parseCharOrStringInteger(String orig) {
            String parsed;
            String string = orig;
            int len = string.length();
            if (len <= 2 || string.charAt(0) != '\'' || string.charAt(len - 1) != '\'') {
                throw new IllegalArgumentException("Expecting char or integer string, got " + string);
            }
            string = string.substring(1, len - 1);
            if ((len -= 2) == 4) {
                boolean isIntegerString = true;
                int i = len;
                while (i-- != 0) {
                    if (string.charAt(i) != '\\') continue;
                    isIntegerString = false;
                    break;
                }
                if (isIntegerString) {
                    long result = 0L;
                    for (int i2 = 0; i2 < len; ++i2) {
                        result = result << 8 | (long)string.charAt(i2);
                    }
                    if (len == 4) {
                        return new Constant(Type.IntegerString, IntForm.String, (int)result, orig);
                    }
                    return new Constant(Type.LongString, IntForm.String, result, orig);
                }
            }
            if ((parsed = Constant.parseNakedString(string)).length() != 1) {
                throw new IllegalArgumentException("Expected char, go string of length " + parsed.length() + ": '" + parsed + "'");
            }
            return new Constant(Type.Char, Character.valueOf(parsed.charAt(0)), orig);
        }

        public static Constant parseChar(String orig) {
            String string = orig;
            int len = string.length();
            if (len <= 2 || string.charAt(0) != '\'' || string.charAt(len - 1) != '\'') {
                throw new IllegalArgumentException("Expecting char, got " + string);
            }
            string = string.substring(1, len - 1);
            return new Constant(Type.Char, Character.valueOf(Constant.parseNakedString(string).charAt(0)), orig);
        }

        private static String parseNakedString(String string) {
            int len = string.length();
            StringBuffer b = new StringBuffer(len);
            int i = 0;
            block12: while (i < len) {
                char c;
                if ((c = string.charAt(i++)) == '\\') {
                    int end;
                    c = string.charAt(i++);
                    switch (c) {
                        case 't': {
                            b.append('\t');
                            continue block12;
                        }
                        case 'n': {
                            b.append('\n');
                            continue block12;
                        }
                        case 'r': {
                            b.append('\r');
                            continue block12;
                        }
                        case 'f': {
                            b.append('\f');
                            continue block12;
                        }
                        case 'b': {
                            b.append('\b');
                            continue block12;
                        }
                        case '\\': {
                            b.append('\\');
                            continue block12;
                        }
                        case '\"': {
                            b.append('\"');
                            continue block12;
                        }
                        case '\'': {
                            b.append('\'');
                            continue block12;
                        }
                        case 'u': {
                            if (i >= len - 3) continue block12;
                            b.append((char)Integer.parseInt(string.substring(i, i + 4), 16));
                            i += 4;
                            continue block12;
                        }
                        case '0': {
                            b.append('\u0000');
                            continue block12;
                        }
                    }
                    if (!Character.isDigit(c)) continue;
                    int start = i - 1;
                    for (end = i; end < len && Character.isDigit(string.charAt(end)); ++end) {
                    }
                    b.append((char)Integer.parseInt(string.substring(start, end), 8));
                    i = end;
                    continue;
                }
                b.append(c);
            }
            return b.toString();
        }

        public static Constant parseStringInteger(String orig) {
            String string = orig;
            int len = string.length();
            if (len <= 2 || string.charAt(0) != '\'' || string.charAt(len - 1) != '\'' || (len -= 2) != 4 && len != 8) {
                throw new IllegalArgumentException("Expecting 'xxxx' or 'xxxxxxxx', got " + string);
            }
            string = string.substring(1, len - 1);
            long result = 0L;
            int i = len;
            while (i-- != 0) {
                result = result << 8 | (long)string.charAt(i);
            }
            if (len == 4) {
                return new Constant(Type.Int, IntForm.String, (int)result, orig);
            }
            return new Constant(Type.Long, IntForm.String, result, orig);
        }

        public static Constant parseString(String orig) {
            String string = orig;
            int len = string.length();
            if (len < 2 || string.charAt(0) != '\"' || string.charAt(len - 1) != '\"') {
                throw new IllegalArgumentException("Expecting string, got " + string);
            }
            string = string.substring(1, len - 1);
            return new Constant(Type.String, Constant.parseNakedString(string), orig);
        }

        public static Constant string(String s) {
            return new Constant(Type.String, s, s);
        }

        public static Constant parseDecimal(String string) {
            return Constant.parseInteger(string, 10, IntForm.Decimal, false);
        }

        public static Constant parseInteger(String string, int radix, IntForm form, boolean negate) {
            return Constant.parseInteger(string, radix, form, negate, string);
        }

        public static Constant parseInteger(String string, int radix, IntForm form, boolean negate, String orig) {
            Constable value;
            char c;
            if ((string = string.trim().toLowerCase()).startsWith("+")) {
                string = string.substring(1);
            }
            Type tpe = Type.Int;
            boolean unsigned = false;
            while (string.length() > 0 && ((c = string.charAt(string.length() - 1)) == 'u' || c == 'i' || c == 'l' || c == 's')) {
                if (string.endsWith("ll") || string.endsWith("li")) {
                    tpe = Type.Long;
                    string = string.substring(0, string.length() - 2);
                    continue;
                }
                if (string.endsWith("l") || string.endsWith("i")) {
                    string = string.substring(0, string.length() - 1);
                    continue;
                }
                if (string.endsWith("s")) {
                    tpe = Type.Short;
                    string = string.substring(0, string.length() - 1);
                    continue;
                }
                if (!string.endsWith("u")) continue;
                unsigned = true;
                string = string.substring(0, string.length() - 1);
            }
            if (string.equals("ffffffffffffffff")) {
                tpe = Type.Long;
                value = -1L;
            } else {
                long longValue = tpe == Type.Long && unsigned || string.length() == 16 ? new BigInteger(string, radix).longValue() : Long.parseLong(string, radix);
                switch (tpe) {
                    case Bool: {
                        assert (!negate);
                        value = Boolean.valueOf(longValue != 0L);
                        break;
                    }
                    case Byte: {
                        if (longValue > 127L || longValue < -256L) {
                            tpe = Type.Short;
                            value = (short)(negate ? -longValue : longValue);
                            break;
                        }
                        byte v = (byte)(longValue & 0xFFL);
                        value = negate ? -v : v;
                        break;
                    }
                    case Char: {
                        assert (!negate);
                        value = Character.valueOf((char)(longValue & 0xFFFFL));
                        break;
                    }
                    case Short: {
                        if (longValue > 65534L || longValue < -65536L) {
                            tpe = Type.Int;
                            value = (int)(negate ? -longValue : longValue);
                            break;
                        }
                        short v = (short)(longValue & 0xFFFFL);
                        value = negate ? -v : v;
                        break;
                    }
                    case Int: {
                        if (longValue > 0xFFFFFFFEL || longValue < -4294967296L) {
                            tpe = Type.Long;
                            value = negate ? -longValue : longValue;
                            break;
                        }
                        if (longValue > Integer.MAX_VALUE || longValue < Integer.MIN_VALUE) {
                            tpe = Type.UInt;
                        }
                        int v = (int)(longValue & 0xFFFFFFFFFFFFFFFFL);
                        value = negate ? -v : v;
                        break;
                    }
                    case Long: {
                        value = negate ? -longValue : longValue;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Can't parse decimal of type " + (Object)((Object)tpe));
                    }
                }
            }
            if (unsigned || form == IntForm.Hex) {
                switch (tpe) {
                    case Int: {
                        tpe = Type.UInt;
                        break;
                    }
                    case Long: {
                        tpe = Type.ULong;
                    }
                }
            }
            return new Constant(tpe, form, value, orig);
        }

        public static Constant parseHex(String orig, boolean negate) {
            String string = orig;
            if (!(string = string.trim().toLowerCase()).startsWith("0x")) {
                throw new IllegalArgumentException("Expected hex literal, got " + string);
            }
            try {
                return Constant.parseInteger(string.substring(2), 16, IntForm.Hex, negate, orig);
            }
            catch (NumberFormatException ex) {
                throw new NumberFormatException("Parsing hex : \"" + string + "\"");
            }
        }

        public static Constant parseOctal(String string, boolean negate) {
            if (!(string = string.trim().toLowerCase()).startsWith("0")) {
                throw new IllegalArgumentException("Expected octal literal, got " + string);
            }
            return Constant.parseInteger(string.substring(1), 8, IntForm.Octal, negate);
        }

        public static Constant parseFloat(String orig) {
            int lm1;
            char c;
            String string = orig;
            if ((string = string.trim().toLowerCase()).length() > 0 && Character.isLetter(c = string.charAt(lm1 = string.length() - 1))) {
                String beg = string.substring(0, lm1);
                if (c == 'f') {
                    return new Constant(Type.Float, Float.valueOf(Float.parseFloat(beg)), orig);
                }
            }
            return new Constant(Type.Double, Double.parseDouble(string), orig);
        }

        static String trimTrailingTypeInfo(String s) {
            if (s == null) {
                return null;
            }
            block3: while (s.length() > 0) {
                switch (Character.toLowerCase(s.charAt(s.length() - 1))) {
                    case 'i': 
                    case 'l': 
                    case 's': 
                    case 'u': {
                        s = s.substring(0, s.length() - 1);
                        continue block3;
                    }
                }
                return s;
            }
            return s;
        }

        public Constant asJava() {
            Type type = this.getType();
            String txt = this.originalTextualRepresentation;
            switch (type) {
                case Int: 
                case Long: 
                case LongString: 
                case Byte: 
                case Short: {
                    txt = Constant.trimTrailingTypeInfo(txt);
                    break;
                }
                case UInt: {
                    if (this.intForm != IntForm.Hex && this.getValue() instanceof Long && (Long)this.getValue() > Integer.MAX_VALUE) {
                        txt = null;
                        break;
                    }
                }
                case ULong: {
                    if (this.intForm == IntForm.Hex) {
                        txt = Constant.trimTrailingTypeInfo(txt);
                        break;
                    }
                }
                case IntegerString: {
                    txt = null;
                }
            }
            switch (type) {
                case ULong: 
                case Long: {
                    if (txt != null) {
                        txt = txt + "L";
                    }
                }
                case LongString: {
                    type = Type.Long;
                    break;
                }
                case UInt: 
                case IntegerString: {
                    type = Type.Int;
                }
            }
            return new Constant(type, this.getValue(), txt);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum IntForm {
            Hex,
            Octal,
            String,
            Decimal;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            Int,
            String,
            Char,
            IntegerString,
            Float,
            Short,
            Byte,
            Long,
            UInt,
            Double,
            LongString,
            ULong,
            Bool,
            Null;

        }
    }

    public static class UnaryOp
    extends Expression {
        UnaryOperator operator;
        Expression operand;

        public UnaryOp(Expression operand, UnaryOperator operator) {
            this.setOperand(operand);
            this.setOperator(operator);
        }

        public UnaryOp() {
        }

        public Expression getOperand() {
            return this.operand;
        }

        public void setOperator(UnaryOperator operator) {
            this.operator = operator;
        }

        public void setOperand(Expression operand) {
            this.operand = UnaryOp.changeValue((Element)this, this.operand, operand);
        }

        public UnaryOperator getOperator() {
            return this.operator;
        }

        public void accept(Visitor visitor) {
            visitor.visitUnaryOp(this);
        }

        public Element getNextChild(Element child) {
            return null;
        }

        public Element getPreviousChild(Element child) {
            return null;
        }

        public boolean replaceChild(Element child, Element by) {
            if (child == this.getOperand()) {
                this.setOperand((Expression)by);
                return true;
            }
            return super.replaceChild(child, by);
        }
    }

    public static class BinaryOp
    extends Expression {
        BinaryOperator operator;
        Expression firstOperand;
        Expression secondOperand;

        public BinaryOp(Expression firstOperand, BinaryOperator operator, Expression secondOperand) {
            if (operator == null) {
                throw new NullPointerException();
            }
            this.setOperator(operator);
            this.setFirstOperand(firstOperand);
            this.setSecondOperand(secondOperand);
        }

        public BinaryOp() {
        }

        public void setOperator(BinaryOperator operator) {
            this.operator = operator;
        }

        public Expression getSecondOperand() {
            return this.secondOperand;
        }

        public Expression getFirstOperand() {
            return this.firstOperand;
        }

        public void setSecondOperand(Expression secondOperand) {
            this.secondOperand = BinaryOp.changeValue((Element)this, this.secondOperand, secondOperand);
        }

        public void setFirstOperand(Expression firstOperand) {
            this.firstOperand = BinaryOp.changeValue((Element)this, this.firstOperand, firstOperand);
        }

        public BinaryOperator getOperator() {
            return this.operator;
        }

        public void accept(Visitor visitor) {
            visitor.visitBinaryOp(this);
        }

        public Element getNextChild(Element child) {
            if (child == this.getFirstOperand()) {
                return this.getSecondOperand();
            }
            return null;
        }

        public Element getPreviousChild(Element child) {
            if (child == this.getSecondOperand()) {
                return this.getFirstOperand();
            }
            return null;
        }

        public boolean replaceChild(Element child, Element by) {
            if (child == this.getFirstOperand()) {
                this.setFirstOperand((Expression)by);
                return true;
            }
            if (child == this.getSecondOperand()) {
                this.setSecondOperand((Expression)by);
                return true;
            }
            return super.replaceChild(child, by);
        }
    }

    public static class AssignmentOp
    extends Expression {
        Expression target;
        Expression value;
        AssignmentOperator operator;

        public AssignmentOp() {
        }

        public AssignmentOp(Expression target, AssignmentOperator operator, Expression value) {
            if (operator == null) {
                throw new NullPointerException();
            }
            this.setValue(value);
            this.setTarget(target);
            this.setOperator(operator);
        }

        public AssignmentOperator getOperator() {
            return this.operator;
        }

        public void setOperator(AssignmentOperator operator) {
            this.operator = operator;
        }

        public Expression getValue() {
            return this.value;
        }

        public Expression getTarget() {
            return this.target;
        }

        public void setValue(Expression value) {
            this.value = AssignmentOp.changeValue((Element)this, this.value, value);
        }

        public void setTarget(Expression target) {
            this.target = AssignmentOp.changeValue((Element)this, this.target, target);
        }

        public void accept(Visitor visitor) {
            visitor.visitAssignmentOp(this);
        }

        public Element getNextChild(Element child) {
            if (child == this.getTarget()) {
                return this.getValue();
            }
            return null;
        }

        public Element getPreviousChild(Element child) {
            if (child == this.getValue()) {
                return this.getTarget();
            }
            return null;
        }

        public boolean replaceChild(Element child, Element by) {
            if (child == this.getTarget()) {
                this.setTarget((Expression)by);
                return true;
            }
            if (child == this.getValue()) {
                this.setValue((Expression)by);
                return true;
            }
            return super.replaceChild(child, by);
        }
    }

    public static class Cast
    extends Expression {
        TypeRef type;
        Expression target;

        public Cast(TypeRef type, Expression target) {
            this.setTarget(target);
            this.setType(type);
        }

        public Cast() {
        }

        public void setTarget(Expression target) {
            this.target = Cast.changeValue((Element)this, this.target, target);
        }

        public void setType(TypeRef type) {
            this.type = Cast.changeValue((Element)this, this.type, type);
        }

        public Expression getTarget() {
            return this.target;
        }

        public TypeRef getType() {
            return this.type;
        }

        public void accept(Visitor visitor) {
            visitor.visitCast(this);
        }

        public Element getNextChild(Element child) {
            return null;
        }

        public Element getPreviousChild(Element child) {
            return null;
        }

        public boolean replaceChild(Element child, Element by) {
            if (child == this.getTarget()) {
                this.setTarget((Expression)by);
                return true;
            }
            if (child == this.getType()) {
                this.setType((TypeRef)by);
                return true;
            }
            return super.replaceChild(child, by);
        }
    }

    public static class ConditionalExpression
    extends Expression {
        Expression test;
        Expression thenValue;
        Expression elseValue;

        public ConditionalExpression() {
        }

        public ConditionalExpression(Expression test, Expression thenValue, Expression elseValue) {
            this.setTest(test);
            this.setThenValue(thenValue);
            this.setElseValue(elseValue);
        }

        public Expression getTest() {
            return this.test;
        }

        public void setTest(Expression test) {
            this.test = ConditionalExpression.changeValue((Element)this, this.test, test);
        }

        public Expression getThenValue() {
            return this.thenValue;
        }

        public void setThenValue(Expression thenValue) {
            this.thenValue = ConditionalExpression.changeValue((Element)this, this.thenValue, thenValue);
        }

        public Expression getElseValue() {
            return this.elseValue;
        }

        public void setElseValue(Expression elseValue) {
            this.elseValue = ConditionalExpression.changeValue((Element)this, this.elseValue, elseValue);
        }

        public void accept(Visitor visitor) {
            visitor.visitConditionalExpression(this);
        }

        public Element getNextChild(Element child) {
            return null;
        }

        public Element getPreviousChild(Element child) {
            return null;
        }

        public boolean replaceChild(Element child, Element by) {
            if (child == this.getTest()) {
                this.setTest((Expression)by);
                return true;
            }
            if (child == this.getThenValue()) {
                this.setThenValue((Expression)by);
                return true;
            }
            if (child == this.getElseValue()) {
                this.setElseValue((Expression)by);
                return true;
            }
            return super.replaceChild(child, by);
        }
    }

    public static class NullExpression
    extends Expression {
        public void accept(Visitor visitor) {
            visitor.visitNullExpression(this);
        }

        public Element getNextChild(Element child) {
            return null;
        }

        public Element getPreviousChild(Element child) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UnaryOperator implements Operator
    {
        Not("!"),
        Minus("-"),
        Parenthesis("()"),
        Complement("~"),
        Reference("&"),
        Dereference("*"),
        PreIncr("++"),
        PreDecr("--"),
        PostIncr("++"),
        PostDecr("--");

        String s;

        private UnaryOperator(String s) {
            this.s = s;
        }

        public String toString() {
            return this.s;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AssignmentOperator implements Operator
    {
        Equal("=", null),
        MultiplyEqual("*=", BinaryOperator.Multiply),
        DivideEqual("/=", BinaryOperator.Divide),
        ModuloEqual("%=", BinaryOperator.Modulo),
        PlusEqual("+=", BinaryOperator.Plus),
        MinusEqual("-=", BinaryOperator.Minus),
        LeftShiftEqual("<<=", BinaryOperator.LeftShift),
        RightShiftEqual(">>=", BinaryOperator.RightShift),
        SignedRightShiftEqual(">>>=", BinaryOperator.SignedRightShift),
        BitAndEqual("&=", BinaryOperator.BitAnd),
        XOREqual("^=", BinaryOperator.XOR),
        BitOrEqual("|=", BinaryOperator.BitOr);

        String s;
        BinaryOperator correspondingBinaryOp;

        private AssignmentOperator(String s, BinaryOperator correspondingBinaryOp) {
            this.s = s;
            this.correspondingBinaryOp = correspondingBinaryOp;
        }

        public String toString() {
            return this.s;
        }

        public BinaryOperator getCorrespondingBinaryOp() {
            return this.correspondingBinaryOp;
        }
    }

    public static interface Operator {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BinaryOperator implements Operator
    {
        Assign("="),
        Arrow("->"),
        ArrowStar("->*"),
        SquareBrackets("[]"),
        Comma(","),
        Plus("+"),
        Minus("-"),
        Divide("/"),
        Multiply("*"),
        Modulo("%"),
        LeftShift("<<"),
        RightShift(">>"),
        SignedRightShift(">>>"),
        XOR("^"),
        LessEqual("<=", true),
        GreaterEqual(">=", true),
        Less("<", true),
        Greater(">", true),
        IsEqual("==", true),
        IsDifferent("!=", true),
        BitOr("|"),
        Or("||", true),
        BitAnd("&"),
        And("&&", true);

        final String s;
        public final boolean givesBool;

        private BinaryOperator(String s) {
            this(s, false);
        }

        private BinaryOperator(String s, boolean givesBool) {
            this.s = s;
            this.givesBool = givesBool;
        }

        public String toString() {
            return this.s;
        }
    }

    public static class VariableRef
    extends Expression {
        Identifier name;

        public VariableRef(Identifier name) {
            this.setName(name);
        }

        public VariableRef() {
        }

        public Identifier getName() {
            return this.name;
        }

        public void setName(Identifier name) {
            this.name = VariableRef.changeValue((Element)this, this.name, name);
        }

        public void accept(Visitor visitor) {
            visitor.visitVariableRef(this);
        }

        public Element getNextChild(Element child) {
            return null;
        }

        public Element getPreviousChild(Element child) {
            return null;
        }

        public boolean replaceChild(Element child, Element by) {
            if (child == this.getName()) {
                this.setName((Identifier)by);
                return true;
            }
            return super.replaceChild(child, by);
        }
    }

    public static class ArrayAccess
    extends Expression {
        Expression target;
        Expression index;

        public ArrayAccess() {
        }

        public ArrayAccess(Expression target, Expression index) {
            this.setTarget(target);
            this.setIndex(index);
        }

        public Expression getTarget() {
            return this.target;
        }

        public void setTarget(Expression target) {
            this.target = ArrayAccess.changeValue((Element)this, this.target, target);
        }

        public void setIndex(Expression index) {
            this.index = ArrayAccess.changeValue((Element)this, this.index, index);
        }

        public Expression getIndex() {
            return this.index;
        }

        public void accept(Visitor visitor) {
            visitor.visitArrayAccess(this);
        }

        public Element getNextChild(Element child) {
            return null;
        }

        public Element getPreviousChild(Element child) {
            return null;
        }

        public boolean replaceChild(Element child, Element by) {
            if (child == this.getTarget()) {
                this.setTarget((Expression)by);
                return true;
            }
            if (child == this.getIndex()) {
                this.setIndex((Expression)by);
                return true;
            }
            return super.replaceChild(child, by);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FunctionCall
    extends MemberRef {
        Expression function;
        List<Pair<String, Expression>> arguments = new ArrayList<Pair<String, Expression>>();

        public List<Pair<String, Expression>> getArguments() {
            return this.unmodifiableList(this.arguments);
        }

        public void setArguments(List<Pair<String, Expression>> arguments) {
            for (Pair<String, Expression> p : this.arguments) {
                ((Expression)p.getSecond()).setParentElement(null);
            }
            this.arguments.clear();
            for (Pair<String, Expression> p : arguments) {
                this.addArgument((String)p.getFirst(), (Expression)p.getSecond());
            }
        }

        public FunctionCall(Expression function) {
            this.setFunction(function);
        }

        public FunctionCall(Expression function, Expression ... unnamedArgs) {
            this.setFunction(function);
            for (Expression x : unnamedArgs) {
                if (x == null) continue;
                this.addArgument(x);
            }
        }

        public FunctionCall(Expression target, Expression function, MemberRefStyle memberRefStyle, Expression ... unnamedArgs) {
            this.setTarget(target);
            this.setFunction(function);
            this.setMemberRefStyle(memberRefStyle);
            for (Expression x : unnamedArgs) {
                this.addArgument(x);
            }
        }

        public FunctionCall() {
        }

        public void addArgument(Expression ex) {
            this.addArgument(null, ex);
        }

        public void addArguments(List<Expression> ex) {
            for (Expression x : ex) {
                this.addArgument(null, x);
            }
        }

        public void addArgument(String argumentSelector, Expression ex) {
            if (ex == null) {
                return;
            }
            ex.setParentElement(this);
            this.arguments.add((Pair<String, Expression>)new Pair((Object)argumentSelector, (Object)ex));
        }

        public Expression getFunction() {
            return this.function;
        }

        public void setFunction(Expression function) {
            this.function = FunctionCall.changeValue((Element)this, this.function, function);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitFunctionCall(this);
        }

        protected int indexOf(Element x, List<Pair<String, Expression>> list) {
            int i = 0;
            for (Pair<String, Expression> p : list) {
                if (p.getValue() == x) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        @Override
        public Element getNextChild(Element child) {
            int i = this.indexOf(child, this.arguments);
            if (i >= 0) {
                return i < this.arguments.size() - 1 ? (Expression)this.arguments.get(i + 1).getValue() : null;
            }
            return null;
        }

        @Override
        public Element getPreviousChild(Element child) {
            int i = this.indexOf(child, this.arguments);
            if (i >= 0) {
                return i > 0 ? (Expression)this.arguments.get(i - 1).getValue() : null;
            }
            return null;
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            if (child == this.getTarget()) {
                this.setTarget((Expression)by);
                return true;
            }
            if (child == this.getFunction()) {
                this.setFunction((Expression)by);
                return true;
            }
            int i = this.indexOf(child, this.arguments);
            if (i >= 0) {
                Expression old = by == null ? (Expression)this.arguments.remove(i).getValue() : (Expression)this.arguments.get(i).setValue((Object)((Expression)by));
                if (old != by) {
                    if (old != null) {
                        old.setParentElement(null);
                    }
                    if (by != null) {
                        by.setParentElement(this);
                    }
                }
                return true;
            }
            return super.replaceChild(child, by);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class New
    extends Expression {
        TypeRef type;
        FunctionCall construction;

        public New(TypeRef type) {
            this.setType(type);
        }

        public New(TypeRef type, FunctionCall construction) {
            this.setType(type);
            this.setConstruction(construction);
        }

        public New(TypeRef type, Expression ... arguments) {
            this.setType(type);
            this.setConstruction(new FunctionCall(null, arguments));
        }

        public New(TypeRef type, List<Expression> arguments) {
            this(type, arguments.toArray(new Expression[arguments.size()]));
        }

        public New() {
        }

        public void setType(TypeRef type) {
            this.type = New.changeValue((Element)this, this.type, type);
        }

        public TypeRef getType() {
            return this.type;
        }

        public void setConstruction(FunctionCall construction) {
            this.construction = New.changeValue((Element)this, this.construction, construction);
        }

        public FunctionCall getConstruction() {
            return this.construction;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitNew(this);
        }

        @Override
        public Element getNextChild(Element child) {
            return null;
        }

        @Override
        public Element getPreviousChild(Element child) {
            return null;
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            if (child == this.getType()) {
                this.setType((TypeRef)by);
                return true;
            }
            if (child == this.getConstruction()) {
                this.setConstruction((FunctionCall)by);
                return true;
            }
            return super.replaceChild(child, by);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NewArray
    extends Expression {
        TypeRef type;
        boolean isAnnotationValue;
        List<Expression> dimensions = new ArrayList<Expression>();
        List<Expression> initialValues = new ArrayList<Expression>();

        public NewArray() {
        }

        public NewArray(TypeRef type, List<Expression> dimensions, List<Expression> initialValues) {
            this.setType(type);
            this.setDimensions(dimensions);
            this.setInitialValues(initialValues);
        }

        public static NewArray newAnnotationArrayValue(List<Expression> initialValues) {
            NewArray a = new NewArray(null, Collections.EMPTY_LIST, initialValues);
            a.setAnnotationValue(true);
            return a;
        }

        public boolean isAnnotationValue() {
            return this.isAnnotationValue;
        }

        public void setAnnotationValue(boolean value) {
            this.isAnnotationValue = value;
        }

        public List<Expression> getDimensions() {
            return this.unmodifiableList(this.dimensions);
        }

        public void addDimension(Expression dimension) {
            if (dimension == null) {
                return;
            }
            dimension.setParentElement(this);
            this.dimensions.add(dimension);
        }

        public void setDimensions(List<Expression> dimensions) {
            NewArray.changeValue((Element)this, this.dimensions, dimensions);
        }

        public List<Expression> getInitialValues() {
            return this.unmodifiableList(this.initialValues);
        }

        public void setInitialValues(List<Expression> initialValues) {
            NewArray.changeValue((Element)this, this.initialValues, initialValues);
        }

        public TypeRef getType() {
            return this.type;
        }

        public void setType(TypeRef type) {
            this.type = NewArray.changeValue((Element)this, this.type, type);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitNewArray(this);
        }

        @Override
        public Element getNextChild(Element child) {
            Element e = NewArray.getNextSibling(this.dimensions, child);
            if (e == null) {
                e = NewArray.getNextSibling(this.initialValues, child);
            }
            return e;
        }

        @Override
        public Element getPreviousChild(Element child) {
            Element e = NewArray.getPreviousSibling(this.dimensions, child);
            if (e == null) {
                e = NewArray.getPreviousSibling(this.initialValues, child);
            }
            return e;
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            if (child == this.getType()) {
                this.setType((TypeRef)by);
                return true;
            }
            return NewArray.replaceChild(this.initialValues, Expression.class, (Element)this, child, by) || NewArray.replaceChild(this.dimensions, Expression.class, (Element)this, child, by) || super.replaceChild(child, by);
        }
    }

    public static class MemberRef
    extends Expression {
        MemberRefStyle memberRefStyle;
        Expression target;
        Identifier name;

        public MemberRef(Identifier.SimpleIdentifier name) {
            this.setName(name);
        }

        public MemberRef(Expression target, MemberRefStyle memberRefStyle, Identifier name) {
            this.setTarget(target);
            this.setName(name);
            this.setMemberRefStyle(memberRefStyle);
        }

        public MemberRef() {
        }

        public void setName(Identifier name) {
            this.name = MemberRef.changeValue((Element)this, this.name, name);
        }

        public Identifier getName() {
            return this.name;
        }

        public void setTarget(Expression target) {
            this.target = MemberRef.changeValue((Element)this, this.target, target);
        }

        public Expression getTarget() {
            return this.target;
        }

        public void setMemberRefStyle(MemberRefStyle memberRefStyle) {
            this.memberRefStyle = memberRefStyle;
        }

        public MemberRefStyle getMemberRefStyle() {
            return this.memberRefStyle;
        }

        public boolean replaceChild(Element child, Element by) {
            if (child == this.getTarget()) {
                this.setTarget((Expression)by);
            }
            if (child == this.getName()) {
                this.setName((Identifier)by);
            }
            return super.replaceChild(child, by);
        }

        public void accept(Visitor visitor) {
            visitor.visitMemberRef(this);
        }

        public Element getNextChild(Element child) {
            return null;
        }

        public Element getPreviousChild(Element child) {
            return null;
        }
    }

    public static class EmptyArraySize
    extends Expression {
        public void accept(Visitor visitor) {
            visitor.visitEmptyArraySize(this);
        }

        public Element getNextChild(Element child) {
            return null;
        }

        public Element getPreviousChild(Element child) {
            return null;
        }
    }

    public static class TypeRefExpression
    extends Expression {
        TypeRef type;

        public TypeRefExpression(TypeRef type) {
            this.setType(type);
        }

        public TypeRefExpression() {
        }

        public TypeRef getType() {
            return this.type;
        }

        public void setType(TypeRef type) {
            this.type = TypeRefExpression.changeValue((Element)this, this.type, type);
        }

        public void accept(Visitor visitor) {
            visitor.visitTypeRefExpression(this);
        }

        public Element getNextChild(Element child) {
            return null;
        }

        public Element getPreviousChild(Element child) {
            return null;
        }

        public boolean replaceChild(Element child, Element by) {
            if (child == this.getType()) {
                this.setType((TypeRef)by);
                return true;
            }
            return super.replaceChild(child, by);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MemberRefStyle {
        Dot,
        SquareBrackets,
        Arrow,
        Colons;

    }

    public static class OpaqueExpression
    extends Expression {
        String opaqueString;

        public void setOpaqueString(String opaqueString) {
            this.opaqueString = opaqueString;
        }

        public String getOpaqueString() {
            return this.opaqueString;
        }

        public OpaqueExpression() {
        }

        public OpaqueExpression(String opaqueString) {
            this.setOpaqueString(opaqueString);
        }

        public void accept(Visitor visitor) {
            visitor.visitOpaqueExpression(this);
        }

        public Element getNextChild(Element child) {
            return null;
        }

        public Element getPreviousChild(Element child) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExpressionSequence
    extends Expression {
        final List<Expression> expressions = new ArrayList<Expression>();

        public ExpressionSequence() {
        }

        public ExpressionSequence(Expression ... expressions) {
            this(Arrays.asList(expressions));
        }

        public ExpressionSequence(List<Expression> expressions) {
            this.setExpressions(expressions);
        }

        public void addExpression(Expression e) {
            if (e != null) {
                this.expressions.add(e);
                e.setParentElement(this);
            }
        }

        public List<Expression> getExpressions() {
            return this.expressions;
        }

        public void setExpressions(List<Expression> sequence) {
            ExpressionSequence.changeValue((Element)this, this.expressions, sequence);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitExpressionSequence(this);
        }

        @Override
        public Element getNextChild(Element child) {
            return ExpressionSequence.getNextSibling(this.getExpressions(), child);
        }

        @Override
        public Element getPreviousChild(Element child) {
            return ExpressionSequence.getPreviousSibling(this.getExpressions(), child);
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            return ExpressionSequence.replaceChild(this.getExpressions(), Expression.class, (Element)this, child, by) || super.replaceChild(child, by);
        }
    }

    public static class ExpressionsBlock
    extends ExpressionSequence {
        public void accept(Visitor visitor) {
            visitor.visitExpressionsBlock(this);
        }
    }
}

