/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator.parser;

import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.Struct;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.Visitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Enum
extends TypeRef.TaggedTypeRef {
    Type type = Type.C;
    final List<EnumItem> items = new ArrayList<EnumItem>();
    final List<Identifier> interfaces = new ArrayList<Identifier>();
    Struct body;

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void addItem(EnumItem item) {
        if (item == null) {
            return;
        }
        item.setParentElement(this);
        this.items.add(item);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitEnum(this);
    }

    public List<EnumItem> getItems() {
        return this.unmodifiableList(this.items);
    }

    public void setItems(List<EnumItem> items) {
        Enum.changeValue((Element)this, this.items, items);
    }

    @Override
    public Element getNextChild(Element child) {
        Element e = super.getNextChild(child);
        if (e != null) {
            return e;
        }
        e = Enum.getNextSibling(this.items, child);
        if (e != null) {
            return e;
        }
        e = Enum.getNextSibling(this.interfaces, child);
        if (e != null) {
            return e;
        }
        return super.getNextChild(child);
    }

    @Override
    public Element getPreviousChild(Element child) {
        Element e = super.getPreviousChild(child);
        if (e != null) {
            return e;
        }
        e = Enum.getPreviousSibling(this.items, child);
        if (e != null) {
            return e;
        }
        e = Enum.getPreviousSibling(this.interfaces, child);
        if (e != null) {
            return e;
        }
        return super.getPreviousChild(child);
    }

    public Struct getBody() {
        return this.body;
    }

    public void setBody(Struct body) {
        this.body = Enum.changeValue((Element)this, this.body, body);
    }

    public List<Identifier> getInterfaces() {
        return Collections.unmodifiableList(this.interfaces);
    }

    public void setInterfaces(List<Identifier> interfaces) {
        Enum.changeValue((Element)this, this.interfaces, interfaces);
    }

    public void addInterface(Identifier interf) {
        if (interf == null) {
            return;
        }
        interf.setParentElement(this);
        this.interfaces.add(interf);
    }

    @Override
    public boolean replaceChild(Element child, Element by) {
        if (super.replaceChild(child, by)) {
            return true;
        }
        if (Enum.replaceChild(this.items, EnumItem.class, (Element)this, child, by)) {
            return true;
        }
        if (Enum.replaceChild(this.interfaces, Identifier.class, (Element)this, child, by)) {
            return true;
        }
        if (child == this.getBody()) {
            this.setBody((Struct)by);
            return true;
        }
        return super.replaceChild(child, by);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumItem
    extends Element {
        String name;
        List<Expression> arguments = new ArrayList<Expression>();
        Struct body;
        Type type;

        public EnumItem() {
        }

        public Type getType() {
            if (this.type == null && this.getParentElement() instanceof Enum) {
                return ((Enum)this.getParentElement()).getType();
            }
            return this.type;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public EnumItem(String name, Expression ... arguments) {
            this.setName(name);
            this.setArguments(Arrays.asList(arguments));
        }

        public Struct getBody() {
            return this.body;
        }

        public void setBody(Struct body) {
            this.body = EnumItem.changeValue((Element)this, this.body, body);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<Expression> getArguments() {
            return Collections.unmodifiableList(this.arguments);
        }

        public void setArguments(List<Expression> arguments) {
            EnumItem.changeValue((Element)this, this.arguments, arguments);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitEnumItem(this);
        }

        @Override
        public Element getNextChild(Element child) {
            Element e = EnumItem.getNextSibling(this.arguments, child);
            if (e != null) {
                return e;
            }
            return null;
        }

        @Override
        public Element getPreviousChild(Element child) {
            Element e = EnumItem.getPreviousSibling(this.arguments, child);
            if (e != null) {
                return e;
            }
            return null;
        }

        @Override
        public boolean replaceChild(Element child, Element by) {
            if (EnumItem.replaceChild(this.arguments, Expression.class, (Element)this, child, by)) {
                return true;
            }
            if (child == this.getBody()) {
                this.setBody((Struct)by);
                return true;
            }
            return super.replaceChild(child, by);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        C,
        Java;

    }
}

