/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator.parser;

import com.nativelibs4java.jalico.Pair;
import com.ochafik.lang.jnaerator.parser.Function;
import com.ochafik.lang.jnaerator.parser.Identifier;
import com.ochafik.lang.jnaerator.parser.ObjCppParser;
import com.ochafik.lang.jnaerator.parser.Printer;
import com.ochafik.lang.jnaerator.parser.SemiUnmodifiableList;
import com.ochafik.lang.jnaerator.parser.TaggedTypeRefDeclaration;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.Visitor;
import com.ochafik.lang.reflect.GettersAndSettersHelper;
import com.ochafik.util.string.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Element {
    Element parentElement;
    String elementFile;
    int elementLine = -1;
    String commentBefore;
    String commentAfter;
    static int nextId = 1;
    private final int id = nextId++;
    protected EnumSet<ObjCppParser.Language> possibleLanguages;
    protected Identifier resolvedJavaIdentifier;
    protected Map<Object, Object> attributes;
    private static WeakHashMap<Class<?>, GettersAndSettersHelper> elementClassesGettersAndSetters = new WeakHashMap();
    private static final GettersAndSettersHelper.FieldGetter fieldGetter = new GettersAndSettersHelper.FieldGetter(){

        public Field getField(Class<?> c, String name) throws SecurityException, NoSuchFieldException {
            return c.getField(name);
        }
    };
    List<GettersAndSettersHelper.GetterAndSetterInfo> elementListGettersAndSetters;

    public Element() {
        if (Thread.interrupted()) {
            throw new RuntimeException(new InterruptedException());
        }
    }

    public void setResolvedJavaIdentifier(Identifier resolvedJavaIdentifier) {
        this.resolvedJavaIdentifier = Element.changeValue(this, this.resolvedJavaIdentifier, resolvedJavaIdentifier);
    }

    public Identifier getResolvedJavaIdentifier() {
        return this.resolvedJavaIdentifier;
    }

    public static Identifier getName(Element element) {
        if (element instanceof Function) {
            return ((Function)element).getName();
        }
        if (element instanceof TaggedTypeRefDeclaration) {
            return Element.getName(((TaggedTypeRefDeclaration)element).getTaggedTypeRef());
        }
        if (element instanceof TypeRef.TaggedTypeRef) {
            return ((TypeRef.TaggedTypeRef)element).getTag();
        }
        return null;
    }

    public Map<Object, Object> getAttributes() {
        return this.attributes == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(this.attributes);
    }

    public Object getAttribute(Object key) {
        return this.attributes == null ? null : this.attributes.get(key);
    }

    public void setAttribute(Object key, Object value) {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap<Object, Object>();
        }
        this.attributes.put(key, value);
    }

    public void setAttributes(Map<Object, Object> attributes) {
        this.attributes = attributes == null ? null : new LinkedHashMap<Object, Object>(attributes);
    }

    public EnumSet<ObjCppParser.Language> getPossibleLanguages() {
        return this.possibleLanguages;
    }

    public EnumSet<ObjCppParser.Language> resolvePossibleLanguages() {
        if (this.possibleLanguages != null) {
            return this.possibleLanguages;
        }
        Element parent = this.getParentElement();
        if (parent != null) {
            return parent.resolvePossibleLanguages();
        }
        return null;
    }

    public void setPossibleLanguages(EnumSet<ObjCppParser.Language> possibleLanguages) {
        this.possibleLanguages = possibleLanguages;
    }

    public int getId() {
        return this.id;
    }

    public void stripDetails() {
        this.setCommentBefore(null);
        this.setCommentAfter(null);
        this.setElementFile(null);
        this.setElementLine(-1);
    }

    public Element importComments(Element e, String ... extraComments) {
        if (e != null) {
            this.importDetails(e, false);
            this.moveAllCommentsBefore();
            this.deDioxygenizeCommentBefore();
        }
        this.addToCommentBefore(extraComments);
        return this;
    }

    public Element importDetails(Element from, boolean move) {
        if (from == null) {
            return this;
        }
        if (from.getElementFile() != null) {
            this.setElementFile(from.getElementFile());
        }
        if (from.getElementLine() >= 0) {
            this.setElementLine(from.getElementLine());
        }
        if (from.getCommentBefore() != null) {
            this.addToCommentBefore(from.getCommentBefore());
        }
        if (from.getCommentAfter() != null) {
            this.setCommentAfter(from.getCommentAfter());
        }
        if (move) {
            from.stripDetails();
        }
        return this;
    }

    protected <T> List<T> unmodifiableList(List<T> list) {
        return new SemiUnmodifiableList<T>(list);
    }

    public static String getFileOfAscendency(Element decl) {
        String file = null;
        TreeSet<Integer> visitedIds = new TreeSet<Integer>();
        for (Element e = decl; e != null && (file = e.getElementFile()) == null && visitedIds.add(e.getId()); e = e.getParentElement()) {
        }
        return file;
    }

    public static String cleanComment(String s) {
        if ((s = s.trim()).startsWith("//")) {
            s = s.replaceAll("^//+", "");
        } else if (s.startsWith("/*")) {
            s = s.replaceAll("^/\\*++!?", "").replaceAll("\\*/$", "");
            s = s.replaceAll("\n\\s+", "\n").replaceAll("\n\\*\\s?+", "\n");
        }
        s = s.replaceAll("\\*/", "* /");
        s = s.replaceAll("<br/?>\n", "\n");
        s = s.replaceAll("<br/?>$", "");
        return s.trim();
    }

    public void addToCommentBefore(List<String> s) {
        String b = this.getCommentBefore();
        ArrayList<String> ss = new ArrayList<String>();
        if (b != null && (b = Element.cleanComment(b)).length() > 0) {
            ss.add(b);
        }
        for (String a : s) {
            if (a == null || (a = Element.cleanComment(a)).length() <= 0) continue;
            ss.add(a);
        }
        this.setCommentBefore(ss.isEmpty() ? null : StringUtils.implode(ss, (Object)"\n"));
    }

    public void moveAllCommentsBefore() {
        if (this.getCommentAfter() != null) {
            this.addToCommentBefore(this.getCommentAfter());
            this.setCommentAfter(null);
        }
    }

    public void deDioxygenizeCommentBefore() {
        String comment = this.getCommentBefore();
        if (comment != null) {
            comment = comment.replaceAll("\n\\s*\\* ", "\n");
        }
        this.setCommentBefore(comment);
    }

    public void addToCommentBefore(String ... s) {
        this.addToCommentBefore(Arrays.asList(s));
    }

    public void setCommentBefore(String text) {
        this.commentBefore = text;
    }

    public String getCommentBefore() {
        return this.commentBefore;
    }

    public void setCommentAfter(String commentAfter) {
        this.commentAfter = commentAfter;
    }

    public String getCommentAfter() {
        return this.commentAfter;
    }

    public String getElementFile() {
        return this.elementFile;
    }

    public void setElementFile(String elementFile) {
        this.elementFile = elementFile;
    }

    public void setElementLine(int elementLine) {
        this.elementLine = elementLine;
    }

    public int getElementLine() {
        return this.elementLine;
    }

    public final Element getParentElement() {
        return this.parentElement;
    }

    public final void setParentElement(Element parentElement) {
        this.parentElement = parentElement == null ? null : parentElement;
    }

    public GettersAndSettersHelper getGettersAndSetters() {
        Class<?> type = this.getClass();
        GettersAndSettersHelper helper = elementClassesGettersAndSetters.get(type);
        if (helper == null) {
            helper = new GettersAndSettersHelper(type, fieldGetter);
            elementClassesGettersAndSetters.put(type, helper);
        }
        return helper;
    }

    public static <T extends Element> List<T> deepClone(List<T> list) {
        ArrayList<Element> clone = new ArrayList<Element>(list.size());
        for (Element e : list) {
            clone.add(e.clone());
        }
        return clone;
    }

    public Element clone() {
        String fieldName = null;
        try {
            Element clone = (Element)this.getClass().newInstance();
            Map infos = this.getGettersAndSetters().gettersAndSetters;
            for (Map.Entry e : infos.entrySet()) {
                fieldName = (String)e.getKey();
                if (fieldName.equals("parentElement")) continue;
                if (fieldName.equals("possibleLanguages")) {
                    fieldName = fieldName.toString();
                }
                GettersAndSettersHelper.GetterAndSetterInfo p = (GettersAndSettersHelper.GetterAndSetterInfo)e.getValue();
                if (p.getter == null || p.setter == null) continue;
                Object value = p.getter.invoke((Object)this, new Object[0]);
                Object clonedValue = fieldName.equals("attributes") ? value : Element.cloneObject(value);
                p.setter.invoke((Object)clone, clonedValue);
            }
            return clone;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static Object cloneObject(Object value) throws CloneNotSupportedException {
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (Element.class.isAssignableFrom(type)) {
            return ((Element)value).clone();
        }
        if (EnumSet.class.isAssignableFrom(type)) {
            return ((EnumSet)value).clone();
        }
        if (Collection.class.isAssignableFrom(type)) {
            return Element.cloneElements((Collection)value);
        }
        if (Map.class.isAssignableFrom(type)) {
            return Element.cloneElements((Map)value);
        }
        if (Pair.class.isAssignableFrom(type)) {
            Pair pair = (Pair)value;
            return new Pair(Element.cloneObject(pair.getFirst()), Element.cloneObject(pair.getSecond()));
        }
        return value;
    }

    public static Collection<?> cloneElements(Collection<?> col) throws CloneNotSupportedException {
        AbstractCollection colClone;
        if (col instanceof List) {
            colClone = new ArrayList(col.size());
        } else if (col instanceof LinkedHashSet) {
            colClone = new LinkedHashSet(col.size());
        } else if (col instanceof HashSet) {
            colClone = new HashSet(col.size());
        } else if (col instanceof TreeSet) {
            colClone = new TreeSet();
        } else if (col instanceof Set) {
            colClone = new LinkedHashSet(col.size());
        } else {
            throw new CloneNotSupportedException();
        }
        for (Object o : col) {
            o = Element.cloneObject(o);
            colClone.add(o);
        }
        return colClone;
    }

    public static Map<?, ?> cloneElements(Map<?, ?> col) throws CloneNotSupportedException {
        AbstractMap colClone;
        if (col instanceof TreeMap) {
            colClone = new TreeMap();
        } else if (col instanceof Map) {
            colClone = new LinkedHashMap();
        } else {
            throw new CloneNotSupportedException();
        }
        for (Map.Entry<?, ?> entry : col.entrySet()) {
            colClone.put(Element.cloneObject(entry.getKey()), Element.cloneObject(entry.getValue()));
        }
        return colClone;
    }

    public boolean replaceChild(Element child, Element by) {
        if (this.getResolvedJavaIdentifier() == child) {
            this.setResolvedJavaIdentifier((Identifier)by);
            return true;
        }
        return false;
    }

    public abstract Element getNextChild(Element var1);

    public abstract Element getPreviousChild(Element var1);

    public Element getNextSibling() {
        Element pe = this.getParentElement();
        if (pe != null) {
            return pe.getNextChild(this);
        }
        return null;
    }

    public Element getPreviousSibling() {
        Element pe = this.getParentElement();
        if (pe != null) {
            return pe.getPreviousChild(this);
        }
        return null;
    }

    public static <T extends Element> boolean replaceChild(List<T> list, Class<T> type, Element parent, Element child, Element by) {
        int i = Element.indexOfInstance(child, list);
        if (i >= 0) {
            Element old = by == null ? (Element)list.remove(i) : list.set(i, type == null ? by : (Element)type.cast(by));
            if (old != by) {
                if (old != null) {
                    old.setParentElement(null);
                }
                if (by != null) {
                    by.setParentElement(parent);
                }
            }
            return true;
        }
        return false;
    }

    public static <T extends Element> boolean replaceChild(Map<String, T> map, Class<T> type, Element parent, Element child, Element by) {
        String i = Element.indexOfInstance(child, map);
        if (i != null) {
            Element old = by == null ? (Element)map.remove(i) : map.put(i, type == null ? by : (Element)type.cast(by));
            if (old != by) {
                if (old != null) {
                    old.setParentElement(null);
                }
                if (by != null) {
                    by.setParentElement(parent);
                }
            }
            return true;
        }
        return false;
    }

    static <T> int indexOfInstance(Element e, List<? extends Element> list) {
        int i = -1;
        int n = list.size();
        for (int k = 0; k < n; ++k) {
            if (list.get(k) != e) continue;
            i = k;
            break;
        }
        return i;
    }

    static <T> T indexOfInstance(Element e, Map<T, ? extends Element> map) {
        for (Map.Entry<T, Element> entry : map.entrySet()) {
            if (entry.getValue() != e) continue;
            return entry.getKey();
        }
        return null;
    }

    public static <T extends Element> Element getNextSibling(Iterable<T> list, Element child) {
        boolean wasLast = false;
        for (Element value : list) {
            if (child == value) {
                wasLast = true;
                continue;
            }
            if (!wasLast) continue;
            return value;
        }
        return null;
    }

    public static <T extends Element> Element getPreviousSibling(Iterable<T> list, Element child) {
        Element last = null;
        for (Element value : list) {
            if (child == value) {
                return last;
            }
            last = value;
        }
        return null;
    }

    public static <T extends Element> void changeValue(Element parent, List<T> oldValue, List<T> newValue) {
        for (Element t : oldValue) {
            t.setParentElement(null);
        }
        oldValue.clear();
        if (newValue != null) {
            for (Element t : newValue) {
                if (t == null) continue;
                t.setParentElement(parent);
                oldValue.add(t);
            }
        }
    }

    public static <T extends Element> void changeValue(Element parent, Map<String, T> oldValue, Map<String, T> newValue) {
        for (Element t : oldValue.values()) {
            t.setParentElement(null);
        }
        oldValue.clear();
        if (newValue != null) {
            for (String name : newValue.keySet()) {
                Element t = (Element)newValue.get(name);
                if (t == null) continue;
                t.setParentElement(parent);
                oldValue.put(name, t);
            }
        }
    }

    public static <T extends Element> T changeValue(Element parent, T oldValue, T newValue) {
        if (oldValue != newValue) {
            if (oldValue != null) {
                oldValue.setParentElement(null);
            }
            if (newValue != null) {
                newValue.setParentElement(parent);
            }
        }
        return newValue;
    }

    public boolean insertSibling(Element siblingToInsert, boolean before) {
        Element parent = this.getParentElement();
        if (parent == null) {
            return false;
        }
        return parent.insertChild(this, siblingToInsert, before);
    }

    public boolean insertChild(Element existingChild, Element childToInsert, boolean before) {
        if (this.elementListGettersAndSetters == null) {
            this.elementListGettersAndSetters = new ArrayList<GettersAndSettersHelper.GetterAndSetterInfo>();
            GettersAndSettersHelper gettersAndSetters = this.getGettersAndSetters();
            for (Map.Entry e : gettersAndSetters.gettersAndSetters.entrySet()) {
                Type returnType;
                GettersAndSettersHelper.GetterAndSetterInfo p = (GettersAndSettersHelper.GetterAndSetterInfo)e.getValue();
                if (!p.isFull() || !((returnType = p.getter.getGenericReturnType()) instanceof ParameterizedType)) continue;
                ParameterizedType paramReturnType = (ParameterizedType)returnType;
                Type rawType = paramReturnType.getRawType();
                Type[] typeArguments = paramReturnType.getActualTypeArguments();
                Type typeArgument = typeArguments.length == 1 ? typeArguments[0] : null;
                if (typeArgument == null || !(typeArgument instanceof Class) || !(rawType instanceof Class)) continue;
                Class typeClass = (Class)typeArgument;
                Class rawClass = (Class)rawType;
                if (!Element.class.isAssignableFrom(typeClass) || !List.class.isAssignableFrom(rawClass)) continue;
                p.elementType = typeClass;
                this.elementListGettersAndSetters.add(p);
            }
        }
        Class<?> t = existingChild.getClass();
        Class<?> t2 = childToInsert.getClass();
        for (GettersAndSettersHelper.GetterAndSetterInfo info : this.elementListGettersAndSetters) {
            if (!info.elementType.isAssignableFrom(t) || !info.elementType.isAssignableFrom(t2)) continue;
            try {
                int i;
                List list = (List)info.getter.invoke((Object)this, new Object[0]);
                if (list instanceof SemiUnmodifiableList) {
                    list = ((SemiUnmodifiableList)list).getList();
                }
                if ((i = Element.indexOfInstance(existingChild, list)) < 0) continue;
                list.add(before ? i : i + 1, childToInsert);
                childToInsert.setParentElement(this);
                return true;
            }
            catch (Exception e) {
                throw new RuntimeException("Implementation bug in " + Element.class + ".insertChild !", e);
            }
        }
        return false;
    }

    public boolean replaceBy(Element element) {
        Element pe = this.getParentElement();
        if (pe != null) {
            return pe.replaceChild(this, element);
        }
        return false;
    }

    public boolean replaceByAndVisit(Element element, Visitor visitor) {
        if (!this.replaceBy(element)) {
            return false;
        }
        element.accept(visitor);
        return true;
    }

    public <T> T findParentOfType(Class<T> type) {
        return (T)this.findParentOfTypes(type);
    }

    public Object findParentOfTypes(Class<?> ... types) {
        Element e = this;
        block0: while ((e = e.getParentElement()) != null) {
            Class<?>[] classArray = types;
            int n = classArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block0;
                Class<?> type = classArray[n2];
                if (type.isAssignableFrom(e.getClass())) {
                    return type.cast(e);
                }
                ++n2;
            }
            break;
        }
        return null;
    }

    public String toString() {
        return new Printer(null).append(this).toString();
    }

    public abstract void accept(Visitor var1);
}

