/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.lang.jnaerator.parser;

import com.ochafik.lang.jnaerator.parser.Element;
import com.ochafik.lang.jnaerator.parser.Expression;
import com.ochafik.lang.jnaerator.parser.TypeRef;
import com.ochafik.lang.jnaerator.parser.Visitor;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Annotation
extends Element {
    TypeRef annotationClass;
    final Map<String, Expression> namedArguments = new LinkedHashMap<String, Expression>();
    Expression defaultArgument;

    public Annotation() {
    }

    public Annotation(TypeRef annotationClass) {
        this(annotationClass, null);
    }

    public Annotation(TypeRef annotationClass, Expression defaultArgument) {
        this(annotationClass, defaultArgument, Collections.emptyMap());
    }

    public Annotation(TypeRef annotationClass, Expression defaultArgument, Map<String, Expression> namedArguments) {
        this.setAnnotationClass(annotationClass);
        this.setDefaultArgument(defaultArgument);
        this.setNamedArguments(namedArguments);
    }

    public void setDefaultArgument(Expression defaultArgument) {
        this.defaultArgument = Annotation.changeValue((Element)this, this.defaultArgument, defaultArgument);
    }

    public Expression getDefaultArgument() {
        return this.defaultArgument;
    }

    public void setNamedArguments(Map<String, Expression> namedArguments) {
        Annotation.changeValue((Element)this, this.namedArguments, namedArguments);
    }

    public Map<String, Expression> getNamedArguments() {
        return Collections.unmodifiableMap(this.namedArguments);
    }

    public TypeRef getAnnotationClass() {
        return this.annotationClass;
    }

    public void setAnnotationClass(TypeRef annotationClass) {
        this.annotationClass = Annotation.changeValue((Element)this, this.annotationClass, annotationClass);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitAnnotation(this);
    }

    @Override
    public Element getNextChild(Element child) {
        return Annotation.getNextSibling(this.namedArguments.values(), child);
    }

    @Override
    public Element getPreviousChild(Element child) {
        return Annotation.getPreviousSibling(this.namedArguments.values(), child);
    }

    @Override
    public boolean replaceChild(Element child, Element by) {
        if (child == this.getAnnotationClass()) {
            this.setAnnotationClass((TypeRef)by);
            return true;
        }
        if (child == this.getDefaultArgument()) {
            this.setDefaultArgument((Expression)by);
            return true;
        }
        return Annotation.replaceChild(this.namedArguments, Expression.class, (Element)this, child, by) || super.replaceChild(child, by);
    }
}

