// $ANTLR 3.4 com/ochafik/lang/jnaerator/parser/XCodeProject.g 2015-03-28 11:03:43
 
/*
	Copyright (c) 2009 Olivier Chafik, All Rights Reserved
	
	This file is part of JNAerator (http://jnaerator.googlecode.com/).
	
	JNAerator is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.
	
	JNAerator is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.
	
	You should have received a copy of the GNU Lesser General Public License
	along with JNAerator.  If not, see <http://www.gnu.org/licenses/>.
*/

package com.ochafik.lang.jnaerator.parser;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

@SuppressWarnings({"all", "warnings", "unchecked"})
public class XCodeProjectLexer extends Lexer {
    public static final int EOF=-1;
    public static final int T__18=18;
    public static final int T__19=19;
    public static final int T__20=20;
    public static final int T__21=21;
    public static final int T__22=22;
    public static final int T__23=23;
    public static final int T__24=24;
    public static final int CHARACTER=4;
    public static final int COMMENT=5;
    public static final int CharEscape=6;
    public static final int FloatingPointConstantSuffix=7;
    public static final int FloatingPointExponentSuffix=8;
    public static final int HexDigit=9;
    public static final int IDENTIFIER=10;
    public static final int IntegerConstantSuffix=11;
    public static final int LINE_COMMENT=12;
    public static final int Letter=13;
    public static final int OctalEscape=14;
    public static final int STRING=15;
    public static final int UnicodeEscape=16;
    public static final int WS=17;

    // delegates
    // delegators
    public Lexer[] getDelegates() {
        return new Lexer[] {};
    }

    public XCodeProjectLexer() {} 
    public XCodeProjectLexer(CharStream input) {
        this(input, new RecognizerSharedState());
    }
    public XCodeProjectLexer(CharStream input, RecognizerSharedState state) {
        super(input,state);
    }
    public String getGrammarFileName() { return "com/ochafik/lang/jnaerator/parser/XCodeProject.g"; }

    // $ANTLR start "T__18"
    public final void mT__18() throws RecognitionException {
        try {
            int _type = T__18;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:25:7: ( '(' )
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:25:9: '('
            {
            match('('); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "T__18"

    // $ANTLR start "T__19"
    public final void mT__19() throws RecognitionException {
        try {
            int _type = T__19;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:26:7: ( ')' )
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:26:9: ')'
            {
            match(')'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "T__19"

    // $ANTLR start "T__20"
    public final void mT__20() throws RecognitionException {
        try {
            int _type = T__20;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:27:7: ( ',' )
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:27:9: ','
            {
            match(','); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "T__20"

    // $ANTLR start "T__21"
    public final void mT__21() throws RecognitionException {
        try {
            int _type = T__21;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:28:7: ( ';' )
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:28:9: ';'
            {
            match(';'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "T__21"

    // $ANTLR start "T__22"
    public final void mT__22() throws RecognitionException {
        try {
            int _type = T__22;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:29:7: ( '=' )
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:29:9: '='
            {
            match('='); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "T__22"

    // $ANTLR start "T__23"
    public final void mT__23() throws RecognitionException {
        try {
            int _type = T__23;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:30:7: ( '{' )
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:30:9: '{'
            {
            match('{'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "T__23"

    // $ANTLR start "T__24"
    public final void mT__24() throws RecognitionException {
        try {
            int _type = T__24;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:31:7: ( '}' )
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:31:9: '}'
            {
            match('}'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "T__24"

    // $ANTLR start "Letter"
    public final void mLetter() throws RecognitionException {
        try {
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:143:2: ( '$' | '_' | 'A' .. 'Z' | 'a' .. 'z' )
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:
            {
            if ( input.LA(1)=='$'||(input.LA(1) >= 'A' && input.LA(1) <= 'Z')||input.LA(1)=='_'||(input.LA(1) >= 'a' && input.LA(1) <= 'z') ) {
                input.consume();
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;
            }


            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "Letter"

    // $ANTLR start "IDENTIFIER"
    public final void mIDENTIFIER() throws RecognitionException {
        try {
            int _type = IDENTIFIER;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:149:2: ( ( Letter | '0' .. '9' )* )
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:149:4: ( Letter | '0' .. '9' )*
            {
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:149:4: ( Letter | '0' .. '9' )*
            loop1:
            do {
                int alt1=2;
                switch ( input.LA(1) ) {
                case '$':
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                case 'A':
                case 'B':
                case 'C':
                case 'D':
                case 'E':
                case 'F':
                case 'G':
                case 'H':
                case 'I':
                case 'J':
                case 'K':
                case 'L':
                case 'M':
                case 'N':
                case 'O':
                case 'P':
                case 'Q':
                case 'R':
                case 'S':
                case 'T':
                case 'U':
                case 'V':
                case 'W':
                case 'X':
                case 'Y':
                case 'Z':
                case '_':
                case 'a':
                case 'b':
                case 'c':
                case 'd':
                case 'e':
                case 'f':
                case 'g':
                case 'h':
                case 'i':
                case 'j':
                case 'k':
                case 'l':
                case 'm':
                case 'n':
                case 'o':
                case 'p':
                case 'q':
                case 'r':
                case 's':
                case 't':
                case 'u':
                case 'v':
                case 'w':
                case 'x':
                case 'y':
                case 'z':
                    {
                    alt1=1;
                    }
                    break;

                }

                switch (alt1) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/XCodeProject.g:
            	    {
            	    if ( input.LA(1)=='$'||(input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'Z')||input.LA(1)=='_'||(input.LA(1) >= 'a' && input.LA(1) <= 'z') ) {
            	        input.consume();
            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;
            	    }


            	    }
            	    break;

            	default :
            	    break loop1;
                }
            } while (true);


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "IDENTIFIER"

    // $ANTLR start "FloatingPointExponentSuffix"
    public final void mFloatingPointExponentSuffix() throws RecognitionException {
        try {
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:158:2: ( ( 'e' | 'E' ) ( '+' | '-' )? ( '0' .. '9' )+ )
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:158:4: ( 'e' | 'E' ) ( '+' | '-' )? ( '0' .. '9' )+
            {
            if ( input.LA(1)=='E'||input.LA(1)=='e' ) {
                input.consume();
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;
            }


            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:159:3: ( '+' | '-' )?
            int alt2=2;
            switch ( input.LA(1) ) {
                case '+':
                case '-':
                    {
                    alt2=1;
                    }
                    break;
            }

            switch (alt2) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/XCodeProject.g:
                    {
                    if ( input.LA(1)=='+'||input.LA(1)=='-' ) {
                        input.consume();
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    }
                    break;

            }


            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:160:3: ( '0' .. '9' )+
            int cnt3=0;
            loop3:
            do {
                int alt3=2;
                switch ( input.LA(1) ) {
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                    {
                    alt3=1;
                    }
                    break;

                }

                switch (alt3) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/XCodeProject.g:
            	    {
            	    if ( (input.LA(1) >= '0' && input.LA(1) <= '9') ) {
            	        input.consume();
            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;
            	    }


            	    }
            	    break;

            	default :
            	    if ( cnt3 >= 1 ) break loop3;
                        EarlyExitException eee =
                            new EarlyExitException(3, input);
                        throw eee;
                }
                cnt3++;
            } while (true);


            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "FloatingPointExponentSuffix"

    // $ANTLR start "FloatingPointConstantSuffix"
    public final void mFloatingPointConstantSuffix() throws RecognitionException {
        try {
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:165:2: ( 'f' | 'F' | 'd' | 'D' )
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:
            {
            if ( input.LA(1)=='D'||input.LA(1)=='F'||input.LA(1)=='d'||input.LA(1)=='f' ) {
                input.consume();
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;
            }


            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "FloatingPointConstantSuffix"

    // $ANTLR start "CharEscape"
    public final void mCharEscape() throws RecognitionException {
        try {
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:173:2: ( '\\\\' ( 'b' | 't' | 'n' | 'f' | 'r' | '\\\"' | '\\'' | '\\\\' ) | OctalEscape )
            int alt4=2;
            switch ( input.LA(1) ) {
            case '\\':
                {
                switch ( input.LA(2) ) {
                case '\"':
                case '\'':
                case '\\':
                case 'b':
                case 'f':
                case 'n':
                case 'r':
                case 't':
                    {
                    alt4=1;
                    }
                    break;
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                    {
                    alt4=2;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 4, 1, input);

                    throw nvae;

                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 4, 0, input);

                throw nvae;

            }

            switch (alt4) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/XCodeProject.g:173:4: '\\\\' ( 'b' | 't' | 'n' | 'f' | 'r' | '\\\"' | '\\'' | '\\\\' )
                    {
                    match('\\'); 

                    if ( input.LA(1)=='\"'||input.LA(1)=='\''||input.LA(1)=='\\'||input.LA(1)=='b'||input.LA(1)=='f'||input.LA(1)=='n'||input.LA(1)=='r'||input.LA(1)=='t' ) {
                        input.consume();
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/XCodeProject.g:184:3: OctalEscape
                    {
                    mOctalEscape(); 


                    }
                    break;

            }

        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "CharEscape"

    // $ANTLR start "OctalEscape"
    public final void mOctalEscape() throws RecognitionException {
        try {
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:189:2: ( '\\\\' ( ( '0' .. '3' ) ( '0' .. '7' ) ( '0' .. '7' ) | ( '0' .. '7' ) ( '0' .. '7' ) | ( '0' .. '7' ) ) )
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:189:4: '\\\\' ( ( '0' .. '3' ) ( '0' .. '7' ) ( '0' .. '7' ) | ( '0' .. '7' ) ( '0' .. '7' ) | ( '0' .. '7' ) )
            {
            match('\\'); 

            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:189:9: ( ( '0' .. '3' ) ( '0' .. '7' ) ( '0' .. '7' ) | ( '0' .. '7' ) ( '0' .. '7' ) | ( '0' .. '7' ) )
            int alt5=3;
            switch ( input.LA(1) ) {
            case '0':
            case '1':
            case '2':
            case '3':
                {
                switch ( input.LA(2) ) {
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                    {
                    switch ( input.LA(3) ) {
                    case '0':
                    case '1':
                    case '2':
                    case '3':
                    case '4':
                    case '5':
                    case '6':
                    case '7':
                        {
                        alt5=1;
                        }
                        break;
                    default:
                        alt5=2;
                    }

                    }
                    break;
                default:
                    alt5=3;
                }

                }
                break;
            case '4':
            case '5':
            case '6':
            case '7':
                {
                switch ( input.LA(2) ) {
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                    {
                    alt5=2;
                    }
                    break;
                default:
                    alt5=3;
                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 5, 0, input);

                throw nvae;

            }

            switch (alt5) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/XCodeProject.g:190:4: ( '0' .. '3' ) ( '0' .. '7' ) ( '0' .. '7' )
                    {
                    if ( (input.LA(1) >= '0' && input.LA(1) <= '3') ) {
                        input.consume();
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    if ( (input.LA(1) >= '0' && input.LA(1) <= '7') ) {
                        input.consume();
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    if ( (input.LA(1) >= '0' && input.LA(1) <= '7') ) {
                        input.consume();
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/XCodeProject.g:191:4: ( '0' .. '7' ) ( '0' .. '7' )
                    {
                    if ( (input.LA(1) >= '0' && input.LA(1) <= '7') ) {
                        input.consume();
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    if ( (input.LA(1) >= '0' && input.LA(1) <= '7') ) {
                        input.consume();
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    }
                    break;
                case 3 :
                    // com/ochafik/lang/jnaerator/parser/XCodeProject.g:192:4: ( '0' .. '7' )
                    {
                    if ( (input.LA(1) >= '0' && input.LA(1) <= '7') ) {
                        input.consume();
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    }
                    break;

            }


            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "OctalEscape"

    // $ANTLR start "UnicodeEscape"
    public final void mUnicodeEscape() throws RecognitionException {
        try {
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:198:2: ( '\\\\' 'u' HexDigit HexDigit HexDigit HexDigit )
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:198:4: '\\\\' 'u' HexDigit HexDigit HexDigit HexDigit
            {
            match('\\'); 

            match('u'); 

            mHexDigit(); 


            mHexDigit(); 


            mHexDigit(); 


            mHexDigit(); 


            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "UnicodeEscape"

    // $ANTLR start "CHARACTER"
    public final void mCHARACTER() throws RecognitionException {
        try {
            int _type = CHARACTER;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:204:2: ( '\\'' ( CharEscape |~ ( '\\\\' | '\\'' ) )+ '\\'' )
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:204:4: '\\'' ( CharEscape |~ ( '\\\\' | '\\'' ) )+ '\\''
            {
            match('\''); 

            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:205:3: ( CharEscape |~ ( '\\\\' | '\\'' ) )+
            int cnt6=0;
            loop6:
            do {
                int alt6=3;
                int LA6_0 = input.LA(1);

                if ( (LA6_0=='\\') ) {
                    alt6=1;
                }
                else if ( ((LA6_0 >= '\u0000' && LA6_0 <= '&')||(LA6_0 >= '(' && LA6_0 <= '[')||(LA6_0 >= ']' && LA6_0 <= '\uFFFF')) ) {
                    alt6=2;
                }


                switch (alt6) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/XCodeProject.g:206:4: CharEscape
            	    {
            	    mCharEscape(); 


            	    }
            	    break;
            	case 2 :
            	    // com/ochafik/lang/jnaerator/parser/XCodeProject.g:207:4: ~ ( '\\\\' | '\\'' )
            	    {
            	    if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '&')||(input.LA(1) >= '(' && input.LA(1) <= '[')||(input.LA(1) >= ']' && input.LA(1) <= '\uFFFF') ) {
            	        input.consume();
            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;
            	    }


            	    }
            	    break;

            	default :
            	    if ( cnt6 >= 1 ) break loop6;
                        EarlyExitException eee =
                            new EarlyExitException(6, input);
                        throw eee;
                }
                cnt6++;
            } while (true);


            match('\''); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "CHARACTER"

    // $ANTLR start "STRING"
    public final void mSTRING() throws RecognitionException {
        try {
            int _type = STRING;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:216:2: ( '\"' ( CharEscape |~ ( '\\\\' | '\"' ) )* '\"' )
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:216:4: '\"' ( CharEscape |~ ( '\\\\' | '\"' ) )* '\"'
            {
            match('\"'); 

            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:217:3: ( CharEscape |~ ( '\\\\' | '\"' ) )*
            loop7:
            do {
                int alt7=3;
                int LA7_0 = input.LA(1);

                if ( (LA7_0=='\\') ) {
                    alt7=1;
                }
                else if ( ((LA7_0 >= '\u0000' && LA7_0 <= '!')||(LA7_0 >= '#' && LA7_0 <= '[')||(LA7_0 >= ']' && LA7_0 <= '\uFFFF')) ) {
                    alt7=2;
                }


                switch (alt7) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/XCodeProject.g:218:4: CharEscape
            	    {
            	    mCharEscape(); 


            	    }
            	    break;
            	case 2 :
            	    // com/ochafik/lang/jnaerator/parser/XCodeProject.g:219:4: ~ ( '\\\\' | '\"' )
            	    {
            	    if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '!')||(input.LA(1) >= '#' && input.LA(1) <= '[')||(input.LA(1) >= ']' && input.LA(1) <= '\uFFFF') ) {
            	        input.consume();
            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;
            	    }


            	    }
            	    break;

            	default :
            	    break loop7;
                }
            } while (true);


            match('\"'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "STRING"

    // $ANTLR start "HexDigit"
    public final void mHexDigit() throws RecognitionException {
        try {
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:231:2: ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' )
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:
            {
            if ( (input.LA(1) >= '0' && input.LA(1) <= '9')||(input.LA(1) >= 'A' && input.LA(1) <= 'F')||(input.LA(1) >= 'a' && input.LA(1) <= 'f') ) {
                input.consume();
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;
            }


            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "HexDigit"

    // $ANTLR start "IntegerConstantSuffix"
    public final void mIntegerConstantSuffix() throws RecognitionException {
        try {
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:238:2: ( ( 'u' | 'U' ) | ( ( 'l' | 'L' ) ( 'l' | 'L' )? ) )
            int alt9=2;
            switch ( input.LA(1) ) {
            case 'U':
            case 'u':
                {
                alt9=1;
                }
                break;
            case 'L':
            case 'l':
                {
                alt9=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 9, 0, input);

                throw nvae;

            }

            switch (alt9) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/XCodeProject.g:238:4: ( 'u' | 'U' )
                    {
                    if ( input.LA(1)=='U'||input.LA(1)=='u' ) {
                        input.consume();
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/XCodeProject.g:239:3: ( ( 'l' | 'L' ) ( 'l' | 'L' )? )
                    {
                    // com/ochafik/lang/jnaerator/parser/XCodeProject.g:239:3: ( ( 'l' | 'L' ) ( 'l' | 'L' )? )
                    // com/ochafik/lang/jnaerator/parser/XCodeProject.g:240:4: ( 'l' | 'L' ) ( 'l' | 'L' )?
                    {
                    if ( input.LA(1)=='L'||input.LA(1)=='l' ) {
                        input.consume();
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    // com/ochafik/lang/jnaerator/parser/XCodeProject.g:241:4: ( 'l' | 'L' )?
                    int alt8=2;
                    switch ( input.LA(1) ) {
                        case 'L':
                        case 'l':
                            {
                            alt8=1;
                            }
                            break;
                    }

                    switch (alt8) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:
                            {
                            if ( input.LA(1)=='L'||input.LA(1)=='l' ) {
                                input.consume();
                            }
                            else {
                                MismatchedSetException mse = new MismatchedSetException(null,input);
                                recover(mse);
                                throw mse;
                            }


                            }
                            break;

                    }


                    }


                    }
                    break;

            }

        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "IntegerConstantSuffix"

    // $ANTLR start "WS"
    public final void mWS() throws RecognitionException {
        try {
            int _type = WS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:245:2: ( ( ' ' | '\\r' | '\\t' | '\\u000C' | '\\n' ) )
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:245:4: ( ' ' | '\\r' | '\\t' | '\\u000C' | '\\n' )
            {
            if ( (input.LA(1) >= '\t' && input.LA(1) <= '\n')||(input.LA(1) >= '\f' && input.LA(1) <= '\r')||input.LA(1)==' ' ) {
                input.consume();
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;
            }



            			_channel=HIDDEN;
            		

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "WS"

    // $ANTLR start "COMMENT"
    public final void mCOMMENT() throws RecognitionException {
        try {
            int _type = COMMENT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:257:2: ( ( '/*' ( options {greedy=false; } : . )* '*/' ) )
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:257:4: ( '/*' ( options {greedy=false; } : . )* '*/' )
            {
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:257:4: ( '/*' ( options {greedy=false; } : . )* '*/' )
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:258:4: '/*' ( options {greedy=false; } : . )* '*/'
            {
            match("/*"); 



            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:259:4: ( options {greedy=false; } : . )*
            loop10:
            do {
                int alt10=2;
                int LA10_0 = input.LA(1);

                if ( (LA10_0=='*') ) {
                    int LA10_1 = input.LA(2);

                    if ( (LA10_1=='/') ) {
                        alt10=2;
                    }
                    else if ( ((LA10_1 >= '\u0000' && LA10_1 <= '.')||(LA10_1 >= '0' && LA10_1 <= '\uFFFF')) ) {
                        alt10=1;
                    }


                }
                else if ( ((LA10_0 >= '\u0000' && LA10_0 <= ')')||(LA10_0 >= '+' && LA10_0 <= '\uFFFF')) ) {
                    alt10=1;
                }


                switch (alt10) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/XCodeProject.g:259:32: .
            	    {
            	    matchAny(); 

            	    }
            	    break;

            	default :
            	    break loop10;
                }
            } while (true);


            match("*/"); 



            }


             
            			_channel=HIDDEN; 
            		

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "COMMENT"

    // $ANTLR start "LINE_COMMENT"
    public final void mLINE_COMMENT() throws RecognitionException {
        try {
            int _type = LINE_COMMENT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:267:2: ( ( '//' (~ ( '\\n' | '\\r' ) )* ( '\\r' )? '\\n' ) )
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:267:4: ( '//' (~ ( '\\n' | '\\r' ) )* ( '\\r' )? '\\n' )
            {
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:267:4: ( '//' (~ ( '\\n' | '\\r' ) )* ( '\\r' )? '\\n' )
            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:268:4: '//' (~ ( '\\n' | '\\r' ) )* ( '\\r' )? '\\n'
            {
            match("//"); 



            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:269:4: (~ ( '\\n' | '\\r' ) )*
            loop11:
            do {
                int alt11=2;
                int LA11_0 = input.LA(1);

                if ( ((LA11_0 >= '\u0000' && LA11_0 <= '\t')||(LA11_0 >= '\u000B' && LA11_0 <= '\f')||(LA11_0 >= '\u000E' && LA11_0 <= '\uFFFF')) ) {
                    alt11=1;
                }


                switch (alt11) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/XCodeProject.g:
            	    {
            	    if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '\t')||(input.LA(1) >= '\u000B' && input.LA(1) <= '\f')||(input.LA(1) >= '\u000E' && input.LA(1) <= '\uFFFF') ) {
            	        input.consume();
            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;
            	    }


            	    }
            	    break;

            	default :
            	    break loop11;
                }
            } while (true);


            // com/ochafik/lang/jnaerator/parser/XCodeProject.g:270:4: ( '\\r' )?
            int alt12=2;
            switch ( input.LA(1) ) {
                case '\r':
                    {
                    alt12=1;
                    }
                    break;
            }

            switch (alt12) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/XCodeProject.g:270:4: '\\r'
                    {
                    match('\r'); 

                    }
                    break;

            }


            match('\n'); 

            }


             
            			_channel=HIDDEN;
            		

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "LINE_COMMENT"

    public void mTokens() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/XCodeProject.g:1:8: ( T__18 | T__19 | T__20 | T__21 | T__22 | T__23 | T__24 | IDENTIFIER | CHARACTER | STRING | WS | COMMENT | LINE_COMMENT )
        int alt13=13;
        switch ( input.LA(1) ) {
        case '(':
            {
            alt13=1;
            }
            break;
        case ')':
            {
            alt13=2;
            }
            break;
        case ',':
            {
            alt13=3;
            }
            break;
        case ';':
            {
            alt13=4;
            }
            break;
        case '=':
            {
            alt13=5;
            }
            break;
        case '{':
            {
            alt13=6;
            }
            break;
        case '}':
            {
            alt13=7;
            }
            break;
        case '\'':
            {
            alt13=9;
            }
            break;
        case '\"':
            {
            alt13=10;
            }
            break;
        case '\t':
        case '\n':
        case '\f':
        case '\r':
        case ' ':
            {
            alt13=11;
            }
            break;
        case '/':
            {
            switch ( input.LA(2) ) {
            case '*':
                {
                alt13=12;
                }
                break;
            case '/':
                {
                alt13=13;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 13, 12, input);

                throw nvae;

            }

            }
            break;
        default:
            alt13=8;
        }

        switch (alt13) {
            case 1 :
                // com/ochafik/lang/jnaerator/parser/XCodeProject.g:1:10: T__18
                {
                mT__18(); 


                }
                break;
            case 2 :
                // com/ochafik/lang/jnaerator/parser/XCodeProject.g:1:16: T__19
                {
                mT__19(); 


                }
                break;
            case 3 :
                // com/ochafik/lang/jnaerator/parser/XCodeProject.g:1:22: T__20
                {
                mT__20(); 


                }
                break;
            case 4 :
                // com/ochafik/lang/jnaerator/parser/XCodeProject.g:1:28: T__21
                {
                mT__21(); 


                }
                break;
            case 5 :
                // com/ochafik/lang/jnaerator/parser/XCodeProject.g:1:34: T__22
                {
                mT__22(); 


                }
                break;
            case 6 :
                // com/ochafik/lang/jnaerator/parser/XCodeProject.g:1:40: T__23
                {
                mT__23(); 


                }
                break;
            case 7 :
                // com/ochafik/lang/jnaerator/parser/XCodeProject.g:1:46: T__24
                {
                mT__24(); 


                }
                break;
            case 8 :
                // com/ochafik/lang/jnaerator/parser/XCodeProject.g:1:52: IDENTIFIER
                {
                mIDENTIFIER(); 


                }
                break;
            case 9 :
                // com/ochafik/lang/jnaerator/parser/XCodeProject.g:1:63: CHARACTER
                {
                mCHARACTER(); 


                }
                break;
            case 10 :
                // com/ochafik/lang/jnaerator/parser/XCodeProject.g:1:73: STRING
                {
                mSTRING(); 


                }
                break;
            case 11 :
                // com/ochafik/lang/jnaerator/parser/XCodeProject.g:1:80: WS
                {
                mWS(); 


                }
                break;
            case 12 :
                // com/ochafik/lang/jnaerator/parser/XCodeProject.g:1:83: COMMENT
                {
                mCOMMENT(); 


                }
                break;
            case 13 :
                // com/ochafik/lang/jnaerator/parser/XCodeProject.g:1:91: LINE_COMMENT
                {
                mLINE_COMMENT(); 


                }
                break;

        }

    }


 

}