// $ANTLR 3.4 com/ochafik/lang/jnaerator/parser/ObjCpp.g 2015-03-28 11:03:40
 
/*
  Copyright (c) 2009 Olivier Chafik, All Rights Reserved
  
  This file is part of JNAerator (http://jnaerator.googlecode.com/).
  
  JNAerator is free software: you can redistribute it and/or modify
  it under the terms of the GNU Lesser General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  JNAerator is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public License
  along with JNAerator.  If not, see <http://www.gnu.org/licenses/>.
*/

package com.ochafik.lang.jnaerator.parser;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.HashSet;
import static com.ochafik.lang.jnaerator.parser.TypeRef.*;
import static com.ochafik.lang.jnaerator.parser.Expression.*;
import static com.ochafik.lang.jnaerator.parser.Declaration.*;
import static com.ochafik.lang.jnaerator.parser.Identifier.*;
import static com.ochafik.lang.jnaerator.parser.Statement.*;
import static com.ochafik.lang.jnaerator.parser.Declarator.*;
import static com.ochafik.lang.jnaerator.parser.ElementsHelper.*;
import static com.ochafik.lang.jnaerator.parser.StoredDeclarations.*;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;

/**
  This grammar is by no mean complete.
  It is able to parse preprocessed C &amp; Objective-C files and can tolerate some amount of C++. 
*/
@SuppressWarnings({"all", "warnings", "unchecked"})
public class ObjCppParser extends Parser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "CHARACTER", "COMMA", "COMMENT", "CharEscape", "DECIMAL_NUMBER", "FLOAT_NUMBER", "FloatingPointConstantSuffix", "FloatingPointExponentSuffix", "HEXADECIMAL_NUMBER", "HexDigit", "IDENTIFIER", "IntegerConstantSuffix", "LBRACE", "LINE_COMMENT", "LPAREN", "Letter", "LongConstantSuffix", "OCTAL_NUMBER", "OctalEscape", "RBRACE", "RPAREN", "SEMICOLON", "STRING", "UnicodeEscape", "UnsignedConstantSuffix", "WS", "'!'", "'!='", "'#line'", "'%'", "'%='", "'&&'", "'&'", "'&='", "'*'", "'*='", "'+'", "'++'", "'+='", "'-'", "'--'", "'-='", "'->'", "'.'", "'...'", "'/'", "'/='", "':'", "'::'", "'<'", "'<<'", "'<<='", "'<='", "'='", "'=='", "'>'", "'>='", "'>>'", "'>>='", "'>>>'", "'?'", "'@class'", "'@encode'", "'@end'", "'@interface'", "'@optional'", "'@package'", "'@private'", "'@property'", "'@protected'", "'@protocol'", "'@public'", "'@required'", "'@selector'", "'['", "']'", "'^'", "'^='", "'__attribute__'", "'__declspec'", "'break'", "'case'", "'class'", "'do'", "'else'", "'enum'", "'for'", "'if'", "'namespace'", "'return'", "'struct'", "'switch'", "'typedef'", "'typename'", "'union'", "'while'", "'|'", "'|='", "'||'", "'~'", "'~='"
    };

    public static final int EOF=-1;
    public static final int T__30=30;
    public static final int T__31=31;
    public static final int T__32=32;
    public static final int T__33=33;
    public static final int T__34=34;
    public static final int T__35=35;
    public static final int T__36=36;
    public static final int T__37=37;
    public static final int T__38=38;
    public static final int T__39=39;
    public static final int T__40=40;
    public static final int T__41=41;
    public static final int T__42=42;
    public static final int T__43=43;
    public static final int T__44=44;
    public static final int T__45=45;
    public static final int T__46=46;
    public static final int T__47=47;
    public static final int T__48=48;
    public static final int T__49=49;
    public static final int T__50=50;
    public static final int T__51=51;
    public static final int T__52=52;
    public static final int T__53=53;
    public static final int T__54=54;
    public static final int T__55=55;
    public static final int T__56=56;
    public static final int T__57=57;
    public static final int T__58=58;
    public static final int T__59=59;
    public static final int T__60=60;
    public static final int T__61=61;
    public static final int T__62=62;
    public static final int T__63=63;
    public static final int T__64=64;
    public static final int T__65=65;
    public static final int T__66=66;
    public static final int T__67=67;
    public static final int T__68=68;
    public static final int T__69=69;
    public static final int T__70=70;
    public static final int T__71=71;
    public static final int T__72=72;
    public static final int T__73=73;
    public static final int T__74=74;
    public static final int T__75=75;
    public static final int T__76=76;
    public static final int T__77=77;
    public static final int T__78=78;
    public static final int T__79=79;
    public static final int T__80=80;
    public static final int T__81=81;
    public static final int T__82=82;
    public static final int T__83=83;
    public static final int T__84=84;
    public static final int T__85=85;
    public static final int T__86=86;
    public static final int T__87=87;
    public static final int T__88=88;
    public static final int T__89=89;
    public static final int T__90=90;
    public static final int T__91=91;
    public static final int T__92=92;
    public static final int T__93=93;
    public static final int T__94=94;
    public static final int T__95=95;
    public static final int T__96=96;
    public static final int T__97=97;
    public static final int T__98=98;
    public static final int T__99=99;
    public static final int T__100=100;
    public static final int T__101=101;
    public static final int T__102=102;
    public static final int T__103=103;
    public static final int T__104=104;
    public static final int CHARACTER=4;
    public static final int COMMA=5;
    public static final int COMMENT=6;
    public static final int CharEscape=7;
    public static final int DECIMAL_NUMBER=8;
    public static final int FLOAT_NUMBER=9;
    public static final int FloatingPointConstantSuffix=10;
    public static final int FloatingPointExponentSuffix=11;
    public static final int HEXADECIMAL_NUMBER=12;
    public static final int HexDigit=13;
    public static final int IDENTIFIER=14;
    public static final int IntegerConstantSuffix=15;
    public static final int LBRACE=16;
    public static final int LINE_COMMENT=17;
    public static final int LPAREN=18;
    public static final int Letter=19;
    public static final int LongConstantSuffix=20;
    public static final int OCTAL_NUMBER=21;
    public static final int OctalEscape=22;
    public static final int RBRACE=23;
    public static final int RPAREN=24;
    public static final int SEMICOLON=25;
    public static final int STRING=26;
    public static final int UnicodeEscape=27;
    public static final int UnsignedConstantSuffix=28;
    public static final int WS=29;

    // delegates
    public Parser[] getDelegates() {
        return new Parser[] {};
    }

    // delegators

    protected static class CurrentClass_scope {
        Identifier name;
    }
    protected Stack CurrentClass_stack = new Stack();


    protected static class ModContext_scope {
        boolean isObjCArgDef;
        boolean isInExtMod;
    }
    protected Stack ModContext_stack = new Stack();


    protected static class Symbols_scope {
        Set<String> typeIdentifiers;
    }
    protected Stack Symbols_stack = new Stack();


    protected static class ModifierKinds_scope {
        EnumSet<ModifierKind> allowedKinds;
        EnumSet<ModifierKind> forbiddenKinds;
    }
    protected Stack ModifierKinds_stack = new Stack();



    public ObjCppParser(TokenStream input) {
        this(input, new RecognizerSharedState());
    }
    public ObjCppParser(TokenStream input, RecognizerSharedState state) {
        super(input, state);
        this.state.ruleMemo = new HashMap[414+1];
         

    }

    public String[] getTokenNames() { return ObjCppParser.tokenNames; }
    public String getGrammarFileName() { return "com/ochafik/lang/jnaerator/parser/ObjCpp.g"; }


      public enum Language {
        C, CPlusPlus, ObjectiveC
      }
      public EnumSet<Language> possibleLanguages = EnumSet.allOf(Language.class);
      
      String lastComment;
      String file;
      int sourceLineDelta = 0; // line(token) = token.line - lastLineToken.line + lastLine; sourceLineDelta = lastLine - lastLineToken.line
      //String pack;
      
      public Set<String> topLevelTypeIdentifiers;// = new HashSet<String>();//java.util.Arrays.asList("CHAR"));
      public interface ObjCParserHelper {
        boolean isObjCppPrimitive(String identifier);
      }
      public ObjCParserHelper objCParserHelper;
      boolean isPrimitiveType(String identifier) {
        return objCParserHelper != null && objCParserHelper.isObjCppPrimitive(identifier);
      }
      public EnumSet<ModifierKind> newKinds(ModifierKind first, ModifierKind... rest) {
        return EnumSet.of(first, rest);
      }
      public void setupScopes() {
        if (hasModifierKinds())
          return;
          
            Symbols_scope ss = new Symbols_scope();
            ss.typeIdentifiers = new HashSet();
            Symbols_stack.push(ss);
            
            ModifierKinds_scope mk = new ModifierKinds_scope();
            
            //mk.allowedKinds = EnumSet.allOf(ModifierKind.class);
            
            mk.forbiddenKinds = EnumSet.noneOf(ModifierKind.class);
            mk.forbiddenKinds.addAll(Arrays.asList(
              ModifierKind.VCParameterAnnotation, 
              ModifierKind.Attribute,
              ModifierKind.Declspec,
              ModifierKind.Java,
              //ModifierKind.ObjectiveC, // TODO find a way to disable this...
              ModifierKind.OpenCL,
              ModifierKind.StringAnnotation
          ));
            //mk.forbiddenKinds.add(ModifierKind.ObjectiveCRemoting);
            
            ModifierKinds_stack.push(mk);
      }
      void setCurrentClassName(Identifier name) {
        ((CurrentClass_scope)CurrentClass_stack.peek()).name = name;
      }
      Identifier getCurrentClassName() {
        if (CurrentClass_stack.isEmpty())
          return null;
          
        return ((CurrentClass_scope)CurrentClass_stack.peek()).name;
      }
      boolean hasModifierKinds() {
        if (ModifierKinds_stack.isEmpty())
          return false;
        if (ModifierKinds_stack.size() > 1)
          return true;
        ModifierKinds_scope kinds = (ModifierKinds_scope)ModifierKinds_stack.get(0);
        return kinds.allowedKinds != null || kinds.forbiddenKinds != null;
      }
      ModifierKinds_scope getModifierKinds() {
        if (!hasModifierKinds())
          setupScopes();
    //      return null;
        return (ModifierKinds_scope)ModifierKinds_stack.get(ModifierKinds_stack.size() - 1);
      }
      public void forbidKinds(ModifierKind... kinds) {
        ModifierKinds_scope scope = getModifierKinds();
        if (scope == null)
          return;
        if (scope.forbiddenKinds == null)
          scope.forbiddenKinds = EnumSet.copyOf(Arrays.asList(kinds));
        else
          scope.forbiddenKinds.addAll(Arrays.asList(kinds));
          
        if (scope.allowedKinds != null)
          scope.allowedKinds.removeAll(Arrays.asList(kinds));
      }
      public void allowKinds(ModifierKind... kinds) {
        ModifierKinds_scope scope = getModifierKinds();
        if (scope == null)
          return;
        if (scope.allowedKinds == null)
          scope.allowedKinds = EnumSet.copyOf(Arrays.asList(kinds));
        else
          scope.allowedKinds.addAll(Arrays.asList(kinds));
          
        if (scope.forbiddenKinds != null)
          scope.forbiddenKinds.removeAll(Arrays.asList(kinds));
      }
      public boolean isAllowed(Modifier mod) {
        if (!hasModifierKinds())
          setupScopes();
        
        int nScopes = ModifierKinds_stack.size();
        for (int i = nScopes; i-- != 0;) {
          ModifierKinds_scope scope = (ModifierKinds_scope)ModifierKinds_stack.get(i);
          boolean allowed = false;
          for (ModifierKind kind : mod.getKinds()) {
            if (scope.forbiddenKinds != null && scope.forbiddenKinds.contains(kind))
              return false;
            if (scope.allowedKinds != null && scope.allowedKinds.contains(kind))
              allowed = true;
          }
          if (allowed)
            return true;
        }
        return true;
        //if (true) return true;
        /*ModifierKinds_scope scope = getModifierKinds();
        if (scope == null)
          return true;
        return scope.allowedKinds.containsAll(mod.getKinds());*/
      }
      public void addTypeIdent(String ident) {
        try {
          ((Symbols_scope)Symbols_stack.peek()).typeIdentifiers.add(ident);
        } catch (Exception ex) {
          ex.printStackTrace();
        }
      }
      boolean isObjCArgDef() {
        if (ModContext_stack.isEmpty())
          return false;
        ModContext_scope scope = (ModContext_scope)ModContext_stack.get(ModContext_stack.size() - 1);
        return scope.isObjCArgDef;
      }
      boolean isInExtMod() {
        if (ModContext_stack.isEmpty())
          return false;
        ModContext_scope scope = (ModContext_scope)ModContext_stack.get(ModContext_stack.size() - 1);
        return scope.isInExtMod;
      }
      void defineTypeIdentifierInParentScope(Identifier i) {
        if (i != null && i.isPlain())
          defineTypeIdentifierInParentScope(i.toString());
      }
      void defineTypeIdentifierInParentScope(String name) {
        if (name == null || Symbols_stack.isEmpty())
          return;
        int s = Symbols_stack.size();
        Symbols_scope sp = (Symbols_scope)Symbols_stack.get(s - 2 >= 0 ? s - 2 : s - 1);
        sp.typeIdentifiers.add(name);
      }
      boolean isTypeIdentifier(String identifier) {
        if (possibleLanguages.contains(Language.ObjectiveC)) {
          if ("SEL".equals(identifier) ||
            "id".equals(identifier) ||
            "IMP".equals(identifier) ||
            "Class".equals(identifier) ||
            "Protocol".equals(identifier) ||
            "BOOL".equals(identifier) ||
            "NSObject".equals(identifier) ||
            "NSClass".equals(identifier))
            return true;
        }
        for (Object oscope : Symbols_stack) {
          Symbols_scope scope = (Symbols_scope)oscope;
          if (scope.typeIdentifiers.contains(identifier))
            return true;
        }
        if (isPrimitiveType(identifier)) {
          //System.err.println("Found primitive : " + identifier);
          return true;
        }
        //System.err.println("Not a primitive : " + identifier);
        return topLevelTypeIdentifiers == null ? false : topLevelTypeIdentifiers.contains(identifier);
      }
      public void setFile(String file) {
        this.file = file;
        possibleLanguages = guessPossibleLanguages(file);
      }
      
      public EnumSet<Language> guessPossibleLanguages(String file) {
        int i = file.lastIndexOf(".");
        if (i > 0) {
          String ext = file.substring(i + 1).toLowerCase();
        
          if (ext.equals("h"))
            return EnumSet.allOf(Language.class);
          else if (ext.equals("c"))
            return EnumSet.of(Language.C);
          else if (ext.startsWith("c") || ext.startsWith("h")) // cxx, hxx
            return EnumSet.of(Language.C, Language.CPlusPlus);
          else if (ext.equals("m"))
            return EnumSet.of(Language.C, Language.ObjectiveC);
          else if (ext.equals("mm"))
            return EnumSet.allOf(Language.class);
        }
        return EnumSet.allOf(Language.class);
      }
      public String getFile() { 
        return file; 
      }
      
      public int getLine() {
        return getLine(getTokenStream().get(getTokenStream().index()));
      }
      
      public int getLine(Token token) {
        return token.getLine(); //+ sourceLineDelta;
      }
      
      protected <T extends Element> T mark(T element, int tokenLine) {
        element.setElementFile(getFile());
        if (tokenLine >= 0)
          element.setElementLine(tokenLine + sourceLineDelta);
        return element;
      }
      protected String getCommentBefore() {
        return getCommentBefore(getTokenStream().index());
      }
      protected String getCommentBefore(int index) {
        while (index > 0) {
          Token token = getTokenStream().get(--index);
          switch (token.getType()) {
            case COMMENT:
            case LINE_COMMENT:
              String comment = token.getText();
              while (index > 0) {
                Token prevToken = getTokenStream().get(--index);
                switch (prevToken.getType()) {
                  case COMMENT:
                  case LINE_COMMENT:
                    if (prevToken.getText().indexOf("\n") >= 0) {
                      return comment;
                    }
                    break;
                  default:
                    if (getLine(prevToken) < getLine(token)) {
                      return comment;
                    } else {
                      return null;
                    }
                }
              }
              if (index == 0) {
                return comment;
              }
              break;
            case SEMICOLON:
            case LBRACE:
            case RBRACE:
            case LPAREN:
            case RPAREN:
            case COMMA:
              return null;
            default:
              break;
          }
        }
        return null;
      }
      protected String getCommentAfterOnSameLine(int index, String forbiddenChars) {
        int size = getTokenStream().size();
        while (index < size) {
          Token token = getTokenStream().get(index++);
          String tt = token.getText();
          if (token.getType() == COMMENT || token.getType() == LINE_COMMENT)
            return tt;
          else if (tt.indexOf("\n") >= 0 || forbiddenChars != null && tt.matches(".*?[" + forbiddenChars + "].*"))
            break;
        }
        return null;
      }
      protected Declaration decl(TaggedTypeRef type) {
        return mark(new TaggedTypeRefDeclaration(type), type.getElementLine());
      } 
      
      protected String next() {
        return next(1);
      }
      protected String next(int i) {
        return input.LT(i).getText();
      }
      protected Modifier parseModifier(String s, ModifierKind... anyModKind) {
        Modifier mod = ModifierType.parseModifier(next(), anyModKind);
        if (mod == null)
          return null;
        if (mod.isAllOf(ModifierKind.ObjectiveC, ModifierKind.OnlyInArgDef) && !isObjCArgDef())
          return null;
        if (mod.isA(ModifierKind.Java))
          return null;
          
        //if (mod.isAnyOf(ModifierKind.Declspec, ModifierKind.Attribute) && !isInExtMod())
        //  return null;
          
        if (!mod.isAnyOf(anyModKind) && !isAllowed(mod))
          return null;
        
        return mod;
      }
      protected boolean next(ModifierKind... anyModKind) {
        return parseModifier(next(), anyModKind) != null;
      } 
      protected boolean next(String... ss) {
        return next(1, ss);
      }
      protected boolean next(Identifier id) {
        if (id == null)
          return false;
        return next(id.toString());
      }
      
      protected boolean next(int i, String... ss) {
        String n = next(i);
        for (String s : ss)
          if (s.equals(n))
            return true;
            
        return false;
      }
      
      String getSurroundings(Token t, int width) {
        if (t == null)
          return null;
        int x = t.getTokenIndex();
        List<String> strs = new ArrayList<String>();
        int size = getTokenStream().size();
        for (int i = x - width; i < x + width + 1; i++) {
          if (i < 0 || i >= size)
            continue;

          strs.add(getTokenStream().get(i).getText());
        }
        return com.ochafik.util.string.StringUtils.implode(strs, " ");
      }
      @Override
        public String getErrorMessage(RecognitionException e, String[] tokenNames) {
        if (e instanceof NoViableAltException) {
          NoViableAltException ne = (NoViableAltException)e;
          checkInterrupt();
          return "Failed to match any alternative with token " + ne.token + "\n\t" +
            " File: " + getFile() + ":" + (ne.line + sourceLineDelta) + "\n\t" +
            "Input: " + getSurroundings(ne.token, 5).replace('\n', ' ') + "\n\t" +
            " Rule: " + ne.grammarDecisionDescription + "\n\t" +
            "Stack: " + getRuleInvocationStack(e, getClass().getName()) + "\n";
        } else
          return super.getErrorMessage(e, tokenNames);
      }
      @Override
      public String getTokenErrorDisplay(Token t) {
        return t.toString();  
      }
      protected boolean checkInterrupt() {
        if (Thread.interrupted())
          throw new RuntimeException(new InterruptedException());
          
        return true;
      }



    // $ANTLR start "lineDirective"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:463:1: lineDirective : ln= '#line' line= DECIMAL_NUMBER (unescapedString= STRING ) depth= DECIMAL_NUMBER ;
    public final void lineDirective() throws RecognitionException {
        int lineDirective_StartIndex = input.index();

        Token ln=null;
        Token line=null;
        Token unescapedString=null;
        Token depth=null;

        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 1) ) { return ; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:464:3: (ln= '#line' line= DECIMAL_NUMBER (unescapedString= STRING ) depth= DECIMAL_NUMBER )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:464:6: ln= '#line' line= DECIMAL_NUMBER (unescapedString= STRING ) depth= DECIMAL_NUMBER
            {
            ln=(Token)match(input,32,FOLLOW_32_in_lineDirective98); if (state.failed) return ;

            line=(Token)match(input,DECIMAL_NUMBER,FOLLOW_DECIMAL_NUMBER_in_lineDirective102); if (state.failed) return ;

            if ( state.backtracking==0 ) {
                  try {
                    sourceLineDelta = Integer.parseInt((line!=null?line.getText():null)) - ln.getLine() - 1;
                  } catch (Exception ex) {
                    System.err.println("ERROR: unparsable line in #line directive : " + (line!=null?line.getText():null));
                    sourceLineDelta = 0;
                  }
                }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:472:5: (unescapedString= STRING )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:473:7: unescapedString= STRING
            {
            unescapedString=(Token)match(input,STRING,FOLLOW_STRING_in_lineDirective120); if (state.failed) return ;

            if ( state.backtracking==0 ) {
                    String fileStr = (unescapedString!=null?unescapedString.getText():null).trim();
                    if (fileStr.startsWith("\"")) {
                      fileStr = fileStr.substring(1);
                      if (fileStr.endsWith("\""))
                        fileStr = fileStr.substring(0, fileStr.length() - 1);
                    }        
                    setFile(fileStr);
                  }

            }


            depth=(Token)match(input,DECIMAL_NUMBER,FOLLOW_DECIMAL_NUMBER_in_lineDirective138); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 1, lineDirective_StartIndex); }

        }
        return ;
    }
    // $ANTLR end "lineDirective"



    // $ANTLR start "sourceFile"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:486:1: sourceFile returns [SourceFile sourceFile] : ( declaration | lineDirective |{...}? => IDENTIFIER STRING LBRACE | RBRACE )* EOF ;
    public final SourceFile sourceFile() throws RecognitionException {
        Symbols_stack.push(new Symbols_scope());

        SourceFile sourceFile = null;

        int sourceFile_StartIndex = input.index();

        ObjCppParser.declaration_return declaration1 =null;



          ((Symbols_scope)Symbols_stack.peek()).typeIdentifiers = new HashSet<String>();

        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 2) ) { return sourceFile; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:491:3: ( ( declaration | lineDirective |{...}? => IDENTIFIER STRING LBRACE | RBRACE )* EOF )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:492:5: ( declaration | lineDirective |{...}? => IDENTIFIER STRING LBRACE | RBRACE )* EOF
            {
            if ( state.backtracking==0 ) { sourceFile = new SourceFile(); }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:493:5: ( declaration | lineDirective |{...}? => IDENTIFIER STRING LBRACE | RBRACE )*
            loop1:
            do {
                int alt1=5;
                switch ( input.LA(1) ) {
                case IDENTIFIER:
                    {
                    switch ( input.LA(2) ) {
                    case COMMA:
                    case IDENTIFIER:
                    case LPAREN:
                    case SEMICOLON:
                    case 30:
                    case 31:
                    case 33:
                    case 34:
                    case 35:
                    case 36:
                    case 37:
                    case 38:
                    case 39:
                    case 40:
                    case 41:
                    case 42:
                    case 43:
                    case 44:
                    case 45:
                    case 46:
                    case 49:
                    case 50:
                    case 51:
                    case 52:
                    case 53:
                    case 54:
                    case 55:
                    case 56:
                    case 57:
                    case 58:
                    case 59:
                    case 60:
                    case 61:
                    case 62:
                    case 63:
                    case 65:
                    case 68:
                    case 74:
                    case 78:
                    case 80:
                    case 81:
                    case 82:
                    case 83:
                    case 86:
                    case 89:
                    case 92:
                    case 94:
                    case 96:
                    case 97:
                    case 98:
                    case 100:
                    case 101:
                    case 102:
                    case 103:
                    case 104:
                        {
                        alt1=1;
                        }
                        break;
                    case STRING:
                        {
                        int LA1_24 = input.LA(3);

                        if ( (synpred1_ObjCpp()) ) {
                            alt1=1;
                        }
                        else if ( (((( next("extern") )&&( next("extern") ))&&synpred3_ObjCpp())) ) {
                            alt1=3;
                        }


                        }
                        break;

                    }

                    }
                    break;
                case LPAREN:
                case SEMICOLON:
                case 36:
                case 38:
                case 51:
                case 52:
                case 65:
                case 68:
                case 74:
                case 78:
                case 80:
                case 82:
                case 83:
                case 86:
                case 89:
                case 92:
                case 94:
                case 96:
                case 97:
                case 98:
                case 103:
                    {
                    alt1=1;
                    }
                    break;
                case 32:
                    {
                    alt1=2;
                    }
                    break;
                case RBRACE:
                    {
                    alt1=4;
                    }
                    break;

                }

                switch (alt1) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:494:7: declaration
            	    {
            	    pushFollow(FOLLOW_declaration_in_sourceFile188);
            	    declaration1=declaration();

            	    state._fsp--;
            	    if (state.failed) return sourceFile;

            	    if ( state.backtracking==0 ) { 
            	            sourceFile.addDeclaration((declaration1!=null?declaration1.declaration:null)); 
            	          }

            	    }
            	    break;
            	case 2 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:497:7: lineDirective
            	    {
            	    pushFollow(FOLLOW_lineDirective_in_sourceFile200);
            	    lineDirective();

            	    state._fsp--;
            	    if (state.failed) return sourceFile;

            	    if ( state.backtracking==0 ) {
            	            if (sourceFile.getElementFile() == null)
            	              sourceFile.setElementFile(getFile());
            	          }

            	    }
            	    break;
            	case 3 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:501:7: {...}? => IDENTIFIER STRING LBRACE
            	    {
            	    if ( !(( next("extern") )) ) {
            	        if (state.backtracking>0) {state.failed=true; return sourceFile;}
            	        throw new FailedPredicateException(input, "sourceFile", " next(\"extern\") ");
            	    }

            	    match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_sourceFile215); if (state.failed) return sourceFile;

            	    match(input,STRING,FOLLOW_STRING_in_sourceFile217); if (state.failed) return sourceFile;

            	    match(input,LBRACE,FOLLOW_LBRACE_in_sourceFile219); if (state.failed) return sourceFile;

            	    }
            	    break;
            	case 4 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:502:7: RBRACE
            	    {
            	    match(input,RBRACE,FOLLOW_RBRACE_in_sourceFile229); if (state.failed) return sourceFile;

            	    }
            	    break;

            	default :
            	    break loop1;
                }
            } while (true);


            match(input,EOF,FOLLOW_EOF_in_sourceFile244); if (state.failed) return sourceFile;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 2, sourceFile_StartIndex); }

            Symbols_stack.pop();

        }
        return sourceFile;
    }
    // $ANTLR end "sourceFile"



    // $ANTLR start "externDeclarations"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:507:1: externDeclarations returns [ExternDeclarations declaration] :{...}? => IDENTIFIER STRING ( LBRACE (ed= declaration | lineDirective )* RBRACE |dd= declaration ) ;
    public final ExternDeclarations externDeclarations() throws RecognitionException {
        ExternDeclarations declaration = null;

        int externDeclarations_StartIndex = input.index();

        Token STRING2=null;
        ObjCppParser.declaration_return ed =null;

        ObjCppParser.declaration_return dd =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 3) ) { return declaration; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:508:3: ({...}? => IDENTIFIER STRING ( LBRACE (ed= declaration | lineDirective )* RBRACE |dd= declaration ) )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:508:6: {...}? => IDENTIFIER STRING ( LBRACE (ed= declaration | lineDirective )* RBRACE |dd= declaration )
            {
            if ( !(( next("extern") )) ) {
                if (state.backtracking>0) {state.failed=true; return declaration;}
                throw new FailedPredicateException(input, "externDeclarations", " next(\"extern\") ");
            }

            match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_externDeclarations266); if (state.failed) return declaration;

            STRING2=(Token)match(input,STRING,FOLLOW_STRING_in_externDeclarations272); if (state.failed) return declaration;

            if ( state.backtracking==0 ) {
                  declaration = mark(new ExternDeclarations(), getLine(STRING2));
                  declaration.setLanguage((STRING2!=null?STRING2.getText():null));
                }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:513:5: ( LBRACE (ed= declaration | lineDirective )* RBRACE |dd= declaration )
            int alt3=2;
            switch ( input.LA(1) ) {
            case LBRACE:
                {
                alt3=1;
                }
                break;
            case IDENTIFIER:
            case LPAREN:
            case SEMICOLON:
            case 36:
            case 38:
            case 51:
            case 52:
            case 65:
            case 68:
            case 74:
            case 78:
            case 80:
            case 82:
            case 83:
            case 86:
            case 89:
            case 92:
            case 94:
            case 96:
            case 97:
            case 98:
            case 103:
                {
                alt3=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return declaration;}
                NoViableAltException nvae =
                    new NoViableAltException("", 3, 0, input);

                throw nvae;

            }

            switch (alt3) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:514:7: LBRACE (ed= declaration | lineDirective )* RBRACE
                    {
                    match(input,LBRACE,FOLLOW_LBRACE_in_externDeclarations288); if (state.failed) return declaration;

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:515:9: (ed= declaration | lineDirective )*
                    loop2:
                    do {
                        int alt2=3;
                        switch ( input.LA(1) ) {
                        case IDENTIFIER:
                        case LPAREN:
                        case SEMICOLON:
                        case 36:
                        case 38:
                        case 51:
                        case 52:
                        case 65:
                        case 68:
                        case 74:
                        case 78:
                        case 80:
                        case 82:
                        case 83:
                        case 86:
                        case 89:
                        case 92:
                        case 94:
                        case 96:
                        case 97:
                        case 98:
                        case 103:
                            {
                            alt2=1;
                            }
                            break;
                        case 32:
                            {
                            alt2=2;
                            }
                            break;

                        }

                        switch (alt2) {
                    	case 1 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:516:11: ed= declaration
                    	    {
                    	    pushFollow(FOLLOW_declaration_in_externDeclarations313);
                    	    ed=declaration();

                    	    state._fsp--;
                    	    if (state.failed) return declaration;

                    	    if ( state.backtracking==0 ) { 
                    	                declaration.addDeclaration((ed!=null?ed.declaration:null)); 
                    	              }

                    	    }
                    	    break;
                    	case 2 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:519:11: lineDirective
                    	    {
                    	    pushFollow(FOLLOW_lineDirective_in_externDeclarations329);
                    	    lineDirective();

                    	    state._fsp--;
                    	    if (state.failed) return declaration;

                    	    }
                    	    break;

                    	default :
                    	    break loop2;
                        }
                    } while (true);


                    match(input,RBRACE,FOLLOW_RBRACE_in_externDeclarations349); if (state.failed) return declaration;

                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:522:7: dd= declaration
                    {
                    pushFollow(FOLLOW_declaration_in_externDeclarations361);
                    dd=declaration();

                    state._fsp--;
                    if (state.failed) return declaration;

                    if ( state.backtracking==0 ) { 
                            declaration.addDeclaration((dd!=null?dd.declaration:null)); 
                            }

                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 3, externDeclarations_StartIndex); }

        }
        return declaration;
    }
    // $ANTLR end "externDeclarations"


    public static class declaration_return extends ParserRuleReturnScope {
        public Declaration declaration;
        public List<Modifier> modifiers;
        public String preComment;
        public int startTokenIndex;
        public Template template;
    };


    // $ANTLR start "declaration"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:528:1: declaration returns [Declaration declaration, List<Modifier> modifiers, String preComment, int startTokenIndex, Template template] : ({...}? IDENTIFIER )? (tp= templatePrefix )? ( ({...}? => pragmaContent | functionDeclaration |{...}? => externDeclarations |{...}? => IDENTIFIER qualifiedIdentifier SEMICOLON | varDecl SEMICOLON | objCClassDef | typeDef | forwardClassDecl | namespaceDecl ) ) ;
    public final ObjCppParser.declaration_return declaration() throws RecognitionException {
        ModContext_stack.push(new ModContext_scope());

        ObjCppParser.declaration_return retval = new ObjCppParser.declaration_return();
        retval.start = input.LT(1);

        int declaration_StartIndex = input.index();

        Template tp =null;

        ObjCppParser.functionDeclaration_return functionDeclaration3 =null;

        ExternDeclarations externDeclarations4 =null;

        VariablesDeclaration varDecl5 =null;

        Struct objCClassDef6 =null;

        TypeDef typeDef7 =null;

        List<Declaration> forwardClassDecl8 =null;

        Namespace namespaceDecl9 =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 4) ) { return retval; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:557:3: ( ({...}? IDENTIFIER )? (tp= templatePrefix )? ( ({...}? => pragmaContent | functionDeclaration |{...}? => externDeclarations |{...}? => IDENTIFIER qualifiedIdentifier SEMICOLON | varDecl SEMICOLON | objCClassDef | typeDef | forwardClassDecl | namespaceDecl ) ) )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:559:5: ({...}? IDENTIFIER )? (tp= templatePrefix )? ( ({...}? => pragmaContent | functionDeclaration |{...}? => externDeclarations |{...}? => IDENTIFIER qualifiedIdentifier SEMICOLON | varDecl SEMICOLON | objCClassDef | typeDef | forwardClassDecl | namespaceDecl ) )
            {
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:559:5: ({...}? IDENTIFIER )?
            int alt4=2;
            switch ( input.LA(1) ) {
                case IDENTIFIER:
                    {
                    int LA4_1 = input.LA(2);

                    if ( (((( next("__extension__") )&&( next("__extension__") ))&&synpred8_ObjCpp())) ) {
                        alt4=1;
                    }
                    }
                    break;
            }

            switch (alt4) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:559:7: {...}? IDENTIFIER
                    {
                    if ( !(( next("__extension__") )) ) {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        throw new FailedPredicateException(input, "declaration", " next(\"__extension__\") ");
                    }

                    match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_declaration418); if (state.failed) return retval;

                    }
                    break;

            }


            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:560:5: (tp= templatePrefix )?
            int alt5=2;
            switch ( input.LA(1) ) {
                case IDENTIFIER:
                    {
                    switch ( input.LA(2) ) {
                        case 53:
                            {
                            int LA5_19 = input.LA(3);

                            if ( (((synpred9_ObjCpp()&&synpred9_ObjCpp())&&( next("template") ))) ) {
                                alt5=1;
                            }
                            }
                            break;
                    }

                    }
                    break;
            }

            switch (alt5) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:560:7: tp= templatePrefix
                    {
                    pushFollow(FOLLOW_templatePrefix_in_declaration431);
                    tp=templatePrefix();

                    state._fsp--;
                    if (state.failed) return retval;

                    if ( state.backtracking==0 ) { retval.template = tp; }

                    }
                    break;

            }


            if ( state.backtracking==0 ) {
                  retval.modifiers = new ArrayList<Modifier>();
                  retval.startTokenIndex = getTokenStream().index();
                  retval.preComment = getCommentBefore(retval.startTokenIndex);
                }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:566:5: ( ({...}? => pragmaContent | functionDeclaration |{...}? => externDeclarations |{...}? => IDENTIFIER qualifiedIdentifier SEMICOLON | varDecl SEMICOLON | objCClassDef | typeDef | forwardClassDecl | namespaceDecl ) )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:567:7: ({...}? => pragmaContent | functionDeclaration |{...}? => externDeclarations |{...}? => IDENTIFIER qualifiedIdentifier SEMICOLON | varDecl SEMICOLON | objCClassDef | typeDef | forwardClassDecl | namespaceDecl )
            {
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:567:7: ({...}? => pragmaContent | functionDeclaration |{...}? => externDeclarations |{...}? => IDENTIFIER qualifiedIdentifier SEMICOLON | varDecl SEMICOLON | objCClassDef | typeDef | forwardClassDecl | namespaceDecl )
            int alt6=9;
            alt6 = dfa6.predict(input);
            switch (alt6) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:568:9: {...}? => pragmaContent
                    {
                    if ( !(( next("__pragma") )) ) {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        throw new FailedPredicateException(input, "declaration", " next(\"__pragma\") ");
                    }

                    pushFollow(FOLLOW_pragmaContent_in_declaration469);
                    pragmaContent();

                    state._fsp--;
                    if (state.failed) return retval;

                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:569:9: functionDeclaration
                    {
                    pushFollow(FOLLOW_functionDeclaration_in_declaration481);
                    functionDeclaration3=functionDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;

                    if ( state.backtracking==0 ) {
                              retval.declaration = (functionDeclaration3!=null?functionDeclaration3.function:null);
                            }

                    }
                    break;
                case 3 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:572:9: {...}? => externDeclarations
                    {
                    if ( !(( next("extern") )) ) {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        throw new FailedPredicateException(input, "declaration", " next(\"extern\") ");
                    }

                    pushFollow(FOLLOW_externDeclarations_in_declaration498);
                    externDeclarations4=externDeclarations();

                    state._fsp--;
                    if (state.failed) return retval;

                    if ( state.backtracking==0 ) {
                              retval.declaration = externDeclarations4; 
                            }

                    }
                    break;
                case 4 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:575:9: {...}? => IDENTIFIER qualifiedIdentifier SEMICOLON
                    {
                    if ( !(( next("using") )) ) {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        throw new FailedPredicateException(input, "declaration", " next(\"using\") ");
                    }

                    match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_declaration515); if (state.failed) return retval;

                    pushFollow(FOLLOW_qualifiedIdentifier_in_declaration517);
                    qualifiedIdentifier();

                    state._fsp--;
                    if (state.failed) return retval;

                    match(input,SEMICOLON,FOLLOW_SEMICOLON_in_declaration519); if (state.failed) return retval;

                    if ( state.backtracking==0 ) {
                              // TODO
                            }

                    }
                    break;
                case 5 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:578:9: varDecl SEMICOLON
                    {
                    pushFollow(FOLLOW_varDecl_in_declaration533);
                    varDecl5=varDecl();

                    state._fsp--;
                    if (state.failed) return retval;

                    match(input,SEMICOLON,FOLLOW_SEMICOLON_in_declaration535); if (state.failed) return retval;

                    if ( state.backtracking==0 ) { 
                              retval.declaration = varDecl5; 
                            }

                    }
                    break;
                case 6 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:581:9: objCClassDef
                    {
                    pushFollow(FOLLOW_objCClassDef_in_declaration549);
                    objCClassDef6=objCClassDef();

                    state._fsp--;
                    if (state.failed) return retval;

                    if ( state.backtracking==0 ) { 
                              retval.declaration = decl(objCClassDef6); 
                            }

                    }
                    break;
                case 7 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:584:9: typeDef
                    {
                    pushFollow(FOLLOW_typeDef_in_declaration563);
                    typeDef7=typeDef();

                    state._fsp--;
                    if (state.failed) return retval;

                    if ( state.backtracking==0 ) {
                              retval.declaration = typeDef7; 
                            }

                    }
                    break;
                case 8 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:587:9: forwardClassDecl
                    {
                    pushFollow(FOLLOW_forwardClassDecl_in_declaration577);
                    forwardClassDecl8=forwardClassDecl();

                    state._fsp--;
                    if (state.failed) return retval;

                    if ( state.backtracking==0 ) {
                              retval.declaration = new Declarations(forwardClassDecl8); 
                            }

                    }
                    break;
                case 9 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:591:9: namespaceDecl
                    {
                    pushFollow(FOLLOW_namespaceDecl_in_declaration600);
                    namespaceDecl9=namespaceDecl();

                    state._fsp--;
                    if (state.failed) return retval;

                    if ( state.backtracking==0 ) {
                              retval.declaration = namespaceDecl9;
                            }

                    }
                    break;

            }


            if ( state.backtracking==0 ) {
                    String commentAfter = getCommentAfterOnSameLine(retval.startTokenIndex, null);
                    if (retval.declaration != null) {
                      retval.declaration.setCommentBefore(retval.preComment);
                      retval.declaration.setCommentAfter(commentAfter);
                      retval.declaration.addModifiers(retval.modifiers);
                    }
                  }

            }


            }

            retval.stop = input.LT(-1);


            if ( state.backtracking==0 ) {
              if (retval.declaration == null)
              try {
                int i = ((Token)retval.start).getTokenIndex();
                if (i > 0) {
                  String s1 = getTokenStream().get(i - 1).getText(), s2 = i > 1 ? getTokenStream().get(i - 2).getText() : null;
                           String s = (s2 == null ? "" : s2) + s1;
                           if (s.matches(".*\n\\s*\n"))
                    retval.declaration = new EmptyDeclaration();
                }  
              } catch (Exception ex) {
                ex.printStackTrace();
              }
              if (retval.template != null) {
                retval.template.setDeclaration(retval.declaration);
                if (retval.declaration instanceof TaggedTypeRefDeclaration) {
                  TaggedTypeRefDeclaration ttrd = (TaggedTypeRefDeclaration)retval.declaration;
                  TaggedTypeRef ttr = (TaggedTypeRef)ttrd.getTaggedTypeRef();
                  if (ttr != ttr)
                    defineTypeIdentifierInParentScope(ttr.getTag());
                }
                retval.declaration = retval.template;
              }
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 4, declaration_StartIndex); }

            ModContext_stack.pop();

        }
        return retval;
    }
    // $ANTLR end "declaration"



    // $ANTLR start "namespaceDecl"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:607:1: namespaceDecl returns [Namespace namespace] : 'namespace' ns= IDENTIFIER LBRACE (subD= declaration | lineDirective )* RBRACE ;
    public final Namespace namespaceDecl() throws RecognitionException {
        Namespace namespace = null;

        int namespaceDecl_StartIndex = input.index();

        Token ns=null;
        ObjCppParser.declaration_return subD =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 5) ) { return namespace; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:608:3: ( 'namespace' ns= IDENTIFIER LBRACE (subD= declaration | lineDirective )* RBRACE )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:609:5: 'namespace' ns= IDENTIFIER LBRACE (subD= declaration | lineDirective )* RBRACE
            {
            match(input,92,FOLLOW_92_in_namespaceDecl656); if (state.failed) return namespace;

            ns=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_namespaceDecl660); if (state.failed) return namespace;

            match(input,LBRACE,FOLLOW_LBRACE_in_namespaceDecl662); if (state.failed) return namespace;

            if ( state.backtracking==0 ) {
                  namespace = new Namespace();
                  namespace.setName(new SimpleIdentifier((ns!=null?ns.getText():null)));
                }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:613:5: (subD= declaration | lineDirective )*
            loop7:
            do {
                int alt7=3;
                switch ( input.LA(1) ) {
                case IDENTIFIER:
                case LPAREN:
                case SEMICOLON:
                case 36:
                case 38:
                case 51:
                case 52:
                case 65:
                case 68:
                case 74:
                case 78:
                case 80:
                case 82:
                case 83:
                case 86:
                case 89:
                case 92:
                case 94:
                case 96:
                case 97:
                case 98:
                case 103:
                    {
                    alt7=1;
                    }
                    break;
                case 32:
                    {
                    alt7=2;
                    }
                    break;

                }

                switch (alt7) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:614:7: subD= declaration
            	    {
            	    pushFollow(FOLLOW_declaration_in_namespaceDecl680);
            	    subD=declaration();

            	    state._fsp--;
            	    if (state.failed) return namespace;

            	    if ( state.backtracking==0 ) {
            	            namespace.addDeclaration((subD!=null?subD.declaration:null));
            	          }

            	    }
            	    break;
            	case 2 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:617:7: lineDirective
            	    {
            	    pushFollow(FOLLOW_lineDirective_in_namespaceDecl692);
            	    lineDirective();

            	    state._fsp--;
            	    if (state.failed) return namespace;

            	    }
            	    break;

            	default :
            	    break loop7;
                }
            } while (true);


            match(input,RBRACE,FOLLOW_RBRACE_in_namespaceDecl705); if (state.failed) return namespace;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 5, namespaceDecl_StartIndex); }

        }
        return namespace;
    }
    // $ANTLR end "namespaceDecl"



    // $ANTLR start "forwardClassDecl"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:622:1: forwardClassDecl returns [List<Declaration> declarations] : '@class' n1= IDENTIFIER ( COMMA nx= IDENTIFIER )* SEMICOLON ;
    public final List<Declaration> forwardClassDecl() throws RecognitionException {
        List<Declaration> declarations = null;

        int forwardClassDecl_StartIndex = input.index();

        Token n1=null;
        Token nx=null;

        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 6) ) { return declarations; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:623:3: ( '@class' n1= IDENTIFIER ( COMMA nx= IDENTIFIER )* SEMICOLON )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:623:7: '@class' n1= IDENTIFIER ( COMMA nx= IDENTIFIER )* SEMICOLON
            {
            if ( state.backtracking==0 ) { declarations = new ArrayList<Declaration>(); }

            match(input,65,FOLLOW_65_in_forwardClassDecl732); if (state.failed) return declarations;

            n1=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_forwardClassDecl741); if (state.failed) return declarations;

            if ( state.backtracking==0 ) { 
                  declarations.add(decl(Struct.forwardDecl(new SimpleIdentifier((n1!=null?n1.getText():null)), Struct.Type.ObjCClass))); 
                  defineTypeIdentifierInParentScope((n1!=null?n1.getText():null));
                }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:629:5: ( COMMA nx= IDENTIFIER )*
            loop8:
            do {
                int alt8=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt8=1;
                    }
                    break;

                }

                switch (alt8) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:629:6: COMMA nx= IDENTIFIER
            	    {
            	    match(input,COMMA,FOLLOW_COMMA_in_forwardClassDecl750); if (state.failed) return declarations;

            	    nx=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_forwardClassDecl759); if (state.failed) return declarations;

            	    if ( state.backtracking==0 ) { 
            	          declarations.add(decl(Struct.forwardDecl(new SimpleIdentifier((nx!=null?nx.getText():null)), Struct.Type.ObjCClass))); 
            	          defineTypeIdentifierInParentScope((nx!=null?nx.getText():null));
            	        }

            	    }
            	    break;

            	default :
            	    break loop8;
                }
            } while (true);


            match(input,SEMICOLON,FOLLOW_SEMICOLON_in_forwardClassDecl774); if (state.failed) return declarations;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 6, forwardClassDecl_StartIndex); }

        }
        return declarations;
    }
    // $ANTLR end "forwardClassDecl"



    // $ANTLR start "functionPointerVarDecl"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:638:1: functionPointerVarDecl returns [Declaration decl] : tr= mutableTypeRef {...}? SEMICOLON ;
    public final Declaration functionPointerVarDecl() throws RecognitionException {
        Declaration decl = null;

        int functionPointerVarDecl_StartIndex = input.index();

        TypeRef tr =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 7) ) { return decl; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:639:3: (tr= mutableTypeRef {...}? SEMICOLON )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:639:6: tr= mutableTypeRef {...}? SEMICOLON
            {
            pushFollow(FOLLOW_mutableTypeRef_in_functionPointerVarDecl798);
            tr=mutableTypeRef();

            state._fsp--;
            if (state.failed) return decl;

            if ( !((
                  (tr instanceof FunctionSignature) && 
                  ((FunctionSignature)tr).getFunction().getName() != null
                )) ) {
                if (state.backtracking>0) {state.failed=true; return decl;}
                throw new FailedPredicateException(input, "functionPointerVarDecl", "\n      ($tr.type instanceof FunctionSignature) && \n      ((FunctionSignature)$tr.type).getFunction().getName() != null\n    ");
            }

            if ( state.backtracking==0 ) {
                  decl = new FunctionPointerDeclaration(((FunctionSignature)tr));
                }

            match(input,SEMICOLON,FOLLOW_SEMICOLON_in_functionPointerVarDecl808); if (state.failed) return decl;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 7, functionPointerVarDecl_StartIndex); }

        }
        return decl;
    }
    // $ANTLR end "functionPointerVarDecl"


    public static class enumItem_return extends ParserRuleReturnScope {
        public Enum.EnumItem item;
    };


    // $ANTLR start "enumItem"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:648:1: enumItem returns [Enum.EnumItem item] : n= IDENTIFIER ( '=' v= topLevelExpr )? ;
    public final ObjCppParser.enumItem_return enumItem() throws RecognitionException {
        ObjCppParser.enumItem_return retval = new ObjCppParser.enumItem_return();
        retval.start = input.LT(1);

        int enumItem_StartIndex = input.index();

        Token n=null;
        ObjCppParser.topLevelExpr_return v =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 8) ) { return retval; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:649:3: (n= IDENTIFIER ( '=' v= topLevelExpr )? )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:649:6: n= IDENTIFIER ( '=' v= topLevelExpr )?
            {
            n=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_enumItem830); if (state.failed) return retval;

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:649:19: ( '=' v= topLevelExpr )?
            int alt9=2;
            switch ( input.LA(1) ) {
                case 57:
                    {
                    alt9=1;
                    }
                    break;
            }

            switch (alt9) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:649:20: '=' v= topLevelExpr
                    {
                    match(input,57,FOLLOW_57_in_enumItem833); if (state.failed) return retval;

                    pushFollow(FOLLOW_topLevelExpr_in_enumItem837);
                    v=topLevelExpr();

                    state._fsp--;
                    if (state.failed) return retval;

                    }
                    break;

            }


            if ( state.backtracking==0 ) {
                  retval.item = mark(new Enum.EnumItem((n!=null?n.getText():null), (v!=null?input.toString(v.start,v.stop):null) == null ? null : (v!=null?v.expr:null)), getLine(n));
                  retval.item.setCommentBefore(getCommentBefore(n.getTokenIndex()));
                  retval.item.setCommentAfter(getCommentAfterOnSameLine(n.getTokenIndex() - 1, "}"));
                }

            }

            retval.stop = input.LT(-1);


        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 8, enumItem_StartIndex); }

        }
        return retval;
    }
    // $ANTLR end "enumItem"



    // $ANTLR start "enumBody"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:656:1: enumBody returns [Enum e] : LBRACE (i1= enumItem ( COMMA (ix= enumItem )? )* )? RBRACE ;
    public final Enum enumBody() throws RecognitionException {
        ModContext_stack.push(new ModContext_scope());

        Enum e = null;

        int enumBody_StartIndex = input.index();

        ObjCppParser.enumItem_return i1 =null;

        ObjCppParser.enumItem_return ix =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 9) ) { return e; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:658:3: ( LBRACE (i1= enumItem ( COMMA (ix= enumItem )? )* )? RBRACE )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:659:5: LBRACE (i1= enumItem ( COMMA (ix= enumItem )? )* )? RBRACE
            {
            if ( state.backtracking==0 ) { 
                  e = new Enum();
                        e.setType(Enum.Type.C);
                  e.setForwardDeclaration(false); 
                }

            match(input,LBRACE,FOLLOW_LBRACE_in_enumBody875); if (state.failed) return e;

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:665:7: (i1= enumItem ( COMMA (ix= enumItem )? )* )?
            int alt12=2;
            switch ( input.LA(1) ) {
                case IDENTIFIER:
                    {
                    alt12=1;
                    }
                    break;
            }

            switch (alt12) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:666:9: i1= enumItem ( COMMA (ix= enumItem )? )*
                    {
                    pushFollow(FOLLOW_enumItem_in_enumBody898);
                    i1=enumItem();

                    state._fsp--;
                    if (state.failed) return e;

                    if ( state.backtracking==0 ) { 
                              if ((i1!=null?input.toString(i1.start,i1.stop):null) != null)
                                e.addItem((i1!=null?i1.item:null)); 
                            }

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:670:9: ( COMMA (ix= enumItem )? )*
                    loop11:
                    do {
                        int alt11=2;
                        switch ( input.LA(1) ) {
                        case COMMA:
                            {
                            alt11=1;
                            }
                            break;

                        }

                        switch (alt11) {
                    	case 1 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:671:11: COMMA (ix= enumItem )?
                    	    {
                    	    match(input,COMMA,FOLLOW_COMMA_in_enumBody922); if (state.failed) return e;

                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:672:11: (ix= enumItem )?
                    	    int alt10=2;
                    	    switch ( input.LA(1) ) {
                    	        case IDENTIFIER:
                    	            {
                    	            alt10=1;
                    	            }
                    	            break;
                    	    }

                    	    switch (alt10) {
                    	        case 1 :
                    	            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:672:12: ix= enumItem
                    	            {
                    	            pushFollow(FOLLOW_enumItem_in_enumBody938);
                    	            ix=enumItem();

                    	            state._fsp--;
                    	            if (state.failed) return e;

                    	            if ( state.backtracking==0 ) { 
                    	                        if ((ix!=null?input.toString(ix.start,ix.stop):null) != null)
                    	                          e.addItem((ix!=null?ix.item:null)); 
                    	                      }

                    	            }
                    	            break;

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop11;
                        }
                    } while (true);


                    }
                    break;

            }


            match(input,RBRACE,FOLLOW_RBRACE_in_enumBody968); if (state.failed) return e;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 9, enumBody_StartIndex); }

            ModContext_stack.pop();

        }
        return e;
    }
    // $ANTLR end "enumBody"



    // $ANTLR start "enumCore"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:680:1: enumCore returns [Enum e] : t= 'enum' ( (m1= modifiers )? ( ( ':' IDENTIFIER )? ab= enumBody |tag= qualifiedIdentifier ( (m2= modifiers )? ( ':' IDENTIFIER )? nb= enumBody |) ) ) ;
    public final Enum enumCore() throws RecognitionException {
        Enum e = null;

        int enumCore_StartIndex = input.index();

        Token t=null;
        List<Modifier> m1 =null;

        Enum ab =null;

        Identifier tag =null;

        List<Modifier> m2 =null;

        Enum nb =null;



          List<Modifier> modifiers = new ArrayList<Modifier>();

        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 10) ) { return e; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:684:3: (t= 'enum' ( (m1= modifiers )? ( ( ':' IDENTIFIER )? ab= enumBody |tag= qualifiedIdentifier ( (m2= modifiers )? ( ':' IDENTIFIER )? nb= enumBody |) ) ) )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:685:5: t= 'enum' ( (m1= modifiers )? ( ( ':' IDENTIFIER )? ab= enumBody |tag= qualifiedIdentifier ( (m2= modifiers )? ( ':' IDENTIFIER )? nb= enumBody |) ) )
            {
            t=(Token)match(input,89,FOLLOW_89_in_enumCore995); if (state.failed) return e;

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:686:5: ( (m1= modifiers )? ( ( ':' IDENTIFIER )? ab= enumBody |tag= qualifiedIdentifier ( (m2= modifiers )? ( ':' IDENTIFIER )? nb= enumBody |) ) )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:687:7: (m1= modifiers )? ( ( ':' IDENTIFIER )? ab= enumBody |tag= qualifiedIdentifier ( (m2= modifiers )? ( ':' IDENTIFIER )? nb= enumBody |) )
            {
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:687:7: (m1= modifiers )?
            int alt13=2;
            switch ( input.LA(1) ) {
                case IDENTIFIER:
                    {
                    switch ( input.LA(2) ) {
                        case LPAREN:
                            {
                            int LA13_6 = input.LA(3);

                            if ( ((((( next("__pragma") )||( next("__asm") )||( next("__success") )||( next(ModifierKind.VCAnnotation1Arg, ModifierKind.VCAnnotation2Args) ))&&(( next("__pragma") )||( next("__asm") )||( next("__success") )||( next(ModifierKind.VCAnnotation1Arg, ModifierKind.VCAnnotation2Args) )))&&synpred25_ObjCpp())) ) {
                                alt13=1;
                            }
                            }
                            break;
                        case STRING:
                            {
                            int LA13_7 = input.LA(3);

                            if ( (((( next("extern") )&&( next("extern") ))&&synpred25_ObjCpp())) ) {
                                alt13=1;
                            }
                            }
                            break;
                        case IDENTIFIER:
                            {
                            int LA13_8 = input.LA(3);

                            if ( (((( parseModifier(next()) != null )&&( parseModifier(next()) != null ))&&synpred25_ObjCpp())) ) {
                                alt13=1;
                            }
                            }
                            break;
                        case 82:
                        case 83:
                            {
                            int LA13_9 = input.LA(3);

                            if ( (((( parseModifier(next()) != null )&&( parseModifier(next()) != null ))&&synpred25_ObjCpp())) ) {
                                alt13=1;
                            }
                            }
                            break;
                        case 51:
                            {
                            int LA13_10 = input.LA(3);

                            if ( (((( parseModifier(next()) != null )&&( parseModifier(next()) != null ))&&synpred25_ObjCpp())) ) {
                                alt13=1;
                            }
                            }
                            break;
                        case LBRACE:
                            {
                            int LA13_11 = input.LA(3);

                            if ( (((( parseModifier(next()) != null )&&( parseModifier(next()) != null ))&&synpred25_ObjCpp())) ) {
                                alt13=1;
                            }
                            }
                            break;
                        case 52:
                            {
                            int LA13_12 = input.LA(3);

                            if ( (((( parseModifier(next()) != null )&&( parseModifier(next()) != null ))&&synpred25_ObjCpp())) ) {
                                alt13=1;
                            }
                            }
                            break;
                    }

                    }
                    break;
                case 82:
                case 83:
                    {
                    alt13=1;
                    }
                    break;
            }

            switch (alt13) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:687:9: m1= modifiers
                    {
                    pushFollow(FOLLOW_modifiers_in_enumCore1013);
                    m1=modifiers();

                    state._fsp--;
                    if (state.failed) return e;

                    if ( state.backtracking==0 ) { modifiers.addAll(m1); }

                    }
                    break;

            }


            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:688:7: ( ( ':' IDENTIFIER )? ab= enumBody |tag= qualifiedIdentifier ( (m2= modifiers )? ( ':' IDENTIFIER )? nb= enumBody |) )
            int alt18=2;
            switch ( input.LA(1) ) {
            case LBRACE:
            case 51:
                {
                alt18=1;
                }
                break;
            case IDENTIFIER:
            case 52:
                {
                alt18=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return e;}
                NoViableAltException nvae =
                    new NoViableAltException("", 18, 0, input);

                throw nvae;

            }

            switch (alt18) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:689:8: ( ':' IDENTIFIER )? ab= enumBody
                    {
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:689:8: ( ':' IDENTIFIER )?
                    int alt14=2;
                    switch ( input.LA(1) ) {
                        case 51:
                            {
                            alt14=1;
                            }
                            break;
                    }

                    switch (alt14) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:689:10: ':' IDENTIFIER
                            {
                            match(input,51,FOLLOW_51_in_enumCore1037); if (state.failed) return e;

                            match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_enumCore1039); if (state.failed) return e;

                            }
                            break;

                    }


                    pushFollow(FOLLOW_enumBody_in_enumCore1054);
                    ab=enumBody();

                    state._fsp--;
                    if (state.failed) return e;

                    if ( state.backtracking==0 ) {
                              e = ab;
                              e.setForwardDeclaration(false);
                            }

                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:694:9: tag= qualifiedIdentifier ( (m2= modifiers )? ( ':' IDENTIFIER )? nb= enumBody |)
                    {
                    pushFollow(FOLLOW_qualifiedIdentifier_in_enumCore1070);
                    tag=qualifiedIdentifier();

                    state._fsp--;
                    if (state.failed) return e;

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:695:9: ( (m2= modifiers )? ( ':' IDENTIFIER )? nb= enumBody |)
                    int alt17=2;
                    alt17 = dfa17.predict(input);
                    switch (alt17) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:696:11: (m2= modifiers )? ( ':' IDENTIFIER )? nb= enumBody
                            {
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:696:11: (m2= modifiers )?
                            int alt15=2;
                            switch ( input.LA(1) ) {
                                case IDENTIFIER:
                                case 82:
                                case 83:
                                    {
                                    alt15=1;
                                    }
                                    break;
                            }

                            switch (alt15) {
                                case 1 :
                                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:696:13: m2= modifiers
                                    {
                                    pushFollow(FOLLOW_modifiers_in_enumCore1096);
                                    m2=modifiers();

                                    state._fsp--;
                                    if (state.failed) return e;

                                    if ( state.backtracking==0 ) { modifiers.addAll(m2); }

                                    }
                                    break;

                            }


                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:697:11: ( ':' IDENTIFIER )?
                            int alt16=2;
                            switch ( input.LA(1) ) {
                                case 51:
                                    {
                                    alt16=1;
                                    }
                                    break;
                            }

                            switch (alt16) {
                                case 1 :
                                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:697:13: ':' IDENTIFIER
                                    {
                                    match(input,51,FOLLOW_51_in_enumCore1115); if (state.failed) return e;

                                    match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_enumCore1117); if (state.failed) return e;

                                    }
                                    break;

                            }


                            pushFollow(FOLLOW_enumBody_in_enumCore1134);
                            nb=enumBody();

                            state._fsp--;
                            if (state.failed) return e;

                            if ( state.backtracking==0 ) {
                                        e = nb;
                                        e.setForwardDeclaration(false);
                                      }

                            }
                            break;
                        case 2 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:701:15: 
                            {
                            if ( state.backtracking==0 ) {
                                        e = new Enum();
                                                    e.setType(Enum.Type.C);
                                        e.setForwardDeclaration(true);
                                      }

                            }
                            break;

                    }


                    if ( state.backtracking==0 ) {
                              e.setTag(tag);
                            }

                    }
                    break;

            }


            }


            if ( state.backtracking==0 ) {
                  //e.setCommentBefore(getCommentBefore(t.getTokenIndex()));
                  e = mark(e, getLine(t));
                  e.addModifiers(modifiers);
                  defineTypeIdentifierInParentScope(e.getTag());
                }

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 10, enumCore_StartIndex); }

        }
        return e;
    }
    // $ANTLR end "enumCore"



    // $ANTLR start "objCClassDef"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:719:1: objCClassDef returns [Struct struct] : octype= ( '@protocol' | '@interface' ) className= IDENTIFIER ( ( ':' parentClass= IDENTIFIER ) | ( LPAREN categoryName= IDENTIFIER RPAREN ) |) ( '<' (p1= IDENTIFIER ( COMMA px= IDENTIFIER )* )? '>' )? ( LBRACE ( '@package' | '@public' | '@private' | '@protected' | ( functionPointerOrSimpleVarDecl SEMICOLON ) | lineDirective )* RBRACE )? ( '@required' | '@optional' | objCMethodDecl | objCPropertyDecl | typeDef |vd= varDecl SEMICOLON | lineDirective )* '@end' ;
    public final Struct objCClassDef() throws RecognitionException {
        Struct struct = null;

        int objCClassDef_StartIndex = input.index();

        Token octype=null;
        Token className=null;
        Token parentClass=null;
        Token categoryName=null;
        Token p1=null;
        Token px=null;
        VariablesDeclaration vd =null;

        Declaration functionPointerOrSimpleVarDecl10 =null;

        Function objCMethodDecl11 =null;

        Property objCPropertyDecl12 =null;

        TypeDef typeDef13 =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 11) ) { return struct; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:720:3: (octype= ( '@protocol' | '@interface' ) className= IDENTIFIER ( ( ':' parentClass= IDENTIFIER ) | ( LPAREN categoryName= IDENTIFIER RPAREN ) |) ( '<' (p1= IDENTIFIER ( COMMA px= IDENTIFIER )* )? '>' )? ( LBRACE ( '@package' | '@public' | '@private' | '@protected' | ( functionPointerOrSimpleVarDecl SEMICOLON ) | lineDirective )* RBRACE )? ( '@required' | '@optional' | objCMethodDecl | objCPropertyDecl | typeDef |vd= varDecl SEMICOLON | lineDirective )* '@end' )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:721:5: octype= ( '@protocol' | '@interface' ) className= IDENTIFIER ( ( ':' parentClass= IDENTIFIER ) | ( LPAREN categoryName= IDENTIFIER RPAREN ) |) ( '<' (p1= IDENTIFIER ( COMMA px= IDENTIFIER )* )? '>' )? ( LBRACE ( '@package' | '@public' | '@private' | '@protected' | ( functionPointerOrSimpleVarDecl SEMICOLON ) | lineDirective )* RBRACE )? ( '@required' | '@optional' | objCMethodDecl | objCPropertyDecl | typeDef |vd= varDecl SEMICOLON | lineDirective )* '@end'
            {
            octype=(Token)input.LT(1);

            if ( input.LA(1)==68||input.LA(1)==74 ) {
                input.consume();
                state.errorRecovery=false;
                state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return struct;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            className=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_objCClassDef1213); if (state.failed) return struct;

            if ( state.backtracking==0 ) {
                  defineTypeIdentifierInParentScope((className!=null?className.getText():null));
                  struct = mark(new Struct(), getLine(octype));
                  //struct.setForwardDeclaration(true);
                  //struct.setCommentBefore(getCommentBefore(octype.getTokenIndex()));
                  struct.setType((octype!=null?octype.getText():null).equals("@interface") ?
                    Struct.Type.ObjCClass :
                    Struct.Type.ObjCProtocol
                  );
                  struct.setTag(new SimpleIdentifier((className!=null?className.getText():null)));
                }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:733:5: ( ( ':' parentClass= IDENTIFIER ) | ( LPAREN categoryName= IDENTIFIER RPAREN ) |)
            int alt19=3;
            switch ( input.LA(1) ) {
            case 51:
                {
                switch ( input.LA(2) ) {
                case IDENTIFIER:
                    {
                    alt19=1;
                    }
                    break;
                case DECIMAL_NUMBER:
                    {
                    alt19=3;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return struct;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 19, 1, input);

                    throw nvae;

                }

                }
                break;
            case LPAREN:
                {
                switch ( input.LA(2) ) {
                case IDENTIFIER:
                    {
                    int LA19_23 = input.LA(3);

                    if ( (synpred33_ObjCpp()) ) {
                        alt19=2;
                    }
                    else if ( (true) ) {
                        alt19=3;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return struct;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 19, 23, input);

                        throw nvae;

                    }
                    }
                    break;
                case LPAREN:
                case 36:
                case 38:
                case 51:
                case 80:
                case 82:
                case 83:
                    {
                    alt19=3;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return struct;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 19, 2, input);

                    throw nvae;

                }

                }
                break;
            case IDENTIFIER:
            case LBRACE:
            case SEMICOLON:
            case 32:
            case 36:
            case 38:
            case 40:
            case 43:
            case 52:
            case 53:
            case 67:
            case 69:
            case 72:
            case 76:
            case 80:
            case 82:
            case 83:
            case 86:
            case 89:
            case 94:
            case 96:
            case 97:
            case 98:
                {
                alt19=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return struct;}
                NoViableAltException nvae =
                    new NoViableAltException("", 19, 0, input);

                throw nvae;

            }

            switch (alt19) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:734:7: ( ':' parentClass= IDENTIFIER )
                    {
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:734:7: ( ':' parentClass= IDENTIFIER )
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:735:9: ':' parentClass= IDENTIFIER
                    {
                    match(input,51,FOLLOW_51_in_objCClassDef1241); if (state.failed) return struct;

                    parentClass=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_objCClassDef1245); if (state.failed) return struct;

                    if ( state.backtracking==0 ) {
                            if ((parentClass!=null?parentClass.getText():null) != null)
                              struct.addParent(new SimpleIdentifier((parentClass!=null?parentClass.getText():null)));
                            }

                    }


                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:740:7: ( LPAREN categoryName= IDENTIFIER RPAREN )
                    {
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:740:7: ( LPAREN categoryName= IDENTIFIER RPAREN )
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:741:9: LPAREN categoryName= IDENTIFIER RPAREN
                    {
                    match(input,LPAREN,FOLLOW_LPAREN_in_objCClassDef1275); if (state.failed) return struct;

                    categoryName=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_objCClassDef1279); if (state.failed) return struct;

                    match(input,RPAREN,FOLLOW_RPAREN_in_objCClassDef1281); if (state.failed) return struct;

                    if ( state.backtracking==0 ) {
                              struct.setCategoryName((categoryName!=null?categoryName.getText():null));
                            }

                    }


                    }
                    break;
                case 3 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:745:5: 
                    {
                    }
                    break;

            }


            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:746:5: ( '<' (p1= IDENTIFIER ( COMMA px= IDENTIFIER )* )? '>' )?
            int alt22=2;
            switch ( input.LA(1) ) {
                case 53:
                    {
                    alt22=1;
                    }
                    break;
            }

            switch (alt22) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:747:7: '<' (p1= IDENTIFIER ( COMMA px= IDENTIFIER )* )? '>'
                    {
                    match(input,53,FOLLOW_53_in_objCClassDef1315); if (state.failed) return struct;

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:747:11: (p1= IDENTIFIER ( COMMA px= IDENTIFIER )* )?
                    int alt21=2;
                    switch ( input.LA(1) ) {
                        case IDENTIFIER:
                            {
                            alt21=1;
                            }
                            break;
                    }

                    switch (alt21) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:748:9: p1= IDENTIFIER ( COMMA px= IDENTIFIER )*
                            {
                            p1=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_objCClassDef1329); if (state.failed) return struct;

                            if ( state.backtracking==0 ) { struct.addProtocol(new SimpleIdentifier((p1!=null?p1.getText():null))); }

                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:749:9: ( COMMA px= IDENTIFIER )*
                            loop20:
                            do {
                                int alt20=2;
                                switch ( input.LA(1) ) {
                                case COMMA:
                                    {
                                    alt20=1;
                                    }
                                    break;

                                }

                                switch (alt20) {
                            	case 1 :
                            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:750:11: COMMA px= IDENTIFIER
                            	    {
                            	    match(input,COMMA,FOLLOW_COMMA_in_objCClassDef1353); if (state.failed) return struct;

                            	    px=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_objCClassDef1368); if (state.failed) return struct;

                            	    if ( state.backtracking==0 ) { struct.addProtocol(new SimpleIdentifier((px!=null?px.getText():null))); }

                            	    }
                            	    break;

                            	default :
                            	    break loop20;
                                }
                            } while (true);


                            }
                            break;

                    }


                    match(input,59,FOLLOW_59_in_objCClassDef1392); if (state.failed) return struct;

                    }
                    break;

            }


            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:755:5: ( LBRACE ( '@package' | '@public' | '@private' | '@protected' | ( functionPointerOrSimpleVarDecl SEMICOLON ) | lineDirective )* RBRACE )?
            int alt24=2;
            switch ( input.LA(1) ) {
                case LBRACE:
                    {
                    alt24=1;
                    }
                    break;
            }

            switch (alt24) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:756:7: LBRACE ( '@package' | '@public' | '@private' | '@protected' | ( functionPointerOrSimpleVarDecl SEMICOLON ) | lineDirective )* RBRACE
                    {
                    match(input,LBRACE,FOLLOW_LBRACE_in_objCClassDef1413); if (state.failed) return struct;

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:757:7: ( '@package' | '@public' | '@private' | '@protected' | ( functionPointerOrSimpleVarDecl SEMICOLON ) | lineDirective )*
                    loop23:
                    do {
                        int alt23=7;
                        switch ( input.LA(1) ) {
                        case 70:
                            {
                            alt23=1;
                            }
                            break;
                        case 75:
                            {
                            alt23=2;
                            }
                            break;
                        case 71:
                            {
                            alt23=3;
                            }
                            break;
                        case 73:
                            {
                            alt23=4;
                            }
                            break;
                        case IDENTIFIER:
                        case LPAREN:
                        case SEMICOLON:
                        case 36:
                        case 38:
                        case 51:
                        case 52:
                        case 78:
                        case 80:
                        case 82:
                        case 83:
                        case 86:
                        case 89:
                        case 94:
                        case 97:
                        case 98:
                            {
                            alt23=5;
                            }
                            break;
                        case 32:
                            {
                            alt23=6;
                            }
                            break;

                        }

                        switch (alt23) {
                    	case 1 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:758:9: '@package'
                    	    {
                    	    match(input,70,FOLLOW_70_in_objCClassDef1431); if (state.failed) return struct;

                    	    }
                    	    break;
                    	case 2 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:759:9: '@public'
                    	    {
                    	    match(input,75,FOLLOW_75_in_objCClassDef1444); if (state.failed) return struct;

                    	    if ( state.backtracking==0 ) { struct.setNextMemberVisibility(Struct.MemberVisibility.Public); }

                    	    }
                    	    break;
                    	case 3 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:760:9: '@private'
                    	    {
                    	    match(input,71,FOLLOW_71_in_objCClassDef1459); if (state.failed) return struct;

                    	    if ( state.backtracking==0 ) { struct.setNextMemberVisibility(Struct.MemberVisibility.Private); }

                    	    }
                    	    break;
                    	case 4 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:761:9: '@protected'
                    	    {
                    	    match(input,73,FOLLOW_73_in_objCClassDef1474); if (state.failed) return struct;

                    	    if ( state.backtracking==0 ) { struct.setNextMemberVisibility(Struct.MemberVisibility.Protected); }

                    	    }
                    	    break;
                    	case 5 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:762:9: ( functionPointerOrSimpleVarDecl SEMICOLON )
                    	    {
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:762:9: ( functionPointerOrSimpleVarDecl SEMICOLON )
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:763:11: functionPointerOrSimpleVarDecl SEMICOLON
                    	    {
                    	    pushFollow(FOLLOW_functionPointerOrSimpleVarDecl_in_objCClassDef1500);
                    	    functionPointerOrSimpleVarDecl10=functionPointerOrSimpleVarDecl();

                    	    state._fsp--;
                    	    if (state.failed) return struct;

                    	    match(input,SEMICOLON,FOLLOW_SEMICOLON_in_objCClassDef1502); if (state.failed) return struct;

                    	    if ( state.backtracking==0 ) {
                    	                struct.addDeclaration(functionPointerOrSimpleVarDecl10);
                    	              }

                    	    }


                    	    }
                    	    break;
                    	case 6 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:767:9: lineDirective
                    	    {
                    	    pushFollow(FOLLOW_lineDirective_in_objCClassDef1526);
                    	    lineDirective();

                    	    state._fsp--;
                    	    if (state.failed) return struct;

                    	    }
                    	    break;

                    	default :
                    	    break loop23;
                        }
                    } while (true);


                    match(input,RBRACE,FOLLOW_RBRACE_in_objCClassDef1544); if (state.failed) return struct;

                    }
                    break;

            }


            if ( state.backtracking==0 ) { struct.setNextMemberVisibility(Struct.MemberVisibility.Public); }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:772:5: ( '@required' | '@optional' | objCMethodDecl | objCPropertyDecl | typeDef |vd= varDecl SEMICOLON | lineDirective )*
            loop25:
            do {
                int alt25=8;
                switch ( input.LA(1) ) {
                case 76:
                    {
                    alt25=1;
                    }
                    break;
                case 69:
                    {
                    alt25=2;
                    }
                    break;
                case 40:
                case 43:
                    {
                    alt25=3;
                    }
                    break;
                case 72:
                    {
                    alt25=4;
                    }
                    break;
                case 96:
                    {
                    alt25=5;
                    }
                    break;
                case IDENTIFIER:
                case LPAREN:
                case SEMICOLON:
                case 36:
                case 38:
                case 51:
                case 52:
                case 80:
                case 82:
                case 83:
                case 86:
                case 89:
                case 94:
                case 97:
                case 98:
                    {
                    alt25=6;
                    }
                    break;
                case 32:
                    {
                    alt25=7;
                    }
                    break;

                }

                switch (alt25) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:773:9: '@required'
            	    {
            	    match(input,76,FOLLOW_76_in_objCClassDef1573); if (state.failed) return struct;

            	    }
            	    break;
            	case 2 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:774:9: '@optional'
            	    {
            	    match(input,69,FOLLOW_69_in_objCClassDef1586); if (state.failed) return struct;

            	    }
            	    break;
            	case 3 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:775:7: objCMethodDecl
            	    {
            	    pushFollow(FOLLOW_objCMethodDecl_in_objCClassDef1597);
            	    objCMethodDecl11=objCMethodDecl();

            	    state._fsp--;
            	    if (state.failed) return struct;

            	    if ( state.backtracking==0 ) { 
            	            struct.addDeclaration(objCMethodDecl11);
            	          }

            	    }
            	    break;
            	case 4 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:778:7: objCPropertyDecl
            	    {
            	    pushFollow(FOLLOW_objCPropertyDecl_in_objCClassDef1609);
            	    objCPropertyDecl12=objCPropertyDecl();

            	    state._fsp--;
            	    if (state.failed) return struct;

            	    if ( state.backtracking==0 ) {
            	            struct.addDeclaration(objCPropertyDecl12); 
            	          }

            	    }
            	    break;
            	case 5 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:781:7: typeDef
            	    {
            	    pushFollow(FOLLOW_typeDef_in_objCClassDef1621);
            	    typeDef13=typeDef();

            	    state._fsp--;
            	    if (state.failed) return struct;

            	    if ( state.backtracking==0 ) {
            	            struct.addDeclaration(typeDef13); 
            	          }

            	    }
            	    break;
            	case 6 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:784:7: vd= varDecl SEMICOLON
            	    {
            	    pushFollow(FOLLOW_varDecl_in_objCClassDef1635);
            	    vd=varDecl();

            	    state._fsp--;
            	    if (state.failed) return struct;

            	    match(input,SEMICOLON,FOLLOW_SEMICOLON_in_objCClassDef1637); if (state.failed) return struct;

            	    if ( state.backtracking==0 ) {
            	            struct.addDeclaration(vd);
            	          }

            	    }
            	    break;
            	case 7 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:787:7: lineDirective
            	    {
            	    pushFollow(FOLLOW_lineDirective_in_objCClassDef1649);
            	    lineDirective();

            	    state._fsp--;
            	    if (state.failed) return struct;

            	    }
            	    break;

            	default :
            	    break loop25;
                }
            } while (true);


            match(input,67,FOLLOW_67_in_objCClassDef1662); if (state.failed) return struct;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 11, objCClassDef_StartIndex); }

        }
        return struct;
    }
    // $ANTLR end "objCClassDef"



    // $ANTLR start "functionPointerOrSimpleVarDecl"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:792:1: functionPointerOrSimpleVarDecl returns [Declaration decl] : (fv= varDecl | functionPointerVarDecl );
    public final Declaration functionPointerOrSimpleVarDecl() throws RecognitionException {
        Declaration decl = null;

        int functionPointerOrSimpleVarDecl_StartIndex = input.index();

        VariablesDeclaration fv =null;

        Declaration functionPointerVarDecl14 =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 12) ) { return decl; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:793:3: (fv= varDecl | functionPointerVarDecl )
            int alt26=2;
            alt26 = dfa26.predict(input);
            switch (alt26) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:794:5: fv= varDecl
                    {
                    pushFollow(FOLLOW_varDecl_in_functionPointerOrSimpleVarDecl1697);
                    fv=varDecl();

                    state._fsp--;
                    if (state.failed) return decl;

                    if ( state.backtracking==0 ) {
                          decl = fv;
                        }

                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:797:5: functionPointerVarDecl
                    {
                    pushFollow(FOLLOW_functionPointerVarDecl_in_functionPointerOrSimpleVarDecl1707);
                    functionPointerVarDecl14=functionPointerVarDecl();

                    state._fsp--;
                    if (state.failed) return decl;

                    if ( state.backtracking==0 ) { 
                          decl = functionPointerVarDecl14; 
                        }

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 12, functionPointerOrSimpleVarDecl_StartIndex); }

        }
        return decl;
    }
    // $ANTLR end "functionPointerOrSimpleVarDecl"



    // $ANTLR start "objCPropertyAttribute"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:802:1: objCPropertyAttribute returns [Modifier modifier] :{...}?m= IDENTIFIER ( '=' v= IDENTIFIER )? ;
    public final Modifier objCPropertyAttribute() throws RecognitionException {
        Modifier modifier = null;

        int objCPropertyAttribute_StartIndex = input.index();

        Token m=null;
        Token v=null;

        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 13) ) { return modifier; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:803:5: ({...}?m= IDENTIFIER ( '=' v= IDENTIFIER )? )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:804:9: {...}?m= IDENTIFIER ( '=' v= IDENTIFIER )?
            {
            if ( !(( next(ModifierKind.ObjCPropertyModifier) )) ) {
                if (state.backtracking>0) {state.failed=true; return modifier;}
                throw new FailedPredicateException(input, "objCPropertyAttribute", " next(ModifierKind.ObjCPropertyModifier) ");
            }

            m=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_objCPropertyAttribute1740); if (state.failed) return modifier;

            if ( state.backtracking==0 ) {
                      modifier = ModifierType.parseModifier((m!=null?m.getText():null));
                    }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:807:9: ( '=' v= IDENTIFIER )?
            int alt27=2;
            switch ( input.LA(1) ) {
                case 57:
                    {
                    alt27=1;
                    }
                    break;
            }

            switch (alt27) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:808:11: '=' v= IDENTIFIER
                    {
                    match(input,57,FOLLOW_57_in_objCPropertyAttribute1764); if (state.failed) return modifier;

                    v=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_objCPropertyAttribute1768); if (state.failed) return modifier;

                    if ( state.backtracking==0 ) {
                                modifier = new ValuedModifier(modifier, Constant.string((v!=null?v.getText():null)));
                              }

                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 13, objCPropertyAttribute_StartIndex); }

        }
        return modifier;
    }
    // $ANTLR end "objCPropertyAttribute"



    // $ANTLR start "objCPropertyDecl"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:814:1: objCPropertyDecl returns [Property property] : '@property' ( LPAREN a1= objCPropertyAttribute ( COMMA ax= objCPropertyAttribute )* RPAREN )? functionPointerOrSimpleVarDecl SEMICOLON ;
    public final Property objCPropertyDecl() throws RecognitionException {
        Property property = null;

        int objCPropertyDecl_StartIndex = input.index();

        Modifier a1 =null;

        Modifier ax =null;

        Declaration functionPointerOrSimpleVarDecl15 =null;



          List<Modifier> modifiers = new ArrayList<Modifier>();

        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 14) ) { return property; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:821:3: ( '@property' ( LPAREN a1= objCPropertyAttribute ( COMMA ax= objCPropertyAttribute )* RPAREN )? functionPointerOrSimpleVarDecl SEMICOLON )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:822:5: '@property' ( LPAREN a1= objCPropertyAttribute ( COMMA ax= objCPropertyAttribute )* RPAREN )? functionPointerOrSimpleVarDecl SEMICOLON
            {
            match(input,72,FOLLOW_72_in_objCPropertyDecl1814); if (state.failed) return property;

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:823:5: ( LPAREN a1= objCPropertyAttribute ( COMMA ax= objCPropertyAttribute )* RPAREN )?
            int alt29=2;
            switch ( input.LA(1) ) {
                case LPAREN:
                    {
                    switch ( input.LA(2) ) {
                        case IDENTIFIER:
                            {
                            int LA29_14 = input.LA(3);

                            if ( (synpred54_ObjCpp()) ) {
                                alt29=1;
                            }
                            }
                            break;
                    }

                    }
                    break;
            }

            switch (alt29) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:824:7: LPAREN a1= objCPropertyAttribute ( COMMA ax= objCPropertyAttribute )* RPAREN
                    {
                    match(input,LPAREN,FOLLOW_LPAREN_in_objCPropertyDecl1829); if (state.failed) return property;

                    pushFollow(FOLLOW_objCPropertyAttribute_in_objCPropertyDecl1843);
                    a1=objCPropertyAttribute();

                    state._fsp--;
                    if (state.failed) return property;

                    if ( state.backtracking==0 ) {
                                modifiers.add(a1);
                              }

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:828:11: ( COMMA ax= objCPropertyAttribute )*
                    loop28:
                    do {
                        int alt28=2;
                        switch ( input.LA(1) ) {
                        case COMMA:
                            {
                            alt28=1;
                            }
                            break;

                        }

                        switch (alt28) {
                    	case 1 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:829:13: COMMA ax= objCPropertyAttribute
                    	    {
                    	    match(input,COMMA,FOLLOW_COMMA_in_objCPropertyDecl1871); if (state.failed) return property;

                    	    pushFollow(FOLLOW_objCPropertyAttribute_in_objCPropertyDecl1875);
                    	    ax=objCPropertyAttribute();

                    	    state._fsp--;
                    	    if (state.failed) return property;

                    	    if ( state.backtracking==0 ) {
                    	                  modifiers.add(ax);
                    	                }

                    	    }
                    	    break;

                    	default :
                    	    break loop28;
                        }
                    } while (true);


                    match(input,RPAREN,FOLLOW_RPAREN_in_objCPropertyDecl1898); if (state.failed) return property;

                    }
                    break;

            }


            pushFollow(FOLLOW_functionPointerOrSimpleVarDecl_in_objCPropertyDecl1911);
            functionPointerOrSimpleVarDecl15=functionPointerOrSimpleVarDecl();

            state._fsp--;
            if (state.failed) return property;

            match(input,SEMICOLON,FOLLOW_SEMICOLON_in_objCPropertyDecl1913); if (state.failed) return property;

            if ( state.backtracking==0 ) {
                  property = new Property(functionPointerOrSimpleVarDecl15);
                }

            }

            if ( state.backtracking==0 ) { 
              property.addModifiers(modifiers);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 14, objCPropertyDecl_StartIndex); }

        }
        return property;
    }
    // $ANTLR end "objCPropertyDecl"



    // $ANTLR start "objCMethodDecl"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:840:1: objCMethodDecl returns [Function function] :tk= (tp= '+' |tm= '-' ) ( LPAREN (returnTypeRef= mutableTypeRef )? RPAREN )? methodName= ( IDENTIFIER | 'class' ) ( ':' LPAREN argType1= mutableTypeRef RPAREN argName1= IDENTIFIER (sel= IDENTIFIER ':' LPAREN argType= mutableTypeRef RPAREN argName= IDENTIFIER )* ( COMMA '...' )? )? SEMICOLON ;
    public final Function objCMethodDecl() throws RecognitionException {
        ModContext_stack.push(new ModContext_scope());

        Function function = null;

        int objCMethodDecl_StartIndex = input.index();

        Token tp=null;
        Token tm=null;
        Token tk=null;
        Token methodName=null;
        Token argName1=null;
        Token sel=null;
        Token argName=null;
        TypeRef returnTypeRef =null;

        TypeRef argType1 =null;

        TypeRef argType =null;



          ((ModContext_scope)ModContext_stack.peek()).isObjCArgDef = true;

        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 15) ) { return function; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:845:3: (tk= (tp= '+' |tm= '-' ) ( LPAREN (returnTypeRef= mutableTypeRef )? RPAREN )? methodName= ( IDENTIFIER | 'class' ) ( ':' LPAREN argType1= mutableTypeRef RPAREN argName1= IDENTIFIER (sel= IDENTIFIER ':' LPAREN argType= mutableTypeRef RPAREN argName= IDENTIFIER )* ( COMMA '...' )? )? SEMICOLON )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:845:6: tk= (tp= '+' |tm= '-' ) ( LPAREN (returnTypeRef= mutableTypeRef )? RPAREN )? methodName= ( IDENTIFIER | 'class' ) ( ':' LPAREN argType1= mutableTypeRef RPAREN argName1= IDENTIFIER (sel= IDENTIFIER ':' LPAREN argType= mutableTypeRef RPAREN argName= IDENTIFIER )* ( COMMA '...' )? )? SEMICOLON
            {
            if ( state.backtracking==0 ) {   
                  function = new Function(); 
                  function.setType(Function.Type.ObjCMethod);
                }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:849:8: (tp= '+' |tm= '-' )
            int alt30=2;
            switch ( input.LA(1) ) {
            case 40:
                {
                alt30=1;
                }
                break;
            case 43:
                {
                alt30=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return function;}
                NoViableAltException nvae =
                    new NoViableAltException("", 30, 0, input);

                throw nvae;

            }

            switch (alt30) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:850:7: tp= '+'
                    {
                    tp=(Token)match(input,40,FOLLOW_40_in_objCMethodDecl1963); if (state.failed) return function;

                    if ( state.backtracking==0 ) { 
                            function.addModifiers(ModifierType.Static); 
                            function = mark(function, getLine(tp)); 
                            function.setCommentBefore(getCommentBefore(tp.getTokenIndex()));
                          }

                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:855:7: tm= '-'
                    {
                    tm=(Token)match(input,43,FOLLOW_43_in_objCMethodDecl1978); if (state.failed) return function;

                    if ( state.backtracking==0 ) {
                            function = mark(function, getLine(tm)); 
                            function.setCommentBefore(getCommentBefore(tm.getTokenIndex()));
                          }

                    }
                    break;

            }


            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:860:5: ( LPAREN (returnTypeRef= mutableTypeRef )? RPAREN )?
            int alt32=2;
            switch ( input.LA(1) ) {
                case LPAREN:
                    {
                    alt32=1;
                    }
                    break;
            }

            switch (alt32) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:862:7: LPAREN (returnTypeRef= mutableTypeRef )? RPAREN
                    {
                    match(input,LPAREN,FOLLOW_LPAREN_in_objCMethodDecl2007); if (state.failed) return function;

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:863:22: (returnTypeRef= mutableTypeRef )?
                    int alt31=2;
                    switch ( input.LA(1) ) {
                        case IDENTIFIER:
                        case LPAREN:
                        case 36:
                        case 38:
                        case 52:
                        case 78:
                        case 80:
                        case 82:
                        case 83:
                        case 86:
                        case 89:
                        case 94:
                        case 97:
                        case 98:
                            {
                            alt31=1;
                            }
                            break;
                        case RPAREN:
                            {
                            int LA31_12 = input.LA(2);

                            if ( (synpred56_ObjCpp()) ) {
                                alt31=1;
                            }
                            }
                            break;
                    }

                    switch (alt31) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:863:22: returnTypeRef= mutableTypeRef
                            {
                            pushFollow(FOLLOW_mutableTypeRef_in_objCMethodDecl2019);
                            returnTypeRef=mutableTypeRef();

                            state._fsp--;
                            if (state.failed) return function;

                            }
                            break;

                    }


                    if ( state.backtracking==0 ) { 
                              function.setValueType(returnTypeRef); 
                            }

                    match(input,RPAREN,FOLLOW_RPAREN_in_objCMethodDecl2030); if (state.failed) return function;

                    }
                    break;

            }


            methodName=(Token)input.LT(1);

            if ( input.LA(1)==IDENTIFIER||input.LA(1)==86 ) {
                input.consume();
                state.errorRecovery=false;
                state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return function;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            if ( state.backtracking==0 ) { 
                  function.setName(new SimpleIdentifier((methodName!=null?methodName.getText():null))); 
                  function.setCommentAfter(getCommentAfterOnSameLine(methodName.getTokenIndex(), null));
                }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:872:5: ( ':' LPAREN argType1= mutableTypeRef RPAREN argName1= IDENTIFIER (sel= IDENTIFIER ':' LPAREN argType= mutableTypeRef RPAREN argName= IDENTIFIER )* ( COMMA '...' )? )?
            int alt35=2;
            switch ( input.LA(1) ) {
                case 51:
                    {
                    alt35=1;
                    }
                    break;
            }

            switch (alt35) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:873:7: ':' LPAREN argType1= mutableTypeRef RPAREN argName1= IDENTIFIER (sel= IDENTIFIER ':' LPAREN argType= mutableTypeRef RPAREN argName= IDENTIFIER )* ( COMMA '...' )?
                    {
                    match(input,51,FOLLOW_51_in_objCMethodDecl2068); if (state.failed) return function;

                    match(input,LPAREN,FOLLOW_LPAREN_in_objCMethodDecl2070); if (state.failed) return function;

                    pushFollow(FOLLOW_mutableTypeRef_in_objCMethodDecl2074);
                    argType1=mutableTypeRef();

                    state._fsp--;
                    if (state.failed) return function;

                    match(input,RPAREN,FOLLOW_RPAREN_in_objCMethodDecl2076); if (state.failed) return function;

                    argName1=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_objCMethodDecl2080); if (state.failed) return function;

                    if ( state.backtracking==0 ) {
                            Arg arg = new Arg((argName1!=null?argName1.getText():null), argType1);
                            arg.setSelector((methodName!=null?methodName.getText():null));
                            function.addArg(arg);
                          }

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:878:7: (sel= IDENTIFIER ':' LPAREN argType= mutableTypeRef RPAREN argName= IDENTIFIER )*
                    loop33:
                    do {
                        int alt33=2;
                        switch ( input.LA(1) ) {
                        case IDENTIFIER:
                            {
                            alt33=1;
                            }
                            break;

                        }

                        switch (alt33) {
                    	case 1 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:879:9: sel= IDENTIFIER ':' LPAREN argType= mutableTypeRef RPAREN argName= IDENTIFIER
                    	    {
                    	    sel=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_objCMethodDecl2102); if (state.failed) return function;

                    	    match(input,51,FOLLOW_51_in_objCMethodDecl2104); if (state.failed) return function;

                    	    match(input,LPAREN,FOLLOW_LPAREN_in_objCMethodDecl2115); if (state.failed) return function;

                    	    pushFollow(FOLLOW_mutableTypeRef_in_objCMethodDecl2119);
                    	    argType=mutableTypeRef();

                    	    state._fsp--;
                    	    if (state.failed) return function;

                    	    match(input,RPAREN,FOLLOW_RPAREN_in_objCMethodDecl2121); if (state.failed) return function;

                    	    argName=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_objCMethodDecl2134); if (state.failed) return function;

                    	    if ( state.backtracking==0 ) {
                    	              Arg arg = new Arg((argName!=null?argName.getText():null), argType);
                    	              arg.setSelector((sel!=null?sel.getText():null));
                    	              function.addArg(arg);
                    	            }

                    	    }
                    	    break;

                    	default :
                    	    break loop33;
                        }
                    } while (true);


                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:887:7: ( COMMA '...' )?
                    int alt34=2;
                    switch ( input.LA(1) ) {
                        case COMMA:
                            {
                            alt34=1;
                            }
                            break;
                    }

                    switch (alt34) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:888:9: COMMA '...'
                            {
                            match(input,COMMA,FOLLOW_COMMA_in_objCMethodDecl2163); if (state.failed) return function;

                            match(input,48,FOLLOW_48_in_objCMethodDecl2165); if (state.failed) return function;

                            if ( state.backtracking==0 ) {
                                      function.addArg(Arg.createVarArgs());
                                    }

                            }
                            break;

                    }


                    }
                    break;

            }


            match(input,SEMICOLON,FOLLOW_SEMICOLON_in_objCMethodDecl2189); if (state.failed) return function;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 15, objCMethodDecl_StartIndex); }

            ModContext_stack.pop();

        }
        return function;
    }
    // $ANTLR end "objCMethodDecl"



    // $ANTLR start "structBody"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:896:1: structBody returns [Struct struct] : LBRACE ( ({...}? IDENTIFIER |{...}? IDENTIFIER |{...}? IDENTIFIER ) ':' |{...}? IDENTIFIER (friendDecl= declaration |friendVar= varDecl SEMICOLON ) | (tp= templatePrefix )? {...}?id= IDENTIFIER s= functionDeclarationSuffix |decl= declaration |fv= varDecl SEMICOLON | lineDirective )* RBRACE ;
    public final Struct structBody() throws RecognitionException {
        ModContext_stack.push(new ModContext_scope());
        Symbols_stack.push(new Symbols_scope());

        Struct struct = null;

        int structBody_StartIndex = input.index();

        Token id=null;
        ObjCppParser.declaration_return friendDecl =null;

        VariablesDeclaration friendVar =null;

        Template tp =null;

        ObjCppParser.functionDeclarationSuffix_return s =null;

        ObjCppParser.declaration_return decl =null;

        VariablesDeclaration fv =null;



          ((Symbols_scope)Symbols_stack.peek()).typeIdentifiers = new HashSet<String>();

        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 16) ) { return struct; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:902:3: ( LBRACE ( ({...}? IDENTIFIER |{...}? IDENTIFIER |{...}? IDENTIFIER ) ':' |{...}? IDENTIFIER (friendDecl= declaration |friendVar= varDecl SEMICOLON ) | (tp= templatePrefix )? {...}?id= IDENTIFIER s= functionDeclarationSuffix |decl= declaration |fv= varDecl SEMICOLON | lineDirective )* RBRACE )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:903:5: LBRACE ( ({...}? IDENTIFIER |{...}? IDENTIFIER |{...}? IDENTIFIER ) ':' |{...}? IDENTIFIER (friendDecl= declaration |friendVar= varDecl SEMICOLON ) | (tp= templatePrefix )? {...}?id= IDENTIFIER s= functionDeclarationSuffix |decl= declaration |fv= varDecl SEMICOLON | lineDirective )* RBRACE
            {
            if ( state.backtracking==0 ) { 
                  struct = new Struct();
                  struct.setForwardDeclaration(false); 
                }

            match(input,LBRACE,FOLLOW_LBRACE_in_structBody2232); if (state.failed) return struct;

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:908:7: ( ({...}? IDENTIFIER |{...}? IDENTIFIER |{...}? IDENTIFIER ) ':' |{...}? IDENTIFIER (friendDecl= declaration |friendVar= varDecl SEMICOLON ) | (tp= templatePrefix )? {...}?id= IDENTIFIER s= functionDeclarationSuffix |decl= declaration |fv= varDecl SEMICOLON | lineDirective )*
            loop39:
            do {
                int alt39=7;
                alt39 = dfa39.predict(input);
                switch (alt39) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:909:9: ({...}? IDENTIFIER |{...}? IDENTIFIER |{...}? IDENTIFIER ) ':'
            	    {
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:909:9: ({...}? IDENTIFIER |{...}? IDENTIFIER |{...}? IDENTIFIER )
            	    int alt36=3;
            	    switch ( input.LA(1) ) {
            	    case IDENTIFIER:
            	        {
            	        int LA36_1 = input.LA(2);

            	        if ( (((synpred62_ObjCpp()&&synpred62_ObjCpp())&&( next("public") ))) ) {
            	            alt36=1;
            	        }
            	        else if ( (((synpred63_ObjCpp()&&synpred63_ObjCpp())&&( next("private") ))) ) {
            	            alt36=2;
            	        }
            	        else if ( (( next("protected") )) ) {
            	            alt36=3;
            	        }
            	        else {
            	            if (state.backtracking>0) {state.failed=true; return struct;}
            	            NoViableAltException nvae =
            	                new NoViableAltException("", 36, 1, input);

            	            throw nvae;

            	        }
            	        }
            	        break;
            	    default:
            	        if (state.backtracking>0) {state.failed=true; return struct;}
            	        NoViableAltException nvae =
            	            new NoViableAltException("", 36, 0, input);

            	        throw nvae;

            	    }

            	    switch (alt36) {
            	        case 1 :
            	            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:910:11: {...}? IDENTIFIER
            	            {
            	            if ( !(( next("public") )) ) {
            	                if (state.backtracking>0) {state.failed=true; return struct;}
            	                throw new FailedPredicateException(input, "structBody", " next(\"public\") ");
            	            }

            	            match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_structBody2264); if (state.failed) return struct;

            	            if ( state.backtracking==0 ) { struct.setNextMemberVisibility(Struct.MemberVisibility.Public); }

            	            }
            	            break;
            	        case 2 :
            	            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:911:11: {...}? IDENTIFIER
            	            {
            	            if ( !(( next("private") )) ) {
            	                if (state.backtracking>0) {state.failed=true; return struct;}
            	                throw new FailedPredicateException(input, "structBody", " next(\"private\") ");
            	            }

            	            match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_structBody2283); if (state.failed) return struct;

            	            if ( state.backtracking==0 ) { struct.setNextMemberVisibility(Struct.MemberVisibility.Private); }

            	            }
            	            break;
            	        case 3 :
            	            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:912:11: {...}? IDENTIFIER
            	            {
            	            if ( !(( next("protected") )) ) {
            	                if (state.backtracking>0) {state.failed=true; return struct;}
            	                throw new FailedPredicateException(input, "structBody", " next(\"protected\") ");
            	            }

            	            match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_structBody2302); if (state.failed) return struct;

            	            if ( state.backtracking==0 ) { struct.setNextMemberVisibility(Struct.MemberVisibility.Protected); }

            	            }
            	            break;

            	    }


            	    match(input,51,FOLLOW_51_in_structBody2317); if (state.failed) return struct;

            	    }
            	    break;
            	case 2 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:914:9: {...}? IDENTIFIER (friendDecl= declaration |friendVar= varDecl SEMICOLON )
            	    {
            	    if ( !(( next("friend") )) ) {
            	        if (state.backtracking>0) {state.failed=true; return struct;}
            	        throw new FailedPredicateException(input, "structBody", " next(\"friend\") ");
            	    }

            	    match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_structBody2331); if (state.failed) return struct;

            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:914:40: (friendDecl= declaration |friendVar= varDecl SEMICOLON )
            	    int alt37=2;
            	    alt37 = dfa37.predict(input);
            	    switch (alt37) {
            	        case 1 :
            	            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:915:11: friendDecl= declaration
            	            {
            	            pushFollow(FOLLOW_declaration_in_structBody2347);
            	            friendDecl=declaration();

            	            state._fsp--;
            	            if (state.failed) return struct;

            	            if ( state.backtracking==0 ) {
            	                        struct.addDeclaration(new FriendDeclaration(friendDecl.declaration));
            	                      }

            	            }
            	            break;
            	        case 2 :
            	            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:918:11: friendVar= varDecl SEMICOLON
            	            {
            	            pushFollow(FOLLOW_varDecl_in_structBody2365);
            	            friendVar=varDecl();

            	            state._fsp--;
            	            if (state.failed) return struct;

            	            match(input,SEMICOLON,FOLLOW_SEMICOLON_in_structBody2367); if (state.failed) return struct;

            	            if ( state.backtracking==0 ) {
            	                        struct.addDeclaration(new FriendDeclaration(decl.declaration));
            	                      }

            	            }
            	            break;

            	    }


            	    }
            	    break;
            	case 3 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:922:9: (tp= templatePrefix )? {...}?id= IDENTIFIER s= functionDeclarationSuffix
            	    {
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:922:11: (tp= templatePrefix )?
            	    int alt38=2;
            	    switch ( input.LA(1) ) {
            	        case IDENTIFIER:
            	            {
            	            switch ( input.LA(2) ) {
            	                case 53:
            	                    {
            	                    alt38=1;
            	                    }
            	                    break;
            	            }

            	            }
            	            break;
            	    }

            	    switch (alt38) {
            	        case 1 :
            	            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:922:11: tp= templatePrefix
            	            {
            	            pushFollow(FOLLOW_templatePrefix_in_structBody2393);
            	            tp=templatePrefix();

            	            state._fsp--;
            	            if (state.failed) return struct;

            	            }
            	            break;

            	    }


            	    if ( !(( next(getCurrentClassName()) )) ) {
            	        if (state.backtracking>0) {state.failed=true; return struct;}
            	        throw new FailedPredicateException(input, "structBody", " next(getCurrentClassName()) ");
            	    }

            	    id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_structBody2408); if (state.failed) return struct;

            	    pushFollow(FOLLOW_functionDeclarationSuffix_in_structBody2412);
            	    s=functionDeclarationSuffix();

            	    state._fsp--;
            	    if (state.failed) return struct;

            	    if ( state.backtracking==0 ) {
            	              Function f = new Function();
            	              f.setName(getCurrentClassName());
            	              f.setType(Function.Type.CppMethod);
            	              f.setArgs((s!=null?s.args:null));
            	              f.addModifiers((s!=null?s.postModifiers:null));
            	              f.setInitializers((s!=null?s.initializers:null));
            	              f.setBody((s!=null?s.body:null));
            	              
            	              if (tp != null) {
            	                tp.setDeclaration(f);
            	                struct.addDeclaration(tp);
            	              } else {
            	                struct.addDeclaration(f);
            	              }
            	            }

            	    }
            	    break;
            	case 4 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:939:9: decl= declaration
            	    {
            	    pushFollow(FOLLOW_declaration_in_structBody2428);
            	    decl=declaration();

            	    state._fsp--;
            	    if (state.failed) return struct;

            	    if ( state.backtracking==0 ) {
            	              struct.addDeclaration((decl!=null?decl.declaration:null));
            	            }

            	    }
            	    break;
            	case 5 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:942:9: fv= varDecl SEMICOLON
            	    {
            	    pushFollow(FOLLOW_varDecl_in_structBody2444);
            	    fv=varDecl();

            	    state._fsp--;
            	    if (state.failed) return struct;

            	    match(input,SEMICOLON,FOLLOW_SEMICOLON_in_structBody2446); if (state.failed) return struct;

            	    if ( state.backtracking==0 ) {
            	              struct.addDeclaration(fv);
            	            }

            	    }
            	    break;
            	case 6 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:945:9: lineDirective
            	    {
            	    pushFollow(FOLLOW_lineDirective_in_structBody2460);
            	    lineDirective();

            	    state._fsp--;
            	    if (state.failed) return struct;

            	    }
            	    break;

            	default :
            	    break loop39;
                }
            } while (true);


            match(input,RBRACE,FOLLOW_RBRACE_in_structBody2475); if (state.failed) return struct;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 16, structBody_StartIndex); }

            ModContext_stack.pop();
            Symbols_stack.pop();

        }
        return struct;
    }
    // $ANTLR end "structBody"



    // $ANTLR start "structCore"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:950:1: structCore returns [Struct struct] : typeToken= ( 'struct' | 'union' | 'class' ) ( (m1= modifiers )? (ab= structBody |tag= qualifiedIdentifier ( ( (m2= modifiers )? ( ':' ({...}?p= IDENTIFIER )? parent= qualifiedIdentifier )? nb= structBody ) |) ) ) ;
    public final Struct structCore() throws RecognitionException {
        Symbols_stack.push(new Symbols_scope());
        ModContext_stack.push(new ModContext_scope());
        CurrentClass_stack.push(new CurrentClass_scope());

        Struct struct = null;

        int structCore_StartIndex = input.index();

        Token typeToken=null;
        Token p=null;
        List<Modifier> m1 =null;

        Struct ab =null;

        Identifier tag =null;

        List<Modifier> m2 =null;

        Identifier parent =null;

        Struct nb =null;



          ((Symbols_scope)Symbols_stack.peek()).typeIdentifiers = new HashSet<String>();
          List<Modifier> modifiers = new ArrayList<Modifier>();
          Identifier parentIdentifier = null;

        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 17) ) { return struct; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:978:3: (typeToken= ( 'struct' | 'union' | 'class' ) ( (m1= modifiers )? (ab= structBody |tag= qualifiedIdentifier ( ( (m2= modifiers )? ( ':' ({...}?p= IDENTIFIER )? parent= qualifiedIdentifier )? nb= structBody ) |) ) ) )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:981:5: typeToken= ( 'struct' | 'union' | 'class' ) ( (m1= modifiers )? (ab= structBody |tag= qualifiedIdentifier ( ( (m2= modifiers )? ( ':' ({...}?p= IDENTIFIER )? parent= qualifiedIdentifier )? nb= structBody ) |) ) )
            {
            typeToken=(Token)input.LT(1);

            if ( input.LA(1)==86||input.LA(1)==94||input.LA(1)==98 ) {
                input.consume();
                state.errorRecovery=false;
                state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return struct;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:982:5: ( (m1= modifiers )? (ab= structBody |tag= qualifiedIdentifier ( ( (m2= modifiers )? ( ':' ({...}?p= IDENTIFIER )? parent= qualifiedIdentifier )? nb= structBody ) |) ) )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:983:7: (m1= modifiers )? (ab= structBody |tag= qualifiedIdentifier ( ( (m2= modifiers )? ( ':' ({...}?p= IDENTIFIER )? parent= qualifiedIdentifier )? nb= structBody ) |) )
            {
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:983:7: (m1= modifiers )?
            int alt40=2;
            switch ( input.LA(1) ) {
                case IDENTIFIER:
                    {
                    switch ( input.LA(2) ) {
                        case LPAREN:
                            {
                            int LA40_5 = input.LA(3);

                            if ( (((synpred74_ObjCpp()&&synpred74_ObjCpp())&&(( next("__pragma") )||( next("__asm") )||( next("__success") )||( next(ModifierKind.VCAnnotation1Arg, ModifierKind.VCAnnotation2Args) )))) ) {
                                alt40=1;
                            }
                            }
                            break;
                        case STRING:
                            {
                            int LA40_6 = input.LA(3);

                            if ( (((( next("extern") )&&( next("extern") ))&&synpred74_ObjCpp())) ) {
                                alt40=1;
                            }
                            }
                            break;
                        case IDENTIFIER:
                            {
                            int LA40_7 = input.LA(3);

                            if ( (((synpred74_ObjCpp()&&synpred74_ObjCpp())&&( parseModifier(next()) != null ))) ) {
                                alt40=1;
                            }
                            }
                            break;
                        case 82:
                        case 83:
                            {
                            int LA40_8 = input.LA(3);

                            if ( (((synpred74_ObjCpp()&&synpred74_ObjCpp())&&( parseModifier(next()) != null ))) ) {
                                alt40=1;
                            }
                            }
                            break;
                        case LBRACE:
                            {
                            int LA40_9 = input.LA(3);

                            if ( (((synpred74_ObjCpp()&&synpred74_ObjCpp())&&( parseModifier(next()) != null ))) ) {
                                alt40=1;
                            }
                            }
                            break;
                        case 52:
                            {
                            int LA40_10 = input.LA(3);

                            if ( (((synpred74_ObjCpp()&&synpred74_ObjCpp())&&( parseModifier(next()) != null ))) ) {
                                alt40=1;
                            }
                            }
                            break;
                    }

                    }
                    break;
                case 82:
                case 83:
                    {
                    alt40=1;
                    }
                    break;
            }

            switch (alt40) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:983:9: m1= modifiers
                    {
                    pushFollow(FOLLOW_modifiers_in_structCore2563);
                    m1=modifiers();

                    state._fsp--;
                    if (state.failed) return struct;

                    if ( state.backtracking==0 ) { modifiers.addAll(m1); }

                    }
                    break;

            }


            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:984:7: (ab= structBody |tag= qualifiedIdentifier ( ( (m2= modifiers )? ( ':' ({...}?p= IDENTIFIER )? parent= qualifiedIdentifier )? nb= structBody ) |) )
            int alt45=2;
            switch ( input.LA(1) ) {
            case LBRACE:
                {
                alt45=1;
                }
                break;
            case IDENTIFIER:
            case 52:
                {
                alt45=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return struct;}
                NoViableAltException nvae =
                    new NoViableAltException("", 45, 0, input);

                throw nvae;

            }

            switch (alt45) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:985:9: ab= structBody
                    {
                    pushFollow(FOLLOW_structBody_in_structCore2588);
                    ab=structBody();

                    state._fsp--;
                    if (state.failed) return struct;

                    if ( state.backtracking==0 ) {
                              struct = ab;
                              struct.setForwardDeclaration(false);
                            }

                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:989:9: tag= qualifiedIdentifier ( ( (m2= modifiers )? ( ':' ({...}?p= IDENTIFIER )? parent= qualifiedIdentifier )? nb= structBody ) |)
                    {
                    pushFollow(FOLLOW_qualifiedIdentifier_in_structCore2604);
                    tag=qualifiedIdentifier();

                    state._fsp--;
                    if (state.failed) return struct;

                    if ( state.backtracking==0 ) {
                              defineTypeIdentifierInParentScope(tag);
                              setCurrentClassName(tag);
                            }

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:993:9: ( ( (m2= modifiers )? ( ':' ({...}?p= IDENTIFIER )? parent= qualifiedIdentifier )? nb= structBody ) |)
                    int alt44=2;
                    alt44 = dfa44.predict(input);
                    switch (alt44) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:994:11: ( (m2= modifiers )? ( ':' ({...}?p= IDENTIFIER )? parent= qualifiedIdentifier )? nb= structBody )
                            {
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:994:11: ( (m2= modifiers )? ( ':' ({...}?p= IDENTIFIER )? parent= qualifiedIdentifier )? nb= structBody )
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:995:13: (m2= modifiers )? ( ':' ({...}?p= IDENTIFIER )? parent= qualifiedIdentifier )? nb= structBody
                            {
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:995:13: (m2= modifiers )?
                            int alt41=2;
                            switch ( input.LA(1) ) {
                                case IDENTIFIER:
                                case 82:
                                case 83:
                                    {
                                    alt41=1;
                                    }
                                    break;
                            }

                            switch (alt41) {
                                case 1 :
                                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:995:15: m2= modifiers
                                    {
                                    pushFollow(FOLLOW_modifiers_in_structCore2646);
                                    m2=modifiers();

                                    state._fsp--;
                                    if (state.failed) return struct;

                                    if ( state.backtracking==0 ) { modifiers.addAll(m2); }

                                    }
                                    break;

                            }


                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:996:13: ( ':' ({...}?p= IDENTIFIER )? parent= qualifiedIdentifier )?
                            int alt43=2;
                            switch ( input.LA(1) ) {
                                case 51:
                                    {
                                    alt43=1;
                                    }
                                    break;
                            }

                            switch (alt43) {
                                case 1 :
                                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:997:15: ':' ({...}?p= IDENTIFIER )? parent= qualifiedIdentifier
                                    {
                                    match(input,51,FOLLOW_51_in_structCore2681); if (state.failed) return struct;

                                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:998:15: ({...}?p= IDENTIFIER )?
                                    int alt42=2;
                                    switch ( input.LA(1) ) {
                                        case IDENTIFIER:
                                            {
                                            switch ( input.LA(2) ) {
                                                case 52:
                                                    {
                                                    int LA42_3 = input.LA(3);

                                                    if ( (((( next("public", "private", "virtual") )&&( next("public", "private", "virtual") ))&&synpred77_ObjCpp())) ) {
                                                        alt42=1;
                                                    }
                                                    }
                                                    break;
                                                case IDENTIFIER:
                                                    {
                                                    alt42=1;
                                                    }
                                                    break;
                                            }

                                            }
                                            break;
                                    }

                                    switch (alt42) {
                                        case 1 :
                                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:998:17: {...}?p= IDENTIFIER
                                            {
                                            if ( !(( next("public", "private", "virtual") )) ) {
                                                if (state.backtracking>0) {state.failed=true; return struct;}
                                                throw new FailedPredicateException(input, "structCore", " next(\"public\", \"private\", \"virtual\") ");
                                            }

                                            p=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_structCore2703); if (state.failed) return struct;

                                            }
                                            break;

                                    }


                                    pushFollow(FOLLOW_qualifiedIdentifier_in_structCore2724);
                                    parent=qualifiedIdentifier();

                                    state._fsp--;
                                    if (state.failed) return struct;

                                    if ( state.backtracking==0 ) {
                                                    parentIdentifier = parent;
                                                  }

                                    }
                                    break;

                            }


                            pushFollow(FOLLOW_structBody_in_structCore2758);
                            nb=structBody();

                            state._fsp--;
                            if (state.failed) return struct;

                            if ( state.backtracking==0 ) {
                                          struct = nb;
                                          struct.setForwardDeclaration(false);
                                          if (parentIdentifier != null)
                                            struct.addParent(parentIdentifier);
                                        }

                            }


                            }
                            break;
                        case 2 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1009:15: 
                            {
                            if ( state.backtracking==0 ) {
                                        struct = new Struct();
                                        struct.setForwardDeclaration(true);
                                      }

                            }
                            break;

                    }


                    if ( state.backtracking==0 ) {
                              struct.setTag(tag);
                            }

                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {
              struct = mark(struct, getLine(typeToken)); 
              struct.setType(
                (typeToken!=null?typeToken.getText():null).equals("struct") ?  Struct.Type.CStruct :
                (typeToken!=null?typeToken.getText():null).equals("union") ?  Struct.Type.CUnion :
                        Struct.Type.CPPClass
              );
              
              Function.Type forcedType = null;
              if (struct.getType() == Struct.Type.CPPClass)
                forcedType = Function.Type.CppMethod;
              
              if (forcedType != null)
              for (Declaration d : struct.getDeclarations()) {
                if (d instanceof Function)
                  ((Function)d).setType(forcedType);
              }
              struct.addModifiers(modifiers);
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 17, structCore_StartIndex); }

            Symbols_stack.pop();
            ModContext_stack.pop();
            CurrentClass_stack.pop();

        }
        return struct;
    }
    // $ANTLR end "structCore"



    // $ANTLR start "anyOp"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1020:1: anyOp returns [java.lang.Enum<?> op] : ( binaryOp | unaryOp | assignmentOp );
    public final java.lang.Enum<?> anyOp() throws RecognitionException {
        java.lang.Enum<?> op = null;

        int anyOp_StartIndex = input.index();

        Expression.BinaryOperator binaryOp16 =null;

        Expression.UnaryOperator unaryOp17 =null;

        ObjCppParser.assignmentOp_return assignmentOp18 =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 18) ) { return op; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1021:3: ( binaryOp | unaryOp | assignmentOp )
            int alt46=3;
            switch ( input.LA(1) ) {
            case 36:
            case 38:
            case 43:
                {
                int LA46_1 = input.LA(2);

                if ( (synpred80_ObjCpp()) ) {
                    alt46=1;
                }
                else if ( (synpred81_ObjCpp()) ) {
                    alt46=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return op;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 46, 1, input);

                    throw nvae;

                }
                }
                break;
            case 31:
            case 33:
            case 35:
            case 40:
            case 49:
            case 53:
            case 54:
            case 56:
            case 58:
            case 59:
            case 60:
            case 61:
            case 63:
            case 80:
            case 100:
            case 102:
                {
                alt46=1;
                }
                break;
            case 30:
            case 41:
            case 44:
            case 103:
                {
                alt46=2;
                }
                break;
            case 34:
            case 37:
            case 39:
            case 42:
            case 45:
            case 50:
            case 55:
            case 57:
            case 62:
            case 81:
            case 101:
            case 104:
                {
                alt46=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return op;}
                NoViableAltException nvae =
                    new NoViableAltException("", 46, 0, input);

                throw nvae;

            }

            switch (alt46) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1021:6: binaryOp
                    {
                    pushFollow(FOLLOW_binaryOp_in_anyOp2823);
                    binaryOp16=binaryOp();

                    state._fsp--;
                    if (state.failed) return op;

                    if ( state.backtracking==0 ) { op = binaryOp16; }

                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1022:5: unaryOp
                    {
                    pushFollow(FOLLOW_unaryOp_in_anyOp2834);
                    unaryOp17=unaryOp();

                    state._fsp--;
                    if (state.failed) return op;

                    if ( state.backtracking==0 ) { op = unaryOp17; }

                    }
                    break;
                case 3 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1023:5: assignmentOp
                    {
                    pushFollow(FOLLOW_assignmentOp_in_anyOp2845);
                    assignmentOp18=assignmentOp();

                    state._fsp--;
                    if (state.failed) return op;

                    if ( state.backtracking==0 ) { op = (assignmentOp18!=null?assignmentOp18.op:null); }

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 18, anyOp_StartIndex); }

        }
        return op;
    }
    // $ANTLR end "anyOp"


    public static class functionDeclaration_return extends ParserRuleReturnScope {
        public Function function;
    };


    // $ANTLR start "functionDeclaration"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1028:1: functionDeclaration returns [Function function] : ({...}? => IDENTIFIER (castPreMods= modifiers )? castTypeRef= mutableTypeRef | (preMods1= modifiers )? returnTypeRef= mutableTypeRef (preMods2= modifiers )? name= qualifiedCppFunctionName ) s= functionDeclarationSuffix ;
    public final ObjCppParser.functionDeclaration_return functionDeclaration() throws RecognitionException {
        Symbols_stack.push(new Symbols_scope());

        ObjCppParser.functionDeclaration_return retval = new ObjCppParser.functionDeclaration_return();
        retval.start = input.LT(1);

        int functionDeclaration_StartIndex = input.index();

        List<Modifier> castPreMods =null;

        TypeRef castTypeRef =null;

        List<Modifier> preMods1 =null;

        TypeRef returnTypeRef =null;

        List<Modifier> preMods2 =null;

        Identifier name =null;

        ObjCppParser.functionDeclarationSuffix_return s =null;



          ((Symbols_scope)Symbols_stack.peek()).typeIdentifiers = new HashSet<String>();

        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 19) ) { return retval; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1033:3: ( ({...}? => IDENTIFIER (castPreMods= modifiers )? castTypeRef= mutableTypeRef | (preMods1= modifiers )? returnTypeRef= mutableTypeRef (preMods2= modifiers )? name= qualifiedCppFunctionName ) s= functionDeclarationSuffix )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1033:6: ({...}? => IDENTIFIER (castPreMods= modifiers )? castTypeRef= mutableTypeRef | (preMods1= modifiers )? returnTypeRef= mutableTypeRef (preMods2= modifiers )? name= qualifiedCppFunctionName ) s= functionDeclarationSuffix
            {
            if ( state.backtracking==0 ) {   
                  retval.function = mark(new Function(), -1);
                  retval.function.setType(Function.Type.CFunction);
                }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1037:5: ({...}? => IDENTIFIER (castPreMods= modifiers )? castTypeRef= mutableTypeRef | (preMods1= modifiers )? returnTypeRef= mutableTypeRef (preMods2= modifiers )? name= qualifiedCppFunctionName )
            int alt50=2;
            int LA50_0 = input.LA(1);

            if ( (LA50_0==IDENTIFIER) ) {
                int LA50_1 = input.LA(2);

                if ( (((( next("operator") )&&( next("operator") ))&&synpred83_ObjCpp())) ) {
                    alt50=1;
                }
                else if ( (true) ) {
                    alt50=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 50, 1, input);

                    throw nvae;

                }
            }
            else if ( ((LA50_0 >= 82 && LA50_0 <= 83)||LA50_0==97) ) {
                alt50=2;
            }
            else if ( (LA50_0==52) && (( 
                    next(2, "<") ||
                    isTypeIdentifier(next()) || 
                    (
                      parseModifier(next(1)) == null &&
                      //(isTypeDef() || !next(2, "=", ",", ";", ":", "[", "(", ")"))
                      !next(2, "=", ",", ";", ":", "[", "(", ")")
                    ) 
                  ))) {
                alt50=2;
            }
            else if ( (LA50_0==LPAREN||LA50_0==36||LA50_0==38||LA50_0==78||LA50_0==80||LA50_0==86||LA50_0==89||LA50_0==94||LA50_0==98||LA50_0==103) ) {
                alt50=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 50, 0, input);

                throw nvae;

            }
            switch (alt50) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1039:7: {...}? => IDENTIFIER (castPreMods= modifiers )? castTypeRef= mutableTypeRef
                    {
                    if ( !(( next("operator") )) ) {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        throw new FailedPredicateException(input, "functionDeclaration", " next(\"operator\") ");
                    }

                    match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_functionDeclaration2902); if (state.failed) return retval;

                    if ( state.backtracking==0 ) {
                            retval.function.setName(ident("operator")); 
                            mark(retval.function, getLine(((Token)retval.start)));
                          }

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1043:7: (castPreMods= modifiers )?
                    int alt47=2;
                    switch ( input.LA(1) ) {
                        case IDENTIFIER:
                            {
                            int LA47_1 = input.LA(2);

                            if ( (((synpred82_ObjCpp()&&synpred82_ObjCpp())&&(( next("extern") )||( next("__pragma") )||( parseModifier(next()) != null )||( next("__asm") )||( next("__success") )||( next(ModifierKind.VCAnnotation1Arg, ModifierKind.VCAnnotation2Args) )))) ) {
                                alt47=1;
                            }
                            }
                            break;
                        case 82:
                        case 83:
                            {
                            switch ( input.LA(2) ) {
                                case LPAREN:
                                    {
                                    int LA47_26 = input.LA(3);

                                    if ( (synpred82_ObjCpp()) ) {
                                        alt47=1;
                                    }
                                    }
                                    break;
                            }

                            }
                            break;
                    }

                    switch (alt47) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1043:9: castPreMods= modifiers
                            {
                            pushFollow(FOLLOW_modifiers_in_functionDeclaration2917);
                            castPreMods=modifiers();

                            state._fsp--;
                            if (state.failed) return retval;

                            if ( state.backtracking==0 ) { retval.function.addModifiers(castPreMods); }

                            }
                            break;

                    }


                    pushFollow(FOLLOW_mutableTypeRef_in_functionDeclaration2932);
                    castTypeRef=mutableTypeRef();

                    state._fsp--;
                    if (state.failed) return retval;

                    if ( state.backtracking==0 ) { 
                            retval.function.setValueType(castTypeRef); 
                          }

                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1047:7: (preMods1= modifiers )? returnTypeRef= mutableTypeRef (preMods2= modifiers )? name= qualifiedCppFunctionName
                    {
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1047:7: (preMods1= modifiers )?
                    int alt48=2;
                    switch ( input.LA(1) ) {
                        case IDENTIFIER:
                            {
                            int LA48_1 = input.LA(2);

                            if ( ((((( next("extern") )||( next("__pragma") )||( parseModifier(next()) != null )||( next("__asm") )||( next("__success") )||( next(ModifierKind.VCAnnotation1Arg, ModifierKind.VCAnnotation2Args) ))&&(( next("extern") )||( next("__pragma") )||( parseModifier(next()) != null )||( next("__asm") )||( next("__success") )||( next(ModifierKind.VCAnnotation1Arg, ModifierKind.VCAnnotation2Args) )))&&synpred84_ObjCpp())) ) {
                                alt48=1;
                            }
                            }
                            break;
                        case 82:
                        case 83:
                            {
                            switch ( input.LA(2) ) {
                                case LPAREN:
                                    {
                                    int LA48_37 = input.LA(3);

                                    if ( (synpred84_ObjCpp()) ) {
                                        alt48=1;
                                    }
                                    }
                                    break;
                            }

                            }
                            break;
                    }

                    switch (alt48) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1047:9: preMods1= modifiers
                            {
                            pushFollow(FOLLOW_modifiers_in_functionDeclaration2948);
                            preMods1=modifiers();

                            state._fsp--;
                            if (state.failed) return retval;

                            if ( state.backtracking==0 ) { retval.function.addModifiers(preMods1); }

                            }
                            break;

                    }


                    pushFollow(FOLLOW_mutableTypeRef_in_functionDeclaration2963);
                    returnTypeRef=mutableTypeRef();

                    state._fsp--;
                    if (state.failed) return retval;

                    if ( state.backtracking==0 ) { 
                            retval.function.setValueType(returnTypeRef); 
                          }

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1051:7: (preMods2= modifiers )?
                    int alt49=2;
                    switch ( input.LA(1) ) {
                        case IDENTIFIER:
                            {
                            switch ( input.LA(2) ) {
                                case LPAREN:
                                    {
                                    int LA49_4 = input.LA(3);

                                    if ( ((((( next("__pragma") )||( next("__asm") )||( next("__success") )||( next(ModifierKind.VCAnnotation1Arg, ModifierKind.VCAnnotation2Args) ))&&(( next("__pragma") )||( next("__asm") )||( next("__success") )||( next(ModifierKind.VCAnnotation1Arg, ModifierKind.VCAnnotation2Args) )))&&synpred85_ObjCpp())) ) {
                                        alt49=1;
                                    }
                                    }
                                    break;
                                case IDENTIFIER:
                                case STRING:
                                case 82:
                                case 83:
                                    {
                                    alt49=1;
                                    }
                                    break;
                                case 103:
                                    {
                                    int LA49_8 = input.LA(3);

                                    if ( (((( parseModifier(next()) != null )&&( parseModifier(next()) != null ))&&synpred85_ObjCpp())) ) {
                                        alt49=1;
                                    }
                                    }
                                    break;
                            }

                            }
                            break;
                        case 82:
                        case 83:
                            {
                            alt49=1;
                            }
                            break;
                    }

                    switch (alt49) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1051:9: preMods2= modifiers
                            {
                            pushFollow(FOLLOW_modifiers_in_functionDeclaration2977);
                            preMods2=modifiers();

                            state._fsp--;
                            if (state.failed) return retval;

                            if ( state.backtracking==0 ) { retval.function.addModifiers(preMods2); }

                            }
                            break;

                    }


                    pushFollow(FOLLOW_qualifiedCppFunctionName_in_functionDeclaration2992);
                    name=qualifiedCppFunctionName();

                    state._fsp--;
                    if (state.failed) return retval;

                    if ( state.backtracking==0 ) {
                            retval.function.setName(name); 
                            mark(retval.function, getLine(((Token)retval.start)));
                          }

                    }
                    break;

            }


            pushFollow(FOLLOW_functionDeclarationSuffix_in_functionDeclaration3008);
            s=functionDeclarationSuffix();

            state._fsp--;
            if (state.failed) return retval;

            if ( state.backtracking==0 ) {
                  retval.function.setArgs((s!=null?s.args:null));
                  retval.function.addModifiers((s!=null?s.postModifiers:null));
                  if (!(s!=null?s.initializers:null).isEmpty()) {
                    retval.function.setInitializers((s!=null?s.initializers:null));
                    retval.function.setType(Function.Type.CppMethod);
                  }
                  retval.function.setThrows((s!=null?s.thrown:null) != null);
                  retval.function.setThrown((s!=null?s.thrown:null));
                  retval.function.setBody((s!=null?s.body:null));
                }

            }

            retval.stop = input.LT(-1);


        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 19, functionDeclaration_StartIndex); }

            Symbols_stack.pop();

        }
        return retval;
    }
    // $ANTLR end "functionDeclaration"


    public static class functionDeclarationSuffix_return extends ParserRuleReturnScope {
        public List<Arg> args;
        public List<Modifier> postModifiers;
        public List<FunctionCall> initializers;
        public Block body;
        public List<TypeRef> thrown;
    };


    // $ANTLR start "functionDeclarationSuffix"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1070:1: functionDeclarationSuffix returns [List<Arg> args, List<Modifier> postModifiers, List<FunctionCall> initializers, Block body, List<TypeRef> thrown] : argList (postMods= modifiers )? ({...}? IDENTIFIER LPAREN (t1= mutableTypeRef ( COMMA tx= mutableTypeRef )* )? RPAREN )? ( ':' i1= constructorInitializer ( COMMA ix= constructorInitializer )* )? ( ({...}? '=' DECIMAL_NUMBER )? SEMICOLON | statementsBlock ) ;
    public final ObjCppParser.functionDeclarationSuffix_return functionDeclarationSuffix() throws RecognitionException {
        ObjCppParser.functionDeclarationSuffix_return retval = new ObjCppParser.functionDeclarationSuffix_return();
        retval.start = input.LT(1);

        int functionDeclarationSuffix_StartIndex = input.index();

        List<Modifier> postMods =null;

        TypeRef t1 =null;

        TypeRef tx =null;

        FunctionCall i1 =null;

        FunctionCall ix =null;

        ObjCppParser.argList_return argList19 =null;

        Block statementsBlock20 =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 20) ) { return retval; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1071:3: ( argList (postMods= modifiers )? ({...}? IDENTIFIER LPAREN (t1= mutableTypeRef ( COMMA tx= mutableTypeRef )* )? RPAREN )? ( ':' i1= constructorInitializer ( COMMA ix= constructorInitializer )* )? ( ({...}? '=' DECIMAL_NUMBER )? SEMICOLON | statementsBlock ) )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1072:5: argList (postMods= modifiers )? ({...}? IDENTIFIER LPAREN (t1= mutableTypeRef ( COMMA tx= mutableTypeRef )* )? RPAREN )? ( ':' i1= constructorInitializer ( COMMA ix= constructorInitializer )* )? ( ({...}? '=' DECIMAL_NUMBER )? SEMICOLON | statementsBlock )
            {
            if ( state.backtracking==0 ) {
                  retval.initializers = new ArrayList<FunctionCall>();
                }

            pushFollow(FOLLOW_argList_in_functionDeclarationSuffix3040);
            argList19=argList();

            state._fsp--;
            if (state.failed) return retval;

            if ( state.backtracking==0 ) {
                  retval.args = (argList19!=null?argList19.args:null);
                }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1078:5: (postMods= modifiers )?
            int alt51=2;
            switch ( input.LA(1) ) {
                case IDENTIFIER:
                    {
                    switch ( input.LA(2) ) {
                        case LPAREN:
                            {
                            int LA51_7 = input.LA(3);

                            if ( ((((( next("__pragma") )||( next("__asm") )||( next("__success") )||( next(ModifierKind.VCAnnotation1Arg, ModifierKind.VCAnnotation2Args) ))&&(( next("__pragma") )||( next("__asm") )||( next("__success") )||( next(ModifierKind.VCAnnotation1Arg, ModifierKind.VCAnnotation2Args) )))&&synpred86_ObjCpp())) ) {
                                alt51=1;
                            }
                            }
                            break;
                        case IDENTIFIER:
                        case LBRACE:
                        case SEMICOLON:
                        case STRING:
                        case 51:
                        case 57:
                        case 82:
                        case 83:
                            {
                            alt51=1;
                            }
                            break;
                    }

                    }
                    break;
                case 82:
                case 83:
                    {
                    alt51=1;
                    }
                    break;
            }

            switch (alt51) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1078:7: postMods= modifiers
                    {
                    pushFollow(FOLLOW_modifiers_in_functionDeclarationSuffix3052);
                    postMods=modifiers();

                    state._fsp--;
                    if (state.failed) return retval;

                    if ( state.backtracking==0 ) { retval.postModifiers = postMods; }

                    }
                    break;

            }


            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1079:5: ({...}? IDENTIFIER LPAREN (t1= mutableTypeRef ( COMMA tx= mutableTypeRef )* )? RPAREN )?
            int alt54=2;
            switch ( input.LA(1) ) {
                case IDENTIFIER:
                    {
                    alt54=1;
                    }
                    break;
            }

            switch (alt54) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1080:7: {...}? IDENTIFIER LPAREN (t1= mutableTypeRef ( COMMA tx= mutableTypeRef )* )? RPAREN
                    {
                    if ( !(( next("throw") )) ) {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        throw new FailedPredicateException(input, "functionDeclarationSuffix", " next(\"throw\") ");
                    }

                    match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_functionDeclarationSuffix3073); if (state.failed) return retval;

                    if ( state.backtracking==0 ) {
                            retval.thrown = new ArrayList<TypeRef>();
                          }

                    match(input,LPAREN,FOLLOW_LPAREN_in_functionDeclarationSuffix3083); if (state.failed) return retval;

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1084:9: (t1= mutableTypeRef ( COMMA tx= mutableTypeRef )* )?
                    int alt53=2;
                    switch ( input.LA(1) ) {
                        case COMMA:
                        case IDENTIFIER:
                        case LPAREN:
                        case 36:
                        case 38:
                        case 52:
                        case 78:
                        case 80:
                        case 82:
                        case 83:
                        case 86:
                        case 89:
                        case 94:
                        case 97:
                        case 98:
                            {
                            alt53=1;
                            }
                            break;
                        case RPAREN:
                            {
                            int LA53_13 = input.LA(2);

                            if ( (synpred88_ObjCpp()) ) {
                                alt53=1;
                            }
                            }
                            break;
                    }

                    switch (alt53) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1085:11: t1= mutableTypeRef ( COMMA tx= mutableTypeRef )*
                            {
                            pushFollow(FOLLOW_mutableTypeRef_in_functionDeclarationSuffix3107);
                            t1=mutableTypeRef();

                            state._fsp--;
                            if (state.failed) return retval;

                            if ( state.backtracking==0 ) {
                                        retval.thrown.add(t1);
                                      }

                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1088:11: ( COMMA tx= mutableTypeRef )*
                            loop52:
                            do {
                                int alt52=2;
                                switch ( input.LA(1) ) {
                                case COMMA:
                                    {
                                    alt52=1;
                                    }
                                    break;

                                }

                                switch (alt52) {
                            	case 1 :
                            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1089:13: COMMA tx= mutableTypeRef
                            	    {
                            	    match(input,COMMA,FOLLOW_COMMA_in_functionDeclarationSuffix3135); if (state.failed) return retval;

                            	    pushFollow(FOLLOW_mutableTypeRef_in_functionDeclarationSuffix3151);
                            	    tx=mutableTypeRef();

                            	    state._fsp--;
                            	    if (state.failed) return retval;

                            	    if ( state.backtracking==0 ) {
                            	                  retval.thrown.add(tx);
                            	                }

                            	    }
                            	    break;

                            	default :
                            	    break loop52;
                                }
                            } while (true);


                            }
                            break;

                    }


                    match(input,RPAREN,FOLLOW_RPAREN_in_functionDeclarationSuffix3185); if (state.failed) return retval;

                    }
                    break;

            }


            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1097:5: ( ':' i1= constructorInitializer ( COMMA ix= constructorInitializer )* )?
            int alt56=2;
            switch ( input.LA(1) ) {
                case 51:
                    {
                    alt56=1;
                    }
                    break;
            }

            switch (alt56) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1098:7: ':' i1= constructorInitializer ( COMMA ix= constructorInitializer )*
                    {
                    match(input,51,FOLLOW_51_in_functionDeclarationSuffix3216); if (state.failed) return retval;

                    pushFollow(FOLLOW_constructorInitializer_in_functionDeclarationSuffix3226);
                    i1=constructorInitializer();

                    state._fsp--;
                    if (state.failed) return retval;

                    if ( state.backtracking==0 ) { retval.initializers.add(i1); }

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1100:7: ( COMMA ix= constructorInitializer )*
                    loop55:
                    do {
                        int alt55=2;
                        switch ( input.LA(1) ) {
                        case COMMA:
                            {
                            alt55=1;
                            }
                            break;

                        }

                        switch (alt55) {
                    	case 1 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1101:9: COMMA ix= constructorInitializer
                    	    {
                    	    match(input,COMMA,FOLLOW_COMMA_in_functionDeclarationSuffix3246); if (state.failed) return retval;

                    	    pushFollow(FOLLOW_constructorInitializer_in_functionDeclarationSuffix3250);
                    	    ix=constructorInitializer();

                    	    state._fsp--;
                    	    if (state.failed) return retval;

                    	    if ( state.backtracking==0 ) { retval.initializers.add(ix); }

                    	    }
                    	    break;

                    	default :
                    	    break loop55;
                        }
                    } while (true);


                    }
                    break;

            }


            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1104:5: ( ({...}? '=' DECIMAL_NUMBER )? SEMICOLON | statementsBlock )
            int alt58=2;
            switch ( input.LA(1) ) {
            case SEMICOLON:
            case 57:
                {
                alt58=1;
                }
                break;
            case LBRACE:
                {
                alt58=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 58, 0, input);

                throw nvae;

            }

            switch (alt58) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1105:7: ({...}? '=' DECIMAL_NUMBER )? SEMICOLON
                    {
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1105:7: ({...}? '=' DECIMAL_NUMBER )?
                    int alt57=2;
                    switch ( input.LA(1) ) {
                        case 57:
                            {
                            alt57=1;
                            }
                            break;
                    }

                    switch (alt57) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1106:9: {...}? '=' DECIMAL_NUMBER
                            {
                            if ( !(( next(2, "0") )) ) {
                                if (state.backtracking>0) {state.failed=true; return retval;}
                                throw new FailedPredicateException(input, "functionDeclarationSuffix", " next(2, \"0\") ");
                            }

                            match(input,57,FOLLOW_57_in_functionDeclarationSuffix3297); if (state.failed) return retval;

                            match(input,DECIMAL_NUMBER,FOLLOW_DECIMAL_NUMBER_in_functionDeclarationSuffix3299); if (state.failed) return retval;

                            }
                            break;

                    }


                    match(input,SEMICOLON,FOLLOW_SEMICOLON_in_functionDeclarationSuffix3317); if (state.failed) return retval;

                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1109:7: statementsBlock
                    {
                    pushFollow(FOLLOW_statementsBlock_in_functionDeclarationSuffix3327);
                    statementsBlock20=statementsBlock();

                    state._fsp--;
                    if (state.failed) return retval;

                    if ( state.backtracking==0 ) {
                            retval.body = statementsBlock20;
                          }

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);


        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 20, functionDeclarationSuffix_StartIndex); }

        }
        return retval;
    }
    // $ANTLR end "functionDeclarationSuffix"



    // $ANTLR start "constructorInitializer"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1114:1: constructorInitializer returns [FunctionCall init] : qn= qualifiedCppFunctionName LPAREN (el= topLevelExprList )? RPAREN ;
    public final FunctionCall constructorInitializer() throws RecognitionException {
        FunctionCall init = null;

        int constructorInitializer_StartIndex = input.index();

        Identifier qn =null;

        List<Expression> el =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 21) ) { return init; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1115:3: (qn= qualifiedCppFunctionName LPAREN (el= topLevelExprList )? RPAREN )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1115:6: qn= qualifiedCppFunctionName LPAREN (el= topLevelExprList )? RPAREN
            {
            pushFollow(FOLLOW_qualifiedCppFunctionName_in_constructorInitializer3354);
            qn=qualifiedCppFunctionName();

            state._fsp--;
            if (state.failed) return init;

            if ( state.backtracking==0 ) {
                  init = new FunctionCall(new TypeRefExpression(new SimpleTypeRef(qn)));
                }

            match(input,LPAREN,FOLLOW_LPAREN_in_constructorInitializer3364); if (state.failed) return init;

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1118:12: (el= topLevelExprList )?
            int alt59=2;
            switch ( input.LA(1) ) {
                case CHARACTER:
                case DECIMAL_NUMBER:
                case FLOAT_NUMBER:
                case HEXADECIMAL_NUMBER:
                case IDENTIFIER:
                case LBRACE:
                case LPAREN:
                case OCTAL_NUMBER:
                case STRING:
                case 30:
                case 36:
                case 38:
                case 40:
                case 41:
                case 43:
                case 44:
                case 66:
                case 74:
                case 77:
                case 78:
                case 103:
                    {
                    alt59=1;
                    }
                    break;
            }

            switch (alt59) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1119:7: el= topLevelExprList
                    {
                    pushFollow(FOLLOW_topLevelExprList_in_constructorInitializer3376);
                    el=topLevelExprList();

                    state._fsp--;
                    if (state.failed) return init;

                    if ( state.backtracking==0 ) { init.addArguments(el); }

                    }
                    break;

            }


            match(input,RPAREN,FOLLOW_RPAREN_in_constructorInitializer3387); if (state.failed) return init;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 21, constructorInitializer_StartIndex); }

        }
        return init;
    }
    // $ANTLR end "constructorInitializer"



    // $ANTLR start "modifiers"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1123:1: modifiers returns [List<Modifier> modifiers] : m= modifier (x= modifier )* ;
    public final List<Modifier> modifiers() throws RecognitionException {
        List<Modifier> modifiers = null;

        int modifiers_StartIndex = input.index();

        ObjCppParser.modifier_return m =null;

        ObjCppParser.modifier_return x =null;


         modifiers = new ArrayList<Modifier>(); 
        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 22) ) { return modifiers; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1125:3: (m= modifier (x= modifier )* )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1126:5: m= modifier (x= modifier )*
            {
            pushFollow(FOLLOW_modifier_in_modifiers3420);
            m=modifier();

            state._fsp--;
            if (state.failed) return modifiers;

            if ( state.backtracking==0 ) {
                  modifiers.addAll((m!=null?m.modifiers:null)); 
                }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1129:5: (x= modifier )*
            loop60:
            do {
                int alt60=2;
                alt60 = dfa60.predict(input);
                switch (alt60) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1130:7: x= modifier
            	    {
            	    pushFollow(FOLLOW_modifier_in_modifiers3440);
            	    x=modifier();

            	    state._fsp--;
            	    if (state.failed) return modifiers;

            	    if ( state.backtracking==0 ) { 
            	            modifiers.addAll((x!=null?x.modifiers:null)); 
            	          }

            	    }
            	    break;

            	default :
            	    break loop60;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 22, modifiers_StartIndex); }

        }
        return modifiers;
    }
    // $ANTLR end "modifiers"



    // $ANTLR start "pragmaContent"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1136:1: pragmaContent : IDENTIFIER LPAREN ( IDENTIFIER | constant | COMMA | ':' | LPAREN ( IDENTIFIER | constant | COMMA | ':' )* RPAREN )* RPAREN ( SEMICOLON )? ;
    public final void pragmaContent() throws RecognitionException {
        int pragmaContent_StartIndex = input.index();

        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 23) ) { return ; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1136:16: ( IDENTIFIER LPAREN ( IDENTIFIER | constant | COMMA | ':' | LPAREN ( IDENTIFIER | constant | COMMA | ':' )* RPAREN )* RPAREN ( SEMICOLON )? )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1139:7: IDENTIFIER LPAREN ( IDENTIFIER | constant | COMMA | ':' | LPAREN ( IDENTIFIER | constant | COMMA | ':' )* RPAREN )* RPAREN ( SEMICOLON )?
            {
            match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_pragmaContent3482); if (state.failed) return ;

            match(input,LPAREN,FOLLOW_LPAREN_in_pragmaContent3484); if (state.failed) return ;

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1140:9: ( IDENTIFIER | constant | COMMA | ':' | LPAREN ( IDENTIFIER | constant | COMMA | ':' )* RPAREN )*
            loop62:
            do {
                int alt62=6;
                switch ( input.LA(1) ) {
                case IDENTIFIER:
                    {
                    alt62=1;
                    }
                    break;
                case CHARACTER:
                case DECIMAL_NUMBER:
                case FLOAT_NUMBER:
                case HEXADECIMAL_NUMBER:
                case OCTAL_NUMBER:
                case STRING:
                case 40:
                case 43:
                    {
                    alt62=2;
                    }
                    break;
                case COMMA:
                    {
                    alt62=3;
                    }
                    break;
                case 51:
                    {
                    alt62=4;
                    }
                    break;
                case LPAREN:
                    {
                    alt62=5;
                    }
                    break;

                }

                switch (alt62) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1140:10: IDENTIFIER
            	    {
            	    match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_pragmaContent3495); if (state.failed) return ;

            	    }
            	    break;
            	case 2 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1140:23: constant
            	    {
            	    pushFollow(FOLLOW_constant_in_pragmaContent3499);
            	    constant();

            	    state._fsp--;
            	    if (state.failed) return ;

            	    }
            	    break;
            	case 3 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1140:34: COMMA
            	    {
            	    match(input,COMMA,FOLLOW_COMMA_in_pragmaContent3503); if (state.failed) return ;

            	    }
            	    break;
            	case 4 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1140:42: ':'
            	    {
            	    match(input,51,FOLLOW_51_in_pragmaContent3507); if (state.failed) return ;

            	    }
            	    break;
            	case 5 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1140:48: LPAREN ( IDENTIFIER | constant | COMMA | ':' )* RPAREN
            	    {
            	    match(input,LPAREN,FOLLOW_LPAREN_in_pragmaContent3511); if (state.failed) return ;

            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1140:55: ( IDENTIFIER | constant | COMMA | ':' )*
            	    loop61:
            	    do {
            	        int alt61=5;
            	        switch ( input.LA(1) ) {
            	        case IDENTIFIER:
            	            {
            	            alt61=1;
            	            }
            	            break;
            	        case CHARACTER:
            	        case DECIMAL_NUMBER:
            	        case FLOAT_NUMBER:
            	        case HEXADECIMAL_NUMBER:
            	        case OCTAL_NUMBER:
            	        case STRING:
            	        case 40:
            	        case 43:
            	            {
            	            alt61=2;
            	            }
            	            break;
            	        case COMMA:
            	            {
            	            alt61=3;
            	            }
            	            break;
            	        case 51:
            	            {
            	            alt61=4;
            	            }
            	            break;

            	        }

            	        switch (alt61) {
            	    	case 1 :
            	    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1140:56: IDENTIFIER
            	    	    {
            	    	    match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_pragmaContent3514); if (state.failed) return ;

            	    	    }
            	    	    break;
            	    	case 2 :
            	    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1140:69: constant
            	    	    {
            	    	    pushFollow(FOLLOW_constant_in_pragmaContent3518);
            	    	    constant();

            	    	    state._fsp--;
            	    	    if (state.failed) return ;

            	    	    }
            	    	    break;
            	    	case 3 :
            	    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1140:80: COMMA
            	    	    {
            	    	    match(input,COMMA,FOLLOW_COMMA_in_pragmaContent3522); if (state.failed) return ;

            	    	    }
            	    	    break;
            	    	case 4 :
            	    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1140:88: ':'
            	    	    {
            	    	    match(input,51,FOLLOW_51_in_pragmaContent3526); if (state.failed) return ;

            	    	    }
            	    	    break;

            	    	default :
            	    	    break loop61;
            	        }
            	    } while (true);


            	    match(input,RPAREN,FOLLOW_RPAREN_in_pragmaContent3530); if (state.failed) return ;

            	    }
            	    break;

            	default :
            	    break loop62;
                }
            } while (true);


            match(input,RPAREN,FOLLOW_RPAREN_in_pragmaContent3540); if (state.failed) return ;

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1142:7: ( SEMICOLON )?
            int alt63=2;
            alt63 = dfa63.predict(input);
            switch (alt63) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1142:7: SEMICOLON
                    {
                    match(input,SEMICOLON,FOLLOW_SEMICOLON_in_pragmaContent3548); if (state.failed) return ;

                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 23, pragmaContent_StartIndex); }

        }
        return ;
    }
    // $ANTLR end "pragmaContent"


    public static class modifier_return extends ParserRuleReturnScope {
        public List<Modifier> modifiers;
        public String asmName;
    };


    // $ANTLR start "modifier"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1146:1: modifier returns [List<Modifier> modifiers, String asmName] : ({...}? => pragmaContent |{...}? => IDENTIFIER ex= STRING |{...}?m= IDENTIFIER | ( '__declspec' | '__attribute__' ) ( LPAREN )+ ({...}?m= IDENTIFIER ( LPAREN arg= constant RPAREN |) )* ( RPAREN )+ |{...}? => IDENTIFIER LPAREN (an= STRING )+ RPAREN |{...}? => IDENTIFIER LPAREN 'return' binaryOp expression RPAREN |{...}? =>m= IDENTIFIER LPAREN x= constant RPAREN );
    public final ObjCppParser.modifier_return modifier() throws RecognitionException {
        ObjCppParser.modifier_return retval = new ObjCppParser.modifier_return();
        retval.start = input.LT(1);

        int modifier_StartIndex = input.index();

        Token ex=null;
        Token m=null;
        Token an=null;
        Constant arg =null;

        Constant x =null;


         retval.modifiers = new ArrayList<Modifier>(); 
        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 24) ) { return retval; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1148:3: ({...}? => pragmaContent |{...}? => IDENTIFIER ex= STRING |{...}?m= IDENTIFIER | ( '__declspec' | '__attribute__' ) ( LPAREN )+ ({...}?m= IDENTIFIER ( LPAREN arg= constant RPAREN |) )* ( RPAREN )+ |{...}? => IDENTIFIER LPAREN (an= STRING )+ RPAREN |{...}? => IDENTIFIER LPAREN 'return' binaryOp expression RPAREN |{...}? =>m= IDENTIFIER LPAREN x= constant RPAREN )
            int alt69=7;
            switch ( input.LA(1) ) {
            case IDENTIFIER:
                {
                switch ( input.LA(2) ) {
                case LPAREN:
                    {
                    int LA69_3 = input.LA(3);

                    if ( (((synpred106_ObjCpp()&&synpred106_ObjCpp())&&( next("__pragma") ))) ) {
                        alt69=1;
                    }
                    else if ( (((synpred108_ObjCpp()&&synpred108_ObjCpp())&&( parseModifier(next()) != null ))) ) {
                        alt69=3;
                    }
                    else if ( (((( next("__asm") )&&( next("__asm") ))&&synpred116_ObjCpp())) ) {
                        alt69=5;
                    }
                    else if ( (((( next("__success") )&&( next("__success") ))&&synpred117_ObjCpp())) ) {
                        alt69=6;
                    }
                    else if ( (( next(ModifierKind.VCAnnotation1Arg, ModifierKind.VCAnnotation2Args) )) ) {
                        alt69=7;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 69, 3, input);

                        throw nvae;

                    }
                    }
                    break;
                case STRING:
                    {
                    int LA69_4 = input.LA(3);

                    if ( (((( next("extern") )&&( next("extern") ))&&synpred107_ObjCpp())) ) {
                        alt69=2;
                    }
                    else if ( (((synpred108_ObjCpp()&&synpred108_ObjCpp())&&( parseModifier(next()) != null ))) ) {
                        alt69=3;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 69, 4, input);

                        throw nvae;

                    }
                    }
                    break;
                case EOF:
                case CHARACTER:
                case COMMA:
                case DECIMAL_NUMBER:
                case FLOAT_NUMBER:
                case HEXADECIMAL_NUMBER:
                case IDENTIFIER:
                case LBRACE:
                case OCTAL_NUMBER:
                case RBRACE:
                case RPAREN:
                case SEMICOLON:
                case 30:
                case 31:
                case 33:
                case 34:
                case 35:
                case 36:
                case 37:
                case 38:
                case 39:
                case 40:
                case 41:
                case 42:
                case 43:
                case 44:
                case 45:
                case 49:
                case 50:
                case 51:
                case 52:
                case 53:
                case 54:
                case 55:
                case 56:
                case 57:
                case 58:
                case 59:
                case 60:
                case 61:
                case 62:
                case 64:
                case 66:
                case 74:
                case 77:
                case 78:
                case 79:
                case 80:
                case 81:
                case 82:
                case 83:
                case 86:
                case 89:
                case 94:
                case 97:
                case 98:
                case 100:
                case 101:
                case 102:
                case 103:
                case 104:
                    {
                    alt69=3;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 69, 1, input);

                    throw nvae;

                }

                }
                break;
            case 82:
            case 83:
                {
                alt69=4;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 69, 0, input);

                throw nvae;

            }

            switch (alt69) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1150:5: {...}? => pragmaContent
                    {
                    if ( !(( next("__pragma") )) ) {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        throw new FailedPredicateException(input, "modifier", " next(\"__pragma\") ");
                    }

                    pushFollow(FOLLOW_pragmaContent_in_modifier3588);
                    pragmaContent();

                    state._fsp--;
                    if (state.failed) return retval;

                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1151:5: {...}? => IDENTIFIER ex= STRING
                    {
                    if ( !(( next("extern") )) ) {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        throw new FailedPredicateException(input, "modifier", " next(\"extern\") ");
                    }

                    match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_modifier3600); if (state.failed) return retval;

                    ex=(Token)match(input,STRING,FOLLOW_STRING_in_modifier3604); if (state.failed) return retval;

                    if ( state.backtracking==0 ) {
                          retval.modifiers.add(ModifierType.Extern); // TODO
                        }

                    }
                    break;
                case 3 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1154:5: {...}?m= IDENTIFIER
                    {
                    if ( !(( parseModifier(next()) != null )) ) {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        throw new FailedPredicateException(input, "modifier", " parseModifier(next()) != null ");
                    }

                    m=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_modifier3618); if (state.failed) return retval;

                    if ( state.backtracking==0 ) {
                          retval.modifiers.add(ModifierType.parseModifier((m!=null?m.getText():null)));
                        }

                    }
                    break;
                case 4 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1158:5: ( '__declspec' | '__attribute__' ) ( LPAREN )+ ({...}?m= IDENTIFIER ( LPAREN arg= constant RPAREN |) )* ( RPAREN )+
                    {
                    if ( (input.LA(1) >= 82 && input.LA(1) <= 83) ) {
                        input.consume();
                        state.errorRecovery=false;
                        state.failed=false;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }


                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1159:5: ( LPAREN )+
                    int cnt64=0;
                    loop64:
                    do {
                        int alt64=2;
                        switch ( input.LA(1) ) {
                        case LPAREN:
                            {
                            alt64=1;
                            }
                            break;

                        }

                        switch (alt64) {
                    	case 1 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1159:5: LPAREN
                    	    {
                    	    match(input,LPAREN,FOLLOW_LPAREN_in_modifier3647); if (state.failed) return retval;

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt64 >= 1 ) break loop64;
                    	    if (state.backtracking>0) {state.failed=true; return retval;}
                                EarlyExitException eee =
                                    new EarlyExitException(64, input);
                                throw eee;
                        }
                        cnt64++;
                    } while (true);


                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1159:13: ({...}?m= IDENTIFIER ( LPAREN arg= constant RPAREN |) )*
                    loop66:
                    do {
                        int alt66=2;
                        switch ( input.LA(1) ) {
                        case IDENTIFIER:
                            {
                            alt66=1;
                            }
                            break;

                        }

                        switch (alt66) {
                    	case 1 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1160:7: {...}?m= IDENTIFIER ( LPAREN arg= constant RPAREN |)
                    	    {
                    	    if ( !(( next(ModifierKind.Extended) )) ) {
                    	        if (state.backtracking>0) {state.failed=true; return retval;}
                    	        throw new FailedPredicateException(input, "modifier", " next(ModifierKind.Extended) ");
                    	    }

                    	    m=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_modifier3664); if (state.failed) return retval;

                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1161:7: ( LPAREN arg= constant RPAREN |)
                    	    int alt65=2;
                    	    switch ( input.LA(1) ) {
                    	    case LPAREN:
                    	        {
                    	        alt65=1;
                    	        }
                    	        break;
                    	    case IDENTIFIER:
                    	    case RPAREN:
                    	        {
                    	        alt65=2;
                    	        }
                    	        break;
                    	    default:
                    	        if (state.backtracking>0) {state.failed=true; return retval;}
                    	        NoViableAltException nvae =
                    	            new NoViableAltException("", 65, 0, input);

                    	        throw nvae;

                    	    }

                    	    switch (alt65) {
                    	        case 1 :
                    	            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1162:9: LPAREN arg= constant RPAREN
                    	            {
                    	            match(input,LPAREN,FOLLOW_LPAREN_in_modifier3683); if (state.failed) return retval;

                    	            pushFollow(FOLLOW_constant_in_modifier3687);
                    	            arg=constant();

                    	            state._fsp--;
                    	            if (state.failed) return retval;

                    	            match(input,RPAREN,FOLLOW_RPAREN_in_modifier3689); if (state.failed) return retval;

                    	            if ( state.backtracking==0 ) {
                    	                      retval.modifiers.add(new ValuedModifier(ModifierType.parseModifier((m!=null?m.getText():null)), arg));
                    	                    }

                    	            }
                    	            break;
                    	        case 2 :
                    	            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1165:9: 
                    	            {
                    	            if ( state.backtracking==0 ) {
                    	                      retval.modifiers.add(ModifierType.parseModifier((m!=null?m.getText():null)));
                    	                    }

                    	            }
                    	            break;

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop66;
                        }
                    } while (true);


                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1171:8: ( RPAREN )+
                    int cnt67=0;
                    loop67:
                    do {
                        int alt67=2;
                        alt67 = dfa67.predict(input);
                        switch (alt67) {
                    	case 1 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1171:8: RPAREN
                    	    {
                    	    match(input,RPAREN,FOLLOW_RPAREN_in_modifier3732); if (state.failed) return retval;

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt67 >= 1 ) break loop67;
                    	    if (state.backtracking>0) {state.failed=true; return retval;}
                                EarlyExitException eee =
                                    new EarlyExitException(67, input);
                                throw eee;
                        }
                        cnt67++;
                    } while (true);


                    }
                    break;
                case 5 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1172:5: {...}? => IDENTIFIER LPAREN (an= STRING )+ RPAREN
                    {
                    if ( !(( next("__asm") )) ) {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        throw new FailedPredicateException(input, "modifier", " next(\"__asm\") ");
                    }

                    match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_modifier3744); if (state.failed) return retval;

                    match(input,LPAREN,FOLLOW_LPAREN_in_modifier3746); if (state.failed) return retval;

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1172:44: (an= STRING )+
                    int cnt68=0;
                    loop68:
                    do {
                        int alt68=2;
                        switch ( input.LA(1) ) {
                        case STRING:
                            {
                            alt68=1;
                            }
                            break;

                        }

                        switch (alt68) {
                    	case 1 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1173:7: an= STRING
                    	    {
                    	    an=(Token)match(input,STRING,FOLLOW_STRING_in_modifier3759); if (state.failed) return retval;

                    	    if ( state.backtracking==0 ) { 
                    	            String s = String.valueOf(Constant.parseString((an!=null?an.getText():null)).getValue());
                    	            if (retval.asmName == null) 
                    	              retval.asmName = s; 
                    	            else 
                    	              retval.asmName += s; 
                    	          }

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt68 >= 1 ) break loop68;
                    	    if (state.backtracking>0) {state.failed=true; return retval;}
                                EarlyExitException eee =
                                    new EarlyExitException(68, input);
                                throw eee;
                        }
                        cnt68++;
                    } while (true);


                    match(input,RPAREN,FOLLOW_RPAREN_in_modifier3771); if (state.failed) return retval;

                    }
                    break;
                case 6 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1181:5: {...}? => IDENTIFIER LPAREN 'return' binaryOp expression RPAREN
                    {
                    if ( !(( next("__success") )) ) {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        throw new FailedPredicateException(input, "modifier", " next(\"__success\") ");
                    }

                    match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_modifier3786); if (state.failed) return retval;

                    match(input,LPAREN,FOLLOW_LPAREN_in_modifier3788); if (state.failed) return retval;

                    match(input,93,FOLLOW_93_in_modifier3790); if (state.failed) return retval;

                    pushFollow(FOLLOW_binaryOp_in_modifier3792);
                    binaryOp();

                    state._fsp--;
                    if (state.failed) return retval;

                    pushFollow(FOLLOW_expression_in_modifier3794);
                    expression();

                    state._fsp--;
                    if (state.failed) return retval;

                    match(input,RPAREN,FOLLOW_RPAREN_in_modifier3797); if (state.failed) return retval;

                    }
                    break;
                case 7 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1185:5: {...}? =>m= IDENTIFIER LPAREN x= constant RPAREN
                    {
                    if ( !(( next(ModifierKind.VCAnnotation1Arg, ModifierKind.VCAnnotation2Args) )) ) {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        throw new FailedPredicateException(input, "modifier", " next(ModifierKind.VCAnnotation1Arg, ModifierKind.VCAnnotation2Args) ");
                    }

                    m=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_modifier3824); if (state.failed) return retval;

                    match(input,LPAREN,FOLLOW_LPAREN_in_modifier3826); if (state.failed) return retval;

                    pushFollow(FOLLOW_constant_in_modifier3830);
                    x=constant();

                    state._fsp--;
                    if (state.failed) return retval;

                    match(input,RPAREN,FOLLOW_RPAREN_in_modifier3832); if (state.failed) return retval;

                    if ( state.backtracking==0 ) {
                          retval.modifiers.add(new ValuedModifier(ModifierType.parseModifier((m!=null?m.getText():null)), x));
                        }

                    }
                    break;

            }
            retval.stop = input.LT(-1);


        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 24, modifier_StartIndex); }

        }
        return retval;
    }
    // $ANTLR end "modifier"



    // $ANTLR start "extendedModifiers"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1192:1: extendedModifiers returns [List<Modifier> modifiers] : ({...}?m= IDENTIFIER ( LPAREN arg= constant RPAREN |) )* ;
    public final List<Modifier> extendedModifiers() throws RecognitionException {
        ModContext_stack.push(new ModContext_scope());

        List<Modifier> modifiers = null;

        int extendedModifiers_StartIndex = input.index();

        Token m=null;
        Constant arg =null;



          ((ModContext_scope)ModContext_stack.peek()).isInExtMod = true;

        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 25) ) { return modifiers; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1197:3: ( ({...}?m= IDENTIFIER ( LPAREN arg= constant RPAREN |) )* )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1197:6: ({...}?m= IDENTIFIER ( LPAREN arg= constant RPAREN |) )*
            {
            if ( state.backtracking==0 ) { modifiers = new ArrayList<Modifier>(); }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1198:5: ({...}?m= IDENTIFIER ( LPAREN arg= constant RPAREN |) )*
            loop71:
            do {
                int alt71=2;
                switch ( input.LA(1) ) {
                case IDENTIFIER:
                    {
                    alt71=1;
                    }
                    break;

                }

                switch (alt71) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1199:7: {...}?m= IDENTIFIER ( LPAREN arg= constant RPAREN |)
            	    {
            	    if ( !(( next(ModifierKind.Extended) )) ) {
            	        if (state.backtracking>0) {state.failed=true; return modifiers;}
            	        throw new FailedPredicateException(input, "extendedModifiers", " next(ModifierKind.Extended) ");
            	    }

            	    m=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_extendedModifiers3881); if (state.failed) return modifiers;

            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1200:7: ( LPAREN arg= constant RPAREN |)
            	    int alt70=2;
            	    switch ( input.LA(1) ) {
            	    case LPAREN:
            	        {
            	        alt70=1;
            	        }
            	        break;
            	    case EOF:
            	    case IDENTIFIER:
            	        {
            	        alt70=2;
            	        }
            	        break;
            	    default:
            	        if (state.backtracking>0) {state.failed=true; return modifiers;}
            	        NoViableAltException nvae =
            	            new NoViableAltException("", 70, 0, input);

            	        throw nvae;

            	    }

            	    switch (alt70) {
            	        case 1 :
            	            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1201:9: LPAREN arg= constant RPAREN
            	            {
            	            match(input,LPAREN,FOLLOW_LPAREN_in_extendedModifiers3900); if (state.failed) return modifiers;

            	            pushFollow(FOLLOW_constant_in_extendedModifiers3904);
            	            arg=constant();

            	            state._fsp--;
            	            if (state.failed) return modifiers;

            	            match(input,RPAREN,FOLLOW_RPAREN_in_extendedModifiers3906); if (state.failed) return modifiers;

            	            if ( state.backtracking==0 ) {
            	                      modifiers.add(new ValuedModifier(ModifierType.parseModifier((m!=null?m.getText():null)), arg));
            	                    }

            	            }
            	            break;
            	        case 2 :
            	            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1204:9: 
            	            {
            	            if ( state.backtracking==0 ) {
            	                      modifiers.add(ModifierType.parseModifier((m!=null?m.getText():null)));
            	                    }

            	            }
            	            break;

            	    }


            	    }
            	    break;

            	default :
            	    break loop71;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 25, extendedModifiers_StartIndex); }

            ModContext_stack.pop();

        }
        return modifiers;
    }
    // $ANTLR end "extendedModifiers"


    public static class argDef_return extends ParserRuleReturnScope {
        public Arg arg;
    };


    // $ANTLR start "argDef"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1210:1: argDef returns [Arg arg] : ( (tr= mutableTypeRef ) ( declarator )? ( '=' dv= topLevelExpr )? | '...' );
    public final ObjCppParser.argDef_return argDef() throws RecognitionException {
        ObjCppParser.argDef_return retval = new ObjCppParser.argDef_return();
        retval.start = input.LT(1);

        int argDef_StartIndex = input.index();

        TypeRef tr =null;

        ObjCppParser.topLevelExpr_return dv =null;

        Declarator declarator21 =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 26) ) { return retval; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1211:3: ( (tr= mutableTypeRef ) ( declarator )? ( '=' dv= topLevelExpr )? | '...' )
            int alt74=2;
            switch ( input.LA(1) ) {
            case EOF:
            case COMMA:
            case IDENTIFIER:
            case LPAREN:
            case RPAREN:
            case 36:
            case 38:
            case 51:
            case 52:
            case 57:
            case 59:
            case 78:
            case 80:
            case 82:
            case 83:
            case 86:
            case 89:
            case 94:
            case 97:
            case 98:
                {
                alt74=1;
                }
                break;
            case 48:
                {
                alt74=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 74, 0, input);

                throw nvae;

            }

            switch (alt74) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1211:6: (tr= mutableTypeRef ) ( declarator )? ( '=' dv= topLevelExpr )?
                    {
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1211:6: (tr= mutableTypeRef )
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1212:7: tr= mutableTypeRef
                    {
                    pushFollow(FOLLOW_mutableTypeRef_in_argDef3963);
                    tr=mutableTypeRef();

                    state._fsp--;
                    if (state.failed) return retval;

                    if ( state.backtracking==0 ) { 
                            if (tr != null) {
                              retval.arg = new Arg(); 
                              retval.arg.setValueType(tr); 
                              int i = getTokenStream().index() + 1;
                              retval.arg.setCommentBefore(getCommentBefore(i));
                              retval.arg.setCommentAfter(getCommentAfterOnSameLine(i, ")"));
                            }
                          }

                    }


                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1222:5: ( declarator )?
                    int alt72=2;
                    switch ( input.LA(1) ) {
                        case IDENTIFIER:
                        case LPAREN:
                        case 36:
                        case 38:
                        case 51:
                        case 80:
                        case 82:
                        case 83:
                            {
                            alt72=1;
                            }
                            break;
                    }

                    switch (alt72) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1223:7: declarator
                            {
                            pushFollow(FOLLOW_declarator_in_argDef3985);
                            declarator21=declarator();

                            state._fsp--;
                            if (state.failed) return retval;

                            if ( state.backtracking==0 ) { 
                                    if (retval.arg != null) {
                                      retval.arg.setDeclarator(declarator21); 
                                    }
                                  }

                            }
                            break;

                    }


                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1232:5: ( '=' dv= topLevelExpr )?
                    int alt73=2;
                    switch ( input.LA(1) ) {
                        case 57:
                            {
                            switch ( input.LA(2) ) {
                                case LPAREN:
                                    {
                                    int LA73_6 = input.LA(3);

                                    if ( (synpred121_ObjCpp()) ) {
                                        alt73=1;
                                    }
                                    }
                                    break;
                                case IDENTIFIER:
                                    {
                                    int LA73_7 = input.LA(3);

                                    if ( (synpred121_ObjCpp()) ) {
                                        alt73=1;
                                    }
                                    }
                                    break;
                                case 43:
                                    {
                                    int LA73_8 = input.LA(3);

                                    if ( (synpred121_ObjCpp()) ) {
                                        alt73=1;
                                    }
                                    }
                                    break;
                                case DECIMAL_NUMBER:
                                    {
                                    int LA73_9 = input.LA(3);

                                    if ( (synpred121_ObjCpp()) ) {
                                        alt73=1;
                                    }
                                    }
                                    break;
                                case HEXADECIMAL_NUMBER:
                                    {
                                    int LA73_10 = input.LA(3);

                                    if ( (synpred121_ObjCpp()) ) {
                                        alt73=1;
                                    }
                                    }
                                    break;
                                case OCTAL_NUMBER:
                                    {
                                    int LA73_11 = input.LA(3);

                                    if ( (synpred121_ObjCpp()) ) {
                                        alt73=1;
                                    }
                                    }
                                    break;
                                case CHARACTER:
                                    {
                                    int LA73_12 = input.LA(3);

                                    if ( (synpred121_ObjCpp()) ) {
                                        alt73=1;
                                    }
                                    }
                                    break;
                                case FLOAT_NUMBER:
                                    {
                                    int LA73_13 = input.LA(3);

                                    if ( (synpred121_ObjCpp()) ) {
                                        alt73=1;
                                    }
                                    }
                                    break;
                                case STRING:
                                    {
                                    int LA73_14 = input.LA(3);

                                    if ( (synpred121_ObjCpp()) ) {
                                        alt73=1;
                                    }
                                    }
                                    break;
                                case 78:
                                    {
                                    int LA73_15 = input.LA(3);

                                    if ( (synpred121_ObjCpp()) ) {
                                        alt73=1;
                                    }
                                    }
                                    break;
                                case LBRACE:
                                    {
                                    int LA73_16 = input.LA(3);

                                    if ( (synpred121_ObjCpp()) ) {
                                        alt73=1;
                                    }
                                    }
                                    break;
                                case 77:
                                    {
                                    int LA73_17 = input.LA(3);

                                    if ( (synpred121_ObjCpp()) ) {
                                        alt73=1;
                                    }
                                    }
                                    break;
                                case 74:
                                    {
                                    int LA73_18 = input.LA(3);

                                    if ( (synpred121_ObjCpp()) ) {
                                        alt73=1;
                                    }
                                    }
                                    break;
                                case 66:
                                    {
                                    int LA73_19 = input.LA(3);

                                    if ( (synpred121_ObjCpp()) ) {
                                        alt73=1;
                                    }
                                    }
                                    break;
                                case 40:
                                    {
                                    int LA73_20 = input.LA(3);

                                    if ( (synpred121_ObjCpp()) ) {
                                        alt73=1;
                                    }
                                    }
                                    break;
                                case 30:
                                case 36:
                                case 38:
                                case 41:
                                case 44:
                                case 103:
                                    {
                                    int LA73_21 = input.LA(3);

                                    if ( (synpred121_ObjCpp()) ) {
                                        alt73=1;
                                    }
                                    }
                                    break;
                            }

                            }
                            break;
                    }

                    switch (alt73) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1232:7: '=' dv= topLevelExpr
                            {
                            match(input,57,FOLLOW_57_in_argDef4008); if (state.failed) return retval;

                            pushFollow(FOLLOW_topLevelExpr_in_argDef4012);
                            dv=topLevelExpr();

                            state._fsp--;
                            if (state.failed) return retval;

                            if ( state.backtracking==0 ) {
                                  if (retval.arg != null)
                                    retval.arg.setDefaultValue((dv!=null?dv.expr:null));
                                }

                            }
                            break;

                    }


                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1237:5: '...'
                    {
                    match(input,48,FOLLOW_48_in_argDef4031); if (state.failed) return retval;

                    if ( state.backtracking==0 ) { 
                          retval.arg = Arg.createVarArgs(); 
                        }

                    }
                    break;

            }
            retval.stop = input.LT(-1);


        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 26, argDef_StartIndex); }

        }
        return retval;
    }
    // $ANTLR end "argDef"



    // $ANTLR start "typeMutator"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1242:1: typeMutator returns [TypeMutator mutator] : ({...}? => IDENTIFIER | '*' | '&' | '^' | '[' ( expression |) ']' );
    public final TypeMutator typeMutator() throws RecognitionException {
        TypeMutator mutator = null;

        int typeMutator_StartIndex = input.index();

        Expression expression22 =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 27) ) { return mutator; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1243:3: ({...}? => IDENTIFIER | '*' | '&' | '^' | '[' ( expression |) ']' )
            int alt76=5;
            int LA76_0 = input.LA(1);

            if ( (LA76_0==IDENTIFIER) && (( next("const", "__const") ))) {
                alt76=1;
            }
            else if ( (LA76_0==38) ) {
                alt76=2;
            }
            else if ( (LA76_0==36) ) {
                alt76=3;
            }
            else if ( (LA76_0==80) ) {
                alt76=4;
            }
            else if ( (LA76_0==78) ) {
                alt76=5;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return mutator;}
                NoViableAltException nvae =
                    new NoViableAltException("", 76, 0, input);

                throw nvae;

            }
            switch (alt76) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1244:5: {...}? => IDENTIFIER
                    {
                    if ( !(( next("const", "__const") )) ) {
                        if (state.backtracking>0) {state.failed=true; return mutator;}
                        throw new FailedPredicateException(input, "typeMutator", " next(\"const\", \"__const\") ");
                    }

                    match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_typeMutator4059); if (state.failed) return mutator;

                    if ( state.backtracking==0 ) { 
                          mutator = TypeMutator.CONST; 
                        }

                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1247:5: '*'
                    {
                    match(input,38,FOLLOW_38_in_typeMutator4069); if (state.failed) return mutator;

                    if ( state.backtracking==0 ) { 
                          mutator = TypeMutator.STAR;
                        }

                    }
                    break;
                case 3 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1250:5: '&'
                    {
                    match(input,36,FOLLOW_36_in_typeMutator4079); if (state.failed) return mutator;

                    if ( state.backtracking==0 ) { 
                          mutator = TypeMutator.AMPERSTAND; 
                        }

                    }
                    break;
                case 4 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1253:5: '^'
                    {
                    match(input,80,FOLLOW_80_in_typeMutator4089); if (state.failed) return mutator;

                    if ( state.backtracking==0 ) { 
                          mutator = TypeMutator.HAT; 
                        }

                    }
                    break;
                case 5 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1256:5: '[' ( expression |) ']'
                    {
                    match(input,78,FOLLOW_78_in_typeMutator4099); if (state.failed) return mutator;

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1257:7: ( expression |)
                    int alt75=2;
                    switch ( input.LA(1) ) {
                    case CHARACTER:
                    case DECIMAL_NUMBER:
                    case FLOAT_NUMBER:
                    case HEXADECIMAL_NUMBER:
                    case IDENTIFIER:
                    case LBRACE:
                    case LPAREN:
                    case OCTAL_NUMBER:
                    case STRING:
                    case 30:
                    case 36:
                    case 38:
                    case 40:
                    case 41:
                    case 43:
                    case 44:
                    case 66:
                    case 74:
                    case 77:
                    case 78:
                    case 103:
                        {
                        alt75=1;
                        }
                        break;
                    case 79:
                        {
                        alt75=2;
                        }
                        break;
                    default:
                        if (state.backtracking>0) {state.failed=true; return mutator;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 75, 0, input);

                        throw nvae;

                    }

                    switch (alt75) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1258:10: expression
                            {
                            pushFollow(FOLLOW_expression_in_typeMutator4119);
                            expression22=expression();

                            state._fsp--;
                            if (state.failed) return mutator;

                            if ( state.backtracking==0 ) {
                            	        mutator = TypeMutator.array(expression22); 
                            	      }

                            }
                            break;
                        case 2 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1261:8: 
                            {
                            if ( state.backtracking==0 ) {
                            	      	mutator = TypeMutator.BRACKETS;
                            	      }

                            }
                            break;

                    }


                    match(input,79,FOLLOW_79_in_typeMutator4154); if (state.failed) return mutator;

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 27, typeMutator_StartIndex); }

        }
        return mutator;
    }
    // $ANTLR end "typeMutator"



    // $ANTLR start "templatePrefix"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1268:1: templatePrefix returns [Template template] :{...}? IDENTIFIER '<' (t1= templateArgDecl ( COMMA tx= templateArgDecl )* )? '>' ;
    public final Template templatePrefix() throws RecognitionException {
        Template template = null;

        int templatePrefix_StartIndex = input.index();

        Arg t1 =null;

        Arg tx =null;



          template = new Template();

        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 28) ) { return template; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1272:3: ({...}? IDENTIFIER '<' (t1= templateArgDecl ( COMMA tx= templateArgDecl )* )? '>' )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1273:5: {...}? IDENTIFIER '<' (t1= templateArgDecl ( COMMA tx= templateArgDecl )* )? '>'
            {
            if ( !(( next("template") )) ) {
                if (state.backtracking>0) {state.failed=true; return template;}
                throw new FailedPredicateException(input, "templatePrefix", " next(\"template\") ");
            }

            match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_templatePrefix4185); if (state.failed) return template;

            match(input,53,FOLLOW_53_in_templatePrefix4192); if (state.failed) return template;

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1275:5: (t1= templateArgDecl ( COMMA tx= templateArgDecl )* )?
            int alt78=2;
            switch ( input.LA(1) ) {
                case COMMA:
                case IDENTIFIER:
                case LPAREN:
                case 36:
                case 38:
                case 48:
                case 51:
                case 52:
                case 57:
                case 78:
                case 80:
                case 82:
                case 83:
                case 86:
                case 89:
                case 94:
                case 97:
                case 98:
                    {
                    alt78=1;
                    }
                    break;
                case 59:
                    {
                    int LA78_16 = input.LA(2);

                    if ( (synpred129_ObjCpp()) ) {
                        alt78=1;
                    }
                    }
                    break;
            }

            switch (alt78) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1276:7: t1= templateArgDecl ( COMMA tx= templateArgDecl )*
                    {
                    pushFollow(FOLLOW_templateArgDecl_in_templatePrefix4209);
                    t1=templateArgDecl();

                    state._fsp--;
                    if (state.failed) return template;

                    if ( state.backtracking==0 ) {
                            template.addArg(t1);
                          }

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1279:7: ( COMMA tx= templateArgDecl )*
                    loop77:
                    do {
                        int alt77=2;
                        switch ( input.LA(1) ) {
                        case COMMA:
                            {
                            alt77=1;
                            }
                            break;

                        }

                        switch (alt77) {
                    	case 1 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1280:9: COMMA tx= templateArgDecl
                    	    {
                    	    match(input,COMMA,FOLLOW_COMMA_in_templatePrefix4229); if (state.failed) return template;

                    	    pushFollow(FOLLOW_templateArgDecl_in_templatePrefix4233);
                    	    tx=templateArgDecl();

                    	    state._fsp--;
                    	    if (state.failed) return template;

                    	    if ( state.backtracking==0 ) {
                    	              template.addArg(tx);
                    	            }

                    	    }
                    	    break;

                    	default :
                    	    break loop77;
                        }
                    } while (true);


                    }
                    break;

            }


            match(input,59,FOLLOW_59_in_templatePrefix4259); if (state.failed) return template;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 28, templatePrefix_StartIndex); }

        }
        return template;
    }
    // $ANTLR end "templatePrefix"



    // $ANTLR start "templateArgDecl"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1288:1: templateArgDecl returns [Arg arg] : (t= ( 'class' | 'typename' ) n= IDENTIFIER ( '=' tr= mutableTypeRef )? | argDef ( '=' v= expression )? );
    public final Arg templateArgDecl() throws RecognitionException {
        Arg arg = null;

        int templateArgDecl_StartIndex = input.index();

        Token t=null;
        Token n=null;
        TypeRef tr =null;

        Expression v =null;

        ObjCppParser.argDef_return argDef23 =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 29) ) { return arg; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1289:3: (t= ( 'class' | 'typename' ) n= IDENTIFIER ( '=' tr= mutableTypeRef )? | argDef ( '=' v= expression )? )
            int alt81=2;
            int LA81_0 = input.LA(1);

            if ( (LA81_0==97) ) {
                switch ( input.LA(2) ) {
                case IDENTIFIER:
                    {
                    int LA81_19 = input.LA(3);

                    if ( (synpred132_ObjCpp()) ) {
                        alt81=1;
                    }
                    else if ( (true) ) {
                        alt81=2;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return arg;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 81, 19, input);

                        throw nvae;

                    }
                    }
                    break;
                case 52:
                    {
                    alt81=2;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return arg;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 81, 1, input);

                    throw nvae;

                }

            }
            else if ( (LA81_0==IDENTIFIER||(LA81_0 >= 82 && LA81_0 <= 83)) ) {
                alt81=2;
            }
            else if ( (LA81_0==86) ) {
                switch ( input.LA(2) ) {
                case IDENTIFIER:
                    {
                    int LA81_21 = input.LA(3);

                    if ( (synpred132_ObjCpp()) ) {
                        alt81=1;
                    }
                    else if ( (true) ) {
                        alt81=2;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return arg;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 81, 21, input);

                        throw nvae;

                    }
                    }
                    break;
                case LBRACE:
                case 52:
                case 82:
                case 83:
                    {
                    alt81=2;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return arg;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 81, 4, input);

                    throw nvae;

                }

            }
            else if ( (LA81_0==52) && (( 
                    next(2, "<") ||
                    isTypeIdentifier(next()) || 
                    (
                      parseModifier(next(1)) == null &&
                      //(isTypeDef() || !next(2, "=", ",", ";", ":", "[", "(", ")"))
                      !next(2, "=", ",", ";", ":", "[", "(", ")")
                    ) 
                  ))) {
                alt81=2;
            }
            else if ( (LA81_0==EOF||LA81_0==COMMA||LA81_0==LPAREN||LA81_0==36||LA81_0==38||LA81_0==48||LA81_0==51||LA81_0==57||LA81_0==59||LA81_0==78||LA81_0==80||LA81_0==89||LA81_0==94||LA81_0==98) ) {
                alt81=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return arg;}
                NoViableAltException nvae =
                    new NoViableAltException("", 81, 0, input);

                throw nvae;

            }
            switch (alt81) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1289:6: t= ( 'class' | 'typename' ) n= IDENTIFIER ( '=' tr= mutableTypeRef )?
                    {
                    t=(Token)input.LT(1);

                    if ( input.LA(1)==86||input.LA(1)==97 ) {
                        input.consume();
                        state.errorRecovery=false;
                        state.failed=false;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return arg;}
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }


                    n=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_templateArgDecl4291); if (state.failed) return arg;

                    if ( state.backtracking==0 ) {
                          arg = new Arg((n!=null?n.getText():null), new SimpleTypeRef((t!=null?t.getText():null)));
                          addTypeIdent((n!=null?n.getText():null));
                        }

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1293:5: ( '=' tr= mutableTypeRef )?
                    int alt79=2;
                    switch ( input.LA(1) ) {
                        case 57:
                            {
                            alt79=1;
                            }
                            break;
                    }

                    switch (alt79) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1294:7: '=' tr= mutableTypeRef
                            {
                            match(input,57,FOLLOW_57_in_templateArgDecl4309); if (state.failed) return arg;

                            pushFollow(FOLLOW_mutableTypeRef_in_templateArgDecl4313);
                            tr=mutableTypeRef();

                            state._fsp--;
                            if (state.failed) return arg;

                            if ( state.backtracking==0 ) {
                                    arg.setDefaultValue(expr(tr));
                                  }

                            }
                            break;

                    }


                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1298:5: argDef ( '=' v= expression )?
                    {
                    pushFollow(FOLLOW_argDef_in_templateArgDecl4330);
                    argDef23=argDef();

                    state._fsp--;
                    if (state.failed) return arg;

                    if ( state.backtracking==0 ) {
                          arg = (argDef23!=null?argDef23.arg:null);
                        }

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1301:5: ( '=' v= expression )?
                    int alt80=2;
                    switch ( input.LA(1) ) {
                        case 57:
                            {
                            alt80=1;
                            }
                            break;
                    }

                    switch (alt80) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1302:7: '=' v= expression
                            {
                            match(input,57,FOLLOW_57_in_templateArgDecl4348); if (state.failed) return arg;

                            pushFollow(FOLLOW_expression_in_templateArgDecl4352);
                            v=expression();

                            state._fsp--;
                            if (state.failed) return arg;

                            if ( state.backtracking==0 ) {
                                    arg.setDefaultValue(v);
                                  }

                            }
                            break;

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 29, templateArgDecl_StartIndex); }

        }
        return arg;
    }
    // $ANTLR end "templateArgDecl"


    public static class functionSignatureSuffix_return extends ParserRuleReturnScope {
        public FunctionSignature signature;
        public PointerStyle pointerStyle;
    };


    // $ANTLR start "functionSignatureSuffix"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1308:1: functionSignatureSuffix returns [FunctionSignature signature, PointerStyle pointerStyle] : tk= LPAREN (m1= modifiers )? (pt= ( '*' | '^' ) (m2= modifiers )? )? (ii= IDENTIFIER )? RPAREN LPAREN (a1= argDef ( COMMA ax= argDef )* )? RPAREN ;
    public final ObjCppParser.functionSignatureSuffix_return functionSignatureSuffix() throws RecognitionException {
        ObjCppParser.functionSignatureSuffix_return retval = new ObjCppParser.functionSignatureSuffix_return();
        retval.start = input.LT(1);

        int functionSignatureSuffix_StartIndex = input.index();

        Token tk=null;
        Token pt=null;
        Token ii=null;
        List<Modifier> m1 =null;

        List<Modifier> m2 =null;

        ObjCppParser.argDef_return a1 =null;

        ObjCppParser.argDef_return ax =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 30) ) { return retval; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1309:3: (tk= LPAREN (m1= modifiers )? (pt= ( '*' | '^' ) (m2= modifiers )? )? (ii= IDENTIFIER )? RPAREN LPAREN (a1= argDef ( COMMA ax= argDef )* )? RPAREN )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1309:6: tk= LPAREN (m1= modifiers )? (pt= ( '*' | '^' ) (m2= modifiers )? )? (ii= IDENTIFIER )? RPAREN LPAREN (a1= argDef ( COMMA ax= argDef )* )? RPAREN
            {
            tk=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_functionSignatureSuffix4387); if (state.failed) return retval;

            if ( state.backtracking==0 ) {
                  retval.signature = mark(new FunctionSignature(new Function(Function.Type.CFunction, null, null)), getLine(tk));
                  retval.signature.getFunction().setType(Function.Type.CFunction);
                }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1313:5: (m1= modifiers )?
            int alt82=2;
            switch ( input.LA(1) ) {
                case IDENTIFIER:
                    {
                    int LA82_1 = input.LA(2);

                    if ( ((((( next("extern") )||( next("__pragma") )||( parseModifier(next()) != null )||( next("__asm") )||( next("__success") )||( next(ModifierKind.VCAnnotation1Arg, ModifierKind.VCAnnotation2Args) ))&&(( next("extern") )||( next("__pragma") )||( parseModifier(next()) != null )||( next("__asm") )||( next("__success") )||( next(ModifierKind.VCAnnotation1Arg, ModifierKind.VCAnnotation2Args) )))&&synpred134_ObjCpp())) ) {
                        alt82=1;
                    }
                    }
                    break;
                case 82:
                case 83:
                    {
                    alt82=1;
                    }
                    break;
            }

            switch (alt82) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1314:7: m1= modifiers
                    {
                    pushFollow(FOLLOW_modifiers_in_functionSignatureSuffix4405);
                    m1=modifiers();

                    state._fsp--;
                    if (state.failed) return retval;

                    if ( state.backtracking==0 ) {
                            retval.signature.getFunction().addModifiers(m1);
                          }

                    }
                    break;

            }


            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1318:5: (pt= ( '*' | '^' ) (m2= modifiers )? )?
            int alt84=2;
            switch ( input.LA(1) ) {
                case 38:
                case 80:
                    {
                    alt84=1;
                    }
                    break;
            }

            switch (alt84) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1319:7: pt= ( '*' | '^' ) (m2= modifiers )?
                    {
                    pt=(Token)input.LT(1);

                    if ( input.LA(1)==38||input.LA(1)==80 ) {
                        input.consume();
                        state.errorRecovery=false;
                        state.failed=false;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }


                    if ( state.backtracking==0 ) {
                            retval.pointerStyle = PointerStyle.parsePointerStyle((pt!=null?pt.getText():null));
                            if ((pt!=null?pt.getText():null) != null && (pt!=null?pt.getText():null).equals("^"))
                              retval.signature.setType(FunctionSignature.Type.ObjCBlock);
                          }

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1324:7: (m2= modifiers )?
                    int alt83=2;
                    switch ( input.LA(1) ) {
                        case IDENTIFIER:
                            {
                            int LA83_1 = input.LA(2);

                            if ( ((((( next("extern") )||( next("__pragma") )||( parseModifier(next()) != null )||( next("__asm") )||( next("__success") )||( next(ModifierKind.VCAnnotation1Arg, ModifierKind.VCAnnotation2Args) ))&&(( next("extern") )||( next("__pragma") )||( parseModifier(next()) != null )||( next("__asm") )||( next("__success") )||( next(ModifierKind.VCAnnotation1Arg, ModifierKind.VCAnnotation2Args) )))&&synpred136_ObjCpp())) ) {
                                alt83=1;
                            }
                            }
                            break;
                        case 82:
                        case 83:
                            {
                            alt83=1;
                            }
                            break;
                    }

                    switch (alt83) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1325:9: m2= modifiers
                            {
                            pushFollow(FOLLOW_modifiers_in_functionSignatureSuffix4458);
                            m2=modifiers();

                            state._fsp--;
                            if (state.failed) return retval;

                            if ( state.backtracking==0 ) {
                                      retval.signature.getFunction().addModifiers(m2);
                                    }

                            }
                            break;

                    }


                    }
                    break;

            }


            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1330:5: (ii= IDENTIFIER )?
            int alt85=2;
            switch ( input.LA(1) ) {
                case IDENTIFIER:
                    {
                    alt85=1;
                    }
                    break;
            }

            switch (alt85) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1331:7: ii= IDENTIFIER
                    {
                    ii=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_functionSignatureSuffix4492); if (state.failed) return retval;

                    if ( state.backtracking==0 ) {
                            retval.signature.getFunction().setName(new SimpleIdentifier((ii!=null?ii.getText():null)));
                          }

                    }
                    break;

            }


            match(input,RPAREN,FOLLOW_RPAREN_in_functionSignatureSuffix4507); if (state.failed) return retval;

            match(input,LPAREN,FOLLOW_LPAREN_in_functionSignatureSuffix4513); if (state.failed) return retval;

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1336:12: (a1= argDef ( COMMA ax= argDef )* )?
            int alt87=2;
            switch ( input.LA(1) ) {
                case COMMA:
                case IDENTIFIER:
                case LPAREN:
                case 36:
                case 38:
                case 48:
                case 51:
                case 52:
                case 57:
                case 78:
                case 80:
                case 82:
                case 83:
                case 86:
                case 89:
                case 94:
                case 97:
                case 98:
                    {
                    alt87=1;
                    }
                    break;
                case RPAREN:
                    {
                    int LA87_15 = input.LA(2);

                    if ( (synpred140_ObjCpp()) ) {
                        alt87=1;
                    }
                    }
                    break;
            }

            switch (alt87) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1337:7: a1= argDef ( COMMA ax= argDef )*
                    {
                    pushFollow(FOLLOW_argDef_in_functionSignatureSuffix4525);
                    a1=argDef();

                    state._fsp--;
                    if (state.failed) return retval;

                    if ( state.backtracking==0 ) { 
                            if (!(a1!=null?input.toString(a1.start,a1.stop):null).equals("void"))
                              retval.signature.getFunction().addArg((a1!=null?a1.arg:null)); 
                          }

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1341:7: ( COMMA ax= argDef )*
                    loop86:
                    do {
                        int alt86=2;
                        switch ( input.LA(1) ) {
                        case COMMA:
                            {
                            alt86=1;
                            }
                            break;

                        }

                        switch (alt86) {
                    	case 1 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1342:9: COMMA ax= argDef
                    	    {
                    	    match(input,COMMA,FOLLOW_COMMA_in_functionSignatureSuffix4545); if (state.failed) return retval;

                    	    pushFollow(FOLLOW_argDef_in_functionSignatureSuffix4558);
                    	    ax=argDef();

                    	    state._fsp--;
                    	    if (state.failed) return retval;

                    	    if ( state.backtracking==0 ) { 
                    	              retval.signature.getFunction().addArg((ax!=null?ax.arg:null)); 
                    	            }

                    	    }
                    	    break;

                    	default :
                    	    break loop86;
                        }
                    } while (true);


                    }
                    break;

            }


            match(input,RPAREN,FOLLOW_RPAREN_in_functionSignatureSuffix4578); if (state.failed) return retval;

            }

            retval.stop = input.LT(-1);


        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 30, functionSignatureSuffix_StartIndex); }

        }
        return retval;
    }
    // $ANTLR end "functionSignatureSuffix"



    // $ANTLR start "mutableTypeRef"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1373:1: mutableTypeRef returns [TypeRef type] : nonMutableTypeRef ( (m1= typeMutator ) | ({...}?m= IDENTIFIER ) | (f1= functionSignatureSuffix ) )* ;
    public final TypeRef mutableTypeRef() throws RecognitionException {
        TypeRef type = null;

        int mutableTypeRef_StartIndex = input.index();

        Token m=null;
        TypeMutator m1 =null;

        ObjCppParser.functionSignatureSuffix_return f1 =null;

        TypeRef nonMutableTypeRef24 =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 31) ) { return type; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1377:3: ( nonMutableTypeRef ( (m1= typeMutator ) | ({...}?m= IDENTIFIER ) | (f1= functionSignatureSuffix ) )* )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1378:5: nonMutableTypeRef ( (m1= typeMutator ) | ({...}?m= IDENTIFIER ) | (f1= functionSignatureSuffix ) )*
            {
            pushFollow(FOLLOW_nonMutableTypeRef_in_mutableTypeRef4629);
            nonMutableTypeRef24=nonMutableTypeRef();

            state._fsp--;
            if (state.failed) return type;

            if ( state.backtracking==0 ) {
                  type = nonMutableTypeRef24;
                }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1381:5: ( (m1= typeMutator ) | ({...}?m= IDENTIFIER ) | (f1= functionSignatureSuffix ) )*
            loop88:
            do {
                int alt88=4;
                alt88 = dfa88.predict(input);
                switch (alt88) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1382:7: (m1= typeMutator )
            	    {
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1382:7: (m1= typeMutator )
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1383:9: m1= typeMutator
            	    {
            	    pushFollow(FOLLOW_typeMutator_in_mutableTypeRef4657);
            	    m1=typeMutator();

            	    state._fsp--;
            	    if (state.failed) return type;

            	    if ( state.backtracking==0 ) {
            	              type = m1.mutateType(type);
            	            }

            	    }


            	    }
            	    break;
            	case 2 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1387:7: ({...}?m= IDENTIFIER )
            	    {
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1387:7: ({...}?m= IDENTIFIER )
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1387:9: {...}?m= IDENTIFIER
            	    {
            	    if ( !(( next(ModifierKind.StorageClassSpecifier) )) ) {
            	        if (state.backtracking>0) {state.failed=true; return type;}
            	        throw new FailedPredicateException(input, "mutableTypeRef", " next(ModifierKind.StorageClassSpecifier) ");
            	    }

            	    m=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_mutableTypeRef4683); if (state.failed) return type;

            	    if ( state.backtracking==0 ) {
            	              type.addModifiers(ModifierType.parseModifier((m!=null?m.getText():null)));
            	          }

            	    }


            	    }
            	    break;
            	case 3 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1390:7: (f1= functionSignatureSuffix )
            	    {
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1390:7: (f1= functionSignatureSuffix )
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1391:9: f1= functionSignatureSuffix
            	    {
            	    pushFollow(FOLLOW_functionSignatureSuffix_in_mutableTypeRef4708);
            	    f1=functionSignatureSuffix();

            	    state._fsp--;
            	    if (state.failed) return type;

            	    if ( state.backtracking==0 ) { 
            	              assert (f1!=null?f1.signature:null) != null && (f1!=null?f1.signature:null).getFunction() != null;
            	              if ((f1!=null?f1.signature:null) != null && (f1!=null?f1.signature:null).getFunction() != null) {
            	                (f1!=null?f1.signature:null).getFunction().setValueType(type); 
            	                type = (f1!=null?f1.signature:null);
            	                if ((f1!=null?f1.pointerStyle:null) != null) {
            	                  type = new Pointer(type, (f1!=null?f1.pointerStyle:null));
            	                }
            	              }
            	            }

            	    }


            	    }
            	    break;

            	default :
            	    break loop88;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 31, mutableTypeRef_StartIndex); }

        }
        return type;
    }
    // $ANTLR end "mutableTypeRef"



    // $ANTLR start "declarator"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1405:1: declarator returns [Declarator decl] : (m= modifiers )? ( ( ( ( directDeclarator ) | (pt= ( '*' | '&' | '^' ) inner= declarator ) ) ( ':' bits= DECIMAL_NUMBER )? ) | ':' bits= DECIMAL_NUMBER ) ;
    public final Declarator declarator() throws RecognitionException {
        Declarator decl = null;

        int declarator_StartIndex = input.index();

        Token pt=null;
        Token bits=null;
        List<Modifier> m =null;

        Declarator inner =null;

        Declarator directDeclarator25 =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 32) ) { return decl; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1406:3: ( (m= modifiers )? ( ( ( ( directDeclarator ) | (pt= ( '*' | '&' | '^' ) inner= declarator ) ) ( ':' bits= DECIMAL_NUMBER )? ) | ':' bits= DECIMAL_NUMBER ) )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1407:5: (m= modifiers )? ( ( ( ( directDeclarator ) | (pt= ( '*' | '&' | '^' ) inner= declarator ) ) ( ':' bits= DECIMAL_NUMBER )? ) | ':' bits= DECIMAL_NUMBER )
            {
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1407:6: (m= modifiers )?
            int alt89=2;
            switch ( input.LA(1) ) {
                case IDENTIFIER:
                    {
                    switch ( input.LA(2) ) {
                        case LPAREN:
                            {
                            int LA89_6 = input.LA(3);

                            if ( ((((( next("__pragma") )||( next("__asm") )||( parseModifier(next()) != null )||( next("__success") )||( next(ModifierKind.VCAnnotation1Arg, ModifierKind.VCAnnotation2Args) ))&&(( next("__pragma") )||( next("__asm") )||( parseModifier(next()) != null )||( next("__success") )||( next(ModifierKind.VCAnnotation1Arg, ModifierKind.VCAnnotation2Args) )))&&synpred144_ObjCpp())) ) {
                                alt89=1;
                            }
                            }
                            break;
                        case STRING:
                        case 36:
                        case 38:
                        case 80:
                        case 82:
                        case 83:
                            {
                            alt89=1;
                            }
                            break;
                        case IDENTIFIER:
                            {
                            int LA89_8 = input.LA(3);

                            if ( (((( parseModifier(next()) != null )&&( parseModifier(next()) != null ))&&synpred144_ObjCpp())) ) {
                                alt89=1;
                            }
                            }
                            break;
                        case 51:
                            {
                            int LA89_11 = input.LA(3);

                            if ( (((( parseModifier(next()) != null )&&( parseModifier(next()) != null ))&&synpred144_ObjCpp())) ) {
                                alt89=1;
                            }
                            }
                            break;
                    }

                    }
                    break;
                case 82:
                case 83:
                    {
                    alt89=1;
                    }
                    break;
            }

            switch (alt89) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1407:6: m= modifiers
                    {
                    pushFollow(FOLLOW_modifiers_in_declarator4749);
                    m=modifiers();

                    state._fsp--;
                    if (state.failed) return decl;

                    }
                    break;

            }


            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1408:5: ( ( ( ( directDeclarator ) | (pt= ( '*' | '&' | '^' ) inner= declarator ) ) ( ':' bits= DECIMAL_NUMBER )? ) | ':' bits= DECIMAL_NUMBER )
            int alt92=2;
            int LA92_0 = input.LA(1);

            if ( (LA92_0==IDENTIFIER) && (( parseModifier(next()) == null ))) {
                alt92=1;
            }
            else if ( (LA92_0==LPAREN||LA92_0==36||LA92_0==38||LA92_0==80) ) {
                alt92=1;
            }
            else if ( (LA92_0==51) ) {
                alt92=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return decl;}
                NoViableAltException nvae =
                    new NoViableAltException("", 92, 0, input);

                throw nvae;

            }
            switch (alt92) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1409:7: ( ( ( directDeclarator ) | (pt= ( '*' | '&' | '^' ) inner= declarator ) ) ( ':' bits= DECIMAL_NUMBER )? )
                    {
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1409:7: ( ( ( directDeclarator ) | (pt= ( '*' | '&' | '^' ) inner= declarator ) ) ( ':' bits= DECIMAL_NUMBER )? )
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1410:9: ( ( directDeclarator ) | (pt= ( '*' | '&' | '^' ) inner= declarator ) ) ( ':' bits= DECIMAL_NUMBER )?
                    {
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1410:9: ( ( directDeclarator ) | (pt= ( '*' | '&' | '^' ) inner= declarator ) )
                    int alt90=2;
                    int LA90_0 = input.LA(1);

                    if ( (LA90_0==IDENTIFIER) && (( parseModifier(next()) == null ))) {
                        alt90=1;
                    }
                    else if ( (LA90_0==LPAREN) ) {
                        alt90=1;
                    }
                    else if ( (LA90_0==36||LA90_0==38||LA90_0==80) ) {
                        alt90=2;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return decl;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 90, 0, input);

                        throw nvae;

                    }
                    switch (alt90) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1411:11: ( directDeclarator )
                            {
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1411:11: ( directDeclarator )
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1412:13: directDeclarator
                            {
                            pushFollow(FOLLOW_directDeclarator_in_declarator4801);
                            directDeclarator25=directDeclarator();

                            state._fsp--;
                            if (state.failed) return decl;

                            if ( state.backtracking==0 ) { 
                                          decl = directDeclarator25; 
                                        }

                            }


                            }
                            break;
                        case 2 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1416:11: (pt= ( '*' | '&' | '^' ) inner= declarator )
                            {
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1416:11: (pt= ( '*' | '&' | '^' ) inner= declarator )
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1417:13: pt= ( '*' | '&' | '^' ) inner= declarator
                            {
                            pt=(Token)input.LT(1);

                            if ( input.LA(1)==36||input.LA(1)==38||input.LA(1)==80 ) {
                                input.consume();
                                state.errorRecovery=false;
                                state.failed=false;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return decl;}
                                MismatchedSetException mse = new MismatchedSetException(null,input);
                                throw mse;
                            }


                            pushFollow(FOLLOW_declarator_in_declarator4873);
                            inner=declarator();

                            state._fsp--;
                            if (state.failed) return decl;

                            if ( state.backtracking==0 ) {
                                          // TODO EMPTY DECLARATOR... maybe not the brightest idea one can have...
                                          decl = new PointerDeclarator(inner == null ? new DirectDeclarator(null) : inner, PointerStyle.parsePointerStyle((pt!=null?pt.getText():null)));
                                        }

                            }


                            }
                            break;

                    }


                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1424:9: ( ':' bits= DECIMAL_NUMBER )?
                    int alt91=2;
                    switch ( input.LA(1) ) {
                        case 51:
                            {
                            int LA91_1 = input.LA(2);

                            if ( (synpred148_ObjCpp()) ) {
                                alt91=1;
                            }
                            }
                            break;
                    }

                    switch (alt91) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1425:11: ':' bits= DECIMAL_NUMBER
                            {
                            match(input,51,FOLLOW_51_in_declarator4920); if (state.failed) return decl;

                            bits=(Token)match(input,DECIMAL_NUMBER,FOLLOW_DECIMAL_NUMBER_in_declarator4924); if (state.failed) return decl;

                            if ( state.backtracking==0 ) {
                                        if (decl != null)
                                          decl.setBits(Integer.parseInt((bits!=null?bits.getText():null)));
                                      }

                            }
                            break;

                    }


                    }


                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1431:7: ':' bits= DECIMAL_NUMBER
                    {
                    match(input,51,FOLLOW_51_in_declarator4955); if (state.failed) return decl;

                    bits=(Token)match(input,DECIMAL_NUMBER,FOLLOW_DECIMAL_NUMBER_in_declarator4959); if (state.failed) return decl;

                    if ( state.backtracking==0 ) {
                            decl = mark(new DirectDeclarator(null), getLine(bits));
                            decl.setBits(Integer.parseInt((bits!=null?bits.getText():null)));
                          }

                    }
                    break;

            }


            if ( state.backtracking==0 ) {
                  if (decl != null && m != null)
                    decl.setModifiers(m);
                }

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 32, declarator_StartIndex); }

        }
        return decl;
    }
    // $ANTLR end "declarator"



    // $ANTLR start "typeDef"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1442:1: typeDef returns [TypeDef typeDef] : 'typedef' varDecl SEMICOLON ;
    public final TypeDef typeDef() throws RecognitionException {
        TypeDef typeDef = null;

        int typeDef_StartIndex = input.index();

        VariablesDeclaration varDecl26 =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 33) ) { return typeDef; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1451:3: ( 'typedef' varDecl SEMICOLON )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1451:6: 'typedef' varDecl SEMICOLON
            {
            match(input,96,FOLLOW_96_in_typeDef4996); if (state.failed) return typeDef;

            pushFollow(FOLLOW_varDecl_in_typeDef5003);
            varDecl26=varDecl();

            state._fsp--;
            if (state.failed) return typeDef;

            match(input,SEMICOLON,FOLLOW_SEMICOLON_in_typeDef5005); if (state.failed) return typeDef;

            if ( state.backtracking==0 ) {
                   VariablesDeclaration vd = varDecl26;
                  typeDef = new TypeDef(vd.getValueType(), vd.getDeclarators());
                }

            }

            if ( state.backtracking==0 ) {
              for (Declarator d : typeDef.getDeclarators()) {
                String n = d.resolveName();
                if (n != null) {
                  addTypeIdent(n);
                }
              }
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 33, typeDef_StartIndex); }

        }
        return typeDef;
    }
    // $ANTLR end "typeDef"



    // $ANTLR start "varDeclEOF"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1458:1: varDeclEOF returns [Declaration decl] : varDecl SEMICOLON EOF ;
    public final Declaration varDeclEOF() throws RecognitionException {
        Declaration decl = null;

        int varDeclEOF_StartIndex = input.index();

        VariablesDeclaration varDecl27 =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 34) ) { return decl; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1459:3: ( varDecl SEMICOLON EOF )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1459:5: varDecl SEMICOLON EOF
            {
            pushFollow(FOLLOW_varDecl_in_varDeclEOF5026);
            varDecl27=varDecl();

            state._fsp--;
            if (state.failed) return decl;

            match(input,SEMICOLON,FOLLOW_SEMICOLON_in_varDeclEOF5028); if (state.failed) return decl;

            match(input,EOF,FOLLOW_EOF_in_varDeclEOF5030); if (state.failed) return decl;

            if ( state.backtracking==0 ) { decl = varDecl27; }

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 34, varDeclEOF_StartIndex); }

        }
        return decl;
    }
    // $ANTLR end "varDeclEOF"



    // $ANTLR start "declarationEOF"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1462:1: declarationEOF returns [Declaration declaration] : d= declaration EOF ;
    public final Declaration declarationEOF() throws RecognitionException {
        Declaration declaration = null;

        int declarationEOF_StartIndex = input.index();

        ObjCppParser.declaration_return d =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 35) ) { return declaration; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1463:3: (d= declaration EOF )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1463:7: d= declaration EOF
            {
            pushFollow(FOLLOW_declaration_in_declarationEOF5053);
            d=declaration();

            state._fsp--;
            if (state.failed) return declaration;

            match(input,EOF,FOLLOW_EOF_in_declarationEOF5055); if (state.failed) return declaration;

            if ( state.backtracking==0 ) { declaration = (d!=null?d.declaration:null); }

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 35, declarationEOF_StartIndex); }

        }
        return declaration;
    }
    // $ANTLR end "declarationEOF"



    // $ANTLR start "varDecl"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1466:1: varDecl returns [VariablesDeclaration decl] : tr= nonMutableTypeRef (d1= declaratorsList )? ;
    public final VariablesDeclaration varDecl() throws RecognitionException {
        VariablesDeclaration decl = null;

        int varDecl_StartIndex = input.index();

        TypeRef tr =null;

        List<Declarator> d1 =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 36) ) { return decl; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1467:3: (tr= nonMutableTypeRef (d1= declaratorsList )? )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1468:5: tr= nonMutableTypeRef (d1= declaratorsList )?
            {
            pushFollow(FOLLOW_nonMutableTypeRef_in_varDecl5082);
            tr=nonMutableTypeRef();

            state._fsp--;
            if (state.failed) return decl;

            if ( state.backtracking==0 ) { 
                  decl = new VariablesDeclaration(tr);
                }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1471:5: (d1= declaratorsList )?
            int alt93=2;
            switch ( input.LA(1) ) {
                case IDENTIFIER:
                    {
                    switch ( input.LA(2) ) {
                        case LPAREN:
                            {
                            int LA93_8 = input.LA(3);

                            if ( (synpred150_ObjCpp()) ) {
                                alt93=1;
                            }
                            }
                            break;
                        case STRING:
                            {
                            int LA93_9 = input.LA(3);

                            if ( (synpred150_ObjCpp()) ) {
                                alt93=1;
                            }
                            }
                            break;
                        case IDENTIFIER:
                            {
                            int LA93_10 = input.LA(3);

                            if ( (synpred150_ObjCpp()) ) {
                                alt93=1;
                            }
                            }
                            break;
                        case EOF:
                        case COMMA:
                        case SEMICOLON:
                        case 51:
                        case 57:
                        case 80:
                        case 82:
                        case 83:
                            {
                            alt93=1;
                            }
                            break;
                        case 36:
                        case 38:
                            {
                            int LA93_12 = input.LA(3);

                            if ( (synpred150_ObjCpp()) ) {
                                alt93=1;
                            }
                            }
                            break;
                        case 78:
                            {
                            int LA93_14 = input.LA(3);

                            if ( (synpred150_ObjCpp()) ) {
                                alt93=1;
                            }
                            }
                            break;
                    }

                    }
                    break;
                case LPAREN:
                case 36:
                case 38:
                case 80:
                case 82:
                case 83:
                    {
                    alt93=1;
                    }
                    break;
                case 51:
                    {
                    switch ( input.LA(2) ) {
                        case DECIMAL_NUMBER:
                            {
                            int LA93_32 = input.LA(3);

                            if ( (synpred150_ObjCpp()) ) {
                                alt93=1;
                            }
                            }
                            break;
                    }

                    }
                    break;
            }

            switch (alt93) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1472:7: d1= declaratorsList
                    {
                    pushFollow(FOLLOW_declaratorsList_in_varDecl5100);
                    d1=declaratorsList();

                    state._fsp--;
                    if (state.failed) return decl;

                    if ( state.backtracking==0 ) {
                            decl.setDeclarators(d1);
                          }

                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 36, varDecl_StartIndex); }

        }
        return decl;
    }
    // $ANTLR end "varDecl"



    // $ANTLR start "objCProtocolRefList"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1478:1: objCProtocolRefList : '<' IDENTIFIER ( COMMA IDENTIFIER )* '>' ;
    public final void objCProtocolRefList() throws RecognitionException {
        int objCProtocolRefList_StartIndex = input.index();

        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 37) ) { return ; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1479:3: ( '<' IDENTIFIER ( COMMA IDENTIFIER )* '>' )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1479:6: '<' IDENTIFIER ( COMMA IDENTIFIER )* '>'
            {
            match(input,53,FOLLOW_53_in_objCProtocolRefList5125); if (state.failed) return ;

            match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_objCProtocolRefList5132); if (state.failed) return ;

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1481:5: ( COMMA IDENTIFIER )*
            loop94:
            do {
                int alt94=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt94=1;
                    }
                    break;

                }

                switch (alt94) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1482:7: COMMA IDENTIFIER
            	    {
            	    match(input,COMMA,FOLLOW_COMMA_in_objCProtocolRefList5147); if (state.failed) return ;

            	    match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_objCProtocolRefList5156); if (state.failed) return ;

            	    }
            	    break;

            	default :
            	    break loop94;
                }
            } while (true);


            match(input,59,FOLLOW_59_in_objCProtocolRefList5170); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 37, objCProtocolRefList_StartIndex); }

        }
        return ;
    }
    // $ANTLR end "objCProtocolRefList"



    // $ANTLR start "declaratorWithValue"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1488:1: declaratorWithValue returns [Declarator decl] : declarator ( '=' dv= topLevelExpr )? ;
    public final Declarator declaratorWithValue() throws RecognitionException {
        Declarator decl = null;

        int declaratorWithValue_StartIndex = input.index();

        ObjCppParser.topLevelExpr_return dv =null;

        Declarator declarator28 =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 38) ) { return decl; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1489:3: ( declarator ( '=' dv= topLevelExpr )? )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1490:5: declarator ( '=' dv= topLevelExpr )?
            {
            pushFollow(FOLLOW_declarator_in_declaratorWithValue5191);
            declarator28=declarator();

            state._fsp--;
            if (state.failed) return decl;

            if ( state.backtracking==0 ) {
                  decl = declarator28;
                }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1493:5: ( '=' dv= topLevelExpr )?
            int alt95=2;
            switch ( input.LA(1) ) {
                case 57:
                    {
                    alt95=1;
                    }
                    break;
            }

            switch (alt95) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1494:7: '=' dv= topLevelExpr
                    {
                    match(input,57,FOLLOW_57_in_declaratorWithValue5207); if (state.failed) return decl;

                    pushFollow(FOLLOW_topLevelExpr_in_declaratorWithValue5218);
                    dv=topLevelExpr();

                    state._fsp--;
                    if (state.failed) return decl;

                    if ( state.backtracking==0 ) {
                            decl.setDefaultValue((dv!=null?dv.expr:null));
                          }

                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 38, declaratorWithValue_StartIndex); }

        }
        return decl;
    }
    // $ANTLR end "declaratorWithValue"



    // $ANTLR start "declaratorsList"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1501:1: declaratorsList returns [List<Declarator> declarators] :d= declaratorWithValue ( COMMA x= declaratorWithValue )* ;
    public final List<Declarator> declaratorsList() throws RecognitionException {
        List<Declarator> declarators = null;

        int declaratorsList_StartIndex = input.index();

        Declarator d =null;

        Declarator x =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 39) ) { return declarators; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1502:3: (d= declaratorWithValue ( COMMA x= declaratorWithValue )* )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1502:6: d= declaratorWithValue ( COMMA x= declaratorWithValue )*
            {
            if ( state.backtracking==0 ) { declarators = new ArrayList<Declarator>(); }

            pushFollow(FOLLOW_declaratorWithValue_in_declaratorsList5253);
            d=declaratorWithValue();

            state._fsp--;
            if (state.failed) return declarators;

            if ( state.backtracking==0 ) { 
                  declarators.add(d); 
                }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1506:5: ( COMMA x= declaratorWithValue )*
            loop96:
            do {
                int alt96=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt96=1;
                    }
                    break;

                }

                switch (alt96) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1507:7: COMMA x= declaratorWithValue
            	    {
            	    match(input,COMMA,FOLLOW_COMMA_in_declaratorsList5269); if (state.failed) return declarators;

            	    pushFollow(FOLLOW_declaratorWithValue_in_declaratorsList5280);
            	    x=declaratorWithValue();

            	    state._fsp--;
            	    if (state.failed) return declarators;

            	    if ( state.backtracking==0 ) { 
            	            declarators.add(x); 
            	          }

            	    }
            	    break;

            	default :
            	    break loop96;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 39, declaratorsList_StartIndex); }

        }
        return declarators;
    }
    // $ANTLR end "declaratorsList"



    // $ANTLR start "directDeclarator"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1514:1: directDeclarator returns [Declarator decl] : ({...}? => IDENTIFIER | LPAREN inner= declarator RPAREN ) ( '[' ( ( expression ) | () ) ']' | argList )* ;
    public final Declarator directDeclarator() throws RecognitionException {
        Declarator decl = null;

        int directDeclarator_StartIndex = input.index();

        Token IDENTIFIER29=null;
        Declarator inner =null;

        Expression expression30 =null;

        ObjCppParser.argList_return argList31 =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 40) ) { return decl; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1515:3: ( ({...}? => IDENTIFIER | LPAREN inner= declarator RPAREN ) ( '[' ( ( expression ) | () ) ']' | argList )* )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1516:5: ({...}? => IDENTIFIER | LPAREN inner= declarator RPAREN ) ( '[' ( ( expression ) | () ) ']' | argList )*
            {
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1516:5: ({...}? => IDENTIFIER | LPAREN inner= declarator RPAREN )
            int alt97=2;
            int LA97_0 = input.LA(1);

            if ( (LA97_0==IDENTIFIER) && (( parseModifier(next()) == null ))) {
                alt97=1;
            }
            else if ( (LA97_0==LPAREN) ) {
                alt97=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return decl;}
                NoViableAltException nvae =
                    new NoViableAltException("", 97, 0, input);

                throw nvae;

            }
            switch (alt97) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1517:7: {...}? => IDENTIFIER
                    {
                    if ( !(( parseModifier(next()) == null )) ) {
                        if (state.backtracking>0) {state.failed=true; return decl;}
                        throw new FailedPredicateException(input, "directDeclarator", " parseModifier(next()) == null ");
                    }

                    IDENTIFIER29=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_directDeclarator5323); if (state.failed) return decl;

                    if ( state.backtracking==0 ) {
                            decl = mark(new DirectDeclarator((IDENTIFIER29!=null?IDENTIFIER29.getText():null)), getLine(IDENTIFIER29));
                          }

                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1520:7: LPAREN inner= declarator RPAREN
                    {
                    match(input,LPAREN,FOLLOW_LPAREN_in_directDeclarator5336); if (state.failed) return decl;

                    pushFollow(FOLLOW_declarator_in_directDeclarator5340);
                    inner=declarator();

                    state._fsp--;
                    if (state.failed) return decl;

                    match(input,RPAREN,FOLLOW_RPAREN_in_directDeclarator5342); if (state.failed) return decl;

                    if ( state.backtracking==0 ) {
                            decl = inner;
                            if (decl != null)
                              decl.setParenthesized(true);
                          }

                    }
                    break;

            }


            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1526:5: ( '[' ( ( expression ) | () ) ']' | argList )*
            loop99:
            do {
                int alt99=3;
                switch ( input.LA(1) ) {
                case 78:
                    {
                    alt99=1;
                    }
                    break;
                case LPAREN:
                    {
                    alt99=2;
                    }
                    break;

                }

                switch (alt99) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1527:7: '[' ( ( expression ) | () ) ']'
            	    {
            	    match(input,78,FOLLOW_78_in_directDeclarator5365); if (state.failed) return decl;

            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1528:7: ( ( expression ) | () )
            	    int alt98=2;
            	    switch ( input.LA(1) ) {
            	    case CHARACTER:
            	    case DECIMAL_NUMBER:
            	    case FLOAT_NUMBER:
            	    case HEXADECIMAL_NUMBER:
            	    case IDENTIFIER:
            	    case LBRACE:
            	    case LPAREN:
            	    case OCTAL_NUMBER:
            	    case STRING:
            	    case 30:
            	    case 36:
            	    case 38:
            	    case 40:
            	    case 41:
            	    case 43:
            	    case 44:
            	    case 66:
            	    case 74:
            	    case 77:
            	    case 78:
            	    case 103:
            	        {
            	        alt98=1;
            	        }
            	        break;
            	    case 79:
            	        {
            	        alt98=2;
            	        }
            	        break;
            	    default:
            	        if (state.backtracking>0) {state.failed=true; return decl;}
            	        NoViableAltException nvae =
            	            new NoViableAltException("", 98, 0, input);

            	        throw nvae;

            	    }

            	    switch (alt98) {
            	        case 1 :
            	            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1529:9: ( expression )
            	            {
            	            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1529:9: ( expression )
            	            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1530:11: expression
            	            {
            	            pushFollow(FOLLOW_expression_in_directDeclarator5396);
            	            expression30=expression();

            	            state._fsp--;
            	            if (state.failed) return decl;

            	            if ( state.backtracking==0 ) {
            	                        if (decl instanceof ArrayDeclarator)
            	                          ((ArrayDeclarator)decl).addDimension(expression30);
            	                        else
            	                          decl = new ArrayDeclarator(decl, expression30);
            	                      }

            	            }


            	            }
            	            break;
            	        case 2 :
            	            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1537:9: ()
            	            {
            	            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1537:9: ()
            	            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1538:11: 
            	            {
            	            if ( state.backtracking==0 ) {
            	                        decl = new ArrayDeclarator(decl, new Expression.EmptyArraySize());
            	                      }

            	            }


            	            }
            	            break;

            	    }


            	    match(input,79,FOLLOW_79_in_directDeclarator5459); if (state.failed) return decl;

            	    }
            	    break;
            	case 2 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1544:7: argList
            	    {
            	    pushFollow(FOLLOW_argList_in_directDeclarator5470);
            	    argList31=argList();

            	    state._fsp--;
            	    if (state.failed) return decl;

            	    if ( state.backtracking==0 ) {
            	            decl = new FunctionDeclarator(decl, (argList31!=null?argList31.args:null));
            	          }

            	    }
            	    break;

            	default :
            	    break loop99;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 40, directDeclarator_StartIndex); }

        }
        return decl;
    }
    // $ANTLR end "directDeclarator"


    public static class argList_return extends ParserRuleReturnScope {
        public List<Arg> args;
        public boolean isObjC;
    };


    // $ANTLR start "argList"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1550:1: argList returns [List<Arg> args, boolean isObjC] :op= LPAREN (a1= argDef ( COMMA ax= argDef )* ( COMMA '...' )? )? cp= RPAREN ;
    public final ObjCppParser.argList_return argList() throws RecognitionException {
        ObjCppParser.argList_return retval = new ObjCppParser.argList_return();
        retval.start = input.LT(1);

        int argList_StartIndex = input.index();

        Token op=null;
        Token cp=null;
        ObjCppParser.argDef_return a1 =null;

        ObjCppParser.argDef_return ax =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 41) ) { return retval; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1551:3: (op= LPAREN (a1= argDef ( COMMA ax= argDef )* ( COMMA '...' )? )? cp= RPAREN )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1551:6: op= LPAREN (a1= argDef ( COMMA ax= argDef )* ( COMMA '...' )? )? cp= RPAREN
            {
            if ( state.backtracking==0 ) { 
                  retval.isObjC = false; 
                  retval.args = new ArrayList<Arg>();
                }

            op=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_argList5510); if (state.failed) return retval;

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1557:5: (a1= argDef ( COMMA ax= argDef )* ( COMMA '...' )? )?
            int alt102=2;
            switch ( input.LA(1) ) {
                case COMMA:
                case IDENTIFIER:
                case LPAREN:
                case 36:
                case 38:
                case 48:
                case 51:
                case 52:
                case 57:
                case 78:
                case 80:
                case 82:
                case 83:
                case 86:
                case 89:
                case 94:
                case 97:
                case 98:
                    {
                    alt102=1;
                    }
                    break;
                case RPAREN:
                    {
                    int LA102_15 = input.LA(2);

                    if ( (synpred160_ObjCpp()) ) {
                        alt102=1;
                    }
                    }
                    break;
            }

            switch (alt102) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1558:7: a1= argDef ( COMMA ax= argDef )* ( COMMA '...' )?
                    {
                    pushFollow(FOLLOW_argDef_in_argList5527);
                    a1=argDef();

                    state._fsp--;
                    if (state.failed) return retval;

                    if ( state.backtracking==0 ) {
                            if (!(a1!=null?input.toString(a1.start,a1.stop):null).equals("void")) 
                              retval.args.add((a1!=null?a1.arg:null));
                          }

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1562:7: ( COMMA ax= argDef )*
                    loop100:
                    do {
                        int alt100=2;
                        switch ( input.LA(1) ) {
                        case COMMA:
                            {
                            switch ( input.LA(2) ) {
                            case 48:
                                {
                                int LA100_3 = input.LA(3);

                                if ( (synpred158_ObjCpp()) ) {
                                    alt100=1;
                                }


                                }
                                break;
                            case COMMA:
                            case IDENTIFIER:
                            case LPAREN:
                            case RPAREN:
                            case 36:
                            case 38:
                            case 51:
                            case 52:
                            case 57:
                            case 78:
                            case 80:
                            case 82:
                            case 83:
                            case 86:
                            case 89:
                            case 94:
                            case 97:
                            case 98:
                                {
                                alt100=1;
                                }
                                break;

                            }

                            }
                            break;

                        }

                        switch (alt100) {
                    	case 1 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1563:9: COMMA ax= argDef
                    	    {
                    	    match(input,COMMA,FOLLOW_COMMA_in_argList5547); if (state.failed) return retval;

                    	    pushFollow(FOLLOW_argDef_in_argList5560);
                    	    ax=argDef();

                    	    state._fsp--;
                    	    if (state.failed) return retval;

                    	    if ( state.backtracking==0 ) {
                    	              retval.args.add((ax!=null?ax.arg:null));
                    	            }

                    	    }
                    	    break;

                    	default :
                    	    break loop100;
                        }
                    } while (true);


                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1568:7: ( COMMA '...' )?
                    int alt101=2;
                    switch ( input.LA(1) ) {
                        case COMMA:
                            {
                            alt101=1;
                            }
                            break;
                    }

                    switch (alt101) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1569:9: COMMA '...'
                            {
                            match(input,COMMA,FOLLOW_COMMA_in_argList5590); if (state.failed) return retval;

                            match(input,48,FOLLOW_48_in_argList5592); if (state.failed) return retval;

                            if ( state.backtracking==0 ) {
                                      retval.isObjC = true;
                                      retval.args.add(Arg.createVarArgs());
                                    }

                            }
                            break;

                    }


                    }
                    break;

            }


            cp=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_argList5618); if (state.failed) return retval;

            }

            retval.stop = input.LT(-1);


        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 41, argList_StartIndex); }

        }
        return retval;
    }
    // $ANTLR end "argList"



    // $ANTLR start "nonMutableTypeRef"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1578:1: nonMutableTypeRef returns [TypeRef type] : (preMods= modifiers )? ({...}? =>i= IDENTIFIER | 'typename' pn= typeName |{...}? =>an= typeName | structCore | enumCore )? (postMods= modifiers )? ;
    public final TypeRef nonMutableTypeRef() throws RecognitionException {
        ModifierKinds_stack.push(new ModifierKinds_scope());

        TypeRef type = null;

        int nonMutableTypeRef_StartIndex = input.index();

        Token i=null;
        List<Modifier> preMods =null;

        TypeRef pn =null;

        TypeRef an =null;

        List<Modifier> postMods =null;

        Struct structCore32 =null;

        Enum enumCore33 =null;



          List<Modifier> modifiers = new ArrayList<Modifier>();
          //TypeRef ref = null;
          int line = -1;

        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 42) ) { return type; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1594:3: ( (preMods= modifiers )? ({...}? =>i= IDENTIFIER | 'typename' pn= typeName |{...}? =>an= typeName | structCore | enumCore )? (postMods= modifiers )? )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1595:5: (preMods= modifiers )? ({...}? =>i= IDENTIFIER | 'typename' pn= typeName |{...}? =>an= typeName | structCore | enumCore )? (postMods= modifiers )?
            {
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1595:5: (preMods= modifiers )?
            int alt103=2;
            alt103 = dfa103.predict(input);
            switch (alt103) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1595:7: preMods= modifiers
                    {
                    pushFollow(FOLLOW_modifiers_in_nonMutableTypeRef5658);
                    preMods=modifiers();

                    state._fsp--;
                    if (state.failed) return type;

                    if ( state.backtracking==0 ) { 
                          modifiers.addAll(preMods);
                          try {
                            if (ModifierType.UUID.isContainedBy(modifiers))
                              allowKinds(ModifierKind.VCParameterAnnotation);
                          } catch (Throwable th) {
                            th.printStackTrace();
                          }
                          
                        }

                    }
                    break;

            }


            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1605:5: ({...}? =>i= IDENTIFIER | 'typename' pn= typeName |{...}? =>an= typeName | structCore | enumCore )?
            int alt104=6;
            alt104 = dfa104.predict(input);
            switch (alt104) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1606:7: {...}? =>i= IDENTIFIER
                    {
                    if ( !(( next("va_list", "__gnuc_va_list", "__builtin_va_list") )) ) {
                        if (state.backtracking>0) {state.failed=true; return type;}
                        throw new FailedPredicateException(input, "nonMutableTypeRef", " next(\"va_list\", \"__gnuc_va_list\", \"__builtin_va_list\") ");
                    }

                    i=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_nonMutableTypeRef5682); if (state.failed) return type;

                    if ( state.backtracking==0 ) {
                            type = new SimpleTypeRef((i!=null?i.getText():null)); 
                          }

                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1609:7: 'typename' pn= typeName
                    {
                    match(input,97,FOLLOW_97_in_nonMutableTypeRef5694); if (state.failed) return type;

                    pushFollow(FOLLOW_typeName_in_nonMutableTypeRef5698);
                    pn=typeName();

                    state._fsp--;
                    if (state.failed) return type;

                    if ( state.backtracking==0 ) { type = pn; }

                    }
                    break;
                case 3 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1610:7: {...}? =>an= typeName
                    {
                    if ( !(( 
                            next(2, "<") ||
                            isTypeIdentifier(next()) || 
                            (
                              parseModifier(next(1)) == null &&
                              //(isTypeDef() || !next(2, "=", ",", ";", ":", "[", "(", ")"))
                              !next(2, "=", ",", ";", ":", "[", "(", ")")
                            ) 
                          )) ) {
                        if (state.backtracking>0) {state.failed=true; return type;}
                        throw new FailedPredicateException(input, "nonMutableTypeRef", " \n        next(2, \"<\") ||\n        isTypeIdentifier(next()) || \n        (\n          parseModifier(next(1)) == null &&\n          //(isTypeDef() || !next(2, \"=\", \",\", \";\", \":\", \"[\", \"(\", \")\"))\n          !next(2, \"=\", \",\", \";\", \":\", \"[\", \"(\", \")\")\n        ) \n      ");
                    }

                    pushFollow(FOLLOW_typeName_in_nonMutableTypeRef5715);
                    an=typeName();

                    state._fsp--;
                    if (state.failed) return type;

                    if ( state.backtracking==0 ) { type = an; }

                    }
                    break;
                case 4 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1619:7: structCore
                    {
                    pushFollow(FOLLOW_structCore_in_nonMutableTypeRef5727);
                    structCore32=structCore();

                    state._fsp--;
                    if (state.failed) return type;

                    if ( state.backtracking==0 ) { type = structCore32; }

                    }
                    break;
                case 5 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1620:7: enumCore
                    {
                    pushFollow(FOLLOW_enumCore_in_nonMutableTypeRef5739);
                    enumCore33=enumCore();

                    state._fsp--;
                    if (state.failed) return type;

                    if ( state.backtracking==0 ) { type = enumCore33; }

                    }
                    break;

            }


            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1622:5: (postMods= modifiers )?
            int alt105=2;
            alt105 = dfa105.predict(input);
            switch (alt105) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1622:7: postMods= modifiers
                    {
                    pushFollow(FOLLOW_modifiers_in_nonMutableTypeRef5758);
                    postMods=modifiers();

                    state._fsp--;
                    if (state.failed) return type;

                    if ( state.backtracking==0 ) { modifiers.addAll(postMods); }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {
              if (type == null && !modifiers.isEmpty()) {
                type = new Primitive(null);
              }
              if (type != null) {
                type.addModifiers(modifiers);
                mark(type, line);
              }
            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 42, nonMutableTypeRef_StartIndex); }

            ModifierKinds_stack.pop();

        }
        return type;
    }
    // $ANTLR end "nonMutableTypeRef"



    // $ANTLR start "typeRefInsides"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1644:1: typeRefInsides returns [TypeRef type] : ( 'typename' pn= typeName |{...}? =>an= typeName | structCore | enumCore );
    public final TypeRef typeRefInsides() throws RecognitionException {
        TypeRef type = null;

        int typeRefInsides_StartIndex = input.index();

        TypeRef pn =null;

        TypeRef an =null;

        Struct structCore34 =null;

        Enum enumCore35 =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 43) ) { return type; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1645:3: ( 'typename' pn= typeName |{...}? =>an= typeName | structCore | enumCore )
            int alt106=4;
            int LA106_0 = input.LA(1);

            if ( (LA106_0==97) ) {
                alt106=1;
            }
            else if ( (LA106_0==52) && (( 
                  isTypeIdentifier(next()) || 
                  (
                    parseModifier(next(1)) == null && 
                    !next(2, "=", ",", ";", ":", "[", "(", ")")
                  ) 
                ))) {
                alt106=2;
            }
            else if ( (LA106_0==IDENTIFIER) && (( 
                  isTypeIdentifier(next()) || 
                  (
                    parseModifier(next(1)) == null && 
                    !next(2, "=", ",", ";", ":", "[", "(", ")")
                  ) 
                ))) {
                alt106=2;
            }
            else if ( (LA106_0==86||LA106_0==94||LA106_0==98) ) {
                alt106=3;
            }
            else if ( (LA106_0==89) ) {
                alt106=4;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return type;}
                NoViableAltException nvae =
                    new NoViableAltException("", 106, 0, input);

                throw nvae;

            }
            switch (alt106) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1646:5: 'typename' pn= typeName
                    {
                    match(input,97,FOLLOW_97_in_typeRefInsides5793); if (state.failed) return type;

                    pushFollow(FOLLOW_typeName_in_typeRefInsides5797);
                    pn=typeName();

                    state._fsp--;
                    if (state.failed) return type;

                    if ( state.backtracking==0 ) { type = pn; }

                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1647:5: {...}? =>an= typeName
                    {
                    if ( !(( 
                          isTypeIdentifier(next()) || 
                          (
                            parseModifier(next(1)) == null && 
                            !next(2, "=", ",", ";", ":", "[", "(", ")")
                          ) 
                        )) ) {
                        if (state.backtracking>0) {state.failed=true; return type;}
                        throw new FailedPredicateException(input, "typeRefInsides", " \n      isTypeIdentifier(next()) || \n      (\n        parseModifier(next(1)) == null && \n        !next(2, \"=\", \",\", \";\", \":\", \"[\", \"(\", \")\")\n      ) \n    ");
                    }

                    pushFollow(FOLLOW_typeName_in_typeRefInsides5812);
                    an=typeName();

                    state._fsp--;
                    if (state.failed) return type;

                    if ( state.backtracking==0 ) { type = an; }

                    }
                    break;
                case 3 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1654:5: structCore
                    {
                    pushFollow(FOLLOW_structCore_in_typeRefInsides5822);
                    structCore34=structCore();

                    state._fsp--;
                    if (state.failed) return type;

                    if ( state.backtracking==0 ) { type = structCore34; }

                    }
                    break;
                case 4 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1655:5: enumCore
                    {
                    pushFollow(FOLLOW_enumCore_in_typeRefInsides5832);
                    enumCore35=enumCore();

                    state._fsp--;
                    if (state.failed) return type;

                    if ( state.backtracking==0 ) { type = enumCore35; }

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 43, typeRefInsides_StartIndex); }

        }
        return type;
    }
    // $ANTLR end "typeRefInsides"



    // $ANTLR start "typeName"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1658:1: typeName returns [TypeRef type] : i= qualifiedIdentifier ;
    public final TypeRef typeName() throws RecognitionException {
        TypeRef type = null;

        int typeName_StartIndex = input.index();

        Identifier i =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 44) ) { return type; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1659:3: (i= qualifiedIdentifier )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1660:5: i= qualifiedIdentifier
            {
            pushFollow(FOLLOW_qualifiedIdentifier_in_typeName5859);
            i=qualifiedIdentifier();

            state._fsp--;
            if (state.failed) return type;

            if ( state.backtracking==0 ) {
                  if (i.isPlain() && isPrimitiveType(i.toString()))
                    type = new Primitive(i.toString());
                  else
                    type = new SimpleTypeRef(i);
                  if (i.isPlain())
                    addTypeIdent(i.toString());
                }

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 44, typeName_StartIndex); }

        }
        return type;
    }
    // $ANTLR end "typeName"



    // $ANTLR start "objCMethodCall"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1670:1: objCMethodCall returns [FunctionCall expr] : '[' target= expression methodName= IDENTIFIER ( ':' arg1= expression (selx= IDENTIFIER ':' argx= expression )* )? ']' ;
    public final FunctionCall objCMethodCall() throws RecognitionException {
        FunctionCall expr = null;

        int objCMethodCall_StartIndex = input.index();

        Token methodName=null;
        Token selx=null;
        Expression target =null;

        Expression arg1 =null;

        Expression argx =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 45) ) { return expr; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1671:3: ( '[' target= expression methodName= IDENTIFIER ( ':' arg1= expression (selx= IDENTIFIER ':' argx= expression )* )? ']' )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1672:5: '[' target= expression methodName= IDENTIFIER ( ':' arg1= expression (selx= IDENTIFIER ':' argx= expression )* )? ']'
            {
            match(input,78,FOLLOW_78_in_objCMethodCall5884); if (state.failed) return expr;

            pushFollow(FOLLOW_expression_in_objCMethodCall5888);
            target=expression();

            state._fsp--;
            if (state.failed) return expr;

            methodName=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_objCMethodCall5892); if (state.failed) return expr;

            if ( state.backtracking==0 ) {
                  expr = new FunctionCall();
                  expr.setFunction(new VariableRef(new SimpleIdentifier((methodName!=null?methodName.getText():null))));
                  expr.setTarget(target);
                  expr.setMemberRefStyle(MemberRefStyle.SquareBrackets);
                }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1678:5: ( ':' arg1= expression (selx= IDENTIFIER ':' argx= expression )* )?
            int alt108=2;
            switch ( input.LA(1) ) {
                case 51:
                    {
                    alt108=1;
                    }
                    break;
            }

            switch (alt108) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1679:7: ':' arg1= expression (selx= IDENTIFIER ':' argx= expression )*
                    {
                    match(input,51,FOLLOW_51_in_objCMethodCall5908); if (state.failed) return expr;

                    pushFollow(FOLLOW_expression_in_objCMethodCall5912);
                    arg1=expression();

                    state._fsp--;
                    if (state.failed) return expr;

                    if ( state.backtracking==0 ) {
                            expr.addArgument(null, arg1);
                          }

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1682:7: (selx= IDENTIFIER ':' argx= expression )*
                    loop107:
                    do {
                        int alt107=2;
                        switch ( input.LA(1) ) {
                        case IDENTIFIER:
                            {
                            alt107=1;
                            }
                            break;

                        }

                        switch (alt107) {
                    	case 1 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1683:9: selx= IDENTIFIER ':' argx= expression
                    	    {
                    	    selx=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_objCMethodCall5934); if (state.failed) return expr;

                    	    match(input,51,FOLLOW_51_in_objCMethodCall5936); if (state.failed) return expr;

                    	    pushFollow(FOLLOW_expression_in_objCMethodCall5940);
                    	    argx=expression();

                    	    state._fsp--;
                    	    if (state.failed) return expr;

                    	    if ( state.backtracking==0 ) {
                    	              expr.addArgument((selx!=null?selx.getText():null), argx);
                    	            }

                    	    }
                    	    break;

                    	default :
                    	    break loop107;
                        }
                    } while (true);


                    }
                    break;

            }


            match(input,79,FOLLOW_79_in_objCMethodCall5964); if (state.failed) return expr;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 45, objCMethodCall_StartIndex); }

        }
        return expr;
    }
    // $ANTLR end "objCMethodCall"



    // $ANTLR start "binaryOp"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1691:1: binaryOp returns [Expression.BinaryOperator op] : t= ( '+' | '-' | '*' | '/' | '%' | '<<' | '>>>' | '>>' | '^' | '||' | '|' | '&&' | '&' | '<=' | '>=' | '<' | '>' | '==' | '!=' ) ;
    public final Expression.BinaryOperator binaryOp() throws RecognitionException {
        Expression.BinaryOperator op = null;

        int binaryOp_StartIndex = input.index();

        Token t=null;

        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 46) ) { return op; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1692:3: (t= ( '+' | '-' | '*' | '/' | '%' | '<<' | '>>>' | '>>' | '^' | '||' | '|' | '&&' | '&' | '<=' | '>=' | '<' | '>' | '==' | '!=' ) )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1692:7: t= ( '+' | '-' | '*' | '/' | '%' | '<<' | '>>>' | '>>' | '^' | '||' | '|' | '&&' | '&' | '<=' | '>=' | '<' | '>' | '==' | '!=' )
            {
            t=(Token)input.LT(1);

            if ( input.LA(1)==31||input.LA(1)==33||(input.LA(1) >= 35 && input.LA(1) <= 36)||input.LA(1)==38||input.LA(1)==40||input.LA(1)==43||input.LA(1)==49||(input.LA(1) >= 53 && input.LA(1) <= 54)||input.LA(1)==56||(input.LA(1) >= 58 && input.LA(1) <= 61)||input.LA(1)==63||input.LA(1)==80||input.LA(1)==100||input.LA(1)==102 ) {
                input.consume();
                state.errorRecovery=false;
                state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return op;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            if ( state.backtracking==0 ) {
                  op = Expression.getBinaryOperator((t!=null?t.getText():null));
                  if (op == null)
                    throw new RuntimeException("Failed to parse op " + (t!=null?t.getText():null));
                }

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 46, binaryOp_StartIndex); }

        }
        return op;
    }
    // $ANTLR end "binaryOp"



    // $ANTLR start "postfixOp"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1704:1: postfixOp returns [Expression.UnaryOperator op] : ( '++' | '--' );
    public final Expression.UnaryOperator postfixOp() throws RecognitionException {
        Expression.UnaryOperator op = null;

        int postfixOp_StartIndex = input.index();

        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 47) ) { return op; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1705:3: ( '++' | '--' )
            int alt109=2;
            switch ( input.LA(1) ) {
            case 41:
                {
                alt109=1;
                }
                break;
            case 44:
                {
                alt109=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return op;}
                NoViableAltException nvae =
                    new NoViableAltException("", 109, 0, input);

                throw nvae;

            }

            switch (alt109) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1706:5: '++'
                    {
                    match(input,41,FOLLOW_41_in_postfixOp6106); if (state.failed) return op;

                    if ( state.backtracking==0 ) { 
                          op = UnaryOperator.PostIncr; 
                        }

                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1709:5: '--'
                    {
                    match(input,44,FOLLOW_44_in_postfixOp6116); if (state.failed) return op;

                    if ( state.backtracking==0 ) { 
                          op = UnaryOperator.PostDecr; 
                        }

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 47, postfixOp_StartIndex); }

        }
        return op;
    }
    // $ANTLR end "postfixOp"



    // $ANTLR start "typeRefOrExpression"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1714:1: typeRefOrExpression returns [Expression expr] : (tr= mutableTypeRef |e= topLevelExpr );
    public final Expression typeRefOrExpression() throws RecognitionException {
        Expression expr = null;

        int typeRefOrExpression_StartIndex = input.index();

        TypeRef tr =null;

        ObjCppParser.topLevelExpr_return e =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 48) ) { return expr; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1715:3: (tr= mutableTypeRef |e= topLevelExpr )
            int alt110=2;
            alt110 = dfa110.predict(input);
            switch (alt110) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1715:6: tr= mutableTypeRef
                    {
                    pushFollow(FOLLOW_mutableTypeRef_in_typeRefOrExpression6141);
                    tr=mutableTypeRef();

                    state._fsp--;
                    if (state.failed) return expr;

                    if ( state.backtracking==0 ) {
                          expr = new Expression.TypeRefExpression(tr);
                        }

                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1718:5: e= topLevelExpr
                    {
                    pushFollow(FOLLOW_topLevelExpr_in_typeRefOrExpression6154);
                    e=topLevelExpr();

                    state._fsp--;
                    if (state.failed) return expr;

                    if ( state.backtracking==0 ) {
                          expr = (e!=null?e.expr:null);
                        }

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 48, typeRefOrExpression_StartIndex); }

        }
        return expr;
    }
    // $ANTLR end "typeRefOrExpression"



    // $ANTLR start "simpleIdentifier"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1723:1: simpleIdentifier returns [SimpleIdentifier identifier] : i= IDENTIFIER ( '<' (a1= typeRefOrExpression ( COMMA ax= typeRefOrExpression )* )? '>' )? ;
    public final SimpleIdentifier simpleIdentifier() throws RecognitionException {
        SimpleIdentifier identifier = null;

        int simpleIdentifier_StartIndex = input.index();

        Token i=null;
        Expression a1 =null;

        Expression ax =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 49) ) { return identifier; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1724:3: (i= IDENTIFIER ( '<' (a1= typeRefOrExpression ( COMMA ax= typeRefOrExpression )* )? '>' )? )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1724:6: i= IDENTIFIER ( '<' (a1= typeRefOrExpression ( COMMA ax= typeRefOrExpression )* )? '>' )?
            {
            i=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_simpleIdentifier6176); if (state.failed) return identifier;

            if ( state.backtracking==0 ) { identifier = new SimpleIdentifier((i!=null?i.getText():null)); }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1725:5: ( '<' (a1= typeRefOrExpression ( COMMA ax= typeRefOrExpression )* )? '>' )?
            int alt113=2;
            alt113 = dfa113.predict(input);
            switch (alt113) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1726:7: '<' (a1= typeRefOrExpression ( COMMA ax= typeRefOrExpression )* )? '>'
                    {
                    match(input,53,FOLLOW_53_in_simpleIdentifier6192); if (state.failed) return identifier;

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1726:11: (a1= typeRefOrExpression ( COMMA ax= typeRefOrExpression )* )?
                    int alt112=2;
                    alt112 = dfa112.predict(input);
                    switch (alt112) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1727:9: a1= typeRefOrExpression ( COMMA ax= typeRefOrExpression )*
                            {
                            pushFollow(FOLLOW_typeRefOrExpression_in_simpleIdentifier6206);
                            a1=typeRefOrExpression();

                            state._fsp--;
                            if (state.failed) return identifier;

                            if ( state.backtracking==0 ) { identifier.addTemplateArgument(a1); }

                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1728:9: ( COMMA ax= typeRefOrExpression )*
                            loop111:
                            do {
                                int alt111=2;
                                switch ( input.LA(1) ) {
                                case COMMA:
                                    {
                                    alt111=1;
                                    }
                                    break;

                                }

                                switch (alt111) {
                            	case 1 :
                            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1729:11: COMMA ax= typeRefOrExpression
                            	    {
                            	    match(input,COMMA,FOLLOW_COMMA_in_simpleIdentifier6230); if (state.failed) return identifier;

                            	    pushFollow(FOLLOW_typeRefOrExpression_in_simpleIdentifier6245);
                            	    ax=typeRefOrExpression();

                            	    state._fsp--;
                            	    if (state.failed) return identifier;

                            	    if ( state.backtracking==0 ) { identifier.addTemplateArgument(ax); }

                            	    }
                            	    break;

                            	default :
                            	    break loop111;
                                }
                            } while (true);


                            }
                            break;

                    }


                    match(input,59,FOLLOW_59_in_simpleIdentifier6271); if (state.failed) return identifier;

                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 49, simpleIdentifier_StartIndex); }

        }
        return identifier;
    }
    // $ANTLR end "simpleIdentifier"



    // $ANTLR start "qualifiedIdentifier"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1736:1: qualifiedIdentifier returns [Identifier identifier] : ( '::' )? i1= simpleIdentifier ( '::' ix= simpleIdentifier )* ;
    public final Identifier qualifiedIdentifier() throws RecognitionException {
        Identifier identifier = null;

        int qualifiedIdentifier_StartIndex = input.index();

        SimpleIdentifier i1 =null;

        SimpleIdentifier ix =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 50) ) { return identifier; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1737:3: ( ( '::' )? i1= simpleIdentifier ( '::' ix= simpleIdentifier )* )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1738:5: ( '::' )? i1= simpleIdentifier ( '::' ix= simpleIdentifier )*
            {
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1738:5: ( '::' )?
            int alt114=2;
            switch ( input.LA(1) ) {
                case 52:
                    {
                    alt114=1;
                    }
                    break;
            }

            switch (alt114) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1738:5: '::'
                    {
                    match(input,52,FOLLOW_52_in_qualifiedIdentifier6301); if (state.failed) return identifier;

                    }
                    break;

            }


            pushFollow(FOLLOW_simpleIdentifier_in_qualifiedIdentifier6310);
            i1=simpleIdentifier();

            state._fsp--;
            if (state.failed) return identifier;

            if ( state.backtracking==0 ) { identifier = i1; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1740:5: ( '::' ix= simpleIdentifier )*
            loop115:
            do {
                int alt115=2;
                switch ( input.LA(1) ) {
                case 52:
                    {
                    alt115=1;
                    }
                    break;

                }

                switch (alt115) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1741:7: '::' ix= simpleIdentifier
            	    {
            	    match(input,52,FOLLOW_52_in_qualifiedIdentifier6326); if (state.failed) return identifier;

            	    pushFollow(FOLLOW_simpleIdentifier_in_qualifiedIdentifier6330);
            	    ix=simpleIdentifier();

            	    state._fsp--;
            	    if (state.failed) return identifier;

            	    if ( state.backtracking==0 ) { identifier = identifier.derive(QualificationSeparator.Colons, ix); }

            	    }
            	    break;

            	default :
            	    break loop115;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 50, qualifiedIdentifier_StartIndex); }

        }
        return identifier;
    }
    // $ANTLR end "qualifiedIdentifier"



    // $ANTLR start "qualifiedCppFunctionName"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1745:1: qualifiedCppFunctionName returns [Identifier identifier] : i1= simpleCppFunctionName ( '::' ix= simpleCppFunctionName )* ;
    public final Identifier qualifiedCppFunctionName() throws RecognitionException {
        Identifier identifier = null;

        int qualifiedCppFunctionName_StartIndex = input.index();

        SimpleIdentifier i1 =null;

        SimpleIdentifier ix =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 51) ) { return identifier; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1746:3: (i1= simpleCppFunctionName ( '::' ix= simpleCppFunctionName )* )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1746:6: i1= simpleCppFunctionName ( '::' ix= simpleCppFunctionName )*
            {
            pushFollow(FOLLOW_simpleCppFunctionName_in_qualifiedCppFunctionName6361);
            i1=simpleCppFunctionName();

            state._fsp--;
            if (state.failed) return identifier;

            if ( state.backtracking==0 ) { identifier = i1; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1747:5: ( '::' ix= simpleCppFunctionName )*
            loop116:
            do {
                int alt116=2;
                switch ( input.LA(1) ) {
                case 52:
                    {
                    alt116=1;
                    }
                    break;

                }

                switch (alt116) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1748:7: '::' ix= simpleCppFunctionName
            	    {
            	    match(input,52,FOLLOW_52_in_qualifiedCppFunctionName6377); if (state.failed) return identifier;

            	    pushFollow(FOLLOW_simpleCppFunctionName_in_qualifiedCppFunctionName6381);
            	    ix=simpleCppFunctionName();

            	    state._fsp--;
            	    if (state.failed) return identifier;

            	    if ( state.backtracking==0 ) { 
            	              identifier = identifier.derive(QualificationSeparator.Colons, ix); 
            	                }

            	    }
            	    break;

            	default :
            	    break loop116;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 51, qualifiedCppFunctionName_StartIndex); }

        }
        return identifier;
    }
    // $ANTLR end "qualifiedCppFunctionName"



    // $ANTLR start "operator"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1754:1: operator returns [Expression.Operator op] : ( unaryOp | postfixOp | binaryOp | assignmentOp | '=' | '->' '*' | '[' ']' | LPAREN RPAREN | COMMA | '->' );
    public final Expression.Operator operator() throws RecognitionException {
        Expression.Operator op = null;

        int operator_StartIndex = input.index();

        Expression.UnaryOperator unaryOp36 =null;

        Expression.UnaryOperator postfixOp37 =null;

        Expression.BinaryOperator binaryOp38 =null;

        ObjCppParser.assignmentOp_return assignmentOp39 =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 52) ) { return op; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1755:3: ( unaryOp | postfixOp | binaryOp | assignmentOp | '=' | '->' '*' | '[' ']' | LPAREN RPAREN | COMMA | '->' )
            int alt117=10;
            switch ( input.LA(1) ) {
            case 41:
                {
                int LA117_1 = input.LA(2);

                if ( (synpred199_ObjCpp()) ) {
                    alt117=1;
                }
                else if ( (synpred200_ObjCpp()) ) {
                    alt117=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return op;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 117, 1, input);

                    throw nvae;

                }
                }
                break;
            case 44:
                {
                int LA117_2 = input.LA(2);

                if ( (synpred199_ObjCpp()) ) {
                    alt117=1;
                }
                else if ( (synpred200_ObjCpp()) ) {
                    alt117=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return op;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 117, 2, input);

                    throw nvae;

                }
                }
                break;
            case 36:
            case 38:
            case 43:
                {
                int LA117_3 = input.LA(2);

                if ( (synpred199_ObjCpp()) ) {
                    alt117=1;
                }
                else if ( (synpred201_ObjCpp()) ) {
                    alt117=3;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return op;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 117, 3, input);

                    throw nvae;

                }
                }
                break;
            case 30:
            case 103:
                {
                alt117=1;
                }
                break;
            case 31:
            case 33:
            case 35:
            case 40:
            case 49:
            case 53:
            case 54:
            case 56:
            case 58:
            case 59:
            case 60:
            case 61:
            case 63:
            case 80:
            case 100:
            case 102:
                {
                alt117=3;
                }
                break;
            case 57:
                {
                int LA117_6 = input.LA(2);

                if ( (synpred202_ObjCpp()) ) {
                    alt117=4;
                }
                else if ( (synpred203_ObjCpp()) ) {
                    alt117=5;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return op;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 117, 6, input);

                    throw nvae;

                }
                }
                break;
            case 34:
            case 37:
            case 39:
            case 42:
            case 45:
            case 50:
            case 55:
            case 62:
            case 81:
            case 101:
            case 104:
                {
                alt117=4;
                }
                break;
            case 46:
                {
                switch ( input.LA(2) ) {
                case 38:
                    {
                    alt117=6;
                    }
                    break;
                case EOF:
                case LPAREN:
                case 52:
                    {
                    alt117=10;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return op;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 117, 8, input);

                    throw nvae;

                }

                }
                break;
            case 78:
                {
                alt117=7;
                }
                break;
            case LPAREN:
                {
                alt117=8;
                }
                break;
            case COMMA:
                {
                alt117=9;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return op;}
                NoViableAltException nvae =
                    new NoViableAltException("", 117, 0, input);

                throw nvae;

            }

            switch (alt117) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1756:5: unaryOp
                    {
                    pushFollow(FOLLOW_unaryOp_in_operator6413);
                    unaryOp36=unaryOp();

                    state._fsp--;
                    if (state.failed) return op;

                    if ( state.backtracking==0 ) { op = unaryOp36; }

                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1757:5: postfixOp
                    {
                    pushFollow(FOLLOW_postfixOp_in_operator6424);
                    postfixOp37=postfixOp();

                    state._fsp--;
                    if (state.failed) return op;

                    if ( state.backtracking==0 ) { op = postfixOp37; }

                    }
                    break;
                case 3 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1758:5: binaryOp
                    {
                    pushFollow(FOLLOW_binaryOp_in_operator6435);
                    binaryOp38=binaryOp();

                    state._fsp--;
                    if (state.failed) return op;

                    if ( state.backtracking==0 ) { op = binaryOp38; }

                    }
                    break;
                case 4 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1759:5: assignmentOp
                    {
                    pushFollow(FOLLOW_assignmentOp_in_operator6446);
                    assignmentOp39=assignmentOp();

                    state._fsp--;
                    if (state.failed) return op;

                    if ( state.backtracking==0 ) { op = (assignmentOp39!=null?assignmentOp39.op:null); }

                    }
                    break;
                case 5 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1760:5: '='
                    {
                    match(input,57,FOLLOW_57_in_operator6456); if (state.failed) return op;

                    if ( state.backtracking==0 ) { op = BinaryOperator.Assign; }

                    }
                    break;
                case 6 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1761:5: '->' '*'
                    {
                    match(input,46,FOLLOW_46_in_operator6466); if (state.failed) return op;

                    match(input,38,FOLLOW_38_in_operator6468); if (state.failed) return op;

                    if ( state.backtracking==0 ) { op = BinaryOperator.ArrowStar; }

                    }
                    break;
                case 7 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1762:5: '[' ']'
                    {
                    match(input,78,FOLLOW_78_in_operator6478); if (state.failed) return op;

                    match(input,79,FOLLOW_79_in_operator6480); if (state.failed) return op;

                    if ( state.backtracking==0 ) { op = BinaryOperator.SquareBrackets; }

                    }
                    break;
                case 8 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1763:5: LPAREN RPAREN
                    {
                    match(input,LPAREN,FOLLOW_LPAREN_in_operator6490); if (state.failed) return op;

                    match(input,RPAREN,FOLLOW_RPAREN_in_operator6492); if (state.failed) return op;

                    if ( state.backtracking==0 ) { op = UnaryOperator.Parenthesis; }

                    }
                    break;
                case 9 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1764:5: COMMA
                    {
                    match(input,COMMA,FOLLOW_COMMA_in_operator6502); if (state.failed) return op;

                    if ( state.backtracking==0 ) { op = BinaryOperator.Comma; }

                    }
                    break;
                case 10 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1765:5: '->'
                    {
                    match(input,46,FOLLOW_46_in_operator6512); if (state.failed) return op;

                    if ( state.backtracking==0 ) { op = BinaryOperator.Arrow; }

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 52, operator_StartIndex); }

        }
        return op;
    }
    // $ANTLR end "operator"



    // $ANTLR start "simpleCppFunctionName"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1768:1: simpleCppFunctionName returns [SimpleIdentifier identifier] : ({...}? IDENTIFIER operator | (pre= '~' )? i= simpleIdentifier );
    public final SimpleIdentifier simpleCppFunctionName() throws RecognitionException {
        SimpleIdentifier identifier = null;

        int simpleCppFunctionName_StartIndex = input.index();

        Token pre=null;
        SimpleIdentifier i =null;

        Expression.Operator operator40 =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 53) ) { return identifier; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1769:3: ({...}? IDENTIFIER operator | (pre= '~' )? i= simpleIdentifier )
            int alt119=2;
            switch ( input.LA(1) ) {
            case IDENTIFIER:
                {
                switch ( input.LA(2) ) {
                case COMMA:
                case 30:
                case 31:
                case 33:
                case 34:
                case 35:
                case 36:
                case 37:
                case 38:
                case 39:
                case 40:
                case 41:
                case 42:
                case 43:
                case 44:
                case 45:
                case 46:
                case 49:
                case 50:
                case 54:
                case 55:
                case 56:
                case 57:
                case 58:
                case 59:
                case 60:
                case 61:
                case 62:
                case 63:
                case 78:
                case 80:
                case 81:
                case 100:
                case 101:
                case 102:
                case 103:
                case 104:
                    {
                    alt119=1;
                    }
                    break;
                case 53:
                    {
                    int LA119_7 = input.LA(3);

                    if ( (((synpred208_ObjCpp()&&synpred208_ObjCpp())&&( next("operator") ))) ) {
                        alt119=1;
                    }
                    else if ( (true) ) {
                        alt119=2;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return identifier;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 119, 7, input);

                        throw nvae;

                    }
                    }
                    break;
                case LPAREN:
                    {
                    int LA119_12 = input.LA(3);

                    if ( (((synpred208_ObjCpp()&&synpred208_ObjCpp())&&( next("operator") ))) ) {
                        alt119=1;
                    }
                    else if ( (true) ) {
                        alt119=2;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return identifier;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 119, 12, input);

                        throw nvae;

                    }
                    }
                    break;
                case EOF:
                case 52:
                    {
                    alt119=2;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return identifier;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 119, 1, input);

                    throw nvae;

                }

                }
                break;
            case 103:
                {
                alt119=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return identifier;}
                NoViableAltException nvae =
                    new NoViableAltException("", 119, 0, input);

                throw nvae;

            }

            switch (alt119) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1770:5: {...}? IDENTIFIER operator
                    {
                    if ( !(( next("operator") )) ) {
                        if (state.backtracking>0) {state.failed=true; return identifier;}
                        throw new FailedPredicateException(input, "simpleCppFunctionName", " next(\"operator\") ");
                    }

                    match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_simpleCppFunctionName6539); if (state.failed) return identifier;

                    pushFollow(FOLLOW_operator_in_simpleCppFunctionName6541);
                    operator40=operator();

                    state._fsp--;
                    if (state.failed) return identifier;

                    if ( state.backtracking==0 ) {
                          identifier = new SimpleIdentifier("operator" + operator40.toString());
                        }

                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1773:5: (pre= '~' )? i= simpleIdentifier
                    {
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1773:8: (pre= '~' )?
                    int alt118=2;
                    switch ( input.LA(1) ) {
                        case 103:
                            {
                            alt118=1;
                            }
                            break;
                    }

                    switch (alt118) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1773:8: pre= '~'
                            {
                            pre=(Token)match(input,103,FOLLOW_103_in_simpleCppFunctionName6553); if (state.failed) return identifier;

                            }
                            break;

                    }


                    pushFollow(FOLLOW_simpleIdentifier_in_simpleCppFunctionName6563);
                    i=simpleIdentifier();

                    state._fsp--;
                    if (state.failed) return identifier;

                    if ( state.backtracking==0 ) {
                          if ((pre!=null?pre.getText():null) != null)
                            i.setName((pre!=null?pre.getText():null) + i.getName());
                          identifier = i;
                        }

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 53, simpleCppFunctionName_StartIndex); }

        }
        return identifier;
    }
    // $ANTLR end "simpleCppFunctionName"



    // $ANTLR start "expressionsBlock"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1781:1: expressionsBlock returns [ExpressionsBlock expr] : LBRACE (e1= expression ( COMMA ex= expression )* )? RBRACE ;
    public final ExpressionsBlock expressionsBlock() throws RecognitionException {
        ExpressionsBlock expr = null;

        int expressionsBlock_StartIndex = input.index();

        Expression e1 =null;

        Expression ex =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 54) ) { return expr; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1782:3: ( LBRACE (e1= expression ( COMMA ex= expression )* )? RBRACE )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1783:5: LBRACE (e1= expression ( COMMA ex= expression )* )? RBRACE
            {
            match(input,LBRACE,FOLLOW_LBRACE_in_expressionsBlock6588); if (state.failed) return expr;

            if ( state.backtracking==0 ) { 
                  expr = new ExpressionsBlock();
                }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1786:5: (e1= expression ( COMMA ex= expression )* )?
            int alt121=2;
            switch ( input.LA(1) ) {
                case CHARACTER:
                case DECIMAL_NUMBER:
                case FLOAT_NUMBER:
                case HEXADECIMAL_NUMBER:
                case IDENTIFIER:
                case LBRACE:
                case LPAREN:
                case OCTAL_NUMBER:
                case STRING:
                case 30:
                case 36:
                case 38:
                case 40:
                case 41:
                case 43:
                case 44:
                case 66:
                case 74:
                case 77:
                case 78:
                case 103:
                    {
                    alt121=1;
                    }
                    break;
            }

            switch (alt121) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1787:7: e1= expression ( COMMA ex= expression )*
                    {
                    pushFollow(FOLLOW_expression_in_expressionsBlock6606);
                    e1=expression();

                    state._fsp--;
                    if (state.failed) return expr;

                    if ( state.backtracking==0 ) {
                            expr.addExpression(e1);
                          }

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1790:7: ( COMMA ex= expression )*
                    loop120:
                    do {
                        int alt120=2;
                        switch ( input.LA(1) ) {
                        case COMMA:
                            {
                            alt120=1;
                            }
                            break;

                        }

                        switch (alt120) {
                    	case 1 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1791:9: COMMA ex= expression
                    	    {
                    	    match(input,COMMA,FOLLOW_COMMA_in_expressionsBlock6626); if (state.failed) return expr;

                    	    pushFollow(FOLLOW_expression_in_expressionsBlock6638);
                    	    ex=expression();

                    	    state._fsp--;
                    	    if (state.failed) return expr;

                    	    if ( state.backtracking==0 ) {
                    	              expr.addExpression(ex);
                    	            }

                    	    }
                    	    break;

                    	default :
                    	    break loop120;
                        }
                    } while (true);


                    }
                    break;

            }


            match(input,RBRACE,FOLLOW_RBRACE_in_expressionsBlock6662); if (state.failed) return expr;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 54, expressionsBlock_StartIndex); }

        }
        return expr;
    }
    // $ANTLR end "expressionsBlock"



    // $ANTLR start "baseExpression"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1801:1: baseExpression returns [Expression expr] : (i= simpleIdentifier | constant | LPAREN expression RPAREN | objCMethodCall | expressionsBlock | selectorExpr | protocolExpr | encodingExpr );
    public final Expression baseExpression() throws RecognitionException {
        Expression expr = null;

        int baseExpression_StartIndex = input.index();

        SimpleIdentifier i =null;

        Constant constant41 =null;

        Expression expression42 =null;

        FunctionCall objCMethodCall43 =null;

        ExpressionsBlock expressionsBlock44 =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 55) ) { return expr; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1802:3: (i= simpleIdentifier | constant | LPAREN expression RPAREN | objCMethodCall | expressionsBlock | selectorExpr | protocolExpr | encodingExpr )
            int alt122=8;
            switch ( input.LA(1) ) {
            case IDENTIFIER:
                {
                alt122=1;
                }
                break;
            case CHARACTER:
            case DECIMAL_NUMBER:
            case FLOAT_NUMBER:
            case HEXADECIMAL_NUMBER:
            case OCTAL_NUMBER:
            case STRING:
            case 40:
            case 43:
                {
                alt122=2;
                }
                break;
            case LPAREN:
                {
                alt122=3;
                }
                break;
            case 78:
                {
                alt122=4;
                }
                break;
            case LBRACE:
                {
                alt122=5;
                }
                break;
            case 77:
                {
                alt122=6;
                }
                break;
            case 74:
                {
                alt122=7;
                }
                break;
            case 66:
                {
                alt122=8;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return expr;}
                NoViableAltException nvae =
                    new NoViableAltException("", 122, 0, input);

                throw nvae;

            }

            switch (alt122) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1803:5: i= simpleIdentifier
                    {
                    pushFollow(FOLLOW_simpleIdentifier_in_baseExpression6702);
                    i=simpleIdentifier();

                    state._fsp--;
                    if (state.failed) return expr;

                    if ( state.backtracking==0 ) { expr = new VariableRef(i); }

                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1804:5: constant
                    {
                    pushFollow(FOLLOW_constant_in_baseExpression6713);
                    constant41=constant();

                    state._fsp--;
                    if (state.failed) return expr;

                    if ( state.backtracking==0 ) { expr = constant41; }

                    }
                    break;
                case 3 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1805:5: LPAREN expression RPAREN
                    {
                    match(input,LPAREN,FOLLOW_LPAREN_in_baseExpression6723); if (state.failed) return expr;

                    pushFollow(FOLLOW_expression_in_baseExpression6725);
                    expression42=expression();

                    state._fsp--;
                    if (state.failed) return expr;

                    match(input,RPAREN,FOLLOW_RPAREN_in_baseExpression6727); if (state.failed) return expr;

                    if ( state.backtracking==0 ) { 
                          expr = expression42; 
                          if (expr != null)
                            expr.setParenthesis(true);
                        }

                    }
                    break;
                case 4 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1810:5: objCMethodCall
                    {
                    pushFollow(FOLLOW_objCMethodCall_in_baseExpression6737);
                    objCMethodCall43=objCMethodCall();

                    state._fsp--;
                    if (state.failed) return expr;

                    if ( state.backtracking==0 ) { expr = objCMethodCall43; }

                    }
                    break;
                case 5 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1811:5: expressionsBlock
                    {
                    pushFollow(FOLLOW_expressionsBlock_in_baseExpression6747);
                    expressionsBlock44=expressionsBlock();

                    state._fsp--;
                    if (state.failed) return expr;

                    if ( state.backtracking==0 ) { expr = expressionsBlock44; }

                    }
                    break;
                case 6 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1812:5: selectorExpr
                    {
                    pushFollow(FOLLOW_selectorExpr_in_baseExpression6757);
                    selectorExpr();

                    state._fsp--;
                    if (state.failed) return expr;

                    }
                    break;
                case 7 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1813:5: protocolExpr
                    {
                    pushFollow(FOLLOW_protocolExpr_in_baseExpression6765);
                    protocolExpr();

                    state._fsp--;
                    if (state.failed) return expr;

                    }
                    break;
                case 8 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1814:5: encodingExpr
                    {
                    pushFollow(FOLLOW_encodingExpr_in_baseExpression6773);
                    encodingExpr();

                    state._fsp--;
                    if (state.failed) return expr;

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 55, baseExpression_StartIndex); }

        }
        return expr;
    }
    // $ANTLR end "baseExpression"



    // $ANTLR start "selectorExpr"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1817:1: selectorExpr returns [Expression expr] : '@selector' LPAREN selectorName RPAREN ;
    public final Expression selectorExpr() throws RecognitionException {
        Expression expr = null;

        int selectorExpr_StartIndex = input.index();

        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 56) ) { return expr; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1818:3: ( '@selector' LPAREN selectorName RPAREN )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1818:6: '@selector' LPAREN selectorName RPAREN
            {
            match(input,77,FOLLOW_77_in_selectorExpr6793); if (state.failed) return expr;

            match(input,LPAREN,FOLLOW_LPAREN_in_selectorExpr6800); if (state.failed) return expr;

            pushFollow(FOLLOW_selectorName_in_selectorExpr6807);
            selectorName();

            state._fsp--;
            if (state.failed) return expr;

            match(input,RPAREN,FOLLOW_RPAREN_in_selectorExpr6814); if (state.failed) return expr;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 56, selectorExpr_StartIndex); }

        }
        return expr;
    }
    // $ANTLR end "selectorExpr"



    // $ANTLR start "selectorName"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1824:1: selectorName : IDENTIFIER ( IDENTIFIER ':' )* ;
    public final void selectorName() throws RecognitionException {
        int selectorName_StartIndex = input.index();

        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 57) ) { return ; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1825:3: ( IDENTIFIER ( IDENTIFIER ':' )* )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1825:6: IDENTIFIER ( IDENTIFIER ':' )*
            {
            match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_selectorName6828); if (state.failed) return ;

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1825:17: ( IDENTIFIER ':' )*
            loop123:
            do {
                int alt123=2;
                switch ( input.LA(1) ) {
                case IDENTIFIER:
                    {
                    alt123=1;
                    }
                    break;

                }

                switch (alt123) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1825:18: IDENTIFIER ':'
            	    {
            	    match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_selectorName6831); if (state.failed) return ;

            	    match(input,51,FOLLOW_51_in_selectorName6833); if (state.failed) return ;

            	    }
            	    break;

            	default :
            	    break loop123;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 57, selectorName_StartIndex); }

        }
        return ;
    }
    // $ANTLR end "selectorName"



    // $ANTLR start "protocolExpr"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1828:1: protocolExpr : '@protocol' LPAREN IDENTIFIER RPAREN ;
    public final void protocolExpr() throws RecognitionException {
        int protocolExpr_StartIndex = input.index();

        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 58) ) { return ; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1829:3: ( '@protocol' LPAREN IDENTIFIER RPAREN )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1829:6: '@protocol' LPAREN IDENTIFIER RPAREN
            {
            match(input,74,FOLLOW_74_in_protocolExpr6849); if (state.failed) return ;

            match(input,LPAREN,FOLLOW_LPAREN_in_protocolExpr6855); if (state.failed) return ;

            match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_protocolExpr6861); if (state.failed) return ;

            match(input,RPAREN,FOLLOW_RPAREN_in_protocolExpr6867); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 58, protocolExpr_StartIndex); }

        }
        return ;
    }
    // $ANTLR end "protocolExpr"



    // $ANTLR start "encodingExpr"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1835:1: encodingExpr : '@encode' LPAREN IDENTIFIER RPAREN ;
    public final void encodingExpr() throws RecognitionException {
        int encodingExpr_StartIndex = input.index();

        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 59) ) { return ; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1836:3: ( '@encode' LPAREN IDENTIFIER RPAREN )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1836:6: '@encode' LPAREN IDENTIFIER RPAREN
            {
            match(input,66,FOLLOW_66_in_encodingExpr6881); if (state.failed) return ;

            match(input,LPAREN,FOLLOW_LPAREN_in_encodingExpr6888); if (state.failed) return ;

            match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_encodingExpr6894); if (state.failed) return ;

            match(input,RPAREN,FOLLOW_RPAREN_in_encodingExpr6901); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 59, encodingExpr_StartIndex); }

        }
        return ;
    }
    // $ANTLR end "encodingExpr"



    // $ANTLR start "assignmentExpr"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1842:1: assignmentExpr returns [Expression expr] : e= inlineCondExpr (op= assignmentOp f= assignmentExpr )? ;
    public final Expression assignmentExpr() throws RecognitionException {
        Expression expr = null;

        int assignmentExpr_StartIndex = input.index();

        Expression e =null;

        ObjCppParser.assignmentOp_return op =null;

        Expression f =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 60) ) { return expr; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1843:3: (e= inlineCondExpr (op= assignmentOp f= assignmentExpr )? )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1843:6: e= inlineCondExpr (op= assignmentOp f= assignmentExpr )?
            {
            pushFollow(FOLLOW_inlineCondExpr_in_assignmentExpr6921);
            e=inlineCondExpr();

            state._fsp--;
            if (state.failed) return expr;

            if ( state.backtracking==0 ) { expr = e; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1844:5: (op= assignmentOp f= assignmentExpr )?
            int alt124=2;
            alt124 = dfa124.predict(input);
            switch (alt124) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1845:7: op= assignmentOp f= assignmentExpr
                    {
                    pushFollow(FOLLOW_assignmentOp_in_assignmentExpr6942);
                    op=assignmentOp();

                    state._fsp--;
                    if (state.failed) return expr;

                    pushFollow(FOLLOW_assignmentExpr_in_assignmentExpr6946);
                    f=assignmentExpr();

                    state._fsp--;
                    if (state.failed) return expr;

                    if ( state.backtracking==0 ) { 
                            expr = new AssignmentOp(expr, getAssignmentOperator((op!=null?input.toString(op.start,op.stop):null)), f); 
                          }

                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 60, assignmentExpr_StartIndex); }

        }
        return expr;
    }
    // $ANTLR end "assignmentExpr"


    public static class assignmentOp_return extends ParserRuleReturnScope {
        public Expression.AssignmentOperator op;
    };


    // $ANTLR start "assignmentOp"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1851:1: assignmentOp returns [Expression.AssignmentOperator op] : t= ( '=' | '*=' | '/=' | '%=' | '+=' | '-=' | '<<=' | '>>=' | '&=' | '^=' | '|=' | '~=' ) ;
    public final ObjCppParser.assignmentOp_return assignmentOp() throws RecognitionException {
        ObjCppParser.assignmentOp_return retval = new ObjCppParser.assignmentOp_return();
        retval.start = input.LT(1);

        int assignmentOp_StartIndex = input.index();

        Token t=null;

        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 61) ) { return retval; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1852:3: (t= ( '=' | '*=' | '/=' | '%=' | '+=' | '-=' | '<<=' | '>>=' | '&=' | '^=' | '|=' | '~=' ) )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1852:7: t= ( '=' | '*=' | '/=' | '%=' | '+=' | '-=' | '<<=' | '>>=' | '&=' | '^=' | '|=' | '~=' )
            {
            t=(Token)input.LT(1);

            if ( input.LA(1)==34||input.LA(1)==37||input.LA(1)==39||input.LA(1)==42||input.LA(1)==45||input.LA(1)==50||input.LA(1)==55||input.LA(1)==57||input.LA(1)==62||input.LA(1)==81||input.LA(1)==101||input.LA(1)==104 ) {
                input.consume();
                state.errorRecovery=false;
                state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            if ( state.backtracking==0 ) {
                  retval.op = getAssignmentOperator((t!=null?t.getText():null));
                }

            }

            retval.stop = input.LT(-1);


        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 61, assignmentOp_StartIndex); }

        }
        return retval;
    }
    // $ANTLR end "assignmentOp"



    // $ANTLR start "inlineCondExpr"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1857:1: inlineCondExpr returns [Expression expr] : e= logOrExpr ( '?' logOrExpr ':' logOrExpr )* ;
    public final Expression inlineCondExpr() throws RecognitionException {
        Expression expr = null;

        int inlineCondExpr_StartIndex = input.index();

        Expression e =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 62) ) { return expr; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1858:3: (e= logOrExpr ( '?' logOrExpr ':' logOrExpr )* )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1858:6: e= logOrExpr ( '?' logOrExpr ':' logOrExpr )*
            {
            pushFollow(FOLLOW_logOrExpr_in_inlineCondExpr7046);
            e=logOrExpr();

            state._fsp--;
            if (state.failed) return expr;

            if ( state.backtracking==0 ) { expr = e; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1859:5: ( '?' logOrExpr ':' logOrExpr )*
            loop125:
            do {
                int alt125=2;
                switch ( input.LA(1) ) {
                case 64:
                    {
                    int LA125_21 = input.LA(2);

                    if ( (synpred232_ObjCpp()) ) {
                        alt125=1;
                    }


                    }
                    break;

                }

                switch (alt125) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1860:7: '?' logOrExpr ':' logOrExpr
            	    {
            	    match(input,64,FOLLOW_64_in_inlineCondExpr7063); if (state.failed) return expr;

            	    pushFollow(FOLLOW_logOrExpr_in_inlineCondExpr7071);
            	    logOrExpr();

            	    state._fsp--;
            	    if (state.failed) return expr;

            	    match(input,51,FOLLOW_51_in_inlineCondExpr7080); if (state.failed) return expr;

            	    pushFollow(FOLLOW_logOrExpr_in_inlineCondExpr7088);
            	    logOrExpr();

            	    state._fsp--;
            	    if (state.failed) return expr;

            	    }
            	    break;

            	default :
            	    break loop125;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 62, inlineCondExpr_StartIndex); }

        }
        return expr;
    }
    // $ANTLR end "inlineCondExpr"



    // $ANTLR start "addExpr"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1867:1: addExpr returns [Expression expr] : e= multExpr (op= ( '+' | '-' ) f= multExpr )* ;
    public final Expression addExpr() throws RecognitionException {
        Expression expr = null;

        int addExpr_StartIndex = input.index();

        Token op=null;
        Expression e =null;

        Expression f =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 63) ) { return expr; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1868:3: (e= multExpr (op= ( '+' | '-' ) f= multExpr )* )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1868:6: e= multExpr (op= ( '+' | '-' ) f= multExpr )*
            {
            pushFollow(FOLLOW_multExpr_in_addExpr7115);
            e=multExpr();

            state._fsp--;
            if (state.failed) return expr;

            if ( state.backtracking==0 ) { expr = e; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1869:5: (op= ( '+' | '-' ) f= multExpr )*
            loop126:
            do {
                int alt126=2;
                alt126 = dfa126.predict(input);
                switch (alt126) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1870:7: op= ( '+' | '-' ) f= multExpr
            	    {
            	    op=(Token)input.LT(1);

            	    if ( input.LA(1)==40||input.LA(1)==43 ) {
            	        input.consume();
            	        state.errorRecovery=false;
            	        state.failed=false;
            	    }
            	    else {
            	        if (state.backtracking>0) {state.failed=true; return expr;}
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        throw mse;
            	    }


            	    pushFollow(FOLLOW_multExpr_in_addExpr7149);
            	    f=multExpr();

            	    state._fsp--;
            	    if (state.failed) return expr;

            	    if ( state.backtracking==0 ) { expr = new BinaryOp(expr, getBinaryOperator((op!=null?op.getText():null)), f); }

            	    }
            	    break;

            	default :
            	    break loop126;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 63, addExpr_StartIndex); }

        }
        return expr;
    }
    // $ANTLR end "addExpr"



    // $ANTLR start "multExpr"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1875:1: multExpr returns [Expression expr] : e= castExpr (op= ( '%' | '*' | '/' ) f= castExpr )* ;
    public final Expression multExpr() throws RecognitionException {
        Expression expr = null;

        int multExpr_StartIndex = input.index();

        Token op=null;
        Expression e =null;

        Expression f =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 64) ) { return expr; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1876:3: (e= castExpr (op= ( '%' | '*' | '/' ) f= castExpr )* )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1876:6: e= castExpr (op= ( '%' | '*' | '/' ) f= castExpr )*
            {
            pushFollow(FOLLOW_castExpr_in_multExpr7178);
            e=castExpr();

            state._fsp--;
            if (state.failed) return expr;

            if ( state.backtracking==0 ) { expr = e; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1877:5: (op= ( '%' | '*' | '/' ) f= castExpr )*
            loop127:
            do {
                int alt127=2;
                alt127 = dfa127.predict(input);
                switch (alt127) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1878:7: op= ( '%' | '*' | '/' ) f= castExpr
            	    {
            	    op=(Token)input.LT(1);

            	    if ( input.LA(1)==33||input.LA(1)==38||input.LA(1)==49 ) {
            	        input.consume();
            	        state.errorRecovery=false;
            	        state.failed=false;
            	    }
            	    else {
            	        if (state.backtracking>0) {state.failed=true; return expr;}
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        throw mse;
            	    }


            	    pushFollow(FOLLOW_castExpr_in_multExpr7218);
            	    f=castExpr();

            	    state._fsp--;
            	    if (state.failed) return expr;

            	    if ( state.backtracking==0 ) { expr = new BinaryOp(expr, getBinaryOperator((op!=null?op.getText():null)), f); }

            	    }
            	    break;

            	default :
            	    break loop127;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 64, multExpr_StartIndex); }

        }
        return expr;
    }
    // $ANTLR end "multExpr"



    // $ANTLR start "bitOrExpr"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1883:1: bitOrExpr returns [Expression expr] : e= xorExpr (op= '|' f= xorExpr )* ;
    public final Expression bitOrExpr() throws RecognitionException {
        Expression expr = null;

        int bitOrExpr_StartIndex = input.index();

        Token op=null;
        Expression e =null;

        Expression f =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 65) ) { return expr; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1884:3: (e= xorExpr (op= '|' f= xorExpr )* )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1884:6: e= xorExpr (op= '|' f= xorExpr )*
            {
            pushFollow(FOLLOW_xorExpr_in_bitOrExpr7247);
            e=xorExpr();

            state._fsp--;
            if (state.failed) return expr;

            if ( state.backtracking==0 ) { expr = e; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1885:5: (op= '|' f= xorExpr )*
            loop128:
            do {
                int alt128=2;
                switch ( input.LA(1) ) {
                case 100:
                    {
                    int LA128_21 = input.LA(2);

                    if ( (synpred238_ObjCpp()) ) {
                        alt128=1;
                    }


                    }
                    break;

                }

                switch (alt128) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1886:7: op= '|' f= xorExpr
            	    {
            	    op=(Token)match(input,100,FOLLOW_100_in_bitOrExpr7266); if (state.failed) return expr;

            	    pushFollow(FOLLOW_xorExpr_in_bitOrExpr7276);
            	    f=xorExpr();

            	    state._fsp--;
            	    if (state.failed) return expr;

            	    if ( state.backtracking==0 ) { expr = new BinaryOp(expr, getBinaryOperator((op!=null?op.getText():null)), f); }

            	    }
            	    break;

            	default :
            	    break loop128;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 65, bitOrExpr_StartIndex); }

        }
        return expr;
    }
    // $ANTLR end "bitOrExpr"



    // $ANTLR start "bitAndExpr"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1891:1: bitAndExpr returns [Expression expr] : e= equalExpr (op= '&' f= equalExpr )* ;
    public final Expression bitAndExpr() throws RecognitionException {
        Expression expr = null;

        int bitAndExpr_StartIndex = input.index();

        Token op=null;
        Expression e =null;

        Expression f =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 66) ) { return expr; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1892:3: (e= equalExpr (op= '&' f= equalExpr )* )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1892:6: e= equalExpr (op= '&' f= equalExpr )*
            {
            pushFollow(FOLLOW_equalExpr_in_bitAndExpr7305);
            e=equalExpr();

            state._fsp--;
            if (state.failed) return expr;

            if ( state.backtracking==0 ) { expr = e; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1893:5: (op= '&' f= equalExpr )*
            loop129:
            do {
                int alt129=2;
                switch ( input.LA(1) ) {
                case 36:
                    {
                    int LA129_21 = input.LA(2);

                    if ( (synpred239_ObjCpp()) ) {
                        alt129=1;
                    }


                    }
                    break;

                }

                switch (alt129) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1894:7: op= '&' f= equalExpr
            	    {
            	    op=(Token)match(input,36,FOLLOW_36_in_bitAndExpr7323); if (state.failed) return expr;

            	    pushFollow(FOLLOW_equalExpr_in_bitAndExpr7333);
            	    f=equalExpr();

            	    state._fsp--;
            	    if (state.failed) return expr;

            	    if ( state.backtracking==0 ) { expr = new BinaryOp(expr, getBinaryOperator((op!=null?op.getText():null)), f); }

            	    }
            	    break;

            	default :
            	    break loop129;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 66, bitAndExpr_StartIndex); }

        }
        return expr;
    }
    // $ANTLR end "bitAndExpr"



    // $ANTLR start "shiftExpr"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1900:1: shiftExpr returns [Expression expr] : e= addExpr (op= ( '>>' | '<<' ) f= addExpr )* ;
    public final Expression shiftExpr() throws RecognitionException {
        Expression expr = null;

        int shiftExpr_StartIndex = input.index();

        Token op=null;
        Expression e =null;

        Expression f =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 67) ) { return expr; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1901:3: (e= addExpr (op= ( '>>' | '<<' ) f= addExpr )* )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1901:6: e= addExpr (op= ( '>>' | '<<' ) f= addExpr )*
            {
            pushFollow(FOLLOW_addExpr_in_shiftExpr7363);
            e=addExpr();

            state._fsp--;
            if (state.failed) return expr;

            if ( state.backtracking==0 ) { expr = e; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1902:5: (op= ( '>>' | '<<' ) f= addExpr )*
            loop130:
            do {
                int alt130=2;
                switch ( input.LA(1) ) {
                case 54:
                case 61:
                    {
                    int LA130_21 = input.LA(2);

                    if ( (synpred241_ObjCpp()) ) {
                        alt130=1;
                    }


                    }
                    break;

                }

                switch (alt130) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1903:7: op= ( '>>' | '<<' ) f= addExpr
            	    {
            	    op=(Token)input.LT(1);

            	    if ( input.LA(1)==54||input.LA(1)==61 ) {
            	        input.consume();
            	        state.errorRecovery=false;
            	        state.failed=false;
            	    }
            	    else {
            	        if (state.backtracking>0) {state.failed=true; return expr;}
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        throw mse;
            	    }


            	    pushFollow(FOLLOW_addExpr_in_shiftExpr7397);
            	    f=addExpr();

            	    state._fsp--;
            	    if (state.failed) return expr;

            	    if ( state.backtracking==0 ) { expr = new BinaryOp(expr, getBinaryOperator((op!=null?op.getText():null)), f); }

            	    }
            	    break;

            	default :
            	    break loop130;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 67, shiftExpr_StartIndex); }

        }
        return expr;
    }
    // $ANTLR end "shiftExpr"



    // $ANTLR start "xorExpr"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1908:1: xorExpr returns [Expression expr] : e= bitAndExpr (op= '^' f= bitAndExpr )* ;
    public final Expression xorExpr() throws RecognitionException {
        Expression expr = null;

        int xorExpr_StartIndex = input.index();

        Token op=null;
        Expression e =null;

        Expression f =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 68) ) { return expr; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1909:3: (e= bitAndExpr (op= '^' f= bitAndExpr )* )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1909:6: e= bitAndExpr (op= '^' f= bitAndExpr )*
            {
            pushFollow(FOLLOW_bitAndExpr_in_xorExpr7426);
            e=bitAndExpr();

            state._fsp--;
            if (state.failed) return expr;

            if ( state.backtracking==0 ) { expr = e; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1910:5: (op= '^' f= bitAndExpr )*
            loop131:
            do {
                int alt131=2;
                switch ( input.LA(1) ) {
                case 80:
                    {
                    int LA131_21 = input.LA(2);

                    if ( (synpred242_ObjCpp()) ) {
                        alt131=1;
                    }


                    }
                    break;

                }

                switch (alt131) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1911:7: op= '^' f= bitAndExpr
            	    {
            	    op=(Token)match(input,80,FOLLOW_80_in_xorExpr7444); if (state.failed) return expr;

            	    pushFollow(FOLLOW_bitAndExpr_in_xorExpr7454);
            	    f=bitAndExpr();

            	    state._fsp--;
            	    if (state.failed) return expr;

            	    if ( state.backtracking==0 ) { expr = new BinaryOp(expr, getBinaryOperator((op!=null?op.getText():null)), f); }

            	    }
            	    break;

            	default :
            	    break loop131;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 68, xorExpr_StartIndex); }

        }
        return expr;
    }
    // $ANTLR end "xorExpr"



    // $ANTLR start "logOrExpr"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1916:1: logOrExpr returns [Expression expr] : e= logAndExpr (op= '||' f= logAndExpr )* ;
    public final Expression logOrExpr() throws RecognitionException {
        Expression expr = null;

        int logOrExpr_StartIndex = input.index();

        Token op=null;
        Expression e =null;

        Expression f =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 69) ) { return expr; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1917:3: (e= logAndExpr (op= '||' f= logAndExpr )* )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1917:6: e= logAndExpr (op= '||' f= logAndExpr )*
            {
            pushFollow(FOLLOW_logAndExpr_in_logOrExpr7483);
            e=logAndExpr();

            state._fsp--;
            if (state.failed) return expr;

            if ( state.backtracking==0 ) { expr = e; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1918:5: (op= '||' f= logAndExpr )*
            loop132:
            do {
                int alt132=2;
                switch ( input.LA(1) ) {
                case 102:
                    {
                    int LA132_21 = input.LA(2);

                    if ( (synpred243_ObjCpp()) ) {
                        alt132=1;
                    }


                    }
                    break;

                }

                switch (alt132) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1919:7: op= '||' f= logAndExpr
            	    {
            	    op=(Token)match(input,102,FOLLOW_102_in_logOrExpr7501); if (state.failed) return expr;

            	    pushFollow(FOLLOW_logAndExpr_in_logOrExpr7511);
            	    f=logAndExpr();

            	    state._fsp--;
            	    if (state.failed) return expr;

            	    if ( state.backtracking==0 ) { expr = new BinaryOp(expr, getBinaryOperator((op!=null?op.getText():null)), f); }

            	    }
            	    break;

            	default :
            	    break loop132;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 69, logOrExpr_StartIndex); }

        }
        return expr;
    }
    // $ANTLR end "logOrExpr"



    // $ANTLR start "logAndExpr"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1924:1: logAndExpr returns [Expression expr] : e= bitOrExpr (op= '&&' f= bitOrExpr )* ;
    public final Expression logAndExpr() throws RecognitionException {
        Expression expr = null;

        int logAndExpr_StartIndex = input.index();

        Token op=null;
        Expression e =null;

        Expression f =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 70) ) { return expr; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1925:3: (e= bitOrExpr (op= '&&' f= bitOrExpr )* )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1925:6: e= bitOrExpr (op= '&&' f= bitOrExpr )*
            {
            pushFollow(FOLLOW_bitOrExpr_in_logAndExpr7540);
            e=bitOrExpr();

            state._fsp--;
            if (state.failed) return expr;

            if ( state.backtracking==0 ) { expr = e; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1926:5: (op= '&&' f= bitOrExpr )*
            loop133:
            do {
                int alt133=2;
                switch ( input.LA(1) ) {
                case 35:
                    {
                    int LA133_21 = input.LA(2);

                    if ( (synpred244_ObjCpp()) ) {
                        alt133=1;
                    }


                    }
                    break;

                }

                switch (alt133) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1927:7: op= '&&' f= bitOrExpr
            	    {
            	    op=(Token)match(input,35,FOLLOW_35_in_logAndExpr7558); if (state.failed) return expr;

            	    pushFollow(FOLLOW_bitOrExpr_in_logAndExpr7568);
            	    f=bitOrExpr();

            	    state._fsp--;
            	    if (state.failed) return expr;

            	    if ( state.backtracking==0 ) { expr = new BinaryOp(expr, getBinaryOperator((op!=null?op.getText():null)), f); }

            	    }
            	    break;

            	default :
            	    break loop133;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 70, logAndExpr_StartIndex); }

        }
        return expr;
    }
    // $ANTLR end "logAndExpr"



    // $ANTLR start "equalExpr"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1932:1: equalExpr returns [Expression expr] : e= compareExpr (op= ( '!=' | '==' ) f= compareExpr )* ;
    public final Expression equalExpr() throws RecognitionException {
        Expression expr = null;

        int equalExpr_StartIndex = input.index();

        Token op=null;
        Expression e =null;

        Expression f =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 71) ) { return expr; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1933:3: (e= compareExpr (op= ( '!=' | '==' ) f= compareExpr )* )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1933:6: e= compareExpr (op= ( '!=' | '==' ) f= compareExpr )*
            {
            pushFollow(FOLLOW_compareExpr_in_equalExpr7597);
            e=compareExpr();

            state._fsp--;
            if (state.failed) return expr;

            if ( state.backtracking==0 ) { expr = e; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1934:5: (op= ( '!=' | '==' ) f= compareExpr )*
            loop134:
            do {
                int alt134=2;
                switch ( input.LA(1) ) {
                case 31:
                case 58:
                    {
                    int LA134_21 = input.LA(2);

                    if ( (synpred246_ObjCpp()) ) {
                        alt134=1;
                    }


                    }
                    break;

                }

                switch (alt134) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1935:7: op= ( '!=' | '==' ) f= compareExpr
            	    {
            	    op=(Token)input.LT(1);

            	    if ( input.LA(1)==31||input.LA(1)==58 ) {
            	        input.consume();
            	        state.errorRecovery=false;
            	        state.failed=false;
            	    }
            	    else {
            	        if (state.backtracking>0) {state.failed=true; return expr;}
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        throw mse;
            	    }


            	    pushFollow(FOLLOW_compareExpr_in_equalExpr7631);
            	    f=compareExpr();

            	    state._fsp--;
            	    if (state.failed) return expr;

            	    if ( state.backtracking==0 ) { expr = new BinaryOp(expr, getBinaryOperator((op!=null?op.getText():null)), f); }

            	    }
            	    break;

            	default :
            	    break loop134;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 71, equalExpr_StartIndex); }

        }
        return expr;
    }
    // $ANTLR end "equalExpr"



    // $ANTLR start "compareExpr"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1940:1: compareExpr returns [Expression expr] : e= shiftExpr (op= ( '<' | '<=' | '>' | '>=' ) f= shiftExpr )* ;
    public final Expression compareExpr() throws RecognitionException {
        Expression expr = null;

        int compareExpr_StartIndex = input.index();

        Token op=null;
        Expression e =null;

        Expression f =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 72) ) { return expr; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1941:3: (e= shiftExpr (op= ( '<' | '<=' | '>' | '>=' ) f= shiftExpr )* )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1941:6: e= shiftExpr (op= ( '<' | '<=' | '>' | '>=' ) f= shiftExpr )*
            {
            pushFollow(FOLLOW_shiftExpr_in_compareExpr7660);
            e=shiftExpr();

            state._fsp--;
            if (state.failed) return expr;

            if ( state.backtracking==0 ) { expr = e; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1942:5: (op= ( '<' | '<=' | '>' | '>=' ) f= shiftExpr )*
            loop135:
            do {
                int alt135=2;
                alt135 = dfa135.predict(input);
                switch (alt135) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1943:7: op= ( '<' | '<=' | '>' | '>=' ) f= shiftExpr
            	    {
            	    op=(Token)input.LT(1);

            	    if ( input.LA(1)==53||input.LA(1)==56||(input.LA(1) >= 59 && input.LA(1) <= 60) ) {
            	        input.consume();
            	        state.errorRecovery=false;
            	        state.failed=false;
            	    }
            	    else {
            	        if (state.backtracking>0) {state.failed=true; return expr;}
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        throw mse;
            	    }


            	    pushFollow(FOLLOW_shiftExpr_in_compareExpr7703);
            	    f=shiftExpr();

            	    state._fsp--;
            	    if (state.failed) return expr;

            	    if ( state.backtracking==0 ) { expr = new BinaryOp(expr, getBinaryOperator((op!=null?op.getText():null)), f); }

            	    }
            	    break;

            	default :
            	    break loop135;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 72, compareExpr_StartIndex); }

        }
        return expr;
    }
    // $ANTLR end "compareExpr"



    // $ANTLR start "castExpr"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1948:1: castExpr returns [Expression expr] : ( LPAREN tr= mutableTypeRef RPAREN (inner= castExpr | LPAREN expression ( COMMA expression )+ RPAREN ) |e= unaryExpr );
    public final Expression castExpr() throws RecognitionException {
        Expression expr = null;

        int castExpr_StartIndex = input.index();

        TypeRef tr =null;

        Expression inner =null;

        Expression e =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 73) ) { return expr; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1949:3: ( LPAREN tr= mutableTypeRef RPAREN (inner= castExpr | LPAREN expression ( COMMA expression )+ RPAREN ) |e= unaryExpr )
            int alt138=2;
            switch ( input.LA(1) ) {
            case LPAREN:
                {
                switch ( input.LA(2) ) {
                case IDENTIFIER:
                    {
                    int LA138_17 = input.LA(3);

                    if ( (synpred253_ObjCpp()) ) {
                        alt138=1;
                    }
                    else if ( (true) ) {
                        alt138=2;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return expr;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 138, 17, input);

                        throw nvae;

                    }
                    }
                    break;
                case RPAREN:
                case 52:
                case 80:
                case 82:
                case 83:
                case 86:
                case 89:
                case 94:
                case 97:
                case 98:
                    {
                    alt138=1;
                    }
                    break;
                case 38:
                    {
                    int LA138_23 = input.LA(3);

                    if ( (synpred253_ObjCpp()) ) {
                        alt138=1;
                    }
                    else if ( (true) ) {
                        alt138=2;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return expr;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 138, 23, input);

                        throw nvae;

                    }
                    }
                    break;
                case 36:
                    {
                    int LA138_24 = input.LA(3);

                    if ( (synpred253_ObjCpp()) ) {
                        alt138=1;
                    }
                    else if ( (true) ) {
                        alt138=2;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return expr;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 138, 24, input);

                        throw nvae;

                    }
                    }
                    break;
                case 78:
                    {
                    int LA138_26 = input.LA(3);

                    if ( (synpred253_ObjCpp()) ) {
                        alt138=1;
                    }
                    else if ( (true) ) {
                        alt138=2;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return expr;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 138, 26, input);

                        throw nvae;

                    }
                    }
                    break;
                case LPAREN:
                    {
                    int LA138_27 = input.LA(3);

                    if ( (synpred253_ObjCpp()) ) {
                        alt138=1;
                    }
                    else if ( (true) ) {
                        alt138=2;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return expr;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 138, 27, input);

                        throw nvae;

                    }
                    }
                    break;
                case CHARACTER:
                case DECIMAL_NUMBER:
                case FLOAT_NUMBER:
                case HEXADECIMAL_NUMBER:
                case LBRACE:
                case OCTAL_NUMBER:
                case STRING:
                case 30:
                case 40:
                case 41:
                case 43:
                case 44:
                case 66:
                case 74:
                case 77:
                case 103:
                    {
                    alt138=2;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return expr;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 138, 1, input);

                    throw nvae;

                }

                }
                break;
            case CHARACTER:
            case DECIMAL_NUMBER:
            case FLOAT_NUMBER:
            case HEXADECIMAL_NUMBER:
            case IDENTIFIER:
            case LBRACE:
            case OCTAL_NUMBER:
            case STRING:
            case 30:
            case 36:
            case 38:
            case 40:
            case 41:
            case 43:
            case 44:
            case 66:
            case 74:
            case 77:
            case 78:
            case 103:
                {
                alt138=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return expr;}
                NoViableAltException nvae =
                    new NoViableAltException("", 138, 0, input);

                throw nvae;

            }

            switch (alt138) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1949:6: LPAREN tr= mutableTypeRef RPAREN (inner= castExpr | LPAREN expression ( COMMA expression )+ RPAREN )
                    {
                    match(input,LPAREN,FOLLOW_LPAREN_in_castExpr7730); if (state.failed) return expr;

                    pushFollow(FOLLOW_mutableTypeRef_in_castExpr7734);
                    tr=mutableTypeRef();

                    state._fsp--;
                    if (state.failed) return expr;

                    match(input,RPAREN,FOLLOW_RPAREN_in_castExpr7736); if (state.failed) return expr;

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1949:38: (inner= castExpr | LPAREN expression ( COMMA expression )+ RPAREN )
                    int alt137=2;
                    switch ( input.LA(1) ) {
                    case LPAREN:
                        {
                        switch ( input.LA(2) ) {
                        case IDENTIFIER:
                            {
                            int LA137_17 = input.LA(3);

                            if ( (synpred251_ObjCpp()) ) {
                                alt137=1;
                            }
                            else if ( (true) ) {
                                alt137=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 137, 17, input);

                                throw nvae;

                            }
                            }
                            break;
                        case RPAREN:
                        case 52:
                        case 80:
                        case 82:
                        case 83:
                        case 86:
                        case 89:
                        case 94:
                        case 97:
                        case 98:
                            {
                            alt137=1;
                            }
                            break;
                        case 38:
                            {
                            int LA137_23 = input.LA(3);

                            if ( (synpred251_ObjCpp()) ) {
                                alt137=1;
                            }
                            else if ( (true) ) {
                                alt137=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 137, 23, input);

                                throw nvae;

                            }
                            }
                            break;
                        case 36:
                            {
                            int LA137_24 = input.LA(3);

                            if ( (synpred251_ObjCpp()) ) {
                                alt137=1;
                            }
                            else if ( (true) ) {
                                alt137=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 137, 24, input);

                                throw nvae;

                            }
                            }
                            break;
                        case 78:
                            {
                            int LA137_26 = input.LA(3);

                            if ( (synpred251_ObjCpp()) ) {
                                alt137=1;
                            }
                            else if ( (true) ) {
                                alt137=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 137, 26, input);

                                throw nvae;

                            }
                            }
                            break;
                        case LPAREN:
                            {
                            int LA137_27 = input.LA(3);

                            if ( (synpred251_ObjCpp()) ) {
                                alt137=1;
                            }
                            else if ( (true) ) {
                                alt137=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 137, 27, input);

                                throw nvae;

                            }
                            }
                            break;
                        case 43:
                            {
                            int LA137_29 = input.LA(3);

                            if ( (synpred251_ObjCpp()) ) {
                                alt137=1;
                            }
                            else if ( (true) ) {
                                alt137=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 137, 29, input);

                                throw nvae;

                            }
                            }
                            break;
                        case DECIMAL_NUMBER:
                            {
                            int LA137_30 = input.LA(3);

                            if ( (synpred251_ObjCpp()) ) {
                                alt137=1;
                            }
                            else if ( (true) ) {
                                alt137=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 137, 30, input);

                                throw nvae;

                            }
                            }
                            break;
                        case HEXADECIMAL_NUMBER:
                            {
                            int LA137_31 = input.LA(3);

                            if ( (synpred251_ObjCpp()) ) {
                                alt137=1;
                            }
                            else if ( (true) ) {
                                alt137=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 137, 31, input);

                                throw nvae;

                            }
                            }
                            break;
                        case OCTAL_NUMBER:
                            {
                            int LA137_32 = input.LA(3);

                            if ( (synpred251_ObjCpp()) ) {
                                alt137=1;
                            }
                            else if ( (true) ) {
                                alt137=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 137, 32, input);

                                throw nvae;

                            }
                            }
                            break;
                        case CHARACTER:
                            {
                            int LA137_33 = input.LA(3);

                            if ( (synpred251_ObjCpp()) ) {
                                alt137=1;
                            }
                            else if ( (true) ) {
                                alt137=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 137, 33, input);

                                throw nvae;

                            }
                            }
                            break;
                        case FLOAT_NUMBER:
                            {
                            int LA137_34 = input.LA(3);

                            if ( (synpred251_ObjCpp()) ) {
                                alt137=1;
                            }
                            else if ( (true) ) {
                                alt137=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 137, 34, input);

                                throw nvae;

                            }
                            }
                            break;
                        case STRING:
                            {
                            int LA137_35 = input.LA(3);

                            if ( (synpred251_ObjCpp()) ) {
                                alt137=1;
                            }
                            else if ( (true) ) {
                                alt137=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 137, 35, input);

                                throw nvae;

                            }
                            }
                            break;
                        case LBRACE:
                            {
                            int LA137_36 = input.LA(3);

                            if ( (synpred251_ObjCpp()) ) {
                                alt137=1;
                            }
                            else if ( (true) ) {
                                alt137=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 137, 36, input);

                                throw nvae;

                            }
                            }
                            break;
                        case 77:
                            {
                            int LA137_37 = input.LA(3);

                            if ( (synpred251_ObjCpp()) ) {
                                alt137=1;
                            }
                            else if ( (true) ) {
                                alt137=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 137, 37, input);

                                throw nvae;

                            }
                            }
                            break;
                        case 74:
                            {
                            int LA137_38 = input.LA(3);

                            if ( (synpred251_ObjCpp()) ) {
                                alt137=1;
                            }
                            else if ( (true) ) {
                                alt137=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 137, 38, input);

                                throw nvae;

                            }
                            }
                            break;
                        case 66:
                            {
                            int LA137_39 = input.LA(3);

                            if ( (synpred251_ObjCpp()) ) {
                                alt137=1;
                            }
                            else if ( (true) ) {
                                alt137=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 137, 39, input);

                                throw nvae;

                            }
                            }
                            break;
                        case 40:
                            {
                            int LA137_40 = input.LA(3);

                            if ( (synpred251_ObjCpp()) ) {
                                alt137=1;
                            }
                            else if ( (true) ) {
                                alt137=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 137, 40, input);

                                throw nvae;

                            }
                            }
                            break;
                        case 30:
                        case 41:
                        case 44:
                        case 103:
                            {
                            int LA137_41 = input.LA(3);

                            if ( (synpred251_ObjCpp()) ) {
                                alt137=1;
                            }
                            else if ( (true) ) {
                                alt137=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 137, 41, input);

                                throw nvae;

                            }
                            }
                            break;
                        default:
                            if (state.backtracking>0) {state.failed=true; return expr;}
                            NoViableAltException nvae =
                                new NoViableAltException("", 137, 1, input);

                            throw nvae;

                        }

                        }
                        break;
                    case CHARACTER:
                    case DECIMAL_NUMBER:
                    case FLOAT_NUMBER:
                    case HEXADECIMAL_NUMBER:
                    case IDENTIFIER:
                    case LBRACE:
                    case OCTAL_NUMBER:
                    case STRING:
                    case 30:
                    case 36:
                    case 38:
                    case 40:
                    case 41:
                    case 43:
                    case 44:
                    case 66:
                    case 74:
                    case 77:
                    case 78:
                    case 103:
                        {
                        alt137=1;
                        }
                        break;
                    default:
                        if (state.backtracking>0) {state.failed=true; return expr;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 137, 0, input);

                        throw nvae;

                    }

                    switch (alt137) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1950:7: inner= castExpr
                            {
                            pushFollow(FOLLOW_castExpr_in_castExpr7748);
                            inner=castExpr();

                            state._fsp--;
                            if (state.failed) return expr;

                            if ( state.backtracking==0 ) { expr = new Cast(tr, inner); }

                            }
                            break;
                        case 2 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1951:7: LPAREN expression ( COMMA expression )+ RPAREN
                            {
                            match(input,LPAREN,FOLLOW_LPAREN_in_castExpr7760); if (state.failed) return expr;

                            pushFollow(FOLLOW_expression_in_castExpr7762);
                            expression();

                            state._fsp--;
                            if (state.failed) return expr;

                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1951:25: ( COMMA expression )+
                            int cnt136=0;
                            loop136:
                            do {
                                int alt136=2;
                                switch ( input.LA(1) ) {
                                case COMMA:
                                    {
                                    alt136=1;
                                    }
                                    break;

                                }

                                switch (alt136) {
                            	case 1 :
                            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1951:27: COMMA expression
                            	    {
                            	    match(input,COMMA,FOLLOW_COMMA_in_castExpr7766); if (state.failed) return expr;

                            	    pushFollow(FOLLOW_expression_in_castExpr7768);
                            	    expression();

                            	    state._fsp--;
                            	    if (state.failed) return expr;

                            	    }
                            	    break;

                            	default :
                            	    if ( cnt136 >= 1 ) break loop136;
                            	    if (state.backtracking>0) {state.failed=true; return expr;}
                                        EarlyExitException eee =
                                            new EarlyExitException(136, input);
                                        throw eee;
                                }
                                cnt136++;
                            } while (true);


                            match(input,RPAREN,FOLLOW_RPAREN_in_castExpr7774); if (state.failed) return expr;

                            }
                            break;

                    }


                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1953:5: e= unaryExpr
                    {
                    pushFollow(FOLLOW_unaryExpr_in_castExpr7792);
                    e=unaryExpr();

                    state._fsp--;
                    if (state.failed) return expr;

                    if ( state.backtracking==0 ) { expr = e; }

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 73, castExpr_StartIndex); }

        }
        return expr;
    }
    // $ANTLR end "castExpr"



    // $ANTLR start "unaryExpr"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1956:1: unaryExpr returns [Expression expr] : ({...}? IDENTIFIER ( LPAREN tr= mutableTypeRef RPAREN ) |p= postfixExpr |uo= unaryOp castExpr );
    public final Expression unaryExpr() throws RecognitionException {
        Expression expr = null;

        int unaryExpr_StartIndex = input.index();

        TypeRef tr =null;

        Expression p =null;

        Expression.UnaryOperator uo =null;

        Expression castExpr45 =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 74) ) { return expr; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1957:3: ({...}? IDENTIFIER ( LPAREN tr= mutableTypeRef RPAREN ) |p= postfixExpr |uo= unaryOp castExpr )
            int alt139=3;
            alt139 = dfa139.predict(input);
            switch (alt139) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1958:5: {...}? IDENTIFIER ( LPAREN tr= mutableTypeRef RPAREN )
                    {
                    if ( !(( next("sizeof") )) ) {
                        if (state.backtracking>0) {state.failed=true; return expr;}
                        throw new FailedPredicateException(input, "unaryExpr", " next(\"sizeof\") ");
                    }

                    match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_unaryExpr7818); if (state.failed) return expr;

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1958:36: ( LPAREN tr= mutableTypeRef RPAREN )
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1959:7: LPAREN tr= mutableTypeRef RPAREN
                    {
                    match(input,LPAREN,FOLLOW_LPAREN_in_unaryExpr7828); if (state.failed) return expr;

                    pushFollow(FOLLOW_mutableTypeRef_in_unaryExpr7832);
                    tr=mutableTypeRef();

                    state._fsp--;
                    if (state.failed) return expr;

                    match(input,RPAREN,FOLLOW_RPAREN_in_unaryExpr7834); if (state.failed) return expr;

                    if ( state.backtracking==0 ) {
                            expr = new FunctionCall(varRef("sizeof"), new TypeRefExpression(tr));
                          }

                    }


                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1964:5: p= postfixExpr
                    {
                    pushFollow(FOLLOW_postfixExpr_in_unaryExpr7859);
                    p=postfixExpr();

                    state._fsp--;
                    if (state.failed) return expr;

                    if ( state.backtracking==0 ) { expr = p; }

                    }
                    break;
                case 3 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1965:5: uo= unaryOp castExpr
                    {
                    pushFollow(FOLLOW_unaryOp_in_unaryExpr7871);
                    uo=unaryOp();

                    state._fsp--;
                    if (state.failed) return expr;

                    pushFollow(FOLLOW_castExpr_in_unaryExpr7873);
                    castExpr45=castExpr();

                    state._fsp--;
                    if (state.failed) return expr;

                    if ( state.backtracking==0 ) { expr = new UnaryOp(castExpr45, uo); }

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 74, unaryExpr_StartIndex); }

        }
        return expr;
    }
    // $ANTLR end "unaryExpr"



    // $ANTLR start "unaryOp"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1968:1: unaryOp returns [Expression.UnaryOperator op] : t= ( '++' | '--' | '&' | '*' | '-' | '~' | '!' ) ;
    public final Expression.UnaryOperator unaryOp() throws RecognitionException {
        Expression.UnaryOperator op = null;

        int unaryOp_StartIndex = input.index();

        Token t=null;

        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 75) ) { return op; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1969:3: (t= ( '++' | '--' | '&' | '*' | '-' | '~' | '!' ) )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1969:7: t= ( '++' | '--' | '&' | '*' | '-' | '~' | '!' )
            {
            t=(Token)input.LT(1);

            if ( input.LA(1)==30||input.LA(1)==36||input.LA(1)==38||input.LA(1)==41||(input.LA(1) >= 43 && input.LA(1) <= 44)||input.LA(1)==103 ) {
                input.consume();
                state.errorRecovery=false;
                state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return op;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


            if ( state.backtracking==0 ) {
                  op = Expression.getUnaryOperator((t!=null?t.getText():null));
                }

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 75, unaryOp_StartIndex); }

        }
        return op;
    }
    // $ANTLR end "unaryOp"



    // $ANTLR start "postfixExpr"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1974:1: postfixExpr returns [Expression expr] : ({...}? IDENTIFIER tr= nonMutableTypeRef ( ( ( topLevelExprList )? ) | ( ( '[' dim= expression ']' )+ ) ) | baseExpression ( '[' expression ']' | LPAREN ( topLevelExprList )? RPAREN | '::' ao= simpleIdentifier | '.' di= simpleIdentifier | '->' ai= simpleIdentifier | postfixOp )* );
    public final Expression postfixExpr() throws RecognitionException {
        Expression expr = null;

        int postfixExpr_StartIndex = input.index();

        TypeRef tr =null;

        Expression dim =null;

        SimpleIdentifier ao =null;

        SimpleIdentifier di =null;

        SimpleIdentifier ai =null;

        List<Expression> topLevelExprList46 =null;

        Expression baseExpression47 =null;

        Expression expression48 =null;

        List<Expression> topLevelExprList49 =null;

        Expression.UnaryOperator postfixOp50 =null;



          List<Expression> multiArrayDims = new ArrayList<Expression>();

        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 76) ) { return expr; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1978:3: ({...}? IDENTIFIER tr= nonMutableTypeRef ( ( ( topLevelExprList )? ) | ( ( '[' dim= expression ']' )+ ) ) | baseExpression ( '[' expression ']' | LPAREN ( topLevelExprList )? RPAREN | '::' ao= simpleIdentifier | '.' di= simpleIdentifier | '->' ai= simpleIdentifier | postfixOp )* )
            int alt145=2;
            alt145 = dfa145.predict(input);
            switch (alt145) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1979:5: {...}? IDENTIFIER tr= nonMutableTypeRef ( ( ( topLevelExprList )? ) | ( ( '[' dim= expression ']' )+ ) )
                    {
                    if ( !(( next("new") )) ) {
                        if (state.backtracking>0) {state.failed=true; return expr;}
                        throw new FailedPredicateException(input, "postfixExpr", " next(\"new\") ");
                    }

                    match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_postfixExpr7954); if (state.failed) return expr;

                    pushFollow(FOLLOW_nonMutableTypeRef_in_postfixExpr7958);
                    tr=nonMutableTypeRef();

                    state._fsp--;
                    if (state.failed) return expr;

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1980:5: ( ( ( topLevelExprList )? ) | ( ( '[' dim= expression ']' )+ ) )
                    int alt142=2;
                    switch ( input.LA(1) ) {
                    case EOF:
                    case CHARACTER:
                    case COMMA:
                    case DECIMAL_NUMBER:
                    case FLOAT_NUMBER:
                    case HEXADECIMAL_NUMBER:
                    case IDENTIFIER:
                    case LBRACE:
                    case LPAREN:
                    case OCTAL_NUMBER:
                    case RBRACE:
                    case RPAREN:
                    case SEMICOLON:
                    case STRING:
                    case 30:
                    case 31:
                    case 33:
                    case 34:
                    case 35:
                    case 36:
                    case 37:
                    case 38:
                    case 39:
                    case 40:
                    case 41:
                    case 42:
                    case 43:
                    case 44:
                    case 45:
                    case 49:
                    case 50:
                    case 51:
                    case 53:
                    case 54:
                    case 55:
                    case 56:
                    case 57:
                    case 58:
                    case 59:
                    case 60:
                    case 61:
                    case 62:
                    case 64:
                    case 66:
                    case 74:
                    case 77:
                    case 79:
                    case 80:
                    case 81:
                    case 100:
                    case 101:
                    case 102:
                    case 103:
                    case 104:
                        {
                        alt142=1;
                        }
                        break;
                    case 78:
                        {
                        switch ( input.LA(2) ) {
                        case LPAREN:
                            {
                            int LA142_38 = input.LA(3);

                            if ( (synpred263_ObjCpp()) ) {
                                alt142=1;
                            }
                            else if ( (true) ) {
                                alt142=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 142, 38, input);

                                throw nvae;

                            }
                            }
                            break;
                        case IDENTIFIER:
                            {
                            int LA142_39 = input.LA(3);

                            if ( (synpred263_ObjCpp()) ) {
                                alt142=1;
                            }
                            else if ( (true) ) {
                                alt142=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 142, 39, input);

                                throw nvae;

                            }
                            }
                            break;
                        case 43:
                            {
                            int LA142_40 = input.LA(3);

                            if ( (synpred263_ObjCpp()) ) {
                                alt142=1;
                            }
                            else if ( (true) ) {
                                alt142=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 142, 40, input);

                                throw nvae;

                            }
                            }
                            break;
                        case DECIMAL_NUMBER:
                            {
                            int LA142_41 = input.LA(3);

                            if ( (synpred263_ObjCpp()) ) {
                                alt142=1;
                            }
                            else if ( (true) ) {
                                alt142=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 142, 41, input);

                                throw nvae;

                            }
                            }
                            break;
                        case HEXADECIMAL_NUMBER:
                            {
                            int LA142_42 = input.LA(3);

                            if ( (synpred263_ObjCpp()) ) {
                                alt142=1;
                            }
                            else if ( (true) ) {
                                alt142=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 142, 42, input);

                                throw nvae;

                            }
                            }
                            break;
                        case OCTAL_NUMBER:
                            {
                            int LA142_43 = input.LA(3);

                            if ( (synpred263_ObjCpp()) ) {
                                alt142=1;
                            }
                            else if ( (true) ) {
                                alt142=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 142, 43, input);

                                throw nvae;

                            }
                            }
                            break;
                        case CHARACTER:
                            {
                            int LA142_44 = input.LA(3);

                            if ( (synpred263_ObjCpp()) ) {
                                alt142=1;
                            }
                            else if ( (true) ) {
                                alt142=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 142, 44, input);

                                throw nvae;

                            }
                            }
                            break;
                        case FLOAT_NUMBER:
                            {
                            int LA142_45 = input.LA(3);

                            if ( (synpred263_ObjCpp()) ) {
                                alt142=1;
                            }
                            else if ( (true) ) {
                                alt142=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 142, 45, input);

                                throw nvae;

                            }
                            }
                            break;
                        case STRING:
                            {
                            int LA142_46 = input.LA(3);

                            if ( (synpred263_ObjCpp()) ) {
                                alt142=1;
                            }
                            else if ( (true) ) {
                                alt142=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 142, 46, input);

                                throw nvae;

                            }
                            }
                            break;
                        case 78:
                            {
                            int LA142_47 = input.LA(3);

                            if ( (synpred263_ObjCpp()) ) {
                                alt142=1;
                            }
                            else if ( (true) ) {
                                alt142=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 142, 47, input);

                                throw nvae;

                            }
                            }
                            break;
                        case LBRACE:
                            {
                            int LA142_48 = input.LA(3);

                            if ( (synpred263_ObjCpp()) ) {
                                alt142=1;
                            }
                            else if ( (true) ) {
                                alt142=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 142, 48, input);

                                throw nvae;

                            }
                            }
                            break;
                        case 77:
                            {
                            int LA142_49 = input.LA(3);

                            if ( (synpred263_ObjCpp()) ) {
                                alt142=1;
                            }
                            else if ( (true) ) {
                                alt142=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 142, 49, input);

                                throw nvae;

                            }
                            }
                            break;
                        case 74:
                            {
                            int LA142_50 = input.LA(3);

                            if ( (synpred263_ObjCpp()) ) {
                                alt142=1;
                            }
                            else if ( (true) ) {
                                alt142=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 142, 50, input);

                                throw nvae;

                            }
                            }
                            break;
                        case 66:
                            {
                            int LA142_51 = input.LA(3);

                            if ( (synpred263_ObjCpp()) ) {
                                alt142=1;
                            }
                            else if ( (true) ) {
                                alt142=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 142, 51, input);

                                throw nvae;

                            }
                            }
                            break;
                        case 40:
                            {
                            int LA142_52 = input.LA(3);

                            if ( (synpred263_ObjCpp()) ) {
                                alt142=1;
                            }
                            else if ( (true) ) {
                                alt142=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 142, 52, input);

                                throw nvae;

                            }
                            }
                            break;
                        case 30:
                        case 36:
                        case 38:
                        case 41:
                        case 44:
                        case 103:
                            {
                            int LA142_53 = input.LA(3);

                            if ( (synpred263_ObjCpp()) ) {
                                alt142=1;
                            }
                            else if ( (true) ) {
                                alt142=2;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return expr;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 142, 53, input);

                                throw nvae;

                            }
                            }
                            break;
                        default:
                            if (state.backtracking>0) {state.failed=true; return expr;}
                            NoViableAltException nvae =
                                new NoViableAltException("", 142, 10, input);

                            throw nvae;

                        }

                        }
                        break;
                    default:
                        if (state.backtracking>0) {state.failed=true; return expr;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 142, 0, input);

                        throw nvae;

                    }

                    switch (alt142) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1981:7: ( ( topLevelExprList )? )
                            {
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1981:7: ( ( topLevelExprList )? )
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1982:9: ( topLevelExprList )?
                            {
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1982:9: ( topLevelExprList )?
                            int alt140=2;
                            alt140 = dfa140.predict(input);
                            switch (alt140) {
                                case 1 :
                                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1982:9: topLevelExprList
                                    {
                                    pushFollow(FOLLOW_topLevelExprList_in_postfixExpr7982);
                                    topLevelExprList46=topLevelExprList();

                                    state._fsp--;
                                    if (state.failed) return expr;

                                    }
                                    break;

                            }


                            if ( state.backtracking==0 ) {
                                      if (topLevelExprList46 == null)
                                        expr = new New(tr);
                                      else
                                        expr = new New(tr, topLevelExprList46);
                                    }

                            }


                            }
                            break;
                        case 2 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1989:7: ( ( '[' dim= expression ']' )+ )
                            {
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1989:7: ( ( '[' dim= expression ']' )+ )
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1990:9: ( '[' dim= expression ']' )+
                            {
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1990:9: ( '[' dim= expression ']' )+
                            int cnt141=0;
                            loop141:
                            do {
                                int alt141=2;
                                switch ( input.LA(1) ) {
                                case 78:
                                    {
                                    switch ( input.LA(2) ) {
                                    case LPAREN:
                                        {
                                        int LA141_38 = input.LA(3);

                                        if ( (synpred264_ObjCpp()) ) {
                                            alt141=1;
                                        }


                                        }
                                        break;
                                    case IDENTIFIER:
                                        {
                                        int LA141_39 = input.LA(3);

                                        if ( (synpred264_ObjCpp()) ) {
                                            alt141=1;
                                        }


                                        }
                                        break;
                                    case 43:
                                        {
                                        int LA141_40 = input.LA(3);

                                        if ( (synpred264_ObjCpp()) ) {
                                            alt141=1;
                                        }


                                        }
                                        break;
                                    case DECIMAL_NUMBER:
                                        {
                                        int LA141_41 = input.LA(3);

                                        if ( (synpred264_ObjCpp()) ) {
                                            alt141=1;
                                        }


                                        }
                                        break;
                                    case HEXADECIMAL_NUMBER:
                                        {
                                        int LA141_42 = input.LA(3);

                                        if ( (synpred264_ObjCpp()) ) {
                                            alt141=1;
                                        }


                                        }
                                        break;
                                    case OCTAL_NUMBER:
                                        {
                                        int LA141_43 = input.LA(3);

                                        if ( (synpred264_ObjCpp()) ) {
                                            alt141=1;
                                        }


                                        }
                                        break;
                                    case CHARACTER:
                                        {
                                        int LA141_44 = input.LA(3);

                                        if ( (synpred264_ObjCpp()) ) {
                                            alt141=1;
                                        }


                                        }
                                        break;
                                    case FLOAT_NUMBER:
                                        {
                                        int LA141_45 = input.LA(3);

                                        if ( (synpred264_ObjCpp()) ) {
                                            alt141=1;
                                        }


                                        }
                                        break;
                                    case STRING:
                                        {
                                        int LA141_46 = input.LA(3);

                                        if ( (synpred264_ObjCpp()) ) {
                                            alt141=1;
                                        }


                                        }
                                        break;
                                    case 78:
                                        {
                                        int LA141_47 = input.LA(3);

                                        if ( (synpred264_ObjCpp()) ) {
                                            alt141=1;
                                        }


                                        }
                                        break;
                                    case LBRACE:
                                        {
                                        int LA141_48 = input.LA(3);

                                        if ( (synpred264_ObjCpp()) ) {
                                            alt141=1;
                                        }


                                        }
                                        break;
                                    case 77:
                                        {
                                        int LA141_49 = input.LA(3);

                                        if ( (synpred264_ObjCpp()) ) {
                                            alt141=1;
                                        }


                                        }
                                        break;
                                    case 74:
                                        {
                                        int LA141_50 = input.LA(3);

                                        if ( (synpred264_ObjCpp()) ) {
                                            alt141=1;
                                        }


                                        }
                                        break;
                                    case 66:
                                        {
                                        int LA141_51 = input.LA(3);

                                        if ( (synpred264_ObjCpp()) ) {
                                            alt141=1;
                                        }


                                        }
                                        break;
                                    case 40:
                                        {
                                        int LA141_52 = input.LA(3);

                                        if ( (synpred264_ObjCpp()) ) {
                                            alt141=1;
                                        }


                                        }
                                        break;
                                    case 30:
                                    case 36:
                                    case 38:
                                    case 41:
                                    case 44:
                                    case 103:
                                        {
                                        int LA141_53 = input.LA(3);

                                        if ( (synpred264_ObjCpp()) ) {
                                            alt141=1;
                                        }


                                        }
                                        break;

                                    }

                                    }
                                    break;

                                }

                                switch (alt141) {
                            	case 1 :
                            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1991:11: '[' dim= expression ']'
                            	    {
                            	    match(input,78,FOLLOW_78_in_postfixExpr8026); if (state.failed) return expr;

                            	    pushFollow(FOLLOW_expression_in_postfixExpr8030);
                            	    dim=expression();

                            	    state._fsp--;
                            	    if (state.failed) return expr;

                            	    match(input,79,FOLLOW_79_in_postfixExpr8032); if (state.failed) return expr;

                            	    if ( state.backtracking==0 ) {
                            	                multiArrayDims.add(dim);
                            	              }

                            	    }
                            	    break;

                            	default :
                            	    if ( cnt141 >= 1 ) break loop141;
                            	    if (state.backtracking>0) {state.failed=true; return expr;}
                                        EarlyExitException eee =
                                            new EarlyExitException(141, input);
                                        throw eee;
                                }
                                cnt141++;
                            } while (true);


                            if ( state.backtracking==0 ) {
                                      NewArray na = new NewArray();
                                      na.setType(tr);
                                      na.setDimensions(multiArrayDims);
                                      expr = na;
                                    }

                            }


                            }
                            break;

                    }


                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2003:5: baseExpression ( '[' expression ']' | LPAREN ( topLevelExprList )? RPAREN | '::' ao= simpleIdentifier | '.' di= simpleIdentifier | '->' ai= simpleIdentifier | postfixOp )*
                    {
                    pushFollow(FOLLOW_baseExpression_in_postfixExpr8077);
                    baseExpression47=baseExpression();

                    state._fsp--;
                    if (state.failed) return expr;

                    if ( state.backtracking==0 ) { expr = baseExpression47; }

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2004:5: ( '[' expression ']' | LPAREN ( topLevelExprList )? RPAREN | '::' ao= simpleIdentifier | '.' di= simpleIdentifier | '->' ai= simpleIdentifier | postfixOp )*
                    loop144:
                    do {
                        int alt144=7;
                        alt144 = dfa144.predict(input);
                        switch (alt144) {
                    	case 1 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2005:7: '[' expression ']'
                    	    {
                    	    match(input,78,FOLLOW_78_in_postfixExpr8093); if (state.failed) return expr;

                    	    pushFollow(FOLLOW_expression_in_postfixExpr8095);
                    	    expression48=expression();

                    	    state._fsp--;
                    	    if (state.failed) return expr;

                    	    match(input,79,FOLLOW_79_in_postfixExpr8097); if (state.failed) return expr;

                    	    if ( state.backtracking==0 ) { 
                    	            expr = new ArrayAccess(expr, expression48); 
                    	          }

                    	    }
                    	    break;
                    	case 2 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2008:7: LPAREN ( topLevelExprList )? RPAREN
                    	    {
                    	    match(input,LPAREN,FOLLOW_LPAREN_in_postfixExpr8109); if (state.failed) return expr;

                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2008:14: ( topLevelExprList )?
                    	    int alt143=2;
                    	    switch ( input.LA(1) ) {
                    	        case CHARACTER:
                    	        case DECIMAL_NUMBER:
                    	        case FLOAT_NUMBER:
                    	        case HEXADECIMAL_NUMBER:
                    	        case IDENTIFIER:
                    	        case LBRACE:
                    	        case LPAREN:
                    	        case OCTAL_NUMBER:
                    	        case STRING:
                    	        case 30:
                    	        case 36:
                    	        case 38:
                    	        case 40:
                    	        case 41:
                    	        case 43:
                    	        case 44:
                    	        case 66:
                    	        case 74:
                    	        case 77:
                    	        case 78:
                    	        case 103:
                    	            {
                    	            alt143=1;
                    	            }
                    	            break;
                    	    }

                    	    switch (alt143) {
                    	        case 1 :
                    	            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2008:14: topLevelExprList
                    	            {
                    	            pushFollow(FOLLOW_topLevelExprList_in_postfixExpr8111);
                    	            topLevelExprList49=topLevelExprList();

                    	            state._fsp--;
                    	            if (state.failed) return expr;

                    	            }
                    	            break;

                    	    }


                    	    match(input,RPAREN,FOLLOW_RPAREN_in_postfixExpr8114); if (state.failed) return expr;

                    	    if ( state.backtracking==0 ) {
                    	            FunctionCall fc = new FunctionCall(expr);
                    	            if (topLevelExprList49 != null)
                    	              for (Expression x : topLevelExprList49)
                    	                fc.addArgument(x);
                    	            expr = fc;
                    	          }

                    	    }
                    	    break;
                    	case 3 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2015:7: '::' ao= simpleIdentifier
                    	    {
                    	    match(input,52,FOLLOW_52_in_postfixExpr8126); if (state.failed) return expr;

                    	    pushFollow(FOLLOW_simpleIdentifier_in_postfixExpr8130);
                    	    ao=simpleIdentifier();

                    	    state._fsp--;
                    	    if (state.failed) return expr;

                    	    if ( state.backtracking==0 ) {
                    	            expr = new MemberRef(expr, MemberRefStyle.Colons, ao); 
                    	          }

                    	    }
                    	    break;
                    	case 4 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2018:7: '.' di= simpleIdentifier
                    	    {
                    	    match(input,47,FOLLOW_47_in_postfixExpr8142); if (state.failed) return expr;

                    	    pushFollow(FOLLOW_simpleIdentifier_in_postfixExpr8146);
                    	    di=simpleIdentifier();

                    	    state._fsp--;
                    	    if (state.failed) return expr;

                    	    if ( state.backtracking==0 ) { 
                    	            expr = new MemberRef(expr, MemberRefStyle.Dot, di); 
                    	          }

                    	    }
                    	    break;
                    	case 5 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2021:7: '->' ai= simpleIdentifier
                    	    {
                    	    match(input,46,FOLLOW_46_in_postfixExpr8158); if (state.failed) return expr;

                    	    pushFollow(FOLLOW_simpleIdentifier_in_postfixExpr8162);
                    	    ai=simpleIdentifier();

                    	    state._fsp--;
                    	    if (state.failed) return expr;

                    	    if ( state.backtracking==0 ) { 
                    	            expr = new MemberRef(expr, MemberRefStyle.Arrow, ai); 
                    	          }

                    	    }
                    	    break;
                    	case 6 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2024:7: postfixOp
                    	    {
                    	    pushFollow(FOLLOW_postfixOp_in_postfixExpr8174);
                    	    postfixOp50=postfixOp();

                    	    state._fsp--;
                    	    if (state.failed) return expr;

                    	    if ( state.backtracking==0 ) { 
                    	            expr = new UnaryOp(expr, postfixOp50); 
                    	          }

                    	    }
                    	    break;

                    	default :
                    	    break loop144;
                        }
                    } while (true);


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 76, postfixExpr_StartIndex); }

        }
        return expr;
    }
    // $ANTLR end "postfixExpr"


    public static class topLevelExpr_return extends ParserRuleReturnScope {
        public Expression expr;
    };


    // $ANTLR start "topLevelExpr"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2030:1: topLevelExpr returns [Expression expr] : e= assignmentExpr ;
    public final ObjCppParser.topLevelExpr_return topLevelExpr() throws RecognitionException {
        ObjCppParser.topLevelExpr_return retval = new ObjCppParser.topLevelExpr_return();
        retval.start = input.LT(1);

        int topLevelExpr_StartIndex = input.index();

        Expression e =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 77) ) { return retval; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2031:3: (e= assignmentExpr )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2031:6: e= assignmentExpr
            {
            pushFollow(FOLLOW_assignmentExpr_in_topLevelExpr8203);
            e=assignmentExpr();

            state._fsp--;
            if (state.failed) return retval;

            if ( state.backtracking==0 ) { retval.expr = e; }

            }

            retval.stop = input.LT(-1);


        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 77, topLevelExpr_StartIndex); }

        }
        return retval;
    }
    // $ANTLR end "topLevelExpr"



    // $ANTLR start "topLevelExprList"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2033:1: topLevelExprList returns [List<Expression> exprs] :e= topLevelExpr ( COMMA f= topLevelExpr )* ;
    public final List<Expression> topLevelExprList() throws RecognitionException {
        List<Expression> exprs = null;

        int topLevelExprList_StartIndex = input.index();

        ObjCppParser.topLevelExpr_return e =null;

        ObjCppParser.topLevelExpr_return f =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 78) ) { return exprs; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2034:3: (e= topLevelExpr ( COMMA f= topLevelExpr )* )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2035:5: e= topLevelExpr ( COMMA f= topLevelExpr )*
            {
            if ( state.backtracking==0 ) { exprs = new ArrayList<Expression>(); }

            pushFollow(FOLLOW_topLevelExpr_in_topLevelExprList8235);
            e=topLevelExpr();

            state._fsp--;
            if (state.failed) return exprs;

            if ( state.backtracking==0 ) { exprs.add((e!=null?e.expr:null)); }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2037:5: ( COMMA f= topLevelExpr )*
            loop146:
            do {
                int alt146=2;
                alt146 = dfa146.predict(input);
                switch (alt146) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2038:7: COMMA f= topLevelExpr
            	    {
            	    match(input,COMMA,FOLLOW_COMMA_in_topLevelExprList8251); if (state.failed) return exprs;

            	    pushFollow(FOLLOW_topLevelExpr_in_topLevelExprList8261);
            	    f=topLevelExpr();

            	    state._fsp--;
            	    if (state.failed) return exprs;

            	    if ( state.backtracking==0 ) { exprs.add((f!=null?f.expr:null)); }

            	    }
            	    break;

            	default :
            	    break loop146;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 78, topLevelExprList_StartIndex); }

        }
        return exprs;
    }
    // $ANTLR end "topLevelExprList"



    // $ANTLR start "expression"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2043:1: expression returns [Expression expr] : l= topLevelExprList ;
    public final Expression expression() throws RecognitionException {
        Expression expr = null;

        int expression_StartIndex = input.index();

        List<Expression> l =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 79) ) { return expr; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2047:3: (l= topLevelExprList )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2047:6: l= topLevelExprList
            {
            pushFollow(FOLLOW_topLevelExprList_in_expression8295);
            l=topLevelExprList();

            state._fsp--;
            if (state.failed) return expr;

            if ( state.backtracking==0 ) {
                  if (l != null) {
                    if (l.size() == 1)
                      expr = l.get(0);
                    else
                      expr = new ExpressionSequence(l);
                  }
                }

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 79, expression_StartIndex); }

        }
        return expr;
    }
    // $ANTLR end "expression"



    // $ANTLR start "statementsBlock"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2058:1: statementsBlock returns [Block statement] : LBRACE ( statement | lineDirective )* RBRACE ;
    public final Block statementsBlock() throws RecognitionException {
        Symbols_stack.push(new Symbols_scope());

        Block statement = null;

        int statementsBlock_StartIndex = input.index();

        Statement statement51 =null;



          ((Symbols_scope)Symbols_stack.peek()).typeIdentifiers = new HashSet<String>();

        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 80) ) { return statement; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2063:3: ( LBRACE ( statement | lineDirective )* RBRACE )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2063:6: LBRACE ( statement | lineDirective )* RBRACE
            {
            if ( state.backtracking==0 ) { statement = new Block(); }

            match(input,LBRACE,FOLLOW_LBRACE_in_statementsBlock8335); if (state.failed) return statement;

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2065:5: ( statement | lineDirective )*
            loop147:
            do {
                int alt147=3;
                switch ( input.LA(1) ) {
                case CHARACTER:
                case DECIMAL_NUMBER:
                case FLOAT_NUMBER:
                case HEXADECIMAL_NUMBER:
                case IDENTIFIER:
                case LBRACE:
                case LPAREN:
                case OCTAL_NUMBER:
                case SEMICOLON:
                case STRING:
                case 30:
                case 36:
                case 38:
                case 40:
                case 41:
                case 43:
                case 44:
                case 51:
                case 52:
                case 65:
                case 66:
                case 68:
                case 74:
                case 77:
                case 78:
                case 80:
                case 82:
                case 83:
                case 84:
                case 86:
                case 87:
                case 89:
                case 90:
                case 91:
                case 92:
                case 93:
                case 94:
                case 95:
                case 96:
                case 97:
                case 98:
                case 99:
                case 103:
                    {
                    alt147=1;
                    }
                    break;
                case 32:
                    {
                    alt147=2;
                    }
                    break;

                }

                switch (alt147) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2066:7: statement
            	    {
            	    pushFollow(FOLLOW_statement_in_statementsBlock8349);
            	    statement51=statement();

            	    state._fsp--;
            	    if (state.failed) return statement;

            	    if ( state.backtracking==0 ) {
            	            statement.addStatement(statement51);
            	          }

            	    }
            	    break;
            	case 2 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2069:7: lineDirective
            	    {
            	    pushFollow(FOLLOW_lineDirective_in_statementsBlock8361);
            	    lineDirective();

            	    state._fsp--;
            	    if (state.failed) return statement;

            	    }
            	    break;

            	default :
            	    break loop147;
                }
            } while (true);


            match(input,RBRACE,FOLLOW_RBRACE_in_statementsBlock8375); if (state.failed) return statement;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 80, statementsBlock_StartIndex); }

            Symbols_stack.pop();

        }
        return statement;
    }
    // $ANTLR end "statementsBlock"



    // $ANTLR start "gccAsmInOut"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2074:1: gccAsmInOut : STRING LPAREN IDENTIFIER RPAREN ;
    public final void gccAsmInOut() throws RecognitionException {
        int gccAsmInOut_StartIndex = input.index();

        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 81) ) { return ; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2075:3: ( STRING LPAREN IDENTIFIER RPAREN )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2076:5: STRING LPAREN IDENTIFIER RPAREN
            {
            match(input,STRING,FOLLOW_STRING_in_gccAsmInOut8395); if (state.failed) return ;

            match(input,LPAREN,FOLLOW_LPAREN_in_gccAsmInOut8397); if (state.failed) return ;

            match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_gccAsmInOut8399); if (state.failed) return ;

            match(input,RPAREN,FOLLOW_RPAREN_in_gccAsmInOut8401); if (state.failed) return ;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 81, gccAsmInOut_StartIndex); }

        }
        return ;
    }
    // $ANTLR end "gccAsmInOut"



    // $ANTLR start "gccAsmInOuts"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2078:1: gccAsmInOuts : gccAsmInOut ( COMMA gccAsmInOut )* ;
    public final void gccAsmInOuts() throws RecognitionException {
        int gccAsmInOuts_StartIndex = input.index();

        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 82) ) { return ; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2079:3: ( gccAsmInOut ( COMMA gccAsmInOut )* )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2080:5: gccAsmInOut ( COMMA gccAsmInOut )*
            {
            pushFollow(FOLLOW_gccAsmInOut_in_gccAsmInOuts8417);
            gccAsmInOut();

            state._fsp--;
            if (state.failed) return ;

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2080:17: ( COMMA gccAsmInOut )*
            loop148:
            do {
                int alt148=2;
                switch ( input.LA(1) ) {
                case COMMA:
                    {
                    alt148=1;
                    }
                    break;

                }

                switch (alt148) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2080:19: COMMA gccAsmInOut
            	    {
            	    match(input,COMMA,FOLLOW_COMMA_in_gccAsmInOuts8421); if (state.failed) return ;

            	    pushFollow(FOLLOW_gccAsmInOut_in_gccAsmInOuts8423);
            	    gccAsmInOut();

            	    state._fsp--;
            	    if (state.failed) return ;

            	    }
            	    break;

            	default :
            	    break loop148;
                }
            } while (true);


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 82, gccAsmInOuts_StartIndex); }

        }
        return ;
    }
    // $ANTLR end "gccAsmInOuts"



    // $ANTLR start "statement"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2083:1: statement returns [Statement stat] : (b= statementsBlock |{...}? => IDENTIFIER ({...}? => IDENTIFIER )? LPAREN ( STRING )* ( ':' ( gccAsmInOuts )? )* RPAREN ( SEMICOLON )? |{...}? => IDENTIFIER LBRACE ( expression | COMMA )* RBRACE |{...}? => IDENTIFIER LPAREN varDecl {...}? IDENTIFIER expression RPAREN statement |{...}? => IDENTIFIER ( '[' ']' delArr= expression |del= expression ) SEMICOLON |pe= postfixExpr SEMICOLON | declaration |es= expression SEMICOLON |rt= 'return' (rex= expression )? SEMICOLON | IDENTIFIER ':' | 'break' SEMICOLON | 'if' LPAREN ifTest= topLevelExpr RPAREN thn= statement ( 'else' els= statement )? | 'while' LPAREN whileTest= topLevelExpr RPAREN wh= statement | 'do' doStat= statement 'while' LPAREN doWhileTest= topLevelExpr RPAREN SEMICOLON | 'for' LPAREN ( ( varDecl | expression )? SEMICOLON ( expression )? SEMICOLON ( expression )? | varDecl ':' expression ) RPAREN forStat= statement | 'switch' LPAREN expression RPAREN LBRACE ( 'case' topLevelExpr ':' | statement | lineDirective )* RBRACE | SEMICOLON );
    public final Statement statement() throws RecognitionException {
        Statement stat = null;

        int statement_StartIndex = input.index();

        Token rt=null;
        Block b =null;

        Expression delArr =null;

        Expression del =null;

        Expression pe =null;

        Expression es =null;

        Expression rex =null;

        ObjCppParser.topLevelExpr_return ifTest =null;

        Statement thn =null;

        Statement els =null;

        ObjCppParser.topLevelExpr_return whileTest =null;

        Statement wh =null;

        Statement doStat =null;

        ObjCppParser.topLevelExpr_return doWhileTest =null;

        Statement forStat =null;

        ObjCppParser.declaration_return declaration52 =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 83) ) { return stat; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2084:3: (b= statementsBlock |{...}? => IDENTIFIER ({...}? => IDENTIFIER )? LPAREN ( STRING )* ( ':' ( gccAsmInOuts )? )* RPAREN ( SEMICOLON )? |{...}? => IDENTIFIER LBRACE ( expression | COMMA )* RBRACE |{...}? => IDENTIFIER LPAREN varDecl {...}? IDENTIFIER expression RPAREN statement |{...}? => IDENTIFIER ( '[' ']' delArr= expression |del= expression ) SEMICOLON |pe= postfixExpr SEMICOLON | declaration |es= expression SEMICOLON |rt= 'return' (rex= expression )? SEMICOLON | IDENTIFIER ':' | 'break' SEMICOLON | 'if' LPAREN ifTest= topLevelExpr RPAREN thn= statement ( 'else' els= statement )? | 'while' LPAREN whileTest= topLevelExpr RPAREN wh= statement | 'do' doStat= statement 'while' LPAREN doWhileTest= topLevelExpr RPAREN SEMICOLON | 'for' LPAREN ( ( varDecl | expression )? SEMICOLON ( expression )? SEMICOLON ( expression )? | varDecl ':' expression ) RPAREN forStat= statement | 'switch' LPAREN expression RPAREN LBRACE ( 'case' topLevelExpr ':' | statement | lineDirective )* RBRACE | SEMICOLON )
            int alt163=17;
            alt163 = dfa163.predict(input);
            switch (alt163) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2085:5: b= statementsBlock
                    {
                    pushFollow(FOLLOW_statementsBlock_in_statement8451);
                    b=statementsBlock();

                    state._fsp--;
                    if (state.failed) return stat;

                    if ( state.backtracking==0 ) { 
                          stat = b; 
                        }

                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2090:5: {...}? => IDENTIFIER ({...}? => IDENTIFIER )? LPAREN ( STRING )* ( ':' ( gccAsmInOuts )? )* RPAREN ( SEMICOLON )?
                    {
                    if ( !(( next("__asm__", "asm") )) ) {
                        if (state.backtracking>0) {state.failed=true; return stat;}
                        throw new FailedPredicateException(input, "statement", " next(\"__asm__\", \"asm\") ");
                    }

                    match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_statement8475); if (state.failed) return stat;

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2091:5: ({...}? => IDENTIFIER )?
                    int alt149=2;
                    int LA149_0 = input.LA(1);

                    if ( (LA149_0==IDENTIFIER) && (( next("__volatile__", "volatile") ))) {
                        alt149=1;
                    }
                    switch (alt149) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2091:7: {...}? => IDENTIFIER
                            {
                            if ( !(( next("__volatile__", "volatile") )) ) {
                                if (state.backtracking>0) {state.failed=true; return stat;}
                                throw new FailedPredicateException(input, "statement", " next(\"__volatile__\", \"volatile\") ");
                            }

                            match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_statement8486); if (state.failed) return stat;

                            }
                            break;

                    }


                    match(input,LPAREN,FOLLOW_LPAREN_in_statement8491); if (state.failed) return stat;

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2092:7: ( STRING )*
                    loop150:
                    do {
                        int alt150=2;
                        switch ( input.LA(1) ) {
                        case STRING:
                            {
                            alt150=1;
                            }
                            break;

                        }

                        switch (alt150) {
                    	case 1 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2092:7: STRING
                    	    {
                    	    match(input,STRING,FOLLOW_STRING_in_statement8499); if (state.failed) return stat;

                    	    }
                    	    break;

                    	default :
                    	    break loop150;
                        }
                    } while (true);


                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2092:15: ( ':' ( gccAsmInOuts )? )*
                    loop152:
                    do {
                        int alt152=2;
                        switch ( input.LA(1) ) {
                        case 51:
                            {
                            alt152=1;
                            }
                            break;

                        }

                        switch (alt152) {
                    	case 1 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2092:17: ':' ( gccAsmInOuts )?
                    	    {
                    	    match(input,51,FOLLOW_51_in_statement8504); if (state.failed) return stat;

                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2092:21: ( gccAsmInOuts )?
                    	    int alt151=2;
                    	    switch ( input.LA(1) ) {
                    	        case STRING:
                    	            {
                    	            alt151=1;
                    	            }
                    	            break;
                    	    }

                    	    switch (alt151) {
                    	        case 1 :
                    	            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2092:21: gccAsmInOuts
                    	            {
                    	            pushFollow(FOLLOW_gccAsmInOuts_in_statement8506);
                    	            gccAsmInOuts();

                    	            state._fsp--;
                    	            if (state.failed) return stat;

                    	            }
                    	            break;

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop152;
                        }
                    } while (true);


                    match(input,RPAREN,FOLLOW_RPAREN_in_statement8516); if (state.failed) return stat;

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2093:12: ( SEMICOLON )?
                    int alt153=2;
                    alt153 = dfa153.predict(input);
                    switch (alt153) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2093:12: SEMICOLON
                            {
                            match(input,SEMICOLON,FOLLOW_SEMICOLON_in_statement8518); if (state.failed) return stat;

                            }
                            break;

                    }


                    }
                    break;
                case 3 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2095:5: {...}? => IDENTIFIER LBRACE ( expression | COMMA )* RBRACE
                    {
                    if ( !(( next("__asm") )) ) {
                        if (state.backtracking>0) {state.failed=true; return stat;}
                        throw new FailedPredicateException(input, "statement", " next(\"__asm\") ");
                    }

                    match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_statement8536); if (state.failed) return stat;

                    match(input,LBRACE,FOLLOW_LBRACE_in_statement8538); if (state.failed) return stat;

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2096:7: ( expression | COMMA )*
                    loop154:
                    do {
                        int alt154=3;
                        switch ( input.LA(1) ) {
                        case CHARACTER:
                        case DECIMAL_NUMBER:
                        case FLOAT_NUMBER:
                        case HEXADECIMAL_NUMBER:
                        case IDENTIFIER:
                        case LBRACE:
                        case LPAREN:
                        case OCTAL_NUMBER:
                        case STRING:
                        case 30:
                        case 36:
                        case 38:
                        case 40:
                        case 41:
                        case 43:
                        case 44:
                        case 66:
                        case 74:
                        case 77:
                        case 78:
                        case 103:
                            {
                            alt154=1;
                            }
                            break;
                        case COMMA:
                            {
                            alt154=2;
                            }
                            break;

                        }

                        switch (alt154) {
                    	case 1 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2096:9: expression
                    	    {
                    	    pushFollow(FOLLOW_expression_in_statement8548);
                    	    expression();

                    	    state._fsp--;
                    	    if (state.failed) return stat;

                    	    }
                    	    break;
                    	case 2 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2096:22: COMMA
                    	    {
                    	    match(input,COMMA,FOLLOW_COMMA_in_statement8552); if (state.failed) return stat;

                    	    }
                    	    break;

                    	default :
                    	    break loop154;
                        }
                    } while (true);


                    match(input,RBRACE,FOLLOW_RBRACE_in_statement8561); if (state.failed) return stat;

                    }
                    break;
                case 4 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2098:5: {...}? => IDENTIFIER LPAREN varDecl {...}? IDENTIFIER expression RPAREN statement
                    {
                    if ( !(( next("foreach") )) ) {
                        if (state.backtracking>0) {state.failed=true; return stat;}
                        throw new FailedPredicateException(input, "statement", " next(\"foreach\") ");
                    }

                    match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_statement8571); if (state.failed) return stat;

                    match(input,LPAREN,FOLLOW_LPAREN_in_statement8573); if (state.failed) return stat;

                    pushFollow(FOLLOW_varDecl_in_statement8575);
                    varDecl();

                    state._fsp--;
                    if (state.failed) return stat;

                    if ( !(( next("in") )) ) {
                        if (state.backtracking>0) {state.failed=true; return stat;}
                        throw new FailedPredicateException(input, "statement", " next(\"in\") ");
                    }

                    match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_statement8579); if (state.failed) return stat;

                    pushFollow(FOLLOW_expression_in_statement8581);
                    expression();

                    state._fsp--;
                    if (state.failed) return stat;

                    match(input,RPAREN,FOLLOW_RPAREN_in_statement8583); if (state.failed) return stat;

                    pushFollow(FOLLOW_statement_in_statement8585);
                    statement();

                    state._fsp--;
                    if (state.failed) return stat;

                    if ( state.backtracking==0 ) { 
                          // TODO
                        }

                    }
                    break;
                case 5 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2101:5: {...}? => IDENTIFIER ( '[' ']' delArr= expression |del= expression ) SEMICOLON
                    {
                    if ( !(( next("delete") )) ) {
                        if (state.backtracking>0) {state.failed=true; return stat;}
                        throw new FailedPredicateException(input, "statement", " next(\"delete\") ");
                    }

                    match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_statement8598); if (state.failed) return stat;

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2101:39: ( '[' ']' delArr= expression |del= expression )
                    int alt155=2;
                    switch ( input.LA(1) ) {
                    case 78:
                        {
                        switch ( input.LA(2) ) {
                        case 79:
                            {
                            alt155=1;
                            }
                            break;
                        case CHARACTER:
                        case DECIMAL_NUMBER:
                        case FLOAT_NUMBER:
                        case HEXADECIMAL_NUMBER:
                        case IDENTIFIER:
                        case LBRACE:
                        case LPAREN:
                        case OCTAL_NUMBER:
                        case STRING:
                        case 30:
                        case 36:
                        case 38:
                        case 40:
                        case 41:
                        case 43:
                        case 44:
                        case 66:
                        case 74:
                        case 77:
                        case 78:
                        case 103:
                            {
                            alt155=2;
                            }
                            break;
                        default:
                            if (state.backtracking>0) {state.failed=true; return stat;}
                            NoViableAltException nvae =
                                new NoViableAltException("", 155, 1, input);

                            throw nvae;

                        }

                        }
                        break;
                    case CHARACTER:
                    case DECIMAL_NUMBER:
                    case FLOAT_NUMBER:
                    case HEXADECIMAL_NUMBER:
                    case IDENTIFIER:
                    case LBRACE:
                    case LPAREN:
                    case OCTAL_NUMBER:
                    case STRING:
                    case 30:
                    case 36:
                    case 38:
                    case 40:
                    case 41:
                    case 43:
                    case 44:
                    case 66:
                    case 74:
                    case 77:
                    case 103:
                        {
                        alt155=2;
                        }
                        break;
                    default:
                        if (state.backtracking>0) {state.failed=true; return stat;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 155, 0, input);

                        throw nvae;

                    }

                    switch (alt155) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2102:7: '[' ']' delArr= expression
                            {
                            match(input,78,FOLLOW_78_in_statement8609); if (state.failed) return stat;

                            match(input,79,FOLLOW_79_in_statement8611); if (state.failed) return stat;

                            pushFollow(FOLLOW_expression_in_statement8615);
                            delArr=expression();

                            state._fsp--;
                            if (state.failed) return stat;

                            if ( state.backtracking==0 ) { 
                                    stat = new Delete(delArr, true); 
                                  }

                            }
                            break;
                        case 2 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2105:7: del= expression
                            {
                            pushFollow(FOLLOW_expression_in_statement8629);
                            del=expression();

                            state._fsp--;
                            if (state.failed) return stat;

                            if ( state.backtracking==0 ) { 
                                    stat = new Delete(del, false); 
                                  }

                            }
                            break;

                    }


                    match(input,SEMICOLON,FOLLOW_SEMICOLON_in_statement8639); if (state.failed) return stat;

                    }
                    break;
                case 6 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2109:5: pe= postfixExpr SEMICOLON
                    {
                    pushFollow(FOLLOW_postfixExpr_in_statement8649);
                    pe=postfixExpr();

                    state._fsp--;
                    if (state.failed) return stat;

                    match(input,SEMICOLON,FOLLOW_SEMICOLON_in_statement8651); if (state.failed) return stat;

                    if ( state.backtracking==0 ) {
                          // Hack to make sure that f(x); is not parsed as a declaration !
                          // Must stay before declaration.
                          stat = new ExpressionStatement(pe); 
                        }

                    }
                    break;
                case 7 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2114:5: declaration
                    {
                    pushFollow(FOLLOW_declaration_in_statement8661);
                    declaration52=declaration();

                    state._fsp--;
                    if (state.failed) return stat;

                    if ( state.backtracking==0 ) { 
                          stat = stat((declaration52!=null?declaration52.declaration:null)); 
                        }

                    }
                    break;
                case 8 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2117:5: es= expression SEMICOLON
                    {
                    pushFollow(FOLLOW_expression_in_statement8673);
                    es=expression();

                    state._fsp--;
                    if (state.failed) return stat;

                    match(input,SEMICOLON,FOLLOW_SEMICOLON_in_statement8675); if (state.failed) return stat;

                    if ( state.backtracking==0 ) { 
                          stat = new ExpressionStatement(es); 
                        }

                    }
                    break;
                case 9 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2120:5: rt= 'return' (rex= expression )? SEMICOLON
                    {
                    rt=(Token)match(input,93,FOLLOW_93_in_statement8687); if (state.failed) return stat;

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2120:20: (rex= expression )?
                    int alt156=2;
                    switch ( input.LA(1) ) {
                        case CHARACTER:
                        case DECIMAL_NUMBER:
                        case FLOAT_NUMBER:
                        case HEXADECIMAL_NUMBER:
                        case IDENTIFIER:
                        case LBRACE:
                        case LPAREN:
                        case OCTAL_NUMBER:
                        case STRING:
                        case 30:
                        case 36:
                        case 38:
                        case 40:
                        case 41:
                        case 43:
                        case 44:
                        case 66:
                        case 74:
                        case 77:
                        case 78:
                        case 103:
                            {
                            alt156=1;
                            }
                            break;
                    }

                    switch (alt156) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2120:20: rex= expression
                            {
                            pushFollow(FOLLOW_expression_in_statement8691);
                            rex=expression();

                            state._fsp--;
                            if (state.failed) return stat;

                            }
                            break;

                    }


                    match(input,SEMICOLON,FOLLOW_SEMICOLON_in_statement8694); if (state.failed) return stat;

                    if ( state.backtracking==0 ) { 
                          stat = mark(new Return(rex), getLine(rt));
                        }

                    }
                    break;
                case 10 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2123:5: IDENTIFIER ':'
                    {
                    match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_statement8704); if (state.failed) return stat;

                    match(input,51,FOLLOW_51_in_statement8706); if (state.failed) return stat;

                    }
                    break;
                case 11 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2124:5: 'break' SEMICOLON
                    {
                    match(input,84,FOLLOW_84_in_statement8715); if (state.failed) return stat;

                    match(input,SEMICOLON,FOLLOW_SEMICOLON_in_statement8717); if (state.failed) return stat;

                    }
                    break;
                case 12 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2125:5: 'if' LPAREN ifTest= topLevelExpr RPAREN thn= statement ( 'else' els= statement )?
                    {
                    match(input,91,FOLLOW_91_in_statement8725); if (state.failed) return stat;

                    match(input,LPAREN,FOLLOW_LPAREN_in_statement8727); if (state.failed) return stat;

                    pushFollow(FOLLOW_topLevelExpr_in_statement8731);
                    ifTest=topLevelExpr();

                    state._fsp--;
                    if (state.failed) return stat;

                    match(input,RPAREN,FOLLOW_RPAREN_in_statement8733); if (state.failed) return stat;

                    pushFollow(FOLLOW_statement_in_statement8737);
                    thn=statement();

                    state._fsp--;
                    if (state.failed) return stat;

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2125:58: ( 'else' els= statement )?
                    int alt157=2;
                    alt157 = dfa157.predict(input);
                    switch (alt157) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2125:59: 'else' els= statement
                            {
                            match(input,88,FOLLOW_88_in_statement8740); if (state.failed) return stat;

                            pushFollow(FOLLOW_statement_in_statement8744);
                            els=statement();

                            state._fsp--;
                            if (state.failed) return stat;

                            }
                            break;

                    }


                    if ( state.backtracking==0 ) { 
                          stat = new Statement.If(ifTest.expr, thn, els);
                        }

                    }
                    break;
                case 13 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2128:5: 'while' LPAREN whileTest= topLevelExpr RPAREN wh= statement
                    {
                    match(input,99,FOLLOW_99_in_statement8757); if (state.failed) return stat;

                    match(input,LPAREN,FOLLOW_LPAREN_in_statement8759); if (state.failed) return stat;

                    pushFollow(FOLLOW_topLevelExpr_in_statement8763);
                    whileTest=topLevelExpr();

                    state._fsp--;
                    if (state.failed) return stat;

                    match(input,RPAREN,FOLLOW_RPAREN_in_statement8765); if (state.failed) return stat;

                    pushFollow(FOLLOW_statement_in_statement8769);
                    wh=statement();

                    state._fsp--;
                    if (state.failed) return stat;

                    if ( state.backtracking==0 ) { 
                          stat = new Statement.While(whileTest.expr, wh);
                        }

                    }
                    break;
                case 14 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2131:5: 'do' doStat= statement 'while' LPAREN doWhileTest= topLevelExpr RPAREN SEMICOLON
                    {
                    match(input,87,FOLLOW_87_in_statement8780); if (state.failed) return stat;

                    pushFollow(FOLLOW_statement_in_statement8784);
                    doStat=statement();

                    state._fsp--;
                    if (state.failed) return stat;

                    match(input,99,FOLLOW_99_in_statement8786); if (state.failed) return stat;

                    match(input,LPAREN,FOLLOW_LPAREN_in_statement8788); if (state.failed) return stat;

                    pushFollow(FOLLOW_topLevelExpr_in_statement8792);
                    doWhileTest=topLevelExpr();

                    state._fsp--;
                    if (state.failed) return stat;

                    match(input,RPAREN,FOLLOW_RPAREN_in_statement8794); if (state.failed) return stat;

                    match(input,SEMICOLON,FOLLOW_SEMICOLON_in_statement8796); if (state.failed) return stat;

                    if ( state.backtracking==0 ) { 
                          stat = new Statement.DoWhile(doWhileTest.expr, doStat);
                        }

                    }
                    break;
                case 15 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2134:5: 'for' LPAREN ( ( varDecl | expression )? SEMICOLON ( expression )? SEMICOLON ( expression )? | varDecl ':' expression ) RPAREN forStat= statement
                    {
                    match(input,90,FOLLOW_90_in_statement8807); if (state.failed) return stat;

                    match(input,LPAREN,FOLLOW_LPAREN_in_statement8809); if (state.failed) return stat;

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2135:7: ( ( varDecl | expression )? SEMICOLON ( expression )? SEMICOLON ( expression )? | varDecl ':' expression )
                    int alt161=2;
                    alt161 = dfa161.predict(input);
                    switch (alt161) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2136:9: ( varDecl | expression )? SEMICOLON ( expression )? SEMICOLON ( expression )?
                            {
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2136:9: ( varDecl | expression )?
                            int alt158=3;
                            alt158 = dfa158.predict(input);
                            switch (alt158) {
                                case 1 :
                                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2136:10: varDecl
                                    {
                                    pushFollow(FOLLOW_varDecl_in_statement8828);
                                    varDecl();

                                    state._fsp--;
                                    if (state.failed) return stat;

                                    }
                                    break;
                                case 2 :
                                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2136:20: expression
                                    {
                                    pushFollow(FOLLOW_expression_in_statement8832);
                                    expression();

                                    state._fsp--;
                                    if (state.failed) return stat;

                                    }
                                    break;

                            }


                            match(input,SEMICOLON,FOLLOW_SEMICOLON_in_statement8837); if (state.failed) return stat;

                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2136:44: ( expression )?
                            int alt159=2;
                            switch ( input.LA(1) ) {
                                case CHARACTER:
                                case DECIMAL_NUMBER:
                                case FLOAT_NUMBER:
                                case HEXADECIMAL_NUMBER:
                                case IDENTIFIER:
                                case LBRACE:
                                case LPAREN:
                                case OCTAL_NUMBER:
                                case STRING:
                                case 30:
                                case 36:
                                case 38:
                                case 40:
                                case 41:
                                case 43:
                                case 44:
                                case 66:
                                case 74:
                                case 77:
                                case 78:
                                case 103:
                                    {
                                    alt159=1;
                                    }
                                    break;
                            }

                            switch (alt159) {
                                case 1 :
                                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2136:44: expression
                                    {
                                    pushFollow(FOLLOW_expression_in_statement8839);
                                    expression();

                                    state._fsp--;
                                    if (state.failed) return stat;

                                    }
                                    break;

                            }


                            match(input,SEMICOLON,FOLLOW_SEMICOLON_in_statement8842); if (state.failed) return stat;

                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2136:66: ( expression )?
                            int alt160=2;
                            switch ( input.LA(1) ) {
                                case CHARACTER:
                                case DECIMAL_NUMBER:
                                case FLOAT_NUMBER:
                                case HEXADECIMAL_NUMBER:
                                case IDENTIFIER:
                                case LBRACE:
                                case LPAREN:
                                case OCTAL_NUMBER:
                                case STRING:
                                case 30:
                                case 36:
                                case 38:
                                case 40:
                                case 41:
                                case 43:
                                case 44:
                                case 66:
                                case 74:
                                case 77:
                                case 78:
                                case 103:
                                    {
                                    alt160=1;
                                    }
                                    break;
                            }

                            switch (alt160) {
                                case 1 :
                                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2136:66: expression
                                    {
                                    pushFollow(FOLLOW_expression_in_statement8844);
                                    expression();

                                    state._fsp--;
                                    if (state.failed) return stat;

                                    }
                                    break;

                            }


                            }
                            break;
                        case 2 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2137:9: varDecl ':' expression
                            {
                            pushFollow(FOLLOW_varDecl_in_statement8858);
                            varDecl();

                            state._fsp--;
                            if (state.failed) return stat;

                            match(input,51,FOLLOW_51_in_statement8860); if (state.failed) return stat;

                            pushFollow(FOLLOW_expression_in_statement8862);
                            expression();

                            state._fsp--;
                            if (state.failed) return stat;

                            }
                            break;

                    }


                    match(input,RPAREN,FOLLOW_RPAREN_in_statement8881); if (state.failed) return stat;

                    pushFollow(FOLLOW_statement_in_statement8885);
                    forStat=statement();

                    state._fsp--;
                    if (state.failed) return stat;

                    if ( state.backtracking==0 ) { 
                          // TODO
                        }

                    }
                    break;
                case 16 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2142:5: 'switch' LPAREN expression RPAREN LBRACE ( 'case' topLevelExpr ':' | statement | lineDirective )* RBRACE
                    {
                    match(input,95,FOLLOW_95_in_statement8896); if (state.failed) return stat;

                    match(input,LPAREN,FOLLOW_LPAREN_in_statement8898); if (state.failed) return stat;

                    pushFollow(FOLLOW_expression_in_statement8900);
                    expression();

                    state._fsp--;
                    if (state.failed) return stat;

                    match(input,RPAREN,FOLLOW_RPAREN_in_statement8902); if (state.failed) return stat;

                    match(input,LBRACE,FOLLOW_LBRACE_in_statement8904); if (state.failed) return stat;

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2143:7: ( 'case' topLevelExpr ':' | statement | lineDirective )*
                    loop162:
                    do {
                        int alt162=4;
                        switch ( input.LA(1) ) {
                        case 85:
                            {
                            alt162=1;
                            }
                            break;
                        case CHARACTER:
                        case DECIMAL_NUMBER:
                        case FLOAT_NUMBER:
                        case HEXADECIMAL_NUMBER:
                        case IDENTIFIER:
                        case LBRACE:
                        case LPAREN:
                        case OCTAL_NUMBER:
                        case SEMICOLON:
                        case STRING:
                        case 30:
                        case 36:
                        case 38:
                        case 40:
                        case 41:
                        case 43:
                        case 44:
                        case 51:
                        case 52:
                        case 65:
                        case 66:
                        case 68:
                        case 74:
                        case 77:
                        case 78:
                        case 80:
                        case 82:
                        case 83:
                        case 84:
                        case 86:
                        case 87:
                        case 89:
                        case 90:
                        case 91:
                        case 92:
                        case 93:
                        case 94:
                        case 95:
                        case 96:
                        case 97:
                        case 98:
                        case 99:
                        case 103:
                            {
                            alt162=2;
                            }
                            break;
                        case 32:
                            {
                            alt162=3;
                            }
                            break;

                        }

                        switch (alt162) {
                    	case 1 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2144:9: 'case' topLevelExpr ':'
                    	    {
                    	    match(input,85,FOLLOW_85_in_statement8925); if (state.failed) return stat;

                    	    pushFollow(FOLLOW_topLevelExpr_in_statement8927);
                    	    topLevelExpr();

                    	    state._fsp--;
                    	    if (state.failed) return stat;

                    	    match(input,51,FOLLOW_51_in_statement8929); if (state.failed) return stat;

                    	    }
                    	    break;
                    	case 2 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2145:9: statement
                    	    {
                    	    pushFollow(FOLLOW_statement_in_statement8941);
                    	    statement();

                    	    state._fsp--;
                    	    if (state.failed) return stat;

                    	    }
                    	    break;
                    	case 3 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2146:9: lineDirective
                    	    {
                    	    pushFollow(FOLLOW_lineDirective_in_statement8953);
                    	    lineDirective();

                    	    state._fsp--;
                    	    if (state.failed) return stat;

                    	    }
                    	    break;

                    	default :
                    	    break loop162;
                        }
                    } while (true);


                    match(input,RBRACE,FOLLOW_RBRACE_in_statement8968); if (state.failed) return stat;

                    }
                    break;
                case 17 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2149:5: SEMICOLON
                    {
                    match(input,SEMICOLON,FOLLOW_SEMICOLON_in_statement8976); if (state.failed) return stat;

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 83, statement_StartIndex); }

        }
        return stat;
    }
    // $ANTLR end "statement"



    // $ANTLR start "constant"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2152:1: constant returns [Constant constant] : ( (s= ( '-' | '+' ) )? ( DECIMAL_NUMBER | HEXADECIMAL_NUMBER | OCTAL_NUMBER ) | CHARACTER | (s2= ( '-' | '+' ) )? FLOAT_NUMBER | STRING );
    public final Constant constant() throws RecognitionException {
        Constant constant = null;

        int constant_StartIndex = input.index();

        Token s=null;
        Token s2=null;
        Token DECIMAL_NUMBER53=null;
        Token HEXADECIMAL_NUMBER54=null;
        Token OCTAL_NUMBER55=null;
        Token CHARACTER56=null;
        Token FLOAT_NUMBER57=null;
        Token STRING58=null;

        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 84) ) { return constant; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2153:3: ( (s= ( '-' | '+' ) )? ( DECIMAL_NUMBER | HEXADECIMAL_NUMBER | OCTAL_NUMBER ) | CHARACTER | (s2= ( '-' | '+' ) )? FLOAT_NUMBER | STRING )
            int alt167=4;
            switch ( input.LA(1) ) {
            case 40:
            case 43:
                {
                switch ( input.LA(2) ) {
                case DECIMAL_NUMBER:
                case HEXADECIMAL_NUMBER:
                case OCTAL_NUMBER:
                    {
                    alt167=1;
                    }
                    break;
                case FLOAT_NUMBER:
                    {
                    alt167=3;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return constant;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 167, 1, input);

                    throw nvae;

                }

                }
                break;
            case DECIMAL_NUMBER:
            case HEXADECIMAL_NUMBER:
            case OCTAL_NUMBER:
                {
                alt167=1;
                }
                break;
            case CHARACTER:
                {
                alt167=2;
                }
                break;
            case FLOAT_NUMBER:
                {
                alt167=3;
                }
                break;
            case STRING:
                {
                alt167=4;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return constant;}
                NoViableAltException nvae =
                    new NoViableAltException("", 167, 0, input);

                throw nvae;

            }

            switch (alt167) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2153:6: (s= ( '-' | '+' ) )? ( DECIMAL_NUMBER | HEXADECIMAL_NUMBER | OCTAL_NUMBER )
                    {
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2153:7: (s= ( '-' | '+' ) )?
                    int alt164=2;
                    switch ( input.LA(1) ) {
                        case 40:
                        case 43:
                            {
                            alt164=1;
                            }
                            break;
                    }

                    switch (alt164) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2153:7: s= ( '-' | '+' )
                            {
                            s=(Token)input.LT(1);

                            if ( input.LA(1)==40||input.LA(1)==43 ) {
                                input.consume();
                                state.errorRecovery=false;
                                state.failed=false;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return constant;}
                                MismatchedSetException mse = new MismatchedSetException(null,input);
                                throw mse;
                            }


                            }
                            break;

                    }


                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2153:21: ( DECIMAL_NUMBER | HEXADECIMAL_NUMBER | OCTAL_NUMBER )
                    int alt165=3;
                    switch ( input.LA(1) ) {
                    case DECIMAL_NUMBER:
                        {
                        alt165=1;
                        }
                        break;
                    case HEXADECIMAL_NUMBER:
                        {
                        alt165=2;
                        }
                        break;
                    case OCTAL_NUMBER:
                        {
                        alt165=3;
                        }
                        break;
                    default:
                        if (state.backtracking>0) {state.failed=true; return constant;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 165, 0, input);

                        throw nvae;

                    }

                    switch (alt165) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2154:7: DECIMAL_NUMBER
                            {
                            DECIMAL_NUMBER53=(Token)match(input,DECIMAL_NUMBER,FOLLOW_DECIMAL_NUMBER_in_constant9015); if (state.failed) return constant;

                            if ( state.backtracking==0 ) { constant =  Constant.parseDecimal(((s!=null?s.getText():null) == null ? "" : (s!=null?s.getText():null)) + (DECIMAL_NUMBER53!=null?DECIMAL_NUMBER53.getText():null)); }

                            }
                            break;
                        case 2 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2155:7: HEXADECIMAL_NUMBER
                            {
                            HEXADECIMAL_NUMBER54=(Token)match(input,HEXADECIMAL_NUMBER,FOLLOW_HEXADECIMAL_NUMBER_in_constant9027); if (state.failed) return constant;

                            if ( state.backtracking==0 ) { constant = Constant.parseHex((HEXADECIMAL_NUMBER54!=null?HEXADECIMAL_NUMBER54.getText():null), "-".equals((s!=null?s.getText():null))); }

                            }
                            break;
                        case 3 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2156:7: OCTAL_NUMBER
                            {
                            OCTAL_NUMBER55=(Token)match(input,OCTAL_NUMBER,FOLLOW_OCTAL_NUMBER_in_constant9039); if (state.failed) return constant;

                            if ( state.backtracking==0 ) { constant = Constant.parseOctal((OCTAL_NUMBER55!=null?OCTAL_NUMBER55.getText():null), "-".equals((s!=null?s.getText():null))); }

                            }
                            break;

                    }


                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2158:5: CHARACTER
                    {
                    CHARACTER56=(Token)match(input,CHARACTER,FOLLOW_CHARACTER_in_constant9055); if (state.failed) return constant;

                    if ( state.backtracking==0 ) { constant =  Constant.parseCharOrStringInteger((CHARACTER56!=null?CHARACTER56.getText():null)); }

                    }
                    break;
                case 3 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2159:5: (s2= ( '-' | '+' ) )? FLOAT_NUMBER
                    {
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2159:7: (s2= ( '-' | '+' ) )?
                    int alt166=2;
                    switch ( input.LA(1) ) {
                        case 40:
                        case 43:
                            {
                            alt166=1;
                            }
                            break;
                    }

                    switch (alt166) {
                        case 1 :
                            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2159:7: s2= ( '-' | '+' )
                            {
                            s2=(Token)input.LT(1);

                            if ( input.LA(1)==40||input.LA(1)==43 ) {
                                input.consume();
                                state.errorRecovery=false;
                                state.failed=false;
                            }
                            else {
                                if (state.backtracking>0) {state.failed=true; return constant;}
                                MismatchedSetException mse = new MismatchedSetException(null,input);
                                throw mse;
                            }


                            }
                            break;

                    }


                    FLOAT_NUMBER57=(Token)match(input,FLOAT_NUMBER,FOLLOW_FLOAT_NUMBER_in_constant9076); if (state.failed) return constant;

                    if ( state.backtracking==0 ) { constant = Constant.parseFloat(((s2!=null?s2.getText():null) == null ? "" : (s2!=null?s2.getText():null)) + (FLOAT_NUMBER57!=null?FLOAT_NUMBER57.getText():null)); }

                    }
                    break;
                case 4 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2161:5: STRING
                    {
                    STRING58=(Token)match(input,STRING,FOLLOW_STRING_in_constant9091); if (state.failed) return constant;

                    if ( state.backtracking==0 ) { constant =  Constant.parseString((STRING58!=null?STRING58.getText():null)); }

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 84, constant_StartIndex); }

        }
        return constant;
    }
    // $ANTLR end "constant"



    // $ANTLR start "javaTemplateArg"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2173:1: javaTemplateArg returns [Expression expr] : (t= javaType |tk= '?' );
    public final Expression javaTemplateArg() throws RecognitionException {
        Expression expr = null;

        int javaTemplateArg_StartIndex = input.index();

        Token tk=null;
        TypeRef t =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 85) ) { return expr; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2174:3: (t= javaType |tk= '?' )
            int alt168=2;
            switch ( input.LA(1) ) {
            case IDENTIFIER:
                {
                alt168=1;
                }
                break;
            case 64:
                {
                alt168=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return expr;}
                NoViableAltException nvae =
                    new NoViableAltException("", 168, 0, input);

                throw nvae;

            }

            switch (alt168) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2175:5: t= javaType
                    {
                    pushFollow(FOLLOW_javaType_in_javaTemplateArg9165);
                    t=javaType();

                    state._fsp--;
                    if (state.failed) return expr;

                    if ( state.backtracking==0 ) {
                          expr = expr(t);
                        }

                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2178:5: tk= '?'
                    {
                    tk=(Token)match(input,64,FOLLOW_64_in_javaTemplateArg9178); if (state.failed) return expr;

                    if ( state.backtracking==0 ) {
                          expr = expr((tk!=null?tk.getText():null));
                        }

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 85, javaTemplateArg_StartIndex); }

        }
        return expr;
    }
    // $ANTLR end "javaTemplateArg"



    // $ANTLR start "javaTypeIdent"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2183:1: javaTypeIdent returns [Identifier ident] : f= IDENTIFIER ( '.' n= IDENTIFIER )+ ( '<' first= javaTemplateArg ( COMMA other= javaTemplateArg )* '>' )? ;
    public final Identifier javaTypeIdent() throws RecognitionException {
        Identifier ident = null;

        int javaTypeIdent_StartIndex = input.index();

        Token f=null;
        Token n=null;
        Expression first =null;

        Expression other =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 86) ) { return ident; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2184:3: (f= IDENTIFIER ( '.' n= IDENTIFIER )+ ( '<' first= javaTemplateArg ( COMMA other= javaTemplateArg )* '>' )? )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2185:5: f= IDENTIFIER ( '.' n= IDENTIFIER )+ ( '<' first= javaTemplateArg ( COMMA other= javaTemplateArg )* '>' )?
            {
            f=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_javaTypeIdent9207); if (state.failed) return ident;

            if ( state.backtracking==0 ) { 
                  ident = ident((f!=null?f.getText():null)); 
                }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2188:5: ( '.' n= IDENTIFIER )+
            int cnt169=0;
            loop169:
            do {
                int alt169=2;
                switch ( input.LA(1) ) {
                case 47:
                    {
                    alt169=1;
                    }
                    break;

                }

                switch (alt169) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2189:7: '.' n= IDENTIFIER
            	    {
            	    match(input,47,FOLLOW_47_in_javaTypeIdent9224); if (state.failed) return ident;

            	    n=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_javaTypeIdent9228); if (state.failed) return ident;

            	    if ( state.backtracking==0 ) {
            	            ident = ident.derive(Identifier.QualificationSeparator.Dot, (n!=null?n.getText():null));  
            	          }

            	    }
            	    break;

            	default :
            	    if ( cnt169 >= 1 ) break loop169;
            	    if (state.backtracking>0) {state.failed=true; return ident;}
                        EarlyExitException eee =
                            new EarlyExitException(169, input);
                        throw eee;
                }
                cnt169++;
            } while (true);


            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2193:5: ( '<' first= javaTemplateArg ( COMMA other= javaTemplateArg )* '>' )?
            int alt171=2;
            switch ( input.LA(1) ) {
                case 53:
                    {
                    alt171=1;
                    }
                    break;
            }

            switch (alt171) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2194:7: '<' first= javaTemplateArg ( COMMA other= javaTemplateArg )* '>'
                    {
                    match(input,53,FOLLOW_53_in_javaTypeIdent9252); if (state.failed) return ident;

                    pushFollow(FOLLOW_javaTemplateArg_in_javaTypeIdent9264);
                    first=javaTemplateArg();

                    state._fsp--;
                    if (state.failed) return ident;

                    if ( state.backtracking==0 ) {
                              ident.resolveLastSimpleIdentifier().addTemplateArgument(first);
                            }

                    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2198:9: ( COMMA other= javaTemplateArg )*
                    loop170:
                    do {
                        int alt170=2;
                        switch ( input.LA(1) ) {
                        case COMMA:
                            {
                            alt170=1;
                            }
                            break;

                        }

                        switch (alt170) {
                    	case 1 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2199:11: COMMA other= javaTemplateArg
                    	    {
                    	    match(input,COMMA,FOLLOW_COMMA_in_javaTypeIdent9288); if (state.failed) return ident;

                    	    pushFollow(FOLLOW_javaTemplateArg_in_javaTypeIdent9302);
                    	    other=javaTemplateArg();

                    	    state._fsp--;
                    	    if (state.failed) return ident;

                    	    if ( state.backtracking==0 ) {
                    	                ident.resolveLastSimpleIdentifier().addTemplateArgument(other);
                    	              }

                    	    }
                    	    break;

                    	default :
                    	    break loop170;
                        }
                    } while (true);


                    match(input,59,FOLLOW_59_in_javaTypeIdent9324); if (state.failed) return ident;

                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 86, javaTypeIdent_StartIndex); }

        }
        return ident;
    }
    // $ANTLR end "javaTypeIdent"



    // $ANTLR start "javaType"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2209:1: javaType returns [TypeRef typeRef] : i= javaTypeIdent ( '[' ']' ) ;
    public final TypeRef javaType() throws RecognitionException {
        TypeRef typeRef = null;

        int javaType_StartIndex = input.index();

        Identifier i =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 87) ) { return typeRef; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2210:3: (i= javaTypeIdent ( '[' ']' ) )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2211:5: i= javaTypeIdent ( '[' ']' )
            {
            pushFollow(FOLLOW_javaTypeIdent_in_javaType9361);
            i=javaTypeIdent();

            state._fsp--;
            if (state.failed) return typeRef;

            if ( state.backtracking==0 ) {
                  typeRef = new TypeRef.SimpleTypeRef(i);
                }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2214:5: ( '[' ']' )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2215:7: '[' ']'
            {
            match(input,78,FOLLOW_78_in_javaType9377); if (state.failed) return typeRef;

            match(input,79,FOLLOW_79_in_javaType9379); if (state.failed) return typeRef;

            if ( state.backtracking==0 ) {
                    typeRef = new TypeRef.ArrayRef(typeRef);
                  }

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 87, javaType_StartIndex); }

        }
        return typeRef;
    }
    // $ANTLR end "javaType"



    // $ANTLR start "javaArg"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2221:1: javaArg returns [Arg arg] : t= javaType n= IDENTIFIER ;
    public final Arg javaArg() throws RecognitionException {
        Arg arg = null;

        int javaArg_StartIndex = input.index();

        Token n=null;
        TypeRef t =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 88) ) { return arg; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2222:3: (t= javaType n= IDENTIFIER )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2223:5: t= javaType n= IDENTIFIER
            {
            pushFollow(FOLLOW_javaType_in_javaArg9410);
            t=javaType();

            state._fsp--;
            if (state.failed) return arg;

            n=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_javaArg9414); if (state.failed) return arg;

            if ( state.backtracking==0 ) {
                  arg = new Arg((n!=null?n.getText():null), t);
                }

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 88, javaArg_StartIndex); }

        }
        return arg;
    }
    // $ANTLR end "javaArg"



    // $ANTLR start "javaMethodDeclaration"
    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2228:1: javaMethodDeclaration returns [Function function] : ret= javaType name= IDENTIFIER LPAREN first= javaArg ( COMMA other= javaArg ) RPAREN SEMICOLON ;
    public final Function javaMethodDeclaration() throws RecognitionException {
        Function function = null;

        int javaMethodDeclaration_StartIndex = input.index();

        Token name=null;
        TypeRef ret =null;

        Arg first =null;

        Arg other =null;


        try {
            if ( state.backtracking>0 && alreadyParsedRule(input, 89) ) { return function; }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2229:3: (ret= javaType name= IDENTIFIER LPAREN first= javaArg ( COMMA other= javaArg ) RPAREN SEMICOLON )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2230:5: ret= javaType name= IDENTIFIER LPAREN first= javaArg ( COMMA other= javaArg ) RPAREN SEMICOLON
            {
            pushFollow(FOLLOW_javaType_in_javaMethodDeclaration9441);
            ret=javaType();

            state._fsp--;
            if (state.failed) return function;

            name=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_javaMethodDeclaration9449); if (state.failed) return function;

            if ( state.backtracking==0 ) {
                  function = new Function(); 
                  function.setType(Function.Type.JavaMethod);
                  function.setName(ident((name!=null?name.getText():null)));
                  function.setValueType(ret);
                }

            match(input,LPAREN,FOLLOW_LPAREN_in_javaMethodDeclaration9457); if (state.failed) return function;

            pushFollow(FOLLOW_javaArg_in_javaMethodDeclaration9465);
            first=javaArg();

            state._fsp--;
            if (state.failed) return function;

            if ( state.backtracking==0 ) {
                  function.addArg(first);
                }

            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2241:5: ( COMMA other= javaArg )
            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2242:7: COMMA other= javaArg
            {
            match(input,COMMA,FOLLOW_COMMA_in_javaMethodDeclaration9481); if (state.failed) return function;

            pushFollow(FOLLOW_javaArg_in_javaMethodDeclaration9491);
            other=javaArg();

            state._fsp--;
            if (state.failed) return function;

            if ( state.backtracking==0 ) {
                    function.addArg(other);
                  }

            }


            match(input,RPAREN,FOLLOW_RPAREN_in_javaMethodDeclaration9505); if (state.failed) return function;

            match(input,SEMICOLON,FOLLOW_SEMICOLON_in_javaMethodDeclaration9511); if (state.failed) return function;

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
            if ( state.backtracking>0 ) { memoize(input, 89, javaMethodDeclaration_StartIndex); }

        }
        return function;
    }
    // $ANTLR end "javaMethodDeclaration"

    // $ANTLR start synpred1_ObjCpp
    public final void synpred1_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:494:7: ( declaration )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:494:7: declaration
        {
        pushFollow(FOLLOW_declaration_in_synpred1_ObjCpp188);
        declaration();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred1_ObjCpp

    // $ANTLR start synpred3_ObjCpp
    public final void synpred3_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:501:7: ({...}? => IDENTIFIER STRING LBRACE )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:501:7: {...}? => IDENTIFIER STRING LBRACE
        {
        if ( !(( next("extern") )) ) {
            if (state.backtracking>0) {state.failed=true; return ;}
            throw new FailedPredicateException(input, "synpred3_ObjCpp", " next(\"extern\") ");
        }

        match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred3_ObjCpp215); if (state.failed) return ;

        match(input,STRING,FOLLOW_STRING_in_synpred3_ObjCpp217); if (state.failed) return ;

        match(input,LBRACE,FOLLOW_LBRACE_in_synpred3_ObjCpp219); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred3_ObjCpp

    // $ANTLR start synpred8_ObjCpp
    public final void synpred8_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:559:7: ({...}? IDENTIFIER )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:559:7: {...}? IDENTIFIER
        {
        if ( !(( next("__extension__") )) ) {
            if (state.backtracking>0) {state.failed=true; return ;}
            throw new FailedPredicateException(input, "synpred8_ObjCpp", " next(\"__extension__\") ");
        }

        match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred8_ObjCpp418); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred8_ObjCpp

    // $ANTLR start synpred9_ObjCpp
    public final void synpred9_ObjCpp_fragment() throws RecognitionException {
        Template tp =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:560:7: (tp= templatePrefix )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:560:7: tp= templatePrefix
        {
        pushFollow(FOLLOW_templatePrefix_in_synpred9_ObjCpp431);
        tp=templatePrefix();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred9_ObjCpp

    // $ANTLR start synpred10_ObjCpp
    public final void synpred10_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:568:9: ({...}? => pragmaContent )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:568:9: {...}? => pragmaContent
        {
        if ( !(( next("__pragma") )) ) {
            if (state.backtracking>0) {state.failed=true; return ;}
            throw new FailedPredicateException(input, "synpred10_ObjCpp", " next(\"__pragma\") ");
        }

        pushFollow(FOLLOW_pragmaContent_in_synpred10_ObjCpp469);
        pragmaContent();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred10_ObjCpp

    // $ANTLR start synpred11_ObjCpp
    public final void synpred11_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:569:9: ( functionDeclaration )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:569:9: functionDeclaration
        {
        pushFollow(FOLLOW_functionDeclaration_in_synpred11_ObjCpp481);
        functionDeclaration();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred11_ObjCpp

    // $ANTLR start synpred12_ObjCpp
    public final void synpred12_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:572:9: ({...}? => externDeclarations )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:572:9: {...}? => externDeclarations
        {
        if ( !(( next("extern") )) ) {
            if (state.backtracking>0) {state.failed=true; return ;}
            throw new FailedPredicateException(input, "synpred12_ObjCpp", " next(\"extern\") ");
        }

        pushFollow(FOLLOW_externDeclarations_in_synpred12_ObjCpp498);
        externDeclarations();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred12_ObjCpp

    // $ANTLR start synpred13_ObjCpp
    public final void synpred13_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:575:9: ({...}? => IDENTIFIER qualifiedIdentifier SEMICOLON )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:575:9: {...}? => IDENTIFIER qualifiedIdentifier SEMICOLON
        {
        if ( !(( next("using") )) ) {
            if (state.backtracking>0) {state.failed=true; return ;}
            throw new FailedPredicateException(input, "synpred13_ObjCpp", " next(\"using\") ");
        }

        match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred13_ObjCpp515); if (state.failed) return ;

        pushFollow(FOLLOW_qualifiedIdentifier_in_synpred13_ObjCpp517);
        qualifiedIdentifier();

        state._fsp--;
        if (state.failed) return ;

        match(input,SEMICOLON,FOLLOW_SEMICOLON_in_synpred13_ObjCpp519); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred13_ObjCpp

    // $ANTLR start synpred14_ObjCpp
    public final void synpred14_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:578:9: ( varDecl SEMICOLON )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:578:9: varDecl SEMICOLON
        {
        pushFollow(FOLLOW_varDecl_in_synpred14_ObjCpp533);
        varDecl();

        state._fsp--;
        if (state.failed) return ;

        match(input,SEMICOLON,FOLLOW_SEMICOLON_in_synpred14_ObjCpp535); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred14_ObjCpp

    // $ANTLR start synpred25_ObjCpp
    public final void synpred25_ObjCpp_fragment() throws RecognitionException {
        List<Modifier> m1 =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:687:9: (m1= modifiers )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:687:9: m1= modifiers
        {
        pushFollow(FOLLOW_modifiers_in_synpred25_ObjCpp1013);
        m1=modifiers();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred25_ObjCpp

    // $ANTLR start synpred28_ObjCpp
    public final void synpred28_ObjCpp_fragment() throws RecognitionException {
        List<Modifier> m2 =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:696:13: (m2= modifiers )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:696:13: m2= modifiers
        {
        pushFollow(FOLLOW_modifiers_in_synpred28_ObjCpp1096);
        m2=modifiers();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred28_ObjCpp

    // $ANTLR start synpred30_ObjCpp
    public final void synpred30_ObjCpp_fragment() throws RecognitionException {
        List<Modifier> m2 =null;

        Enum nb =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:696:11: ( (m2= modifiers )? ( ':' IDENTIFIER )? nb= enumBody )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:696:11: (m2= modifiers )? ( ':' IDENTIFIER )? nb= enumBody
        {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:696:11: (m2= modifiers )?
        int alt177=2;
        switch ( input.LA(1) ) {
            case IDENTIFIER:
            case 82:
            case 83:
                {
                alt177=1;
                }
                break;
        }

        switch (alt177) {
            case 1 :
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:696:13: m2= modifiers
                {
                pushFollow(FOLLOW_modifiers_in_synpred30_ObjCpp1096);
                m2=modifiers();

                state._fsp--;
                if (state.failed) return ;

                }
                break;

        }


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:697:11: ( ':' IDENTIFIER )?
        int alt178=2;
        switch ( input.LA(1) ) {
            case 51:
                {
                alt178=1;
                }
                break;
        }

        switch (alt178) {
            case 1 :
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:697:13: ':' IDENTIFIER
                {
                match(input,51,FOLLOW_51_in_synpred30_ObjCpp1115); if (state.failed) return ;

                match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred30_ObjCpp1117); if (state.failed) return ;

                }
                break;

        }


        pushFollow(FOLLOW_enumBody_in_synpred30_ObjCpp1134);
        nb=enumBody();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred30_ObjCpp

    // $ANTLR start synpred33_ObjCpp
    public final void synpred33_ObjCpp_fragment() throws RecognitionException {
        Token categoryName=null;

        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:740:7: ( ( LPAREN categoryName= IDENTIFIER RPAREN ) )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:740:7: ( LPAREN categoryName= IDENTIFIER RPAREN )
        {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:740:7: ( LPAREN categoryName= IDENTIFIER RPAREN )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:741:9: LPAREN categoryName= IDENTIFIER RPAREN
        {
        match(input,LPAREN,FOLLOW_LPAREN_in_synpred33_ObjCpp1275); if (state.failed) return ;

        categoryName=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred33_ObjCpp1279); if (state.failed) return ;

        match(input,RPAREN,FOLLOW_RPAREN_in_synpred33_ObjCpp1281); if (state.failed) return ;

        }


        }

    }
    // $ANTLR end synpred33_ObjCpp

    // $ANTLR start synpred41_ObjCpp
    public final void synpred41_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:762:9: ( ( functionPointerOrSimpleVarDecl SEMICOLON ) )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:762:9: ( functionPointerOrSimpleVarDecl SEMICOLON )
        {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:762:9: ( functionPointerOrSimpleVarDecl SEMICOLON )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:763:11: functionPointerOrSimpleVarDecl SEMICOLON
        {
        pushFollow(FOLLOW_functionPointerOrSimpleVarDecl_in_synpred41_ObjCpp1500);
        functionPointerOrSimpleVarDecl();

        state._fsp--;
        if (state.failed) return ;

        match(input,SEMICOLON,FOLLOW_SEMICOLON_in_synpred41_ObjCpp1502); if (state.failed) return ;

        }


        }

    }
    // $ANTLR end synpred41_ObjCpp

    // $ANTLR start synpred49_ObjCpp
    public final void synpred49_ObjCpp_fragment() throws RecognitionException {
        VariablesDeclaration vd =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:784:7: (vd= varDecl SEMICOLON )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:784:7: vd= varDecl SEMICOLON
        {
        pushFollow(FOLLOW_varDecl_in_synpred49_ObjCpp1635);
        vd=varDecl();

        state._fsp--;
        if (state.failed) return ;

        match(input,SEMICOLON,FOLLOW_SEMICOLON_in_synpred49_ObjCpp1637); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred49_ObjCpp

    // $ANTLR start synpred51_ObjCpp
    public final void synpred51_ObjCpp_fragment() throws RecognitionException {
        VariablesDeclaration fv =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:794:5: (fv= varDecl )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:794:5: fv= varDecl
        {
        pushFollow(FOLLOW_varDecl_in_synpred51_ObjCpp1697);
        fv=varDecl();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred51_ObjCpp

    // $ANTLR start synpred54_ObjCpp
    public final void synpred54_ObjCpp_fragment() throws RecognitionException {
        Modifier a1 =null;

        Modifier ax =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:824:7: ( LPAREN a1= objCPropertyAttribute ( COMMA ax= objCPropertyAttribute )* RPAREN )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:824:7: LPAREN a1= objCPropertyAttribute ( COMMA ax= objCPropertyAttribute )* RPAREN
        {
        match(input,LPAREN,FOLLOW_LPAREN_in_synpred54_ObjCpp1829); if (state.failed) return ;

        pushFollow(FOLLOW_objCPropertyAttribute_in_synpred54_ObjCpp1843);
        a1=objCPropertyAttribute();

        state._fsp--;
        if (state.failed) return ;

        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:828:11: ( COMMA ax= objCPropertyAttribute )*
        loop183:
        do {
            int alt183=2;
            switch ( input.LA(1) ) {
            case COMMA:
                {
                alt183=1;
                }
                break;

            }

            switch (alt183) {
        	case 1 :
        	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:829:13: COMMA ax= objCPropertyAttribute
        	    {
        	    match(input,COMMA,FOLLOW_COMMA_in_synpred54_ObjCpp1871); if (state.failed) return ;

        	    pushFollow(FOLLOW_objCPropertyAttribute_in_synpred54_ObjCpp1875);
        	    ax=objCPropertyAttribute();

        	    state._fsp--;
        	    if (state.failed) return ;

        	    }
        	    break;

        	default :
        	    break loop183;
            }
        } while (true);


        match(input,RPAREN,FOLLOW_RPAREN_in_synpred54_ObjCpp1898); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred54_ObjCpp

    // $ANTLR start synpred56_ObjCpp
    public final void synpred56_ObjCpp_fragment() throws RecognitionException {
        TypeRef returnTypeRef =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:863:22: (returnTypeRef= mutableTypeRef )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:863:22: returnTypeRef= mutableTypeRef
        {
        pushFollow(FOLLOW_mutableTypeRef_in_synpred56_ObjCpp2019);
        returnTypeRef=mutableTypeRef();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred56_ObjCpp

    // $ANTLR start synpred62_ObjCpp
    public final void synpred62_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:910:11: ({...}? IDENTIFIER )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:910:11: {...}? IDENTIFIER
        {
        if ( !(( next("public") )) ) {
            if (state.backtracking>0) {state.failed=true; return ;}
            throw new FailedPredicateException(input, "synpred62_ObjCpp", " next(\"public\") ");
        }

        match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred62_ObjCpp2264); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred62_ObjCpp

    // $ANTLR start synpred63_ObjCpp
    public final void synpred63_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:911:11: ({...}? IDENTIFIER )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:911:11: {...}? IDENTIFIER
        {
        if ( !(( next("private") )) ) {
            if (state.backtracking>0) {state.failed=true; return ;}
            throw new FailedPredicateException(input, "synpred63_ObjCpp", " next(\"private\") ");
        }

        match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred63_ObjCpp2283); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred63_ObjCpp

    // $ANTLR start synpred64_ObjCpp
    public final void synpred64_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:909:9: ( ({...}? IDENTIFIER |{...}? IDENTIFIER |{...}? IDENTIFIER ) ':' )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:909:9: ({...}? IDENTIFIER |{...}? IDENTIFIER |{...}? IDENTIFIER ) ':'
        {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:909:9: ({...}? IDENTIFIER |{...}? IDENTIFIER |{...}? IDENTIFIER )
        int alt187=3;
        switch ( input.LA(1) ) {
        case IDENTIFIER:
            {
            int LA187_1 = input.LA(2);

            if ( (((synpred62_ObjCpp()&&synpred62_ObjCpp())&&( next("public") ))) ) {
                alt187=1;
            }
            else if ( (((synpred63_ObjCpp()&&synpred63_ObjCpp())&&( next("private") ))) ) {
                alt187=2;
            }
            else if ( (( next("protected") )) ) {
                alt187=3;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 187, 1, input);

                throw nvae;

            }
            }
            break;
        default:
            if (state.backtracking>0) {state.failed=true; return ;}
            NoViableAltException nvae =
                new NoViableAltException("", 187, 0, input);

            throw nvae;

        }

        switch (alt187) {
            case 1 :
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:910:11: {...}? IDENTIFIER
                {
                if ( !(( next("public") )) ) {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    throw new FailedPredicateException(input, "synpred64_ObjCpp", " next(\"public\") ");
                }

                match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred64_ObjCpp2264); if (state.failed) return ;

                }
                break;
            case 2 :
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:911:11: {...}? IDENTIFIER
                {
                if ( !(( next("private") )) ) {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    throw new FailedPredicateException(input, "synpred64_ObjCpp", " next(\"private\") ");
                }

                match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred64_ObjCpp2283); if (state.failed) return ;

                }
                break;
            case 3 :
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:912:11: {...}? IDENTIFIER
                {
                if ( !(( next("protected") )) ) {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    throw new FailedPredicateException(input, "synpred64_ObjCpp", " next(\"protected\") ");
                }

                match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred64_ObjCpp2302); if (state.failed) return ;

                }
                break;

        }


        match(input,51,FOLLOW_51_in_synpred64_ObjCpp2317); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred64_ObjCpp

    // $ANTLR start synpred65_ObjCpp
    public final void synpred65_ObjCpp_fragment() throws RecognitionException {
        ObjCppParser.declaration_return friendDecl =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:915:11: (friendDecl= declaration )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:915:11: friendDecl= declaration
        {
        pushFollow(FOLLOW_declaration_in_synpred65_ObjCpp2347);
        friendDecl=declaration();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred65_ObjCpp

    // $ANTLR start synpred66_ObjCpp
    public final void synpred66_ObjCpp_fragment() throws RecognitionException {
        ObjCppParser.declaration_return friendDecl =null;

        VariablesDeclaration friendVar =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:914:9: ({...}? IDENTIFIER (friendDecl= declaration |friendVar= varDecl SEMICOLON ) )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:914:9: {...}? IDENTIFIER (friendDecl= declaration |friendVar= varDecl SEMICOLON )
        {
        if ( !(( next("friend") )) ) {
            if (state.backtracking>0) {state.failed=true; return ;}
            throw new FailedPredicateException(input, "synpred66_ObjCpp", " next(\"friend\") ");
        }

        match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred66_ObjCpp2331); if (state.failed) return ;

        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:914:40: (friendDecl= declaration |friendVar= varDecl SEMICOLON )
        int alt188=2;
        alt188 = dfa188.predict(input);
        switch (alt188) {
            case 1 :
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:915:11: friendDecl= declaration
                {
                pushFollow(FOLLOW_declaration_in_synpred66_ObjCpp2347);
                friendDecl=declaration();

                state._fsp--;
                if (state.failed) return ;

                }
                break;
            case 2 :
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:918:11: friendVar= varDecl SEMICOLON
                {
                pushFollow(FOLLOW_varDecl_in_synpred66_ObjCpp2365);
                friendVar=varDecl();

                state._fsp--;
                if (state.failed) return ;

                match(input,SEMICOLON,FOLLOW_SEMICOLON_in_synpred66_ObjCpp2367); if (state.failed) return ;

                }
                break;

        }


        }

    }
    // $ANTLR end synpred66_ObjCpp

    // $ANTLR start synpred68_ObjCpp
    public final void synpred68_ObjCpp_fragment() throws RecognitionException {
        Token id=null;
        Template tp =null;

        ObjCppParser.functionDeclarationSuffix_return s =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:922:9: ( (tp= templatePrefix )? {...}?id= IDENTIFIER s= functionDeclarationSuffix )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:922:9: (tp= templatePrefix )? {...}?id= IDENTIFIER s= functionDeclarationSuffix
        {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:922:11: (tp= templatePrefix )?
        int alt189=2;
        switch ( input.LA(1) ) {
            case IDENTIFIER:
                {
                switch ( input.LA(2) ) {
                    case 53:
                        {
                        alt189=1;
                        }
                        break;
                }

                }
                break;
        }

        switch (alt189) {
            case 1 :
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:922:11: tp= templatePrefix
                {
                pushFollow(FOLLOW_templatePrefix_in_synpred68_ObjCpp2393);
                tp=templatePrefix();

                state._fsp--;
                if (state.failed) return ;

                }
                break;

        }


        if ( !(( next(getCurrentClassName()) )) ) {
            if (state.backtracking>0) {state.failed=true; return ;}
            throw new FailedPredicateException(input, "synpred68_ObjCpp", " next(getCurrentClassName()) ");
        }

        id=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred68_ObjCpp2408); if (state.failed) return ;

        pushFollow(FOLLOW_functionDeclarationSuffix_in_synpred68_ObjCpp2412);
        s=functionDeclarationSuffix();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred68_ObjCpp

    // $ANTLR start synpred69_ObjCpp
    public final void synpred69_ObjCpp_fragment() throws RecognitionException {
        ObjCppParser.declaration_return decl =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:939:9: (decl= declaration )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:939:9: decl= declaration
        {
        pushFollow(FOLLOW_declaration_in_synpred69_ObjCpp2428);
        decl=declaration();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred69_ObjCpp

    // $ANTLR start synpred70_ObjCpp
    public final void synpred70_ObjCpp_fragment() throws RecognitionException {
        VariablesDeclaration fv =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:942:9: (fv= varDecl SEMICOLON )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:942:9: fv= varDecl SEMICOLON
        {
        pushFollow(FOLLOW_varDecl_in_synpred70_ObjCpp2444);
        fv=varDecl();

        state._fsp--;
        if (state.failed) return ;

        match(input,SEMICOLON,FOLLOW_SEMICOLON_in_synpred70_ObjCpp2446); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred70_ObjCpp

    // $ANTLR start synpred74_ObjCpp
    public final void synpred74_ObjCpp_fragment() throws RecognitionException {
        List<Modifier> m1 =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:983:9: (m1= modifiers )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:983:9: m1= modifiers
        {
        pushFollow(FOLLOW_modifiers_in_synpred74_ObjCpp2563);
        m1=modifiers();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred74_ObjCpp

    // $ANTLR start synpred76_ObjCpp
    public final void synpred76_ObjCpp_fragment() throws RecognitionException {
        List<Modifier> m2 =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:995:15: (m2= modifiers )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:995:15: m2= modifiers
        {
        pushFollow(FOLLOW_modifiers_in_synpred76_ObjCpp2646);
        m2=modifiers();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred76_ObjCpp

    // $ANTLR start synpred77_ObjCpp
    public final void synpred77_ObjCpp_fragment() throws RecognitionException {
        Token p=null;

        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:998:17: ({...}?p= IDENTIFIER )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:998:17: {...}?p= IDENTIFIER
        {
        if ( !(( next("public", "private", "virtual") )) ) {
            if (state.backtracking>0) {state.failed=true; return ;}
            throw new FailedPredicateException(input, "synpred77_ObjCpp", " next(\"public\", \"private\", \"virtual\") ");
        }

        p=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred77_ObjCpp2703); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred77_ObjCpp

    // $ANTLR start synpred79_ObjCpp
    public final void synpred79_ObjCpp_fragment() throws RecognitionException {
        Token p=null;
        List<Modifier> m2 =null;

        Identifier parent =null;

        Struct nb =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:994:11: ( ( (m2= modifiers )? ( ':' ({...}?p= IDENTIFIER )? parent= qualifiedIdentifier )? nb= structBody ) )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:994:11: ( (m2= modifiers )? ( ':' ({...}?p= IDENTIFIER )? parent= qualifiedIdentifier )? nb= structBody )
        {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:994:11: ( (m2= modifiers )? ( ':' ({...}?p= IDENTIFIER )? parent= qualifiedIdentifier )? nb= structBody )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:995:13: (m2= modifiers )? ( ':' ({...}?p= IDENTIFIER )? parent= qualifiedIdentifier )? nb= structBody
        {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:995:13: (m2= modifiers )?
        int alt191=2;
        switch ( input.LA(1) ) {
            case IDENTIFIER:
            case 82:
            case 83:
                {
                alt191=1;
                }
                break;
        }

        switch (alt191) {
            case 1 :
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:995:15: m2= modifiers
                {
                pushFollow(FOLLOW_modifiers_in_synpred79_ObjCpp2646);
                m2=modifiers();

                state._fsp--;
                if (state.failed) return ;

                }
                break;

        }


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:996:13: ( ':' ({...}?p= IDENTIFIER )? parent= qualifiedIdentifier )?
        int alt193=2;
        switch ( input.LA(1) ) {
            case 51:
                {
                alt193=1;
                }
                break;
        }

        switch (alt193) {
            case 1 :
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:997:15: ':' ({...}?p= IDENTIFIER )? parent= qualifiedIdentifier
                {
                match(input,51,FOLLOW_51_in_synpred79_ObjCpp2681); if (state.failed) return ;

                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:998:15: ({...}?p= IDENTIFIER )?
                int alt192=2;
                switch ( input.LA(1) ) {
                    case IDENTIFIER:
                        {
                        switch ( input.LA(2) ) {
                            case 52:
                                {
                                int LA192_3 = input.LA(3);

                                if ( (((( next("public", "private", "virtual") )&&( next("public", "private", "virtual") ))&&synpred77_ObjCpp())) ) {
                                    alt192=1;
                                }
                                }
                                break;
                            case IDENTIFIER:
                                {
                                alt192=1;
                                }
                                break;
                        }

                        }
                        break;
                }

                switch (alt192) {
                    case 1 :
                        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:998:17: {...}?p= IDENTIFIER
                        {
                        if ( !(( next("public", "private", "virtual") )) ) {
                            if (state.backtracking>0) {state.failed=true; return ;}
                            throw new FailedPredicateException(input, "synpred79_ObjCpp", " next(\"public\", \"private\", \"virtual\") ");
                        }

                        p=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred79_ObjCpp2703); if (state.failed) return ;

                        }
                        break;

                }


                pushFollow(FOLLOW_qualifiedIdentifier_in_synpred79_ObjCpp2724);
                parent=qualifiedIdentifier();

                state._fsp--;
                if (state.failed) return ;

                }
                break;

        }


        pushFollow(FOLLOW_structBody_in_synpred79_ObjCpp2758);
        nb=structBody();

        state._fsp--;
        if (state.failed) return ;

        }


        }

    }
    // $ANTLR end synpred79_ObjCpp

    // $ANTLR start synpred80_ObjCpp
    public final void synpred80_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1021:6: ( binaryOp )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1021:6: binaryOp
        {
        pushFollow(FOLLOW_binaryOp_in_synpred80_ObjCpp2823);
        binaryOp();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred80_ObjCpp

    // $ANTLR start synpred81_ObjCpp
    public final void synpred81_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1022:5: ( unaryOp )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1022:5: unaryOp
        {
        pushFollow(FOLLOW_unaryOp_in_synpred81_ObjCpp2834);
        unaryOp();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred81_ObjCpp

    // $ANTLR start synpred82_ObjCpp
    public final void synpred82_ObjCpp_fragment() throws RecognitionException {
        List<Modifier> castPreMods =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1043:9: (castPreMods= modifiers )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1043:9: castPreMods= modifiers
        {
        pushFollow(FOLLOW_modifiers_in_synpred82_ObjCpp2917);
        castPreMods=modifiers();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred82_ObjCpp

    // $ANTLR start synpred83_ObjCpp
    public final void synpred83_ObjCpp_fragment() throws RecognitionException {
        List<Modifier> castPreMods =null;

        TypeRef castTypeRef =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1039:7: ({...}? => IDENTIFIER (castPreMods= modifiers )? castTypeRef= mutableTypeRef )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1039:7: {...}? => IDENTIFIER (castPreMods= modifiers )? castTypeRef= mutableTypeRef
        {
        if ( !(( next("operator") )) ) {
            if (state.backtracking>0) {state.failed=true; return ;}
            throw new FailedPredicateException(input, "synpred83_ObjCpp", " next(\"operator\") ");
        }

        match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred83_ObjCpp2902); if (state.failed) return ;

        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1043:7: (castPreMods= modifiers )?
        int alt194=2;
        switch ( input.LA(1) ) {
            case IDENTIFIER:
                {
                int LA194_1 = input.LA(2);

                if ( (((synpred82_ObjCpp()&&synpred82_ObjCpp())&&(( next("extern") )||( next("__pragma") )||( parseModifier(next()) != null )||( next("__asm") )||( next("__success") )||( next(ModifierKind.VCAnnotation1Arg, ModifierKind.VCAnnotation2Args) )))) ) {
                    alt194=1;
                }
                }
                break;
            case 82:
            case 83:
                {
                switch ( input.LA(2) ) {
                    case LPAREN:
                        {
                        int LA194_28 = input.LA(3);

                        if ( (synpred82_ObjCpp()) ) {
                            alt194=1;
                        }
                        }
                        break;
                }

                }
                break;
        }

        switch (alt194) {
            case 1 :
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1043:9: castPreMods= modifiers
                {
                pushFollow(FOLLOW_modifiers_in_synpred83_ObjCpp2917);
                castPreMods=modifiers();

                state._fsp--;
                if (state.failed) return ;

                }
                break;

        }


        pushFollow(FOLLOW_mutableTypeRef_in_synpred83_ObjCpp2932);
        castTypeRef=mutableTypeRef();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred83_ObjCpp

    // $ANTLR start synpred84_ObjCpp
    public final void synpred84_ObjCpp_fragment() throws RecognitionException {
        List<Modifier> preMods1 =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1047:9: (preMods1= modifiers )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1047:9: preMods1= modifiers
        {
        pushFollow(FOLLOW_modifiers_in_synpred84_ObjCpp2948);
        preMods1=modifiers();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred84_ObjCpp

    // $ANTLR start synpred85_ObjCpp
    public final void synpred85_ObjCpp_fragment() throws RecognitionException {
        List<Modifier> preMods2 =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1051:9: (preMods2= modifiers )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1051:9: preMods2= modifiers
        {
        pushFollow(FOLLOW_modifiers_in_synpred85_ObjCpp2977);
        preMods2=modifiers();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred85_ObjCpp

    // $ANTLR start synpred86_ObjCpp
    public final void synpred86_ObjCpp_fragment() throws RecognitionException {
        List<Modifier> postMods =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1078:7: (postMods= modifiers )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1078:7: postMods= modifiers
        {
        pushFollow(FOLLOW_modifiers_in_synpred86_ObjCpp3052);
        postMods=modifiers();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred86_ObjCpp

    // $ANTLR start synpred88_ObjCpp
    public final void synpred88_ObjCpp_fragment() throws RecognitionException {
        TypeRef t1 =null;

        TypeRef tx =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1085:11: (t1= mutableTypeRef ( COMMA tx= mutableTypeRef )* )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1085:11: t1= mutableTypeRef ( COMMA tx= mutableTypeRef )*
        {
        pushFollow(FOLLOW_mutableTypeRef_in_synpred88_ObjCpp3107);
        t1=mutableTypeRef();

        state._fsp--;
        if (state.failed) return ;

        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1088:11: ( COMMA tx= mutableTypeRef )*
        loop195:
        do {
            int alt195=2;
            switch ( input.LA(1) ) {
            case COMMA:
                {
                alt195=1;
                }
                break;

            }

            switch (alt195) {
        	case 1 :
        	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1089:13: COMMA tx= mutableTypeRef
        	    {
        	    match(input,COMMA,FOLLOW_COMMA_in_synpred88_ObjCpp3135); if (state.failed) return ;

        	    pushFollow(FOLLOW_mutableTypeRef_in_synpred88_ObjCpp3151);
        	    tx=mutableTypeRef();

        	    state._fsp--;
        	    if (state.failed) return ;

        	    }
        	    break;

        	default :
        	    break loop195;
            }
        } while (true);


        }

    }
    // $ANTLR end synpred88_ObjCpp

    // $ANTLR start synpred95_ObjCpp
    public final void synpred95_ObjCpp_fragment() throws RecognitionException {
        ObjCppParser.modifier_return x =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1130:7: (x= modifier )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1130:7: x= modifier
        {
        pushFollow(FOLLOW_modifier_in_synpred95_ObjCpp3440);
        x=modifier();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred95_ObjCpp

    // $ANTLR start synpred105_ObjCpp
    public final void synpred105_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1142:7: ( SEMICOLON )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1142:7: SEMICOLON
        {
        match(input,SEMICOLON,FOLLOW_SEMICOLON_in_synpred105_ObjCpp3548); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred105_ObjCpp

    // $ANTLR start synpred106_ObjCpp
    public final void synpred106_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1150:5: ({...}? => pragmaContent )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1150:5: {...}? => pragmaContent
        {
        if ( !(( next("__pragma") )) ) {
            if (state.backtracking>0) {state.failed=true; return ;}
            throw new FailedPredicateException(input, "synpred106_ObjCpp", " next(\"__pragma\") ");
        }

        pushFollow(FOLLOW_pragmaContent_in_synpred106_ObjCpp3588);
        pragmaContent();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred106_ObjCpp

    // $ANTLR start synpred107_ObjCpp
    public final void synpred107_ObjCpp_fragment() throws RecognitionException {
        Token ex=null;

        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1151:5: ({...}? => IDENTIFIER ex= STRING )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1151:5: {...}? => IDENTIFIER ex= STRING
        {
        if ( !(( next("extern") )) ) {
            if (state.backtracking>0) {state.failed=true; return ;}
            throw new FailedPredicateException(input, "synpred107_ObjCpp", " next(\"extern\") ");
        }

        match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred107_ObjCpp3600); if (state.failed) return ;

        ex=(Token)match(input,STRING,FOLLOW_STRING_in_synpred107_ObjCpp3604); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred107_ObjCpp

    // $ANTLR start synpred108_ObjCpp
    public final void synpred108_ObjCpp_fragment() throws RecognitionException {
        Token m=null;

        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1154:5: ({...}?m= IDENTIFIER )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1154:5: {...}?m= IDENTIFIER
        {
        if ( !(( parseModifier(next()) != null )) ) {
            if (state.backtracking>0) {state.failed=true; return ;}
            throw new FailedPredicateException(input, "synpred108_ObjCpp", " parseModifier(next()) != null ");
        }

        m=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred108_ObjCpp3618); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred108_ObjCpp

    // $ANTLR start synpred113_ObjCpp
    public final void synpred113_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1171:8: ( RPAREN )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1171:8: RPAREN
        {
        match(input,RPAREN,FOLLOW_RPAREN_in_synpred113_ObjCpp3732); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred113_ObjCpp

    // $ANTLR start synpred116_ObjCpp
    public final void synpred116_ObjCpp_fragment() throws RecognitionException {
        Token an=null;

        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1172:5: ({...}? => IDENTIFIER LPAREN (an= STRING )+ RPAREN )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1172:5: {...}? => IDENTIFIER LPAREN (an= STRING )+ RPAREN
        {
        if ( !(( next("__asm") )) ) {
            if (state.backtracking>0) {state.failed=true; return ;}
            throw new FailedPredicateException(input, "synpred116_ObjCpp", " next(\"__asm\") ");
        }

        match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred116_ObjCpp3744); if (state.failed) return ;

        match(input,LPAREN,FOLLOW_LPAREN_in_synpred116_ObjCpp3746); if (state.failed) return ;

        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1172:44: (an= STRING )+
        int cnt206=0;
        loop206:
        do {
            int alt206=2;
            switch ( input.LA(1) ) {
            case STRING:
                {
                alt206=1;
                }
                break;

            }

            switch (alt206) {
        	case 1 :
        	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1173:7: an= STRING
        	    {
        	    an=(Token)match(input,STRING,FOLLOW_STRING_in_synpred116_ObjCpp3759); if (state.failed) return ;

        	    }
        	    break;

        	default :
        	    if ( cnt206 >= 1 ) break loop206;
        	    if (state.backtracking>0) {state.failed=true; return ;}
                    EarlyExitException eee =
                        new EarlyExitException(206, input);
                    throw eee;
            }
            cnt206++;
        } while (true);


        match(input,RPAREN,FOLLOW_RPAREN_in_synpred116_ObjCpp3771); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred116_ObjCpp

    // $ANTLR start synpred117_ObjCpp
    public final void synpred117_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1181:5: ({...}? => IDENTIFIER LPAREN 'return' binaryOp expression RPAREN )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1181:5: {...}? => IDENTIFIER LPAREN 'return' binaryOp expression RPAREN
        {
        if ( !(( next("__success") )) ) {
            if (state.backtracking>0) {state.failed=true; return ;}
            throw new FailedPredicateException(input, "synpred117_ObjCpp", " next(\"__success\") ");
        }

        match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred117_ObjCpp3786); if (state.failed) return ;

        match(input,LPAREN,FOLLOW_LPAREN_in_synpred117_ObjCpp3788); if (state.failed) return ;

        match(input,93,FOLLOW_93_in_synpred117_ObjCpp3790); if (state.failed) return ;

        pushFollow(FOLLOW_binaryOp_in_synpred117_ObjCpp3792);
        binaryOp();

        state._fsp--;
        if (state.failed) return ;

        pushFollow(FOLLOW_expression_in_synpred117_ObjCpp3794);
        expression();

        state._fsp--;
        if (state.failed) return ;

        match(input,RPAREN,FOLLOW_RPAREN_in_synpred117_ObjCpp3797); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred117_ObjCpp

    // $ANTLR start synpred120_ObjCpp
    public final void synpred120_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1223:7: ( declarator )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1223:7: declarator
        {
        pushFollow(FOLLOW_declarator_in_synpred120_ObjCpp3985);
        declarator();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred120_ObjCpp

    // $ANTLR start synpred121_ObjCpp
    public final void synpred121_ObjCpp_fragment() throws RecognitionException {
        ObjCppParser.topLevelExpr_return dv =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1232:7: ( '=' dv= topLevelExpr )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1232:7: '=' dv= topLevelExpr
        {
        match(input,57,FOLLOW_57_in_synpred121_ObjCpp4008); if (state.failed) return ;

        pushFollow(FOLLOW_topLevelExpr_in_synpred121_ObjCpp4012);
        dv=topLevelExpr();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred121_ObjCpp

    // $ANTLR start synpred122_ObjCpp
    public final void synpred122_ObjCpp_fragment() throws RecognitionException {
        TypeRef tr =null;

        ObjCppParser.topLevelExpr_return dv =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1211:6: ( (tr= mutableTypeRef ) ( declarator )? ( '=' dv= topLevelExpr )? )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1211:6: (tr= mutableTypeRef ) ( declarator )? ( '=' dv= topLevelExpr )?
        {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1211:6: (tr= mutableTypeRef )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1212:7: tr= mutableTypeRef
        {
        pushFollow(FOLLOW_mutableTypeRef_in_synpred122_ObjCpp3963);
        tr=mutableTypeRef();

        state._fsp--;
        if (state.failed) return ;

        }


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1222:5: ( declarator )?
        int alt208=2;
        switch ( input.LA(1) ) {
            case IDENTIFIER:
            case LPAREN:
            case 36:
            case 38:
            case 51:
            case 80:
            case 82:
            case 83:
                {
                alt208=1;
                }
                break;
        }

        switch (alt208) {
            case 1 :
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1223:7: declarator
                {
                pushFollow(FOLLOW_declarator_in_synpred122_ObjCpp3985);
                declarator();

                state._fsp--;
                if (state.failed) return ;

                }
                break;

        }


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1232:5: ( '=' dv= topLevelExpr )?
        int alt209=2;
        switch ( input.LA(1) ) {
            case 57:
                {
                alt209=1;
                }
                break;
        }

        switch (alt209) {
            case 1 :
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1232:7: '=' dv= topLevelExpr
                {
                match(input,57,FOLLOW_57_in_synpred122_ObjCpp4008); if (state.failed) return ;

                pushFollow(FOLLOW_topLevelExpr_in_synpred122_ObjCpp4012);
                dv=topLevelExpr();

                state._fsp--;
                if (state.failed) return ;

                }
                break;

        }


        }

    }
    // $ANTLR end synpred122_ObjCpp

    // $ANTLR start synpred123_ObjCpp
    public final void synpred123_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1244:5: ({...}? => IDENTIFIER )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1244:5: {...}? => IDENTIFIER
        {
        if ( !(( next("const", "__const") )) ) {
            if (state.backtracking>0) {state.failed=true; return ;}
            throw new FailedPredicateException(input, "synpred123_ObjCpp", " next(\"const\", \"__const\") ");
        }

        match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred123_ObjCpp4059); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred123_ObjCpp

    // $ANTLR start synpred129_ObjCpp
    public final void synpred129_ObjCpp_fragment() throws RecognitionException {
        Arg t1 =null;

        Arg tx =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1276:7: (t1= templateArgDecl ( COMMA tx= templateArgDecl )* )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1276:7: t1= templateArgDecl ( COMMA tx= templateArgDecl )*
        {
        pushFollow(FOLLOW_templateArgDecl_in_synpred129_ObjCpp4209);
        t1=templateArgDecl();

        state._fsp--;
        if (state.failed) return ;

        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1279:7: ( COMMA tx= templateArgDecl )*
        loop210:
        do {
            int alt210=2;
            switch ( input.LA(1) ) {
            case COMMA:
                {
                alt210=1;
                }
                break;

            }

            switch (alt210) {
        	case 1 :
        	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1280:9: COMMA tx= templateArgDecl
        	    {
        	    match(input,COMMA,FOLLOW_COMMA_in_synpred129_ObjCpp4229); if (state.failed) return ;

        	    pushFollow(FOLLOW_templateArgDecl_in_synpred129_ObjCpp4233);
        	    tx=templateArgDecl();

        	    state._fsp--;
        	    if (state.failed) return ;

        	    }
        	    break;

        	default :
        	    break loop210;
            }
        } while (true);


        }

    }
    // $ANTLR end synpred129_ObjCpp

    // $ANTLR start synpred132_ObjCpp
    public final void synpred132_ObjCpp_fragment() throws RecognitionException {
        Token t=null;
        Token n=null;
        TypeRef tr =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1289:6: (t= ( 'class' | 'typename' ) n= IDENTIFIER ( '=' tr= mutableTypeRef )? )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1289:6: t= ( 'class' | 'typename' ) n= IDENTIFIER ( '=' tr= mutableTypeRef )?
        {
        t=(Token)input.LT(1);

        if ( input.LA(1)==86||input.LA(1)==97 ) {
            input.consume();
            state.errorRecovery=false;
            state.failed=false;
        }
        else {
            if (state.backtracking>0) {state.failed=true; return ;}
            MismatchedSetException mse = new MismatchedSetException(null,input);
            throw mse;
        }


        n=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred132_ObjCpp4291); if (state.failed) return ;

        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1293:5: ( '=' tr= mutableTypeRef )?
        int alt211=2;
        switch ( input.LA(1) ) {
            case 57:
                {
                alt211=1;
                }
                break;
        }

        switch (alt211) {
            case 1 :
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1294:7: '=' tr= mutableTypeRef
                {
                match(input,57,FOLLOW_57_in_synpred132_ObjCpp4309); if (state.failed) return ;

                pushFollow(FOLLOW_mutableTypeRef_in_synpred132_ObjCpp4313);
                tr=mutableTypeRef();

                state._fsp--;
                if (state.failed) return ;

                }
                break;

        }


        }

    }
    // $ANTLR end synpred132_ObjCpp

    // $ANTLR start synpred134_ObjCpp
    public final void synpred134_ObjCpp_fragment() throws RecognitionException {
        List<Modifier> m1 =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1314:7: (m1= modifiers )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1314:7: m1= modifiers
        {
        pushFollow(FOLLOW_modifiers_in_synpred134_ObjCpp4405);
        m1=modifiers();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred134_ObjCpp

    // $ANTLR start synpred136_ObjCpp
    public final void synpred136_ObjCpp_fragment() throws RecognitionException {
        List<Modifier> m2 =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1325:9: (m2= modifiers )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1325:9: m2= modifiers
        {
        pushFollow(FOLLOW_modifiers_in_synpred136_ObjCpp4458);
        m2=modifiers();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred136_ObjCpp

    // $ANTLR start synpred140_ObjCpp
    public final void synpred140_ObjCpp_fragment() throws RecognitionException {
        ObjCppParser.argDef_return a1 =null;

        ObjCppParser.argDef_return ax =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1337:7: (a1= argDef ( COMMA ax= argDef )* )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1337:7: a1= argDef ( COMMA ax= argDef )*
        {
        pushFollow(FOLLOW_argDef_in_synpred140_ObjCpp4525);
        a1=argDef();

        state._fsp--;
        if (state.failed) return ;

        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1341:7: ( COMMA ax= argDef )*
        loop213:
        do {
            int alt213=2;
            switch ( input.LA(1) ) {
            case COMMA:
                {
                alt213=1;
                }
                break;

            }

            switch (alt213) {
        	case 1 :
        	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1342:9: COMMA ax= argDef
        	    {
        	    match(input,COMMA,FOLLOW_COMMA_in_synpred140_ObjCpp4545); if (state.failed) return ;

        	    pushFollow(FOLLOW_argDef_in_synpred140_ObjCpp4558);
        	    ax=argDef();

        	    state._fsp--;
        	    if (state.failed) return ;

        	    }
        	    break;

        	default :
        	    break loop213;
            }
        } while (true);


        }

    }
    // $ANTLR end synpred140_ObjCpp

    // $ANTLR start synpred141_ObjCpp
    public final void synpred141_ObjCpp_fragment() throws RecognitionException {
        TypeMutator m1 =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1382:7: ( (m1= typeMutator ) )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1382:7: (m1= typeMutator )
        {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1382:7: (m1= typeMutator )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1383:9: m1= typeMutator
        {
        pushFollow(FOLLOW_typeMutator_in_synpred141_ObjCpp4657);
        m1=typeMutator();

        state._fsp--;
        if (state.failed) return ;

        }


        }

    }
    // $ANTLR end synpred141_ObjCpp

    // $ANTLR start synpred142_ObjCpp
    public final void synpred142_ObjCpp_fragment() throws RecognitionException {
        Token m=null;

        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1387:7: ( ({...}?m= IDENTIFIER ) )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1387:7: ({...}?m= IDENTIFIER )
        {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1387:7: ({...}?m= IDENTIFIER )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1387:9: {...}?m= IDENTIFIER
        {
        if ( !(( next(ModifierKind.StorageClassSpecifier) )) ) {
            if (state.backtracking>0) {state.failed=true; return ;}
            throw new FailedPredicateException(input, "synpred142_ObjCpp", " next(ModifierKind.StorageClassSpecifier) ");
        }

        m=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred142_ObjCpp4683); if (state.failed) return ;

        }


        }

    }
    // $ANTLR end synpred142_ObjCpp

    // $ANTLR start synpred143_ObjCpp
    public final void synpred143_ObjCpp_fragment() throws RecognitionException {
        ObjCppParser.functionSignatureSuffix_return f1 =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1390:7: ( (f1= functionSignatureSuffix ) )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1390:7: (f1= functionSignatureSuffix )
        {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1390:7: (f1= functionSignatureSuffix )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1391:9: f1= functionSignatureSuffix
        {
        pushFollow(FOLLOW_functionSignatureSuffix_in_synpred143_ObjCpp4708);
        f1=functionSignatureSuffix();

        state._fsp--;
        if (state.failed) return ;

        }


        }

    }
    // $ANTLR end synpred143_ObjCpp

    // $ANTLR start synpred144_ObjCpp
    public final void synpred144_ObjCpp_fragment() throws RecognitionException {
        List<Modifier> m =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1407:6: (m= modifiers )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1407:6: m= modifiers
        {
        pushFollow(FOLLOW_modifiers_in_synpred144_ObjCpp4749);
        m=modifiers();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred144_ObjCpp

    // $ANTLR start synpred148_ObjCpp
    public final void synpred148_ObjCpp_fragment() throws RecognitionException {
        Token bits=null;

        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1425:11: ( ':' bits= DECIMAL_NUMBER )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1425:11: ':' bits= DECIMAL_NUMBER
        {
        match(input,51,FOLLOW_51_in_synpred148_ObjCpp4920); if (state.failed) return ;

        bits=(Token)match(input,DECIMAL_NUMBER,FOLLOW_DECIMAL_NUMBER_in_synpred148_ObjCpp4924); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred148_ObjCpp

    // $ANTLR start synpred150_ObjCpp
    public final void synpred150_ObjCpp_fragment() throws RecognitionException {
        List<Declarator> d1 =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1472:7: (d1= declaratorsList )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1472:7: d1= declaratorsList
        {
        pushFollow(FOLLOW_declaratorsList_in_synpred150_ObjCpp5100);
        d1=declaratorsList();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred150_ObjCpp

    // $ANTLR start synpred154_ObjCpp
    public final void synpred154_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1517:7: ({...}? => IDENTIFIER )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1517:7: {...}? => IDENTIFIER
        {
        if ( !(( parseModifier(next()) == null )) ) {
            if (state.backtracking>0) {state.failed=true; return ;}
            throw new FailedPredicateException(input, "synpred154_ObjCpp", " parseModifier(next()) == null ");
        }

        match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred154_ObjCpp5323); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred154_ObjCpp

    // $ANTLR start synpred158_ObjCpp
    public final void synpred158_ObjCpp_fragment() throws RecognitionException {
        ObjCppParser.argDef_return ax =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1563:9: ( COMMA ax= argDef )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1563:9: COMMA ax= argDef
        {
        match(input,COMMA,FOLLOW_COMMA_in_synpred158_ObjCpp5547); if (state.failed) return ;

        pushFollow(FOLLOW_argDef_in_synpred158_ObjCpp5560);
        ax=argDef();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred158_ObjCpp

    // $ANTLR start synpred160_ObjCpp
    public final void synpred160_ObjCpp_fragment() throws RecognitionException {
        ObjCppParser.argDef_return a1 =null;

        ObjCppParser.argDef_return ax =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1558:7: (a1= argDef ( COMMA ax= argDef )* ( COMMA '...' )? )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1558:7: a1= argDef ( COMMA ax= argDef )* ( COMMA '...' )?
        {
        pushFollow(FOLLOW_argDef_in_synpred160_ObjCpp5527);
        a1=argDef();

        state._fsp--;
        if (state.failed) return ;

        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1562:7: ( COMMA ax= argDef )*
        loop217:
        do {
            int alt217=2;
            switch ( input.LA(1) ) {
            case COMMA:
                {
                switch ( input.LA(2) ) {
                case 48:
                    {
                    int LA217_3 = input.LA(3);

                    if ( (synpred158_ObjCpp()) ) {
                        alt217=1;
                    }


                    }
                    break;
                case EOF:
                case COMMA:
                case IDENTIFIER:
                case LPAREN:
                case 36:
                case 38:
                case 51:
                case 52:
                case 57:
                case 78:
                case 80:
                case 82:
                case 83:
                case 86:
                case 89:
                case 94:
                case 97:
                case 98:
                    {
                    alt217=1;
                    }
                    break;

                }

                }
                break;

            }

            switch (alt217) {
        	case 1 :
        	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1563:9: COMMA ax= argDef
        	    {
        	    match(input,COMMA,FOLLOW_COMMA_in_synpred160_ObjCpp5547); if (state.failed) return ;

        	    pushFollow(FOLLOW_argDef_in_synpred160_ObjCpp5560);
        	    ax=argDef();

        	    state._fsp--;
        	    if (state.failed) return ;

        	    }
        	    break;

        	default :
        	    break loop217;
            }
        } while (true);


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1568:7: ( COMMA '...' )?
        int alt218=2;
        switch ( input.LA(1) ) {
            case COMMA:
                {
                alt218=1;
                }
                break;
        }

        switch (alt218) {
            case 1 :
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1569:9: COMMA '...'
                {
                match(input,COMMA,FOLLOW_COMMA_in_synpred160_ObjCpp5590); if (state.failed) return ;

                match(input,48,FOLLOW_48_in_synpred160_ObjCpp5592); if (state.failed) return ;

                }
                break;

        }


        }

    }
    // $ANTLR end synpred160_ObjCpp

    // $ANTLR start synpred161_ObjCpp
    public final void synpred161_ObjCpp_fragment() throws RecognitionException {
        List<Modifier> preMods =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1595:7: (preMods= modifiers )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1595:7: preMods= modifiers
        {
        pushFollow(FOLLOW_modifiers_in_synpred161_ObjCpp5658);
        preMods=modifiers();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred161_ObjCpp

    // $ANTLR start synpred162_ObjCpp
    public final void synpred162_ObjCpp_fragment() throws RecognitionException {
        Token i=null;

        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1606:7: ({...}? =>i= IDENTIFIER )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1606:7: {...}? =>i= IDENTIFIER
        {
        if ( !(( next("va_list", "__gnuc_va_list", "__builtin_va_list") )) ) {
            if (state.backtracking>0) {state.failed=true; return ;}
            throw new FailedPredicateException(input, "synpred162_ObjCpp", " next(\"va_list\", \"__gnuc_va_list\", \"__builtin_va_list\") ");
        }

        i=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred162_ObjCpp5682); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred162_ObjCpp

    // $ANTLR start synpred164_ObjCpp
    public final void synpred164_ObjCpp_fragment() throws RecognitionException {
        TypeRef an =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1610:7: ({...}? =>an= typeName )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1610:7: {...}? =>an= typeName
        {
        if ( !(( 
                next(2, "<") ||
                isTypeIdentifier(next()) || 
                (
                  parseModifier(next(1)) == null &&
                  //(isTypeDef() || !next(2, "=", ",", ";", ":", "[", "(", ")"))
                  !next(2, "=", ",", ";", ":", "[", "(", ")")
                ) 
              )) ) {
            if (state.backtracking>0) {state.failed=true; return ;}
            throw new FailedPredicateException(input, "synpred164_ObjCpp", " \n        next(2, \"<\") ||\n        isTypeIdentifier(next()) || \n        (\n          parseModifier(next(1)) == null &&\n          //(isTypeDef() || !next(2, \"=\", \",\", \";\", \":\", \"[\", \"(\", \")\"))\n          !next(2, \"=\", \",\", \";\", \":\", \"[\", \"(\", \")\")\n        ) \n      ");
        }

        pushFollow(FOLLOW_typeName_in_synpred164_ObjCpp5715);
        an=typeName();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred164_ObjCpp

    // $ANTLR start synpred167_ObjCpp
    public final void synpred167_ObjCpp_fragment() throws RecognitionException {
        List<Modifier> postMods =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1622:7: (postMods= modifiers )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1622:7: postMods= modifiers
        {
        pushFollow(FOLLOW_modifiers_in_synpred167_ObjCpp5758);
        postMods=modifiers();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred167_ObjCpp

    // $ANTLR start synpred169_ObjCpp
    public final void synpred169_ObjCpp_fragment() throws RecognitionException {
        TypeRef an =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1647:5: ({...}? =>an= typeName )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1647:5: {...}? =>an= typeName
        {
        if ( !(( 
              isTypeIdentifier(next()) || 
              (
                parseModifier(next(1)) == null && 
                !next(2, "=", ",", ";", ":", "[", "(", ")")
              ) 
            )) ) {
            if (state.backtracking>0) {state.failed=true; return ;}
            throw new FailedPredicateException(input, "synpred169_ObjCpp", " \n      isTypeIdentifier(next()) || \n      (\n        parseModifier(next(1)) == null && \n        !next(2, \"=\", \",\", \";\", \":\", \"[\", \"(\", \")\")\n      ) \n    ");
        }

        pushFollow(FOLLOW_typeName_in_synpred169_ObjCpp5812);
        an=typeName();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred169_ObjCpp

    // $ANTLR start synpred192_ObjCpp
    public final void synpred192_ObjCpp_fragment() throws RecognitionException {
        TypeRef tr =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1715:6: (tr= mutableTypeRef )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1715:6: tr= mutableTypeRef
        {
        pushFollow(FOLLOW_mutableTypeRef_in_synpred192_ObjCpp6141);
        tr=mutableTypeRef();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred192_ObjCpp

    // $ANTLR start synpred194_ObjCpp
    public final void synpred194_ObjCpp_fragment() throws RecognitionException {
        Expression a1 =null;

        Expression ax =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1727:9: (a1= typeRefOrExpression ( COMMA ax= typeRefOrExpression )* )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1727:9: a1= typeRefOrExpression ( COMMA ax= typeRefOrExpression )*
        {
        pushFollow(FOLLOW_typeRefOrExpression_in_synpred194_ObjCpp6206);
        a1=typeRefOrExpression();

        state._fsp--;
        if (state.failed) return ;

        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1728:9: ( COMMA ax= typeRefOrExpression )*
        loop220:
        do {
            int alt220=2;
            switch ( input.LA(1) ) {
            case COMMA:
                {
                alt220=1;
                }
                break;

            }

            switch (alt220) {
        	case 1 :
        	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1729:11: COMMA ax= typeRefOrExpression
        	    {
        	    match(input,COMMA,FOLLOW_COMMA_in_synpred194_ObjCpp6230); if (state.failed) return ;

        	    pushFollow(FOLLOW_typeRefOrExpression_in_synpred194_ObjCpp6245);
        	    ax=typeRefOrExpression();

        	    state._fsp--;
        	    if (state.failed) return ;

        	    }
        	    break;

        	default :
        	    break loop220;
            }
        } while (true);


        }

    }
    // $ANTLR end synpred194_ObjCpp

    // $ANTLR start synpred195_ObjCpp
    public final void synpred195_ObjCpp_fragment() throws RecognitionException {
        Expression a1 =null;

        Expression ax =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1726:7: ( '<' (a1= typeRefOrExpression ( COMMA ax= typeRefOrExpression )* )? '>' )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1726:7: '<' (a1= typeRefOrExpression ( COMMA ax= typeRefOrExpression )* )? '>'
        {
        match(input,53,FOLLOW_53_in_synpred195_ObjCpp6192); if (state.failed) return ;

        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1726:11: (a1= typeRefOrExpression ( COMMA ax= typeRefOrExpression )* )?
        int alt222=2;
        switch ( input.LA(1) ) {
            case CHARACTER:
            case COMMA:
            case DECIMAL_NUMBER:
            case FLOAT_NUMBER:
            case HEXADECIMAL_NUMBER:
            case IDENTIFIER:
            case LBRACE:
            case LPAREN:
            case OCTAL_NUMBER:
            case STRING:
            case 30:
            case 36:
            case 38:
            case 40:
            case 41:
            case 43:
            case 44:
            case 52:
            case 66:
            case 74:
            case 77:
            case 78:
            case 80:
            case 82:
            case 83:
            case 86:
            case 89:
            case 94:
            case 97:
            case 98:
            case 103:
                {
                alt222=1;
                }
                break;
            case 59:
                {
                int LA222_13 = input.LA(2);

                if ( (synpred194_ObjCpp()) ) {
                    alt222=1;
                }
                }
                break;
        }

        switch (alt222) {
            case 1 :
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1727:9: a1= typeRefOrExpression ( COMMA ax= typeRefOrExpression )*
                {
                pushFollow(FOLLOW_typeRefOrExpression_in_synpred195_ObjCpp6206);
                a1=typeRefOrExpression();

                state._fsp--;
                if (state.failed) return ;

                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1728:9: ( COMMA ax= typeRefOrExpression )*
                loop221:
                do {
                    int alt221=2;
                    switch ( input.LA(1) ) {
                    case COMMA:
                        {
                        alt221=1;
                        }
                        break;

                    }

                    switch (alt221) {
                	case 1 :
                	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1729:11: COMMA ax= typeRefOrExpression
                	    {
                	    match(input,COMMA,FOLLOW_COMMA_in_synpred195_ObjCpp6230); if (state.failed) return ;

                	    pushFollow(FOLLOW_typeRefOrExpression_in_synpred195_ObjCpp6245);
                	    ax=typeRefOrExpression();

                	    state._fsp--;
                	    if (state.failed) return ;

                	    }
                	    break;

                	default :
                	    break loop221;
                    }
                } while (true);


                }
                break;

        }


        match(input,59,FOLLOW_59_in_synpred195_ObjCpp6271); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred195_ObjCpp

    // $ANTLR start synpred199_ObjCpp
    public final void synpred199_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1756:5: ( unaryOp )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1756:5: unaryOp
        {
        pushFollow(FOLLOW_unaryOp_in_synpred199_ObjCpp6413);
        unaryOp();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred199_ObjCpp

    // $ANTLR start synpred200_ObjCpp
    public final void synpred200_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1757:5: ( postfixOp )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1757:5: postfixOp
        {
        pushFollow(FOLLOW_postfixOp_in_synpred200_ObjCpp6424);
        postfixOp();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred200_ObjCpp

    // $ANTLR start synpred201_ObjCpp
    public final void synpred201_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1758:5: ( binaryOp )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1758:5: binaryOp
        {
        pushFollow(FOLLOW_binaryOp_in_synpred201_ObjCpp6435);
        binaryOp();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred201_ObjCpp

    // $ANTLR start synpred202_ObjCpp
    public final void synpred202_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1759:5: ( assignmentOp )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1759:5: assignmentOp
        {
        pushFollow(FOLLOW_assignmentOp_in_synpred202_ObjCpp6446);
        assignmentOp();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred202_ObjCpp

    // $ANTLR start synpred203_ObjCpp
    public final void synpred203_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1760:5: ( '=' )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1760:5: '='
        {
        match(input,57,FOLLOW_57_in_synpred203_ObjCpp6456); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred203_ObjCpp

    // $ANTLR start synpred208_ObjCpp
    public final void synpred208_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1770:5: ({...}? IDENTIFIER operator )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1770:5: {...}? IDENTIFIER operator
        {
        if ( !(( next("operator") )) ) {
            if (state.backtracking>0) {state.failed=true; return ;}
            throw new FailedPredicateException(input, "synpred208_ObjCpp", " next(\"operator\") ");
        }

        match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred208_ObjCpp6539); if (state.failed) return ;

        pushFollow(FOLLOW_operator_in_synpred208_ObjCpp6541);
        operator();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred208_ObjCpp

    // $ANTLR start synpred220_ObjCpp
    public final void synpred220_ObjCpp_fragment() throws RecognitionException {
        ObjCppParser.assignmentOp_return op =null;

        Expression f =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1845:7: (op= assignmentOp f= assignmentExpr )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1845:7: op= assignmentOp f= assignmentExpr
        {
        pushFollow(FOLLOW_assignmentOp_in_synpred220_ObjCpp6942);
        op=assignmentOp();

        state._fsp--;
        if (state.failed) return ;

        pushFollow(FOLLOW_assignmentExpr_in_synpred220_ObjCpp6946);
        f=assignmentExpr();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred220_ObjCpp

    // $ANTLR start synpred232_ObjCpp
    public final void synpred232_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1860:7: ( '?' logOrExpr ':' logOrExpr )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1860:7: '?' logOrExpr ':' logOrExpr
        {
        match(input,64,FOLLOW_64_in_synpred232_ObjCpp7063); if (state.failed) return ;

        pushFollow(FOLLOW_logOrExpr_in_synpred232_ObjCpp7071);
        logOrExpr();

        state._fsp--;
        if (state.failed) return ;

        match(input,51,FOLLOW_51_in_synpred232_ObjCpp7080); if (state.failed) return ;

        pushFollow(FOLLOW_logOrExpr_in_synpred232_ObjCpp7088);
        logOrExpr();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred232_ObjCpp

    // $ANTLR start synpred234_ObjCpp
    public final void synpred234_ObjCpp_fragment() throws RecognitionException {
        Token op=null;
        Expression f =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1870:7: (op= ( '+' | '-' ) f= multExpr )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1870:7: op= ( '+' | '-' ) f= multExpr
        {
        op=(Token)input.LT(1);

        if ( input.LA(1)==40||input.LA(1)==43 ) {
            input.consume();
            state.errorRecovery=false;
            state.failed=false;
        }
        else {
            if (state.backtracking>0) {state.failed=true; return ;}
            MismatchedSetException mse = new MismatchedSetException(null,input);
            throw mse;
        }


        pushFollow(FOLLOW_multExpr_in_synpred234_ObjCpp7149);
        f=multExpr();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred234_ObjCpp

    // $ANTLR start synpred237_ObjCpp
    public final void synpred237_ObjCpp_fragment() throws RecognitionException {
        Token op=null;
        Expression f =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1878:7: (op= ( '%' | '*' | '/' ) f= castExpr )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1878:7: op= ( '%' | '*' | '/' ) f= castExpr
        {
        op=(Token)input.LT(1);

        if ( input.LA(1)==33||input.LA(1)==38||input.LA(1)==49 ) {
            input.consume();
            state.errorRecovery=false;
            state.failed=false;
        }
        else {
            if (state.backtracking>0) {state.failed=true; return ;}
            MismatchedSetException mse = new MismatchedSetException(null,input);
            throw mse;
        }


        pushFollow(FOLLOW_castExpr_in_synpred237_ObjCpp7218);
        f=castExpr();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred237_ObjCpp

    // $ANTLR start synpred238_ObjCpp
    public final void synpred238_ObjCpp_fragment() throws RecognitionException {
        Token op=null;
        Expression f =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1886:7: (op= '|' f= xorExpr )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1886:7: op= '|' f= xorExpr
        {
        op=(Token)match(input,100,FOLLOW_100_in_synpred238_ObjCpp7266); if (state.failed) return ;

        pushFollow(FOLLOW_xorExpr_in_synpred238_ObjCpp7276);
        f=xorExpr();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred238_ObjCpp

    // $ANTLR start synpred239_ObjCpp
    public final void synpred239_ObjCpp_fragment() throws RecognitionException {
        Token op=null;
        Expression f =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1894:7: (op= '&' f= equalExpr )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1894:7: op= '&' f= equalExpr
        {
        op=(Token)match(input,36,FOLLOW_36_in_synpred239_ObjCpp7323); if (state.failed) return ;

        pushFollow(FOLLOW_equalExpr_in_synpred239_ObjCpp7333);
        f=equalExpr();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred239_ObjCpp

    // $ANTLR start synpred241_ObjCpp
    public final void synpred241_ObjCpp_fragment() throws RecognitionException {
        Token op=null;
        Expression f =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1903:7: (op= ( '>>' | '<<' ) f= addExpr )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1903:7: op= ( '>>' | '<<' ) f= addExpr
        {
        op=(Token)input.LT(1);

        if ( input.LA(1)==54||input.LA(1)==61 ) {
            input.consume();
            state.errorRecovery=false;
            state.failed=false;
        }
        else {
            if (state.backtracking>0) {state.failed=true; return ;}
            MismatchedSetException mse = new MismatchedSetException(null,input);
            throw mse;
        }


        pushFollow(FOLLOW_addExpr_in_synpred241_ObjCpp7397);
        f=addExpr();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred241_ObjCpp

    // $ANTLR start synpred242_ObjCpp
    public final void synpred242_ObjCpp_fragment() throws RecognitionException {
        Token op=null;
        Expression f =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1911:7: (op= '^' f= bitAndExpr )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1911:7: op= '^' f= bitAndExpr
        {
        op=(Token)match(input,80,FOLLOW_80_in_synpred242_ObjCpp7444); if (state.failed) return ;

        pushFollow(FOLLOW_bitAndExpr_in_synpred242_ObjCpp7454);
        f=bitAndExpr();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred242_ObjCpp

    // $ANTLR start synpred243_ObjCpp
    public final void synpred243_ObjCpp_fragment() throws RecognitionException {
        Token op=null;
        Expression f =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1919:7: (op= '||' f= logAndExpr )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1919:7: op= '||' f= logAndExpr
        {
        op=(Token)match(input,102,FOLLOW_102_in_synpred243_ObjCpp7501); if (state.failed) return ;

        pushFollow(FOLLOW_logAndExpr_in_synpred243_ObjCpp7511);
        f=logAndExpr();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred243_ObjCpp

    // $ANTLR start synpred244_ObjCpp
    public final void synpred244_ObjCpp_fragment() throws RecognitionException {
        Token op=null;
        Expression f =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1927:7: (op= '&&' f= bitOrExpr )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1927:7: op= '&&' f= bitOrExpr
        {
        op=(Token)match(input,35,FOLLOW_35_in_synpred244_ObjCpp7558); if (state.failed) return ;

        pushFollow(FOLLOW_bitOrExpr_in_synpred244_ObjCpp7568);
        f=bitOrExpr();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred244_ObjCpp

    // $ANTLR start synpred246_ObjCpp
    public final void synpred246_ObjCpp_fragment() throws RecognitionException {
        Token op=null;
        Expression f =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1935:7: (op= ( '!=' | '==' ) f= compareExpr )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1935:7: op= ( '!=' | '==' ) f= compareExpr
        {
        op=(Token)input.LT(1);

        if ( input.LA(1)==31||input.LA(1)==58 ) {
            input.consume();
            state.errorRecovery=false;
            state.failed=false;
        }
        else {
            if (state.backtracking>0) {state.failed=true; return ;}
            MismatchedSetException mse = new MismatchedSetException(null,input);
            throw mse;
        }


        pushFollow(FOLLOW_compareExpr_in_synpred246_ObjCpp7631);
        f=compareExpr();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred246_ObjCpp

    // $ANTLR start synpred250_ObjCpp
    public final void synpred250_ObjCpp_fragment() throws RecognitionException {
        Token op=null;
        Expression f =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1943:7: (op= ( '<' | '<=' | '>' | '>=' ) f= shiftExpr )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1943:7: op= ( '<' | '<=' | '>' | '>=' ) f= shiftExpr
        {
        op=(Token)input.LT(1);

        if ( input.LA(1)==53||input.LA(1)==56||(input.LA(1) >= 59 && input.LA(1) <= 60) ) {
            input.consume();
            state.errorRecovery=false;
            state.failed=false;
        }
        else {
            if (state.backtracking>0) {state.failed=true; return ;}
            MismatchedSetException mse = new MismatchedSetException(null,input);
            throw mse;
        }


        pushFollow(FOLLOW_shiftExpr_in_synpred250_ObjCpp7703);
        f=shiftExpr();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred250_ObjCpp

    // $ANTLR start synpred251_ObjCpp
    public final void synpred251_ObjCpp_fragment() throws RecognitionException {
        Expression inner =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1950:7: (inner= castExpr )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1950:7: inner= castExpr
        {
        pushFollow(FOLLOW_castExpr_in_synpred251_ObjCpp7748);
        inner=castExpr();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred251_ObjCpp

    // $ANTLR start synpred253_ObjCpp
    public final void synpred253_ObjCpp_fragment() throws RecognitionException {
        TypeRef tr =null;

        Expression inner =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1949:6: ( LPAREN tr= mutableTypeRef RPAREN (inner= castExpr | LPAREN expression ( COMMA expression )+ RPAREN ) )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1949:6: LPAREN tr= mutableTypeRef RPAREN (inner= castExpr | LPAREN expression ( COMMA expression )+ RPAREN )
        {
        match(input,LPAREN,FOLLOW_LPAREN_in_synpred253_ObjCpp7730); if (state.failed) return ;

        pushFollow(FOLLOW_mutableTypeRef_in_synpred253_ObjCpp7734);
        tr=mutableTypeRef();

        state._fsp--;
        if (state.failed) return ;

        match(input,RPAREN,FOLLOW_RPAREN_in_synpred253_ObjCpp7736); if (state.failed) return ;

        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1949:38: (inner= castExpr | LPAREN expression ( COMMA expression )+ RPAREN )
        int alt225=2;
        switch ( input.LA(1) ) {
        case LPAREN:
            {
            switch ( input.LA(2) ) {
            case IDENTIFIER:
                {
                int LA225_17 = input.LA(3);

                if ( (synpred251_ObjCpp()) ) {
                    alt225=1;
                }
                else if ( (true) ) {
                    alt225=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 225, 17, input);

                    throw nvae;

                }
                }
                break;
            case RPAREN:
            case 52:
            case 80:
            case 82:
            case 83:
            case 86:
            case 89:
            case 94:
            case 97:
            case 98:
                {
                alt225=1;
                }
                break;
            case 38:
                {
                int LA225_23 = input.LA(3);

                if ( (synpred251_ObjCpp()) ) {
                    alt225=1;
                }
                else if ( (true) ) {
                    alt225=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 225, 23, input);

                    throw nvae;

                }
                }
                break;
            case 36:
                {
                int LA225_24 = input.LA(3);

                if ( (synpred251_ObjCpp()) ) {
                    alt225=1;
                }
                else if ( (true) ) {
                    alt225=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 225, 24, input);

                    throw nvae;

                }
                }
                break;
            case 78:
                {
                int LA225_26 = input.LA(3);

                if ( (synpred251_ObjCpp()) ) {
                    alt225=1;
                }
                else if ( (true) ) {
                    alt225=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 225, 26, input);

                    throw nvae;

                }
                }
                break;
            case LPAREN:
                {
                int LA225_27 = input.LA(3);

                if ( (synpred251_ObjCpp()) ) {
                    alt225=1;
                }
                else if ( (true) ) {
                    alt225=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 225, 27, input);

                    throw nvae;

                }
                }
                break;
            case 43:
                {
                int LA225_29 = input.LA(3);

                if ( (synpred251_ObjCpp()) ) {
                    alt225=1;
                }
                else if ( (true) ) {
                    alt225=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 225, 29, input);

                    throw nvae;

                }
                }
                break;
            case DECIMAL_NUMBER:
                {
                int LA225_30 = input.LA(3);

                if ( (synpred251_ObjCpp()) ) {
                    alt225=1;
                }
                else if ( (true) ) {
                    alt225=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 225, 30, input);

                    throw nvae;

                }
                }
                break;
            case HEXADECIMAL_NUMBER:
                {
                int LA225_31 = input.LA(3);

                if ( (synpred251_ObjCpp()) ) {
                    alt225=1;
                }
                else if ( (true) ) {
                    alt225=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 225, 31, input);

                    throw nvae;

                }
                }
                break;
            case OCTAL_NUMBER:
                {
                int LA225_32 = input.LA(3);

                if ( (synpred251_ObjCpp()) ) {
                    alt225=1;
                }
                else if ( (true) ) {
                    alt225=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 225, 32, input);

                    throw nvae;

                }
                }
                break;
            case CHARACTER:
                {
                int LA225_33 = input.LA(3);

                if ( (synpred251_ObjCpp()) ) {
                    alt225=1;
                }
                else if ( (true) ) {
                    alt225=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 225, 33, input);

                    throw nvae;

                }
                }
                break;
            case FLOAT_NUMBER:
                {
                int LA225_34 = input.LA(3);

                if ( (synpred251_ObjCpp()) ) {
                    alt225=1;
                }
                else if ( (true) ) {
                    alt225=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 225, 34, input);

                    throw nvae;

                }
                }
                break;
            case STRING:
                {
                int LA225_35 = input.LA(3);

                if ( (synpred251_ObjCpp()) ) {
                    alt225=1;
                }
                else if ( (true) ) {
                    alt225=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 225, 35, input);

                    throw nvae;

                }
                }
                break;
            case LBRACE:
                {
                int LA225_36 = input.LA(3);

                if ( (synpred251_ObjCpp()) ) {
                    alt225=1;
                }
                else if ( (true) ) {
                    alt225=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 225, 36, input);

                    throw nvae;

                }
                }
                break;
            case 77:
                {
                int LA225_37 = input.LA(3);

                if ( (synpred251_ObjCpp()) ) {
                    alt225=1;
                }
                else if ( (true) ) {
                    alt225=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 225, 37, input);

                    throw nvae;

                }
                }
                break;
            case 74:
                {
                int LA225_38 = input.LA(3);

                if ( (synpred251_ObjCpp()) ) {
                    alt225=1;
                }
                else if ( (true) ) {
                    alt225=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 225, 38, input);

                    throw nvae;

                }
                }
                break;
            case 66:
                {
                int LA225_39 = input.LA(3);

                if ( (synpred251_ObjCpp()) ) {
                    alt225=1;
                }
                else if ( (true) ) {
                    alt225=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 225, 39, input);

                    throw nvae;

                }
                }
                break;
            case 40:
                {
                int LA225_40 = input.LA(3);

                if ( (synpred251_ObjCpp()) ) {
                    alt225=1;
                }
                else if ( (true) ) {
                    alt225=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 225, 40, input);

                    throw nvae;

                }
                }
                break;
            case 30:
            case 41:
            case 44:
            case 103:
                {
                int LA225_41 = input.LA(3);

                if ( (synpred251_ObjCpp()) ) {
                    alt225=1;
                }
                else if ( (true) ) {
                    alt225=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 225, 41, input);

                    throw nvae;

                }
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 225, 1, input);

                throw nvae;

            }

            }
            break;
        case CHARACTER:
        case DECIMAL_NUMBER:
        case FLOAT_NUMBER:
        case HEXADECIMAL_NUMBER:
        case IDENTIFIER:
        case LBRACE:
        case OCTAL_NUMBER:
        case STRING:
        case 30:
        case 36:
        case 38:
        case 40:
        case 41:
        case 43:
        case 44:
        case 66:
        case 74:
        case 77:
        case 78:
        case 103:
            {
            alt225=1;
            }
            break;
        default:
            if (state.backtracking>0) {state.failed=true; return ;}
            NoViableAltException nvae =
                new NoViableAltException("", 225, 0, input);

            throw nvae;

        }

        switch (alt225) {
            case 1 :
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1950:7: inner= castExpr
                {
                pushFollow(FOLLOW_castExpr_in_synpred253_ObjCpp7748);
                inner=castExpr();

                state._fsp--;
                if (state.failed) return ;

                }
                break;
            case 2 :
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1951:7: LPAREN expression ( COMMA expression )+ RPAREN
                {
                match(input,LPAREN,FOLLOW_LPAREN_in_synpred253_ObjCpp7760); if (state.failed) return ;

                pushFollow(FOLLOW_expression_in_synpred253_ObjCpp7762);
                expression();

                state._fsp--;
                if (state.failed) return ;

                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1951:25: ( COMMA expression )+
                int cnt224=0;
                loop224:
                do {
                    int alt224=2;
                    switch ( input.LA(1) ) {
                    case COMMA:
                        {
                        alt224=1;
                        }
                        break;

                    }

                    switch (alt224) {
                	case 1 :
                	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1951:27: COMMA expression
                	    {
                	    match(input,COMMA,FOLLOW_COMMA_in_synpred253_ObjCpp7766); if (state.failed) return ;

                	    pushFollow(FOLLOW_expression_in_synpred253_ObjCpp7768);
                	    expression();

                	    state._fsp--;
                	    if (state.failed) return ;

                	    }
                	    break;

                	default :
                	    if ( cnt224 >= 1 ) break loop224;
                	    if (state.backtracking>0) {state.failed=true; return ;}
                            EarlyExitException eee =
                                new EarlyExitException(224, input);
                            throw eee;
                    }
                    cnt224++;
                } while (true);


                match(input,RPAREN,FOLLOW_RPAREN_in_synpred253_ObjCpp7774); if (state.failed) return ;

                }
                break;

        }


        }

    }
    // $ANTLR end synpred253_ObjCpp

    // $ANTLR start synpred254_ObjCpp
    public final void synpred254_ObjCpp_fragment() throws RecognitionException {
        TypeRef tr =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1958:5: ({...}? IDENTIFIER ( LPAREN tr= mutableTypeRef RPAREN ) )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1958:5: {...}? IDENTIFIER ( LPAREN tr= mutableTypeRef RPAREN )
        {
        if ( !(( next("sizeof") )) ) {
            if (state.backtracking>0) {state.failed=true; return ;}
            throw new FailedPredicateException(input, "synpred254_ObjCpp", " next(\"sizeof\") ");
        }

        match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred254_ObjCpp7818); if (state.failed) return ;

        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1958:36: ( LPAREN tr= mutableTypeRef RPAREN )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1959:7: LPAREN tr= mutableTypeRef RPAREN
        {
        match(input,LPAREN,FOLLOW_LPAREN_in_synpred254_ObjCpp7828); if (state.failed) return ;

        pushFollow(FOLLOW_mutableTypeRef_in_synpred254_ObjCpp7832);
        tr=mutableTypeRef();

        state._fsp--;
        if (state.failed) return ;

        match(input,RPAREN,FOLLOW_RPAREN_in_synpred254_ObjCpp7834); if (state.failed) return ;

        }


        }

    }
    // $ANTLR end synpred254_ObjCpp

    // $ANTLR start synpred255_ObjCpp
    public final void synpred255_ObjCpp_fragment() throws RecognitionException {
        Expression p =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1964:5: (p= postfixExpr )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1964:5: p= postfixExpr
        {
        pushFollow(FOLLOW_postfixExpr_in_synpred255_ObjCpp7859);
        p=postfixExpr();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred255_ObjCpp

    // $ANTLR start synpred262_ObjCpp
    public final void synpred262_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1982:9: ( topLevelExprList )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1982:9: topLevelExprList
        {
        pushFollow(FOLLOW_topLevelExprList_in_synpred262_ObjCpp7982);
        topLevelExprList();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred262_ObjCpp

    // $ANTLR start synpred263_ObjCpp
    public final void synpred263_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1981:7: ( ( ( topLevelExprList )? ) )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1981:7: ( ( topLevelExprList )? )
        {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1981:7: ( ( topLevelExprList )? )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1982:9: ( topLevelExprList )?
        {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1982:9: ( topLevelExprList )?
        int alt226=2;
        switch ( input.LA(1) ) {
            case CHARACTER:
            case DECIMAL_NUMBER:
            case FLOAT_NUMBER:
            case HEXADECIMAL_NUMBER:
            case IDENTIFIER:
            case LBRACE:
            case LPAREN:
            case OCTAL_NUMBER:
            case STRING:
            case 30:
            case 36:
            case 38:
            case 40:
            case 41:
            case 43:
            case 44:
            case 66:
            case 74:
            case 77:
            case 78:
            case 103:
                {
                alt226=1;
                }
                break;
        }

        switch (alt226) {
            case 1 :
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1982:9: topLevelExprList
                {
                pushFollow(FOLLOW_topLevelExprList_in_synpred263_ObjCpp7982);
                topLevelExprList();

                state._fsp--;
                if (state.failed) return ;

                }
                break;

        }


        }


        }

    }
    // $ANTLR end synpred263_ObjCpp

    // $ANTLR start synpred264_ObjCpp
    public final void synpred264_ObjCpp_fragment() throws RecognitionException {
        Expression dim =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1991:11: ( '[' dim= expression ']' )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1991:11: '[' dim= expression ']'
        {
        match(input,78,FOLLOW_78_in_synpred264_ObjCpp8026); if (state.failed) return ;

        pushFollow(FOLLOW_expression_in_synpred264_ObjCpp8030);
        dim=expression();

        state._fsp--;
        if (state.failed) return ;

        match(input,79,FOLLOW_79_in_synpred264_ObjCpp8032); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred264_ObjCpp

    // $ANTLR start synpred265_ObjCpp
    public final void synpred265_ObjCpp_fragment() throws RecognitionException {
        TypeRef tr =null;

        Expression dim =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1979:5: ({...}? IDENTIFIER tr= nonMutableTypeRef ( ( ( topLevelExprList )? ) | ( ( '[' dim= expression ']' )+ ) ) )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1979:5: {...}? IDENTIFIER tr= nonMutableTypeRef ( ( ( topLevelExprList )? ) | ( ( '[' dim= expression ']' )+ ) )
        {
        if ( !(( next("new") )) ) {
            if (state.backtracking>0) {state.failed=true; return ;}
            throw new FailedPredicateException(input, "synpred265_ObjCpp", " next(\"new\") ");
        }

        match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred265_ObjCpp7954); if (state.failed) return ;

        pushFollow(FOLLOW_nonMutableTypeRef_in_synpred265_ObjCpp7958);
        tr=nonMutableTypeRef();

        state._fsp--;
        if (state.failed) return ;

        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1980:5: ( ( ( topLevelExprList )? ) | ( ( '[' dim= expression ']' )+ ) )
        int alt229=2;
        switch ( input.LA(1) ) {
        case EOF:
        case CHARACTER:
        case DECIMAL_NUMBER:
        case FLOAT_NUMBER:
        case HEXADECIMAL_NUMBER:
        case IDENTIFIER:
        case LBRACE:
        case LPAREN:
        case OCTAL_NUMBER:
        case STRING:
        case 30:
        case 36:
        case 38:
        case 40:
        case 41:
        case 43:
        case 44:
        case 66:
        case 74:
        case 77:
        case 103:
            {
            alt229=1;
            }
            break;
        case 78:
            {
            switch ( input.LA(2) ) {
            case LPAREN:
                {
                int LA229_18 = input.LA(3);

                if ( (synpred263_ObjCpp()) ) {
                    alt229=1;
                }
                else if ( (true) ) {
                    alt229=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 229, 18, input);

                    throw nvae;

                }
                }
                break;
            case IDENTIFIER:
                {
                int LA229_19 = input.LA(3);

                if ( (synpred263_ObjCpp()) ) {
                    alt229=1;
                }
                else if ( (true) ) {
                    alt229=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 229, 19, input);

                    throw nvae;

                }
                }
                break;
            case 43:
                {
                int LA229_20 = input.LA(3);

                if ( (synpred263_ObjCpp()) ) {
                    alt229=1;
                }
                else if ( (true) ) {
                    alt229=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 229, 20, input);

                    throw nvae;

                }
                }
                break;
            case DECIMAL_NUMBER:
                {
                int LA229_21 = input.LA(3);

                if ( (synpred263_ObjCpp()) ) {
                    alt229=1;
                }
                else if ( (true) ) {
                    alt229=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 229, 21, input);

                    throw nvae;

                }
                }
                break;
            case HEXADECIMAL_NUMBER:
                {
                int LA229_22 = input.LA(3);

                if ( (synpred263_ObjCpp()) ) {
                    alt229=1;
                }
                else if ( (true) ) {
                    alt229=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 229, 22, input);

                    throw nvae;

                }
                }
                break;
            case OCTAL_NUMBER:
                {
                int LA229_23 = input.LA(3);

                if ( (synpred263_ObjCpp()) ) {
                    alt229=1;
                }
                else if ( (true) ) {
                    alt229=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 229, 23, input);

                    throw nvae;

                }
                }
                break;
            case CHARACTER:
                {
                int LA229_24 = input.LA(3);

                if ( (synpred263_ObjCpp()) ) {
                    alt229=1;
                }
                else if ( (true) ) {
                    alt229=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 229, 24, input);

                    throw nvae;

                }
                }
                break;
            case FLOAT_NUMBER:
                {
                int LA229_25 = input.LA(3);

                if ( (synpred263_ObjCpp()) ) {
                    alt229=1;
                }
                else if ( (true) ) {
                    alt229=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 229, 25, input);

                    throw nvae;

                }
                }
                break;
            case STRING:
                {
                int LA229_26 = input.LA(3);

                if ( (synpred263_ObjCpp()) ) {
                    alt229=1;
                }
                else if ( (true) ) {
                    alt229=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 229, 26, input);

                    throw nvae;

                }
                }
                break;
            case 78:
                {
                int LA229_27 = input.LA(3);

                if ( (synpred263_ObjCpp()) ) {
                    alt229=1;
                }
                else if ( (true) ) {
                    alt229=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 229, 27, input);

                    throw nvae;

                }
                }
                break;
            case LBRACE:
                {
                int LA229_28 = input.LA(3);

                if ( (synpred263_ObjCpp()) ) {
                    alt229=1;
                }
                else if ( (true) ) {
                    alt229=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 229, 28, input);

                    throw nvae;

                }
                }
                break;
            case 77:
                {
                int LA229_29 = input.LA(3);

                if ( (synpred263_ObjCpp()) ) {
                    alt229=1;
                }
                else if ( (true) ) {
                    alt229=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 229, 29, input);

                    throw nvae;

                }
                }
                break;
            case 74:
                {
                int LA229_30 = input.LA(3);

                if ( (synpred263_ObjCpp()) ) {
                    alt229=1;
                }
                else if ( (true) ) {
                    alt229=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 229, 30, input);

                    throw nvae;

                }
                }
                break;
            case 66:
                {
                int LA229_31 = input.LA(3);

                if ( (synpred263_ObjCpp()) ) {
                    alt229=1;
                }
                else if ( (true) ) {
                    alt229=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 229, 31, input);

                    throw nvae;

                }
                }
                break;
            case 40:
                {
                int LA229_32 = input.LA(3);

                if ( (synpred263_ObjCpp()) ) {
                    alt229=1;
                }
                else if ( (true) ) {
                    alt229=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 229, 32, input);

                    throw nvae;

                }
                }
                break;
            case 30:
            case 36:
            case 38:
            case 41:
            case 44:
            case 103:
                {
                int LA229_33 = input.LA(3);

                if ( (synpred263_ObjCpp()) ) {
                    alt229=1;
                }
                else if ( (true) ) {
                    alt229=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 229, 33, input);

                    throw nvae;

                }
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 229, 10, input);

                throw nvae;

            }

            }
            break;
        default:
            if (state.backtracking>0) {state.failed=true; return ;}
            NoViableAltException nvae =
                new NoViableAltException("", 229, 0, input);

            throw nvae;

        }

        switch (alt229) {
            case 1 :
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1981:7: ( ( topLevelExprList )? )
                {
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1981:7: ( ( topLevelExprList )? )
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1982:9: ( topLevelExprList )?
                {
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1982:9: ( topLevelExprList )?
                int alt227=2;
                switch ( input.LA(1) ) {
                    case CHARACTER:
                    case DECIMAL_NUMBER:
                    case FLOAT_NUMBER:
                    case HEXADECIMAL_NUMBER:
                    case IDENTIFIER:
                    case LBRACE:
                    case LPAREN:
                    case OCTAL_NUMBER:
                    case STRING:
                    case 30:
                    case 36:
                    case 38:
                    case 40:
                    case 41:
                    case 43:
                    case 44:
                    case 66:
                    case 74:
                    case 77:
                    case 78:
                    case 103:
                        {
                        alt227=1;
                        }
                        break;
                }

                switch (alt227) {
                    case 1 :
                        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1982:9: topLevelExprList
                        {
                        pushFollow(FOLLOW_topLevelExprList_in_synpred265_ObjCpp7982);
                        topLevelExprList();

                        state._fsp--;
                        if (state.failed) return ;

                        }
                        break;

                }


                }


                }
                break;
            case 2 :
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1989:7: ( ( '[' dim= expression ']' )+ )
                {
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1989:7: ( ( '[' dim= expression ']' )+ )
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1990:9: ( '[' dim= expression ']' )+
                {
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1990:9: ( '[' dim= expression ']' )+
                int cnt228=0;
                loop228:
                do {
                    int alt228=2;
                    switch ( input.LA(1) ) {
                    case 78:
                        {
                        alt228=1;
                        }
                        break;

                    }

                    switch (alt228) {
                	case 1 :
                	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:1991:11: '[' dim= expression ']'
                	    {
                	    match(input,78,FOLLOW_78_in_synpred265_ObjCpp8026); if (state.failed) return ;

                	    pushFollow(FOLLOW_expression_in_synpred265_ObjCpp8030);
                	    dim=expression();

                	    state._fsp--;
                	    if (state.failed) return ;

                	    match(input,79,FOLLOW_79_in_synpred265_ObjCpp8032); if (state.failed) return ;

                	    }
                	    break;

                	default :
                	    if ( cnt228 >= 1 ) break loop228;
                	    if (state.backtracking>0) {state.failed=true; return ;}
                            EarlyExitException eee =
                                new EarlyExitException(228, input);
                            throw eee;
                    }
                    cnt228++;
                } while (true);


                }


                }
                break;

        }


        }

    }
    // $ANTLR end synpred265_ObjCpp

    // $ANTLR start synpred266_ObjCpp
    public final void synpred266_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2005:7: ( '[' expression ']' )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2005:7: '[' expression ']'
        {
        match(input,78,FOLLOW_78_in_synpred266_ObjCpp8093); if (state.failed) return ;

        pushFollow(FOLLOW_expression_in_synpred266_ObjCpp8095);
        expression();

        state._fsp--;
        if (state.failed) return ;

        match(input,79,FOLLOW_79_in_synpred266_ObjCpp8097); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred266_ObjCpp

    // $ANTLR start synpred268_ObjCpp
    public final void synpred268_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2008:7: ( LPAREN ( topLevelExprList )? RPAREN )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2008:7: LPAREN ( topLevelExprList )? RPAREN
        {
        match(input,LPAREN,FOLLOW_LPAREN_in_synpred268_ObjCpp8109); if (state.failed) return ;

        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2008:14: ( topLevelExprList )?
        int alt230=2;
        switch ( input.LA(1) ) {
            case CHARACTER:
            case DECIMAL_NUMBER:
            case FLOAT_NUMBER:
            case HEXADECIMAL_NUMBER:
            case IDENTIFIER:
            case LBRACE:
            case LPAREN:
            case OCTAL_NUMBER:
            case STRING:
            case 30:
            case 36:
            case 38:
            case 40:
            case 41:
            case 43:
            case 44:
            case 66:
            case 74:
            case 77:
            case 78:
            case 103:
                {
                alt230=1;
                }
                break;
        }

        switch (alt230) {
            case 1 :
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2008:14: topLevelExprList
                {
                pushFollow(FOLLOW_topLevelExprList_in_synpred268_ObjCpp8111);
                topLevelExprList();

                state._fsp--;
                if (state.failed) return ;

                }
                break;

        }


        match(input,RPAREN,FOLLOW_RPAREN_in_synpred268_ObjCpp8114); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred268_ObjCpp

    // $ANTLR start synpred272_ObjCpp
    public final void synpred272_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2024:7: ( postfixOp )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2024:7: postfixOp
        {
        pushFollow(FOLLOW_postfixOp_in_synpred272_ObjCpp8174);
        postfixOp();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred272_ObjCpp

    // $ANTLR start synpred273_ObjCpp
    public final void synpred273_ObjCpp_fragment() throws RecognitionException {
        ObjCppParser.topLevelExpr_return f =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2038:7: ( COMMA f= topLevelExpr )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2038:7: COMMA f= topLevelExpr
        {
        match(input,COMMA,FOLLOW_COMMA_in_synpred273_ObjCpp8251); if (state.failed) return ;

        pushFollow(FOLLOW_topLevelExpr_in_synpred273_ObjCpp8261);
        f=topLevelExpr();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred273_ObjCpp

    // $ANTLR start synpred277_ObjCpp
    public final void synpred277_ObjCpp_fragment() throws RecognitionException {
        Block b =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2085:5: (b= statementsBlock )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2085:5: b= statementsBlock
        {
        pushFollow(FOLLOW_statementsBlock_in_synpred277_ObjCpp8451);
        b=statementsBlock();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred277_ObjCpp

    // $ANTLR start synpred278_ObjCpp
    public final void synpred278_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2091:7: ({...}? => IDENTIFIER )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2091:7: {...}? => IDENTIFIER
        {
        if ( !(( next("__volatile__", "volatile") )) ) {
            if (state.backtracking>0) {state.failed=true; return ;}
            throw new FailedPredicateException(input, "synpred278_ObjCpp", " next(\"__volatile__\", \"volatile\") ");
        }

        match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred278_ObjCpp8486); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred278_ObjCpp

    // $ANTLR start synpred282_ObjCpp
    public final void synpred282_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2093:12: ( SEMICOLON )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2093:12: SEMICOLON
        {
        match(input,SEMICOLON,FOLLOW_SEMICOLON_in_synpred282_ObjCpp8518); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred282_ObjCpp

    // $ANTLR start synpred283_ObjCpp
    public final void synpred283_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2090:5: ({...}? => IDENTIFIER ({...}? => IDENTIFIER )? LPAREN ( STRING )* ( ':' ( gccAsmInOuts )? )* RPAREN ( SEMICOLON )? )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2090:5: {...}? => IDENTIFIER ({...}? => IDENTIFIER )? LPAREN ( STRING )* ( ':' ( gccAsmInOuts )? )* RPAREN ( SEMICOLON )?
        {
        if ( !(( next("__asm__", "asm") )) ) {
            if (state.backtracking>0) {state.failed=true; return ;}
            throw new FailedPredicateException(input, "synpred283_ObjCpp", " next(\"__asm__\", \"asm\") ");
        }

        match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred283_ObjCpp8475); if (state.failed) return ;

        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2091:5: ({...}? => IDENTIFIER )?
        int alt232=2;
        int LA232_0 = input.LA(1);

        if ( (LA232_0==IDENTIFIER) && (( next("__volatile__", "volatile") ))) {
            alt232=1;
        }
        switch (alt232) {
            case 1 :
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2091:7: {...}? => IDENTIFIER
                {
                if ( !(( next("__volatile__", "volatile") )) ) {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    throw new FailedPredicateException(input, "synpred283_ObjCpp", " next(\"__volatile__\", \"volatile\") ");
                }

                match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred283_ObjCpp8486); if (state.failed) return ;

                }
                break;

        }


        match(input,LPAREN,FOLLOW_LPAREN_in_synpred283_ObjCpp8491); if (state.failed) return ;

        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2092:7: ( STRING )*
        loop233:
        do {
            int alt233=2;
            switch ( input.LA(1) ) {
            case STRING:
                {
                alt233=1;
                }
                break;

            }

            switch (alt233) {
        	case 1 :
        	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2092:7: STRING
        	    {
        	    match(input,STRING,FOLLOW_STRING_in_synpred283_ObjCpp8499); if (state.failed) return ;

        	    }
        	    break;

        	default :
        	    break loop233;
            }
        } while (true);


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2092:15: ( ':' ( gccAsmInOuts )? )*
        loop235:
        do {
            int alt235=2;
            switch ( input.LA(1) ) {
            case 51:
                {
                alt235=1;
                }
                break;

            }

            switch (alt235) {
        	case 1 :
        	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2092:17: ':' ( gccAsmInOuts )?
        	    {
        	    match(input,51,FOLLOW_51_in_synpred283_ObjCpp8504); if (state.failed) return ;

        	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2092:21: ( gccAsmInOuts )?
        	    int alt234=2;
        	    switch ( input.LA(1) ) {
        	        case STRING:
        	            {
        	            alt234=1;
        	            }
        	            break;
        	    }

        	    switch (alt234) {
        	        case 1 :
        	            // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2092:21: gccAsmInOuts
        	            {
        	            pushFollow(FOLLOW_gccAsmInOuts_in_synpred283_ObjCpp8506);
        	            gccAsmInOuts();

        	            state._fsp--;
        	            if (state.failed) return ;

        	            }
        	            break;

        	    }


        	    }
        	    break;

        	default :
        	    break loop235;
            }
        } while (true);


        match(input,RPAREN,FOLLOW_RPAREN_in_synpred283_ObjCpp8516); if (state.failed) return ;

        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2093:12: ( SEMICOLON )?
        int alt236=2;
        switch ( input.LA(1) ) {
            case SEMICOLON:
                {
                alt236=1;
                }
                break;
        }

        switch (alt236) {
            case 1 :
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2093:12: SEMICOLON
                {
                match(input,SEMICOLON,FOLLOW_SEMICOLON_in_synpred283_ObjCpp8518); if (state.failed) return ;

                }
                break;

        }


        }

    }
    // $ANTLR end synpred283_ObjCpp

    // $ANTLR start synpred286_ObjCpp
    public final void synpred286_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2095:5: ({...}? => IDENTIFIER LBRACE ( expression | COMMA )* RBRACE )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2095:5: {...}? => IDENTIFIER LBRACE ( expression | COMMA )* RBRACE
        {
        if ( !(( next("__asm") )) ) {
            if (state.backtracking>0) {state.failed=true; return ;}
            throw new FailedPredicateException(input, "synpred286_ObjCpp", " next(\"__asm\") ");
        }

        match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred286_ObjCpp8536); if (state.failed) return ;

        match(input,LBRACE,FOLLOW_LBRACE_in_synpred286_ObjCpp8538); if (state.failed) return ;

        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2096:7: ( expression | COMMA )*
        loop237:
        do {
            int alt237=3;
            switch ( input.LA(1) ) {
            case CHARACTER:
            case DECIMAL_NUMBER:
            case FLOAT_NUMBER:
            case HEXADECIMAL_NUMBER:
            case IDENTIFIER:
            case LBRACE:
            case LPAREN:
            case OCTAL_NUMBER:
            case STRING:
            case 30:
            case 36:
            case 38:
            case 40:
            case 41:
            case 43:
            case 44:
            case 66:
            case 74:
            case 77:
            case 78:
            case 103:
                {
                alt237=1;
                }
                break;
            case COMMA:
                {
                alt237=2;
                }
                break;

            }

            switch (alt237) {
        	case 1 :
        	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2096:9: expression
        	    {
        	    pushFollow(FOLLOW_expression_in_synpred286_ObjCpp8548);
        	    expression();

        	    state._fsp--;
        	    if (state.failed) return ;

        	    }
        	    break;
        	case 2 :
        	    // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2096:22: COMMA
        	    {
        	    match(input,COMMA,FOLLOW_COMMA_in_synpred286_ObjCpp8552); if (state.failed) return ;

        	    }
        	    break;

        	default :
        	    break loop237;
            }
        } while (true);


        match(input,RBRACE,FOLLOW_RBRACE_in_synpred286_ObjCpp8561); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred286_ObjCpp

    // $ANTLR start synpred287_ObjCpp
    public final void synpred287_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2098:5: ({...}? => IDENTIFIER LPAREN varDecl {...}? IDENTIFIER expression RPAREN statement )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2098:5: {...}? => IDENTIFIER LPAREN varDecl {...}? IDENTIFIER expression RPAREN statement
        {
        if ( !(( next("foreach") )) ) {
            if (state.backtracking>0) {state.failed=true; return ;}
            throw new FailedPredicateException(input, "synpred287_ObjCpp", " next(\"foreach\") ");
        }

        match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred287_ObjCpp8571); if (state.failed) return ;

        match(input,LPAREN,FOLLOW_LPAREN_in_synpred287_ObjCpp8573); if (state.failed) return ;

        pushFollow(FOLLOW_varDecl_in_synpred287_ObjCpp8575);
        varDecl();

        state._fsp--;
        if (state.failed) return ;

        if ( !(( next("in") )) ) {
            if (state.backtracking>0) {state.failed=true; return ;}
            throw new FailedPredicateException(input, "synpred287_ObjCpp", " next(\"in\") ");
        }

        match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred287_ObjCpp8579); if (state.failed) return ;

        pushFollow(FOLLOW_expression_in_synpred287_ObjCpp8581);
        expression();

        state._fsp--;
        if (state.failed) return ;

        match(input,RPAREN,FOLLOW_RPAREN_in_synpred287_ObjCpp8583); if (state.failed) return ;

        pushFollow(FOLLOW_statement_in_synpred287_ObjCpp8585);
        statement();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred287_ObjCpp

    // $ANTLR start synpred289_ObjCpp
    public final void synpred289_ObjCpp_fragment() throws RecognitionException {
        Expression delArr =null;

        Expression del =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2101:5: ({...}? => IDENTIFIER ( '[' ']' delArr= expression |del= expression ) SEMICOLON )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2101:5: {...}? => IDENTIFIER ( '[' ']' delArr= expression |del= expression ) SEMICOLON
        {
        if ( !(( next("delete") )) ) {
            if (state.backtracking>0) {state.failed=true; return ;}
            throw new FailedPredicateException(input, "synpred289_ObjCpp", " next(\"delete\") ");
        }

        match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred289_ObjCpp8598); if (state.failed) return ;

        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2101:39: ( '[' ']' delArr= expression |del= expression )
        int alt238=2;
        switch ( input.LA(1) ) {
        case 78:
            {
            switch ( input.LA(2) ) {
            case 79:
                {
                alt238=1;
                }
                break;
            case CHARACTER:
            case DECIMAL_NUMBER:
            case FLOAT_NUMBER:
            case HEXADECIMAL_NUMBER:
            case IDENTIFIER:
            case LBRACE:
            case LPAREN:
            case OCTAL_NUMBER:
            case STRING:
            case 30:
            case 36:
            case 38:
            case 40:
            case 41:
            case 43:
            case 44:
            case 66:
            case 74:
            case 77:
            case 78:
            case 103:
                {
                alt238=2;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 238, 1, input);

                throw nvae;

            }

            }
            break;
        case CHARACTER:
        case DECIMAL_NUMBER:
        case FLOAT_NUMBER:
        case HEXADECIMAL_NUMBER:
        case IDENTIFIER:
        case LBRACE:
        case LPAREN:
        case OCTAL_NUMBER:
        case STRING:
        case 30:
        case 36:
        case 38:
        case 40:
        case 41:
        case 43:
        case 44:
        case 66:
        case 74:
        case 77:
        case 103:
            {
            alt238=2;
            }
            break;
        default:
            if (state.backtracking>0) {state.failed=true; return ;}
            NoViableAltException nvae =
                new NoViableAltException("", 238, 0, input);

            throw nvae;

        }

        switch (alt238) {
            case 1 :
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2102:7: '[' ']' delArr= expression
                {
                match(input,78,FOLLOW_78_in_synpred289_ObjCpp8609); if (state.failed) return ;

                match(input,79,FOLLOW_79_in_synpred289_ObjCpp8611); if (state.failed) return ;

                pushFollow(FOLLOW_expression_in_synpred289_ObjCpp8615);
                delArr=expression();

                state._fsp--;
                if (state.failed) return ;

                }
                break;
            case 2 :
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2105:7: del= expression
                {
                pushFollow(FOLLOW_expression_in_synpred289_ObjCpp8629);
                del=expression();

                state._fsp--;
                if (state.failed) return ;

                }
                break;

        }


        match(input,SEMICOLON,FOLLOW_SEMICOLON_in_synpred289_ObjCpp8639); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred289_ObjCpp

    // $ANTLR start synpred290_ObjCpp
    public final void synpred290_ObjCpp_fragment() throws RecognitionException {
        Expression pe =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2109:5: (pe= postfixExpr SEMICOLON )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2109:5: pe= postfixExpr SEMICOLON
        {
        pushFollow(FOLLOW_postfixExpr_in_synpred290_ObjCpp8649);
        pe=postfixExpr();

        state._fsp--;
        if (state.failed) return ;

        match(input,SEMICOLON,FOLLOW_SEMICOLON_in_synpred290_ObjCpp8651); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred290_ObjCpp

    // $ANTLR start synpred291_ObjCpp
    public final void synpred291_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2114:5: ( declaration )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2114:5: declaration
        {
        pushFollow(FOLLOW_declaration_in_synpred291_ObjCpp8661);
        declaration();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred291_ObjCpp

    // $ANTLR start synpred292_ObjCpp
    public final void synpred292_ObjCpp_fragment() throws RecognitionException {
        Expression es =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2117:5: (es= expression SEMICOLON )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2117:5: es= expression SEMICOLON
        {
        pushFollow(FOLLOW_expression_in_synpred292_ObjCpp8673);
        es=expression();

        state._fsp--;
        if (state.failed) return ;

        match(input,SEMICOLON,FOLLOW_SEMICOLON_in_synpred292_ObjCpp8675); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred292_ObjCpp

    // $ANTLR start synpred295_ObjCpp
    public final void synpred295_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2123:5: ( IDENTIFIER ':' )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2123:5: IDENTIFIER ':'
        {
        match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_synpred295_ObjCpp8704); if (state.failed) return ;

        match(input,51,FOLLOW_51_in_synpred295_ObjCpp8706); if (state.failed) return ;

        }

    }
    // $ANTLR end synpred295_ObjCpp

    // $ANTLR start synpred297_ObjCpp
    public final void synpred297_ObjCpp_fragment() throws RecognitionException {
        Statement els =null;


        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2125:59: ( 'else' els= statement )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2125:59: 'else' els= statement
        {
        match(input,88,FOLLOW_88_in_synpred297_ObjCpp8740); if (state.failed) return ;

        pushFollow(FOLLOW_statement_in_synpred297_ObjCpp8744);
        els=statement();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred297_ObjCpp

    // $ANTLR start synpred301_ObjCpp
    public final void synpred301_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2136:10: ( varDecl )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2136:10: varDecl
        {
        pushFollow(FOLLOW_varDecl_in_synpred301_ObjCpp8828);
        varDecl();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred301_ObjCpp

    // $ANTLR start synpred302_ObjCpp
    public final void synpred302_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2136:20: ( expression )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2136:20: expression
        {
        pushFollow(FOLLOW_expression_in_synpred302_ObjCpp8832);
        expression();

        state._fsp--;
        if (state.failed) return ;

        }

    }
    // $ANTLR end synpred302_ObjCpp

    // $ANTLR start synpred305_ObjCpp
    public final void synpred305_ObjCpp_fragment() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2136:9: ( ( varDecl | expression )? SEMICOLON ( expression )? SEMICOLON ( expression )? )
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2136:9: ( varDecl | expression )? SEMICOLON ( expression )? SEMICOLON ( expression )?
        {
        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2136:9: ( varDecl | expression )?
        int alt241=3;
        alt241 = dfa241.predict(input);
        switch (alt241) {
            case 1 :
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2136:10: varDecl
                {
                pushFollow(FOLLOW_varDecl_in_synpred305_ObjCpp8828);
                varDecl();

                state._fsp--;
                if (state.failed) return ;

                }
                break;
            case 2 :
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2136:20: expression
                {
                pushFollow(FOLLOW_expression_in_synpred305_ObjCpp8832);
                expression();

                state._fsp--;
                if (state.failed) return ;

                }
                break;

        }


        match(input,SEMICOLON,FOLLOW_SEMICOLON_in_synpred305_ObjCpp8837); if (state.failed) return ;

        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2136:44: ( expression )?
        int alt242=2;
        switch ( input.LA(1) ) {
            case CHARACTER:
            case DECIMAL_NUMBER:
            case FLOAT_NUMBER:
            case HEXADECIMAL_NUMBER:
            case IDENTIFIER:
            case LBRACE:
            case LPAREN:
            case OCTAL_NUMBER:
            case STRING:
            case 30:
            case 36:
            case 38:
            case 40:
            case 41:
            case 43:
            case 44:
            case 66:
            case 74:
            case 77:
            case 78:
            case 103:
                {
                alt242=1;
                }
                break;
        }

        switch (alt242) {
            case 1 :
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2136:44: expression
                {
                pushFollow(FOLLOW_expression_in_synpred305_ObjCpp8839);
                expression();

                state._fsp--;
                if (state.failed) return ;

                }
                break;

        }


        match(input,SEMICOLON,FOLLOW_SEMICOLON_in_synpred305_ObjCpp8842); if (state.failed) return ;

        // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2136:66: ( expression )?
        int alt243=2;
        switch ( input.LA(1) ) {
            case CHARACTER:
            case DECIMAL_NUMBER:
            case FLOAT_NUMBER:
            case HEXADECIMAL_NUMBER:
            case IDENTIFIER:
            case LBRACE:
            case LPAREN:
            case OCTAL_NUMBER:
            case STRING:
            case 30:
            case 36:
            case 38:
            case 40:
            case 41:
            case 43:
            case 44:
            case 66:
            case 74:
            case 77:
            case 78:
            case 103:
                {
                alt243=1;
                }
                break;
        }

        switch (alt243) {
            case 1 :
                // com/ochafik/lang/jnaerator/parser/ObjCpp.g:2136:66: expression
                {
                pushFollow(FOLLOW_expression_in_synpred305_ObjCpp8844);
                expression();

                state._fsp--;
                if (state.failed) return ;

                }
                break;

        }


        }

    }
    // $ANTLR end synpred305_ObjCpp

    // Delegated rules

    public final boolean synpred74_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred74_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred263_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred263_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred76_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred76_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred77_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred77_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred70_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred70_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred262_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred262_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred264_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred264_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred79_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred79_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred8_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred8_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred132_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred132_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred268_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred268_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred266_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred266_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred265_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred265_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred9_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred9_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred134_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred134_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred136_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred136_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred161_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred161_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred167_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred167_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred169_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred169_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred41_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred41_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred30_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred30_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred69_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred69_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred220_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred220_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred234_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred234_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred81_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred81_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred62_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred62_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred63_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred63_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred66_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred66_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred85_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred85_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred84_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred84_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred25_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred25_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred80_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred80_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred253_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred253_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred88_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred88_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred122_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred122_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred292_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred292_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred121_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred121_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred278_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred278_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred297_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred297_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred140_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred140_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred143_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred143_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred144_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred144_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred162_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred162_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred302_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred302_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred129_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred129_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred3_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred3_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred11_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred11_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred201_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred201_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred107_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred107_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred195_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred195_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred33_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred33_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred199_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred199_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred238_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred238_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred51_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred51_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred56_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred56_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred208_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred208_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred244_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred244_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred243_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred243_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred241_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred241_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred242_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred242_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred246_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred246_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred203_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred203_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred113_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred113_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred283_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred283_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred14_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred14_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred150_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred150_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred95_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred95_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred287_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred287_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred301_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred301_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred289_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred289_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred282_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred282_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred148_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred148_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred286_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred286_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred305_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred305_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred154_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred154_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred158_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred158_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred12_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred12_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred10_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred10_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred200_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred200_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred117_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred117_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred106_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred106_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred202_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred202_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred108_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred108_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred192_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred192_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred194_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred194_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred237_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred237_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred239_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred239_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred49_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred49_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred54_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred54_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred82_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred82_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred251_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred251_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred250_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred250_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred65_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred65_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred64_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred64_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred68_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred68_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred255_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred255_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred254_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred254_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred28_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred28_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred86_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred86_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred120_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred120_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred83_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred83_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred123_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred123_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred291_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred291_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred273_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred273_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred277_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred277_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred272_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred272_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred295_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred295_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred290_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred290_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred141_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred141_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred142_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred142_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred164_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred164_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred1_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred1_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred160_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred160_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred13_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred13_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred116_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred116_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred105_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred105_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }
    public final boolean synpred232_ObjCpp() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred232_ObjCpp_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }


    protected DFA6 dfa6 = new DFA6(this);
    protected DFA17 dfa17 = new DFA17(this);
    protected DFA26 dfa26 = new DFA26(this);
    protected DFA39 dfa39 = new DFA39(this);
    protected DFA37 dfa37 = new DFA37(this);
    protected DFA44 dfa44 = new DFA44(this);
    protected DFA60 dfa60 = new DFA60(this);
    protected DFA63 dfa63 = new DFA63(this);
    protected DFA67 dfa67 = new DFA67(this);
    protected DFA88 dfa88 = new DFA88(this);
    protected DFA103 dfa103 = new DFA103(this);
    protected DFA104 dfa104 = new DFA104(this);
    protected DFA105 dfa105 = new DFA105(this);
    protected DFA110 dfa110 = new DFA110(this);
    protected DFA113 dfa113 = new DFA113(this);
    protected DFA112 dfa112 = new DFA112(this);
    protected DFA124 dfa124 = new DFA124(this);
    protected DFA126 dfa126 = new DFA126(this);
    protected DFA127 dfa127 = new DFA127(this);
    protected DFA135 dfa135 = new DFA135(this);
    protected DFA139 dfa139 = new DFA139(this);
    protected DFA145 dfa145 = new DFA145(this);
    protected DFA140 dfa140 = new DFA140(this);
    protected DFA144 dfa144 = new DFA144(this);
    protected DFA146 dfa146 = new DFA146(this);
    protected DFA163 dfa163 = new DFA163(this);
    protected DFA153 dfa153 = new DFA153(this);
    protected DFA157 dfa157 = new DFA157(this);
    protected DFA161 dfa161 = new DFA161(this);
    protected DFA158 dfa158 = new DFA158(this);
    protected DFA188 dfa188 = new DFA188(this);
    protected DFA241 dfa241 = new DFA241(this);
    static final String DFA6_eotS =
        "\136\uffff";
    static final String DFA6_eofS =
        "\136\uffff";
    static final String DFA6_minS =
        "\1\16\1\5\1\22\7\16\1\uffff\1\16\7\uffff\14\0\1\uffff\1\0\5\uffff"+
        "\1\0\2\uffff\1\0\2\uffff\17\0\1\uffff\3\0\1\uffff\1\0\1\uffff\2"+
        "\0\1\uffff\3\0\1\uffff\1\0\1\uffff\2\0\1\uffff\3\0\1\uffff\1\0\1"+
        "\uffff\3\0\7\uffff";
    static final String DFA6_maxS =
        "\1\147\1\150\1\22\1\64\1\16\2\123\3\147\1\uffff\1\123\7\uffff\14"+
        "\0\1\uffff\1\0\5\uffff\1\0\2\uffff\1\0\2\uffff\17\0\1\uffff\3\0"+
        "\1\uffff\1\0\1\uffff\2\0\1\uffff\3\0\1\uffff\1\0\1\uffff\2\0\1\uffff"+
        "\3\0\1\uffff\1\0\1\uffff\3\0\7\uffff";
    static final String DFA6_acceptS =
        "\12\uffff\1\2\2\uffff\1\5\1\uffff\1\6\1\7\1\10\1\11\110\uffff\1"+
        "\1\1\3\1\4";
    static final String DFA6_specialS =
        "\23\uffff\1\0\1\1\1\2\1\3\1\4\1\5\1\6\1\7\1\10\1\11\1\12\1\13\1"+
        "\uffff\1\14\5\uffff\1\15\2\uffff\1\16\2\uffff\1\17\1\20\1\21\1\22"+
        "\1\23\1\24\1\25\1\26\1\27\1\30\1\31\1\32\1\33\1\34\1\35\1\uffff"+
        "\1\36\1\37\1\40\1\uffff\1\41\1\uffff\1\42\1\43\1\uffff\1\44\1\45"+
        "\1\46\1\uffff\1\47\1\uffff\1\50\1\51\1\uffff\1\52\1\53\1\54\1\uffff"+
        "\1\55\1\uffff\1\56\1\57\1\60\7\uffff}>";
    static final String[] DFA6_transitionS = {
            "\1\1\3\uffff\1\13\6\uffff\1\15\12\uffff\1\10\1\uffff\1\7\14"+
            "\uffff\1\15\1\4\14\uffff\1\21\2\uffff\1\17\5\uffff\1\17\3\uffff"+
            "\1\12\1\uffff\1\11\1\uffff\2\2\2\uffff\1\5\2\uffff\1\6\2\uffff"+
            "\1\22\1\uffff\1\5\1\uffff\1\20\1\3\1\5\4\uffff\1\12",
            "\1\51\10\uffff\1\25\3\uffff\1\23\6\uffff\1\15\1\24\3\uffff"+
            "\2\12\1\uffff\3\12\1\34\1\12\1\33\10\12\2\uffff\2\12\1\15\1"+
            "\30\1\40\3\12\1\46\6\12\16\uffff\1\36\1\uffff\1\35\1\12\2\26"+
            "\2\uffff\1\31\2\uffff\1\32\4\uffff\1\31\2\uffff\1\27\1\31\1"+
            "\uffff\5\12",
            "\1\54",
            "\1\56\45\uffff\1\55",
            "\1\57",
            "\1\60\1\uffff\1\62\43\uffff\1\63\35\uffff\2\61",
            "\1\64\1\uffff\1\67\42\uffff\1\66\1\70\35\uffff\2\65",
            "\1\71\3\uffff\1\100\21\uffff\1\75\1\uffff\1\74\14\uffff\1\15"+
            "\32\uffff\1\12\1\uffff\1\76\1\uffff\2\72\23\uffff\1\12",
            "\1\102\3\uffff\1\111\21\uffff\1\106\1\uffff\1\105\14\uffff"+
            "\1\15\32\uffff\1\12\1\uffff\1\107\1\uffff\2\103\23\uffff\1\12",
            "\1\113\3\uffff\1\122\21\uffff\1\117\1\uffff\1\116\14\uffff"+
            "\1\15\32\uffff\1\12\1\uffff\1\120\1\uffff\2\114\23\uffff\1\12",
            "",
            "\1\124\3\uffff\1\15\5\uffff\1\12\13\uffff\1\15\1\uffff\1\126"+
            "\14\uffff\1\15\34\uffff\1\126\1\uffff\2\125",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "\1\uffff",
            "",
            "",
            "",
            "",
            "",
            "\1\uffff",
            "",
            "",
            "\1\uffff",
            "",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "\1\uffff",
            "",
            "\1\uffff",
            "\1\uffff",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "\1\uffff",
            "",
            "\1\uffff",
            "\1\uffff",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "\1\uffff",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "",
            "",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA6_eot = DFA.unpackEncodedString(DFA6_eotS);
    static final short[] DFA6_eof = DFA.unpackEncodedString(DFA6_eofS);
    static final char[] DFA6_min = DFA.unpackEncodedStringToUnsignedChars(DFA6_minS);
    static final char[] DFA6_max = DFA.unpackEncodedStringToUnsignedChars(DFA6_maxS);
    static final short[] DFA6_accept = DFA.unpackEncodedString(DFA6_acceptS);
    static final short[] DFA6_special = DFA.unpackEncodedString(DFA6_specialS);
    static final short[][] DFA6_transition;

    static {
        int numStates = DFA6_transitionS.length;
        DFA6_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA6_transition[i] = DFA.unpackEncodedString(DFA6_transitionS[i]);
        }
    }

    class DFA6 extends DFA {

        public DFA6(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 6;
            this.eot = DFA6_eot;
            this.eof = DFA6_eof;
            this.min = DFA6_min;
            this.max = DFA6_max;
            this.accept = DFA6_accept;
            this.special = DFA6_special;
            this.transition = DFA6_transition;
        }
        public String getDescription() {
            return "567:7: ({...}? => pragmaContent | functionDeclaration |{...}? => externDeclarations |{...}? => IDENTIFIER qualifiedIdentifier SEMICOLON | varDecl SEMICOLON | objCClassDef | typeDef | forwardClassDecl | namespaceDecl )";
        }
        public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
            TokenStream input = (TokenStream)_input;
        	int _s = s;
            switch ( s ) {
                    case 0 : 
                        int LA6_19 = input.LA(1);

                         
                        int index6_19 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((( next("__pragma") )&&( next("__pragma") ))&&synpred10_ObjCpp())) ) {s = 91;}

                        else if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_19);

                        if ( s>=0 ) return s;
                        break;
                    case 1 : 
                        int LA6_20 = input.LA(1);

                         
                        int index6_20 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (((( next("extern") )&&( next("extern") ))&&synpred12_ObjCpp())) ) {s = 92;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_20);

                        if ( s>=0 ) return s;
                        break;
                    case 2 : 
                        int LA6_21 = input.LA(1);

                         
                        int index6_21 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (((( next("using") )&&( next("using") ))&&synpred13_ObjCpp())) ) {s = 93;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_21);

                        if ( s>=0 ) return s;
                        break;
                    case 3 : 
                        int LA6_22 = input.LA(1);

                         
                        int index6_22 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_22);

                        if ( s>=0 ) return s;
                        break;
                    case 4 : 
                        int LA6_23 = input.LA(1);

                         
                        int index6_23 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (((synpred14_ObjCpp()&&synpred14_ObjCpp())&&( parseModifier(next()) != null ))) ) {s = 13;}

                         
                        input.seek(index6_23);

                        if ( s>=0 ) return s;
                        break;
                    case 5 : 
                        int LA6_24 = input.LA(1);

                         
                        int index6_24 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (((( next("using") )&&( next("using") ))&&synpred13_ObjCpp())) ) {s = 93;}

                        else if ( ((((( parseModifier(next()) != null )||( 
                                next(2, "<") ||
                                isTypeIdentifier(next()) || 
                                (
                                  parseModifier(next(1)) == null &&
                                  //(isTypeDef() || !next(2, "=", ",", ";", ":", "[", "(", ")"))
                                  !next(2, "=", ",", ";", ":", "[", "(", ")")
                                ) 
                              ))&&(( parseModifier(next()) != null )||( 
                                next(2, "<") ||
                                isTypeIdentifier(next()) || 
                                (
                                  parseModifier(next(1)) == null &&
                                  //(isTypeDef() || !next(2, "=", ",", ";", ":", "[", "(", ")"))
                                  !next(2, "=", ",", ";", ":", "[", "(", ")")
                                ) 
                              )))&&synpred14_ObjCpp())) ) {s = 13;}

                         
                        input.seek(index6_24);

                        if ( s>=0 ) return s;
                        break;
                    case 6 : 
                        int LA6_25 = input.LA(1);

                         
                        int index6_25 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (((synpred14_ObjCpp()&&synpred14_ObjCpp())&&( parseModifier(next()) != null ))) ) {s = 13;}

                         
                        input.seek(index6_25);

                        if ( s>=0 ) return s;
                        break;
                    case 7 : 
                        int LA6_26 = input.LA(1);

                         
                        int index6_26 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (((synpred14_ObjCpp()&&synpred14_ObjCpp())&&( parseModifier(next()) != null ))) ) {s = 13;}

                         
                        input.seek(index6_26);

                        if ( s>=0 ) return s;
                        break;
                    case 8 : 
                        int LA6_27 = input.LA(1);

                         
                        int index6_27 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_27);

                        if ( s>=0 ) return s;
                        break;
                    case 9 : 
                        int LA6_28 = input.LA(1);

                         
                        int index6_28 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_28);

                        if ( s>=0 ) return s;
                        break;
                    case 10 : 
                        int LA6_29 = input.LA(1);

                         
                        int index6_29 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_29);

                        if ( s>=0 ) return s;
                        break;
                    case 11 : 
                        int LA6_30 = input.LA(1);

                         
                        int index6_30 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_30);

                        if ( s>=0 ) return s;
                        break;
                    case 12 : 
                        int LA6_32 = input.LA(1);

                         
                        int index6_32 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (((synpred14_ObjCpp()&&synpred14_ObjCpp())&&( 
                                next(2, "<") ||
                                isTypeIdentifier(next()) || 
                                (
                                  parseModifier(next(1)) == null &&
                                  //(isTypeDef() || !next(2, "=", ",", ";", ":", "[", "(", ")"))
                                  !next(2, "=", ",", ";", ":", "[", "(", ")")
                                ) 
                              ))) ) {s = 13;}

                         
                        input.seek(index6_32);

                        if ( s>=0 ) return s;
                        break;
                    case 13 : 
                        int LA6_38 = input.LA(1);

                         
                        int index6_38 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_38);

                        if ( s>=0 ) return s;
                        break;
                    case 14 : 
                        int LA6_41 = input.LA(1);

                         
                        int index6_41 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_41);

                        if ( s>=0 ) return s;
                        break;
                    case 15 : 
                        int LA6_44 = input.LA(1);

                         
                        int index6_44 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_44);

                        if ( s>=0 ) return s;
                        break;
                    case 16 : 
                        int LA6_45 = input.LA(1);

                         
                        int index6_45 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_45);

                        if ( s>=0 ) return s;
                        break;
                    case 17 : 
                        int LA6_46 = input.LA(1);

                         
                        int index6_46 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_46);

                        if ( s>=0 ) return s;
                        break;
                    case 18 : 
                        int LA6_47 = input.LA(1);

                         
                        int index6_47 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (((synpred14_ObjCpp()&&synpred14_ObjCpp())&&( 
                                next(2, "<") ||
                                isTypeIdentifier(next()) || 
                                (
                                  parseModifier(next(1)) == null &&
                                  //(isTypeDef() || !next(2, "=", ",", ";", ":", "[", "(", ")"))
                                  !next(2, "=", ",", ";", ":", "[", "(", ")")
                                ) 
                              ))) ) {s = 13;}

                         
                        input.seek(index6_47);

                        if ( s>=0 ) return s;
                        break;
                    case 19 : 
                        int LA6_48 = input.LA(1);

                         
                        int index6_48 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_48);

                        if ( s>=0 ) return s;
                        break;
                    case 20 : 
                        int LA6_49 = input.LA(1);

                         
                        int index6_49 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_49);

                        if ( s>=0 ) return s;
                        break;
                    case 21 : 
                        int LA6_50 = input.LA(1);

                         
                        int index6_50 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_50);

                        if ( s>=0 ) return s;
                        break;
                    case 22 : 
                        int LA6_51 = input.LA(1);

                         
                        int index6_51 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_51);

                        if ( s>=0 ) return s;
                        break;
                    case 23 : 
                        int LA6_52 = input.LA(1);

                         
                        int index6_52 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_52);

                        if ( s>=0 ) return s;
                        break;
                    case 24 : 
                        int LA6_53 = input.LA(1);

                         
                        int index6_53 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_53);

                        if ( s>=0 ) return s;
                        break;
                    case 25 : 
                        int LA6_54 = input.LA(1);

                         
                        int index6_54 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_54);

                        if ( s>=0 ) return s;
                        break;
                    case 26 : 
                        int LA6_55 = input.LA(1);

                         
                        int index6_55 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_55);

                        if ( s>=0 ) return s;
                        break;
                    case 27 : 
                        int LA6_56 = input.LA(1);

                         
                        int index6_56 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_56);

                        if ( s>=0 ) return s;
                        break;
                    case 28 : 
                        int LA6_57 = input.LA(1);

                         
                        int index6_57 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_57);

                        if ( s>=0 ) return s;
                        break;
                    case 29 : 
                        int LA6_58 = input.LA(1);

                         
                        int index6_58 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_58);

                        if ( s>=0 ) return s;
                        break;
                    case 30 : 
                        int LA6_60 = input.LA(1);

                         
                        int index6_60 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_60);

                        if ( s>=0 ) return s;
                        break;
                    case 31 : 
                        int LA6_61 = input.LA(1);

                         
                        int index6_61 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_61);

                        if ( s>=0 ) return s;
                        break;
                    case 32 : 
                        int LA6_62 = input.LA(1);

                         
                        int index6_62 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_62);

                        if ( s>=0 ) return s;
                        break;
                    case 33 : 
                        int LA6_64 = input.LA(1);

                         
                        int index6_64 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_64);

                        if ( s>=0 ) return s;
                        break;
                    case 34 : 
                        int LA6_66 = input.LA(1);

                         
                        int index6_66 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_66);

                        if ( s>=0 ) return s;
                        break;
                    case 35 : 
                        int LA6_67 = input.LA(1);

                         
                        int index6_67 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_67);

                        if ( s>=0 ) return s;
                        break;
                    case 36 : 
                        int LA6_69 = input.LA(1);

                         
                        int index6_69 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_69);

                        if ( s>=0 ) return s;
                        break;
                    case 37 : 
                        int LA6_70 = input.LA(1);

                         
                        int index6_70 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_70);

                        if ( s>=0 ) return s;
                        break;
                    case 38 : 
                        int LA6_71 = input.LA(1);

                         
                        int index6_71 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_71);

                        if ( s>=0 ) return s;
                        break;
                    case 39 : 
                        int LA6_73 = input.LA(1);

                         
                        int index6_73 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_73);

                        if ( s>=0 ) return s;
                        break;
                    case 40 : 
                        int LA6_75 = input.LA(1);

                         
                        int index6_75 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_75);

                        if ( s>=0 ) return s;
                        break;
                    case 41 : 
                        int LA6_76 = input.LA(1);

                         
                        int index6_76 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_76);

                        if ( s>=0 ) return s;
                        break;
                    case 42 : 
                        int LA6_78 = input.LA(1);

                         
                        int index6_78 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_78);

                        if ( s>=0 ) return s;
                        break;
                    case 43 : 
                        int LA6_79 = input.LA(1);

                         
                        int index6_79 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_79);

                        if ( s>=0 ) return s;
                        break;
                    case 44 : 
                        int LA6_80 = input.LA(1);

                         
                        int index6_80 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_80);

                        if ( s>=0 ) return s;
                        break;
                    case 45 : 
                        int LA6_82 = input.LA(1);

                         
                        int index6_82 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_82);

                        if ( s>=0 ) return s;
                        break;
                    case 46 : 
                        int LA6_84 = input.LA(1);

                         
                        int index6_84 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_84);

                        if ( s>=0 ) return s;
                        break;
                    case 47 : 
                        int LA6_85 = input.LA(1);

                         
                        int index6_85 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_85);

                        if ( s>=0 ) return s;
                        break;
                    case 48 : 
                        int LA6_86 = input.LA(1);

                         
                        int index6_86 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred11_ObjCpp()) ) {s = 10;}

                        else if ( (synpred14_ObjCpp()) ) {s = 13;}

                         
                        input.seek(index6_86);

                        if ( s>=0 ) return s;
                        break;
            }
            if (state.backtracking>0) {state.failed=true; return -1;}

            NoViableAltException nvae =
                new NoViableAltException(getDescription(), 6, _s, input);
            error(nvae);
            throw nvae;
        }

    }
    static final String DFA17_eotS =
        "\u0096\uffff";
    static final String DFA17_eofS =
        "\2\5\1\uffff\1\5\u0092\uffff";
    static final String DFA17_minS =
        "\2\4\1\22\2\4\43\uffff\6\0\53\uffff\2\0\51\uffff\2\0\20\uffff";
    static final String DFA17_maxS =
        "\2\150\1\22\2\147\43\uffff\6\0\53\uffff\2\0\51\uffff\2\0\20\uffff";
    static final String DFA17_acceptS =
        "\5\uffff\1\2\u008f\uffff\1\1";
    static final String DFA17_specialS =
        "\50\uffff\1\0\1\1\1\2\1\3\1\4\1\5\53\uffff\1\6\1\7\51\uffff\1\10"+
        "\1\11\20\uffff}>";
    static final String[] DFA17_transitionS = {
            "\2\5\2\uffff\2\5\2\uffff\1\5\1\uffff\1\1\1\uffff\1\4\1\uffff"+
            "\1\5\2\uffff\1\5\1\uffff\4\5\3\uffff\2\5\1\uffff\15\5\3\uffff"+
            "\2\5\1\3\1\uffff\12\5\1\uffff\1\5\1\uffff\1\5\7\uffff\1\5\2"+
            "\uffff\5\5\2\2\20\uffff\5\5",
            "\2\5\2\uffff\2\5\2\uffff\1\5\1\uffff\1\53\1\uffff\1\55\1\uffff"+
            "\1\50\2\uffff\1\5\1\uffff\3\5\1\51\3\uffff\2\5\1\uffff\17\5"+
            "\1\uffff\2\5\1\52\15\5\1\uffff\1\5\7\uffff\1\5\2\uffff\5\5\2"+
            "\54\2\uffff\1\5\2\uffff\1\5\4\uffff\1\5\2\uffff\2\5\1\uffff"+
            "\5\5",
            "\1\131",
            "\1\5\3\uffff\2\5\2\uffff\1\5\1\uffff\1\132\1\uffff\1\5\1\uffff"+
            "\1\5\2\uffff\1\5\1\uffff\1\5\1\uffff\2\5\3\uffff\1\5\1\uffff"+
            "\1\5\3\uffff\1\5\1\uffff\1\5\1\uffff\2\5\1\uffff\2\5\6\uffff"+
            "\2\5\14\uffff\2\5\1\uffff\1\5\5\uffff\1\5\2\uffff\2\5\1\uffff"+
            "\1\5\1\uffff\6\5\1\uffff\13\5\3\uffff\1\5",
            "\1\5\3\uffff\2\5\2\uffff\1\5\1\uffff\1\u0084\1\uffff\1\5\1"+
            "\uffff\1\5\2\uffff\1\5\1\uffff\1\u0085\2\uffff\1\5\3\uffff\1"+
            "\5\5\uffff\1\5\1\uffff\1\5\1\uffff\2\5\1\uffff\2\5\25\uffff"+
            "\1\5\7\uffff\1\5\2\uffff\2\5\30\uffff\1\5",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\uffff",
            "\1\uffff",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\uffff",
            "\1\uffff",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA17_eot = DFA.unpackEncodedString(DFA17_eotS);
    static final short[] DFA17_eof = DFA.unpackEncodedString(DFA17_eofS);
    static final char[] DFA17_min = DFA.unpackEncodedStringToUnsignedChars(DFA17_minS);
    static final char[] DFA17_max = DFA.unpackEncodedStringToUnsignedChars(DFA17_maxS);
    static final short[] DFA17_accept = DFA.unpackEncodedString(DFA17_acceptS);
    static final short[] DFA17_special = DFA.unpackEncodedString(DFA17_specialS);
    static final short[][] DFA17_transition;

    static {
        int numStates = DFA17_transitionS.length;
        DFA17_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA17_transition[i] = DFA.unpackEncodedString(DFA17_transitionS[i]);
        }
    }

    class DFA17 extends DFA {

        public DFA17(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 17;
            this.eot = DFA17_eot;
            this.eof = DFA17_eof;
            this.min = DFA17_min;
            this.max = DFA17_max;
            this.accept = DFA17_accept;
            this.special = DFA17_special;
            this.transition = DFA17_transition;
        }
        public String getDescription() {
            return "695:9: ( (m2= modifiers )? ( ':' IDENTIFIER )? nb= enumBody |)";
        }
        public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
            TokenStream input = (TokenStream)_input;
        	int _s = s;
            switch ( s ) {
                    case 0 : 
                        int LA17_40 = input.LA(1);

                         
                        int index17_40 = input.index();
                        input.rewind();

                        s = -1;
                        if ( ((((( next("__pragma") )||( next("__asm") )||( next("__success") )||( next(ModifierKind.VCAnnotation1Arg, ModifierKind.VCAnnotation2Args) ))&&(( next("__pragma") )||( next("__asm") )||( next("__success") )||( next(ModifierKind.VCAnnotation1Arg, ModifierKind.VCAnnotation2Args) )))&&synpred30_ObjCpp())) ) {s = 149;}

                        else if ( (true) ) {s = 5;}

                         
                        input.seek(index17_40);

                        if ( s>=0 ) return s;
                        break;
                    case 1 : 
                        int LA17_41 = input.LA(1);

                         
                        int index17_41 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((( next("extern") )&&( next("extern") ))&&synpred30_ObjCpp())) ) {s = 149;}

                        else if ( (true) ) {s = 5;}

                         
                        input.seek(index17_41);

                        if ( s>=0 ) return s;
                        break;
                    case 2 : 
                        int LA17_42 = input.LA(1);

                         
                        int index17_42 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((synpred30_ObjCpp()&&synpred30_ObjCpp())&&( parseModifier(next()) != null ))) ) {s = 149;}

                        else if ( (true) ) {s = 5;}

                         
                        input.seek(index17_42);

                        if ( s>=0 ) return s;
                        break;
                    case 3 : 
                        int LA17_43 = input.LA(1);

                         
                        int index17_43 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((synpred30_ObjCpp()&&synpred30_ObjCpp())&&( parseModifier(next()) != null ))) ) {s = 149;}

                        else if ( (true) ) {s = 5;}

                         
                        input.seek(index17_43);

                        if ( s>=0 ) return s;
                        break;
                    case 4 : 
                        int LA17_44 = input.LA(1);

                         
                        int index17_44 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((synpred30_ObjCpp()&&synpred30_ObjCpp())&&( parseModifier(next()) != null ))) ) {s = 149;}

                        else if ( (true) ) {s = 5;}

                         
                        input.seek(index17_44);

                        if ( s>=0 ) return s;
                        break;
                    case 5 : 
                        int LA17_45 = input.LA(1);

                         
                        int index17_45 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((synpred30_ObjCpp()&&synpred30_ObjCpp())&&( parseModifier(next()) != null ))) ) {s = 149;}

                        else if ( (true) ) {s = 5;}

                         
                        input.seek(index17_45);

                        if ( s>=0 ) return s;
                        break;
                    case 6 : 
                        int LA17_89 = input.LA(1);

                         
                        int index17_89 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred30_ObjCpp()) ) {s = 149;}

                        else if ( (true) ) {s = 5;}

                         
                        input.seek(index17_89);

                        if ( s>=0 ) return s;
                        break;
                    case 7 : 
                        int LA17_90 = input.LA(1);

                         
                        int index17_90 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred30_ObjCpp()) ) {s = 149;}

                        else if ( (true) ) {s = 5;}

                         
                        input.seek(index17_90);

                        if ( s>=0 ) return s;
                        break;
                    case 8 : 
                        int LA17_132 = input.LA(1);

                         
                        int index17_132 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred30_ObjCpp()) ) {s = 149;}

                        else if ( (true) ) {s = 5;}

                         
                        input.seek(index17_132);

                        if ( s>=0 ) return s;
                        break;
                    case 9 : 
                        int LA17_133 = input.LA(1);

                         
                        int index17_133 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred30_ObjCpp()) ) {s = 149;}

                        else if ( (true) ) {s = 5;}

                         
                        input.seek(index17_133);

                        if ( s>=0 ) return s;
                        break;
            }
            if (state.backtracking>0) {state.failed=true; return -1;}

            NoViableAltException nvae =
                new NoViableAltException(getDescription(), 17, _s, input);
            error(nvae);
            throw nvae;
        }

    }
    static final String DFA26_eotS =
        "\151\uffff";
    static final String DFA26_eofS =
        "\151\uffff";
    static final String DFA26_minS =
        "\1\16\1\5\1\22\6\16\1\uffff\1\0\2\16\1\uffff\11\0\1\uffff\3\0\2"+
        "\uffff\21\0\1\uffff\1\0\3\uffff\1\0\1\uffff\2\0\2\uffff\2\0\34\uffff"+
        "\1\0\1\uffff\2\0\2\uffff\2\0\1\uffff\1\0\1\uffff\2\0\2\uffff\2\0"+
        "\1\uffff";
    static final String DFA26_maxS =
        "\2\142\1\22\1\64\1\16\4\123\1\uffff\1\0\2\123\1\uffff\11\0\1\uffff"+
        "\3\0\2\uffff\21\0\1\uffff\1\0\3\uffff\1\0\1\uffff\2\0\2\uffff\2"+
        "\0\34\uffff\1\0\1\uffff\2\0\2\uffff\2\0\1\uffff\1\0\1\uffff\2\0"+
        "\2\uffff\2\0\1\uffff";
    static final String DFA26_acceptS =
        "\11\uffff\1\1\3\uffff\1\2\133\uffff";
    static final String DFA26_specialS =
        "\1\0\1\1\2\uffff\1\2\5\uffff\1\3\3\uffff\1\4\1\5\1\6\1\7\1\10\1"+
        "\11\1\12\1\13\1\14\1\uffff\1\15\1\16\1\17\2\uffff\1\20\1\21\1\22"+
        "\1\23\1\24\1\25\1\26\1\27\1\30\1\31\1\32\1\33\1\34\1\35\1\36\1\37"+
        "\1\40\1\uffff\1\41\3\uffff\1\42\1\uffff\1\43\1\44\2\uffff\1\45\1"+
        "\46\34\uffff\1\47\1\uffff\1\50\1\51\2\uffff\1\52\1\53\1\uffff\1"+
        "\54\1\uffff\1\55\1\56\2\uffff\1\57\1\60\1\uffff}>";
    static final String[] DFA26_transitionS = {
            "\1\1\3\uffff\1\7\6\uffff\1\12\12\uffff\1\13\1\uffff\1\10\14"+
            "\uffff\1\11\1\4\31\uffff\1\15\1\uffff\1\14\1\uffff\2\2\2\uffff"+
            "\1\5\2\uffff\1\6\4\uffff\1\5\2\uffff\1\3\1\5",
            "\1\11\10\uffff\1\20\3\uffff\1\16\6\uffff\1\30\1\17\11\uffff"+
            "\1\35\1\uffff\1\26\14\uffff\1\11\1\23\1\31\3\uffff\1\11\24\uffff"+
            "\1\32\1\uffff\1\36\1\uffff\2\21\2\uffff\1\24\2\uffff\1\25\4"+
            "\uffff\1\24\2\uffff\1\22\1\24",
            "\1\37",
            "\1\41\45\uffff\1\40",
            "\1\42",
            "\1\43\1\uffff\1\45\43\uffff\1\46\35\uffff\2\44",
            "\1\47\1\uffff\1\52\42\uffff\1\51\1\53\35\uffff\2\50",
            "\1\54\3\uffff\1\11\5\uffff\1\15\13\uffff\1\11\1\uffff\1\57"+
            "\14\uffff\1\11\34\uffff\1\57\1\uffff\2\55",
            "\1\63\3\uffff\1\65\6\uffff\1\15\12\uffff\1\71\1\uffff\1\66"+
            "\14\uffff\1\11\32\uffff\1\15\1\uffff\1\72\1\uffff\2\11",
            "",
            "\1\uffff",
            "\1\127\3\uffff\1\131\6\uffff\1\15\12\uffff\1\135\1\uffff\1"+
            "\132\14\uffff\1\11\32\uffff\1\15\1\uffff\1\136\1\uffff\2\11",
            "\1\140\3\uffff\1\142\6\uffff\1\15\12\uffff\1\146\1\uffff\1"+
            "\143\14\uffff\1\11\32\uffff\1\15\1\uffff\1\147\1\uffff\2\11",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "\1\uffff",
            "",
            "",
            "",
            "\1\uffff",
            "",
            "\1\uffff",
            "\1\uffff",
            "",
            "",
            "\1\uffff",
            "\1\uffff",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\uffff",
            "",
            "\1\uffff",
            "\1\uffff",
            "",
            "",
            "\1\uffff",
            "\1\uffff",
            "",
            "\1\uffff",
            "",
            "\1\uffff",
            "\1\uffff",
            "",
            "",
            "\1\uffff",
            "\1\uffff",
            ""
    };

    static final short[] DFA26_eot = DFA.unpackEncodedString(DFA26_eotS);
    static final short[] DFA26_eof = DFA.unpackEncodedString(DFA26_eofS);
    static final char[] DFA26_min = DFA.unpackEncodedStringToUnsignedChars(DFA26_minS);
    static final char[] DFA26_max = DFA.unpackEncodedStringToUnsignedChars(DFA26_maxS);
    static final short[] DFA26_accept = DFA.unpackEncodedString(DFA26_acceptS);
    static final short[] DFA26_special = DFA.unpackEncodedString(DFA26_specialS);
    static final short[][] DFA26_transition;

    static {
        int numStates = DFA26_transitionS.length;
        DFA26_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA26_transition[i] = DFA.unpackEncodedString(DFA26_transitionS[i]);
        }
    }

    class DFA26 extends DFA {

        public DFA26(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 26;
            this.eot = DFA26_eot;
            this.eof = DFA26_eof;
            this.min = DFA26_min;
            this.max = DFA26_max;
            this.accept = DFA26_accept;
            this.special = DFA26_special;
            this.transition = DFA26_transition;
        }
        public String getDescription() {
            return "792:1: functionPointerOrSimpleVarDecl returns [Declaration decl] : (fv= varDecl | functionPointerVarDecl );";
        }
        public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
            TokenStream input = (TokenStream)_input;
        	int _s = s;
            switch ( s ) {
                    case 0 : 
                        int LA26_0 = input.LA(1);

                         
                        int index26_0 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (LA26_0==IDENTIFIER) ) {s = 1;}

                        else if ( ((LA26_0 >= 82 && LA26_0 <= 83)) ) {s = 2;}

                        else if ( (LA26_0==97) ) {s = 3;}

                        else if ( (LA26_0==52) && (( 
                                next(2, "<") ||
                                isTypeIdentifier(next()) || 
                                (
                                  parseModifier(next(1)) == null &&
                                  //(isTypeDef() || !next(2, "=", ",", ";", ":", "[", "(", ")"))
                                  !next(2, "=", ",", ";", ":", "[", "(", ")")
                                ) 
                              ))) {s = 4;}

                        else if ( (LA26_0==86||LA26_0==94||LA26_0==98) ) {s = 5;}

                        else if ( (LA26_0==89) ) {s = 6;}

                        else if ( (LA26_0==LPAREN) ) {s = 7;}

                        else if ( (LA26_0==38) ) {s = 8;}

                        else if ( (LA26_0==51) ) {s = 9;}

                        else if ( (LA26_0==SEMICOLON) ) {s = 10;}

                        else if ( (LA26_0==36) ) {s = 11;}

                        else if ( (LA26_0==80) ) {s = 12;}

                        else if ( (LA26_0==78) ) {s = 13;}

                         
                        input.seek(index26_0);

                        if ( s>=0 ) return s;
                        break;
                    case 1 : 
                        int LA26_1 = input.LA(1);

                         
                        int index26_1 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (LA26_1==LPAREN) ) {s = 14;}

                        else if ( (LA26_1==STRING) ) {s = 15;}

                        else if ( (LA26_1==IDENTIFIER) ) {s = 16;}

                        else if ( ((LA26_1 >= 82 && LA26_1 <= 83)) ) {s = 17;}

                        else if ( (LA26_1==97) ) {s = 18;}

                        else if ( (LA26_1==52) ) {s = 19;}

                        else if ( (LA26_1==86||LA26_1==94||LA26_1==98) ) {s = 20;}

                        else if ( (LA26_1==89) ) {s = 21;}

                        else if ( (LA26_1==38) ) {s = 22;}

                        else if ( (LA26_1==COMMA||LA26_1==51||LA26_1==57) ) {s = 9;}

                        else if ( (LA26_1==SEMICOLON) ) {s = 24;}

                        else if ( (LA26_1==53) && (( 
                                next(2, "<") ||
                                isTypeIdentifier(next()) || 
                                (
                                  parseModifier(next(1)) == null &&
                                  //(isTypeDef() || !next(2, "=", ",", ";", ":", "[", "(", ")"))
                                  !next(2, "=", ",", ";", ":", "[", "(", ")")
                                ) 
                              ))) {s = 25;}

                        else if ( (LA26_1==78) ) {s = 26;}

                        else if ( (LA26_1==36) ) {s = 29;}

                        else if ( (LA26_1==80) ) {s = 30;}

                         
                        input.seek(index26_1);

                        if ( s>=0 ) return s;
                        break;
                    case 2 : 
                        int LA26_4 = input.LA(1);

                         
                        int index26_4 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (LA26_4==IDENTIFIER) && (( 
                                next(2, "<") ||
                                isTypeIdentifier(next()) || 
                                (
                                  parseModifier(next(1)) == null &&
                                  //(isTypeDef() || !next(2, "=", ",", ";", ":", "[", "(", ")"))
                                  !next(2, "=", ",", ";", ":", "[", "(", ")")
                                ) 
                              ))) {s = 34;}

                         
                        input.seek(index26_4);

                        if ( s>=0 ) return s;
                        break;
                    case 3 : 
                        int LA26_10 = input.LA(1);

                         
                        int index26_10 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_10);

                        if ( s>=0 ) return s;
                        break;
                    case 4 : 
                        int LA26_14 = input.LA(1);

                         
                        int index26_14 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_14);

                        if ( s>=0 ) return s;
                        break;
                    case 5 : 
                        int LA26_15 = input.LA(1);

                         
                        int index26_15 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (( next("extern") )) ) {s = 13;}

                         
                        input.seek(index26_15);

                        if ( s>=0 ) return s;
                        break;
                    case 6 : 
                        int LA26_16 = input.LA(1);

                         
                        int index26_16 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_16);

                        if ( s>=0 ) return s;
                        break;
                    case 7 : 
                        int LA26_17 = input.LA(1);

                         
                        int index26_17 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( ((( parseModifier(next()) != null )||( 
                                next(2, "<") ||
                                isTypeIdentifier(next()) || 
                                (
                                  parseModifier(next(1)) == null &&
                                  //(isTypeDef() || !next(2, "=", ",", ";", ":", "[", "(", ")"))
                                  !next(2, "=", ",", ";", ":", "[", "(", ")")
                                ) 
                              )||( next("va_list", "__gnuc_va_list", "__builtin_va_list") ))) ) {s = 13;}

                         
                        input.seek(index26_17);

                        if ( s>=0 ) return s;
                        break;
                    case 8 : 
                        int LA26_18 = input.LA(1);

                         
                        int index26_18 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((( parseModifier(next()) != null )&&( parseModifier(next()) != null ))&&synpred51_ObjCpp())) ) {s = 9;}

                        else if ( (( parseModifier(next()) != null )) ) {s = 13;}

                         
                        input.seek(index26_18);

                        if ( s>=0 ) return s;
                        break;
                    case 9 : 
                        int LA26_19 = input.LA(1);

                         
                        int index26_19 = input.index();
                        input.rewind();

                        s = -1;
                        if ( ((((( parseModifier(next()) != null )||( 
                                next(2, "<") ||
                                isTypeIdentifier(next()) || 
                                (
                                  parseModifier(next(1)) == null &&
                                  //(isTypeDef() || !next(2, "=", ",", ";", ":", "[", "(", ")"))
                                  !next(2, "=", ",", ";", ":", "[", "(", ")")
                                ) 
                              ))&&(( parseModifier(next()) != null )||( 
                                next(2, "<") ||
                                isTypeIdentifier(next()) || 
                                (
                                  parseModifier(next(1)) == null &&
                                  //(isTypeDef() || !next(2, "=", ",", ";", ":", "[", "(", ")"))
                                  !next(2, "=", ",", ";", ":", "[", "(", ")")
                                ) 
                              )))&&synpred51_ObjCpp())) ) {s = 9;}

                        else if ( ((( parseModifier(next()) != null )||( 
                                next(2, "<") ||
                                isTypeIdentifier(next()) || 
                                (
                                  parseModifier(next(1)) == null &&
                                  //(isTypeDef() || !next(2, "=", ",", ";", ":", "[", "(", ")"))
                                  !next(2, "=", ",", ";", ":", "[", "(", ")")
                                ) 
                              ))) ) {s = 13;}

                         
                        input.seek(index26_19);

                        if ( s>=0 ) return s;
                        break;
                    case 10 : 
                        int LA26_20 = input.LA(1);

                         
                        int index26_20 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((( parseModifier(next()) != null )&&( parseModifier(next()) != null ))&&synpred51_ObjCpp())) ) {s = 9;}

                        else if ( (( parseModifier(next()) != null )) ) {s = 13;}

                         
                        input.seek(index26_20);

                        if ( s>=0 ) return s;
                        break;
                    case 11 : 
                        int LA26_21 = input.LA(1);

                         
                        int index26_21 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((( parseModifier(next()) != null )&&( parseModifier(next()) != null ))&&synpred51_ObjCpp())) ) {s = 9;}

                        else if ( (( parseModifier(next()) != null )) ) {s = 13;}

                         
                        input.seek(index26_21);

                        if ( s>=0 ) return s;
                        break;
                    case 12 : 
                        int LA26_22 = input.LA(1);

                         
                        int index26_22 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_22);

                        if ( s>=0 ) return s;
                        break;
                    case 13 : 
                        int LA26_24 = input.LA(1);

                         
                        int index26_24 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_24);

                        if ( s>=0 ) return s;
                        break;
                    case 14 : 
                        int LA26_25 = input.LA(1);

                         
                        int index26_25 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((( 
                                next(2, "<") ||
                                isTypeIdentifier(next()) || 
                                (
                                  parseModifier(next(1)) == null &&
                                  //(isTypeDef() || !next(2, "=", ",", ";", ":", "[", "(", ")"))
                                  !next(2, "=", ",", ";", ":", "[", "(", ")")
                                ) 
                              )&&( 
                                next(2, "<") ||
                                isTypeIdentifier(next()) || 
                                (
                                  parseModifier(next(1)) == null &&
                                  //(isTypeDef() || !next(2, "=", ",", ";", ":", "[", "(", ")"))
                                  !next(2, "=", ",", ";", ":", "[", "(", ")")
                                ) 
                              ))&&synpred51_ObjCpp())) ) {s = 9;}

                        else if ( (( 
                                next(2, "<") ||
                                isTypeIdentifier(next()) || 
                                (
                                  parseModifier(next(1)) == null &&
                                  //(isTypeDef() || !next(2, "=", ",", ";", ":", "[", "(", ")"))
                                  !next(2, "=", ",", ";", ":", "[", "(", ")")
                                ) 
                              )) ) {s = 13;}

                         
                        input.seek(index26_25);

                        if ( s>=0 ) return s;
                        break;
                    case 15 : 
                        int LA26_26 = input.LA(1);

                         
                        int index26_26 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_26);

                        if ( s>=0 ) return s;
                        break;
                    case 16 : 
                        int LA26_29 = input.LA(1);

                         
                        int index26_29 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_29);

                        if ( s>=0 ) return s;
                        break;
                    case 17 : 
                        int LA26_30 = input.LA(1);

                         
                        int index26_30 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_30);

                        if ( s>=0 ) return s;
                        break;
                    case 18 : 
                        int LA26_31 = input.LA(1);

                         
                        int index26_31 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_31);

                        if ( s>=0 ) return s;
                        break;
                    case 19 : 
                        int LA26_32 = input.LA(1);

                         
                        int index26_32 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_32);

                        if ( s>=0 ) return s;
                        break;
                    case 20 : 
                        int LA26_33 = input.LA(1);

                         
                        int index26_33 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_33);

                        if ( s>=0 ) return s;
                        break;
                    case 21 : 
                        int LA26_34 = input.LA(1);

                         
                        int index26_34 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((( 
                                next(2, "<") ||
                                isTypeIdentifier(next()) || 
                                (
                                  parseModifier(next(1)) == null &&
                                  //(isTypeDef() || !next(2, "=", ",", ";", ":", "[", "(", ")"))
                                  !next(2, "=", ",", ";", ":", "[", "(", ")")
                                ) 
                              )&&( 
                                next(2, "<") ||
                                isTypeIdentifier(next()) || 
                                (
                                  parseModifier(next(1)) == null &&
                                  //(isTypeDef() || !next(2, "=", ",", ";", ":", "[", "(", ")"))
                                  !next(2, "=", ",", ";", ":", "[", "(", ")")
                                ) 
                              ))&&synpred51_ObjCpp())) ) {s = 9;}

                        else if ( (( 
                                next(2, "<") ||
                                isTypeIdentifier(next()) || 
                                (
                                  parseModifier(next(1)) == null &&
                                  //(isTypeDef() || !next(2, "=", ",", ";", ":", "[", "(", ")"))
                                  !next(2, "=", ",", ";", ":", "[", "(", ")")
                                ) 
                              )) ) {s = 13;}

                         
                        input.seek(index26_34);

                        if ( s>=0 ) return s;
                        break;
                    case 22 : 
                        int LA26_35 = input.LA(1);

                         
                        int index26_35 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_35);

                        if ( s>=0 ) return s;
                        break;
                    case 23 : 
                        int LA26_36 = input.LA(1);

                         
                        int index26_36 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_36);

                        if ( s>=0 ) return s;
                        break;
                    case 24 : 
                        int LA26_37 = input.LA(1);

                         
                        int index26_37 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_37);

                        if ( s>=0 ) return s;
                        break;
                    case 25 : 
                        int LA26_38 = input.LA(1);

                         
                        int index26_38 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_38);

                        if ( s>=0 ) return s;
                        break;
                    case 26 : 
                        int LA26_39 = input.LA(1);

                         
                        int index26_39 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_39);

                        if ( s>=0 ) return s;
                        break;
                    case 27 : 
                        int LA26_40 = input.LA(1);

                         
                        int index26_40 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_40);

                        if ( s>=0 ) return s;
                        break;
                    case 28 : 
                        int LA26_41 = input.LA(1);

                         
                        int index26_41 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_41);

                        if ( s>=0 ) return s;
                        break;
                    case 29 : 
                        int LA26_42 = input.LA(1);

                         
                        int index26_42 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_42);

                        if ( s>=0 ) return s;
                        break;
                    case 30 : 
                        int LA26_43 = input.LA(1);

                         
                        int index26_43 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_43);

                        if ( s>=0 ) return s;
                        break;
                    case 31 : 
                        int LA26_44 = input.LA(1);

                         
                        int index26_44 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_44);

                        if ( s>=0 ) return s;
                        break;
                    case 32 : 
                        int LA26_45 = input.LA(1);

                         
                        int index26_45 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_45);

                        if ( s>=0 ) return s;
                        break;
                    case 33 : 
                        int LA26_47 = input.LA(1);

                         
                        int index26_47 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_47);

                        if ( s>=0 ) return s;
                        break;
                    case 34 : 
                        int LA26_51 = input.LA(1);

                         
                        int index26_51 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_51);

                        if ( s>=0 ) return s;
                        break;
                    case 35 : 
                        int LA26_53 = input.LA(1);

                         
                        int index26_53 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_53);

                        if ( s>=0 ) return s;
                        break;
                    case 36 : 
                        int LA26_54 = input.LA(1);

                         
                        int index26_54 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_54);

                        if ( s>=0 ) return s;
                        break;
                    case 37 : 
                        int LA26_57 = input.LA(1);

                         
                        int index26_57 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_57);

                        if ( s>=0 ) return s;
                        break;
                    case 38 : 
                        int LA26_58 = input.LA(1);

                         
                        int index26_58 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_58);

                        if ( s>=0 ) return s;
                        break;
                    case 39 : 
                        int LA26_87 = input.LA(1);

                         
                        int index26_87 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_87);

                        if ( s>=0 ) return s;
                        break;
                    case 40 : 
                        int LA26_89 = input.LA(1);

                         
                        int index26_89 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_89);

                        if ( s>=0 ) return s;
                        break;
                    case 41 : 
                        int LA26_90 = input.LA(1);

                         
                        int index26_90 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_90);

                        if ( s>=0 ) return s;
                        break;
                    case 42 : 
                        int LA26_93 = input.LA(1);

                         
                        int index26_93 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_93);

                        if ( s>=0 ) return s;
                        break;
                    case 43 : 
                        int LA26_94 = input.LA(1);

                         
                        int index26_94 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_94);

                        if ( s>=0 ) return s;
                        break;
                    case 44 : 
                        int LA26_96 = input.LA(1);

                         
                        int index26_96 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_96);

                        if ( s>=0 ) return s;
                        break;
                    case 45 : 
                        int LA26_98 = input.LA(1);

                         
                        int index26_98 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_98);

                        if ( s>=0 ) return s;
                        break;
                    case 46 : 
                        int LA26_99 = input.LA(1);

                         
                        int index26_99 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_99);

                        if ( s>=0 ) return s;
                        break;
                    case 47 : 
                        int LA26_102 = input.LA(1);

                         
                        int index26_102 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_102);

                        if ( s>=0 ) return s;
                        break;
                    case 48 : 
                        int LA26_103 = input.LA(1);

                         
                        int index26_103 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred51_ObjCpp()) ) {s = 9;}

                        else if ( (true) ) {s = 13;}

                         
                        input.seek(index26_103);

                        if ( s>=0 ) return s;
                        break;
            }
            if (state.backtracking>0) {state.failed=true; return -1;}

            NoViableAltException nvae =
                new NoViableAltException(getDescription(), 26, _s, input);
            error(nvae);
            throw nvae;
        }

    }
    static final String DFA39_eotS =
        "\172\uffff";
    static final String DFA39_eofS =
        "\172\uffff";
    static final String DFA39_minS =
        "\1\16\1\uffff\1\5\1\22\7\16\1\uffff\1\16\1\uffff\1\10\1\0\5\uffff"+
        "\24\0\5\uffff\1\0\2\uffff\20\0\1\uffff\3\0\1\uffff\4\0\1\uffff\3"+
        "\0\1\uffff\4\0\1\uffff\3\0\1\uffff\5\0\1\uffff\4\0\30\uffff";
    static final String DFA39_maxS =
        "\1\147\1\uffff\1\150\1\22\1\64\1\16\2\123\3\147\1\uffff\1\123\1"+
        "\uffff\1\10\1\0\5\uffff\24\0\5\uffff\1\0\2\uffff\20\0\1\uffff\3"+
        "\0\1\uffff\4\0\1\uffff\3\0\1\uffff\4\0\1\uffff\3\0\1\uffff\5\0\1"+
        "\uffff\4\0\30\uffff";
    static final String DFA39_acceptS =
        "\1\uffff\1\7\11\uffff\1\4\10\uffff\1\6\141\uffff\1\5\1\3\1\2\1\1";
    static final String DFA39_specialS =
        "\17\uffff\1\0\5\uffff\1\1\1\2\1\3\1\4\1\5\1\6\1\7\1\10\1\11\1\12"+
        "\1\13\1\14\1\15\1\16\1\17\1\20\1\21\1\22\1\23\1\24\5\uffff\1\25"+
        "\2\uffff\1\26\1\27\1\30\1\31\1\32\1\33\1\34\1\35\1\36\1\37\1\40"+
        "\1\41\1\42\1\43\1\44\1\45\1\uffff\1\46\1\47\1\50\1\uffff\1\51\1"+
        "\52\1\53\1\54\1\uffff\1\55\1\56\1\57\1\uffff\1\60\1\61\1\62\1\63"+
        "\1\uffff\1\64\1\65\1\66\1\uffff\1\67\1\70\1\71\1\72\1\73\1\uffff"+
        "\1\74\1\75\1\76\1\77\30\uffff}>";
    static final String[] DFA39_transitionS = {
            "\1\2\3\uffff\1\14\4\uffff\1\1\1\uffff\1\17\6\uffff\1\24\3\uffff"+
            "\1\11\1\uffff\1\10\14\uffff\1\16\1\5\14\uffff\1\13\2\uffff\1"+
            "\13\5\uffff\1\13\3\uffff\1\13\1\uffff\1\12\1\uffff\2\3\2\uffff"+
            "\1\6\2\uffff\1\7\2\uffff\1\13\1\uffff\1\6\1\uffff\1\13\1\4\1"+
            "\6\4\uffff\1\13",
            "",
            "\1\61\10\uffff\1\31\3\uffff\1\26\6\uffff\1\44\1\27\3\uffff"+
            "\2\13\1\uffff\3\13\1\40\1\13\1\37\10\13\2\uffff\2\13\1\30\1"+
            "\34\1\25\3\13\1\56\6\13\1\uffff\1\47\2\uffff\1\45\5\uffff\1"+
            "\45\3\uffff\1\42\1\uffff\1\41\1\13\2\32\2\uffff\1\35\2\uffff"+
            "\1\36\2\uffff\1\50\1\uffff\1\35\1\uffff\1\46\1\33\1\35\1\uffff"+
            "\3\13\1\43\1\13",
            "\1\62",
            "\1\64\45\uffff\1\63",
            "\1\65",
            "\1\66\1\uffff\1\70\43\uffff\1\71\35\uffff\2\67",
            "\1\72\1\uffff\1\75\42\uffff\1\74\1\76\35\uffff\2\73",
            "\1\77\3\uffff\1\106\21\uffff\1\103\1\uffff\1\102\14\uffff\1"+
            "\107\32\uffff\1\13\1\uffff\1\104\1\uffff\2\100\23\uffff\1\13",
            "\1\110\3\uffff\1\117\21\uffff\1\114\1\uffff\1\113\14\uffff"+
            "\1\120\32\uffff\1\13\1\uffff\1\115\1\uffff\2\111\23\uffff\1"+
            "\13",
            "\1\121\3\uffff\1\130\21\uffff\1\125\1\uffff\1\124\14\uffff"+
            "\1\131\32\uffff\1\13\1\uffff\1\126\1\uffff\2\122\23\uffff\1"+
            "\13",
            "",
            "\1\132\3\uffff\1\136\5\uffff\1\13\13\uffff\1\137\1\uffff\1"+
            "\134\14\uffff\1\140\34\uffff\1\134\1\uffff\2\133",
            "",
            "\1\141",
            "\1\uffff",
            "",
            "",
            "",
            "",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "",
            "",
            "",
            "",
            "\1\uffff",
            "",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA39_eot = DFA.unpackEncodedString(DFA39_eotS);
    static final short[] DFA39_eof = DFA.unpackEncodedString(DFA39_eofS);
    static final char[] DFA39_min = DFA.unpackEncodedStringToUnsignedChars(DFA39_minS);
    static final char[] DFA39_max = DFA.unpackEncodedStringToUnsignedChars(DFA39_maxS);
    static final short[] DFA39_accept = DFA.unpackEncodedString(DFA39_acceptS);
    static final short[] DFA39_special = DFA.unpackEncodedString(DFA39_specialS);
    static final short[][] DFA39_transition;

    static {
        int numStates = DFA39_transitionS.length;
        DFA39_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA39_transition[i] = DFA.unpackEncodedString(DFA39_transitionS[i]);
        }
    }

    class DFA39 extends DFA {

        public DFA39(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 39;
            this.eot = DFA39_eot;
            this.eof = DFA39_eof;
            this.min = DFA39_min;
            this.max = DFA39_max;
            this.accept = DFA39_accept;
            this.special = DFA39_special;
            this.transition = DFA39_transition;
        }
        public String getDescription() {
            return "()* loopback of 908:7: ( ({...}? IDENTIFIER |{...}? IDENTIFIER |{...}? IDENTIFIER ) ':' |{...}? IDENTIFIER (friendDecl= declaration |friendVar= varDecl SEMICOLON ) | (tp= templatePrefix )? {...}?id= IDENTIFIER s= functionDeclarationSuffix |decl= declaration |fv= varDecl SEMICOLON | lineDirective )*";
        }
        public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
            TokenStream input = (TokenStream)_input;
        	int _s = s;
            switch ( s ) {
                    case 0 : 
                        int LA39_15 = input.LA(1);

                         
                        int index39_15 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_15);

                        if ( s>=0 ) return s;
                        break;
                    case 1 : 
                        int LA39_21 = input.LA(1);

                         
                        int index39_21 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((synpred68_ObjCpp()&&synpred68_ObjCpp())&&( next("template") ))) ) {s = 119;}

                        else if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (((( 
                                next(2, "<") ||
                                isTypeIdentifier(next()) || 
                                (
                                  parseModifier(next(1)) == null &&
                                  //(isTypeDef() || !next(2, "=", ",", ";", ":", "[", "(", ")"))
                                  !next(2, "=", ",", ";", ":", "[", "(", ")")
                                ) 
                              )&&( 
                                next(2, "<") ||
                                isTypeIdentifier(next()) || 
                                (
                                  parseModifier(next(1)) == null &&
                                  //(isTypeDef() || !next(2, "=", ",", ";", ":", "[", "(", ")"))
                                  !next(2, "=", ",", ";", ":", "[", "(", ")")
                                ) 
                              ))&&synpred70_ObjCpp())) ) {s = 118;}

                         
                        input.seek(index39_21);

                        if ( s>=0 ) return s;
                        break;
                    case 2 : 
                        int LA39_22 = input.LA(1);

                         
                        int index39_22 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((( next("friend") )&&( next("friend") ))&&synpred66_ObjCpp())) ) {s = 120;}

                        else if ( (((( next(getCurrentClassName()) )&&( next(getCurrentClassName()) ))&&synpred68_ObjCpp())) ) {s = 119;}

                        else if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_22);

                        if ( s>=0 ) return s;
                        break;
                    case 3 : 
                        int LA39_23 = input.LA(1);

                         
                        int index39_23 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_23);

                        if ( s>=0 ) return s;
                        break;
                    case 4 : 
                        int LA39_24 = input.LA(1);

                         
                        int index39_24 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((synpred64_ObjCpp()&&synpred64_ObjCpp())&&(( next("public") )||( next("protected") )||( next("private") )))) ) {s = 121;}

                        else if ( (((( next("friend") )&&( next("friend") ))&&synpred66_ObjCpp())) ) {s = 120;}

                        else if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_24);

                        if ( s>=0 ) return s;
                        break;
                    case 5 : 
                        int LA39_25 = input.LA(1);

                         
                        int index39_25 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((( next("friend") )&&( next("friend") ))&&synpred66_ObjCpp())) ) {s = 120;}

                        else if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_25);

                        if ( s>=0 ) return s;
                        break;
                    case 6 : 
                        int LA39_26 = input.LA(1);

                         
                        int index39_26 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((( next("friend") )&&( next("friend") ))&&synpred66_ObjCpp())) ) {s = 120;}

                        else if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_26);

                        if ( s>=0 ) return s;
                        break;
                    case 7 : 
                        int LA39_27 = input.LA(1);

                         
                        int index39_27 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((( next("friend") )&&( next("friend") ))&&synpred66_ObjCpp())) ) {s = 120;}

                        else if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (((( parseModifier(next()) != null )&&( parseModifier(next()) != null ))&&synpred70_ObjCpp())) ) {s = 118;}

                         
                        input.seek(index39_27);

                        if ( s>=0 ) return s;
                        break;
                    case 8 : 
                        int LA39_28 = input.LA(1);

                         
                        int index39_28 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((( next("friend") )&&( next("friend") ))&&synpred66_ObjCpp())) ) {s = 120;}

                        else if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( ((((( parseModifier(next()) != null )||( 
                                next(2, "<") ||
                                isTypeIdentifier(next()) || 
                                (
                                  parseModifier(next(1)) == null &&
                                  //(isTypeDef() || !next(2, "=", ",", ";", ":", "[", "(", ")"))
                                  !next(2, "=", ",", ";", ":", "[", "(", ")")
                                ) 
                              ))&&(( parseModifier(next()) != null )||( 
                                next(2, "<") ||
                                isTypeIdentifier(next()) || 
                                (
                                  parseModifier(next(1)) == null &&
                                  //(isTypeDef() || !next(2, "=", ",", ";", ":", "[", "(", ")"))
                                  !next(2, "=", ",", ";", ":", "[", "(", ")")
                                ) 
                              )))&&synpred70_ObjCpp())) ) {s = 118;}

                         
                        input.seek(index39_28);

                        if ( s>=0 ) return s;
                        break;
                    case 9 : 
                        int LA39_29 = input.LA(1);

                         
                        int index39_29 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((( next("friend") )&&( next("friend") ))&&synpred66_ObjCpp())) ) {s = 120;}

                        else if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (((( parseModifier(next()) != null )&&( parseModifier(next()) != null ))&&synpred70_ObjCpp())) ) {s = 118;}

                         
                        input.seek(index39_29);

                        if ( s>=0 ) return s;
                        break;
                    case 10 : 
                        int LA39_30 = input.LA(1);

                         
                        int index39_30 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((( next("friend") )&&( next("friend") ))&&synpred66_ObjCpp())) ) {s = 120;}

                        else if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (((( parseModifier(next()) != null )&&( parseModifier(next()) != null ))&&synpred70_ObjCpp())) ) {s = 118;}

                         
                        input.seek(index39_30);

                        if ( s>=0 ) return s;
                        break;
                    case 11 : 
                        int LA39_31 = input.LA(1);

                         
                        int index39_31 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((( next("friend") )&&( next("friend") ))&&synpred66_ObjCpp())) ) {s = 120;}

                        else if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_31);

                        if ( s>=0 ) return s;
                        break;
                    case 12 : 
                        int LA39_32 = input.LA(1);

                         
                        int index39_32 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((( next("friend") )&&( next("friend") ))&&synpred66_ObjCpp())) ) {s = 120;}

                        else if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_32);

                        if ( s>=0 ) return s;
                        break;
                    case 13 : 
                        int LA39_33 = input.LA(1);

                         
                        int index39_33 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((( next("friend") )&&( next("friend") ))&&synpred66_ObjCpp())) ) {s = 120;}

                        else if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_33);

                        if ( s>=0 ) return s;
                        break;
                    case 14 : 
                        int LA39_34 = input.LA(1);

                         
                        int index39_34 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((( next("friend") )&&( next("friend") ))&&synpred66_ObjCpp())) ) {s = 120;}

                        else if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_34);

                        if ( s>=0 ) return s;
                        break;
                    case 15 : 
                        int LA39_35 = input.LA(1);

                         
                        int index39_35 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((( next("friend") )&&( next("friend") ))&&synpred66_ObjCpp())) ) {s = 120;}

                        else if ( (synpred69_ObjCpp()) ) {s = 11;}

                         
                        input.seek(index39_35);

                        if ( s>=0 ) return s;
                        break;
                    case 16 : 
                        int LA39_36 = input.LA(1);

                         
                        int index39_36 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((( next("friend") )&&( next("friend") ))&&synpred66_ObjCpp())) ) {s = 120;}

                        else if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_36);

                        if ( s>=0 ) return s;
                        break;
                    case 17 : 
                        int LA39_37 = input.LA(1);

                         
                        int index39_37 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((( next("friend") )&&( next("friend") ))&&synpred66_ObjCpp())) ) {s = 120;}

                        else if ( (((( next("__extension__") )&&( next("__extension__") ))&&synpred69_ObjCpp())) ) {s = 11;}

                         
                        input.seek(index39_37);

                        if ( s>=0 ) return s;
                        break;
                    case 18 : 
                        int LA39_38 = input.LA(1);

                         
                        int index39_38 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((( next("friend") )&&( next("friend") ))&&synpred66_ObjCpp())) ) {s = 120;}

                        else if ( (((( next("__extension__") )&&( next("__extension__") ))&&synpred69_ObjCpp())) ) {s = 11;}

                         
                        input.seek(index39_38);

                        if ( s>=0 ) return s;
                        break;
                    case 19 : 
                        int LA39_39 = input.LA(1);

                         
                        int index39_39 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((( next("friend") )&&( next("friend") ))&&synpred66_ObjCpp())) ) {s = 120;}

                        else if ( (((( next("__extension__") )&&( next("__extension__") ))&&synpred69_ObjCpp())) ) {s = 11;}

                         
                        input.seek(index39_39);

                        if ( s>=0 ) return s;
                        break;
                    case 20 : 
                        int LA39_40 = input.LA(1);

                         
                        int index39_40 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((( next("friend") )&&( next("friend") ))&&synpred66_ObjCpp())) ) {s = 120;}

                        else if ( (((( next("__extension__") )&&( next("__extension__") ))&&synpred69_ObjCpp())) ) {s = 11;}

                         
                        input.seek(index39_40);

                        if ( s>=0 ) return s;
                        break;
                    case 21 : 
                        int LA39_46 = input.LA(1);

                         
                        int index39_46 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_46);

                        if ( s>=0 ) return s;
                        break;
                    case 22 : 
                        int LA39_49 = input.LA(1);

                         
                        int index39_49 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_49);

                        if ( s>=0 ) return s;
                        break;
                    case 23 : 
                        int LA39_50 = input.LA(1);

                         
                        int index39_50 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_50);

                        if ( s>=0 ) return s;
                        break;
                    case 24 : 
                        int LA39_51 = input.LA(1);

                         
                        int index39_51 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_51);

                        if ( s>=0 ) return s;
                        break;
                    case 25 : 
                        int LA39_52 = input.LA(1);

                         
                        int index39_52 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_52);

                        if ( s>=0 ) return s;
                        break;
                    case 26 : 
                        int LA39_53 = input.LA(1);

                         
                        int index39_53 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (((( 
                                next(2, "<") ||
                                isTypeIdentifier(next()) || 
                                (
                                  parseModifier(next(1)) == null &&
                                  //(isTypeDef() || !next(2, "=", ",", ";", ":", "[", "(", ")"))
                                  !next(2, "=", ",", ";", ":", "[", "(", ")")
                                ) 
                              )&&( 
                                next(2, "<") ||
                                isTypeIdentifier(next()) || 
                                (
                                  parseModifier(next(1)) == null &&
                                  //(isTypeDef() || !next(2, "=", ",", ";", ":", "[", "(", ")"))
                                  !next(2, "=", ",", ";", ":", "[", "(", ")")
                                ) 
                              ))&&synpred70_ObjCpp())) ) {s = 118;}

                         
                        input.seek(index39_53);

                        if ( s>=0 ) return s;
                        break;
                    case 27 : 
                        int LA39_54 = input.LA(1);

                         
                        int index39_54 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_54);

                        if ( s>=0 ) return s;
                        break;
                    case 28 : 
                        int LA39_55 = input.LA(1);

                         
                        int index39_55 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_55);

                        if ( s>=0 ) return s;
                        break;
                    case 29 : 
                        int LA39_56 = input.LA(1);

                         
                        int index39_56 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_56);

                        if ( s>=0 ) return s;
                        break;
                    case 30 : 
                        int LA39_57 = input.LA(1);

                         
                        int index39_57 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_57);

                        if ( s>=0 ) return s;
                        break;
                    case 31 : 
                        int LA39_58 = input.LA(1);

                         
                        int index39_58 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_58);

                        if ( s>=0 ) return s;
                        break;
                    case 32 : 
                        int LA39_59 = input.LA(1);

                         
                        int index39_59 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_59);

                        if ( s>=0 ) return s;
                        break;
                    case 33 : 
                        int LA39_60 = input.LA(1);

                         
                        int index39_60 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_60);

                        if ( s>=0 ) return s;
                        break;
                    case 34 : 
                        int LA39_61 = input.LA(1);

                         
                        int index39_61 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_61);

                        if ( s>=0 ) return s;
                        break;
                    case 35 : 
                        int LA39_62 = input.LA(1);

                         
                        int index39_62 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_62);

                        if ( s>=0 ) return s;
                        break;
                    case 36 : 
                        int LA39_63 = input.LA(1);

                         
                        int index39_63 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_63);

                        if ( s>=0 ) return s;
                        break;
                    case 37 : 
                        int LA39_64 = input.LA(1);

                         
                        int index39_64 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_64);

                        if ( s>=0 ) return s;
                        break;
                    case 38 : 
                        int LA39_66 = input.LA(1);

                         
                        int index39_66 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_66);

                        if ( s>=0 ) return s;
                        break;
                    case 39 : 
                        int LA39_67 = input.LA(1);

                         
                        int index39_67 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_67);

                        if ( s>=0 ) return s;
                        break;
                    case 40 : 
                        int LA39_68 = input.LA(1);

                         
                        int index39_68 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_68);

                        if ( s>=0 ) return s;
                        break;
                    case 41 : 
                        int LA39_70 = input.LA(1);

                         
                        int index39_70 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_70);

                        if ( s>=0 ) return s;
                        break;
                    case 42 : 
                        int LA39_71 = input.LA(1);

                         
                        int index39_71 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_71);

                        if ( s>=0 ) return s;
                        break;
                    case 43 : 
                        int LA39_72 = input.LA(1);

                         
                        int index39_72 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_72);

                        if ( s>=0 ) return s;
                        break;
                    case 44 : 
                        int LA39_73 = input.LA(1);

                         
                        int index39_73 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_73);

                        if ( s>=0 ) return s;
                        break;
                    case 45 : 
                        int LA39_75 = input.LA(1);

                         
                        int index39_75 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_75);

                        if ( s>=0 ) return s;
                        break;
                    case 46 : 
                        int LA39_76 = input.LA(1);

                         
                        int index39_76 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_76);

                        if ( s>=0 ) return s;
                        break;
                    case 47 : 
                        int LA39_77 = input.LA(1);

                         
                        int index39_77 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_77);

                        if ( s>=0 ) return s;
                        break;
                    case 48 : 
                        int LA39_79 = input.LA(1);

                         
                        int index39_79 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_79);

                        if ( s>=0 ) return s;
                        break;
                    case 49 : 
                        int LA39_80 = input.LA(1);

                         
                        int index39_80 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_80);

                        if ( s>=0 ) return s;
                        break;
                    case 50 : 
                        int LA39_81 = input.LA(1);

                         
                        int index39_81 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_81);

                        if ( s>=0 ) return s;
                        break;
                    case 51 : 
                        int LA39_82 = input.LA(1);

                         
                        int index39_82 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_82);

                        if ( s>=0 ) return s;
                        break;
                    case 52 : 
                        int LA39_84 = input.LA(1);

                         
                        int index39_84 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_84);

                        if ( s>=0 ) return s;
                        break;
                    case 53 : 
                        int LA39_85 = input.LA(1);

                         
                        int index39_85 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_85);

                        if ( s>=0 ) return s;
                        break;
                    case 54 : 
                        int LA39_86 = input.LA(1);

                         
                        int index39_86 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_86);

                        if ( s>=0 ) return s;
                        break;
                    case 55 : 
                        int LA39_88 = input.LA(1);

                         
                        int index39_88 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_88);

                        if ( s>=0 ) return s;
                        break;
                    case 56 : 
                        int LA39_89 = input.LA(1);

                         
                        int index39_89 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_89);

                        if ( s>=0 ) return s;
                        break;
                    case 57 : 
                        int LA39_90 = input.LA(1);

                         
                        int index39_90 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_90);

                        if ( s>=0 ) return s;
                        break;
                    case 58 : 
                        int LA39_91 = input.LA(1);

                         
                        int index39_91 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_91);

                        if ( s>=0 ) return s;
                        break;
                    case 59 : 
                        int LA39_92 = input.LA(1);

                         
                        int index39_92 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_92);

                        if ( s>=0 ) return s;
                        break;
                    case 60 : 
                        int LA39_94 = input.LA(1);

                         
                        int index39_94 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_94);

                        if ( s>=0 ) return s;
                        break;
                    case 61 : 
                        int LA39_95 = input.LA(1);

                         
                        int index39_95 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_95);

                        if ( s>=0 ) return s;
                        break;
                    case 62 : 
                        int LA39_96 = input.LA(1);

                         
                        int index39_96 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_96);

                        if ( s>=0 ) return s;
                        break;
                    case 63 : 
                        int LA39_97 = input.LA(1);

                         
                        int index39_97 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred69_ObjCpp()) ) {s = 11;}

                        else if ( (synpred70_ObjCpp()) ) {s = 118;}

                         
                        input.seek(index39_97);

                        if ( s>=0 ) return s;
                        break;
            }
            if (state.backtracking>0) {state.failed=true; return -1;}

            NoViableAltException nvae =
                new NoViableAltException(getDescription(), 39, _s, input);
            error(nvae);
            throw nvae;
        }

    }
    static final String DFA37_eotS =
        "\165\uffff";
    static final String DFA37_eofS =
        "\165\uffff";
    static final String DFA37_minS =
        "\1\16\1\5\1\22\7\16\1\uffff\1\16\1\uffff\1\10\1\0\4\uffff\15\0\1"+
        "\uffff\2\0\11\uffff\1\0\2\uffff\20\0\1\uffff\3\0\1\uffff\4\0\1\uffff"+
        "\3\0\1\uffff\4\0\1\uffff\3\0\1\uffff\5\0\1\uffff\4\0\25\uffff";
    static final String DFA37_maxS =
        "\1\147\1\150\1\22\1\64\1\16\2\123\3\147\1\uffff\1\123\1\uffff\1"+
        "\10\1\0\4\uffff\15\0\1\uffff\2\0\11\uffff\1\0\2\uffff\20\0\1\uffff"+
        "\3\0\1\uffff\4\0\1\uffff\3\0\1\uffff\4\0\1\uffff\3\0\1\uffff\5\0"+
        "\1\uffff\4\0\25\uffff";
    static final String DFA37_acceptS =
        "\12\uffff\1\1\151\uffff\1\2";
    static final String DFA37_specialS =
        "\16\uffff\1\0\4\uffff\1\1\1\2\1\3\1\4\1\5\1\6\1\7\1\10\1\11\1\12"+
        "\1\13\1\14\1\15\1\uffff\1\16\1\17\11\uffff\1\20\2\uffff\1\21\1\22"+
        "\1\23\1\24\1\25\1\26\1\27\1\30\1\31\1\32\1\33\1\34\1\35\1\36\1\37"+
        "\1\40\1\uffff\1\41\1\42\1\43\1\uffff\1\44\1\45\1\46\1\47\1\uffff"+
        "\1\50\1\51\1\52\1\uffff\1\53\1\54\1\55\1\56\1\uffff\1\57\1\60\1"+
        "\61\1\uffff\1\62\1\63\1\64\1\65\1\66\1\uffff\1\67\1\70\1\71\1\72"+
        "\25\uffff}>";
    static final String[] DFA37_transitionS = {
            "\1\1\3\uffff\1\13\6\uffff\1\16\12\uffff\1\10\1\uffff\1\7\14"+
            "\uffff\1\15\1\4\14\uffff\1\12\2\uffff\1\12\5\uffff\1\12\3\uffff"+
            "\1\12\1\uffff\1\11\1\uffff\2\2\2\uffff\1\5\2\uffff\1\6\2\uffff"+
            "\1\12\1\uffff\1\5\1\uffff\1\12\1\3\1\5\4\uffff\1\12",
            "\1\57\10\uffff\1\26\3\uffff\1\24\6\uffff\1\42\1\25\3\uffff"+
            "\2\12\1\uffff\3\12\1\35\1\12\1\34\10\12\2\uffff\2\12\1\41\1"+
            "\31\1\23\3\12\1\54\6\12\1\uffff\1\12\2\uffff\1\12\5\uffff\1"+
            "\12\3\uffff\1\37\1\uffff\1\36\1\12\2\27\2\uffff\1\32\2\uffff"+
            "\1\33\2\uffff\1\12\1\uffff\1\32\1\uffff\1\12\1\30\1\32\1\uffff"+
            "\5\12",
            "\1\60",
            "\1\62\45\uffff\1\61",
            "\1\63",
            "\1\64\1\uffff\1\66\43\uffff\1\67\35\uffff\2\65",
            "\1\70\1\uffff\1\73\42\uffff\1\72\1\74\35\uffff\2\71",
            "\1\75\3\uffff\1\104\21\uffff\1\101\1\uffff\1\100\14\uffff\1"+
            "\105\32\uffff\1\12\1\uffff\1\102\1\uffff\2\76\23\uffff\1\12",
            "\1\106\3\uffff\1\115\21\uffff\1\112\1\uffff\1\111\14\uffff"+
            "\1\116\32\uffff\1\12\1\uffff\1\113\1\uffff\2\107\23\uffff\1"+
            "\12",
            "\1\117\3\uffff\1\126\21\uffff\1\123\1\uffff\1\122\14\uffff"+
            "\1\127\32\uffff\1\12\1\uffff\1\124\1\uffff\2\120\23\uffff\1"+
            "\12",
            "",
            "\1\130\3\uffff\1\134\5\uffff\1\12\13\uffff\1\135\1\uffff\1"+
            "\132\14\uffff\1\136\34\uffff\1\132\1\uffff\2\131",
            "",
            "\1\137",
            "\1\uffff",
            "",
            "",
            "",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "\1\uffff",
            "\1\uffff",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\uffff",
            "",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA37_eot = DFA.unpackEncodedString(DFA37_eotS);
    static final short[] DFA37_eof = DFA.unpackEncodedString(DFA37_eofS);
    static final char[] DFA37_min = DFA.unpackEncodedStringToUnsignedChars(DFA37_minS);
    static final char[] DFA37_max = DFA.unpackEncodedStringToUnsignedChars(DFA37_maxS);
    static final short[] DFA37_accept = DFA.unpackEncodedString(DFA37_acceptS);
    static final short[] DFA37_special = DFA.unpackEncodedString(DFA37_specialS);
    static final short[][] DFA37_transition;

    static {
        int numStates = DFA37_transitionS.length;
        DFA37_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA37_transition[i] = DFA.unpackEncodedString(DFA37_transitionS[i]);
        }
    }

    class DFA37 extends DFA {

        public DFA37(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 37;
            this.eot = DFA37_eot;
            this.eof = DFA37_eof;
            this.min = DFA37_min;
            this.max = DFA37_max;
            this.accept = DFA37_accept;
            this.special = DFA37_special;
            this.transition = DFA37_transition;
        }
        public String getDescription() {
            return "914:40: (friendDecl= declaration |friendVar= varDecl SEMICOLON )";
        }
        public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
            TokenStream input = (TokenStream)_input;
        	int _s = s;
            switch ( s ) {
                    case 0 : 
                        int LA37_14 = input.LA(1);

                         
                        int index37_14 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_14);

                        if ( s>=0 ) return s;
                        break;
                    case 1 : 
                        int LA37_19 = input.LA(1);

                         
                        int index37_19 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (( 
                                next(2, "<") ||
                                isTypeIdentifier(next()) || 
                                (
                                  parseModifier(next(1)) == null &&
                                  //(isTypeDef() || !next(2, "=", ",", ";", ":", "[", "(", ")"))
                                  !next(2, "=", ",", ";", ":", "[", "(", ")")
                                ) 
                              )) ) {s = 116;}

                         
                        input.seek(index37_19);

                        if ( s>=0 ) return s;
                        break;
                    case 2 : 
                        int LA37_20 = input.LA(1);

                         
                        int index37_20 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_20);

                        if ( s>=0 ) return s;
                        break;
                    case 3 : 
                        int LA37_21 = input.LA(1);

                         
                        int index37_21 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_21);

                        if ( s>=0 ) return s;
                        break;
                    case 4 : 
                        int LA37_22 = input.LA(1);

                         
                        int index37_22 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_22);

                        if ( s>=0 ) return s;
                        break;
                    case 5 : 
                        int LA37_23 = input.LA(1);

                         
                        int index37_23 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_23);

                        if ( s>=0 ) return s;
                        break;
                    case 6 : 
                        int LA37_24 = input.LA(1);

                         
                        int index37_24 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (( parseModifier(next()) != null )) ) {s = 116;}

                         
                        input.seek(index37_24);

                        if ( s>=0 ) return s;
                        break;
                    case 7 : 
                        int LA37_25 = input.LA(1);

                         
                        int index37_25 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( ((( parseModifier(next()) != null )||( 
                                next(2, "<") ||
                                isTypeIdentifier(next()) || 
                                (
                                  parseModifier(next(1)) == null &&
                                  //(isTypeDef() || !next(2, "=", ",", ";", ":", "[", "(", ")"))
                                  !next(2, "=", ",", ";", ":", "[", "(", ")")
                                ) 
                              ))) ) {s = 116;}

                         
                        input.seek(index37_25);

                        if ( s>=0 ) return s;
                        break;
                    case 8 : 
                        int LA37_26 = input.LA(1);

                         
                        int index37_26 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (( parseModifier(next()) != null )) ) {s = 116;}

                         
                        input.seek(index37_26);

                        if ( s>=0 ) return s;
                        break;
                    case 9 : 
                        int LA37_27 = input.LA(1);

                         
                        int index37_27 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (( parseModifier(next()) != null )) ) {s = 116;}

                         
                        input.seek(index37_27);

                        if ( s>=0 ) return s;
                        break;
                    case 10 : 
                        int LA37_28 = input.LA(1);

                         
                        int index37_28 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_28);

                        if ( s>=0 ) return s;
                        break;
                    case 11 : 
                        int LA37_29 = input.LA(1);

                         
                        int index37_29 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_29);

                        if ( s>=0 ) return s;
                        break;
                    case 12 : 
                        int LA37_30 = input.LA(1);

                         
                        int index37_30 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_30);

                        if ( s>=0 ) return s;
                        break;
                    case 13 : 
                        int LA37_31 = input.LA(1);

                         
                        int index37_31 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_31);

                        if ( s>=0 ) return s;
                        break;
                    case 14 : 
                        int LA37_33 = input.LA(1);

                         
                        int index37_33 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_33);

                        if ( s>=0 ) return s;
                        break;
                    case 15 : 
                        int LA37_34 = input.LA(1);

                         
                        int index37_34 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_34);

                        if ( s>=0 ) return s;
                        break;
                    case 16 : 
                        int LA37_44 = input.LA(1);

                         
                        int index37_44 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_44);

                        if ( s>=0 ) return s;
                        break;
                    case 17 : 
                        int LA37_47 = input.LA(1);

                         
                        int index37_47 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_47);

                        if ( s>=0 ) return s;
                        break;
                    case 18 : 
                        int LA37_48 = input.LA(1);

                         
                        int index37_48 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_48);

                        if ( s>=0 ) return s;
                        break;
                    case 19 : 
                        int LA37_49 = input.LA(1);

                         
                        int index37_49 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_49);

                        if ( s>=0 ) return s;
                        break;
                    case 20 : 
                        int LA37_50 = input.LA(1);

                         
                        int index37_50 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_50);

                        if ( s>=0 ) return s;
                        break;
                    case 21 : 
                        int LA37_51 = input.LA(1);

                         
                        int index37_51 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (( 
                                next(2, "<") ||
                                isTypeIdentifier(next()) || 
                                (
                                  parseModifier(next(1)) == null &&
                                  //(isTypeDef() || !next(2, "=", ",", ";", ":", "[", "(", ")"))
                                  !next(2, "=", ",", ";", ":", "[", "(", ")")
                                ) 
                              )) ) {s = 116;}

                         
                        input.seek(index37_51);

                        if ( s>=0 ) return s;
                        break;
                    case 22 : 
                        int LA37_52 = input.LA(1);

                         
                        int index37_52 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_52);

                        if ( s>=0 ) return s;
                        break;
                    case 23 : 
                        int LA37_53 = input.LA(1);

                         
                        int index37_53 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_53);

                        if ( s>=0 ) return s;
                        break;
                    case 24 : 
                        int LA37_54 = input.LA(1);

                         
                        int index37_54 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_54);

                        if ( s>=0 ) return s;
                        break;
                    case 25 : 
                        int LA37_55 = input.LA(1);

                         
                        int index37_55 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_55);

                        if ( s>=0 ) return s;
                        break;
                    case 26 : 
                        int LA37_56 = input.LA(1);

                         
                        int index37_56 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_56);

                        if ( s>=0 ) return s;
                        break;
                    case 27 : 
                        int LA37_57 = input.LA(1);

                         
                        int index37_57 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_57);

                        if ( s>=0 ) return s;
                        break;
                    case 28 : 
                        int LA37_58 = input.LA(1);

                         
                        int index37_58 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_58);

                        if ( s>=0 ) return s;
                        break;
                    case 29 : 
                        int LA37_59 = input.LA(1);

                         
                        int index37_59 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_59);

                        if ( s>=0 ) return s;
                        break;
                    case 30 : 
                        int LA37_60 = input.LA(1);

                         
                        int index37_60 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_60);

                        if ( s>=0 ) return s;
                        break;
                    case 31 : 
                        int LA37_61 = input.LA(1);

                         
                        int index37_61 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_61);

                        if ( s>=0 ) return s;
                        break;
                    case 32 : 
                        int LA37_62 = input.LA(1);

                         
                        int index37_62 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_62);

                        if ( s>=0 ) return s;
                        break;
                    case 33 : 
                        int LA37_64 = input.LA(1);

                         
                        int index37_64 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_64);

                        if ( s>=0 ) return s;
                        break;
                    case 34 : 
                        int LA37_65 = input.LA(1);

                         
                        int index37_65 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_65);

                        if ( s>=0 ) return s;
                        break;
                    case 35 : 
                        int LA37_66 = input.LA(1);

                         
                        int index37_66 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_66);

                        if ( s>=0 ) return s;
                        break;
                    case 36 : 
                        int LA37_68 = input.LA(1);

                         
                        int index37_68 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_68);

                        if ( s>=0 ) return s;
                        break;
                    case 37 : 
                        int LA37_69 = input.LA(1);

                         
                        int index37_69 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_69);

                        if ( s>=0 ) return s;
                        break;
                    case 38 : 
                        int LA37_70 = input.LA(1);

                         
                        int index37_70 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_70);

                        if ( s>=0 ) return s;
                        break;
                    case 39 : 
                        int LA37_71 = input.LA(1);

                         
                        int index37_71 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_71);

                        if ( s>=0 ) return s;
                        break;
                    case 40 : 
                        int LA37_73 = input.LA(1);

                         
                        int index37_73 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_73);

                        if ( s>=0 ) return s;
                        break;
                    case 41 : 
                        int LA37_74 = input.LA(1);

                         
                        int index37_74 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_74);

                        if ( s>=0 ) return s;
                        break;
                    case 42 : 
                        int LA37_75 = input.LA(1);

                         
                        int index37_75 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_75);

                        if ( s>=0 ) return s;
                        break;
                    case 43 : 
                        int LA37_77 = input.LA(1);

                         
                        int index37_77 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_77);

                        if ( s>=0 ) return s;
                        break;
                    case 44 : 
                        int LA37_78 = input.LA(1);

                         
                        int index37_78 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_78);

                        if ( s>=0 ) return s;
                        break;
                    case 45 : 
                        int LA37_79 = input.LA(1);

                         
                        int index37_79 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_79);

                        if ( s>=0 ) return s;
                        break;
                    case 46 : 
                        int LA37_80 = input.LA(1);

                         
                        int index37_80 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_80);

                        if ( s>=0 ) return s;
                        break;
                    case 47 : 
                        int LA37_82 = input.LA(1);

                         
                        int index37_82 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_82);

                        if ( s>=0 ) return s;
                        break;
                    case 48 : 
                        int LA37_83 = input.LA(1);

                         
                        int index37_83 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_83);

                        if ( s>=0 ) return s;
                        break;
                    case 49 : 
                        int LA37_84 = input.LA(1);

                         
                        int index37_84 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_84);

                        if ( s>=0 ) return s;
                        break;
                    case 50 : 
                        int LA37_86 = input.LA(1);

                         
                        int index37_86 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_86);

                        if ( s>=0 ) return s;
                        break;
                    case 51 : 
                        int LA37_87 = input.LA(1);

                         
                        int index37_87 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_87);

                        if ( s>=0 ) return s;
                        break;
                    case 52 : 
                        int LA37_88 = input.LA(1);

                         
                        int index37_88 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_88);

                        if ( s>=0 ) return s;
                        break;
                    case 53 : 
                        int LA37_89 = input.LA(1);

                         
                        int index37_89 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_89);

                        if ( s>=0 ) return s;
                        break;
                    case 54 : 
                        int LA37_90 = input.LA(1);

                         
                        int index37_90 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_90);

                        if ( s>=0 ) return s;
                        break;
                    case 55 : 
                        int LA37_92 = input.LA(1);

                         
                        int index37_92 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_92);

                        if ( s>=0 ) return s;
                        break;
                    case 56 : 
                        int LA37_93 = input.LA(1);

                         
                        int index37_93 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_93);

                        if ( s>=0 ) return s;
                        break;
                    case 57 : 
                        int LA37_94 = input.LA(1);

                         
                        int index37_94 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_94);

                        if ( s>=0 ) return s;
                        break;
                    case 58 : 
                        int LA37_95 = input.LA(1);

                         
                        int index37_95 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred65_ObjCpp()) ) {s = 10;}

                        else if ( (true) ) {s = 116;}

                         
                        input.seek(index37_95);

                        if ( s>=0 ) return s;
                        break;
            }
            if (state.backtracking>0) {state.failed=true; return -1;}

            NoViableAltException nvae =
                new NoViableAltException(getDescription(), 37, _s, input);
            error(nvae);
            throw nvae;
        }

    }
    static final String DFA44_eotS =
        "\u00a5\uffff";
    static final String DFA44_eofS =
        "\2\5\1\uffff\1\5\u00a1\uffff";
    static final String DFA44_minS =
        "\2\4\1\22\2\4\43\uffff\6\0\53\uffff\1\0\1\uffff\2\0\47\uffff\1\0"+
        "\5\uffff\2\0\1\uffff\3\0\2\uffff\1\0\4\uffff\1\0\15\uffff";
    static final String DFA44_maxS =
        "\2\150\1\22\2\147\43\uffff\6\0\53\uffff\1\0\1\uffff\2\0\47\uffff"+
        "\1\0\5\uffff\2\0\1\uffff\3\0\2\uffff\1\0\4\uffff\1\0\15\uffff";
    static final String DFA44_acceptS =
        "\5\uffff\1\2\177\uffff\1\1\37\uffff";
    static final String DFA44_specialS =
        "\50\uffff\1\0\1\1\1\2\1\3\1\4\1\5\53\uffff\1\6\1\uffff\1\7\1\10"+
        "\47\uffff\1\11\5\uffff\1\12\1\13\1\uffff\1\14\1\15\1\16\2\uffff"+
        "\1\17\4\uffff\1\20\15\uffff}>";
    static final String[] DFA44_transitionS = {
            "\2\5\2\uffff\2\5\2\uffff\1\5\1\uffff\1\1\1\uffff\1\4\1\uffff"+
            "\1\5\2\uffff\1\5\1\uffff\4\5\3\uffff\2\5\1\uffff\15\5\3\uffff"+
            "\2\5\1\3\1\uffff\12\5\1\uffff\1\5\1\uffff\1\5\7\uffff\1\5\2"+
            "\uffff\5\5\2\2\20\uffff\5\5",
            "\2\5\2\uffff\2\5\2\uffff\1\5\1\uffff\1\53\1\uffff\1\55\1\uffff"+
            "\1\50\2\uffff\1\5\1\uffff\3\5\1\51\3\uffff\2\5\1\uffff\17\5"+
            "\1\uffff\2\5\1\52\15\5\1\uffff\1\5\7\uffff\1\5\2\uffff\5\5\2"+
            "\54\2\uffff\1\5\2\uffff\1\5\4\uffff\1\5\2\uffff\2\5\1\uffff"+
            "\5\5",
            "\1\131",
            "\1\5\3\uffff\2\5\2\uffff\1\5\1\uffff\1\133\1\uffff\1\5\1\uffff"+
            "\1\5\2\uffff\1\5\1\uffff\1\5\1\uffff\2\5\3\uffff\1\5\1\uffff"+
            "\1\5\3\uffff\1\5\1\uffff\1\5\1\uffff\2\5\1\uffff\2\5\6\uffff"+
            "\1\5\1\134\14\uffff\2\5\1\uffff\1\5\5\uffff\1\5\2\uffff\2\5"+
            "\1\uffff\1\5\1\uffff\6\5\1\uffff\13\5\3\uffff\1\5",
            "\1\5\3\uffff\2\5\2\uffff\1\5\1\uffff\1\u0084\1\uffff\1\5\1"+
            "\uffff\1\u008e\2\uffff\1\5\1\uffff\1\u0097\1\uffff\1\u0085\1"+
            "\5\3\uffff\1\5\1\uffff\1\u0085\3\uffff\1\u008b\1\uffff\1\u008a"+
            "\1\uffff\2\5\1\uffff\2\5\6\uffff\2\u0085\14\uffff\1\u0085\1"+
            "\5\1\uffff\1\u0085\5\uffff\1\u0092\2\uffff\1\5\1\u008d\1\uffff"+
            "\1\u0085\1\uffff\2\u0085\2\uffff\1\u0085\2\uffff\1\u0085\2\uffff"+
            "\1\u0085\1\uffff\1\u0085\1\uffff\3\u0085\4\uffff\1\u008f",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\uffff",
            "",
            "\1\uffff",
            "\1\uffff",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\uffff",
            "",
            "",
            "",
            "",
            "",
            "\1\uffff",
            "\1\uffff",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "",
            "\1\uffff",
            "",
            "",
            "",
            "",
            "\1\uffff",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA44_eot = DFA.unpackEncodedString(DFA44_eotS);
    static final short[] DFA44_eof = DFA.unpackEncodedString(DFA44_eofS);
    static final char[] DFA44_min = DFA.unpackEncodedStringToUnsignedChars(DFA44_minS);
    static final char[] DFA44_max = DFA.unpackEncodedStringToUnsignedChars(DFA44_maxS);
    static final short[] DFA44_accept = DFA.unpackEncodedString(DFA44_acceptS);
    static final short[] DFA44_special = DFA.unpackEncodedString(DFA44_specialS);
    static final short[][] DFA44_transition;

    static {
        int numStates = DFA44_transitionS.length;
        DFA44_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA44_transition[i] = DFA.unpackEncodedString(DFA44_transitionS[i]);
        }
    }

    class DFA44 extends DFA {

        public DFA44(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 44;
            this.eot = DFA44_eot;
            this.eof = DFA44_eof;
            this.min = DFA44_min;
            this.max = DFA44_max;
            this.accept = DFA44_accept;
            this.special = DFA44_special;
            this.transition = DFA44_transition;
        }
        public String getDescription() {
            return "993:9: ( ( (m2= modifiers )? ( ':' ({...}?p= IDENTIFIER )? parent= qualifiedIdentifier )? nb= structBody ) |)";
        }
        public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
            TokenStream input = (TokenStream)_input;
        	int _s = s;
            switch ( s ) {
                    case 0 : 
                        int LA44_40 = input.LA(1);

                         
                        int index44_40 = input.index();
                        input.rewind();

                        s = -1;
                        if ( ((((( next("__pragma") )||( next("__asm") )||( next("__success") )||( next(ModifierKind.VCAnnotation1Arg, ModifierKind.VCAnnotation2Args) ))&&(( next("__pragma") )||( next("__asm") )||( next("__success") )||( next(ModifierKind.VCAnnotation1Arg, ModifierKind.VCAnnotation2Args) )))&&synpred79_ObjCpp())) ) {s = 133;}

                        else if ( (true) ) {s = 5;}

                         
                        input.seek(index44_40);

                        if ( s>=0 ) return s;
                        break;
                    case 1 : 
                        int LA44_41 = input.LA(1);

                         
                        int index44_41 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((( next("extern") )&&( next("extern") ))&&synpred79_ObjCpp())) ) {s = 133;}

                        else if ( (true) ) {s = 5;}

                         
                        input.seek(index44_41);

                        if ( s>=0 ) return s;
                        break;
                    case 2 : 
                        int LA44_42 = input.LA(1);

                         
                        int index44_42 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((( parseModifier(next()) != null )&&( parseModifier(next()) != null ))&&synpred79_ObjCpp())) ) {s = 133;}

                        else if ( (true) ) {s = 5;}

                         
                        input.seek(index44_42);

                        if ( s>=0 ) return s;
                        break;
                    case 3 : 
                        int LA44_43 = input.LA(1);

                         
                        int index44_43 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((( parseModifier(next()) != null )&&( parseModifier(next()) != null ))&&synpred79_ObjCpp())) ) {s = 133;}

                        else if ( (true) ) {s = 5;}

                         
                        input.seek(index44_43);

                        if ( s>=0 ) return s;
                        break;
                    case 4 : 
                        int LA44_44 = input.LA(1);

                         
                        int index44_44 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((( parseModifier(next()) != null )&&( parseModifier(next()) != null ))&&synpred79_ObjCpp())) ) {s = 133;}

                        else if ( (true) ) {s = 5;}

                         
                        input.seek(index44_44);

                        if ( s>=0 ) return s;
                        break;
                    case 5 : 
                        int LA44_45 = input.LA(1);

                         
                        int index44_45 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((( parseModifier(next()) != null )&&( parseModifier(next()) != null ))&&synpred79_ObjCpp())) ) {s = 133;}

                        else if ( (true) ) {s = 5;}

                         
                        input.seek(index44_45);

                        if ( s>=0 ) return s;
                        break;
                    case 6 : 
                        int LA44_89 = input.LA(1);

                         
                        int index44_89 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred79_ObjCpp()) ) {s = 133;}

                        else if ( (true) ) {s = 5;}

                         
                        input.seek(index44_89);

                        if ( s>=0 ) return s;
                        break;
                    case 7 : 
                        int LA44_91 = input.LA(1);

                         
                        int index44_91 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred79_ObjCpp()) ) {s = 133;}

                        else if ( (true) ) {s = 5;}

                         
                        input.seek(index44_91);

                        if ( s>=0 ) return s;
                        break;
                    case 8 : 
                        int LA44_92 = input.LA(1);

                         
                        int index44_92 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred79_ObjCpp()) ) {s = 133;}

                        else if ( (true) ) {s = 5;}

                         
                        input.seek(index44_92);

                        if ( s>=0 ) return s;
                        break;
                    case 9 : 
                        int LA44_132 = input.LA(1);

                         
                        int index44_132 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred79_ObjCpp()) ) {s = 133;}

                        else if ( (true) ) {s = 5;}

                         
                        input.seek(index44_132);

                        if ( s>=0 ) return s;
                        break;
                    case 10 : 
                        int LA44_138 = input.LA(1);

                         
                        int index44_138 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred79_ObjCpp()) ) {s = 133;}

                        else if ( (true) ) {s = 5;}

                         
                        input.seek(index44_138);

                        if ( s>=0 ) return s;
                        break;
                    case 11 : 
                        int LA44_139 = input.LA(1);

                         
                        int index44_139 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred79_ObjCpp()) ) {s = 133;}

                        else if ( (true) ) {s = 5;}

                         
                        input.seek(index44_139);

                        if ( s>=0 ) return s;
                        break;
                    case 12 : 
                        int LA44_141 = input.LA(1);

                         
                        int index44_141 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred79_ObjCpp()) ) {s = 133;}

                        else if ( (true) ) {s = 5;}

                         
                        input.seek(index44_141);

                        if ( s>=0 ) return s;
                        break;
                    case 13 : 
                        int LA44_142 = input.LA(1);

                         
                        int index44_142 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred79_ObjCpp()) ) {s = 133;}

                        else if ( (true) ) {s = 5;}

                         
                        input.seek(index44_142);

                        if ( s>=0 ) return s;
                        break;
                    case 14 : 
                        int LA44_143 = input.LA(1);

                         
                        int index44_143 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred79_ObjCpp()) ) {s = 133;}

                        else if ( (true) ) {s = 5;}

                         
                        input.seek(index44_143);

                        if ( s>=0 ) return s;
                        break;
                    case 15 : 
                        int LA44_146 = input.LA(1);

                         
                        int index44_146 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred79_ObjCpp()) ) {s = 133;}

                        else if ( (true) ) {s = 5;}

                         
                        input.seek(index44_146);

                        if ( s>=0 ) return s;
                        break;
                    case 16 : 
                        int LA44_151 = input.LA(1);

                         
                        int index44_151 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred79_ObjCpp()) ) {s = 133;}

                        else if ( (true) ) {s = 5;}

                         
                        input.seek(index44_151);

                        if ( s>=0 ) return s;
                        break;
            }
            if (state.backtracking>0) {state.failed=true; return -1;}

            NoViableAltException nvae =
                new NoViableAltException(getDescription(), 44, _s, input);
            error(nvae);
            throw nvae;
        }

    }
    static final String DFA60_eotS =
        "\137\uffff";
    static final String DFA60_eofS =
        "\1\1\136\uffff";
    static final String DFA60_minS =
        "\1\4\3\uffff\1\0\1\22\130\uffff\1\0";
    static final String DFA60_maxS =
        "\1\150\3\uffff\1\0\1\22\130\uffff\1\0";
    static final String DFA60_acceptS =
        "\1\uffff\1\2\133\uffff\1\1\1\uffff";
    static final String DFA60_specialS =
        "\4\uffff\1\0\131\uffff\1\1}>";
    static final String[] DFA60_transitionS = {
            "\2\1\2\uffff\2\1\2\uffff\1\1\1\uffff\1\4\1\uffff\1\1\1\uffff"+
            "\1\1\2\uffff\1\1\1\uffff\4\1\3\uffff\2\1\1\uffff\15\1\3\uffff"+
            "\16\1\1\uffff\1\1\1\uffff\1\1\7\uffff\1\1\2\uffff\5\1\2\5\2"+
            "\uffff\1\1\2\uffff\1\1\4\uffff\1\1\2\uffff\2\1\1\uffff\5\1",
            "",
            "",
            "",
            "\1\uffff",
            "\1\136",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\uffff"
    };

    static final short[] DFA60_eot = DFA.unpackEncodedString(DFA60_eotS);
    static final short[] DFA60_eof = DFA.unpackEncodedString(DFA60_eofS);
    static final char[] DFA60_min = DFA.unpackEncodedStringToUnsignedChars(DFA60_minS);
    static final char[] DFA60_max = DFA.unpackEncodedStringToUnsignedChars(DFA60_maxS);
    static final short[] DFA60_accept = DFA.unpackEncodedString(DFA60_acceptS);
    static final short[] DFA60_special = DFA.unpackEncodedString(DFA60_specialS);
    static final short[][] DFA60_transition;

    static {
        int numStates = DFA60_transitionS.length;
        DFA60_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA60_transition[i] = DFA.unpackEncodedString(DFA60_transitionS[i]);
        }
    }

    class DFA60 extends DFA {

        public DFA60(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 60;
            this.eot = DFA60_eot;
            this.eof = DFA60_eof;
            this.min = DFA60_min;
            this.max = DFA60_max;
            this.accept = DFA60_accept;
            this.special = DFA60_special;
            this.transition = DFA60_transition;
        }
        public String getDescription() {
            return "()* loopback of 1129:5: (x= modifier )*";
        }
        public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
            TokenStream input = (TokenStream)_input;
        	int _s = s;
            switch ( s ) {
                    case 0 : 
                        int LA60_4 = input.LA(1);

                         
                        int index60_4 = input.index();
                        input.rewind();

                        s = -1;
                        if ( ((((( next("extern") )||( next("__pragma") )||( parseModifier(next()) != null )||( next("__asm") )||( next("__success") )||( next(ModifierKind.VCAnnotation1Arg, ModifierKind.VCAnnotation2Args) ))&&(( next("extern") )||( next("__pragma") )||( parseModifier(next()) != null )||( next("__asm") )||( next("__success") )||( next(ModifierKind.VCAnnotation1Arg, ModifierKind.VCAnnotation2Args) )))&&synpred95_ObjCpp())) ) {s = 93;}

                        else if ( (true) ) {s = 1;}

                         
                        input.seek(index60_4);

                        if ( s>=0 ) return s;
                        break;
                    case 1 : 
                        int LA60_94 = input.LA(1);

                         
                        int index60_94 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred95_ObjCpp()) ) {s = 93;}

                        else if ( (true) ) {s = 1;}

                         
                        input.seek(index60_94);

                        if ( s>=0 ) return s;
                        break;
            }
            if (state.backtracking>0) {state.failed=true; return -1;}

            NoViableAltException nvae =
                new NoViableAltException(getDescription(), 60, _s, input);
            error(nvae);
            throw nvae;
        }

    }
    static final String DFA63_eotS =
        "\174\uffff";
    static final String DFA63_eofS =
        "\1\2\173\uffff";
    static final String DFA63_minS =
        "\1\4\1\0\172\uffff";
    static final String DFA63_maxS =
        "\1\150\1\0\172\uffff";
    static final String DFA63_acceptS =
        "\2\uffff\1\2\170\uffff\1\1";
    static final String DFA63_specialS =
        "\1\uffff\1\0\172\uffff}>";
    static final String[] DFA63_transitionS = {
            "\2\2\2\uffff\2\2\2\uffff\1\2\1\uffff\1\2\1\uffff\1\2\1\uffff"+
            "\1\2\2\uffff\1\2\1\uffff\2\2\1\1\1\2\3\uffff\20\2\3\uffff\16"+
            "\2\1\uffff\3\2\1\uffff\1\2\5\uffff\1\2\2\uffff\34\2",
            "\1\uffff",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA63_eot = DFA.unpackEncodedString(DFA63_eotS);
    static final short[] DFA63_eof = DFA.unpackEncodedString(DFA63_eofS);
    static final char[] DFA63_min = DFA.unpackEncodedStringToUnsignedChars(DFA63_minS);
    static final char[] DFA63_max = DFA.unpackEncodedStringToUnsignedChars(DFA63_maxS);
    static final short[] DFA63_accept = DFA.unpackEncodedString(DFA63_acceptS);
    static final short[] DFA63_special = DFA.unpackEncodedString(DFA63_specialS);
    static final short[][] DFA63_transition;

    static {
        int numStates = DFA63_transitionS.length;
        DFA63_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA63_transition[i] = DFA.unpackEncodedString(DFA63_transitionS[i]);
        }
    }

    class DFA63 extends DFA {

        public DFA63(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 63;
            this.eot = DFA63_eot;
            this.eof = DFA63_eof;
            this.min = DFA63_min;
            this.max = DFA63_max;
            this.accept = DFA63_accept;
            this.special = DFA63_special;
            this.transition = DFA63_transition;
        }
        public String getDescription() {
            return "1142:7: ( SEMICOLON )?";
        }
        public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
            TokenStream input = (TokenStream)_input;
        	int _s = s;
            switch ( s ) {
                    case 0 : 
                        int LA63_1 = input.LA(1);

                         
                        int index63_1 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred105_ObjCpp()) ) {s = 123;}

                        else if ( (true) ) {s = 2;}

                         
                        input.seek(index63_1);

                        if ( s>=0 ) return s;
                        break;
            }
            if (state.backtracking>0) {state.failed=true; return -1;}

            NoViableAltException nvae =
                new NoViableAltException(getDescription(), 63, _s, input);
            error(nvae);
            throw nvae;
        }

    }
    static final String DFA67_eotS =
        "\150\uffff";
    static final String DFA67_eofS =
        "\1\1\147\uffff";
    static final String DFA67_minS =
        "\1\4\20\uffff\1\0\126\uffff";
    static final String DFA67_maxS =
        "\1\150\20\uffff\1\0\126\uffff";
    static final String DFA67_acceptS =
        "\1\uffff\1\2\145\uffff\1\1";
    static final String DFA67_specialS =
        "\21\uffff\1\0\126\uffff}>";
    static final String[] DFA67_transitionS = {
            "\2\1\2\uffff\2\1\2\uffff\1\1\1\uffff\1\1\1\uffff\1\1\1\uffff"+
            "\1\1\2\uffff\1\1\1\uffff\1\1\1\21\2\1\3\uffff\2\1\1\uffff\15"+
            "\1\3\uffff\16\1\1\uffff\1\1\1\uffff\1\1\7\uffff\1\1\2\uffff"+
            "\7\1\2\uffff\1\1\2\uffff\1\1\4\uffff\1\1\2\uffff\2\1\1\uffff"+
            "\5\1",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\uffff",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA67_eot = DFA.unpackEncodedString(DFA67_eotS);
    static final short[] DFA67_eof = DFA.unpackEncodedString(DFA67_eofS);
    static final char[] DFA67_min = DFA.unpackEncodedStringToUnsignedChars(DFA67_minS);
    static final char[] DFA67_max = DFA.unpackEncodedStringToUnsignedChars(DFA67_maxS);
    static final short[] DFA67_accept = DFA.unpackEncodedString(DFA67_acceptS);
    static final short[] DFA67_special = DFA.unpackEncodedString(DFA67_specialS);
    static final short[][] DFA67_transition;

    static {
        int numStates = DFA67_transitionS.length;
        DFA67_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA67_transition[i] = DFA.unpackEncodedString(DFA67_transitionS[i]);
        }
    }

    class DFA67 extends DFA {

        public DFA67(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 67;
            this.eot = DFA67_eot;
            this.eof = DFA67_eof;
            this.min = DFA67_min;
            this.max = DFA67_max;
            this.accept = DFA67_accept;
            this.special = DFA67_special;
            this.transition = DFA67_transition;
        }
        public String getDescription() {
            return "()+ loopback of 1171:8: ( RPAREN )+";
        }
        public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
            TokenStream input = (TokenStream)_input;
        	int _s = s;
            switch ( s ) {
                    case 0 : 
                        int LA67_17 = input.LA(1);

                         
                        int index67_17 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred113_ObjCpp()) ) {s = 103;}

                        else if ( (true) ) {s = 1;}

                         
                        input.seek(index67_17);

                        if ( s>=0 ) return s;
                        break;
            }
            if (state.backtracking>0) {state.failed=true; return -1;}

            NoViableAltException nvae =
                new NoViableAltException(getDescription(), 67, _s, input);
            error(nvae);
            throw nvae;
        }

    }
    static final String DFA88_eotS =
        "\150\uffff";
    static final String DFA88_eofS =
        "\1\1\7\uffff\1\17\4\uffff\2\17\131\uffff";
    static final String DFA88_minS =
        "\1\5\2\uffff\1\5\1\0\3\uffff\1\5\4\uffff\2\5\1\uffff\2\0\4\uffff"+
        "\1\0\1\uffff\1\0\5\uffff\1\0\33\uffff\5\0\7\uffff\2\0\1\uffff\5"+
        "\0\7\uffff\2\0\1\uffff\5\0\7\uffff\2\0\2\uffff";
    static final String DFA88_maxS =
        "\1\147\2\uffff\1\142\1\0\3\uffff\1\147\4\uffff\2\147\1\uffff\2\0"+
        "\4\uffff\1\0\1\uffff\1\0\5\uffff\1\0\33\uffff\5\0\7\uffff\2\0\1"+
        "\uffff\5\0\7\uffff\2\0\1\uffff\5\0\7\uffff\2\0\2\uffff";
    static final String DFA88_acceptS =
        "\1\uffff\1\4\15\uffff\1\1\51\uffff\1\2\55\uffff\1\3";
    static final String DFA88_specialS =
        "\4\uffff\1\0\13\uffff\1\1\1\2\4\uffff\1\3\1\uffff\1\4\5\uffff\1"+
        "\5\33\uffff\1\6\1\7\1\10\1\11\1\12\7\uffff\1\13\1\14\1\uffff\1\15"+
        "\1\16\1\17\1\20\1\21\7\uffff\1\22\1\23\1\uffff\1\24\1\25\1\26\1"+
        "\27\1\30\7\uffff\1\31\1\32\2\uffff}>";
    static final String[] DFA88_transitionS = {
            "\1\1\10\uffff\1\4\3\uffff\1\3\5\uffff\2\1\12\uffff\1\15\1\uffff"+
            "\1\10\14\uffff\1\1\5\uffff\1\1\1\uffff\1\1\22\uffff\1\17\1\uffff"+
            "\1\16\1\uffff\2\1\23\uffff\1\1",
            "",
            "",
            "\1\1\10\uffff\1\20\3\uffff\1\1\5\uffff\1\36\13\uffff\1\1\1"+
            "\uffff\1\26\11\uffff\1\1\2\uffff\2\1\4\uffff\1\1\24\uffff\1"+
            "\1\1\uffff\1\30\1\uffff\2\21\2\uffff\1\1\2\uffff\1\1\4\uffff"+
            "\1\1\2\uffff\2\1",
            "\1\uffff",
            "",
            "",
            "",
            "\1\17\10\uffff\1\72\3\uffff\1\74\5\uffff\2\17\12\uffff\1\106"+
            "\1\uffff\1\75\14\uffff\1\76\5\uffff\1\17\1\uffff\1\17\22\uffff"+
            "\1\17\1\uffff\1\107\1\uffff\2\73\23\uffff\1\17",
            "",
            "",
            "",
            "",
            "\1\17\10\uffff\1\111\3\uffff\1\113\5\uffff\2\17\12\uffff\1"+
            "\125\1\uffff\1\114\14\uffff\1\115\5\uffff\1\17\1\uffff\1\17"+
            "\22\uffff\1\17\1\uffff\1\126\1\uffff\2\112\23\uffff\1\17",
            "\1\17\10\uffff\1\130\3\uffff\1\132\5\uffff\2\17\12\uffff\1"+
            "\144\1\uffff\1\133\14\uffff\1\134\5\uffff\1\17\1\uffff\1\17"+
            "\22\uffff\1\17\1\uffff\1\145\1\uffff\2\131\23\uffff\1\17",
            "",
            "\1\uffff",
            "\1\uffff",
            "",
            "",
            "",
            "",
            "\1\uffff",
            "",
            "\1\uffff",
            "",
            "",
            "",
            "",
            "",
            "\1\uffff",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\uffff",
            "\1\uffff",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\uffff",
            "\1\uffff",
            "",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "\1\uffff",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\uffff",
            "\1\uffff",
            "",
            ""
    };

    static final short[] DFA88_eot = DFA.unpackEncodedString(DFA88_eotS);
    static final short[] DFA88_eof = DFA.unpackEncodedString(DFA88_eofS);
    static final char[] DFA88_min = DFA.unpackEncodedStringToUnsignedChars(DFA88_minS);
    static final char[] DFA88_max = DFA.unpackEncodedStringToUnsignedChars(DFA88_maxS);
    static final short[] DFA88_accept = DFA.unpackEncodedString(DFA88_acceptS);
    static final short[] DFA88_special = DFA.unpackEncodedString(DFA88_specialS);
    static final short[][] DFA88_transition;

    static {
        int numStates = DFA88_transitionS.length;
        DFA88_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA88_transition[i] = DFA.unpackEncodedString(DFA88_transitionS[i]);
        }
    }

    class DFA88 extends DFA {

        public DFA88(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 88;
            this.eot = DFA88_eot;
            this.eof = DFA88_eof;
            this.min = DFA88_min;
            this.max = DFA88_max;
            this.accept = DFA88_accept;
            this.special = DFA88_special;
            this.transition = DFA88_transition;
        }
        public String getDescription() {
            return "()* loopback of 1381:5: ( (m1= typeMutator ) | ({...}?m= IDENTIFIER ) | (f1= functionSignatureSuffix ) )*";
        }
        public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
            TokenStream input = (TokenStream)_input;
        	int _s = s;
            switch ( s ) {
                    case 0 : 
                        int LA88_4 = input.LA(1);

                         
                        int index88_4 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (((( next("const", "__const") )&&( next("const", "__const") ))&&synpred141_ObjCpp())) ) {s = 15;}

                        else if ( (((( next(ModifierKind.StorageClassSpecifier) )&&( next(ModifierKind.StorageClassSpecifier) ))&&synpred142_ObjCpp())) ) {s = 57;}

                        else if ( (true) ) {s = 1;}

                         
                        input.seek(index88_4);

                        if ( s>=0 ) return s;
                        break;
                    case 1 : 
                        int LA88_16 = input.LA(1);

                         
                        int index88_16 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred143_ObjCpp()) ) {s = 103;}

                        else if ( (true) ) {s = 1;}

                         
                        input.seek(index88_16);

                        if ( s>=0 ) return s;
                        break;
                    case 2 : 
                        int LA88_17 = input.LA(1);

                         
                        int index88_17 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred143_ObjCpp()) ) {s = 103;}

                        else if ( (true) ) {s = 1;}

                         
                        input.seek(index88_17);

                        if ( s>=0 ) return s;
                        break;
                    case 3 : 
                        int LA88_22 = input.LA(1);

                         
                        int index88_22 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred143_ObjCpp()) ) {s = 103;}

                        else if ( (true) ) {s = 1;}

                         
                        input.seek(index88_22);

                        if ( s>=0 ) return s;
                        break;
                    case 4 : 
                        int LA88_24 = input.LA(1);

                         
                        int index88_24 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred143_ObjCpp()) ) {s = 103;}

                        else if ( (true) ) {s = 1;}

                         
                        input.seek(index88_24);

                        if ( s>=0 ) return s;
                        break;
                    case 5 : 
                        int LA88_30 = input.LA(1);

                         
                        int index88_30 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred143_ObjCpp()) ) {s = 103;}

                        else if ( (true) ) {s = 1;}

                         
                        input.seek(index88_30);

                        if ( s>=0 ) return s;
                        break;
                    case 6 : 
                        int LA88_58 = input.LA(1);

                         
                        int index88_58 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred141_ObjCpp()) ) {s = 15;}

                        else if ( (true) ) {s = 1;}

                         
                        input.seek(index88_58);

                        if ( s>=0 ) return s;
                        break;
                    case 7 : 
                        int LA88_59 = input.LA(1);

                         
                        int index88_59 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred141_ObjCpp()) ) {s = 15;}

                        else if ( (true) ) {s = 1;}

                         
                        input.seek(index88_59);

                        if ( s>=0 ) return s;
                        break;
                    case 8 : 
                        int LA88_60 = input.LA(1);

                         
                        int index88_60 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred141_ObjCpp()) ) {s = 15;}

                        else if ( (true) ) {s = 1;}

                         
                        input.seek(index88_60);

                        if ( s>=0 ) return s;
                        break;
                    case 9 : 
                        int LA88_61 = input.LA(1);

                         
                        int index88_61 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred141_ObjCpp()) ) {s = 15;}

                        else if ( (true) ) {s = 1;}

                         
                        input.seek(index88_61);

                        if ( s>=0 ) return s;
                        break;
                    case 10 : 
                        int LA88_62 = input.LA(1);

                         
                        int index88_62 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred141_ObjCpp()) ) {s = 15;}

                        else if ( (true) ) {s = 1;}

                         
                        input.seek(index88_62);

                        if ( s>=0 ) return s;
                        break;
                    case 11 : 
                        int LA88_70 = input.LA(1);

                         
                        int index88_70 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred141_ObjCpp()) ) {s = 15;}

                        else if ( (true) ) {s = 1;}

                         
                        input.seek(index88_70);

                        if ( s>=0 ) return s;
                        break;
                    case 12 : 
                        int LA88_71 = input.LA(1);

                         
                        int index88_71 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred141_ObjCpp()) ) {s = 15;}

                        else if ( (true) ) {s = 1;}

                         
                        input.seek(index88_71);

                        if ( s>=0 ) return s;
                        break;
                    case 13 : 
                        int LA88_73 = input.LA(1);

                         
                        int index88_73 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred141_ObjCpp()) ) {s = 15;}

                        else if ( (true) ) {s = 1;}

                         
                        input.seek(index88_73);

                        if ( s>=0 ) return s;
                        break;
                    case 14 : 
                        int LA88_74 = input.LA(1);

                         
                        int index88_74 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred141_ObjCpp()) ) {s = 15;}

                        else if ( (true) ) {s = 1;}

                         
                        input.seek(index88_74);

                        if ( s>=0 ) return s;
                        break;
                    case 15 : 
                        int LA88_75 = input.LA(1);

                         
                        int index88_75 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred141_ObjCpp()) ) {s = 15;}

                        else if ( (true) ) {s = 1;}

                         
                        input.seek(index88_75);

                        if ( s>=0 ) return s;
                        break;
                    case 16 : 
                        int LA88_76 = input.LA(1);

                         
                        int index88_76 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred141_ObjCpp()) ) {s = 15;}

                        else if ( (true) ) {s = 1;}

                         
                        input.seek(index88_76);

                        if ( s>=0 ) return s;
                        break;
                    case 17 : 
                        int LA88_77 = input.LA(1);

                         
                        int index88_77 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred141_ObjCpp()) ) {s = 15;}

                        else if ( (true) ) {s = 1;}

                         
                        input.seek(index88_77);

                        if ( s>=0 ) return s;
                        break;
                    case 18 : 
                        int LA88_85 = input.LA(1);

                         
                        int index88_85 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred141_ObjCpp()) ) {s = 15;}

                        else if ( (true) ) {s = 1;}

                         
                        input.seek(index88_85);

                        if ( s>=0 ) return s;
                        break;
                    case 19 : 
                        int LA88_86 = input.LA(1);

                         
                        int index88_86 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred141_ObjCpp()) ) {s = 15;}

                        else if ( (true) ) {s = 1;}

                         
                        input.seek(index88_86);

                        if ( s>=0 ) return s;
                        break;
                    case 20 : 
                        int LA88_88 = input.LA(1);

                         
                        int index88_88 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred141_ObjCpp()) ) {s = 15;}

                        else if ( (true) ) {s = 1;}

                         
                        input.seek(index88_88);

                        if ( s>=0 ) return s;
                        break;
                    case 21 : 
                        int LA88_89 = input.LA(1);

                         
                        int index88_89 = input.index();
                        input.rewind();

                        s = -1;
                        if ( (synpred141_ObjCpp()) ) {s = 15;}

                        else if ( (true) ) {s = 1;}

                         
                        input.seek(index88_89);

                        if ( s>=0 ) return s;
                        break;
                    case 22 : 
                        int LA88_90 = input.LA(1);

                         
                        int index88_90 = input.