// $ANTLR 3.4 com/ochafik/lang/jnaerator/parser/ObjCDemangling.g 2015-03-28 11:03:43
 
/*
	Copyright (c) 2009 Olivier Chafik, All Rights Reserved
	
	This file is part of JNAerator (http://jnaerator.googlecode.com/).
	
	JNAerator is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.
	
	JNAerator is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.
	
	You should have received a copy of the GNU Lesser General Public License
	along with JNAerator.  If not, see <http://www.gnu.org/licenses/>.
*/

package com.ochafik.lang.jnaerator.parser;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.HashMap;
import java.util.HashSet;


import static com.ochafik.lang.jnaerator.parser.ElementsHelper.*;
import static com.ochafik.lang.jnaerator.parser.TypeRef.*;
import static com.ochafik.lang.jnaerator.parser.Expression.*;
import static com.ochafik.lang.jnaerator.parser.Declaration.*;
import static com.ochafik.lang.jnaerator.parser.Identifier.*;
import static com.ochafik.lang.jnaerator.parser.Statement.*;
import static com.ochafik.lang.jnaerator.parser.Declarator.*;
import static com.ochafik.lang.jnaerator.parser.StoredDeclarations.*;



import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

/**
	This grammar is by no mean complete.
	It is able to parse preprocessed C &amp; Objective-C files and can tolerate some amount of C++. 
	It lacks serious expression support, which is being worked on.
	Complex variable declarations may not be supported, such as complex signatures of functions that return function pointers...
*/
@SuppressWarnings({"all", "warnings", "unchecked"})
public class ObjCDemanglingParser extends Parser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "CharEscape", "DECIMAL_NUMBER", "IDENTIFIER", "Letter", "OCTAL_NUMBER", "OctalEscape", "STRING", "'#'", "'('", "')'", "'*'", "':'", "'='", "'?'", "'@'", "'['", "']'", "'^'", "'b'", "'{'", "'}'"
    };

    public static final int EOF=-1;
    public static final int T__11=11;
    public static final int T__12=12;
    public static final int T__13=13;
    public static final int T__14=14;
    public static final int T__15=15;
    public static final int T__16=16;
    public static final int T__17=17;
    public static final int T__18=18;
    public static final int T__19=19;
    public static final int T__20=20;
    public static final int T__21=21;
    public static final int T__22=22;
    public static final int T__23=23;
    public static final int T__24=24;
    public static final int CharEscape=4;
    public static final int DECIMAL_NUMBER=5;
    public static final int IDENTIFIER=6;
    public static final int Letter=7;
    public static final int OCTAL_NUMBER=8;
    public static final int OctalEscape=9;
    public static final int STRING=10;

    // delegates
    public Parser[] getDelegates() {
        return new Parser[] {};
    }

    // delegators


    public ObjCDemanglingParser(TokenStream input) {
        this(input, new RecognizerSharedState());
    }
    public ObjCDemanglingParser(TokenStream input, RecognizerSharedState state) {
        super(input, state);
    }

    public String[] getTokenNames() { return ObjCDemanglingParser.tokenNames; }
    public String getGrammarFileName() { return "com/ochafik/lang/jnaerator/parser/ObjCDemangling.g"; }


    	protected String next() {
    		return input.LT(1).getText();
    	}
    	
    	static HashMap<String, TypeRef> predefRefs = new HashMap<String, TypeRef>();
    	static {
    		predefRefs.put("c", typeRef("char"));
    		
    		predefRefs.put("i", typeRef("int"));
    		predefRefs.put("s", typeRef("short"));
    		predefRefs.put("l", typeRef("long"));
    		predefRefs.put("q", typeRef("long").addModifiers(ModifierType.Long));
    		predefRefs.put("C", typeRef("char").addModifiers(ModifierType.Unsigned));
    		predefRefs.put("I", typeRef("int").addModifiers(ModifierType.Unsigned));
    		predefRefs.put("S", typeRef("short").addModifiers(ModifierType.Unsigned));
    		predefRefs.put("L", typeRef("long").addModifiers(ModifierType.Unsigned));
    		predefRefs.put("Q", typeRef("long").addModifiers(ModifierType.Unsigned, ModifierType.Long));
    		predefRefs.put("f", typeRef("float"));
    		predefRefs.put("d", typeRef("double"));
    		predefRefs.put("B", typeRef("BOOL"));
    		predefRefs.put("v", typeRef("void"));
    	}
    	boolean isPredefRef(String s) {
    		return predefRefs.containsKey(s);
    	}
    	public TypeRef getPredefRef(String s) {
    		return predefRefs.get(s).clone();
    	}



    // $ANTLR start "mangledTypeEOF"
    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:129:1: mangledTypeEOF returns [TypeRef type] : mangledType EOF ;
    public final TypeRef mangledTypeEOF() throws RecognitionException {
        TypeRef type = null;


        TypeRef mangledType1 =null;


        try {
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:129:39: ( mangledType EOF )
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:129:41: mangledType EOF
            {
            pushFollow(FOLLOW_mangledType_in_mangledTypeEOF60);
            mangledType1=mangledType();

            state._fsp--;


             type = mangledType1; 

            match(input,EOF,FOLLOW_EOF_in_mangledTypeEOF64); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return type;
    }
    // $ANTLR end "mangledTypeEOF"



    // $ANTLR start "mangledType"
    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:130:1: mangledType returns [TypeRef type] : ( structType | unionType | arrayType | primitiveType | '^' (pointed= mangledType ) );
    public final TypeRef mangledType() throws RecognitionException {
        TypeRef type = null;


        TypeRef pointed =null;

        Struct structType2 =null;

        Struct unionType3 =null;

        TypeRef arrayType4 =null;

        TypeRef primitiveType5 =null;


        try {
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:131:2: ( structType | unionType | arrayType | primitiveType | '^' (pointed= mangledType ) )
            int alt1=5;
            switch ( input.LA(1) ) {
            case 23:
                {
                alt1=1;
                }
                break;
            case 12:
                {
                alt1=2;
                }
                break;
            case 19:
                {
                alt1=3;
                }
                break;
            case IDENTIFIER:
            case 11:
            case 14:
            case 15:
            case 17:
            case 18:
                {
                alt1=4;
                }
                break;
            case 21:
                {
                alt1=5;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 1, 0, input);

                throw nvae;

            }

            switch (alt1) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:131:4: structType
                    {
                    pushFollow(FOLLOW_structType_in_mangledType76);
                    structType2=structType();

                    state._fsp--;


                     type = structType2; 

                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:132:3: unionType
                    {
                    pushFollow(FOLLOW_unionType_in_mangledType84);
                    unionType3=unionType();

                    state._fsp--;


                     type = unionType3; 

                    }
                    break;
                case 3 :
                    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:133:3: arrayType
                    {
                    pushFollow(FOLLOW_arrayType_in_mangledType92);
                    arrayType4=arrayType();

                    state._fsp--;


                     type = arrayType4; 

                    }
                    break;
                case 4 :
                    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:134:3: primitiveType
                    {
                    pushFollow(FOLLOW_primitiveType_in_mangledType100);
                    primitiveType5=primitiveType();

                    state._fsp--;


                     type = primitiveType5; 

                    }
                    break;
                case 5 :
                    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:135:3: '^' (pointed= mangledType )
                    {
                    match(input,21,FOLLOW_21_in_mangledType108); 

                    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:135:7: (pointed= mangledType )
                    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:137:4: pointed= mangledType
                    {
                    pushFollow(FOLLOW_mangledType_in_mangledType121);
                    pointed=mangledType();

                    state._fsp--;


                     
                    				type = new TypeRef.Pointer(pointed, Declarator.PointerStyle.Pointer); 
                    			

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return type;
    }
    // $ANTLR end "mangledType"



    // $ANTLR start "primitiveType"
    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:143:1: primitiveType returns [TypeRef type] : ({...}? IDENTIFIER | '*' | '@' | '#' | ':' | '?' );
    public final TypeRef primitiveType() throws RecognitionException {
        TypeRef type = null;


        Token IDENTIFIER6=null;

        try {
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:144:2: ({...}? IDENTIFIER | '*' | '@' | '#' | ':' | '?' )
            int alt2=6;
            switch ( input.LA(1) ) {
            case IDENTIFIER:
                {
                alt2=1;
                }
                break;
            case 14:
                {
                alt2=2;
                }
                break;
            case 18:
                {
                alt2=3;
                }
                break;
            case 11:
                {
                alt2=4;
                }
                break;
            case 15:
                {
                alt2=5;
                }
                break;
            case 17:
                {
                alt2=6;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 2, 0, input);

                throw nvae;

            }

            switch (alt2) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:145:3: {...}? IDENTIFIER
                    {
                    if ( !(( isPredefRef(next()) )) ) {
                        throw new FailedPredicateException(input, "primitiveType", " isPredefRef(next()) ");
                    }

                    IDENTIFIER6=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_primitiveType147); 


                    			type = getPredefRef((IDENTIFIER6!=null?IDENTIFIER6.getText():null));
                    		

                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:148:3: '*'
                    {
                    match(input,14,FOLLOW_14_in_primitiveType155); 

                     type = new TypeRef.Pointer(typeRef("char"), PointerStyle.Pointer); 

                    }
                    break;
                case 3 :
                    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:149:3: '@'
                    {
                    match(input,18,FOLLOW_18_in_primitiveType163); 

                     type = typeRef("id"); 

                    }
                    break;
                case 4 :
                    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:150:3: '#'
                    {
                    match(input,11,FOLLOW_11_in_primitiveType171); 

                     type = typeRef("Class"); 

                    }
                    break;
                case 5 :
                    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:151:3: ':'
                    {
                    match(input,15,FOLLOW_15_in_primitiveType179); 

                     type = typeRef("SEL"); 

                    }
                    break;
                case 6 :
                    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:152:3: '?'
                    {
                    match(input,17,FOLLOW_17_in_primitiveType187); 

                     type = typeRef("__opaque_unknown_type"); 

                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return type;
    }
    // $ANTLR end "primitiveType"



    // $ANTLR start "structType"
    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:155:1: structType returns [Struct type] : '{' (tagName= IDENTIFIER '=' ) (f= structField )* '}' ;
    public final Struct structType() throws RecognitionException {
        Struct type = null;


        Token tagName=null;
        VariablesDeclaration f =null;


        try {
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:156:2: ( '{' (tagName= IDENTIFIER '=' ) (f= structField )* '}' )
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:156:4: '{' (tagName= IDENTIFIER '=' ) (f= structField )* '}'
            {
             
            			type = new Struct();
            			type.setType(Struct.Type.CStruct);
            			type.setForwardDeclaration(true);
            		

            match(input,23,FOLLOW_23_in_structType207); 

            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:161:3: (tagName= IDENTIFIER '=' )
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:162:4: tagName= IDENTIFIER '='
            {
            tagName=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_structType219); 

            match(input,16,FOLLOW_16_in_structType221); 


            				type.setTag(ident((tagName!=null?tagName.getText():null)));
            			

            }


            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:166:3: (f= structField )*
            loop3:
            do {
                int alt3=2;
                switch ( input.LA(1) ) {
                case IDENTIFIER:
                case STRING:
                case 11:
                case 12:
                case 14:
                case 15:
                case 17:
                case 18:
                case 19:
                case 21:
                case 22:
                case 23:
                    {
                    alt3=1;
                    }
                    break;

                }

                switch (alt3) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:167:4: f= structField
            	    {
            	    pushFollow(FOLLOW_structField_in_structType239);
            	    f=structField();

            	    state._fsp--;



            	    				type.addDeclaration(f);
            	    				type.setForwardDeclaration(false);
            	    			

            	    }
            	    break;

            	default :
            	    break loop3;
                }
            } while (true);


            match(input,24,FOLLOW_24_in_structType250); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return type;
    }
    // $ANTLR end "structType"



    // $ANTLR start "arrayType"
    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:176:1: arrayType returns [TypeRef type] : '[' (size= DECIMAL_NUMBER )? ct= mangledType ']' ;
    public final TypeRef arrayType() throws RecognitionException {
        TypeRef type = null;


        Token size=null;
        TypeRef ct =null;


        try {
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:177:2: ( '[' (size= DECIMAL_NUMBER )? ct= mangledType ']' )
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:178:3: '[' (size= DECIMAL_NUMBER )? ct= mangledType ']'
            {
            match(input,19,FOLLOW_19_in_arrayType270); 

            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:179:8: (size= DECIMAL_NUMBER )?
            int alt4=2;
            switch ( input.LA(1) ) {
                case DECIMAL_NUMBER:
                    {
                    alt4=1;
                    }
                    break;
            }

            switch (alt4) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:179:8: size= DECIMAL_NUMBER
                    {
                    size=(Token)match(input,DECIMAL_NUMBER,FOLLOW_DECIMAL_NUMBER_in_arrayType278); 

                    }
                    break;

            }


            pushFollow(FOLLOW_mangledType_in_arrayType286);
            ct=mangledType();

            state._fsp--;


             
            				type = new TypeRef.ArrayRef(ct, (size!=null?size.getText():null) == null ? null : expr(Constant.Type.Int, Integer.parseInt((size!=null?size.getText():null)))); 
            				
            			

            match(input,20,FOLLOW_20_in_arrayType292); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return type;
    }
    // $ANTLR end "arrayType"



    // $ANTLR start "methodType"
    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:187:1: methodType returns [Function method] : rt= mangledType DECIMAL_NUMBER '@' DECIMAL_NUMBER ':' DECIMAL_NUMBER (at= mangledType DECIMAL_NUMBER )* EOF ;
    public final Function methodType() throws RecognitionException {
        Function method = null;


        TypeRef rt =null;

        TypeRef at =null;


        try {
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:188:2: (rt= mangledType DECIMAL_NUMBER '@' DECIMAL_NUMBER ':' DECIMAL_NUMBER (at= mangledType DECIMAL_NUMBER )* EOF )
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:189:3: rt= mangledType DECIMAL_NUMBER '@' DECIMAL_NUMBER ':' DECIMAL_NUMBER (at= mangledType DECIMAL_NUMBER )* EOF
            {
            pushFollow(FOLLOW_mangledType_in_methodType314);
            rt=mangledType();

            state._fsp--;



            			method = new Function(Function.Type.ObjCMethod, null, rt);
            		

            match(input,DECIMAL_NUMBER,FOLLOW_DECIMAL_NUMBER_in_methodType320); 

            match(input,18,FOLLOW_18_in_methodType325); 

            match(input,DECIMAL_NUMBER,FOLLOW_DECIMAL_NUMBER_in_methodType327); 

            match(input,15,FOLLOW_15_in_methodType329); 

            match(input,DECIMAL_NUMBER,FOLLOW_DECIMAL_NUMBER_in_methodType331); 

            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:194:3: (at= mangledType DECIMAL_NUMBER )*
            loop5:
            do {
                int alt5=2;
                switch ( input.LA(1) ) {
                case IDENTIFIER:
                case 11:
                case 12:
                case 14:
                case 15:
                case 17:
                case 18:
                case 19:
                case 21:
                case 23:
                    {
                    alt5=1;
                    }
                    break;

                }

                switch (alt5) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:195:4: at= mangledType DECIMAL_NUMBER
            	    {
            	    pushFollow(FOLLOW_mangledType_in_methodType343);
            	    at=mangledType();

            	    state._fsp--;


            	    match(input,DECIMAL_NUMBER,FOLLOW_DECIMAL_NUMBER_in_methodType345); 


            	    				method.addArg(new Arg(null, at));
            	    			

            	    }
            	    break;

            	default :
            	    break loop5;
                }
            } while (true);


            match(input,EOF,FOLLOW_EOF_in_methodType356); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return method;
    }
    // $ANTLR end "methodType"



    // $ANTLR start "unionType"
    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:201:1: unionType returns [Struct type] : '(' (tagName= IDENTIFIER '=' )? (f= structField )+ ')' ;
    public final Struct unionType() throws RecognitionException {
        Struct type = null;


        Token tagName=null;
        VariablesDeclaration f =null;


        try {
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:202:2: ( '(' (tagName= IDENTIFIER '=' )? (f= structField )+ ')' )
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:202:4: '(' (tagName= IDENTIFIER '=' )? (f= structField )+ ')'
            {
             
            			type = new Struct();
            			type.setType(Struct.Type.CUnion);
            		

            match(input,12,FOLLOW_12_in_unionType372); 

            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:206:3: (tagName= IDENTIFIER '=' )?
            int alt6=2;
            switch ( input.LA(1) ) {
                case IDENTIFIER:
                    {
                    switch ( input.LA(2) ) {
                        case 16:
                            {
                            alt6=1;
                            }
                            break;
                    }

                    }
                    break;
            }

            switch (alt6) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:207:4: tagName= IDENTIFIER '='
                    {
                    tagName=(Token)match(input,IDENTIFIER,FOLLOW_IDENTIFIER_in_unionType384); 

                    match(input,16,FOLLOW_16_in_unionType386); 


                    				type.setTag(ident((tagName!=null?tagName.getText():null)));
                    			

                    }
                    break;

            }


            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:211:3: (f= structField )+
            int cnt7=0;
            loop7:
            do {
                int alt7=2;
                switch ( input.LA(1) ) {
                case IDENTIFIER:
                case STRING:
                case 11:
                case 12:
                case 14:
                case 15:
                case 17:
                case 18:
                case 19:
                case 21:
                case 22:
                case 23:
                    {
                    alt7=1;
                    }
                    break;

                }

                switch (alt7) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:212:4: f= structField
            	    {
            	    pushFollow(FOLLOW_structField_in_unionType406);
            	    f=structField();

            	    state._fsp--;


            	     type.addDeclaration(f); 

            	    }
            	    break;

            	default :
            	    if ( cnt7 >= 1 ) break loop7;
                        EarlyExitException eee =
                            new EarlyExitException(7, input);
                        throw eee;
                }
                cnt7++;
            } while (true);


            match(input,13,FOLLOW_13_in_unionType418); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return type;
    }
    // $ANTLR end "unionType"



    // $ANTLR start "structField"
    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:218:1: structField returns [VariablesDeclaration field] : (fieldName= STRING )? (fieldType= mangledType | 'b' bits= DECIMAL_NUMBER ) ;
    public final VariablesDeclaration structField() throws RecognitionException {
        VariablesDeclaration field = null;


        Token fieldName=null;
        Token bits=null;
        TypeRef fieldType =null;



        	DirectDeclarator declarator = null;

        try {
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:222:2: ( (fieldName= STRING )? (fieldType= mangledType | 'b' bits= DECIMAL_NUMBER ) )
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:223:3: (fieldName= STRING )? (fieldType= mangledType | 'b' bits= DECIMAL_NUMBER )
            {
             
            			field = new VariablesDeclaration(); 
            			field.addDeclarator(declarator = new DirectDeclarator());
            		

            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:227:3: (fieldName= STRING )?
            int alt8=2;
            switch ( input.LA(1) ) {
                case STRING:
                    {
                    alt8=1;
                    }
                    break;
            }

            switch (alt8) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:228:4: fieldName= STRING
                    {
                    fieldName=(Token)match(input,STRING,FOLLOW_STRING_in_structField453); 


                    				declarator.setName(String.valueOf(Constant.parseString((fieldName!=null?fieldName.getText():null)).getValue()));
                    			

                    }
                    break;

            }


            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:232:3: (fieldType= mangledType | 'b' bits= DECIMAL_NUMBER )
            int alt9=2;
            switch ( input.LA(1) ) {
            case IDENTIFIER:
            case 11:
            case 12:
            case 14:
            case 15:
            case 17:
            case 18:
            case 19:
            case 21:
            case 23:
                {
                alt9=1;
                }
                break;
            case 22:
                {
                alt9=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 9, 0, input);

                throw nvae;

            }

            switch (alt9) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:233:4: fieldType= mangledType
                    {
                    pushFollow(FOLLOW_mangledType_in_structField471);
                    fieldType=mangledType();

                    state._fsp--;



                    				field.setValueType(fieldType);
                    			

                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:236:4: 'b' bits= DECIMAL_NUMBER
                    {
                    match(input,22,FOLLOW_22_in_structField480); 

                    bits=(Token)match(input,DECIMAL_NUMBER,FOLLOW_DECIMAL_NUMBER_in_structField484); 


                    				declarator.setBits(Integer.parseInt((bits!=null?bits.getText():null)));
                    				field.setValueType(typeRef("int"));
                    			

                    }
                    break;

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }

        finally {
        	// do for sure before leaving
        }
        return field;
    }
    // $ANTLR end "structField"

    // Delegated rules


 

    public static final BitSet FOLLOW_mangledType_in_mangledTypeEOF60 = new BitSet(new long[]{0x0000000000000000L});
    public static final BitSet FOLLOW_EOF_in_mangledTypeEOF64 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_structType_in_mangledType76 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_unionType_in_mangledType84 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_arrayType_in_mangledType92 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_primitiveType_in_mangledType100 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_21_in_mangledType108 = new BitSet(new long[]{0x0000000000AED840L});
    public static final BitSet FOLLOW_mangledType_in_mangledType121 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_IDENTIFIER_in_primitiveType147 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_14_in_primitiveType155 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_18_in_primitiveType163 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_11_in_primitiveType171 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_15_in_primitiveType179 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_17_in_primitiveType187 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_23_in_structType207 = new BitSet(new long[]{0x0000000000000040L});
    public static final BitSet FOLLOW_IDENTIFIER_in_structType219 = new BitSet(new long[]{0x0000000000010000L});
    public static final BitSet FOLLOW_16_in_structType221 = new BitSet(new long[]{0x0000000001EEDC40L});
    public static final BitSet FOLLOW_structField_in_structType239 = new BitSet(new long[]{0x0000000001EEDC40L});
    public static final BitSet FOLLOW_24_in_structType250 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_19_in_arrayType270 = new BitSet(new long[]{0x0000000000AED860L});
    public static final BitSet FOLLOW_DECIMAL_NUMBER_in_arrayType278 = new BitSet(new long[]{0x0000000000AED840L});
    public static final BitSet FOLLOW_mangledType_in_arrayType286 = new BitSet(new long[]{0x0000000000100000L});
    public static final BitSet FOLLOW_20_in_arrayType292 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_mangledType_in_methodType314 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_DECIMAL_NUMBER_in_methodType320 = new BitSet(new long[]{0x0000000000040000L});
    public static final BitSet FOLLOW_18_in_methodType325 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_DECIMAL_NUMBER_in_methodType327 = new BitSet(new long[]{0x0000000000008000L});
    public static final BitSet FOLLOW_15_in_methodType329 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_DECIMAL_NUMBER_in_methodType331 = new BitSet(new long[]{0x0000000000AED840L});
    public static final BitSet FOLLOW_mangledType_in_methodType343 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_DECIMAL_NUMBER_in_methodType345 = new BitSet(new long[]{0x0000000000AED840L});
    public static final BitSet FOLLOW_EOF_in_methodType356 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_12_in_unionType372 = new BitSet(new long[]{0x0000000000EEDC40L});
    public static final BitSet FOLLOW_IDENTIFIER_in_unionType384 = new BitSet(new long[]{0x0000000000010000L});
    public static final BitSet FOLLOW_16_in_unionType386 = new BitSet(new long[]{0x0000000000EEDC40L});
    public static final BitSet FOLLOW_structField_in_unionType406 = new BitSet(new long[]{0x0000000000EEFC40L});
    public static final BitSet FOLLOW_13_in_unionType418 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRING_in_structField453 = new BitSet(new long[]{0x0000000000EED840L});
    public static final BitSet FOLLOW_mangledType_in_structField471 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_22_in_structField480 = new BitSet(new long[]{0x0000000000000020L});
    public static final BitSet FOLLOW_DECIMAL_NUMBER_in_structField484 = new BitSet(new long[]{0x0000000000000002L});

}