// $ANTLR 3.4 com/ochafik/lang/jnaerator/parser/ObjCDemangling.g 2015-03-28 11:03:43
 
/*
	Copyright (c) 2009 Olivier Chafik, All Rights Reserved
	
	This file is part of JNAerator (http://jnaerator.googlecode.com/).
	
	JNAerator is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.
	
	JNAerator is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.
	
	You should have received a copy of the GNU Lesser General Public License
	along with JNAerator.  If not, see <http://www.gnu.org/licenses/>.
*/

package com.ochafik.lang.jnaerator.parser;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

@SuppressWarnings({"all", "warnings", "unchecked"})
public class ObjCDemanglingLexer extends Lexer {
    public static final int EOF=-1;
    public static final int T__11=11;
    public static final int T__12=12;
    public static final int T__13=13;
    public static final int T__14=14;
    public static final int T__15=15;
    public static final int T__16=16;
    public static final int T__17=17;
    public static final int T__18=18;
    public static final int T__19=19;
    public static final int T__20=20;
    public static final int T__21=21;
    public static final int T__22=22;
    public static final int T__23=23;
    public static final int T__24=24;
    public static final int CharEscape=4;
    public static final int DECIMAL_NUMBER=5;
    public static final int IDENTIFIER=6;
    public static final int Letter=7;
    public static final int OCTAL_NUMBER=8;
    public static final int OctalEscape=9;
    public static final int STRING=10;

    // delegates
    // delegators
    public Lexer[] getDelegates() {
        return new Lexer[] {};
    }

    public ObjCDemanglingLexer() {} 
    public ObjCDemanglingLexer(CharStream input) {
        this(input, new RecognizerSharedState());
    }
    public ObjCDemanglingLexer(CharStream input, RecognizerSharedState state) {
        super(input,state);
    }
    public String getGrammarFileName() { return "com/ochafik/lang/jnaerator/parser/ObjCDemangling.g"; }

    // $ANTLR start "T__11"
    public final void mT__11() throws RecognitionException {
        try {
            int _type = T__11;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:25:7: ( '#' )
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:25:9: '#'
            {
            match('#'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "T__11"

    // $ANTLR start "T__12"
    public final void mT__12() throws RecognitionException {
        try {
            int _type = T__12;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:26:7: ( '(' )
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:26:9: '('
            {
            match('('); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "T__12"

    // $ANTLR start "T__13"
    public final void mT__13() throws RecognitionException {
        try {
            int _type = T__13;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:27:7: ( ')' )
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:27:9: ')'
            {
            match(')'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "T__13"

    // $ANTLR start "T__14"
    public final void mT__14() throws RecognitionException {
        try {
            int _type = T__14;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:28:7: ( '*' )
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:28:9: '*'
            {
            match('*'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "T__14"

    // $ANTLR start "T__15"
    public final void mT__15() throws RecognitionException {
        try {
            int _type = T__15;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:29:7: ( ':' )
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:29:9: ':'
            {
            match(':'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "T__15"

    // $ANTLR start "T__16"
    public final void mT__16() throws RecognitionException {
        try {
            int _type = T__16;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:30:7: ( '=' )
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:30:9: '='
            {
            match('='); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "T__16"

    // $ANTLR start "T__17"
    public final void mT__17() throws RecognitionException {
        try {
            int _type = T__17;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:31:7: ( '?' )
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:31:9: '?'
            {
            match('?'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "T__17"

    // $ANTLR start "T__18"
    public final void mT__18() throws RecognitionException {
        try {
            int _type = T__18;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:32:7: ( '@' )
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:32:9: '@'
            {
            match('@'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "T__18"

    // $ANTLR start "T__19"
    public final void mT__19() throws RecognitionException {
        try {
            int _type = T__19;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:33:7: ( '[' )
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:33:9: '['
            {
            match('['); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "T__19"

    // $ANTLR start "T__20"
    public final void mT__20() throws RecognitionException {
        try {
            int _type = T__20;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:34:7: ( ']' )
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:34:9: ']'
            {
            match(']'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "T__20"

    // $ANTLR start "T__21"
    public final void mT__21() throws RecognitionException {
        try {
            int _type = T__21;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:35:7: ( '^' )
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:35:9: '^'
            {
            match('^'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "T__21"

    // $ANTLR start "T__22"
    public final void mT__22() throws RecognitionException {
        try {
            int _type = T__22;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:36:7: ( 'b' )
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:36:9: 'b'
            {
            match('b'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "T__22"

    // $ANTLR start "T__23"
    public final void mT__23() throws RecognitionException {
        try {
            int _type = T__23;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:37:7: ( '{' )
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:37:9: '{'
            {
            match('{'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "T__23"

    // $ANTLR start "T__24"
    public final void mT__24() throws RecognitionException {
        try {
            int _type = T__24;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:38:7: ( '}' )
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:38:9: '}'
            {
            match('}'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "T__24"

    // $ANTLR start "Letter"
    public final void mLetter() throws RecognitionException {
        try {
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:246:2: ( '$' | '_' | 'A' .. 'Z' | 'a' .. 'z' )
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:
            {
            if ( input.LA(1)=='$'||(input.LA(1) >= 'A' && input.LA(1) <= 'Z')||input.LA(1)=='_'||(input.LA(1) >= 'a' && input.LA(1) <= 'z') ) {
                input.consume();
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;
            }


            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "Letter"

    // $ANTLR start "IDENTIFIER"
    public final void mIDENTIFIER() throws RecognitionException {
        try {
            int _type = IDENTIFIER;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:252:2: ( ( Letter )+ )
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:253:3: ( Letter )+
            {
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:253:3: ( Letter )+
            int cnt1=0;
            loop1:
            do {
                int alt1=2;
                switch ( input.LA(1) ) {
                case '$':
                case 'A':
                case 'B':
                case 'C':
                case 'D':
                case 'E':
                case 'F':
                case 'G':
                case 'H':
                case 'I':
                case 'J':
                case 'K':
                case 'L':
                case 'M':
                case 'N':
                case 'O':
                case 'P':
                case 'Q':
                case 'R':
                case 'S':
                case 'T':
                case 'U':
                case 'V':
                case 'W':
                case 'X':
                case 'Y':
                case 'Z':
                case '_':
                case 'a':
                case 'b':
                case 'c':
                case 'd':
                case 'e':
                case 'f':
                case 'g':
                case 'h':
                case 'i':
                case 'j':
                case 'k':
                case 'l':
                case 'm':
                case 'n':
                case 'o':
                case 'p':
                case 'q':
                case 'r':
                case 's':
                case 't':
                case 'u':
                case 'v':
                case 'w':
                case 'x':
                case 'y':
                case 'z':
                    {
                    alt1=1;
                    }
                    break;

                }

                switch (alt1) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:
            	    {
            	    if ( input.LA(1)=='$'||(input.LA(1) >= 'A' && input.LA(1) <= 'Z')||input.LA(1)=='_'||(input.LA(1) >= 'a' && input.LA(1) <= 'z') ) {
            	        input.consume();
            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;
            	    }


            	    }
            	    break;

            	default :
            	    if ( cnt1 >= 1 ) break loop1;
                        EarlyExitException eee =
                            new EarlyExitException(1, input);
                        throw eee;
                }
                cnt1++;
            } while (true);


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "IDENTIFIER"

    // $ANTLR start "DECIMAL_NUMBER"
    public final void mDECIMAL_NUMBER() throws RecognitionException {
        try {
            int _type = DECIMAL_NUMBER;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:257:2: ( ( '0' | '1' .. '9' ( '0' .. '9' )* ) )
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:258:3: ( '0' | '1' .. '9' ( '0' .. '9' )* )
            {
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:258:3: ( '0' | '1' .. '9' ( '0' .. '9' )* )
            int alt3=2;
            switch ( input.LA(1) ) {
            case '0':
                {
                alt3=1;
                }
                break;
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9':
                {
                alt3=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 3, 0, input);

                throw nvae;

            }

            switch (alt3) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:258:4: '0'
                    {
                    match('0'); 

                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:258:10: '1' .. '9' ( '0' .. '9' )*
                    {
                    matchRange('1','9'); 

                    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:258:19: ( '0' .. '9' )*
                    loop2:
                    do {
                        int alt2=2;
                        switch ( input.LA(1) ) {
                        case '0':
                        case '1':
                        case '2':
                        case '3':
                        case '4':
                        case '5':
                        case '6':
                        case '7':
                        case '8':
                        case '9':
                            {
                            alt2=1;
                            }
                            break;

                        }

                        switch (alt2) {
                    	case 1 :
                    	    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:
                    	    {
                    	    if ( (input.LA(1) >= '0' && input.LA(1) <= '9') ) {
                    	        input.consume();
                    	    }
                    	    else {
                    	        MismatchedSetException mse = new MismatchedSetException(null,input);
                    	        recover(mse);
                    	        throw mse;
                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop2;
                        }
                    } while (true);


                    }
                    break;

            }


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "DECIMAL_NUMBER"

    // $ANTLR start "OCTAL_NUMBER"
    public final void mOCTAL_NUMBER() throws RecognitionException {
        try {
            int _type = OCTAL_NUMBER;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:262:2: ( '0' ( '0' .. '7' )+ )
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:262:5: '0' ( '0' .. '7' )+
            {
            match('0'); 

            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:263:3: ( '0' .. '7' )+
            int cnt4=0;
            loop4:
            do {
                int alt4=2;
                switch ( input.LA(1) ) {
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                    {
                    alt4=1;
                    }
                    break;

                }

                switch (alt4) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:
            	    {
            	    if ( (input.LA(1) >= '0' && input.LA(1) <= '7') ) {
            	        input.consume();
            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;
            	    }


            	    }
            	    break;

            	default :
            	    if ( cnt4 >= 1 ) break loop4;
                        EarlyExitException eee =
                            new EarlyExitException(4, input);
                        throw eee;
                }
                cnt4++;
            } while (true);


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "OCTAL_NUMBER"

    // $ANTLR start "CharEscape"
    public final void mCharEscape() throws RecognitionException {
        try {
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:269:2: ( '\\\\' ( 'b' | 't' | 'n' | 'f' | 'r' | '\\\"' | '\\'' | '\\\\' ) | OctalEscape )
            int alt5=2;
            switch ( input.LA(1) ) {
            case '\\':
                {
                switch ( input.LA(2) ) {
                case '\"':
                case '\'':
                case '\\':
                case 'b':
                case 'f':
                case 'n':
                case 'r':
                case 't':
                    {
                    alt5=1;
                    }
                    break;
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                    {
                    alt5=2;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 5, 1, input);

                    throw nvae;

                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 5, 0, input);

                throw nvae;

            }

            switch (alt5) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:269:4: '\\\\' ( 'b' | 't' | 'n' | 'f' | 'r' | '\\\"' | '\\'' | '\\\\' )
                    {
                    match('\\'); 

                    if ( input.LA(1)=='\"'||input.LA(1)=='\''||input.LA(1)=='\\'||input.LA(1)=='b'||input.LA(1)=='f'||input.LA(1)=='n'||input.LA(1)=='r'||input.LA(1)=='t' ) {
                        input.consume();
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:280:3: OctalEscape
                    {
                    mOctalEscape(); 


                    }
                    break;

            }

        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "CharEscape"

    // $ANTLR start "OctalEscape"
    public final void mOctalEscape() throws RecognitionException {
        try {
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:286:2: ( '\\\\' ( ( '0' .. '3' ) ( '0' .. '7' ) ( '0' .. '7' ) | ( '0' .. '7' ) ( '0' .. '7' ) | ( '0' .. '7' ) ) )
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:286:4: '\\\\' ( ( '0' .. '3' ) ( '0' .. '7' ) ( '0' .. '7' ) | ( '0' .. '7' ) ( '0' .. '7' ) | ( '0' .. '7' ) )
            {
            match('\\'); 

            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:286:9: ( ( '0' .. '3' ) ( '0' .. '7' ) ( '0' .. '7' ) | ( '0' .. '7' ) ( '0' .. '7' ) | ( '0' .. '7' ) )
            int alt6=3;
            switch ( input.LA(1) ) {
            case '0':
            case '1':
            case '2':
            case '3':
                {
                switch ( input.LA(2) ) {
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                    {
                    switch ( input.LA(3) ) {
                    case '0':
                    case '1':
                    case '2':
                    case '3':
                    case '4':
                    case '5':
                    case '6':
                    case '7':
                        {
                        alt6=1;
                        }
                        break;
                    default:
                        alt6=2;
                    }

                    }
                    break;
                default:
                    alt6=3;
                }

                }
                break;
            case '4':
            case '5':
            case '6':
            case '7':
                {
                switch ( input.LA(2) ) {
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                    {
                    alt6=2;
                    }
                    break;
                default:
                    alt6=3;
                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 6, 0, input);

                throw nvae;

            }

            switch (alt6) {
                case 1 :
                    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:287:4: ( '0' .. '3' ) ( '0' .. '7' ) ( '0' .. '7' )
                    {
                    if ( (input.LA(1) >= '0' && input.LA(1) <= '3') ) {
                        input.consume();
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    if ( (input.LA(1) >= '0' && input.LA(1) <= '7') ) {
                        input.consume();
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    if ( (input.LA(1) >= '0' && input.LA(1) <= '7') ) {
                        input.consume();
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    }
                    break;
                case 2 :
                    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:288:4: ( '0' .. '7' ) ( '0' .. '7' )
                    {
                    if ( (input.LA(1) >= '0' && input.LA(1) <= '7') ) {
                        input.consume();
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    if ( (input.LA(1) >= '0' && input.LA(1) <= '7') ) {
                        input.consume();
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    }
                    break;
                case 3 :
                    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:289:4: ( '0' .. '7' )
                    {
                    if ( (input.LA(1) >= '0' && input.LA(1) <= '7') ) {
                        input.consume();
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;
                    }


                    }
                    break;

            }


            }


        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "OctalEscape"

    // $ANTLR start "STRING"
    public final void mSTRING() throws RecognitionException {
        try {
            int _type = STRING;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:293:2: ( '\"' ( CharEscape |~ ( '\\\\' | '\"' ) )* '\"' )
            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:293:4: '\"' ( CharEscape |~ ( '\\\\' | '\"' ) )* '\"'
            {
            match('\"'); 

            // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:294:3: ( CharEscape |~ ( '\\\\' | '\"' ) )*
            loop7:
            do {
                int alt7=3;
                int LA7_0 = input.LA(1);

                if ( (LA7_0=='\\') ) {
                    alt7=1;
                }
                else if ( ((LA7_0 >= '\u0000' && LA7_0 <= '!')||(LA7_0 >= '#' && LA7_0 <= '[')||(LA7_0 >= ']' && LA7_0 <= '\uFFFF')) ) {
                    alt7=2;
                }


                switch (alt7) {
            	case 1 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:295:4: CharEscape
            	    {
            	    mCharEscape(); 


            	    }
            	    break;
            	case 2 :
            	    // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:296:4: ~ ( '\\\\' | '\"' )
            	    {
            	    if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '!')||(input.LA(1) >= '#' && input.LA(1) <= '[')||(input.LA(1) >= ']' && input.LA(1) <= '\uFFFF') ) {
            	        input.consume();
            	    }
            	    else {
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;
            	    }


            	    }
            	    break;

            	default :
            	    break loop7;
                }
            } while (true);


            match('\"'); 

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        	// do for sure before leaving
        }
    }
    // $ANTLR end "STRING"

    public void mTokens() throws RecognitionException {
        // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:1:8: ( T__11 | T__12 | T__13 | T__14 | T__15 | T__16 | T__17 | T__18 | T__19 | T__20 | T__21 | T__22 | T__23 | T__24 | IDENTIFIER | DECIMAL_NUMBER | OCTAL_NUMBER | STRING )
        int alt8=18;
        switch ( input.LA(1) ) {
        case '#':
            {
            alt8=1;
            }
            break;
        case '(':
            {
            alt8=2;
            }
            break;
        case ')':
            {
            alt8=3;
            }
            break;
        case '*':
            {
            alt8=4;
            }
            break;
        case ':':
            {
            alt8=5;
            }
            break;
        case '=':
            {
            alt8=6;
            }
            break;
        case '?':
            {
            alt8=7;
            }
            break;
        case '@':
            {
            alt8=8;
            }
            break;
        case '[':
            {
            alt8=9;
            }
            break;
        case ']':
            {
            alt8=10;
            }
            break;
        case '^':
            {
            alt8=11;
            }
            break;
        case 'b':
            {
            switch ( input.LA(2) ) {
            case '$':
            case 'A':
            case 'B':
            case 'C':
            case 'D':
            case 'E':
            case 'F':
            case 'G':
            case 'H':
            case 'I':
            case 'J':
            case 'K':
            case 'L':
            case 'M':
            case 'N':
            case 'O':
            case 'P':
            case 'Q':
            case 'R':
            case 'S':
            case 'T':
            case 'U':
            case 'V':
            case 'W':
            case 'X':
            case 'Y':
            case 'Z':
            case '_':
            case 'a':
            case 'b':
            case 'c':
            case 'd':
            case 'e':
            case 'f':
            case 'g':
            case 'h':
            case 'i':
            case 'j':
            case 'k':
            case 'l':
            case 'm':
            case 'n':
            case 'o':
            case 'p':
            case 'q':
            case 'r':
            case 's':
            case 't':
            case 'u':
            case 'v':
            case 'w':
            case 'x':
            case 'y':
            case 'z':
                {
                alt8=15;
                }
                break;
            default:
                alt8=12;
            }

            }
            break;
        case '{':
            {
            alt8=13;
            }
            break;
        case '}':
            {
            alt8=14;
            }
            break;
        case '$':
        case 'A':
        case 'B':
        case 'C':
        case 'D':
        case 'E':
        case 'F':
        case 'G':
        case 'H':
        case 'I':
        case 'J':
        case 'K':
        case 'L':
        case 'M':
        case 'N':
        case 'O':
        case 'P':
        case 'Q':
        case 'R':
        case 'S':
        case 'T':
        case 'U':
        case 'V':
        case 'W':
        case 'X':
        case 'Y':
        case 'Z':
        case '_':
        case 'a':
        case 'c':
        case 'd':
        case 'e':
        case 'f':
        case 'g':
        case 'h':
        case 'i':
        case 'j':
        case 'k':
        case 'l':
        case 'm':
        case 'n':
        case 'o':
        case 'p':
        case 'q':
        case 'r':
        case 's':
        case 't':
        case 'u':
        case 'v':
        case 'w':
        case 'x':
        case 'y':
        case 'z':
            {
            alt8=15;
            }
            break;
        case '0':
            {
            switch ( input.LA(2) ) {
            case '0':
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
                {
                alt8=17;
                }
                break;
            default:
                alt8=16;
            }

            }
            break;
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
            {
            alt8=16;
            }
            break;
        case '\"':
            {
            alt8=18;
            }
            break;
        default:
            NoViableAltException nvae =
                new NoViableAltException("", 8, 0, input);

            throw nvae;

        }

        switch (alt8) {
            case 1 :
                // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:1:10: T__11
                {
                mT__11(); 


                }
                break;
            case 2 :
                // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:1:16: T__12
                {
                mT__12(); 


                }
                break;
            case 3 :
                // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:1:22: T__13
                {
                mT__13(); 


                }
                break;
            case 4 :
                // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:1:28: T__14
                {
                mT__14(); 


                }
                break;
            case 5 :
                // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:1:34: T__15
                {
                mT__15(); 


                }
                break;
            case 6 :
                // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:1:40: T__16
                {
                mT__16(); 


                }
                break;
            case 7 :
                // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:1:46: T__17
                {
                mT__17(); 


                }
                break;
            case 8 :
                // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:1:52: T__18
                {
                mT__18(); 


                }
                break;
            case 9 :
                // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:1:58: T__19
                {
                mT__19(); 


                }
                break;
            case 10 :
                // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:1:64: T__20
                {
                mT__20(); 


                }
                break;
            case 11 :
                // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:1:70: T__21
                {
                mT__21(); 


                }
                break;
            case 12 :
                // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:1:76: T__22
                {
                mT__22(); 


                }
                break;
            case 13 :
                // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:1:82: T__23
                {
                mT__23(); 


                }
                break;
            case 14 :
                // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:1:88: T__24
                {
                mT__24(); 


                }
                break;
            case 15 :
                // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:1:94: IDENTIFIER
                {
                mIDENTIFIER(); 


                }
                break;
            case 16 :
                // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:1:105: DECIMAL_NUMBER
                {
                mDECIMAL_NUMBER(); 


                }
                break;
            case 17 :
                // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:1:120: OCTAL_NUMBER
                {
                mOCTAL_NUMBER(); 


                }
                break;
            case 18 :
                // com/ochafik/lang/jnaerator/parser/ObjCDemangling.g:1:133: STRING
                {
                mSTRING(); 


                }
                break;

        }

    }


 

}