/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.rt.bro.ptr;

import java.util.Arrays;
import org.robovm.rt.VM;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.StructMember;
import org.robovm.rt.bro.ptr.Ptr;

public final class BooleanPtr
extends Struct<BooleanPtr> {
    public BooleanPtr() {
    }

    public BooleanPtr(boolean value) {
        this.set(value);
    }

    public boolean get() {
        return this.getByte() != 0;
    }

    @StructMember(value=0)
    native byte getByte();

    @StructMember(value=0)
    native void setByte(byte var1);

    public void set(boolean value) {
        this.setByte((byte)(value ? 1 : 0));
    }

    public boolean[] toBooleanArray(int n) {
        boolean[] result = new boolean[n];
        this.get(result);
        return result;
    }

    public void get(boolean[] dst) {
        this.get(dst, 0, dst.length);
    }

    public void get(boolean[] dst, int offset, int count) {
        Arrays.checkOffsetAndCount(dst.length, offset, count);
        long h = this.getHandle();
        for (int i = 0; i < count; ++i) {
            dst[i + offset] = VM.getByte(h++) != 0;
        }
    }

    public void set(boolean[] src) {
        this.set(src, 0, src.length);
    }

    public void set(boolean[] src, int offset, int count) {
        Arrays.checkOffsetAndCount(src.length, offset, count);
        long h = this.getHandle();
        for (int i = 0; i < count; ++i) {
            VM.setByte(h++, (byte)(src[i + offset] ? 1 : 0));
        }
    }

    public static class BooleanPtrPtr
    extends Ptr<BooleanPtr, BooleanPtrPtr> {
    }
}

