/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import java.net.UnknownHostException;
import libcore.io.Libcore;
import libcore.io.OsConstants;

public final class GaiException
extends RuntimeException {
    private final String functionName;
    public final int error;

    public GaiException(String functionName, int error) {
        this.functionName = functionName;
        this.error = error;
    }

    public GaiException(String functionName, int error, Throwable cause) {
        super(cause);
        this.functionName = functionName;
        this.error = error;
    }

    @Override
    public String getMessage() {
        String gaiName = OsConstants.gaiName(this.error);
        if (gaiName == null) {
            gaiName = "GAI_ error " + this.error;
        }
        String description = Libcore.os.gai_strerror(this.error);
        return this.functionName + " failed: " + gaiName + " (" + description + ")";
    }

    public UnknownHostException rethrowAsUnknownHostException(String detailMessage) throws UnknownHostException {
        UnknownHostException newException = new UnknownHostException(detailMessage);
        newException.initCause(this);
        throw newException;
    }

    public UnknownHostException rethrowAsUnknownHostException() throws UnknownHostException {
        throw this.rethrowAsUnknownHostException(this.getMessage());
    }
}

