/*
 * Decompiled with CFR 0.152.
 */
package libcore.icu;

import java.util.Locale;

public final class AlphabeticIndex {
    private long peer;

    public AlphabeticIndex(Locale locale) {
        this.peer = AlphabeticIndex.create(locale.toString());
    }

    protected synchronized void finalize() throws Throwable {
        try {
            AlphabeticIndex.destroy(this.peer);
            this.peer = 0L;
        }
        finally {
            super.finalize();
        }
    }

    public synchronized int getMaxLabelCount() {
        return AlphabeticIndex.getMaxLabelCount(this.peer);
    }

    public synchronized AlphabeticIndex setMaxLabelCount(int count) {
        AlphabeticIndex.setMaxLabelCount(this.peer, count);
        return this;
    }

    public synchronized AlphabeticIndex addLabels(Locale locale) {
        AlphabeticIndex.addLabels(this.peer, locale.toString());
        return this;
    }

    public synchronized AlphabeticIndex addLabelRange(int codePointStart, int codePointEnd) {
        AlphabeticIndex.addLabelRange(this.peer, codePointStart, codePointEnd);
        return this;
    }

    public synchronized int getBucketCount() {
        return AlphabeticIndex.getBucketCount(this.peer);
    }

    public synchronized int getBucketIndex(String s) {
        return AlphabeticIndex.getBucketIndex(this.peer, s);
    }

    public synchronized String getBucketLabel(int index) {
        return AlphabeticIndex.getBucketLabel(this.peer, index);
    }

    public synchronized ImmutableIndex getImmutableIndex() {
        return new ImmutableIndex(AlphabeticIndex.buildImmutableIndex(this.peer));
    }

    private static native long create(String var0);

    private static native void destroy(long var0);

    private static native int getMaxLabelCount(long var0);

    private static native void setMaxLabelCount(long var0, int var2);

    private static native void addLabels(long var0, String var2);

    private static native void addLabelRange(long var0, int var2, int var3);

    private static native int getBucketCount(long var0);

    private static native int getBucketIndex(long var0, String var2);

    private static native String getBucketLabel(long var0, int var2);

    private static native long buildImmutableIndex(long var0);

    public static final class ImmutableIndex {
        private long peer;

        private ImmutableIndex(long peer) {
            this.peer = peer;
        }

        protected synchronized void finalize() throws Throwable {
            try {
                AlphabeticIndex.destroy(this.peer);
                this.peer = 0L;
            }
            finally {
                super.finalize();
            }
        }

        public int getBucketCount() {
            return ImmutableIndex.getBucketCount(this.peer);
        }

        public int getBucketIndex(String s) {
            return ImmutableIndex.getBucketIndex(this.peer, s);
        }

        public String getBucketLabel(int index) {
            return ImmutableIndex.getBucketLabel(this.peer, index);
        }

        private static native int getBucketCount(long var0);

        private static native int getBucketIndex(long var0, String var2);

        private static native String getBucketLabel(long var0, int var2);
    }
}

