/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import java.util.regex.MatchResult;

class MatchResultImpl
implements MatchResult {
    private String text;
    private int[] offsets;

    MatchResultImpl(String text, int[] offsets) {
        this.text = text;
        this.offsets = (int[])offsets.clone();
    }

    @Override
    public int end() {
        return this.end(0);
    }

    @Override
    public int end(int group) {
        return this.offsets[2 * group + 1];
    }

    @Override
    public String group() {
        return this.text.substring(this.start(), this.end());
    }

    @Override
    public String group(int group) {
        int from = this.offsets[group * 2];
        int to = this.offsets[group * 2 + 1];
        if (from == -1 || to == -1) {
            return null;
        }
        return this.text.substring(from, to);
    }

    @Override
    public int groupCount() {
        return this.offsets.length / 2 - 1;
    }

    @Override
    public int start() {
        return this.start(0);
    }

    @Override
    public int start(int group) {
        return this.offsets[2 * group];
    }
}

