/*
 * Decompiled with CFR 0.152.
 */
package java.util.prefs;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.NodeSet;
import java.util.prefs.Preferences;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import libcore.io.IoUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class XMLParser {
    static final String PREFS_DTD_NAME = "http://java.sun.com/dtd/preferences.dtd";
    static final String PREFS_DTD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>    <!ELEMENT preferences (root)>    <!ATTLIST preferences EXTERNAL_XML_VERSION CDATA \"0.0\" >    <!ELEMENT root (map, node*) >    <!ATTLIST root type (system|user) #REQUIRED >    <!ELEMENT node (map, node*) >    <!ATTLIST node name CDATA #REQUIRED >    <!ELEMENT map (entry*) >    <!ELEMENT entry EMPTY >    <!ATTLIST entry key   CDATA #REQUIRED value CDATA #REQUIRED >";
    static final String HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    static final String DOCTYPE = "<!DOCTYPE preferences SYSTEM";
    private static final String FILE_PREFS = "<!DOCTYPE map SYSTEM 'http://java.sun.com/dtd/preferences.dtd'>";
    private static final float XML_VERSION = 1.0f;
    private static final DocumentBuilder builder;
    private static int indent;

    private XMLParser() {
    }

    static void exportPrefs(Preferences prefs, OutputStream stream, boolean withSubTree) throws IOException, BackingStoreException {
        indent = -1;
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(stream, "UTF-8"));
        out.write(HEADER);
        out.newLine();
        out.newLine();
        out.write(DOCTYPE);
        out.write(" '");
        out.write(PREFS_DTD_NAME);
        out.write("'>");
        out.newLine();
        out.newLine();
        XMLParser.flushStartTag("preferences", new String[]{"EXTERNAL_XML_VERSION"}, new String[]{String.valueOf(1.0f)}, out);
        XMLParser.flushStartTag("root", new String[]{"type"}, new String[]{prefs.isUserNode() ? "user" : "system"}, out);
        XMLParser.flushEmptyElement("map", out);
        StringTokenizer ancestors = new StringTokenizer(prefs.absolutePath(), "/");
        XMLParser.exportNode(ancestors, prefs, withSubTree, out);
        XMLParser.flushEndTag("root", out);
        XMLParser.flushEndTag("preferences", out);
        out.flush();
        out = null;
    }

    private static void exportNode(StringTokenizer ancestors, Preferences prefs, boolean withSubTree, BufferedWriter out) throws IOException, BackingStoreException {
        if (ancestors.hasMoreTokens()) {
            String name = ancestors.nextToken();
            XMLParser.flushStartTag("node", new String[]{"name"}, new String[]{name}, out);
            if (ancestors.hasMoreTokens()) {
                XMLParser.flushEmptyElement("map", out);
                XMLParser.exportNode(ancestors, prefs, withSubTree, out);
            } else {
                XMLParser.exportEntries(prefs, out);
                if (withSubTree) {
                    XMLParser.exportSubTree(prefs, out);
                }
            }
            XMLParser.flushEndTag("node", out);
        }
    }

    private static void exportSubTree(Preferences prefs, BufferedWriter out) throws BackingStoreException, IOException {
        String[] names = prefs.childrenNames();
        if (names.length > 0) {
            for (int i = 0; i < names.length; ++i) {
                Preferences child = prefs.node(names[i]);
                XMLParser.flushStartTag("node", new String[]{"name"}, new String[]{names[i]}, out);
                XMLParser.exportEntries(child, out);
                XMLParser.exportSubTree(child, out);
                XMLParser.flushEndTag("node", out);
            }
        }
    }

    private static void exportEntries(Preferences prefs, BufferedWriter out) throws BackingStoreException, IOException {
        String[] keys = prefs.keys();
        String[] values = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            values[i] = prefs.get(keys[i], null);
        }
        XMLParser.exportEntries(keys, values, out);
    }

    private static void exportEntries(String[] keys, String[] values, BufferedWriter out) throws IOException {
        if (keys.length == 0) {
            XMLParser.flushEmptyElement("map", out);
            return;
        }
        XMLParser.flushStartTag("map", out);
        for (int i = 0; i < keys.length; ++i) {
            if (values[i] == null) continue;
            XMLParser.flushEmptyElement("entry", new String[]{"key", "value"}, new String[]{keys[i], values[i]}, out);
        }
        XMLParser.flushEndTag("map", out);
    }

    private static void flushEndTag(String tagName, BufferedWriter out) throws IOException {
        XMLParser.flushIndent(indent--, out);
        out.write("</");
        out.write(tagName);
        out.write(">");
        out.newLine();
    }

    private static void flushEmptyElement(String tagName, BufferedWriter out) throws IOException {
        XMLParser.flushIndent(++indent, out);
        out.write("<");
        out.write(tagName);
        out.write(" />");
        out.newLine();
        --indent;
    }

    private static void flushEmptyElement(String tagName, String[] attrKeys, String[] attrValues, BufferedWriter out) throws IOException {
        XMLParser.flushIndent(++indent, out);
        out.write("<");
        out.write(tagName);
        XMLParser.flushPairs(attrKeys, attrValues, out);
        out.write(" />");
        out.newLine();
        --indent;
    }

    private static void flushPairs(String[] attrKeys, String[] attrValues, BufferedWriter out) throws IOException {
        for (int i = 0; i < attrKeys.length; ++i) {
            out.write(" ");
            out.write(attrKeys[i]);
            out.write("=\"");
            out.write(XMLParser.htmlEncode(attrValues[i]));
            out.write("\"");
        }
    }

    private static void flushIndent(int ind, BufferedWriter out) throws IOException {
        for (int i = 0; i < ind; ++i) {
            out.write("  ");
        }
    }

    private static void flushStartTag(String tagName, String[] attrKeys, String[] attrValues, BufferedWriter out) throws IOException {
        XMLParser.flushIndent(++indent, out);
        out.write("<");
        out.write(tagName);
        XMLParser.flushPairs(attrKeys, attrValues, out);
        out.write(">");
        out.newLine();
    }

    private static void flushStartTag(String tagName, BufferedWriter out) throws IOException {
        XMLParser.flushIndent(++indent, out);
        out.write("<");
        out.write(tagName);
        out.write(">");
        out.newLine();
    }

    private static String htmlEncode(String s) {
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    static void importPrefs(InputStream in) throws IOException, InvalidPreferencesFormatException {
        try {
            Document doc = builder.parse(new InputSource(in));
            Element preferences = doc.getDocumentElement();
            String version = preferences.getAttribute("EXTERNAL_XML_VERSION");
            if (version != null && Float.parseFloat(version) > 1.0f) {
                throw new InvalidPreferencesFormatException("Preferences version " + version + " is not supported");
            }
            Element root = (Element)preferences.getElementsByTagName("root").item(0);
            Preferences prefsRoot = null;
            String type = root.getAttribute("type");
            prefsRoot = type.equals("user") ? Preferences.userRoot() : Preferences.systemRoot();
            XMLParser.loadNode(prefsRoot, root);
        }
        catch (FactoryConfigurationError e) {
            throw new InvalidPreferencesFormatException(e);
        }
        catch (SAXException e) {
            throw new InvalidPreferencesFormatException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadNode(Preferences prefs, Element node) {
        NodeList children = XMLParser.selectNodeList(node, "node");
        NodeList entries = XMLParser.selectNodeList(node, "map/entry");
        int childNumber = children.getLength();
        Preferences[] prefChildren = new Preferences[childNumber];
        int entryNumber = entries.getLength();
        Object object = ((AbstractPreferences)prefs).lock;
        synchronized (object) {
            int i;
            if (((AbstractPreferences)prefs).isRemoved()) {
                return;
            }
            for (i = 0; i < entryNumber; ++i) {
                Element entry = (Element)entries.item(i);
                String key = entry.getAttribute("key");
                String value = entry.getAttribute("value");
                prefs.put(key, value);
            }
            for (i = 0; i < childNumber; ++i) {
                Element child = (Element)children.item(i);
                String name = child.getAttribute("name");
                prefChildren[i] = prefs.node(name);
            }
        }
        for (int i = 0; i < childNumber; ++i) {
            XMLParser.loadNode(prefChildren[i], (Element)children.item(i));
        }
    }

    private static NodeList selectNodeList(Element documentElement, String string) {
        NodeSet result = null;
        ArrayList<Node> input = new ArrayList<Node>();
        String[] path = string.split("/");
        NodeList childNodes = documentElement.getChildNodes();
        if (path[0].equals("entry") || path[0].equals("node")) {
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node next = childNodes.item(i);
                if (!(next instanceof Element) || !((Element)next).getNodeName().equals(path[0])) continue;
                input.add(next);
            }
        } else if (path[0].equals("map") && path[1].equals("entry")) {
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node next = childNodes.item(i);
                if (!(next instanceof Element) || !((Element)next).getNodeName().equals(path[0])) continue;
                NodeList nextChildNodes = next.getChildNodes();
                for (int j = 0; j < nextChildNodes.getLength(); ++j) {
                    Node subnext = nextChildNodes.item(j);
                    if (!(subnext instanceof Element) || !((Element)subnext).getNodeName().equals(path[1])) continue;
                    input.add(subnext);
                }
            }
        }
        result = new NodeSet(input.iterator());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties readXmlPreferences(File xmlFile) {
        Properties result;
        block5: {
            block7: {
                block6: {
                    result = new Properties();
                    if (xmlFile.exists()) break block6;
                    xmlFile.getParentFile().mkdirs();
                    break block5;
                }
                if (!xmlFile.canRead()) break block7;
                InputStreamReader reader = null;
                try {
                    reader = new InputStreamReader((InputStream)new FileInputStream(xmlFile), "UTF-8");
                    Document document = builder.parse(new InputSource(reader));
                    NodeList entries = XMLParser.selectNodeList(document.getDocumentElement(), "entry");
                    int length = entries.getLength();
                    for (int i = 0; i < length; ++i) {
                        Element node = (Element)entries.item(i);
                        String key = node.getAttribute("key");
                        String value = node.getAttribute("value");
                        result.setProperty(key, value);
                    }
                }
                catch (IOException iOException) {
                    IoUtils.closeQuietly(reader);
                    break block5;
                }
                catch (SAXException sAXException) {
                    IoUtils.closeQuietly(reader);
                    break block5;
                }
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(reader);
                    throw throwable;
                }
                IoUtils.closeQuietly(reader);
                break block5;
            }
            xmlFile.delete();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeXmlPreferences(File xmlFile, Properties properties) throws IOException {
        File parent = xmlFile.getParentFile();
        File temporaryForWriting = new File(parent, "prefs-" + UUID.randomUUID() + ".xml.tmp");
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(temporaryForWriting), "UTF-8"));
            out.write(HEADER);
            out.newLine();
            out.write(FILE_PREFS);
            out.newLine();
            String[] keys = properties.keySet().toArray(new String[properties.size()]);
            int length = keys.length;
            String[] values = new String[length];
            for (int i = 0; i < length; ++i) {
                values[i] = properties.getProperty(keys[i]);
            }
            XMLParser.exportEntries(keys, values, out);
            out.close();
            if (!temporaryForWriting.renameTo(xmlFile)) {
                throw new IOException("Failed to write preferences to " + xmlFile);
            }
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(out);
            temporaryForWriting.delete();
            throw throwable;
        }
        IoUtils.closeQuietly(out);
        temporaryForWriting.delete();
    }

    static {
        indent = -1;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new Error(e);
        }
        builder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (systemId.equals(XMLParser.PREFS_DTD_NAME)) {
                    InputSource result = new InputSource(new StringReader(XMLParser.PREFS_DTD));
                    result.setSystemId(XMLParser.PREFS_DTD_NAME);
                    return result;
                }
                throw new SAXException("Invalid DOCTYPE declaration " + systemId);
            }
        });
        builder.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException e) throws SAXException {
                throw e;
            }

            @Override
            public void error(SAXParseException e) throws SAXException {
                throw e;
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                throw e;
            }
        });
    }
}

