/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class ArrayBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E>,
Serializable {
    private static final long serialVersionUID = -817911632652898426L;
    final Object[] items;
    int takeIndex;
    int putIndex;
    int count;
    final ReentrantLock lock;
    private final Condition notEmpty;
    private final Condition notFull;
    transient Itrs itrs = null;

    final int inc(int i) {
        return ++i == this.items.length ? 0 : i;
    }

    final int dec(int i) {
        return (i == 0 ? this.items.length : i) - 1;
    }

    final E itemAt(int i) {
        return (E)this.items[i];
    }

    private static void checkNotNull(Object v) {
        if (v == null) {
            throw new NullPointerException();
        }
    }

    private void enqueue(E x) {
        this.items[this.putIndex] = x;
        this.putIndex = this.inc(this.putIndex);
        ++this.count;
        this.notEmpty.signal();
    }

    private E dequeue() {
        Object[] items = this.items;
        Object x = items[this.takeIndex];
        items[this.takeIndex] = null;
        this.takeIndex = this.inc(this.takeIndex);
        --this.count;
        if (this.itrs != null) {
            this.itrs.elementDequeued();
        }
        this.notFull.signal();
        return (E)x;
    }

    void removeAt(int removeIndex) {
        Object[] items = this.items;
        if (removeIndex == this.takeIndex) {
            items[this.takeIndex] = null;
            this.takeIndex = this.inc(this.takeIndex);
            --this.count;
            if (this.itrs != null) {
                this.itrs.elementDequeued();
            }
        } else {
            int next;
            int putIndex = this.putIndex;
            int i = removeIndex;
            while ((next = this.inc(i)) != putIndex) {
                items[i] = items[next];
                i = next;
            }
            items[i] = null;
            this.putIndex = i;
            --this.count;
            if (this.itrs != null) {
                this.itrs.removedAt(removeIndex);
            }
        }
        this.notFull.signal();
    }

    public ArrayBlockingQueue(int capacity) {
        this(capacity, false);
    }

    public ArrayBlockingQueue(int capacity, boolean fair) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.items = new Object[capacity];
        this.lock = new ReentrantLock(fair);
        this.notEmpty = this.lock.newCondition();
        this.notFull = this.lock.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayBlockingQueue(int capacity, boolean fair, Collection<? extends E> c) {
        this(capacity, fair);
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int i = 0;
            try {
                for (E e : c) {
                    ArrayBlockingQueue.checkNotNull(e);
                    this.items[i++] = e;
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new IllegalArgumentException();
            }
            this.count = i;
            this.putIndex = i == capacity ? 0 : i;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean add(E e) {
        return super.add(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        ArrayBlockingQueue.checkNotNull(e);
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.count == this.items.length) {
                boolean bl = false;
                return bl;
            }
            this.enqueue(e);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void put(E e) throws InterruptedException {
        ArrayBlockingQueue.checkNotNull(e);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (this.count == this.items.length) {
                this.notFull.await();
            }
            this.enqueue(e);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        ArrayBlockingQueue.checkNotNull(e);
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (this.count == this.items.length) {
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.notFull.awaitNanos(nanos);
            }
            this.enqueue(e);
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public E poll() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            E e = this.count == 0 ? null : (E)this.dequeue();
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public E take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (this.count == 0) {
                this.notEmpty.await();
            }
            E e = this.dequeue();
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (this.count == 0) {
                if (nanos <= 0L) {
                    E e = null;
                    return e;
                }
                nanos = this.notEmpty.awaitNanos(nanos);
            }
            E e = this.dequeue();
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public E peek() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            E e = this.itemAt(this.takeIndex);
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.count;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int remainingCapacity() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.items.length - this.count;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        Object[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.count > 0) {
                int putIndex = this.putIndex;
                int i = this.takeIndex;
                do {
                    if (!o.equals(items[i])) continue;
                    this.removeAt(i);
                    boolean bl = true;
                    return bl;
                } while ((i = this.inc(i)) != putIndex);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        Object[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.count > 0) {
                int putIndex = this.putIndex;
                int i = this.takeIndex;
                do {
                    if (!o.equals(items[i])) continue;
                    boolean bl = true;
                    return bl;
                } while ((i = this.inc(i)) != putIndex);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Object[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int count = this.count;
            Object[] a = new Object[count];
            int n = items.length - this.takeIndex;
            if (count <= n) {
                System.arraycopy((Object)items, this.takeIndex, (Object)a, 0, count);
            } else {
                System.arraycopy((Object)items, this.takeIndex, (Object)a, 0, n);
                System.arraycopy((Object)items, 0, (Object)a, n, count - n);
            }
            Object[] objectArray = a;
            return objectArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        Object[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n;
            int count = this.count;
            int len = a.length;
            if (len < count) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), count);
            }
            if (count <= (n = items.length - this.takeIndex)) {
                System.arraycopy((Object)items, this.takeIndex, a, 0, count);
            } else {
                System.arraycopy((Object)items, this.takeIndex, a, 0, n);
                System.arraycopy((Object)items, 0, a, n, count - n);
            }
            if (len > count) {
                a[count] = null;
            }
            Object[] objectArray = a;
            return objectArray;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public String toString() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int k = this.count;
            if (k == 0) {
                String string = "[]";
                return string;
            }
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            int i = this.takeIndex;
            while (true) {
                Object e;
                sb.append((e = this.items[i]) == this ? "(this Collection)" : e);
                if (--k == 0) {
                    String string = sb.append(']').toString();
                    return string;
                }
                sb.append(',').append(' ');
                i = this.inc(i);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int k = this.count;
            if (k > 0) {
                int putIndex = this.putIndex;
                int i = this.takeIndex;
                do {
                    items[i] = null;
                } while ((i = this.inc(i)) != putIndex);
                this.takeIndex = putIndex;
                this.count = 0;
                if (this.itrs != null) {
                    this.itrs.queueIsEmpty();
                }
                while (k > 0 && lock.hasWaiters(this.notFull)) {
                    this.notFull.signal();
                    --k;
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        ArrayBlockingQueue.checkNotNull(c);
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        Object[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n;
            block17: {
                int i;
                block18: {
                    int n2 = Math.min(maxElements, this.count);
                    int take = this.takeIndex;
                    try {
                        for (i = 0; i < n2; ++i) {
                            Object x = items[take];
                            c.add(x);
                            items[take] = null;
                            take = this.inc(take);
                        }
                        n = n2;
                        if (i <= 0) break block17;
                        this.count -= i;
                        this.takeIndex = take;
                        if (this.itrs == null) break block18;
                        if (this.count == 0) {
                            this.itrs.queueIsEmpty();
                            break block18;
                        }
                        if (i <= take) break block18;
                        this.itrs.takeIndexWrapped();
                    }
                    catch (Throwable throwable) {
                        if (i > 0) {
                            this.count -= i;
                            this.takeIndex = take;
                            if (this.itrs != null) {
                                if (this.count == 0) {
                                    this.itrs.queueIsEmpty();
                                } else if (i > take) {
                                    this.itrs.takeIndexWrapped();
                                }
                            }
                            while (i > 0 && lock.hasWaiters(this.notFull)) {
                                this.notFull.signal();
                                --i;
                            }
                        }
                        throw throwable;
                    }
                }
                while (i > 0 && lock.hasWaiters(this.notFull)) {
                    this.notFull.signal();
                    --i;
                }
            }
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    private class Itr
    implements Iterator<E> {
        private int cursor;
        private E nextItem;
        private int nextIndex;
        private E lastItem;
        private int lastRet = -1;
        private int prevTakeIndex;
        private int prevCycles;
        private static final int NONE = -1;
        private static final int REMOVED = -2;
        private static final int DETACHED = -3;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Itr() {
            ReentrantLock lock = ArrayBlockingQueue.this.lock;
            lock.lock();
            try {
                if (ArrayBlockingQueue.this.count == 0) {
                    this.cursor = -1;
                    this.nextIndex = -1;
                    this.prevTakeIndex = -3;
                } else {
                    int takeIndex;
                    this.prevTakeIndex = takeIndex = ArrayBlockingQueue.this.takeIndex;
                    this.nextIndex = takeIndex;
                    this.nextItem = ArrayBlockingQueue.this.itemAt(this.nextIndex);
                    this.cursor = this.incCursor(takeIndex);
                    if (ArrayBlockingQueue.this.itrs == null) {
                        ArrayBlockingQueue.this.itrs = new Itrs(this);
                    } else {
                        ArrayBlockingQueue.this.itrs.register(this);
                        ArrayBlockingQueue.this.itrs.doSomeSweeping(false);
                    }
                    this.prevCycles = ArrayBlockingQueue.this.itrs.cycles;
                }
            }
            finally {
                lock.unlock();
            }
        }

        boolean isDetached() {
            return this.prevTakeIndex < 0;
        }

        private int incCursor(int index) {
            if ((index = ArrayBlockingQueue.this.inc(index)) == ArrayBlockingQueue.this.putIndex) {
                index = -1;
            }
            return index;
        }

        private boolean invalidated(int index, int prevTakeIndex, long dequeues, int length) {
            if (index < 0) {
                return false;
            }
            int distance = index - prevTakeIndex;
            if (distance < 0) {
                distance += length;
            }
            return dequeues > (long)distance;
        }

        private void incorporateDequeues() {
            int cycles = ArrayBlockingQueue.this.itrs.cycles;
            int takeIndex = ArrayBlockingQueue.this.takeIndex;
            int prevCycles = this.prevCycles;
            int prevTakeIndex = this.prevTakeIndex;
            if (cycles != prevCycles || takeIndex != prevTakeIndex) {
                int len = ArrayBlockingQueue.this.items.length;
                long dequeues = (cycles - prevCycles) * len + (takeIndex - prevTakeIndex);
                if (this.invalidated(this.lastRet, prevTakeIndex, dequeues, len)) {
                    this.lastRet = -2;
                }
                if (this.invalidated(this.nextIndex, prevTakeIndex, dequeues, len)) {
                    this.nextIndex = -2;
                }
                if (this.invalidated(this.cursor, prevTakeIndex, dequeues, len)) {
                    this.cursor = takeIndex;
                }
                if (this.cursor < 0 && this.nextIndex < 0 && this.lastRet < 0) {
                    this.detach();
                } else {
                    this.prevCycles = cycles;
                    this.prevTakeIndex = takeIndex;
                }
            }
        }

        private void detach() {
            if (this.prevTakeIndex >= 0) {
                this.prevTakeIndex = -3;
                ArrayBlockingQueue.this.itrs.doSomeSweeping(true);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.nextItem != null) {
                return true;
            }
            this.noNext();
            return false;
        }

        private void noNext() {
            ReentrantLock lock = ArrayBlockingQueue.this.lock;
            lock.lock();
            try {
                if (!this.isDetached()) {
                    this.incorporateDequeues();
                    if (this.lastRet >= 0) {
                        this.lastItem = ArrayBlockingQueue.this.itemAt(this.lastRet);
                        this.detach();
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            Object x = this.nextItem;
            if (x == null) {
                throw new NoSuchElementException();
            }
            ReentrantLock lock = ArrayBlockingQueue.this.lock;
            lock.lock();
            try {
                if (!this.isDetached()) {
                    this.incorporateDequeues();
                }
                this.lastRet = this.nextIndex;
                int cursor = this.cursor;
                if (cursor >= 0) {
                    this.nextIndex = cursor;
                    this.nextItem = ArrayBlockingQueue.this.itemAt(this.nextIndex);
                    this.cursor = this.incCursor(cursor);
                } else {
                    this.nextIndex = -1;
                    this.nextItem = null;
                }
            }
            finally {
                lock.unlock();
            }
            return x;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            ReentrantLock lock = ArrayBlockingQueue.this.lock;
            lock.lock();
            try {
                if (!this.isDetached()) {
                    this.incorporateDequeues();
                }
                int lastRet = this.lastRet;
                this.lastRet = -1;
                if (lastRet >= 0) {
                    if (!this.isDetached()) {
                        ArrayBlockingQueue.this.removeAt(lastRet);
                    } else {
                        Object lastItem = this.lastItem;
                        this.lastItem = null;
                        if (ArrayBlockingQueue.this.itemAt(lastRet) == lastItem) {
                            ArrayBlockingQueue.this.removeAt(lastRet);
                        }
                    }
                } else if (lastRet == -1) {
                    throw new IllegalStateException();
                }
                if (this.cursor < 0 && this.nextIndex < 0) {
                    this.detach();
                }
            }
            finally {
                lock.unlock();
            }
        }

        void shutdown() {
            this.cursor = -1;
            if (this.nextIndex >= 0) {
                this.nextIndex = -2;
            }
            if (this.lastRet >= 0) {
                this.lastRet = -2;
                this.lastItem = null;
            }
            this.prevTakeIndex = -3;
        }

        private int distance(int index, int prevTakeIndex, int length) {
            int distance = index - prevTakeIndex;
            if (distance < 0) {
                distance += length;
            }
            return distance;
        }

        boolean removedAt(int removedIndex) {
            int nextIndex;
            int lastRet;
            if (this.isDetached()) {
                return true;
            }
            int cycles = ArrayBlockingQueue.this.itrs.cycles;
            int takeIndex = ArrayBlockingQueue.this.takeIndex;
            int prevCycles = this.prevCycles;
            int prevTakeIndex = this.prevTakeIndex;
            int len = ArrayBlockingQueue.this.items.length;
            int cycleDiff = cycles - prevCycles;
            if (removedIndex < takeIndex) {
                ++cycleDiff;
            }
            int removedDistance = cycleDiff * len + (removedIndex - prevTakeIndex);
            int cursor = this.cursor;
            if (cursor >= 0) {
                int x = this.distance(cursor, prevTakeIndex, len);
                if (x == removedDistance) {
                    if (cursor == ArrayBlockingQueue.this.putIndex) {
                        cursor = -1;
                        this.cursor = -1;
                    }
                } else if (x > removedDistance) {
                    this.cursor = cursor = ArrayBlockingQueue.this.dec(cursor);
                }
            }
            if ((lastRet = this.lastRet) >= 0) {
                int x = this.distance(lastRet, prevTakeIndex, len);
                if (x == removedDistance) {
                    lastRet = -2;
                    this.lastRet = -2;
                } else if (x > removedDistance) {
                    this.lastRet = lastRet = ArrayBlockingQueue.this.dec(lastRet);
                }
            }
            if ((nextIndex = this.nextIndex) >= 0) {
                int x = this.distance(nextIndex, prevTakeIndex, len);
                if (x == removedDistance) {
                    nextIndex = -2;
                    this.nextIndex = -2;
                } else if (x > removedDistance) {
                    this.nextIndex = nextIndex = ArrayBlockingQueue.this.dec(nextIndex);
                }
            } else if (cursor < 0 && nextIndex < 0 && lastRet < 0) {
                this.prevTakeIndex = -3;
                return true;
            }
            return false;
        }

        boolean takeIndexWrapped() {
            if (this.isDetached()) {
                return true;
            }
            if (ArrayBlockingQueue.this.itrs.cycles - this.prevCycles > 1) {
                this.shutdown();
                return true;
            }
            return false;
        }
    }

    class Itrs {
        int cycles = 0;
        private java.util.concurrent.ArrayBlockingQueue$Itrs.Node head;
        private java.util.concurrent.ArrayBlockingQueue$Itrs.Node sweeper = null;
        private static final int SHORT_SWEEP_PROBES = 4;
        private static final int LONG_SWEEP_PROBES = 16;

        Itrs(Itr initial) {
            this.register(initial);
        }

        void doSomeSweeping(boolean tryHarder) {
            boolean passedGo;
            java.util.concurrent.ArrayBlockingQueue$Itrs.Node p;
            java.util.concurrent.ArrayBlockingQueue$Itrs.Node o;
            int probes = tryHarder ? 16 : 4;
            java.util.concurrent.ArrayBlockingQueue$Itrs.Node sweeper = this.sweeper;
            if (sweeper == null) {
                o = null;
                p = this.head;
                passedGo = true;
            } else {
                o = sweeper;
                p = o.next;
                passedGo = false;
            }
            while (probes > 0) {
                if (p == null) {
                    if (passedGo) break;
                    o = null;
                    p = this.head;
                    passedGo = true;
                }
                Itr it = (Itr)p.get();
                java.util.concurrent.ArrayBlockingQueue$Itrs.Node next = p.next;
                if (it == null || it.isDetached()) {
                    probes = 16;
                    p.clear();
                    p.next = null;
                    if (o == null) {
                        this.head = next;
                        if (next == null) {
                            ArrayBlockingQueue.this.itrs = null;
                            return;
                        }
                    } else {
                        o.next = next;
                    }
                } else {
                    o = p;
                }
                p = next;
                --probes;
            }
            this.sweeper = p == null ? null : o;
        }

        void register(Itr itr) {
            this.head = new Node(this, itr, (Node)this.head);
        }

        void takeIndexWrapped() {
            ++this.cycles;
            java.util.concurrent.ArrayBlockingQueue$Itrs.Node o = null;
            java.util.concurrent.ArrayBlockingQueue$Itrs.Node p = this.head;
            while (p != null) {
                Itr it = (Itr)p.get();
                java.util.concurrent.ArrayBlockingQueue$Itrs.Node next = p.next;
                if (it == null || it.takeIndexWrapped()) {
                    p.clear();
                    p.next = null;
                    if (o == null) {
                        this.head = next;
                    } else {
                        o.next = next;
                    }
                } else {
                    o = p;
                }
                p = next;
            }
            if (this.head == null) {
                ArrayBlockingQueue.this.itrs = null;
            }
        }

        void removedAt(int removedIndex) {
            java.util.concurrent.ArrayBlockingQueue$Itrs.Node o = null;
            java.util.concurrent.ArrayBlockingQueue$Itrs.Node p = this.head;
            while (p != null) {
                Itr it = (Itr)p.get();
                java.util.concurrent.ArrayBlockingQueue$Itrs.Node next = p.next;
                if (it == null || it.removedAt(removedIndex)) {
                    p.clear();
                    p.next = null;
                    if (o == null) {
                        this.head = next;
                    } else {
                        o.next = next;
                    }
                } else {
                    o = p;
                }
                p = next;
            }
            if (this.head == null) {
                ArrayBlockingQueue.this.itrs = null;
            }
        }

        void queueIsEmpty() {
            java.util.concurrent.ArrayBlockingQueue$Itrs.Node p = this.head;
            while (p != null) {
                Itr it = (Itr)p.get();
                if (it != null) {
                    p.clear();
                    it.shutdown();
                }
                p = p.next;
            }
            this.head = null;
            ArrayBlockingQueue.this.itrs = null;
        }

        void elementDequeued() {
            if (ArrayBlockingQueue.this.count == 0) {
                this.queueIsEmpty();
            } else if (ArrayBlockingQueue.this.takeIndex == 0) {
                this.takeIndexWrapped();
            }
        }

        private static class Node
        extends WeakReference<Itr> {
            java.util.concurrent.ArrayBlockingQueue$Itrs.Node next;
            final /* synthetic */ Itrs this$1;

            Node(Itr iterator, java.util.concurrent.ArrayBlockingQueue$Itrs.Node next) {
                this.this$1 = var1_1;
                super(iterator);
                this.next = next;
            }
        }
    }
}

