/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public abstract class AbstractSequentialList<E>
extends AbstractList<E> {
    protected AbstractSequentialList() {
    }

    @Override
    public void add(int location, E object) {
        this.listIterator(location).add(object);
    }

    @Override
    public boolean addAll(int location, Collection<? extends E> collection) {
        ListIterator<E> it = this.listIterator(location);
        Iterator<E> colIt = collection.iterator();
        int next = it.nextIndex();
        while (colIt.hasNext()) {
            it.add(colIt.next());
        }
        return next != it.nextIndex();
    }

    @Override
    public E get(int location) {
        try {
            return this.listIterator(location).next();
        }
        catch (NoSuchElementException e) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator(0);
    }

    @Override
    public abstract ListIterator<E> listIterator(int var1);

    @Override
    public E remove(int location) {
        try {
            ListIterator<E> it = this.listIterator(location);
            E result = it.next();
            it.remove();
            return result;
        }
        catch (NoSuchElementException e) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public E set(int location, E object) {
        ListIterator<E> it = this.listIterator(location);
        if (!it.hasNext()) {
            throw new IndexOutOfBoundsException();
        }
        E result = it.next();
        it.set(object);
        return result;
    }
}

