/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.InvalidObjectException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.CharacterIterator;
import java.util.Map;
import java.util.Set;

public interface AttributedCharacterIterator
extends CharacterIterator {
    public Set<Attribute> getAllAttributeKeys();

    public Object getAttribute(Attribute var1);

    public Map<Attribute, Object> getAttributes();

    public int getRunLimit();

    public int getRunLimit(Attribute var1);

    public int getRunLimit(Set<? extends Attribute> var1);

    public int getRunStart();

    public int getRunStart(Attribute var1);

    public int getRunStart(Set<? extends Attribute> var1);

    public static class Attribute
    implements Serializable {
        private static final long serialVersionUID = -9142742483513960612L;
        public static final Attribute INPUT_METHOD_SEGMENT = new Attribute("input_method_segment");
        public static final Attribute LANGUAGE = new Attribute("language");
        public static final Attribute READING = new Attribute("reading");
        private String name;

        protected Attribute(String name) {
            this.name = name;
        }

        public final boolean equals(Object object) {
            return this == object;
        }

        protected String getName() {
            return this.name;
        }

        public final int hashCode() {
            return super.hashCode();
        }

        protected Object readResolve() throws InvalidObjectException {
            try {
                for (Field field : this.getClass().getFields()) {
                    if (field.getType() != this.getClass() || !Modifier.isStatic(field.getModifiers())) continue;
                    Attribute candidate = (Attribute)field.get(null);
                    if (!this.name.equals(candidate.name)) continue;
                    return candidate;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            throw new InvalidObjectException("Failed to resolve " + this);
        }

        public String toString() {
            return this.getClass().getName() + '(' + this.getName() + ')';
        }
    }
}

