/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.ByteArrayInputStream;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.util.Iterator;
import java.util.List;

public abstract class CertPath
implements Serializable {
    private static final long serialVersionUID = 6068470306649138683L;
    private final String type;

    protected CertPath(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof CertPath) {
            CertPath o = (CertPath)other;
            if (this.getType().equals(o.getType()) && this.getCertificates().equals(o.getCertificates())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getType().hashCode();
        hash = hash * 31 + this.getCertificates().hashCode();
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getType());
        sb.append(" Cert Path, len=");
        sb.append(this.getCertificates().size());
        sb.append(": [\n");
        int n = 1;
        Iterator<? extends Certificate> i = this.getCertificates().iterator();
        while (i.hasNext()) {
            sb.append("---------------certificate ");
            sb.append(n);
            sb.append("---------------\n");
            sb.append(i.next().toString());
            ++n;
        }
        sb.append("\n]");
        return sb.toString();
    }

    public abstract List<? extends Certificate> getCertificates();

    public abstract byte[] getEncoded() throws CertificateEncodingException;

    public abstract byte[] getEncoded(String var1) throws CertificateEncodingException;

    public abstract Iterator<String> getEncodings();

    protected Object writeReplace() throws ObjectStreamException {
        try {
            return new CertPathRep(this.getType(), this.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new NotSerializableException("Could not create serialization object: " + e);
        }
    }

    protected static class CertPathRep
    implements Serializable {
        private static final long serialVersionUID = 3015633072427920915L;
        private final String type;
        private final byte[] data;
        private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("type", String.class), new ObjectStreamField("data", byte[].class, true)};

        protected CertPathRep(String type, byte[] data) {
            this.type = type;
            this.data = data;
        }

        protected Object readResolve() throws ObjectStreamException {
            try {
                CertificateFactory cf = CertificateFactory.getInstance(this.type);
                return cf.generateCertPath(new ByteArrayInputStream(this.data));
            }
            catch (Throwable t) {
                throw new NotSerializableException("Could not resolve cert path: " + t);
            }
        }
    }
}

