/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.charset.spi.CharsetProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import libcore.icu.NativeConverter;

public abstract class Charset
implements Comparable<Charset> {
    private static final HashMap<String, Charset> CACHED_CHARSETS = new HashMap();
    private static final Charset DEFAULT_CHARSET = Charset.getDefaultCharset();
    private final String canonicalName;
    private final HashSet<String> aliasesSet;

    protected Charset(String canonicalName, String[] aliases) {
        Charset.checkCharsetName(canonicalName);
        this.canonicalName = canonicalName;
        this.aliasesSet = new HashSet();
        if (aliases != null) {
            for (String alias : aliases) {
                Charset.checkCharsetName(alias);
                this.aliasesSet.add(alias);
            }
        }
    }

    private static void checkCharsetName(String name) {
        if (name.isEmpty()) {
            throw new IllegalCharsetNameException(name);
        }
        if (!Charset.isValidCharsetNameStart(name.charAt(0))) {
            throw new IllegalCharsetNameException(name);
        }
        for (int i = 1; i < name.length(); ++i) {
            if (Charset.isValidCharsetNamePart(name.charAt(i))) continue;
            throw new IllegalCharsetNameException(name);
        }
    }

    private static boolean isValidCharsetNameStart(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
    }

    private static boolean isValidCharsetNamePart(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-' || c == '.' || c == ':' || c == '_';
    }

    public static SortedMap<String, Charset> availableCharsets() {
        TreeMap<String, Charset> charsets = new TreeMap<String, Charset>(String.CASE_INSENSITIVE_ORDER);
        for (String charsetName : NativeConverter.getAvailableCharsetNames()) {
            try {
                Charset charset = NativeConverter.charsetForName(charsetName);
                charsets.put(charset.name(), charset);
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                // empty catch block
            }
        }
        for (CharsetProvider charsetProvider : ServiceLoader.load(CharsetProvider.class)) {
            Iterator<Charset> it = charsetProvider.charsets();
            while (it.hasNext()) {
                Charset cs = it.next();
                if (charsets.containsKey(cs.name())) continue;
                charsets.put(cs.name(), cs);
            }
        }
        return Collections.unmodifiableSortedMap(charsets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Charset cacheCharset(String charsetName, Charset cs) {
        HashMap<String, Charset> hashMap = CACHED_CHARSETS;
        synchronized (hashMap) {
            String canonicalName = cs.name();
            Charset canonicalCharset = CACHED_CHARSETS.get(canonicalName);
            if (canonicalCharset == null) {
                canonicalCharset = cs;
            }
            CACHED_CHARSETS.put(canonicalName, canonicalCharset);
            CACHED_CHARSETS.put(charsetName, canonicalCharset);
            for (String alias : cs.aliasesSet) {
                CACHED_CHARSETS.put(alias, canonicalCharset);
            }
            return canonicalCharset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Charset forName(String charsetName) {
        Charset cs;
        HashMap<String, Charset> hashMap = CACHED_CHARSETS;
        synchronized (hashMap) {
            cs = CACHED_CHARSETS.get(charsetName);
            if (cs != null) {
                return cs;
            }
        }
        if (charsetName == null) {
            throw new IllegalCharsetNameException(null);
        }
        Charset.checkCharsetName(charsetName);
        cs = NativeConverter.charsetForName(charsetName);
        if (cs != null) {
            return Charset.cacheCharset(charsetName, cs);
        }
        for (CharsetProvider charsetProvider : ServiceLoader.load(CharsetProvider.class)) {
            cs = charsetProvider.charsetForName(charsetName);
            if (cs == null) continue;
            return Charset.cacheCharset(charsetName, cs);
        }
        throw new UnsupportedCharsetException(charsetName);
    }

    public static Charset forNameUEE(String charsetName) throws UnsupportedEncodingException {
        try {
            return Charset.forName(charsetName);
        }
        catch (Exception cause) {
            UnsupportedEncodingException ex = new UnsupportedEncodingException(charsetName);
            ex.initCause(cause);
            throw ex;
        }
    }

    public static boolean isSupported(String charsetName) {
        try {
            Charset.forName(charsetName);
            return true;
        }
        catch (UnsupportedCharsetException ex) {
            return false;
        }
    }

    public abstract boolean contains(Charset var1);

    public abstract CharsetEncoder newEncoder();

    public abstract CharsetDecoder newDecoder();

    public final String name() {
        return this.canonicalName;
    }

    public final Set<String> aliases() {
        return Collections.unmodifiableSet(this.aliasesSet);
    }

    public String displayName() {
        return this.canonicalName;
    }

    public String displayName(Locale l) {
        return this.canonicalName;
    }

    public final boolean isRegistered() {
        return !this.canonicalName.startsWith("x-") && !this.canonicalName.startsWith("X-");
    }

    public boolean canEncode() {
        return true;
    }

    public final ByteBuffer encode(CharBuffer buffer) {
        try {
            return this.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).encode(buffer);
        }
        catch (CharacterCodingException ex) {
            throw new Error(ex.getMessage(), ex);
        }
    }

    public final ByteBuffer encode(String s) {
        return this.encode(CharBuffer.wrap(s));
    }

    public final CharBuffer decode(ByteBuffer buffer) {
        try {
            return this.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).decode(buffer);
        }
        catch (CharacterCodingException ex) {
            throw new Error(ex.getMessage(), ex);
        }
    }

    @Override
    public final int compareTo(Charset charset) {
        return this.canonicalName.compareToIgnoreCase(charset.canonicalName);
    }

    public final boolean equals(Object obj) {
        if (obj instanceof Charset) {
            Charset that = (Charset)obj;
            return this.canonicalName.equals(that.canonicalName);
        }
        return false;
    }

    public final int hashCode() {
        return this.canonicalName.hashCode();
    }

    public final String toString() {
        return this.getClass().getName() + "[" + this.canonicalName + "]";
    }

    public static Charset defaultCharset() {
        return DEFAULT_CHARSET;
    }

    private static Charset getDefaultCharset() {
        String encoding = System.getProperty("file.encoding", "UTF-8");
        try {
            return Charset.forName(encoding);
        }
        catch (UnsupportedCharsetException e) {
            return Charset.forName("UTF-8");
        }
    }
}

