/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import libcore.util.BasicLruCache;

class AddressCache {
    private static final int MAX_ENTRIES = 16;
    private static final long TTL_NANOS = 2000000000L;
    private final BasicLruCache<String, AddressCacheEntry> cache = new BasicLruCache(16);

    AddressCache() {
    }

    public void clear() {
        this.cache.evictAll();
    }

    public Object get(String hostname) {
        AddressCacheEntry entry = this.cache.get(hostname);
        if (entry != null && entry.expiryNanos >= System.nanoTime()) {
            return entry.value;
        }
        return null;
    }

    public void put(String hostname, InetAddress[] addresses) {
        this.cache.put(hostname, new AddressCacheEntry(addresses));
    }

    public void putUnknownHost(String hostname, String detailMessage) {
        this.cache.put(hostname, new AddressCacheEntry(detailMessage));
    }

    static class AddressCacheEntry {
        final Object value;
        final long expiryNanos;

        AddressCacheEntry(Object value) {
            this.value = value;
            this.expiryNanos = System.nanoTime() + 2000000000L;
        }
    }
}

