/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

@FindBugsSuppressWarnings(value={"DM_NUMBER_CTOR"})
public final class Long
extends Number
implements Comparable<Long> {
    private static final long serialVersionUID = 4290774380558885855L;
    private final long value;
    public static final long MAX_VALUE = 0x7FFFFFFFFFFFFFFFL;
    public static final long MIN_VALUE = -9223372036854775808L;
    public static final Class<Long> TYPE = long[].class.getComponentType();
    public static final int SIZE = 64;
    private static final Long[] SMALL_VALUES = new Long[256];

    public Long(long value) {
        this.value = value;
    }

    public Long(String string) throws NumberFormatException {
        this(Long.parseLong(string));
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public int compareTo(Long object) {
        return Long.compare(this.value, object.value);
    }

    public static int compare(long lhs, long rhs) {
        return lhs < rhs ? -1 : (lhs == rhs ? 0 : 1);
    }

    private static NumberFormatException invalidLong(String s) {
        throw new NumberFormatException("Invalid long: \"" + s + "\"");
    }

    public static Long decode(String string) throws NumberFormatException {
        boolean negative;
        int length = string.length();
        int i = 0;
        if (length == 0) {
            throw Long.invalidLong(string);
        }
        char firstDigit = string.charAt(i);
        boolean bl = negative = firstDigit == '-';
        if (negative) {
            if (length == 1) {
                throw Long.invalidLong(string);
            }
            firstDigit = string.charAt(++i);
        }
        int base = 10;
        if (firstDigit == '0') {
            if (++i == length) {
                return 0L;
            }
            firstDigit = string.charAt(i);
            if (firstDigit == 'x' || firstDigit == 'X') {
                if (i == length) {
                    throw Long.invalidLong(string);
                }
                ++i;
                base = 16;
            } else {
                base = 8;
            }
        } else if (firstDigit == '#') {
            if (i == length) {
                throw Long.invalidLong(string);
            }
            ++i;
            base = 16;
        }
        long result = Long.parse(string, i, base, negative);
        return result;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        return o instanceof Long && ((Long)o).value == this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    public static Long getLong(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String prop = System.getProperty(string);
        if (prop == null) {
            return null;
        }
        try {
            return Long.decode(prop);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static Long getLong(String string, long defaultValue) {
        if (string == null || string.length() == 0) {
            return defaultValue;
        }
        String prop = System.getProperty(string);
        if (prop == null) {
            return defaultValue;
        }
        try {
            return Long.decode(prop);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public static Long getLong(String string, Long defaultValue) {
        if (string == null || string.length() == 0) {
            return defaultValue;
        }
        String prop = System.getProperty(string);
        if (prop == null) {
            return defaultValue;
        }
        try {
            return Long.decode(prop);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    public static long parseLong(String string) throws NumberFormatException {
        return Long.parseLong(string, 10);
    }

    public static long parseLong(String string, int radix) throws NumberFormatException {
        boolean negative;
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException("Invalid radix: " + radix);
        }
        if (string == null) {
            throw Long.invalidLong(string);
        }
        int length = string.length();
        int i = 0;
        if (length == 0) {
            throw Long.invalidLong(string);
        }
        boolean bl = negative = string.charAt(i) == '-';
        if (negative && ++i == length) {
            throw Long.invalidLong(string);
        }
        return Long.parse(string, i, radix, negative);
    }

    private static long parse(String string, int offset, int radix, boolean negative) {
        long max = Long.MIN_VALUE / (long)radix;
        long result = 0L;
        long length = string.length();
        while ((long)offset < length) {
            int digit;
            if ((digit = Character.digit(string.charAt(offset++), radix)) == -1) {
                throw Long.invalidLong(string);
            }
            if (max > result) {
                throw Long.invalidLong(string);
            }
            long next = result * (long)radix - (long)digit;
            if (next > result) {
                throw Long.invalidLong(string);
            }
            result = next;
        }
        if (!negative && (result = -result) < 0L) {
            throw Long.invalidLong(string);
        }
        return result;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    public static String toBinaryString(long v) {
        return IntegralToString.longToBinaryString(v);
    }

    public static String toHexString(long v) {
        return IntegralToString.longToHexString(v);
    }

    public static String toOctalString(long v) {
        return IntegralToString.longToOctalString(v);
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public static String toString(long n) {
        return IntegralToString.longToString(n);
    }

    public static String toString(long v, int radix) {
        return IntegralToString.longToString(v, radix);
    }

    public static Long valueOf(String string) throws NumberFormatException {
        return Long.parseLong(string);
    }

    public static Long valueOf(String string, int radix) throws NumberFormatException {
        return Long.parseLong(string, radix);
    }

    public static long highestOneBit(long v) {
        v |= v >> 1;
        v |= v >> 2;
        v |= v >> 4;
        v |= v >> 8;
        v |= v >> 16;
        v |= v >> 32;
        return v - (v >>> 1);
    }

    public static long lowestOneBit(long v) {
        return v & -v;
    }

    public static int numberOfLeadingZeros(long v) {
        if (v < 0L) {
            return 0;
        }
        if (v == 0L) {
            return 64;
        }
        int n = 1;
        int i = (int)(v >>> 32);
        if (i == 0) {
            n += 32;
            i = (int)v;
        }
        if (i >>> 16 == 0) {
            n += 16;
            i <<= 16;
        }
        if (i >>> 24 == 0) {
            n += 8;
            i <<= 8;
        }
        if (i >>> 28 == 0) {
            n += 4;
            i <<= 4;
        }
        if (i >>> 30 == 0) {
            n += 2;
            i <<= 2;
        }
        return n - (i >>> 31);
    }

    public static int numberOfTrailingZeros(long v) {
        int low = (int)v;
        return low != 0 ? Integer.numberOfTrailingZeros(low) : 32 + Integer.numberOfTrailingZeros((int)(v >>> 32));
    }

    public static int bitCount(long v) {
        v -= v >>> 1 & 0x5555555555555555L;
        v = (v & 0x3333333333333333L) + (v >>> 2 & 0x3333333333333333L);
        int i = (int)(v >>> 32) + (int)v;
        i = (i & 0xF0F0F0F) + (i >>> 4 & 0xF0F0F0F);
        i += i >>> 8;
        i += i >>> 16;
        return i & 0x7F;
    }

    public static long rotateLeft(long v, int distance) {
        return v << distance | v >>> -distance;
    }

    public static long rotateRight(long v, int distance) {
        return v >>> distance | v << -distance;
    }

    public static long reverseBytes(long v) {
        v = v >>> 8 & 0xFF00FF00FF00FFL | (v & 0xFF00FF00FF00FFL) << 8;
        v = v >>> 16 & 0xFFFF0000FFFFL | (v & 0xFFFF0000FFFFL) << 16;
        return v >>> 32 | v << 32;
    }

    public static long reverse(long v) {
        v = v >>> 1 & 0x5555555555555555L | (v & 0x5555555555555555L) << 1;
        v = v >>> 2 & 0x3333333333333333L | (v & 0x3333333333333333L) << 2;
        v = v >>> 4 & 0xF0F0F0F0F0F0F0FL | (v & 0xF0F0F0F0F0F0F0FL) << 4;
        v = v >>> 8 & 0xFF00FF00FF00FFL | (v & 0xFF00FF00FF00FFL) << 8;
        v = v >>> 16 & 0xFFFF0000FFFFL | (v & 0xFFFF0000FFFFL) << 16;
        return v >>> 32 | v << 32;
    }

    public static int signum(long v) {
        return v < 0L ? -1 : (v == 0L ? 0 : 1);
    }

    public static Long valueOf(long v) {
        return v >= 128L || v < -128L ? new Long(v) : SMALL_VALUES[(int)v + 128];
    }

    static {
        for (int i = -128; i < 128; ++i) {
            Long.SMALL_VALUES[i + 128] = new Long(i);
        }
    }
}

