/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import libcore.util.BasicLruCache;
import libcore.util.EmptyArray;

public abstract class Enum<E extends Enum<E>>
implements Serializable,
Comparable<E> {
    private static final long serialVersionUID = -4300926546619394005L;
    private static final BasicLruCache<Class<? extends Enum>, Object[]> sharedConstantsCache = new BasicLruCache<Class<? extends Enum>, Object[]>(64){

        @Override
        protected Object[] create(Class<? extends Enum> enumType) {
            if (!enumType.isEnum()) {
                return null;
            }
            Method method = null;
            try {
                method = enumType.getDeclaredMethod("values", EmptyArray.CLASS);
                method.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            try {
                return (Object[])method.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException impossible) {
                throw new AssertionError();
            }
            catch (InvocationTargetException impossible) {
                throw new AssertionError();
            }
        }
    };
    private final String name;
    private final int ordinal;

    protected Enum(String name, int ordinal) {
        this.name = name;
        this.ordinal = ordinal;
    }

    public final String name() {
        return this.name;
    }

    public final int ordinal() {
        return this.ordinal;
    }

    public String toString() {
        return this.name;
    }

    public final boolean equals(Object other) {
        return this == other;
    }

    public final int hashCode() {
        return this.ordinal + (this.name == null ? 0 : this.name.hashCode());
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Enums may not be cloned");
    }

    @Override
    public final int compareTo(E o) {
        return this.ordinal - ((Enum)o).ordinal;
    }

    public final Class<E> getDeclaringClass() {
        Class<?> myClass = this.getClass();
        Class<?> mySuperClass = myClass.getSuperclass();
        if (Enum.class == mySuperClass) {
            return myClass;
        }
        return mySuperClass;
    }

    public static <T extends Enum<T>> T valueOf(Class<T> enumType, String name) {
        if (enumType == null) {
            throw new NullPointerException("enumType == null");
        }
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        Enum[] values = Enum.getSharedConstants(enumType);
        if (values == null) {
            throw new IllegalArgumentException(enumType + " is not an enum type");
        }
        for (Enum value : values) {
            if (!name.equals(value.name())) continue;
            return (T)value;
        }
        throw new IllegalArgumentException(name + " is not a constant in " + enumType.getName());
    }

    public static <T extends Enum<T>> T[] getSharedConstants(Class<T> enumType) {
        return (Enum[])sharedConstantsCache.get(enumType);
    }

    protected final void finalize() {
    }
}

