/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.robovm.rt.ReflectionAccess;

final class ClassCache<T> {
    static final ReflectionAccess R = ClassCache.loadReflectionAccess();
    private static final Class<?>[] EMPTY_CLASSES = new Class[0];
    private static final Constructor<?>[] EMPTY_CONSTRUCTORS = new Constructor[0];
    private static final Method[] EMPTY_METHODS = new Method[0];
    private static final Field[] EMPTY_FIELDS = new Field[0];
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private final Class<T> clazz;
    private String name;
    private Class<?>[] declaredClasses;
    private Class<?>[] declaredPublicClasses;
    private Class<?>[] allPublicClasses;
    private Field[] declaredFields;
    private Field[] declaredPublicFields;
    private Field[] allPublicFields;
    private Constructor<?>[] declaredConstructors;
    private Constructor<?>[] declaredPublicConstructors;
    private Method[] declaredMethods;
    private Method[] declaredPublicMethods;
    private Method[] allPublicMethods;
    private Annotation[] declaredAnnotations;
    private Annotation[] allAnnotations;

    ClassCache(Class<T> clazz) {
        this.clazz = clazz;
    }

    String getName() {
        if (this.name == null) {
            String n = this.clazz.getName0();
            if (this.clazz.isPrimitive()) {
                switch (n.charAt(0)) {
                    case 'Z': {
                        this.name = "boolean";
                        break;
                    }
                    case 'B': {
                        this.name = "byte";
                        break;
                    }
                    case 'S': {
                        this.name = "short";
                        break;
                    }
                    case 'C': {
                        this.name = "char";
                        break;
                    }
                    case 'I': {
                        this.name = "int";
                        break;
                    }
                    case 'J': {
                        this.name = "long";
                        break;
                    }
                    case 'F': {
                        this.name = "float";
                        break;
                    }
                    case 'D': {
                        this.name = "double";
                        break;
                    }
                    case 'V': {
                        this.name = "void";
                    }
                }
            } else {
                this.name = n.replace('/', '.');
            }
        }
        return this.name;
    }

    Class<?>[] getDeclaredClasses(boolean copy) {
        if (this.declaredClasses == null) {
            this.declaredClasses = this.clazz.getDeclaredClasses0(false);
            if (this.declaredClasses == null) {
                this.declaredClasses = EMPTY_CLASSES;
            }
        }
        return copy ? (Class[])this.declaredClasses.clone() : this.declaredClasses;
    }

    Class<?>[] getDeclaredPublicClasses(boolean copy) {
        if (this.declaredPublicClasses == null) {
            this.declaredPublicClasses = this.clazz.getDeclaredClasses0(true);
            if (this.declaredPublicClasses == null) {
                this.declaredPublicClasses = EMPTY_CLASSES;
            }
        }
        return copy ? (Class[])this.declaredPublicClasses.clone() : this.declaredPublicClasses;
    }

    Class<?>[] getDeclaredClasses(boolean copy, boolean publicOnly) {
        if (publicOnly) {
            return this.getDeclaredPublicClasses(copy);
        }
        return this.getDeclaredClasses(copy);
    }

    Field[] getDeclaredFields(boolean copy) {
        if (this.declaredFields == null) {
            this.declaredFields = this.clazz.getDeclaredFields0(false);
            if (this.declaredFields == null) {
                this.declaredFields = EMPTY_FIELDS;
            }
        }
        return copy ? R.clone(this.declaredFields) : this.declaredFields;
    }

    Field[] getDeclaredPublicFields(boolean copy) {
        if (this.declaredPublicFields == null) {
            this.declaredPublicFields = this.clazz.getDeclaredFields0(true);
            if (this.declaredPublicFields == null) {
                this.declaredPublicFields = EMPTY_FIELDS;
            }
        }
        return copy ? R.clone(this.declaredPublicFields) : this.declaredPublicFields;
    }

    Field[] getDeclaredFields(boolean copy, boolean publicOnly) {
        if (publicOnly) {
            return this.getDeclaredPublicFields(copy);
        }
        return this.getDeclaredFields(copy);
    }

    Constructor<?>[] getDeclaredConstructors(boolean copy) {
        if (this.declaredConstructors == null) {
            this.declaredConstructors = this.clazz.getDeclaredConstructors0(false);
            if (this.declaredConstructors == null) {
                this.declaredConstructors = EMPTY_CONSTRUCTORS;
            }
        }
        return copy ? R.clone(this.declaredConstructors) : this.declaredConstructors;
    }

    Constructor<?>[] getDeclaredPublicConstructors(boolean copy) {
        if (this.declaredPublicConstructors == null) {
            this.declaredPublicConstructors = this.clazz.getDeclaredConstructors0(true);
            if (this.declaredPublicConstructors == null) {
                this.declaredPublicConstructors = EMPTY_CONSTRUCTORS;
            }
        }
        return copy ? R.clone(this.declaredPublicConstructors) : this.declaredPublicConstructors;
    }

    Method[] getDeclaredMethods(boolean copy) {
        if (this.declaredMethods == null) {
            this.declaredMethods = this.clazz.getDeclaredMethods0(false);
            if (this.declaredMethods == null) {
                this.declaredMethods = EMPTY_METHODS;
            }
        }
        return copy ? R.clone(this.declaredMethods) : this.declaredMethods;
    }

    Method[] getDeclaredPublicMethods(boolean copy) {
        if (this.declaredPublicMethods == null) {
            this.declaredPublicMethods = this.clazz.getDeclaredMethods0(true);
            if (this.declaredPublicMethods == null) {
                this.declaredPublicMethods = EMPTY_METHODS;
            }
        }
        return copy ? R.clone(this.declaredPublicMethods) : this.declaredPublicMethods;
    }

    Method[] getDeclaredMethods(boolean copy, boolean publicOnly) {
        if (publicOnly) {
            return this.getDeclaredPublicMethods(copy);
        }
        return this.getDeclaredMethods(copy);
    }

    Annotation[] getDeclaredAnnotations(boolean copy) {
        if (this.declaredAnnotations == null) {
            this.declaredAnnotations = this.clazz.getDeclaredAnnotations0();
            if (this.declaredAnnotations == null) {
                this.declaredAnnotations = EMPTY_ANNOTATIONS;
            }
        }
        return copy ? (Annotation[])this.declaredAnnotations.clone() : this.declaredAnnotations;
    }

    Class<?>[] getClasses(boolean copy) {
        if (this.allPublicClasses == null) {
            List<Class<?>> l = this.buildClassesList(new ArrayList(), new HashSet<String>(), true);
            this.allPublicClasses = l.toArray(new Class[l.size()]);
        }
        return copy ? (Class[])this.allPublicClasses.clone() : this.allPublicClasses;
    }

    Field[] getFields(boolean copy) {
        if (this.allPublicFields == null) {
            List<Field> l = this.buildFieldsList(new ArrayList<Field>(), new HashSet<String>(), true);
            this.allPublicFields = l.toArray(new Field[l.size()]);
        }
        return copy ? R.clone(this.allPublicFields) : this.allPublicFields;
    }

    Method[] getMethods(boolean copy) {
        if (this.allPublicMethods == null) {
            List<Method> l = this.buildMethodsList(new ArrayList<Method>(), new HashSet<MethodHashKey>(), true);
            this.allPublicMethods = l.toArray(new Method[l.size()]);
        }
        return copy ? R.clone(this.allPublicMethods) : this.allPublicMethods;
    }

    Annotation[] getAnnotations(boolean copy) {
        if (this.allAnnotations == null) {
            this.allAnnotations = this.clazz.getAnnotations0();
            if (this.allAnnotations == null) {
                this.allAnnotations = EMPTY_ANNOTATIONS;
            }
        }
        return copy ? (Annotation[])this.allAnnotations.clone() : this.allAnnotations;
    }

    Constructor<T> getDeclaredConstructor(boolean copy, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Constructor<T> c = this.findConstructor(this.getDeclaredConstructors(false), parameterTypes);
        return copy ? R.clone(c) : c;
    }

    Constructor<T> getConstructor(boolean copy, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Constructor<T> c = this.findConstructor(this.getDeclaredPublicConstructors(false), parameterTypes);
        return copy ? R.clone(c) : c;
    }

    Field getDeclaredField(boolean copy, String name) throws NoSuchFieldException {
        Field f = this.findField(this.getDeclaredFields(false), name);
        return copy ? R.clone(f) : f;
    }

    Field getField(boolean copy, String name) throws NoSuchFieldException {
        Field f = this.findField(this.getFields(false), name);
        return copy ? R.clone(f) : f;
    }

    Method getDeclaredMethod(boolean copy, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Method m = this.findMethod(this.getDeclaredMethods(false), name, parameterTypes);
        return copy ? R.clone(m) : m;
    }

    Method getMethod(boolean copy, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Method m = this.findMethod(this.getMethods(false), name, parameterTypes);
        return copy ? R.clone(m) : m;
    }

    private List<Class<?>> buildClassesList(List<Class<?>> result, Set<String> seen, boolean publicOnly) {
        for (Class<T> c = this.clazz; c != null; c = c.getSuperclass()) {
            for (Class<?> f : c.getClassCache().getDeclaredClasses(false, publicOnly)) {
                String s = f.toString();
                if (seen.contains(s)) continue;
                result.add(f);
                seen.add(s);
            }
        }
        return result;
    }

    private List<Field> buildFieldsList(List<Field> result, Set<String> seen, boolean publicOnly) {
        for (Class<T> c = this.clazz; c != null; c = c.getSuperclass()) {
            for (Field field : c.getClassCache().getDeclaredFields(false, publicOnly)) {
                String s = field.toString();
                if (seen.contains(s)) continue;
                result.add(field);
                seen.add(s);
            }
            for (AnnotatedElement annotatedElement : c.getInterfaces()) {
                super.buildFieldsList(result, seen, publicOnly);
            }
        }
        return result;
    }

    private List<Method> buildMethodsList(List<Method> result, Set<MethodHashKey> seen, boolean publicOnly) {
        Class<T> c;
        for (c = this.clazz; c != null; c = c.getSuperclass()) {
            for (AnnotatedElement annotatedElement : c.getClassCache().getDeclaredMethods(false, publicOnly)) {
                MethodHashKey key = new MethodHashKey((Method)annotatedElement);
                if (seen.contains(key)) continue;
                result.add((Method)annotatedElement);
                seen.add(key);
            }
        }
        for (c = this.clazz; c != null; c = c.getSuperclass()) {
            for (AnnotatedElement annotatedElement : c.getInterfaces()) {
                super.buildMethodsList(result, seen, publicOnly);
            }
        }
        return result;
    }

    private Constructor<T> findConstructor(Constructor<?>[] candidates, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        for (Constructor<?> c : candidates) {
            if (!R.matchParameterTypes(c, parameterTypes)) continue;
            return c;
        }
        throw new NoSuchMethodException(this.clazz.getName() + '(' + ClassCache.parameterTypesToString(parameterTypes) + ')');
    }

    private Method findMethod(Method[] candidates, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Method firstMatch = null;
        ArrayList<Method> allMatches = null;
        for (Method m : candidates) {
            if (!name.equals(m.getName()) || !R.matchParameterTypes(m, parameterTypes)) continue;
            if (firstMatch == null) {
                firstMatch = m;
                continue;
            }
            if (allMatches == null) {
                allMatches = new ArrayList<Method>();
                allMatches.add(firstMatch);
            }
            allMatches.add(m);
        }
        if (firstMatch == null) {
            throw new NoSuchMethodException(this.clazz.getName() + "." + name + '(' + ClassCache.parameterTypesToString(parameterTypes) + ')');
        }
        if (allMatches == null) {
            return firstMatch;
        }
        Method result = null;
        for (Method m : allMatches) {
            if (!m.isSynthetic()) {
                return m;
            }
            result = m;
        }
        return result;
    }

    private Field findField(Field[] candidates, String name) throws NoSuchFieldException {
        for (Field f : candidates) {
            if (!name.equals(f.getName())) continue;
            return f;
        }
        throw new NoSuchFieldException(name);
    }

    private static void appendTypeName(StringBuilder out, Class<?> c) {
        if (c == null) {
            out.append("null");
        } else {
            int dimensions = 0;
            while (c.isArray()) {
                c = c.getComponentType();
                ++dimensions;
            }
            out.append(c.getName());
            for (int d = 0; d < dimensions; ++d) {
                out.append("[]");
            }
        }
    }

    private static String parameterTypesToString(Class<?>[] parameterTypes) {
        if (parameterTypes != null && parameterTypes.length > 0) {
            StringBuilder sb = new StringBuilder();
            ClassCache.appendTypeName(sb, parameterTypes[0]);
            for (int i = 1; i < parameterTypes.length; ++i) {
                sb.append(',');
                ClassCache.appendTypeName(sb, parameterTypes[i]);
            }
            return sb.toString();
        }
        return "";
    }

    private static final native ReflectionAccess loadReflectionAccess();

    private static final class MethodHashKey {
        private final Method m;

        MethodHashKey(Method m) {
            this.m = m;
        }

        public int hashCode() {
            return this.m.getName().hashCode();
        }

        public boolean equals(Object o) {
            Method m1 = this.m;
            Method m2 = ((MethodHashKey)o).m;
            return R.equals(m1, m2);
        }
    }
}

