/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.InvalidObjectException;
import java.util.Arrays;
import libcore.util.EmptyArray;

abstract class AbstractStringBuilder {
    static final int INITIAL_CAPACITY = 16;
    private char[] value;
    private int count;
    private boolean shared;

    final char[] getValue() {
        return this.value;
    }

    final char[] shareValue() {
        this.shared = true;
        return this.value;
    }

    final void set(char[] val, int len) throws InvalidObjectException {
        if (val == null) {
            val = EmptyArray.CHAR;
        }
        if (val.length < len) {
            throw new InvalidObjectException("count out of range");
        }
        this.shared = false;
        this.value = val;
        this.count = len;
    }

    AbstractStringBuilder() {
        this.value = new char[16];
    }

    AbstractStringBuilder(int capacity) {
        if (capacity < 0) {
            throw new NegativeArraySizeException(Integer.toString(capacity));
        }
        this.value = new char[capacity];
    }

    AbstractStringBuilder(String string) {
        this.count = string.length();
        this.shared = false;
        this.value = new char[this.count + 16];
        string._getChars(0, this.count, this.value, 0);
    }

    private void enlargeBuffer(int min) {
        int newCount = (this.value.length >> 1) + this.value.length + 2;
        char[] newData = new char[min > newCount ? min : newCount];
        System.arraycopy((Object)this.value, 0, (Object)newData, 0, this.count);
        this.value = newData;
        this.shared = false;
    }

    final void appendNull() {
        int newCount = this.count + 4;
        if (newCount > this.value.length) {
            this.enlargeBuffer(newCount);
        }
        this.value[this.count++] = 110;
        this.value[this.count++] = 117;
        this.value[this.count++] = 108;
        this.value[this.count++] = 108;
    }

    final void append0(char[] chars) {
        int newCount = this.count + chars.length;
        if (newCount > this.value.length) {
            this.enlargeBuffer(newCount);
        }
        System.arraycopy((Object)chars, 0, (Object)this.value, this.count, chars.length);
        this.count = newCount;
    }

    final void append0(char[] chars, int offset, int length) {
        Arrays.checkOffsetAndCount(chars.length, offset, length);
        int newCount = this.count + length;
        if (newCount > this.value.length) {
            this.enlargeBuffer(newCount);
        }
        System.arraycopy((Object)chars, offset, (Object)this.value, this.count, length);
        this.count = newCount;
    }

    final void append0(char ch) {
        if (this.count == this.value.length) {
            this.enlargeBuffer(this.count + 1);
        }
        this.value[this.count++] = ch;
    }

    final void append0(String string) {
        if (string == null) {
            this.appendNull();
            return;
        }
        int length = string.length();
        int newCount = this.count + length;
        if (newCount > this.value.length) {
            this.enlargeBuffer(newCount);
        }
        string._getChars(0, length, this.value, this.count);
        this.count = newCount;
    }

    final void append0(CharSequence s, int start, int end) {
        if (s == null) {
            s = "null";
        }
        if ((start | end) < 0 || start > end || end > s.length()) {
            throw new IndexOutOfBoundsException();
        }
        int length = end - start;
        int newCount = this.count + length;
        if (newCount > this.value.length) {
            this.enlargeBuffer(newCount);
        } else if (this.shared) {
            this.value = (char[])this.value.clone();
            this.shared = false;
        }
        if (s instanceof String) {
            ((String)s)._getChars(start, end, this.value, this.count);
        } else if (s instanceof AbstractStringBuilder) {
            AbstractStringBuilder other = (AbstractStringBuilder)((Object)s);
            System.arraycopy((Object)other.value, start, (Object)this.value, this.count, length);
        } else {
            int j = this.count;
            for (int i = start; i < end; ++i) {
                this.value[j++] = s.charAt(i);
            }
        }
        this.count = newCount;
    }

    public int capacity() {
        return this.value.length;
    }

    public char charAt(int index) {
        if (index < 0 || index >= this.count) {
            throw this.indexAndLength(index);
        }
        return this.value[index];
    }

    private StringIndexOutOfBoundsException indexAndLength(int index) {
        throw new StringIndexOutOfBoundsException(this.count, index);
    }

    private StringIndexOutOfBoundsException startEndAndLength(int start, int end) {
        throw new StringIndexOutOfBoundsException(this.count, start, end - start);
    }

    final void delete0(int start, int end) {
        if (start >= 0) {
            if (end > this.count) {
                end = this.count;
            }
            if (end == start) {
                return;
            }
            if (end > start) {
                int length = this.count - end;
                if (length >= 0) {
                    if (!this.shared) {
                        System.arraycopy((Object)this.value, end, (Object)this.value, start, length);
                    } else {
                        char[] newData = new char[this.value.length];
                        System.arraycopy((Object)this.value, 0, (Object)newData, 0, start);
                        System.arraycopy((Object)this.value, end, (Object)newData, start, length);
                        this.value = newData;
                        this.shared = false;
                    }
                }
                this.count -= end - start;
                return;
            }
        }
        throw this.startEndAndLength(start, end);
    }

    final void deleteCharAt0(int index) {
        if (index < 0 || index >= this.count) {
            throw this.indexAndLength(index);
        }
        int length = this.count - index - 1;
        if (length > 0) {
            if (!this.shared) {
                System.arraycopy((Object)this.value, index + 1, (Object)this.value, index, length);
            } else {
                char[] newData = new char[this.value.length];
                System.arraycopy((Object)this.value, 0, (Object)newData, 0, index);
                System.arraycopy((Object)this.value, index + 1, (Object)newData, index, length);
                this.value = newData;
                this.shared = false;
            }
        }
        --this.count;
    }

    public void ensureCapacity(int min) {
        if (min > this.value.length) {
            int ourMin = this.value.length * 2 + 2;
            this.enlargeBuffer(Math.max(ourMin, min));
        }
    }

    public void getChars(int start, int end, char[] dst, int dstStart) {
        if (start > this.count || end > this.count || start > end) {
            throw this.startEndAndLength(start, end);
        }
        System.arraycopy((Object)this.value, start, (Object)dst, dstStart, end - start);
    }

    final void insert0(int index, char[] chars) {
        if (index < 0 || index > this.count) {
            throw this.indexAndLength(index);
        }
        if (chars.length != 0) {
            this.move(chars.length, index);
            System.arraycopy((Object)chars, 0, (Object)this.value, index, chars.length);
            this.count += chars.length;
        }
    }

    final void insert0(int index, char[] chars, int start, int length) {
        if (index >= 0 && index <= this.count && start >= 0 && length >= 0 && length <= chars.length - start) {
            if (length != 0) {
                this.move(length, index);
                System.arraycopy((Object)chars, start, (Object)this.value, index, length);
                this.count += length;
            }
            return;
        }
        throw new StringIndexOutOfBoundsException("this.length=" + this.count + "; index=" + index + "; chars.length=" + chars.length + "; start=" + start + "; length=" + length);
    }

    final void insert0(int index, char ch) {
        if (index < 0 || index > this.count) {
            throw new ArrayIndexOutOfBoundsException(this.count, index);
        }
        this.move(1, index);
        this.value[index] = ch;
        ++this.count;
    }

    final void insert0(int index, String string) {
        if (index >= 0 && index <= this.count) {
            int min;
            if (string == null) {
                string = "null";
            }
            if ((min = string.length()) != 0) {
                this.move(min, index);
                string._getChars(0, min, this.value, index);
                this.count += min;
            }
        } else {
            throw this.indexAndLength(index);
        }
    }

    final void insert0(int index, CharSequence s, int start, int end) {
        if (s == null) {
            s = "null";
        }
        if ((index | start | end) < 0 || index > this.count || start > end || end > s.length()) {
            throw new IndexOutOfBoundsException();
        }
        this.insert0(index, s.subSequence(start, end).toString());
    }

    public int length() {
        return this.count;
    }

    private void move(int size, int index) {
        int newCount;
        if (this.value.length - this.count >= size) {
            if (!this.shared) {
                System.arraycopy((Object)this.value, index, (Object)this.value, index + size, this.count - index);
                return;
            }
            newCount = this.value.length;
        } else {
            newCount = Math.max(this.count + size, this.value.length * 2 + 2);
        }
        char[] newData = new char[newCount];
        System.arraycopy((Object)this.value, 0, (Object)newData, 0, index);
        System.arraycopy((Object)this.value, index, (Object)newData, index + size, this.count - index);
        this.value = newData;
        this.shared = false;
    }

    final void replace0(int start, int end, String string) {
        if (start >= 0) {
            if (end > this.count) {
                end = this.count;
            }
            if (end > start) {
                int stringLength = string.length();
                int diff = end - start - stringLength;
                if (diff > 0) {
                    if (!this.shared) {
                        System.arraycopy((Object)this.value, end, (Object)this.value, start + stringLength, this.count - end);
                    } else {
                        char[] newData = new char[this.value.length];
                        System.arraycopy((Object)this.value, 0, (Object)newData, 0, start);
                        System.arraycopy((Object)this.value, end, (Object)newData, start + stringLength, this.count - end);
                        this.value = newData;
                        this.shared = false;
                    }
                } else if (diff < 0) {
                    this.move(-diff, end);
                } else if (this.shared) {
                    this.value = (char[])this.value.clone();
                    this.shared = false;
                }
                string._getChars(0, stringLength, this.value, start);
                this.count -= diff;
                return;
            }
            if (start == end) {
                if (string == null) {
                    throw new NullPointerException("string == null");
                }
                this.insert0(start, string);
                return;
            }
        }
        throw this.startEndAndLength(start, end);
    }

    final void reverse0() {
        if (this.count < 2) {
            return;
        }
        if (!this.shared) {
            int end = this.count - 1;
            char frontHigh = this.value[0];
            char endLow = this.value[end];
            boolean allowFrontSur = true;
            boolean allowEndSur = true;
            int i = 0;
            int mid = this.count / 2;
            while (i < mid) {
                boolean surAtFront;
                char frontLow = this.value[i + 1];
                char endHigh = this.value[end - 1];
                boolean bl = surAtFront = allowFrontSur && frontLow >= '\udc00' && frontLow <= '\udfff' && frontHigh >= '\ud800' && frontHigh <= '\udbff';
                if (surAtFront && this.count < 3) {
                    return;
                }
                boolean surAtEnd = allowEndSur && endHigh >= '\ud800' && endHigh <= '\udbff' && endLow >= '\udc00' && endLow <= '\udfff';
                allowEndSur = true;
                allowFrontSur = true;
                if (surAtFront == surAtEnd) {
                    if (surAtFront) {
                        this.value[end] = frontLow;
                        this.value[end - 1] = frontHigh;
                        this.value[i] = endHigh;
                        this.value[i + 1] = endLow;
                        frontHigh = this.value[i + 2];
                        endLow = this.value[end - 2];
                        ++i;
                        --end;
                    } else {
                        this.value[end] = frontHigh;
                        this.value[i] = endLow;
                        frontHigh = frontLow;
                        endLow = endHigh;
                    }
                } else if (surAtFront) {
                    this.value[end] = frontLow;
                    this.value[i] = endLow;
                    endLow = endHigh;
                    allowFrontSur = false;
                } else {
                    this.value[end] = frontHigh;
                    this.value[i] = endHigh;
                    frontHigh = frontLow;
                    allowEndSur = false;
                }
                ++i;
                --end;
            }
            if (!((this.count & 1) != 1 || allowFrontSur && allowEndSur)) {
                this.value[end] = allowFrontSur ? endLow : frontHigh;
            }
        } else {
            char[] newData = new char[this.value.length];
            int end = this.count;
            for (int i = 0; i < this.count; ++i) {
                char low;
                char high = this.value[i];
                if (i + 1 < this.count && high >= '\ud800' && high <= '\udbff' && (low = this.value[i + 1]) >= '\udc00' && low <= '\udfff') {
                    newData[--end] = low;
                    ++i;
                }
                newData[--end] = high;
            }
            this.value = newData;
            this.shared = false;
        }
    }

    public void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.count) {
            throw this.indexAndLength(index);
        }
        if (this.shared) {
            this.value = (char[])this.value.clone();
            this.shared = false;
        }
        this.value[index] = ch;
    }

    public void setLength(int length) {
        if (length < 0) {
            throw new StringIndexOutOfBoundsException("length < 0: " + length);
        }
        if (length > this.value.length) {
            this.enlargeBuffer(length);
        } else if (this.shared) {
            char[] newData = new char[this.value.length];
            System.arraycopy((Object)this.value, 0, (Object)newData, 0, this.count);
            this.value = newData;
            this.shared = false;
        } else if (this.count < length) {
            Arrays.fill(this.value, this.count, length, '\u0000');
        }
        this.count = length;
    }

    public String substring(int start) {
        if (start >= 0 && start <= this.count) {
            if (start == this.count) {
                return "";
            }
            return new String(this.value, start, this.count - start);
        }
        throw this.indexAndLength(start);
    }

    public String substring(int start, int end) {
        if (start >= 0 && start <= end && end <= this.count) {
            if (start == end) {
                return "";
            }
            return new String(this.value, start, end - start);
        }
        throw this.startEndAndLength(start, end);
    }

    public String toString() {
        if (this.count == 0) {
            return "";
        }
        int wasted = this.value.length - this.count;
        if (wasted >= 256 || wasted >= 16 && wasted >= this.count >> 1) {
            return new String(this.value, 0, this.count);
        }
        this.shared = true;
        return new String(0, this.count, this.value);
    }

    public CharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String subString, int start) {
        int subCount;
        if (start < 0) {
            start = 0;
        }
        if ((subCount = subString.length()) > 0) {
            if (subCount + start > this.count) {
                return -1;
            }
            char firstChar = subString.charAt(0);
            while (true) {
                int i;
                boolean found = false;
                for (i = start; i < this.count; ++i) {
                    if (this.value[i] != firstChar) continue;
                    found = true;
                    break;
                }
                if (!found || subCount + i > this.count) {
                    return -1;
                }
                int o1 = i;
                int o2 = 0;
                while (++o2 < subCount && this.value[++o1] == subString.charAt(o2)) {
                }
                if (o2 == subCount) {
                    return i;
                }
                start = i + 1;
            }
        }
        return start < this.count || start == 0 ? start : this.count;
    }

    public int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.count);
    }

    public int lastIndexOf(String subString, int start) {
        int subCount = subString.length();
        if (subCount <= this.count && start >= 0) {
            if (subCount > 0) {
                if (start > this.count - subCount) {
                    start = this.count - subCount;
                }
                char firstChar = subString.charAt(0);
                while (true) {
                    int i;
                    boolean found = false;
                    for (i = start; i >= 0; --i) {
                        if (this.value[i] != firstChar) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        return -1;
                    }
                    int o1 = i;
                    int o2 = 0;
                    while (++o2 < subCount && this.value[++o1] == subString.charAt(o2)) {
                    }
                    if (o2 == subCount) {
                        return i;
                    }
                    start = i - 1;
                }
            }
            return start < this.count ? start : this.count;
        }
        return -1;
    }

    public void trimToSize() {
        if (this.count < this.value.length) {
            char[] newValue = new char[this.count];
            System.arraycopy((Object)this.value, 0, (Object)newValue, 0, this.count);
            this.value = newValue;
            this.shared = false;
        }
    }

    public int codePointAt(int index) {
        if (index < 0 || index >= this.count) {
            throw this.indexAndLength(index);
        }
        return Character.codePointAt(this.value, index, this.count);
    }

    public int codePointBefore(int index) {
        if (index < 1 || index > this.count) {
            throw this.indexAndLength(index);
        }
        return Character.codePointBefore(this.value, index);
    }

    public int codePointCount(int start, int end) {
        if (start < 0 || end > this.count || start > end) {
            throw this.startEndAndLength(start, end);
        }
        return Character.codePointCount(this.value, start, end - start);
    }

    public int offsetByCodePoints(int index, int codePointOffset) {
        return Character.offsetByCodePoints(this.value, 0, this.count, index, codePointOffset);
    }
}

