/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import libcore.util.Objects;

public class PropertyChangeSupport
implements Serializable {
    private static final long serialVersionUID = 6401253773779951803L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("source", Object.class), new ObjectStreamField("children", Object.class), new ObjectStreamField("propertyChangeSupportSerializedDataVersion", Integer.TYPE)};
    private transient Object sourceBean;
    private transient List<PropertyChangeListener> listeners = new CopyOnWriteArrayList<PropertyChangeListener>();

    public PropertyChangeSupport(Object sourceBean) {
        if (sourceBean == null) {
            throw new NullPointerException("sourceBean == null");
        }
        this.sourceBean = sourceBean;
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.firePropertyChange(new PropertyChangeEvent(this.sourceBean, propertyName, oldValue, newValue));
    }

    public void fireIndexedPropertyChange(String propertyName, int index, Object oldValue, Object newValue) {
        this.firePropertyChange(new IndexedPropertyChangeEvent(this.sourceBean, propertyName, oldValue, newValue, index));
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        for (PropertyChangeListener p : this.listeners) {
            if (!this.equals(propertyName, listener, p)) continue;
            this.listeners.remove(p);
            return;
        }
    }

    private boolean equals(String aName, EventListener a, EventListener b) {
        while (b instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy bProxy = (PropertyChangeListenerProxy)b;
            String bName = bProxy.getPropertyName();
            b = bProxy.getListener();
            if (aName == null) {
                if (!(a instanceof PropertyChangeListenerProxy)) {
                    return false;
                }
                PropertyChangeListenerProxy aProxy = (PropertyChangeListenerProxy)a;
                aName = aProxy.getPropertyName();
                a = aProxy.getListener();
            }
            if (!Objects.equal(aName, bName)) {
                return false;
            }
            aName = null;
        }
        return aName == null && Objects.equal(a, b);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener != null && propertyName != null) {
            this.listeners.add(new PropertyChangeListenerProxy(propertyName, listener));
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        ArrayList<PropertyChangeListener> result = new ArrayList<PropertyChangeListener>();
        for (PropertyChangeListener p : this.listeners) {
            if (!(p instanceof PropertyChangeListenerProxy) || !Objects.equal(propertyName, ((PropertyChangeListenerProxy)p).getPropertyName())) continue;
            result.add(p);
        }
        return result.toArray(new PropertyChangeListener[result.size()]);
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.firePropertyChange(propertyName, (Object)oldValue, (Object)newValue);
    }

    public void fireIndexedPropertyChange(String propertyName, int index, boolean oldValue, boolean newValue) {
        if (oldValue != newValue) {
            this.fireIndexedPropertyChange(propertyName, index, (Object)oldValue, (Object)newValue);
        }
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.firePropertyChange(propertyName, (Object)oldValue, (Object)newValue);
    }

    public void fireIndexedPropertyChange(String propertyName, int index, int oldValue, int newValue) {
        if (oldValue != newValue) {
            this.fireIndexedPropertyChange(propertyName, index, (Object)oldValue, (Object)newValue);
        }
    }

    public boolean hasListeners(String propertyName) {
        for (PropertyChangeListener p : this.listeners) {
            if (p instanceof PropertyChangeListenerProxy && !Objects.equal(propertyName, ((PropertyChangeListenerProxy)p).getPropertyName())) continue;
            return true;
        }
        return false;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        for (PropertyChangeListener p : this.listeners) {
            if (!this.equals(null, listener, p)) continue;
            this.listeners.remove(p);
            return;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.listeners.toArray(new PropertyChangeListener[0]);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Hashtable<String, PropertyChangeSupport> map = new Hashtable<String, PropertyChangeSupport>();
        for (PropertyChangeListener p : this.listeners) {
            PropertyChangeListenerProxy proxy;
            PropertyChangeListener listener;
            if (!(p instanceof PropertyChangeListenerProxy) || p instanceof Serializable || !((listener = (PropertyChangeListener)(proxy = (PropertyChangeListenerProxy)p).getListener()) instanceof Serializable)) continue;
            PropertyChangeSupport list = (PropertyChangeSupport)map.get(proxy.getPropertyName());
            if (list == null) {
                list = new PropertyChangeSupport(this.sourceBean);
                map.put(proxy.getPropertyName(), list);
            }
            list.listeners.add(listener);
        }
        ObjectOutputStream.PutField putFields = out.putFields();
        putFields.put("source", this.sourceBean);
        putFields.put("children", map);
        out.writeFields();
        for (PropertyChangeListener p : this.listeners) {
            if (!(p instanceof Serializable)) continue;
            out.writeObject(p);
        }
        out.writeObject(null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        PropertyChangeListener listener;
        ObjectInputStream.GetField readFields = in.readFields();
        this.sourceBean = readFields.get("source", null);
        this.listeners = new CopyOnWriteArrayList<PropertyChangeListener>();
        Map children = (Map)readFields.get("children", null);
        if (children != null) {
            for (Map.Entry entry : children.entrySet()) {
                for (PropertyChangeListener p : ((PropertyChangeSupport)entry.getValue()).listeners) {
                    this.listeners.add(new PropertyChangeListenerProxy((String)entry.getKey(), p));
                }
            }
        }
        while ((listener = (PropertyChangeListener)in.readObject()) != null) {
            this.listeners.add(listener);
        }
    }

    public void firePropertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        Object oldValue = event.getOldValue();
        Object newValue = event.getNewValue();
        if (newValue != null && oldValue != null && newValue.equals(oldValue)) {
            return;
        }
        block0: for (PropertyChangeListener p : this.listeners) {
            while (p instanceof PropertyChangeListenerProxy) {
                PropertyChangeListenerProxy proxy = (PropertyChangeListenerProxy)p;
                if (!Objects.equal(proxy.getPropertyName(), propertyName)) continue block0;
                p = (PropertyChangeListener)proxy.getListener();
            }
            p.propertyChange(event);
        }
    }
}

