/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.CertPinManager;
import com.android.org.conscrypt.ChainStrengthAnalyzer;
import com.android.org.conscrypt.PinManagerException;
import com.android.org.conscrypt.TrustedCertificateIndex;
import com.android.org.conscrypt.TrustedCertificateStore;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.X509TrustManager;

public final class TrustManagerImpl
implements X509TrustManager {
    private final KeyStore rootKeyStore;
    private CertPinManager pinManager;
    private final TrustedCertificateStore trustedCertificateStore;
    private final CertPathValidator validator;
    private final TrustedCertificateIndex trustedCertificateIndex;
    private final X509Certificate[] acceptedIssuers;
    private final Exception err;
    private final CertificateFactory factory;

    public TrustManagerImpl(KeyStore keyStore) {
        this(keyStore, null);
    }

    public TrustManagerImpl(KeyStore keyStore, CertPinManager manager) {
        CertPathValidator validatorLocal = null;
        CertificateFactory factoryLocal = null;
        KeyStore rootKeyStoreLocal = null;
        TrustedCertificateStore trustedCertificateStoreLocal = null;
        TrustedCertificateIndex trustedCertificateIndexLocal = null;
        X509Certificate[] acceptedIssuersLocal = null;
        Exception errLocal = null;
        try {
            validatorLocal = CertPathValidator.getInstance("PKIX");
            factoryLocal = CertificateFactory.getInstance("X509");
            if ("AndroidCAStore".equals(keyStore.getType())) {
                rootKeyStoreLocal = keyStore;
                trustedCertificateStoreLocal = new TrustedCertificateStore();
                acceptedIssuersLocal = null;
                trustedCertificateIndexLocal = new TrustedCertificateIndex();
            } else {
                rootKeyStoreLocal = null;
                trustedCertificateStoreLocal = null;
                acceptedIssuersLocal = TrustManagerImpl.acceptedIssuers(keyStore);
                trustedCertificateIndexLocal = new TrustedCertificateIndex(TrustManagerImpl.trustAnchors(acceptedIssuersLocal));
            }
        }
        catch (Exception e) {
            errLocal = e;
        }
        if (manager != null) {
            this.pinManager = manager;
        } else {
            try {
                this.pinManager = new CertPinManager(trustedCertificateStoreLocal);
            }
            catch (PinManagerException e) {
                throw new SecurityException("Could not initialize CertPinManager", e);
            }
        }
        this.rootKeyStore = rootKeyStoreLocal;
        this.trustedCertificateStore = trustedCertificateStoreLocal;
        this.validator = validatorLocal;
        this.factory = factoryLocal;
        this.trustedCertificateIndex = trustedCertificateIndexLocal;
        this.acceptedIssuers = acceptedIssuersLocal;
        this.err = errLocal;
    }

    private static X509Certificate[] acceptedIssuers(KeyStore ks) {
        try {
            ArrayList<X509Certificate> trusted = new ArrayList<X509Certificate>();
            Enumeration<String> en = ks.aliases();
            while (en.hasMoreElements()) {
                String alias = en.nextElement();
                X509Certificate cert = (X509Certificate)ks.getCertificate(alias);
                if (cert == null) continue;
                trusted.add(cert);
            }
            return trusted.toArray(new X509Certificate[trusted.size()]);
        }
        catch (KeyStoreException e) {
            return new X509Certificate[0];
        }
    }

    private static Set<TrustAnchor> trustAnchors(X509Certificate[] certs) {
        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>(certs.length);
        for (X509Certificate cert : certs) {
            trustAnchors.add(new TrustAnchor(cert, null));
        }
        return trustAnchors;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkTrusted(chain, authType, null, true);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkTrusted(chain, authType, null, false);
    }

    public List<X509Certificate> checkServerTrusted(X509Certificate[] chain, String authType, String host) throws CertificateException {
        return this.checkTrusted(chain, authType, host, false);
    }

    public void handleTrustStorageUpdate() {
        if (this.acceptedIssuers == null) {
            this.trustedCertificateIndex.reset();
        } else {
            this.trustedCertificateIndex.reset(TrustManagerImpl.trustAnchors(this.acceptedIssuers));
        }
    }

    private List<X509Certificate> checkTrusted(X509Certificate[] chain, String authType, String host, boolean clientAuth) throws CertificateException {
        X509Certificate next;
        TrustAnchor cachedTrust;
        if (chain == null || chain.length == 0 || authType == null || authType.length() == 0) {
            throw new IllegalArgumentException("null or zero-length parameter");
        }
        if (this.err != null) {
            throw new CertificateException(this.err);
        }
        HashSet<TrustAnchor> trustAnchor = new HashSet<TrustAnchor>();
        X509Certificate[] newChain = this.cleanupCertChainAndFindTrustAnchors(chain, trustAnchor);
        ArrayList<X509Certificate> wholeChain = new ArrayList<X509Certificate>();
        wholeChain.addAll(Arrays.asList(newChain));
        for (TrustAnchor trust : trustAnchor) {
            wholeChain.add(trust.getTrustedCert());
        }
        X509Certificate last = (X509Certificate)wholeChain.get(wholeChain.size() - 1);
        while ((cachedTrust = this.trustedCertificateIndex.findByIssuerAndSignature(last)) != null && (next = cachedTrust.getTrustedCert()) != last) {
            wholeChain.add(next);
            last = next;
        }
        CertPath certPath = this.factory.generateCertPath(Arrays.asList(newChain));
        if (host != null) {
            boolean chainIsNotPinned = true;
            try {
                chainIsNotPinned = this.pinManager.chainIsNotPinned(host, wholeChain);
            }
            catch (PinManagerException e) {
                throw new CertificateException(e);
            }
            if (chainIsNotPinned) {
                throw new CertificateException(new CertPathValidatorException("Certificate path is not properly pinned.", null, certPath, -1));
            }
        }
        if (newChain.length == 0) {
            return wholeChain;
        }
        if (trustAnchor.isEmpty()) {
            throw new CertificateException(new CertPathValidatorException("Trust anchor for certification path not found.", null, certPath, -1));
        }
        ChainStrengthAnalyzer.check(newChain);
        try {
            PKIXParameters params = new PKIXParameters(trustAnchor);
            params.setRevocationEnabled(false);
            params.addCertPathChecker(new ExtendedKeyUsagePKIXCertPathChecker(clientAuth, newChain[0]));
            this.validator.validate(certPath, params);
            for (int i = 1; i < newChain.length; ++i) {
                this.trustedCertificateIndex.index(newChain[i]);
            }
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CertificateException(e);
        }
        catch (CertPathValidatorException e) {
            throw new CertificateException(e);
        }
        return wholeChain;
    }

    private X509Certificate[] cleanupCertChainAndFindTrustAnchors(X509Certificate[] chain, Set<TrustAnchor> trustAnchors) {
        TrustAnchor trustAnchor;
        int chainLength;
        X509Certificate[] newChain;
        int anchorIndex;
        int currIndex;
        X509Certificate[] original = chain;
        for (currIndex = 0; currIndex < chain.length; ++currIndex) {
            boolean foundNext = false;
            for (int nextIndex = currIndex + 1; nextIndex < chain.length; ++nextIndex) {
                if (!chain[currIndex].getIssuerDN().equals(chain[nextIndex].getSubjectDN())) continue;
                foundNext = true;
                if (nextIndex == currIndex + 1) break;
                if (chain == original) {
                    chain = (X509Certificate[])original.clone();
                }
                X509Certificate tempCertificate = chain[nextIndex];
                chain[nextIndex] = chain[currIndex + 1];
                chain[currIndex + 1] = tempCertificate;
                break;
            }
            if (!foundNext) break;
        }
        for (anchorIndex = 0; anchorIndex <= currIndex; ++anchorIndex) {
            TrustAnchor trustAnchor2 = this.findTrustAnchorBySubjectAndPublicKey(chain[anchorIndex]);
            if (trustAnchor2 == null) continue;
            trustAnchors.add(trustAnchor2);
            break;
        }
        X509Certificate[] x509CertificateArray = newChain = (chainLength = anchorIndex) == chain.length ? chain : Arrays.copyOf(chain, chainLength);
        if (trustAnchors.isEmpty() && (trustAnchor = this.findTrustAnchorByIssuerAndSignature(newChain[anchorIndex - 1])) != null) {
            trustAnchors.add(trustAnchor);
        }
        return newChain;
    }

    private TrustAnchor findTrustAnchorByIssuerAndSignature(X509Certificate lastCert) {
        TrustAnchor trustAnchor = this.trustedCertificateIndex.findByIssuerAndSignature(lastCert);
        if (trustAnchor != null) {
            return trustAnchor;
        }
        if (this.trustedCertificateStore == null) {
            return null;
        }
        X509Certificate issuer = this.trustedCertificateStore.findIssuer(lastCert);
        if (issuer != null) {
            return this.trustedCertificateIndex.index(issuer);
        }
        return null;
    }

    private TrustAnchor findTrustAnchorBySubjectAndPublicKey(X509Certificate cert) {
        TrustAnchor trustAnchor = this.trustedCertificateIndex.findBySubjectAndPublicKey(cert);
        if (trustAnchor != null) {
            return trustAnchor;
        }
        if (this.trustedCertificateStore == null) {
            return null;
        }
        if (this.trustedCertificateStore.isTrustAnchor(cert)) {
            return this.trustedCertificateIndex.index(cert);
        }
        return null;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.acceptedIssuers != null ? (X509Certificate[])this.acceptedIssuers.clone() : TrustManagerImpl.acceptedIssuers(this.rootKeyStore);
    }

    private static class ExtendedKeyUsagePKIXCertPathChecker
    extends PKIXCertPathChecker {
        private static final String EKU_OID = "2.5.29.37";
        private static final String EKU_anyExtendedKeyUsage = "2.5.29.37.0";
        private static final String EKU_clientAuth = "1.3.6.1.5.5.7.3.2";
        private static final String EKU_serverAuth = "1.3.6.1.5.5.7.3.1";
        private static final String EKU_nsSGC = "2.16.840.1.113730.4.1";
        private static final String EKU_msSGC = "1.3.6.1.4.1.311.10.3.3";
        private static final Set<String> SUPPORTED_EXTENSIONS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("2.5.29.37")));
        private final boolean clientAuth;
        private final X509Certificate leaf;

        private ExtendedKeyUsagePKIXCertPathChecker(boolean clientAuth, X509Certificate leaf) {
            this.clientAuth = clientAuth;
            this.leaf = leaf;
        }

        @Override
        public void init(boolean forward) throws CertPathValidatorException {
        }

        @Override
        public boolean isForwardCheckingSupported() {
            return true;
        }

        @Override
        public Set<String> getSupportedExtensions() {
            return SUPPORTED_EXTENSIONS;
        }

        @Override
        public void check(Certificate c, Collection<String> unresolvedCritExts) throws CertPathValidatorException {
            List<String> ekuOids;
            if (c != this.leaf) {
                return;
            }
            try {
                ekuOids = this.leaf.getExtendedKeyUsage();
            }
            catch (CertificateParsingException e) {
                throw new CertPathValidatorException(e);
            }
            if (ekuOids == null) {
                return;
            }
            boolean goodExtendedKeyUsage = false;
            for (String ekuOid : ekuOids) {
                if (ekuOid.equals(EKU_anyExtendedKeyUsage)) {
                    goodExtendedKeyUsage = true;
                    break;
                }
                if (this.clientAuth) {
                    if (!ekuOid.equals(EKU_clientAuth)) continue;
                    goodExtendedKeyUsage = true;
                    break;
                }
                if (ekuOid.equals(EKU_serverAuth)) {
                    goodExtendedKeyUsage = true;
                    break;
                }
                if (ekuOid.equals(EKU_nsSGC)) {
                    goodExtendedKeyUsage = true;
                    break;
                }
                if (!ekuOid.equals(EKU_msSGC)) continue;
                goodExtendedKeyUsage = true;
                break;
            }
            if (!goodExtendedKeyUsage) {
                throw new CertPathValidatorException("End-entity certificate does not have a valid extendedKeyUsage.");
            }
            unresolvedCritExts.remove(EKU_OID);
        }
    }
}

