/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.AbstractSessionContext;
import com.android.org.conscrypt.NativeCrypto;
import com.android.org.conscrypt.SSLServerSessionCache;
import javax.net.ssl.SSLSession;

public class ServerSessionContext
extends AbstractSessionContext {
    private SSLServerSessionCache persistentCache;

    public ServerSessionContext() {
        super(100, 0);
        NativeCrypto.SSL_CTX_set_session_id_context(this.sslCtxNativePointer, new byte[]{32});
    }

    public void setPersistentCache(SSLServerSessionCache persistentCache) {
        this.persistentCache = persistentCache;
    }

    @Override
    protected void sessionRemoved(SSLSession session) {
    }

    @Override
    public SSLSession getSession(byte[] sessionId) {
        byte[] data;
        SSLSession session = super.getSession(sessionId);
        if (session != null) {
            return session;
        }
        if (this.persistentCache != null && (data = this.persistentCache.getSessionData(sessionId)) != null && (session = this.toSession(data, null, -1)) != null && session.isValid()) {
            super.putSession(session);
            return session;
        }
        return null;
    }

    @Override
    void putSession(SSLSession session) {
        byte[] data;
        super.putSession(session);
        if (this.persistentCache != null && (data = this.toBytes(session)) != null) {
            this.persistentCache.putSessionData(session, data);
        }
    }
}

