/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.bouncycastle.jcajce.provider.symmetric.util;

import com.android.org.bouncycastle.crypto.CipherParameters;
import com.android.org.bouncycastle.crypto.PBEParametersGenerator;
import com.android.org.bouncycastle.crypto.digests.AndroidDigestFactory;
import com.android.org.bouncycastle.crypto.generators.OpenSSLPBEParametersGenerator;
import com.android.org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import com.android.org.bouncycastle.crypto.generators.PKCS5S1ParametersGenerator;
import com.android.org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import com.android.org.bouncycastle.crypto.params.DESParameters;
import com.android.org.bouncycastle.crypto.params.KeyParameter;
import com.android.org.bouncycastle.crypto.params.ParametersWithIV;
import com.android.org.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public interface PBE {
    public static final int MD5 = 0;
    public static final int SHA1 = 1;
    public static final int SHA256 = 4;
    public static final int PKCS5S1 = 0;
    public static final int PKCS5S2 = 1;
    public static final int PKCS12 = 2;
    public static final int OPENSSL = 3;
    public static final int PKCS5S1_UTF8 = 4;
    public static final int PKCS5S2_UTF8 = 5;

    public static class Util {
        private static PBEParametersGenerator makePBEGenerator(int type, int hash) {
            PBEParametersGenerator generator;
            block10: {
                block12: {
                    block11: {
                        block9: {
                            if (type != 0 && type != 4) break block9;
                            switch (hash) {
                                case 0: {
                                    generator = new PKCS5S1ParametersGenerator(AndroidDigestFactory.getMD5());
                                    break block10;
                                }
                                case 1: {
                                    generator = new PKCS5S1ParametersGenerator(AndroidDigestFactory.getSHA1());
                                    break block10;
                                }
                                default: {
                                    throw new IllegalStateException("PKCS5 scheme 1 only supports MD2, MD5 and SHA1.");
                                }
                            }
                        }
                        if (type != 1 && type != 5) break block11;
                        generator = new PKCS5S2ParametersGenerator();
                        break block10;
                    }
                    if (type != 2) break block12;
                    switch (hash) {
                        case 0: {
                            generator = new PKCS12ParametersGenerator(AndroidDigestFactory.getMD5());
                            break block10;
                        }
                        case 1: {
                            generator = new PKCS12ParametersGenerator(AndroidDigestFactory.getSHA1());
                            break block10;
                        }
                        case 4: {
                            generator = new PKCS12ParametersGenerator(AndroidDigestFactory.getSHA256());
                            break block10;
                        }
                        default: {
                            throw new IllegalStateException("unknown digest scheme for PBE encryption.");
                        }
                    }
                }
                generator = new OpenSSLPBEParametersGenerator();
            }
            return generator;
        }

        public static CipherParameters makePBEParameters(BCPBEKey pbeKey, AlgorithmParameterSpec spec, String targetAlgorithm) {
            if (spec == null || !(spec instanceof PBEParameterSpec)) {
                throw new IllegalArgumentException("Need a PBEParameter spec with a PBE key.");
            }
            PBEParameterSpec pbeParam = (PBEParameterSpec)spec;
            PBEParametersGenerator generator = Util.makePBEGenerator(pbeKey.getType(), pbeKey.getDigest());
            byte[] key = pbeKey.getEncoded();
            if (pbeKey.shouldTryWrongPKCS12()) {
                key = new byte[2];
            }
            generator.init(key, pbeParam.getSalt(), pbeParam.getIterationCount());
            CipherParameters param = pbeKey.getIvSize() != 0 ? generator.generateDerivedParameters(pbeKey.getKeySize(), pbeKey.getIvSize()) : generator.generateDerivedParameters(pbeKey.getKeySize());
            if (targetAlgorithm.startsWith("DES")) {
                KeyParameter kParam;
                if (param instanceof ParametersWithIV) {
                    kParam = (KeyParameter)((ParametersWithIV)param).getParameters();
                    DESParameters.setOddParity(kParam.getKey());
                } else {
                    kParam = (KeyParameter)param;
                    DESParameters.setOddParity(kParam.getKey());
                }
            }
            for (int i = 0; i != key.length; ++i) {
                key[i] = 0;
            }
            return param;
        }

        public static CipherParameters makePBEMacParameters(BCPBEKey pbeKey, AlgorithmParameterSpec spec) {
            if (spec == null || !(spec instanceof PBEParameterSpec)) {
                throw new IllegalArgumentException("Need a PBEParameter spec with a PBE key.");
            }
            PBEParameterSpec pbeParam = (PBEParameterSpec)spec;
            PBEParametersGenerator generator = Util.makePBEGenerator(pbeKey.getType(), pbeKey.getDigest());
            byte[] key = pbeKey.getEncoded();
            if (pbeKey.shouldTryWrongPKCS12()) {
                key = new byte[2];
            }
            generator.init(key, pbeParam.getSalt(), pbeParam.getIterationCount());
            CipherParameters param = generator.generateDerivedMacParameters(pbeKey.getKeySize());
            for (int i = 0; i != key.length; ++i) {
                key[i] = 0;
            }
            return param;
        }

        public static CipherParameters makePBEParameters(PBEKeySpec keySpec, int type, int hash, int keySize, int ivSize) {
            PBEParametersGenerator generator = Util.makePBEGenerator(type, hash);
            byte[] key = Util.convertPassword(type, keySpec);
            generator.init(key, keySpec.getSalt(), keySpec.getIterationCount());
            CipherParameters param = ivSize != 0 ? generator.generateDerivedParameters(keySize, ivSize) : generator.generateDerivedParameters(keySize);
            for (int i = 0; i != key.length; ++i) {
                key[i] = 0;
            }
            return param;
        }

        public static CipherParameters makePBEMacParameters(PBEKeySpec keySpec, int type, int hash, int keySize) {
            PBEParametersGenerator generator = Util.makePBEGenerator(type, hash);
            byte[] key = Util.convertPassword(type, keySpec);
            generator.init(key, keySpec.getSalt(), keySpec.getIterationCount());
            CipherParameters param = generator.generateDerivedMacParameters(keySize);
            for (int i = 0; i != key.length; ++i) {
                key[i] = 0;
            }
            return param;
        }

        private static byte[] convertPassword(int type, PBEKeySpec keySpec) {
            byte[] key = type == 2 ? PBEParametersGenerator.PKCS12PasswordToBytes(keySpec.getPassword()) : (type == 5 || type == 4 ? PBEParametersGenerator.PKCS5PasswordToUTF8Bytes(keySpec.getPassword()) : PBEParametersGenerator.PKCS5PasswordToBytes(keySpec.getPassword()));
            return key;
        }
    }
}

