/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.bouncycastle.crypto.engines;

import com.android.org.bouncycastle.crypto.CipherParameters;
import com.android.org.bouncycastle.crypto.DataLengthException;
import com.android.org.bouncycastle.crypto.OutputLengthException;
import com.android.org.bouncycastle.crypto.engines.DESEngine;
import com.android.org.bouncycastle.crypto.params.KeyParameter;

public class DESedeEngine
extends DESEngine {
    protected static final int BLOCK_SIZE = 8;
    private int[] workingKey1 = null;
    private int[] workingKey2 = null;
    private int[] workingKey3 = null;
    private boolean forEncryption;

    @Override
    public void init(boolean encrypting, CipherParameters params) {
        if (!(params instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameter passed to DESede init - " + params.getClass().getName());
        }
        byte[] keyMaster = ((KeyParameter)params).getKey();
        if (keyMaster.length != 24 && keyMaster.length != 16) {
            throw new IllegalArgumentException("key size must be 16 or 24 bytes.");
        }
        this.forEncryption = encrypting;
        byte[] key1 = new byte[8];
        System.arraycopy((Object)keyMaster, 0, (Object)key1, 0, key1.length);
        this.workingKey1 = this.generateWorkingKey(encrypting, key1);
        byte[] key2 = new byte[8];
        System.arraycopy((Object)keyMaster, 8, (Object)key2, 0, key2.length);
        this.workingKey2 = this.generateWorkingKey(!encrypting, key2);
        if (keyMaster.length == 24) {
            byte[] key3 = new byte[8];
            System.arraycopy((Object)keyMaster, 16, (Object)key3, 0, key3.length);
            this.workingKey3 = this.generateWorkingKey(encrypting, key3);
        } else {
            this.workingKey3 = this.workingKey1;
        }
    }

    @Override
    public String getAlgorithmName() {
        return "DESede";
    }

    @Override
    public int getBlockSize() {
        return 8;
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) {
        if (this.workingKey1 == null) {
            throw new IllegalStateException("DESede engine not initialised");
        }
        if (inOff + 8 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + 8 > out.length) {
            throw new OutputLengthException("output buffer too short");
        }
        byte[] temp = new byte[8];
        if (this.forEncryption) {
            this.desFunc(this.workingKey1, in, inOff, temp, 0);
            this.desFunc(this.workingKey2, temp, 0, temp, 0);
            this.desFunc(this.workingKey3, temp, 0, out, outOff);
        } else {
            this.desFunc(this.workingKey3, in, inOff, temp, 0);
            this.desFunc(this.workingKey2, temp, 0, temp, 0);
            this.desFunc(this.workingKey1, temp, 0, out, outOff);
        }
        return 8;
    }

    @Override
    public void reset() {
    }
}

