/*
 * Decompiled with CFR 0.152.
 */
package com.android.okhttp;

import com.android.okhttp.OkAuthenticator;
import com.android.okhttp.internal.Util;
import java.net.Proxy;
import java.net.UnknownHostException;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public final class Address {
    final Proxy proxy;
    final String uriHost;
    final int uriPort;
    final SSLSocketFactory sslSocketFactory;
    final HostnameVerifier hostnameVerifier;
    final OkAuthenticator authenticator;
    final List<String> transports;

    public Address(String uriHost, int uriPort, SSLSocketFactory sslSocketFactory, HostnameVerifier hostnameVerifier, OkAuthenticator authenticator, Proxy proxy, List<String> transports) throws UnknownHostException {
        if (uriHost == null) {
            throw new NullPointerException("uriHost == null");
        }
        if (uriPort <= 0) {
            throw new IllegalArgumentException("uriPort <= 0: " + uriPort);
        }
        if (authenticator == null) {
            throw new IllegalArgumentException("authenticator == null");
        }
        if (transports == null) {
            throw new IllegalArgumentException("transports == null");
        }
        this.proxy = proxy;
        this.uriHost = uriHost;
        this.uriPort = uriPort;
        this.sslSocketFactory = sslSocketFactory;
        this.hostnameVerifier = hostnameVerifier;
        this.authenticator = authenticator;
        this.transports = Util.immutableList(transports);
    }

    public String getUriHost() {
        return this.uriHost;
    }

    public int getUriPort() {
        return this.uriPort;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public OkAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public List<String> getTransports() {
        return this.transports;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public boolean equals(Object other) {
        if (other instanceof Address) {
            Address that = (Address)other;
            return Util.equal(this.proxy, that.proxy) && this.uriHost.equals(that.uriHost) && this.uriPort == that.uriPort && Util.equal(this.sslSocketFactory, that.sslSocketFactory) && Util.equal(this.hostnameVerifier, that.hostnameVerifier) && Util.equal(this.authenticator, that.authenticator) && Util.equal(this.transports, that.transports);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.uriHost.hashCode();
        result = 31 * result + this.uriPort;
        result = 31 * result + (this.sslSocketFactory != null ? this.sslSocketFactory.hashCode() : 0);
        result = 31 * result + (this.hostnameVerifier != null ? this.hostnameVerifier.hashCode() : 0);
        result = 31 * result + (this.authenticator != null ? this.authenticator.hashCode() : 0);
        result = 31 * result + (this.proxy != null ? this.proxy.hashCode() : 0);
        result = 31 * result + this.transports.hashCode();
        return result;
    }
}

