/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.llvm;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.robovm.llvm.LineInfo;
import org.robovm.llvm.LlvmException;
import org.robovm.llvm.SectionIterator;
import org.robovm.llvm.Symbol;
import org.robovm.llvm.binding.IntOut;
import org.robovm.llvm.binding.LLVM;
import org.robovm.llvm.binding.LongArray;
import org.robovm.llvm.binding.LongArrayOut;
import org.robovm.llvm.binding.MemoryBufferRefOut;
import org.robovm.llvm.binding.ObjectFileRef;
import org.robovm.llvm.binding.StringOut;
import org.robovm.llvm.binding.SymbolIteratorRef;
import org.robovm.llvm.debuginfo.DwarfDebugMethodInfo;
import org.robovm.llvm.debuginfo.DwarfDebugObjectFileInfo;
import org.robovm.llvm.debuginfo.DwarfDebugVariableInfo;

public class ObjectFile
implements AutoCloseable {
    private final File file;
    private ObjectFileRef ref;

    private ObjectFile(File file, ObjectFileRef objectFileRef) {
        this.file = file;
        this.ref = objectFileRef;
    }

    protected final void checkDisposed() {
        if (this.ref == null) {
            throw new LlvmException("Already disposed");
        }
    }

    protected ObjectFileRef getRef() {
        this.checkDisposed();
        return this.ref;
    }

    public List<Symbol> getSymbols() {
        ArrayList<Symbol> result = new ArrayList<Symbol>();
        SymbolIteratorRef it = LLVM.GetSymbols(this.getRef());
        while (!LLVM.IsSymbolIteratorAtEnd(this.getRef(), it)) {
            String name = LLVM.GetSymbolName(it);
            long address = LLVM.GetSymbolAddress(it);
            long size = LLVM.GetSymbolSize(it);
            result.add(new Symbol(name, address, size));
            LLVM.MoveToNextSymbol(it);
        }
        LLVM.DisposeSymbolIterator(it);
        return result;
    }

    public SectionIterator getSectionIterator() {
        return new SectionIterator(this, LLVM.GetSections(this.getRef()));
    }

    public List<LineInfo> getLineInfos(Symbol symbol) {
        ArrayList<LineInfo> result = new ArrayList<LineInfo>();
        IntOut sizeOut = new IntOut();
        LongArrayOut out = new LongArrayOut();
        LLVM.GetLineInfoForAddressRange(this.getRef(), symbol.getAddress(), symbol.getSize(), sizeOut, out);
        int size = sizeOut.getValue();
        if (size > 0) {
            LongArray values = out.getValue();
            for (int i = 0; i < size; ++i) {
                long address = values.get(i * 3);
                long lineNumber = values.get(i * 3 + 1);
                long columnNumber = values.get(i * 3 + 2);
                result.add(new LineInfo(address, (int)lineNumber, (int)columnNumber));
            }
            values.delete();
        }
        out.delete();
        return result;
    }

    public DwarfDebugObjectFileInfo getDebugInfo() {
        int strLen;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        LLVM.DumpDwarfDebugData(this.getRef(), os);
        if (os.size() == 0) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(os.toByteArray(), 0, os.size());
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        ArrayList<DwarfDebugMethodInfo> methods = new ArrayList<DwarfDebugMethodInfo>();
        while (buffer.hasRemaining() && (strLen = buffer.getInt()) != 0) {
            String methodName = null;
            try {
                methodName = new String(buffer.array(), buffer.position(), strLen, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            buffer.position(buffer.position() + strLen);
            if (methodName == null) break;
            ArrayList<DwarfDebugVariableInfo> variables = new ArrayList<DwarfDebugVariableInfo>();
            while (buffer.hasRemaining() && (strLen = buffer.getInt()) != 0) {
                String variableName = null;
                try {
                    variableName = new String(buffer.array(), buffer.position(), strLen, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                buffer.position(buffer.position() + strLen);
                if (variableName == null) break;
                byte flags = buffer.get();
                int reg = 256 + buffer.get() & 0xFF;
                int offset = buffer.getInt();
                variables.add(new DwarfDebugVariableInfo(variableName, (flags & 1) == 1, reg, offset));
            }
            methods.add(new DwarfDebugMethodInfo(methodName, variables.toArray(new DwarfDebugVariableInfo[0])));
        }
        return new DwarfDebugObjectFileInfo(null, methods.toArray(new DwarfDebugMethodInfo[0]));
    }

    public synchronized void dispose() {
        LLVM.DisposeObjectFile(this.getRef());
        this.ref = null;
    }

    @Override
    public void close() {
        this.dispose();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + (this.ref == null ? 0 : this.ref.hashCode());
        return result;
    }

    public String toString() {
        return "ObjectFile [file=" + this.file + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectFile other = (ObjectFile)obj;
        if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
            return false;
        }
        return !(this.ref == null ? other.ref != null : !this.ref.equals(other.ref));
    }

    public static ObjectFile load(File file) {
        MemoryBufferRefOut memBufOut = new MemoryBufferRefOut();
        StringOut errorMsgOut = new StringOut();
        LLVM.CreateMemoryBufferWithContentsOfFile(file.getAbsolutePath(), memBufOut, errorMsgOut);
        if (memBufOut.getValue() == null) {
            throw new LlvmException("Failed to create memory buffer from " + file.getAbsolutePath() + (String)(errorMsgOut.getValue() != null ? ":" + errorMsgOut.getValue() : ""));
        }
        ObjectFileRef ref = LLVM.CreateObjectFile(memBufOut.getValue());
        if (ref == null) {
            throw new LlvmException("Failed to create memory buffer from " + file.getAbsolutePath());
        }
        return new ObjectFile(file, ref);
    }
}

