/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.Iterator;
import java.util.List;
import soot.Unit;
import soot.jimple.Stmt;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardFlowAnalysis;

public class DominatorAnalysis
extends ForwardFlowAnalysis {
    private UnitGraph g;
    private FlowSet allNodes;

    public DominatorAnalysis(UnitGraph g) {
        super(g);
        this.g = g;
        this.initAllNodes();
        this.doAnalysis();
    }

    private void initAllNodes() {
        this.allNodes = new ArraySparseSet();
        Iterator<Unit> it = this.g.iterator();
        while (it.hasNext()) {
            this.allNodes.add(it.next());
        }
    }

    @Override
    protected void merge(Object in1, Object in2, Object out) {
        FlowSet inSet1 = (FlowSet)in1;
        FlowSet inSet2 = (FlowSet)in2;
        FlowSet outSet = (FlowSet)out;
        inSet1.intersection(inSet2, outSet);
    }

    @Override
    protected void copy(Object source, Object dest) {
        FlowSet sourceIn = (FlowSet)source;
        FlowSet destOut = (FlowSet)dest;
        sourceIn.copy(destOut);
    }

    @Override
    protected void flowThrough(Object inValue, Object unit, Object outValue) {
        FlowSet in = (FlowSet)inValue;
        FlowSet out = (FlowSet)outValue;
        Unit s = (Unit)unit;
        if (this.isUnitStartNode(s)) {
            out.clear();
            out.add(s);
        } else {
            FlowSet domsOfPreds = this.allNodes.clone();
            for (Unit pred : this.g.getPredsOf(s)) {
                FlowSet next = (FlowSet)this.unitToAfterFlow.get(pred);
                in.intersection(next, in);
            }
            out.intersection(in, out);
            out.add(s);
        }
    }

    private boolean isUnitStartNode(Unit s) {
        return s.equals(this.g.getHeads().get(0));
    }

    @Override
    protected Object entryInitialFlow() {
        ArraySparseSet fs = new ArraySparseSet();
        List<Unit> heads = this.g.getHeads();
        if (heads.size() != 1) {
            throw new RuntimeException("Expect one start node only.");
        }
        fs.add(heads.get(0));
        return fs;
    }

    @Override
    protected Object newInitialFlow() {
        return this.allNodes.clone();
    }

    public boolean dominates(Stmt s, Stmt t) {
        return ((FlowSet)this.getFlowBefore(t)).contains(s);
    }
}

