/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple;

import java.util.Iterator;
import soot.Local;
import soot.SideEffectTester;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.Constant;
import soot.jimple.Expr;
import soot.jimple.InstanceFieldRef;
import soot.jimple.Stmt;

public class NaiveSideEffectTester
implements SideEffectTester {
    @Override
    public void newMethod(SootMethod m) {
    }

    @Override
    public boolean unitCanReadFrom(Unit u, Value v) {
        Stmt s = (Stmt)u;
        if (v instanceof Constant) {
            return false;
        }
        if (v instanceof Expr) {
            throw new RuntimeException("can't deal with expr");
        }
        if (s.containsInvokeExpr() && !(v instanceof Local)) {
            return true;
        }
        for (Value value : u.getUseBoxes()) {
            if (value.equivTo(v)) {
                return true;
            }
            Iterator vUseIt = v.getUseBoxes().iterator();
            while (vUseIt.hasNext()) {
                if (!value.equivTo(vUseIt.next())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean unitCanWriteTo(Unit u, Value v) {
        Stmt s = (Stmt)u;
        if (v instanceof Constant) {
            return false;
        }
        if (v instanceof Expr) {
            throw new RuntimeException("can't deal with expr");
        }
        if (s.containsInvokeExpr() && !(v instanceof Local)) {
            return true;
        }
        Iterator<ValueBox> defIt = u.getDefBoxes().iterator();
        while (defIt.hasNext()) {
            Value def = defIt.next().getValue();
            Iterator useIt = v.getUseBoxes().iterator();
            while (useIt.hasNext()) {
                Value use = ((ValueBox)useIt.next()).getValue();
                if (!def.equivTo(use)) continue;
                return true;
            }
            if (def.equivTo(v)) {
                return true;
            }
            if (!(v instanceof InstanceFieldRef) || !(def instanceof InstanceFieldRef) || ((InstanceFieldRef)v).getField() != ((InstanceFieldRef)def).getField()) continue;
            return true;
        }
        return false;
    }
}

