/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import soot.Unit;
import soot.UnitBox;
import soot.jimple.Jimple;

public class LocalVariable {
    private String name;
    private int index;
    private UnitBox startUnit;
    private UnitBox endUnit;
    private String descriptor;
    private List<UnitBox> unitBoxes;

    public LocalVariable(String name, int index, Unit startUnit, Unit endUnit, String descriptor) {
        this.index = index;
        this.name = name;
        this.startUnit = Jimple.v().newStmtBox(startUnit);
        this.endUnit = endUnit != null ? Jimple.v().newStmtBox(endUnit) : null;
        this.descriptor = descriptor;
        ArrayList<UnitBox> boxes = new ArrayList<UnitBox>();
        boxes.add(this.startUnit);
        if (this.endUnit != null) {
            boxes.add(this.endUnit);
        }
        this.unitBoxes = Collections.unmodifiableList(boxes);
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public Unit getStartUnit() {
        return this.startUnit.getUnit();
    }

    public Unit getEndUnit() {
        return this.endUnit != null ? this.endUnit.getUnit() : null;
    }

    public List<UnitBox> getUnitBoxes() {
        return this.unitBoxes;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String toString() {
        return "LocalVariable [name=" + this.name + ", index=" + this.index + ", startUnit=" + this.getStartUnit() + ", endUnit=" + this.getEndUnit() + ", descriptor=" + this.descriptor + "]";
    }
}

