/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.llvm;

import org.robovm.llvm.LlvmException;
import org.robovm.llvm.PassManager;
import org.robovm.llvm.binding.LLVM;
import org.robovm.llvm.binding.PassManagerBuilderRef;

public class PassManagerBuilder
implements AutoCloseable {
    protected PassManagerBuilderRef ref = LLVM.PassManagerBuilderCreate();

    public PassManagerBuilder() {
        if (this.ref == null) {
            throw new LlvmException("Failed to create PassManagerBuilder");
        }
    }

    protected final void checkDisposed() {
        if (this.ref == null) {
            throw new LlvmException("Already disposed");
        }
    }

    public synchronized void dispose() {
        this.checkDisposed();
        LLVM.PassManagerBuilderDispose(this.ref);
        this.ref = null;
    }

    @Override
    public void close() {
        this.dispose();
    }

    public void setDisableSimplifyLibCalls(boolean b) {
        this.checkDisposed();
        LLVM.PassManagerBuilderSetDisableSimplifyLibCalls(this.ref, b);
    }

    public void setDisableUnitAtATime(boolean b) {
        this.checkDisposed();
        LLVM.PassManagerBuilderSetDisableUnitAtATime(this.ref, b);
    }

    public void setDisableUnrollLoops(boolean b) {
        this.checkDisposed();
        LLVM.PassManagerBuilderSetDisableUnrollLoops(this.ref, b);
    }

    public void setDisableTailCalls(boolean b) {
        this.checkDisposed();
        LLVM.PassManagerBuilderSetDisableTailCalls(this.ref, b);
    }

    public void setSetOptLevel(int level) {
        this.checkDisposed();
        LLVM.PassManagerBuilderSetOptLevel(this.ref, level);
    }

    public void setSetSizeLevel(int level) {
        this.checkDisposed();
        LLVM.PassManagerBuilderSetSizeLevel(this.ref, level);
    }

    public void useInlinerWithThreshold(int threshold) {
        this.checkDisposed();
        LLVM.PassManagerBuilderUseInlinerWithThreshold(this.ref, threshold);
    }

    public void useAlwaysInliner(boolean insertLifeTime) {
        this.checkDisposed();
        LLVM.PassManagerBuilderUseAlwaysInliner(this.ref, insertLifeTime);
    }

    public void populateFunctionPassManager(PassManager passManager) {
        this.checkDisposed();
        LLVM.PassManagerBuilderPopulateFunctionPassManager(this.ref, passManager.ref);
    }

    public void populateModulePassManager(PassManager passManager) {
        this.checkDisposed();
        LLVM.PassManagerBuilderPopulateModulePassManager(this.ref, passManager.ref);
    }

    public void populateLTOPassManager(PassManager passManager, boolean internalize, boolean runInliner) {
        this.checkDisposed();
        LLVM.PassManagerBuilderPopulateLTOPassManager(this.ref, passManager.ref, internalize, runInliner);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ref == null ? 0 : this.ref.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PassManagerBuilder other = (PassManagerBuilder)obj;
        return !(this.ref == null ? other.ref != null : !this.ref.equals(other.ref));
    }
}

