/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.libimobiledevice;

import com.dd.plist.NSObject;
import java.io.IOException;
import org.robovm.libimobiledevice.IDevice;
import org.robovm.libimobiledevice.LibIMobileDeviceException;
import org.robovm.libimobiledevice.LockdowndServiceDescriptor;
import org.robovm.libimobiledevice.PlistUtil;
import org.robovm.libimobiledevice.binding.LibIMobileDevice;
import org.robovm.libimobiledevice.binding.LockdowndClientRef;
import org.robovm.libimobiledevice.binding.LockdowndClientRefOut;
import org.robovm.libimobiledevice.binding.LockdowndError;
import org.robovm.libimobiledevice.binding.LockdowndServiceDescriptorStruct;
import org.robovm.libimobiledevice.binding.LockdowndServiceDescriptorStructOut;
import org.robovm.libimobiledevice.binding.PlistRef;
import org.robovm.libimobiledevice.binding.PlistRefOut;

public class LockdowndClient
implements AutoCloseable {
    protected LockdowndClientRef ref;
    private IDevice device;

    LockdowndClient(LockdowndClientRef ref) {
        this.ref = ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockdowndClient(IDevice device, String label, boolean handshake2) {
        if (device == null) {
            throw new NullPointerException("device");
        }
        LockdowndClientRefOut refOut = new LockdowndClientRefOut();
        try {
            LockdowndClient.checkResult(handshake2 ? LibIMobileDevice.lockdownd_client_new_with_handshake(device.getRef(), refOut, label) : LibIMobileDevice.lockdownd_client_new(device.getRef(), refOut, label));
            this.ref = refOut.getValue();
            this.device = device;
        }
        finally {
            refOut.delete();
        }
    }

    protected LockdowndClientRef getRef() {
        this.checkDisposed();
        return this.ref;
    }

    public IDevice getDevice() {
        return this.device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockdowndServiceDescriptor startService(String identifier) {
        if (identifier == null) {
            throw new NullPointerException("identifier");
        }
        LockdowndServiceDescriptorStructOut serviceOut = new LockdowndServiceDescriptorStructOut();
        try {
            LockdowndClient.checkResult(LibIMobileDevice.lockdownd_start_service(this.getRef(), identifier, serviceOut));
            LockdowndServiceDescriptor lockdowndServiceDescriptor = new LockdowndServiceDescriptor(serviceOut.getValue());
            return lockdowndServiceDescriptor;
        }
        finally {
            LockdowndServiceDescriptorStruct d = serviceOut.getValue();
            if (d != null) {
                LibIMobileDevice.lockdownd_service_descriptor_free(d);
            }
            serviceOut.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSObject getValue(String domain, String key) throws IOException {
        PlistRefOut plistOut = new PlistRefOut();
        try {
            LockdowndClient.checkResult(LibIMobileDevice.lockdownd_get_value(this.getRef(), domain, key, plistOut));
            PlistRef plist = plistOut.getValue();
            NSObject nSObject = PlistUtil.toJavaPlist(plist);
            return nSObject;
        }
        finally {
            plistOut.delete();
        }
    }

    protected final void checkDisposed() {
        if (this.ref == null) {
            throw new LibIMobileDeviceException("Already disposed");
        }
    }

    public synchronized void dispose() {
        this.checkDisposed();
        LibIMobileDevice.lockdownd_client_free(this.ref);
        this.ref = null;
    }

    @Override
    public void close() {
        this.dispose();
    }

    private static void checkResult(LockdowndError result) {
        if (result != LockdowndError.LOCKDOWN_E_SUCCESS) {
            throw new LibIMobileDeviceException(result.swigValue(), result.name());
        }
    }
}

