/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.gradle.tasks;

import org.robovm.compiler.AppCompiler;
import org.robovm.compiler.config.Arch;
import org.robovm.compiler.config.Config;
import org.robovm.compiler.config.OS;
import org.robovm.compiler.target.LaunchParameters;
import org.robovm.compiler.target.ios.IOSDeviceLaunchParameters;
import org.robovm.gradle.RoboVMGradleException;
import org.robovm.gradle.tasks.AbstractRoboVMTask;

public class IOSDeviceTask
extends AbstractRoboVMTask {
    @Override
    public void invoke() {
        try {
            Arch arch = Arch.arm64;
            if (this.extension.getArch() != null && this.extension.getArch().equals(Arch.thumbv7.toString())) {
                arch = Arch.thumbv7;
            }
            AppCompiler compiler = this.build(OS.ios, arch, "ios");
            if (this.extension.isSkipLaunch()) {
                return;
            }
            Config config = compiler.getConfig();
            IOSDeviceLaunchParameters launchParameters = (IOSDeviceLaunchParameters)config.getTarget().createLaunchParameters();
            String udid = (String)this.project.getProperties().get("robovm.device.udid");
            if (udid != null && !udid.isEmpty()) {
                launchParameters.setDeviceId(udid);
            }
            compiler.launch((LaunchParameters)launchParameters);
        }
        catch (Throwable t) {
            throw new RoboVMGradleException("Failed to launch IOS Device", t);
        }
    }
}

