/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.gradle;

import org.gradle.api.Project;

public class RoboVMPluginExtension {
    public static final String NAME = "robovm";
    private final Project project;
    private String propertiesFile;
    private String configFile;
    private String iosSignIdentity;
    private String iosProvisioningProfile;
    private String iosSimulatorSdk;
    private String stdoutFifo;
    private String stderrFifo;
    private String os;
    private String arch;
    private boolean iosSkipSigning = false;
    private boolean debug = false;
    private int debugPort = -1;
    private boolean skipLaunch = false;
    private boolean skipLinking = false;
    private boolean enableBitcode = false;
    private String archs;
    private String installDir;
    private String cacheDir;
    private String keychainPassword;
    private String keychainPasswordFile;
    private boolean dumpIntermediates = false;

    public RoboVMPluginExtension(Project project) {
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    public String getPropertiesFile() {
        return this.propertiesFile;
    }

    public void setPropertiesFile(String propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public String getIosSignIdentity() {
        return this.project.hasProperty("robovm.iosSignIdentity") ? this.project.getProperties().get("robovm.iosSignIdentity").toString() : this.iosSignIdentity;
    }

    public void setIosSignIdentity(String iosSignIdentity) {
        this.iosSignIdentity = iosSignIdentity;
    }

    public String getIosProvisioningProfile() {
        return this.project.hasProperty("robovm.iosProvisioningProfile") ? this.project.getProperties().get("robovm.iosProvisioningProfile").toString() : this.iosProvisioningProfile;
    }

    public void setIosProvisioningProfile(String iosProvisioningProfile) {
        this.iosProvisioningProfile = iosProvisioningProfile;
    }

    public String getIosSimulatorSdk() {
        return this.project.hasProperty("robovm.iosSimulatorSdk") ? this.project.getProperties().get("robovm.iosSimulatorSdk").toString() : this.iosSimulatorSdk;
    }

    public void setIosSimulatorSdk(String iosSimulatorSdk) {
        this.iosSimulatorSdk = iosSimulatorSdk;
    }

    public String getStdoutFifo() {
        return this.stdoutFifo;
    }

    public void setStdoutFifo(String stdoutFifo) {
        this.stdoutFifo = stdoutFifo;
    }

    public String getStderrFifo() {
        return this.stderrFifo;
    }

    public void setStderrFifo(String stderrFifo) {
        this.stderrFifo = stderrFifo;
    }

    public boolean isIosSkipSigning() {
        return this.project.hasProperty("robovm.iosSkipSigning") ? Boolean.parseBoolean(this.project.getProperties().get("robovm.iosSkipSigning").toString()) : this.iosSkipSigning;
    }

    public void setIosSkipSigning(boolean iosSkipSigning) {
        this.iosSkipSigning = iosSkipSigning;
    }

    public String getOs() {
        return this.project.hasProperty("robovm.os") ? this.project.getProperties().get("robovm.os").toString() : this.os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public String getArch() {
        return this.project.hasProperty("robovm.arch") ? this.project.getProperties().get("robovm.arch").toString() : this.arch;
    }

    public void setArch(String arch) {
        this.arch = arch;
    }

    public boolean isDebug() {
        return this.project.hasProperty("robovm.debug") ? Boolean.parseBoolean(this.project.getProperties().get("robovm.debug").toString()) : this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isSkipLaunch() {
        return this.project.hasProperty("robovm.skipLaunch") ? Boolean.parseBoolean(this.project.getProperties().get("robovm.skipLaunch").toString()) : this.skipLaunch;
    }

    public void setSkipLaunch(boolean skipLaunch) {
        this.skipLaunch = skipLaunch;
    }

    public boolean isSkipLinking() {
        return this.project.hasProperty("robovm.skipLinking") ? Boolean.parseBoolean(this.project.getProperties().get("robovm.skipLinking").toString()) : this.skipLinking;
    }

    public void setSkipLinking(boolean skipLinking) {
        this.skipLinking = skipLinking;
    }

    public boolean isEnableBitcode() {
        return this.project.hasProperty("robovm.enableBitcode") ? Boolean.parseBoolean(this.project.getProperties().get("robovm.enableBitcode").toString()) : this.enableBitcode;
    }

    public void setEnableBitcode(boolean enableBitcode) {
        this.enableBitcode = enableBitcode;
    }

    public int getDebugPort() {
        return this.project.hasProperty("robovm.debugPort") ? Integer.parseInt(this.project.getProperties().get("robovm.debugPort").toString()) : this.debugPort;
    }

    public void setDebugPort(int debugPort) {
        this.debugPort = debugPort;
    }

    public String getArchs() {
        if (this.project.hasProperty("robovm.ipaArchs")) {
            return this.project.getProperties().get("robovm.ipaArchs").toString();
        }
        if (this.project.hasProperty("robovm.archs")) {
            return this.project.getProperties().get("robovm.archs").toString();
        }
        return this.archs;
    }

    public void setArchs(String ipaArchs) {
        this.archs = ipaArchs;
    }

    public String getInstallDir() {
        return this.project.hasProperty("robovm.installDir") ? this.project.getProperties().get("robovm.installDir").toString() : this.installDir;
    }

    public void setInstallDir(String installDir) {
        this.installDir = installDir;
    }

    public void setCachedir(String cacheDir) {
        this.cacheDir = cacheDir;
    }

    public String getCacheDir() {
        return this.project.hasProperty("robovm.cacheDir") ? this.project.getProperties().get("robovm.cacheDir").toString() : null;
    }

    public String getKeychainPassword() {
        return this.project.hasProperty("robovm.keychainPassword") ? this.project.getProperties().get("robovm.keychainPassword").toString() : this.keychainPassword;
    }

    public void setKeychainPassword(String keychainPassword) {
        this.keychainPassword = keychainPassword;
    }

    public String getKeychainPasswordFile() {
        return this.project.hasProperty("robovm.keychainPasswordFile") ? this.project.getProperties().get("robovm.keychainPasswordFile").toString() : this.keychainPasswordFile;
    }

    public void setKeychainPasswordFile(String keychainPasswordFile) {
        this.keychainPasswordFile = keychainPasswordFile;
    }

    public boolean isDumpIntermediates() {
        return this.dumpIntermediates;
    }

    public void setDumpIntermediates(boolean dumpIntermediates) {
        this.dumpIntermediates = dumpIntermediates;
    }
}

