/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.utils.macho.tools;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;

public final class RegionSquasher {
    public static <T> void squash(List<T> items, BiPredicate<T, T> isSequence, BiConsumer<T, T> squash) {
        Object first = null;
        Object last = null;
        for (T s : items) {
            if (last != null) {
                if (isSequence.test(last, s)) {
                    last = s;
                    continue;
                }
                squash.accept(first, last);
                T t = s;
                last = t;
                first = t;
                continue;
            }
            T t = s;
            last = t;
            first = t;
        }
        if (first != null) {
            squash.accept(first, last);
        }
    }
}

