/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.utils.bytebuffer;

import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import org.robovm.debugger.utils.bytebuffer.DataBuffer;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;

public interface DataBufferWriter
extends DataBuffer {
    public void wants(int var1);

    public DataBufferWriter writeByte(byte var1);

    default public DataBufferWriter writeBoolean(boolean b) {
        return this.writeByte((byte)(b ? 1 : 0));
    }

    public DataBufferWriter writeInt32(int var1);

    default public DataBufferWriter writeUnsignedInt32(long l) {
        int i = (int)(l & 0xFFFFFFFFL);
        return this.writeInt32(i);
    }

    public DataBufferWriter writeInt16(short var1);

    default public DataBufferWriter writeUnsignedInt16(int i) {
        short s = (short)(i & 0xFFFF);
        return this.writeInt16(s);
    }

    default public DataBufferWriter writeChar16(char c) {
        return this.writeUnsignedInt16(c);
    }

    public DataBufferWriter writeLong(long var1);

    public DataBufferWriter writeFloat(float var1);

    public DataBufferWriter writeDouble(double var1);

    default public DataBufferWriter writeStringWithLen(String s) {
        byte[] bytes = s.getBytes();
        this.wants(bytes.length + 4);
        this.writeInt32(bytes.length);
        return this.writeBytes(bytes);
    }

    public DataBufferWriter writeBytes(byte[] var1, int var2, int var3);

    default public DataBufferWriter writeBytes(byte[] bytes) {
        return this.writeBytes(bytes, 0, bytes.length);
    }

    default public DataBufferWriter writePointer(long addr) {
        if (this.is64bit()) {
            return this.writeLong(addr);
        }
        return this.writeUnsignedInt32(addr);
    }

    default public DataBufferWriter writeFromStream(InputStream is) throws IOException {
        return this.writeFromStream(is, is.available());
    }

    default public DataBufferWriter writeFromStream(InputStream is, int count) throws IOException {
        this.wants(count);
        if (this.hasArray()) {
            int bytesRead;
            int offset = this.arrayPositionOffset();
            for (int remaining = count; remaining > 0; remaining -= bytesRead) {
                bytesRead = is.read(this.array(), offset, remaining);
                if (bytesRead < 0) {
                    throw new BufferUnderflowException();
                }
                offset += bytesRead;
            }
            this.setPosition(this.position() + (long)count);
        } else {
            byte[] buffer = new byte[Math.min(1024, count)];
            while (count > 0) {
                int bytesRead = Math.min(count, buffer.length);
                if ((bytesRead = is.read(buffer, 0, bytesRead)) < 0) {
                    throw new BufferUnderflowException();
                }
                this.writeBytes(buffer, 0, bytesRead);
                count -= bytesRead;
            }
        }
        return this;
    }

    default public DataBufferWriter writeFromReader(DataBufferReader reader) {
        int remaining;
        this.wants(reader.remaining());
        if (reader.hasArray()) {
            this.writeBytes(reader.array(), reader.arrayPositionOffset(), reader.remaining());
            reader.skip(remaining);
        } else {
            int bytesRead;
            byte[] buffer = new byte[Math.min(1024, remaining)];
            for (remaining = reader.remaining(); remaining > 0; remaining -= bytesRead) {
                bytesRead = Math.min(remaining, buffer.length);
                reader.readBytes(buffer, 0, bytesRead);
                this.writeBytes(buffer, 0, bytesRead);
            }
        }
        return this;
    }

    @Override
    public DataBufferWriter setPosition(long var1);

    public DataBufferWriter sliceAt(long var1, int var3, long var4, boolean var6);

    default public DataBufferWriter sliceAt(long pos, int size, boolean as64bit) {
        return this.sliceAt(pos, size, 0L, as64bit);
    }

    default public DataBufferWriter sliceAt(long pos, int size) {
        return this.sliceAt(pos, size, this.is64bit());
    }

    default public DataBufferWriter slice(int size) {
        return this.sliceAt(this.position(), size);
    }

    default public DataBufferWriter slice() {
        return this.sliceAt(this.position(), this.remaining());
    }
}

