/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.utils.bytebuffer;

import java.util.Iterator;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;

public class DataBufferArrayReader<T>
implements Iterable<T> {
    private final DataBufferReader bufferReader;
    private final int elementSize;
    private final ObjectReader<T> objectReader;
    private final int count;
    private final boolean reuseElement;
    private T lastAccessedObject;

    public DataBufferArrayReader(DataBufferReader bufferReader, int elementSize, ObjectReader<T> objectReader, boolean reuseElement) {
        this.bufferReader = bufferReader;
        this.elementSize = elementSize;
        this.objectReader = objectReader;
        this.count = bufferReader.size() / elementSize;
        this.reuseElement = reuseElement;
    }

    public DataBufferArrayReader(DataBufferReader bufferReader, int elementSize, ObjectReader<T> objectReader) {
        this(bufferReader, elementSize, objectReader, true);
    }

    public T get(int index) {
        if (index >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        this.bufferReader.setPosition(this.elementSize * index);
        this.lastAccessedObject = this.objectReader.readObject(this.bufferReader, this.reuseElement ? (Object)this.lastAccessedObject : null);
        if (this.bufferReader.position() - (long)(this.elementSize * index) != (long)this.elementSize) {
            throw new IllegalStateException("Object size specified doesn't match actual read from reader");
        }
        return this.lastAccessedObject;
    }

    public int count() {
        return this.count;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < DataBufferArrayReader.this.count;
            }

            @Override
            public T next() {
                return DataBufferArrayReader.this.get(this.idx++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static interface ObjectReader<T> {
        public T readObject(DataBufferReader var1, T var2);
    }
}

