/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.state;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.robovm.debugger.DebuggerConfig;
import org.robovm.debugger.DebuggerException;
import org.robovm.debugger.state.classdata.ClassInfo;
import org.robovm.debugger.state.classdata.ClassInfoLoader;
import org.robovm.debugger.state.classdata.FieldInfo;
import org.robovm.debugger.state.classdata.MethodInfo;
import org.robovm.debugger.state.instances.VmStackTrace;
import org.robovm.debugger.state.instances.VmThread;
import org.robovm.debugger.state.refid.InstanceRefIdHolder;
import org.robovm.debugger.state.refid.RefIdHolder;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;
import org.robovm.debugger.utils.macho.MachOException;
import org.robovm.debugger.utils.macho.MachOLoader;

public class VmDebuggerState {
    private final String LOCK_NOT_ACQUIRED = "Lock has to be acquired before accessing state members";
    RefIdHolder<ClassInfo> classRefIdHolder = new RefIdHolder(RefIdHolder.RefIdType.CLASS_TYPE);
    RefIdHolder<MethodInfo> methodsRefIdHolder = new RefIdHolder(RefIdHolder.RefIdType.METHOD_TYPE);
    RefIdHolder<FieldInfo> fieldRefIdHolder = new RefIdHolder(RefIdHolder.RefIdType.FIELD_TYPE);
    InstanceRefIdHolder referenceRefIdHolder = new InstanceRefIdHolder();
    RefIdHolder<VmStackTrace> frameRefIdHolder = new RefIdHolder(RefIdHolder.RefIdType.FRAME_TYPE);
    List<VmThread> threads = new ArrayList<VmThread>();
    MachOLoader appFileLoader;
    DataBufferReader appFileDataMemoryReader;
    ClassInfoLoader classInfoLoader;
    boolean isTarget64bit;
    Object centralLock = new Object();

    public VmDebuggerState(File appFile, DebuggerConfig.Arch arch) {
        try {
            this.appFileLoader = new MachOLoader(appFile, arch.getMachoValue());
            this.appFileDataMemoryReader = this.appFileLoader.memoryReader();
            this.classInfoLoader = new ClassInfoLoader(this.classRefIdHolder, this.methodsRefIdHolder, this.fieldRefIdHolder, this.appFileLoader, this.appFileDataMemoryReader);
            this.isTarget64bit = this.appFileLoader.isPatform64Bit();
        }
        catch (MachOException e) {
            throw new DebuggerException(e);
        }
    }

    public RefIdHolder<ClassInfo> classRefIdHolder() {
        return this.classRefIdHolder;
    }

    public RefIdHolder<MethodInfo> methodsRefIdHolder() {
        return this.methodsRefIdHolder;
    }

    public RefIdHolder<FieldInfo> fieldRefIdHolder() {
        return this.fieldRefIdHolder;
    }

    public InstanceRefIdHolder referenceRefIdHolder() {
        return this.referenceRefIdHolder;
    }

    public RefIdHolder<VmStackTrace> frameRefIdHolder() {
        return this.frameRefIdHolder;
    }

    public MachOLoader appFileLoader() {
        return this.appFileLoader;
    }

    public DataBufferReader appFileDataMemoryReader() {
        return this.appFileDataMemoryReader;
    }

    public ClassInfoLoader classInfoLoader() {
        if (!Thread.holdsLock(this.centralLock)) {
            throw new DebuggerException("Lock has to be acquired before accessing state members");
        }
        return this.classInfoLoader;
    }

    public boolean isTarget64bit() {
        return this.isTarget64bit;
    }

    public List<VmThread> threads() {
        if (!Thread.holdsLock(this.centralLock)) {
            throw new DebuggerException("Lock has to be acquired before accessing state members");
        }
        return this.threads;
    }

    public Object centralLock() {
        return this.centralLock;
    }
}

