/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.thread;

import org.robovm.debugger.DebuggerException;
import org.robovm.debugger.jdwp.handlers.thread.IJdwpThreadDelegate;
import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;
import org.robovm.debugger.utils.bytebuffer.DataBufferWriter;

public class JdwpThreadResumeHandler
implements IJdwpRequestHandler {
    private final IJdwpThreadDelegate delegate;

    public JdwpThreadResumeHandler(IJdwpThreadDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public short handle(DataBufferReader payload, DataBufferWriter output) {
        long threadId = payload.readLong();
        try {
            this.delegate.jdwpResumeThread(threadId);
        }
        catch (ClassCastException e) {
            return 20;
        }
        catch (DebuggerException e) {
            if (e.getCode() < 0) {
                throw e;
            }
            return (short)e.getCode();
        }
        return 0;
    }

    @Override
    public byte getCommandSet() {
        return 11;
    }

    @Override
    public byte getCommand() {
        return 3;
    }

    public String toString() {
        return "ThreadReference(11).Resume(3)";
    }
}

