/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.debugger.jdwp.handlers.string;

import org.robovm.debugger.DebuggerException;
import org.robovm.debugger.jdwp.handlers.objectreference.IJdwpInstanceDelegate;
import org.robovm.debugger.jdwp.protocol.IJdwpRequestHandler;
import org.robovm.debugger.utils.bytebuffer.DataBufferReader;
import org.robovm.debugger.utils.bytebuffer.DataBufferWriter;

public class JdwpStringGetValueHandler
implements IJdwpRequestHandler {
    private final IJdwpInstanceDelegate delegate;

    public JdwpStringGetValueHandler(IJdwpInstanceDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public short handle(DataBufferReader payload, DataBufferWriter output) {
        long refId = payload.readLong();
        try {
            String stringValue = this.delegate.jdwpGetStringValue(refId);
            output.writeStringWithLen(stringValue);
        }
        catch (DebuggerException e) {
            if (e.getCode() < 0) {
                throw e;
            }
            return (short)e.getCode();
        }
        return 0;
    }

    @Override
    public byte getCommandSet() {
        return 10;
    }

    @Override
    public byte getCommand() {
        return 1;
    }

    public String toString() {
        return "StringReference(10).Value(1)";
    }
}

